if (! document.localization) document.localization = [];		
		
document.localization ['zh_TW'] = {
    'login.username' : "用戶名或電子郵件",
    'login.username.placeholder':"輸入您的用戶名或電子郵件",
    'login.password' : "密碼",
    'login.password.placeholder' : "輸入密碼",
    'login.submit' : "登錄",
    'login.password.incorrect':"無效的用戶名或密碼",
    'login.password.recovery': '忘記密碼？',
    'recovery.password': '恢復密碼',
    'recovery.password.success': '密碼恢復說明已發送至您的郵箱',
    'login.no.account': '沒有帳戶？',
    'login.signup': '報名',

    'signup.title': '開始吧',
    'signup.email': '你的郵箱',
    'signup.email.placeholder': '請輸入有效的電子郵件地址',
    'signup.email.invalid': '請輸入有效的電子郵件地址',
    'signup.terms.agree': '我同意',
    'signup.terms.terms': '條款和條件',
    'signup.submit': '註冊',
    'signup.progress': '正在註冊...',
    'signup.email.used': '使用此電子郵件的客戶已經註冊',
    'signup.name.used': '使用此用戶名的客戶已經註冊',
    'signup.complete': '感謝您的註冊！',
    'signup.email.check': '請檢查您的郵箱並點擊鏈接完成註冊！',
    'signup.complete.title': '您在 ${appName} 的帳戶即將準備就緒！',
    'signup.ready.title': '您在 ${appName} 的帳戶已準備就緒！',
    'signup.customer.id': '用戶名',
    'signup.customer.id.placeholder': '只能使用字母和數字',
    'signup.customer.id.invalid': '請使用 6 個或更多字符，僅限字母和數字',
    'signup.first.name': '名字',
    'signup.first.name.placeholder': '你的名字（必填）',
    'signup.last.name': '姓氏',
    'signup.last.name.placeholder': '你的姓氏（必填）',
    'signup.company': '公司名稱',
    'signup.company.placeholder': '您的公司名稱（可選）',
    'signup.description': '你將如何使用 MDM？',
    'signup.description.placeholder': '這將有助於我們的團隊協助您',
    'signup.password': '密碼',
    'signup.password.repeat': '重複密碼',
    'signup.password.placeholder': '6+ characters',
    'signup.password.short': '請輸入至少6個字符',
    'signup.password.not.match': '密碼不匹配',
    'signup.finalized.title': '您的帳戶已準備就緒！',
    'signup.finalized.description': '在短時間內，您一定會收到包含有用說明的電子郵件。 請查看此電子郵件並使用您的用戶名和密碼登錄網絡面板。',
    'signup.token.invalid.title': '令牌無效或已被使用',
    'signup.token.invalid.description': '請重試註冊以創建新帳戶！',

    'header.label.username' : "用戶名",

    'summary.devices.status': '裝置狀態',
    'summary.devices.active': '活動',
    'summary.devices.idle': '空閒',
    'summary.devices.offline': '離線',
    'summary.devices.enrollment': '註冊摘要',
    'summary.devices.enrolled.total': '註冊總數',
    'summary.devices.enrolled.earlier': '較早註冊',
    'summary.devices.enrolled.monthly': '過去 30 天',
    'summary.devices.installation.status': '應用程式狀態',
    'summary.devices.installation.completed': '完成',
    'summary.devices.version.mismatch': '版本錯誤',
    'summary.devices.installation.failed': '安裝失敗',
    'summary.devices.enrolled.lastyear': '過去 12 個月',

    'devices.group.options.all':"所有組合",
    'devices.configuration.options.all':"所有配置",
    'devices.permissions.all':"授予所有權限",
    'devices.permissions.not.as.device.admin' : "-該應用程式未以設備管理員身份安裝",
    'devices.permissions.window.overlap.prohibited' : "-其他窗口上方的疊加層不可用",
    'devices.permissions.history.access.prohibited' : "-未配置對使用歷史記錄的訪問",
    'devices.unknown' : "未知",
    'devices.model.unknown' : "未知",
    'devices.date.unknown' : "未知",
    'devices.date.format' : "dd/MM/yy HH:mm",
    'devices.app.installed' : "- ${applicationName}: 未安裝.",
    'devices.app.not.installed' : "- ${applicationName}: 未安裝.",
    'devices.app.version.available' : ",可用${applicationVersion}",
    'devices.app.installed.and.version.available' : "- ${applicationName}: 安裝 ${applicationInstalledVersion}, 可用 ${applicationVersionAvailable}",
    'devices.app.needs.removal':"${applicationVersion}，需要刪除",
    'devices.no.data':"設備尚未傳輸數據",
    'devices.settings.conformance.broken' : "與設置不匹配: (${serverData})",
    'devices.file.installed' : "- ${file}: 已安裝",
    'devices.file.not.installed' : "- ${file} 未安裝.",
    'devices.file.lastUpdate.differs' : "- ${file}: 修改時間差 ${diff} 分鐘",
		
    'button.apply' : "套用",
    'button.gps.on':"啟用GPS",
    'button.wifi.on':"啟用Wi-Fi",
    'button.notify.update':"更新通知",
    'button.app.settings' : "應用程式設置",
    'button.ok' : "OK",
    'button.help' : "查詢",
    'button.new.app':"新增應用程式",
    'button.new.app.version' : "新版本",
    'button.upgrade' : "升級",
    'button.renew.config':"設備更新",
    'button.common':"通用應用程式",
    'button.close' : "關閉",
    'button.yes' : "是",
    'button.cancel' : "取消",
    'button.save' : "存儲",
    'button.save.and.close' : "儲存並關閉",
    'button.more' : "更多 ...",
    'button.cleanup' : "明確",
    'button.add' : "新增",
    'button.add.icon':"新圖示",
    'button.search' : "搜索",
    'button.export' : "出口",
    'button.change' : "編輯",
    'button.copy' : "複製",
    'button.qrcode' : "二維碼",
    'button.application' : "應用程式",
    'button.change.password' : "更改密碼",
    'button.set.configuration':"設置配置",
    'button.set.group': '設置一個組',
    'button.group.action': '集體行動',
    'button.delete' : "刪除",
    'button.login' : "登錄",
    'button.renew.code' : "更新",
    'button.configurations':"配置",
    'button.set.configurations':"指定配置",
    'button.edit.versions':"版本",
    'button.edit' : "編輯",
    'button.change.common.app':"編輯共享應用程式",
    'button.delete.common.app':"刪除共享應用程式",
    'button.turn.common.app':"共同",
    'button.hints.enable':"顯示工具提示",
    'button.hints.disable':"隱藏工具提示",
    'button.show.password' : "顯示密碼",
    'button.hide.password':"隱藏密碼",
		
    'question.impersonate.user':"以組織\"${customerName}\"的管理員身份登錄到應用程式嗎？",
    'question.change.user': '以用戶\"${userName}\"的身份登錄應用程序？',
    'question.delete.file' : "要刪除文檔\"${fileName}\"嗎？",
    'question.delete.customer':"刪除組織\"${customerName}\"？",
    'question.delete.user':"刪除用戶\"${username}\"？",
    'question.delete.application' : "是否刪除應用程式\"${applicationName}\"？",
    'question.delete.application.version':"刪除版本\"${applicationVersion}\"？",
    'question.delete.configuration' : "刪除配置\"${configurationName}\"？",
    'question.delete.group':"刪除組合\"${groupName}\"？",
    'question.delete.role': '刪除角色“${roleName}”？',
    'question.delete.icon': '刪除圖示「${iconName}」？',
    'question.delete.device.bulk': '刪除所選設備？',
    'question.delete.device' : "刪除數字為\"${deviceNumber}\"的設備嗎？",
    'question.exit.without.saving' : "更改未儲存。無論如何要離開此頁面？",
    'question.turn2common.application':"共享應用程式\"${applicationName}\"嗎？",
    'question.app.upgrade':"將應用程式\"${v1}\"更新到配置\"${v2}\"的最新版本嗎？",
		
    'error.application.setting.empty.app':"指定應用程式",
    'error.application.setting.empty.name':"輸入名稱",
    'error.application.setting.empty.value':"指定值",
		
    'error.icon.dimension.invalid':"圖示必須是正方形的",
    'error.icon.empty.name':"輸入圖示名稱",
    'error.icon.empty.file':"上傳圖示文檔",
    'error.application.version.pkg.mismatch':"文檔（${actual}）的程序包ID與應用程式（${expected}）不對應",
    'error.empty.user':"選擇用戶",
    'error.empty.user.name':"填寫用戶名",
    'error.empty.user.login':"填寫用戶登錄名",
    'error.empty.user.role':"選擇用戶角色",
    'error.empty.password' : "輸入新密碼",
    'error.empty.password.confirm':"輸入密碼確認",
    'error.user.not.found': '未找到用戶',
    'error.email.not.configured': '電子郵件未配置',
    'error.email.not.found': '用戶郵箱未設置',
    'error.empty.group.name':"填寫組合名",
    'error.empty.configuration':"指定配置",
    'error.empty.configuration.name':"填寫配置名稱",
    'error.empty.configuration.password':"填寫密碼",
    'error.empty.configuration.contentApp':"未指定內容應用程式",
    'error.empty.group': '將設備添加到一個或多個組',
    'error.invalid.character': '設備編號不能包含符號 / ? &',
    'error.invalid.configuration.mainApp':"在MDM設置中，使用了錯誤的主應用程式",
    'error.invalid.configuration.contentApp':"在MDM設置中使用了無效的內容應用程式",
    'error.mismatch.password':"密碼和密碼確認必須匹配",
    'error.empty.customer.name':"以組織的名義填寫",
    'error.empty.customer.prefix':"填寫設備編號前綴",
    'error.empty.customer.device.configuration':"選擇設備配置",
    'error.empty.customer.duplicate.prefix':"前綴已在使用中",
    'error.duplicate.customer.name' : "輸入名稱的組織已經存在。嘗試使用其他名稱。",
    'error.duplicate.group.name' : "輸入名稱的組合已經存在。嘗試使用其他名稱。",
    'error.duplicate.configuration.name' : "使用輸入名稱的配置已存在。嘗試使用其他名稱。",
    'error.duplicate.device.number':"已經存在具有該編號的設備",
    'error.internal.server' : "內部服務器錯誤",
    'error.permission.denied':"沒有執行權",
    'error.request.failure':"請求失敗",
    'error.configuration.device.use' : "無法刪除此配置，它在設備上使用。首先轉到\"設備\",使用此配置查找設備並更改其設置。",
    'error.invalid.system.update.time':"無效的安裝間隔",
    'error.size.limit.exceeded': '超出存儲限制',

    'error.configuration.file.empty.name':"輸入文檔名",
    'error.configuration.file.empty.desc':"指定文檔資訊",
    'error.configuration.file.empty.path':"指定設備上的路徑",
    'error.configuration.file.empty.file': '請上傳檔案',
    'error.configuration.file.empty.url': '請指定檔案 URL',

    'error.notfound.device' : "找不到設備",
    'error.duplicate.device':"已經存在具有相同編號的設備",
    'error.duplicate.login':"此類登錄名已被使用",
    'error.duplicate.email': '使用此電子郵件的用戶已存在',
    'error.duplicate.group':"已經存在相同名稱的組合",
    'error.duplicate.application':"已經存在具有此程序包ID和版本的應用程式",
    'error.recent.application.version.exists':"存在較新的應用程式版本",
    'error.common.application.access.prohibited':"只有超級管理員才能管理常見應用程式",
    'error.application.config.reference.exists':"該應用程式已在配置中使用，無法刪除",
    'error.application.version.deletion.prohibited':"該版本是唯一的或已在配置中使用，無法刪除",
    'error.duplicate.file':"已經存在同名文檔",
    'error.used.file':"已使用此文檔",
    'error.version.exists':"此應用程式的相同版本已存在",
    'error.duplicate.configuration':"具有該名稱的配置已存在",
    'error.duplicate.role.name': '已存在同名角色',
    'error.empty.role.name': '請註明角色名稱',
    'error.duplicate.icon.name': '同名圖示已存在',
    'error.notfound.customer.admin':"找不到管理員帳戶",
    'error.apk.file.required':"選擇擴展名為.apk或.xapk的文檔",
    'error.apk.parse':"解析文檔時發生錯誤",
    'error.package.not.match': '包 ID 不匹配',
    'error.empty.app.name':"輸入應用程式名稱",
    'error.empty.app.pkg':"輸入包裹ID",
    'error.empty.app.url':"輸入網址",
    'error.empty.app.iconText':"輸入圖示文字",
    'error.empty.app.version':"輸入應用程式的版本",
    'error.notempty.group' : "該組合包括一個或多個設備。您無法刪除它。",
    'error.file.empty':"上傳新文檔",
    'error.file.deletion':"刪除服務器上的文檔時出錯",
    'error.file.save':"在服務器上儲存文檔時出錯",
    'error.password.wrong' : "無效的密碼",
    'error.password.empty':"未指定密碼",
    'error.password.weak': '密碼質量弱',
    'error.params.missing' : "缺少參數",
    'error.empty.push.options':"請選擇推送通知選項",
    'error.app.name.exists': '另一個同名的應用程序已存在。 請指定一個唯一的名稱。',

    'table.filtering.check.all' : "全選",
    'table.filtering.uncheck.all':"取消全部",
    'table.filtering.suffix.configuration':"配置",
    'table.filtering.suffix.group':"組合",
    'table.filtering.suffix.permission': '權限',
    'table.filtering.no.selected.configuration':"未選擇配置",
    'table.filtering.no.selected.group':"未選擇組合",
    'table.filtering.no.selected.permission': '未選擇權限',

    'success.admin.created' : "管理員帳戶已創建:\n ${adminCredentials}",
    'success.uploading.file':"文檔已上傳到服務器...",
    'success.loading.devices':"正在加載設備列表...",
    'success.loading.customer':"正在加載客戶詳細信息...",
    'success.file.uploaded' : "文檔上傳成功。",
    'success.file.uploaded.need.save' : "文檔上傳成功。輸入相對路徑，然後單擊\"儲存\"。",
    'success.settings.design.saved':"設計設置已成功儲存",
    'success.settings.common.saved':"設備表設置已成功儲存",
    'success.settings.saved':"設置已成功儲存",
    'success.settings.apiKey.saved':"API密鑰已成功儲存",
    'success.settings.hints.enabled':"啟用提示",
    'success.settings.hints.disabled':"提示已禁用",
    'success.configuration.saved':"配置儲存成功",
    'success.operation.completed':"操作成功完成",
    'success.plugins.disabled':"設置已成功儲存",
    'success.config.update.notification':"配置更新命令已發送到設備",
    'success.config.update.device.app.settings.notification':"更新應用程式設置的命令已發送到設備。",
		
    'form.icon.title' : "圖示",
    'form.icon.name' : "名稱",
    'form.icon.file' : "文檔",

    'configuration.add.warning': '您確定要創建一個空配置嗎？ 您將需要手動添加所有必需的系統應用程序。 考慮改為複制和修改現有配置。',
    'configuration.remove.warning': '您確定要刪除最後的配置嗎？ 您將丟失需要哪些系統應用程序的信息。',
    'form.configuration.title' : "配置",
    'form.configuration.title.typical':"典型配置",
    'form.configuration.settings.auto.update' : "自動更新",
    'form.configuration.settings.system.update' : "系統更新",
    'form.configuration.settings.system.update.default' : "默認",
    'form.configuration.settings.system.update.immediate' : "立即",
    'form.configuration.settings.system.update.scheduled':"預定",
    'form.configuration.settings.system.update.postponed':"推遲",
    'form.configuration.settings.system.update.time':"安裝時間",
    'form.configuration.settings.system.update.time.from' : "由",
    'form.configuration.settings.system.update.time.to' : "至",
    'form.configuration.settings.system.schedule.app.update': '安排應用安裝',
    'form.configuration.settings.system.app.update.time': '應用更新時間',
    'form.configuration.settings.download.updates': '下載內容',
    'form.configuration.settings.download.updates.unlimited': '無限制',
    'form.configuration.settings.download.updates.limited': '在行動網路中嘗試 3 次',
    'form.configuration.settings.download.updates.wifi': '僅透過 WiFi',
    'form.configuration.settings.block.status.bar':"狀態欄鎖定",
    'form.configuration.settings.block.status.bar.hint': '此設置已棄用，適用於 Android 6 及更低版本。 要在較新的 Android 版本上鎖定狀態欄，請使用信息亭模式（MDM 設置）。',
    'form.configuration.settings.mdm.kiosk.mode':"單一應用程序模式",
    'form.configuration.settings.mdm.app.main':"MDM 應用程序",
    'form.configuration.settings.mdm.component.event.receiver':"管理員接收類",
    'form.configuration.settings.mdm.component.event.receiver.placeholder':"應該是 com.hmdm.launcher.AdminReceiver",
    'form.configuration.settings.mdm.component.wifi.ssid':"WiFi SSID",
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder':"註冊WiFi SSID-留空以手動輸入",
    'form.configuration.settings.mdm.component.wifi.password':"WiFi密碼",
    'form.configuration.settings.mdm.component.wifi.password.placeholder':"註冊WiFi通行證-留空以手動輸入",
    'form.configuration.settings.mdm.component.wifi.security':"WiFi安全類型",
    'form.configuration.settings.mdm.component.wifi.notice' : "注意這些WiFi設置僅適用於初始註冊！",
    'form.configuration.settings.mdm.component.server.url':"新服務器網址",
    'form.configuration.settings.mdm.component.server.url.placeholder':"用於遷移到新的MDM服務器",
    'form.configuration.settings.mdm.app.content':"應用程式內容",
    'form.configuration.settings.mdm.kiosk.home':"啟用主頁按鈕",
    'form.configuration.settings.mdm.kiosk.recents':"啟用最近的按鈕",
    'form.configuration.settings.mdm.kiosk.notifications':"啟用通知",
    'form.configuration.settings.mdm.kiosk.system.info':"啟用狀態欄信息",
    'form.configuration.settings.mdm.kiosk.keyguard':"啟用屏幕鎖定",
    'form.configuration.settings.mdm.kiosk.lock.buttons': '鎖定電源按鈕',
    'form.configuration.settings.mdm.mobile.enrollment': '使用移動數據註冊',
    'form.configuration.settings.mdm.encrypt.device': '裝置儲存加密',
    'form.configuration.settings.mdm.lock.safe.settings':"鎖定安全設置（WiFi，GPS等）",
    'form.configuration.settings.mdm.permissive': '寬容（解鎖）模式',
    'form.configuration.settings.mdm.kiosk.exit': '自助服務亭退出按鈕',
    'form.configuration.settings.mdm.kiosk.screen': '螢幕常亮',
    'form.configuration.settings.mdm.allowed.classesEncrypt the device storage':"允許的活動",
    'form.configuration.settings.mdm.allowed.classes.placeholder' : "以逗號分隔的類，例如: com.android.settings.homepage.SettingsHomepageActivity",
    'form.configuration.settings.mdm.restrictions': '限制條件',
    'form.configuration.settings.mdm.restrictions.placeholder': 'MDM限制，以逗號分隔，例如： no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.launcher': '覆寫啟動器 URL',
    'form.configuration.settings.mdm.launcher.placeholder': '用於在封閉網路中註冊的備用啟動器 URL',
    'form.configuration.settings.mdm.misc': '其他二維碼入口',
    'form.configuration.settings.mdm.misc.placeholder': '逗號分隔的條目，例如：\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url':"QR代碼網址",
    'form.configuration.settings.mdm.hint':"選擇主要應用程式和組件",
    'form.configuration.apps.search.label' : "搜索",
    'form.configuration.apps.sort.label' : "分類",
    'form.configuration.apps.sort.byname' : "按名字",
    'form.configuration.apps.sort.bypkg':"按ID",
    'form.configuration.apps.no.apk': '沒有任何',
    'form.configuration.apps.show.systeam.apps':"顯示系統應用程式",
    'form.configuration.apps.action.select': '(選擇)',
    'form.configuration.apps.action.install' : "安裝",
    'form.configuration.apps.action.prohibit' : "塊",
    'form.configuration.apps.action.not.install':"請勿安裝",
    'form.configuration.apps.action.delete' : "刪除",
    'form.configuration.apps.action.permit' : "允許",
    'form.configuration.apps.label.inherit' : "遺傳",
    'form.configuration.apps.label.show' : "節目",
    'form.configuration.apps.label.not.show' : "隱藏",
    'form.configuration.apps.edit.details':"其他參數",
    'form.configuration.apps.keycode' : "按鈕代碼",
    'form.configuration.apps.bottom': '顯示在底行',
    'form.configuration.apps.long.tap': '長按設置',
    'form.configuration.apps.hint' : "提示:要斷開應用程式與配置的鏈接，請選擇操作“阻止\"或“不安裝\"。",
    'form.configuration.settings.design.use.default':"使用默認設計",
    'form.configuration.settings.design.color.background' : "背景顏色",
    'form.configuration.settings.design.color.background.placeholder':"選擇顏色",
    'form.configuration.settings.design.color.app.names':"應用程式名稱顏色",
    'form.configuration.settings.design.color.app.names.placeholder':"選擇顏色",
    'form.configuration.settings.design.background.image.url':"背景圖片的網址",
    'form.configuration.settings.design.background.image.url.placeholder':"輸入背景圖片的網址",
    'form.configuration.settings.design.icon':"圖示大小",
    'form.configuration.settings.design.icon.small' : "小",
    'form.configuration.settings.design.icon.medium':"平均（+ 20％）",
    'form.configuration.settings.design.icon.large':"大（+ 40％）",
    'form.configuration.settings.design.desktop.header':"桌面標題",
    'form.configuration.settings.design.desktop.header.no' : "沒有",
    'form.configuration.settings.design.desktop.header.deviceid' : "設備編號",
    'form.configuration.settings.design.desktop.header.description': '描述',
    'form.configuration.settings.design.desktop.header.custom': '自定義模板',
    'form.configuration.settings.design.desktop.header.hint': '確保將此參數發送到設備（設置 - 常規和語言選項）',
    'form.configuration.settings.design.desktop.header.template': '輸入模板',
    'form.configuration.settings.design.desktop.header.template.placeholder': '使用變量',
    'form.configuration.settings.design.display.status': '顯示時間和電池狀態',
    'form.configuration.settings.design.upload': '上載',
    'form.configuration.settings.common.name' : "名稱",
    'form.configuration.settings.common.name.placeholder':"輸入配置名稱",
    'form.configuration.settings.common.desc' : "資訊",
    'form.configuration.settings.common.desc.placeholder':"輸入配置說明",
    'form.configuration.settings.common.admin.pwd':"解鎖密碼",
    'form.configuration.settings.common.admin.pwd.placeholder':"輸入設備解鎖密碼",
    'form.configuration.settings.common.gps' : "GPS",
    'form.configuration.settings.common.gps.any' : "任何",
    'form.configuration.settings.common.gps.off':"已禁用",
    'form.configuration.settings.common.gps.on':"啟用",
    'form.configuration.settings.common.bluetooth' : "藍牙",
    'form.configuration.settings.common.wifi' : "無線上網",
    'form.configuration.settings.common.mobile.data' : "流動數據",
    'form.configuration.settings.common.usb.storage':"阻止USB存儲",
    'form.configuration.settings.common.brightness':"管理亮度",
    'form.configuration.settings.common.brightness.none' : "沒有",
    'form.configuration.settings.common.brightness.auto' : "自動",
    'form.configuration.settings.common.brightness.manual' : "值",
    'form.configuration.settings.common.brightness.value':"屏幕亮度",
    'form.configuration.settings.common.timeout':"管理屏幕超時",
    'form.configuration.settings.common.timeout.value':"屏幕超時（秒）",
    'form.configuration.settings.common.volume.block':"鎖定音量",
    'form.configuration.settings.common.volume.manage': '管理設備音量',
    'form.configuration.settings.common.volume.value': '裝置音量',
    'form.configuration.settings.common.timezone.mode':"管理時區",
    'form.configuration.settings.common.timezone.mode.default':"不要管",
    'form.configuration.settings.common.timezone.mode.auto' : "自動",
    'form.configuration.settings.common.timezone.mode.manual' : "手冊",
    'form.configuration.settings.common.timezone' : "時區",
    'form.configuration.settings.common.timezone.placeholder':"例如America / Los_Angeles",
    'form.configuration.settings.common.timezone.link':"時區列表",
    'form.configuration.settings.common.no.network.warning' : "警告！不要關閉所有連接通道，否則您將無法再管理設備！",
    'form.configuration.settings.common.autostart.foreground': '在前台啟動應用程序',
    'form.configuration.settings.request.updates': '位置追踪',
    'form.configuration.settings.request.updates.donottrack': '沒有主動跟踪（使用第三方應用位置數據）',
    'form.configuration.settings.request.updates.gps': '通過 GPS 追踪位置',
    'form.configuration.settings.request.updates.wifi': '通過 Wi-Fi 跟踪位置（必須啟用 Google 服務）',
    'form.configuration.settings.request.updates.prompt.gps': '要通過 GPS 跟踪位置，您需要啟用 GPS',
    'form.configuration.settings.request.updates.prompt.wifi': '要通過 Wi-Fi 跟踪位置，您需要啟用 Wi-Fi',
    'form.configuration.settings.revoke.location.permission': '無位置權限',
    'form.configuration.settings.revoke.location.permission.hint': '如果設置，位置權限將不會授予 MDM 代理，並且無法跟踪設備位置',
    'form.configuration.settings.apps.permissions': '其他應用的權限',
    'form.configuration.settings.apps.permissions.grant': '自動授予所有權限',
    'form.configuration.settings.apps.permissions.ask.location': '自動授予所有權限，詢問用戶位置權限',
    'form.configuration.settings.apps.permissions.deny.location': '自動授予全部，不授予位置權限',
    'form.configuration.settings.apps.permissions.ask.all': '向用戶詢問所有權限',
    'form.configuration.settings.push.options'  : "推送通知",
    'form.configuration.settings.push.options.mqtt.worker' :"MQTT協議（節省電池）",
    'form.configuration.settings.push.options.mqtt.alarm' :"MQTT協議",
    'form.configuration.settings.push.options.polling' :"HTTP輪詢",
    'form.configuration.settings.push.options.mqtt.worker.hint' : '設備處於活動狀態時，立即發送推送消息。 但是在睡眠模式下，郵件可能會延遲多達幾個小時。 不要在獨立設備上使用此選項。 MQTT使用TCP端口31000，在防火牆上啟用它。',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT 是一種消耗最少資源的輕量級協定。 MQTT 使用 TCP 連接埠 31000，請在防火牆上啟用它。',
    'form.configuration.settings.push.options.polling.hint' : '長輪詢會保持 HTTP 連接，這會消耗更多伺服器資源。除 HTTP(S) 之外不需要任何 TCP 連接埠。',
    'form.configuration.settings.push.options.keepalive' : '保活時間',
    'form.configuration.settings.minute.1' : '1分鐘',
    'form.configuration.settings.minutes.2' : '2分鐘',
    'form.configuration.settings.minutes.3' : '3分鐘',
    'form.configuration.settings.minutes.5' : '5分鐘',
    'form.configuration.settings.minutes.10' : '10分鐘',
    'form.configuration.settings.minutes.15' : '15分鐘',
    'form.configuration.settings.password.mode' :"密碼要求",
    'form.configuration.settings.password.mode.any'  : "沒有",
    'form.configuration.settings.password.mode.present' :"需要密碼",
    'form.configuration.settings.password.mode.easy' :"簡單（至少6個符號）",
    'form.configuration.settings.password.mode.moderate' :"中等（8個以上的符號，字母和數字）",
    'form.configuration.settings.password.mode.strong' :"強（8個以上，大寫和小寫字母，數字，符號）",
    'form.configuration.settings.show.wifi': '在連接錯誤時啟用 WiFi 設置',
    'form.configuration.settings.use.default.launcher': '後台模式',
    'form.configuration.settings.use.default.launcher.hint': '不取代系統啟動器，僅執行後台 MDM 服務。不建議使用 kiosk 模式。',
    'form.configuration.settings.disable.screenshots':"禁用屏幕截圖",
    'form.configuration.settings.orientation':"屏幕轉向鎖定",
    'form.configuration.settings.orientation.none':"請勿鎖定",
    'form.configuration.settings.orientation.portrait' : "直向",
    'form.configuration.settings.orientation.landscape' : "橫向",
    'form.configuration.settings.files.default.path': '設備上的默認路徑',
    'form.configuration.files.search.label' : "搜索",
    'form.configuration.files.action.upload':"上傳",
    'form.configuration.files.action.remove' : "去掉",
    'form.configuration.files.variables': '內容可變',
    'form.configuration.files.variables.hint': '字符串DEVICE_NUMBER，IMEI，CUSTOM*將替換為其值',

    'form.configuration.file.name' : "文檔名",
    'form.configuration.file.select': '選擇檔案',
    'form.configuration.file.create': '(建立新檔案)',
    'form.configuration.file.description' : "文檔資訊",
    'form.configuration.file.description.placeholder':"可選，為了您的方便",
    'form.configuration.file.path':"設備上的路徑",
    'form.configuration.file.path.placeholder':"不包括驅動器的路徑，例如/my-app/image.jpg",
    'form.configuration.file.url':"URL",
    'form.configuration.file.url.placeholder' : '如果僅在外部資源上託管文檔',
    'form.configuration.file.file' : "文檔",
    'form.configuration.file.action' : "行動",
    'form.configuration.file.action.prompt.1':"上傳",
    'form.configuration.file.action.prompt.2' : "去掉",
    'form.configuration.file.remove.prompt.1':"此文檔將不再與設備同步",
    'form.configuration.file.remove.prompt.2':"從服務器刪除文檔",
		
    'form.password.title' : "更改密碼",
    'form.password.label.user' : "用戶",
    'form.password.label.password.new' : "新密碼",
    'form.password.label.password.new.placeholder' : "輸入新的密碼",
    'form.password.label.password.confirm' : "確認",
    'form.password.label.password.confirm.placeholder':"再次輸入新密碼",
    'form.password.length': '最小長度: ${length}. ',

    'form.application.type' : "類型",
    'form.application.type.option.web' : "網頁",
    'form.application.type.option.app' : "應用程式",
    'form.application.type.option.intent': '系統運算',
    'form.application.intent': '操作',
    'form.application.intent.placeholder': '選擇一個動作',
    'form.application.url.hint': '使用 file:///storage/emulated/0/... 建立本機檔案和資料夾的連結',
    'form.application.pkg':"包裹ID",
    'form.application.from.file':"由文檔確定",
    'form.application.pkg.title' : '當您上傳APK文檔時，包ID會自動確定。手動輸入的軟件包ID僅對於系統應用程式是必需的。',
    'form.application.pkg.placeholder':"例如com.android.camera",
    'form.application.disabled.arch': '版本特定',
    'form.application.disabled.arch.title': '為不同的CPU架構添加APK，點擊“添加”，或打開應用版本列表',
    'form.application.arch': '本機代碼',
    'form.application.arch.title': '一些應用程序包含針對某些CPU架構優化的代碼。 在這種情況下，您需要上傳兩個APK（適用於armeabi-v7a和arm64-v8a架構）',
    'form.application.arch.universal': '無（通用APK）',
    'form.application.arch.armeabi': 'armeabi-v7a的本機代碼',
    'form.application.arch.arm64': 'arm64-v8a的本機代碼',
    'form.application.arch.no.split': '通用APK',
    'form.application.arch.split': '拆分的APK',
    'form.application.arch.warning': '此 APK 僅針對 ${arch} 進行了優化，可能無法在所有設備上運行。 建議上傳另一個針對另一個 CPU arch 優化的 APK。 要在所有設備上使用此 APK，請選擇“通用 APK”。',
    'form.application.arch.success': '這個應用程式包含適用於兩種CPU架構的APK',
    'form.application.version.exists': '此版本的 APK 已存在',
    'form.application.url.armeabi': 'armeabi-v7a 的 URL',
    'form.application.url.arm64': 'arm64-v8a 的 URL',
    'form.application.name' : "應用程式名稱",
    'form.application.name.title' : "您將在列表中看到應用程式名稱。我們建議使用唯一且信息豐富的名稱。",
    'form.application.name.placeholder':"例如，相機（Android）",
    'form.application.version' : "版本",
    'form.application.version.placeholder' : "0為系統應用程式",
    'form.application.version.title' : "打包版本是在您上傳APK文檔時自動確定的。對於系統應用，將其設置為0。",
    'form.application.version.code': '版本代碼',
    'form.application.version.code.exists': '已存在具有相同代碼的版本。 請將此問題報告給應用程序開發人員。',
    'form.application.system' : "系統",
    'form.application.system.title' : "系統應用程式已預先安裝在設備上，不需要URL或文檔。僅在需要啟用某個系統程序包時設置此標誌。",
    'form.application.run.after.install':"安裝後運行",
    'form.application.run.after.install.title':"具有後台服務的應用程式至少需要在前台啟動一次。",
    'form.application.run.at.boot':"啟動時運行",
    'form.application.run.at.boot.title' : "如果需要在啟動後在前台運行應用程式，請設置此標誌。此標誌不影響後台進程。",
    'form.application.url':"URL",
    'form.application.url.title':"僅當您的應用程式託管在外部資源上時，才應輸入URL。建議通過以下字段上傳APK文檔。",
    'form.application.url.disabled' : "為每個版本設置了URL。要更改網址，請關閉此窗口，然後點擊\"版本\"圖示。",
    'form.application.file' : "文檔",
    'form.application.auto.update': '自動更新',
    'form.application.auto.update.title': '設置此標誌以更新安裝應用程序的所有配置。 僅在您 100% 確定應用程序穩定時使用。',
    'form.application.showLabel':"顯示圖示",
    'form.application.showLabel.title':"此標誌表示是否應在啟動器中顯示應用程式圖示。該選項可能在配置中被覆蓋。",
    'form.application.use.kiosk': '在信息亭瀏覽器中打開',
    'form.application.use.kiosk.title': '如果您想在Kiosk Browser中打開網頁而無法更改地址，請設置此標誌',
    'form.application.iconText':"圖示文字",
    'form.application.iconText.placeholder' : "（默認）",
    'form.application.versions.title':"應用程式版本",
    'form.application.icon' : "圖示",
    'form.application.icon.default' : "（默認）",
    'form.application.icon.add':"新增圖示",
		
    'form.application.setting.app' : "應用程式",
    'form.application.setting.app.placeholder':"選擇應用程式",
    'form.application.setting.name' : "屬性",
    'form.application.setting.value' : "值",
    'form.application.setting.comment' : "備註",
    'form.application.setting.type' : "類型",
    'form.application.setting.readonly':"在設備上不變",

    'form.application.configurations.app' : "應用程式",
    'form.application.configurations.configs':"配置",
		
    'form.configuration.copy.new.name' : "新名字",
    'form.configuration.copy.new.name.placeholder':"輸入新的配置名稱",
		
    'form.customer.name' : "名稱",
    'form.customer.name.placeholder':"輸入組織名稱",
    'form.customer.admin.name': '管理員名稱',
    'form.customer.firstname.placeholder': '名',
    'form.customer.lastname.placeholder': '姓',
    'form.customer.language': '語言',
    'form.customer.language.placeholder': '為英文留空或輸入兩個小寫字母',
    'form.customer.apiKey':"API密鑰",
    'form.customer.apiKey.placeholder':"輸入API密鑰",
    'form.customer.prefix' : "字首",
    'form.customer.prefix.placeholder':"輸入設備編號前綴",
    'form.customer.device.configuration':"設備配置",
    'form.customer.desc' : "資訊",
    'form.customer.desc.placeholder':"輸入組織資訊",
    'form.customer.copy.configuration':"複製配置",
    'form.customer.copy.design':"複製設計",
    'form.customer.type' : "客戶類型",
    'form.customer.status':"客戶狀態",
    'form.customer.expiry.time' : "到期日",
    'form.customer.device.limit':"設備限制",
    'form.customer.size.limit': '存儲限制',
    'form.customer.size.limit.placeholder': '大小 (Mb)',

    'form.device.number' : "編號",
    'form.device.number.locked': '由於之前的號碼更改尚未完成，因此無法更改號碼。',
    'form.device.migration.warning': '設備編號將被更改。 確保設備已打開並在線。',
    'form.device.number.hint':"不要使用特殊字符",
    'form.device.desc' : "資訊",
    'form.device.groups':"組合",
    'form.device.config' : "配置",
    'form.device.imei' : "IMEI",
    'form.device.phone.number' : "電話號碼",
		
    'form.update.device.config' : "配置",
    'form.update.device.action': '組操作',
    'form.device.set.group': '添加到組',
    'form.device.clear.group': '從組中刪除',

    'form.file.file' : "文檔",
    'form.file.name': '檔名',
    'form.file.description': '描述（可選）',
    'form.file.external': '外部',
    'form.file.external.title': '您可以指定外部資源的 URL，而不是上傳文件',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': '外部資源上的檔案 URL',
    'form.file.path': '伺服器路徑',
    'form.file.device.path': '裝置路徑',
    'form.file.device.path.placeholder': '相對於 /storage/emulated/0 的路徑',
    'form.file.deleted': '已刪除',
    'form.file.copy.link': '複製連結：${link}',
    'form.file.configurations.file': '檔案',
    'form.file.configurations.configs': '配置',
    'form.file.configurations.upload': '上傳',
    'form.file.path.placeholder' : '輸入相對路徑，例如"/files/"',
    'form.file.available': '可用空間：${space} Mb',

    'form.file.apps.name' : "應用程式名稱",
    'form.file.apps.pkg':"包裹ID",
    'form.file.apps.version' : "版本",
		
    'form.group.name' : "名稱",
    'form.group.name.placeholder':"輸入組合名稱",

    'form.role.name': '名称',
    'form.role.name.placeholder': '输入角色的名称',
    'form.role.permissions': '权限',

    'form.user.login' : "登錄",
    'form.user.login.placeholder':"輸入用戶登錄名",
    'form.user.name' : "名稱",
    'form.user.name.placeholder' : "名字和姓氏",
    'form.user.email': '電子郵件',
    'form.user.email.placeholder': '輸入電子郵件',
    'form.user.role' : "角色",
    'form.user.all.devices.available':"所有設備都可用",
    'form.user.available.groups':"可用的設備組合",
    'form.user.all.configs.available': '所有配置都可用',
    'form.user.available.configs': '可用配置',
    'form.user.password.new' : "新密碼",
    'form.user.password' : "密碼",
    'form.user.password.new.placeholder' : "輸入新的密碼",
    'form.user.password.confirm' : "確認",
    'form.user.password.confirm.placeholder':"再次輸入新密碼",
		
    'form.settings.hints.title':"提示",
		
    'form.settings.plugins.title':"已經選用插件",
		
    'form.settings.common.title':"設備表視圖",
    'form.settings.common.visible.columns':"\"設備\"表中的可見列",
    'form.settings.common.status' : "狀態",
    'form.settings.common.role':"用戶角色",
    'form.settings.common.date' : "上次在線日期",
    'form.settings.common.device.number' : "設備編號",
    'form.settings.common.imei' : "IMEI",
    'form.settings.common.phone.number' : "電話號碼",
    'form.settings.common.phone.model':"電話型號",
    'form.settings.common.status.permissions':"權限狀態",
    'form.settings.common.status.installation':"安裝狀態",
    'form.settings.common.status.files':"文檔狀態",
    'form.settings.common.config' : "配置",
    'form.settings.common.desc' : "資訊",
    'form.settings.common.group' : "組合",
    'form.settings.common.launcher.version':"啟動器版本",
    'form.settings.common.battery.level':"電池電量",
    'form.settings.common.default.launcher':"默認啟動器",
    'form.settings.common.mdm.mode': 'MDM 模式',
    'form.settings.common.kiosk.mode': '信息亭模式',
    'form.settings.common.android.version': '安卓版',
    'form.settings.common.enrollment.date': '註冊日期',
    'form.settings.common.serial': '序列號',
    'form.settings.common.publicip': 'IP地址',

    'form.settings.design.title':"默認設計",
    'form.settings.design.color.font' : "背景顏色",
    'form.settings.design.color.font.placeholder':"選擇顏色",
    'form.settings.design.color.app.names':"應用程式名稱顏色",
    'form.settings.design.color.app.names.placeholder':"選擇顏色",
    'form.settings.design.url.background.image':"背景圖片的網址",
    'form.settings.design.url.background.image.placeholder':"輸入背景圖片網址",
    'form.settings.design.size.icon':"圖示大小",
    'form.settings.design.size.icon.small' : "小",
    'form.settings.design.size.icon.medium':"平均（+ 20％）",
    'form.settings.design.size.icon.large':"大（+ 40％）",
    'form.settings.design.desktop.header':"桌面標題",
    'form.settings.design.desktop.header.no' : "沒有",
    'form.settings.design.desktop.header.device.id' : "設備編號",
		
    'form.settings.lang.title' : "語言設定",
    'form.settings.lang.use.default':"使用默認語言",
    'form.settings.lang.use':"使用語言",
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.vi': 'Tiếng Việt',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title':"其他設置",
    'form.settings.misc.phone.format':"電話號碼格式",
    'form.settings.misc.phone.format.placeholder' : "+9（999）999-99-99",
    'form.settings.misc.custom.property.name.1':"自定義媒體資源1",
    'form.settings.misc.custom.property.name.2':"自定義屬性2",
    'form.settings.misc.custom.property.name.3':"自定義屬性3",
    'form.settings.misc.custom.property.multiline': '多行',
    'form.settings.misc.custom.property.send': '發送到設備',
    'form.settings.misc.custom.property.name.placeholder':"輸入自定義屬性的名稱",
    'form.settings.misc.create.new.devices':"在首次訪問時新增設備",
    'form.settings.misc.new.device.config':"新設備配置",
    'form.settings.misc.new.device.group':"新設備組合",
    'form.settings.misc.send.description': '向設備發送描述',
    'form.settings.misc.password.length': '最小密碼長度',
    'form.settings.misc.password.strength': '密碼強度',
    'form.settings.misc.password.none': '未指定（任何字符）',
    'form.settings.misc.password.alphanumeric': '大小寫字母、數字',
    'form.settings.misc.password.specialchar': '小寫和大寫字母、數字、特殊字符',
    'form.settings.misc.password.reset': '用戶應重置密碼',
    'form.settings.misc.idle.logout': '空閒時登出',
    'form.settings.misc.idle.logout.never': '從不',
    'form.settings.misc.idle.logout.1': '5 分鐘',
    'form.settings.misc.idle.logout.2': '10 分鐘',
    'form.settings.misc.idle.logout.3': '30 分鐘',
    'form.settings.misc.idle.logout.4': '1 小時',
    'form.settings.security.title': '安全設定',

    'idle.logout.message': '由於不活動，您將在 ${sec} 秒後註銷',
    'idle.logout.resume': '我在這裡！',

    'form.settings.groups.title':"組合",
    'form.settings.groups.search.placeholder':"組合搜索",
		
    'form.settings.users.title':"用戶",
    'form.settings.users.search.placeholder':"搜索用戶",

    'form.settings.roles.title': '使用者角色',

    'form.settings.icons.title': '圖標',
    'form.settings.icons.search.placeholder': '搜尋圖示',

    'form.qr.device.number': '設備編號',
    'form.qr.auto.create': '添加到設備列表（如果不存在）',
    'form.qr.number.use': '設備編號分配',
    'form.qr.number.use.request': '用戶價值',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': '序列號',
    'form.qr.number.hint': '清除設備編號以啟用自動設備編號分配',
    'form.qr.groups': '新增至群組',
    'form.qr.button.json': '獲取JSON',
    'form.qr.device.number.placeholder':"輸入設備ID ...",
    'form.qr.code.image.alt' : "二維碼",

    'form.password.reset.title': '請設置新密碼',
    'form.password.reset.invalid': '抱歉，此密碼重置鏈接無效',
    'form.password.reset.submit': '設置密碼',

    'form.two.factor.auth.title': '雙因素身份驗證',
    'form.two.factor.auth.hint': '要完成註冊，請在您的移動設備上安裝身份驗證器應用程序，掃描二維碼，生成並輸入驗證碼。',
    'form.two.factor.auth.code.invalid': '驗證碼無效！',
    'form.two.factor.auth.code': '驗證碼',
    'form.two.factor.auth.code.hint': '來自驗證器應用程序的 6 位代碼',
    'form.two.factor.auth.code.error': '代碼必須是6位數字',
    'form.two.factor.auth.verify': '驗證',
    'form.two.factor.auth.settings.hint': '要設置雙重身份驗證，請在移動設備上安裝Authenticator應用程序，掃描二維碼，生成並輸入驗證碼。',
    'form.two.factor.auth.set': '雙因素身份驗證已開啟',
    'form.two.factor.auth.reset': '雙因素身份驗證已關閉',
    'form.two.factor.auth.off.confirm': '您要關閉雙重認證嗎？ 重新開啟後，所有驗證器都會失效。',

    'form.profile.title' : "更改密碼",
    'form.profile.password.old' : "舊密碼",
    'form.profile.password.old.placeholder':"輸入舊密碼",
    'form.profile.password.new' : "新密碼",
    'form.profile.password.new.placeholder' : "輸入新的密碼",
    'form.profile.password.confirm' : "確認",
    'form.profile.password.confirm.placeholder':"再次輸入新密碼",
		
    'tab.customers':"組織",
    'tab.common.applications':"共享應用程式",
		
    'tab.devices' : "設備",
    'tab.applications':"應用程式",
    'tab.configurations':"配置",
    'tab.files':"文檔",
    'tab.default.design':"默認設計",
    'tab.common.settings':"設備表視圖",
    'tab.users':"用戶",
    'tab.roles': '角色',
    'tab.groups':"組合",
    'tab.icons': '圖示',
    'tab.language':"常規和語言選項",
    'tab.license' : "軟件許可證",
    'tab.hints':"提示",
    'tab.plugins':"插件",

    'tab.configeditor.common.settings':"通用設置",
    'tab.configeditor.design.settings':"設計設置",
    'tab.configeditor.applications':"應用程式",
    'tab.configeditor.mdm.settings':"MDM設置",
    'tab.configeditor.app.settings':"應用程式設置",
    'tab.configeditor.files':"文檔",
		
    'search.placeholder.file':"搜索文檔",
    'search.placeholder.configuration':"搜索配置",
    'search.placeholder.customer':"尋找組織",
    'search.placeholder.application':"搜索應用程式",
    'search.placeholder.application.setting':"搜索應用程式設置",
    'search.placeholder.device':"搜索設備",
    'search.placeholder.address':"網址搜索",
    'search.placeholder.point':"站點搜索",
    'search.placeholder.message':"郵件搜索",
    'search.placeholder':"搜索...",
    'search.placeholder.from':"由...",
    'search.placeholder.to' : "至 ...",
    'search.placeholder.user':"輸入用戶名",
		
    'table.heading.customer.name' : "名稱",
    'table.heading.customer.desc' : "資訊",
    'table.heading.customer.registration.time' : "註冊",
    'table.heading.customer.last.login.time' : "上次登錄",
    'table.heading.customer.actions':"功能",
    'table.heading.customer.type' : "類型",
    'table.heading.customer.expiry.time':"到期",
    'table.heading.customer.device.limit' : "限制",
    'table.heading.customer.status' : "狀態",
		
    'customer.new' : "新",
    'customer.active' : "活性",
    'customer.need.followup':"需要跟進",
    'customer.followup.sent':"後續發送",
    'customer.internal.test':"內部測試",
    'customer.developer':"開發人員",
    'customer.difficult' : "難",
    'customer.pause' : "暫停",
    'customer.inactive': '沒有登錄',
    'customer.abandon': '棄',
    'customer.onpremise': '內部試用',
    'customer.denial' : "否認",
    'customer.client' : "客戶",
		
    'table.heading.configuration.name' : "名稱",
    'table.heading.configuration.desc' : "資訊",
    'table.heading.configuration.actions':"功能",
		
    'table.heading.application.setting.app.pkg':"包裹ID",
    'table.heading.application.setting.app.name' : "應用程式名稱",
    'table.heading.application.setting.name' : "屬性",
    'table.heading.application.setting.value' : "值",
    'table.heading.application.setting.comment' : "備註",
    'table.heading.application.setting.lastUpdate' : "創建日期",
		
    'table.heading.file.url':"URL",
    'table.heading.file.devicepath':"設備上的路徑",
    'table.heading.file.description' : "文檔資訊",
    'table.heading.file.action' : "行動",
    'table.heading.file.lastUpdate' : "創建日期",

    'table.heading.application.pkg':"包裹ID",
    'table.heading.application.name' : "應用程式名稱",
    'table.heading.application.version' : "版本",
    'table.heading.application.url':"URL",
    'table.heading.application.label' : "圖示",
    'table.heading.application.actions':"功能",
    'table.heading.application.order' : "排序",
		
    'table.heading.device.status' : "狀態",
    'table.heading.device.date' : "在線的",
    'table.heading.device.device.number' : "設備編號",
    'table.heading.device.imei' : "IMEI",
    'table.heading.device.phone.number' : "電話號碼",
    'table.heading.device.phone.model':"電話型號",
    'table.heading.device.status.permissions':"權限狀態",
    'table.heading.device.status.installation':"安裝狀態",
    'table.heading.device.status.files':"文檔狀態",
    'table.heading.device.configuration' : "配置",
    'table.heading.device.desc' : "資訊",
    'table.heading.device.group' : "組合",
    'table.heading.device.launcher.version':"啟動器版本",
    'table.heading.device.battery.level':"電池電量",
    'table.heading.device.default.launcher' : "設為默認啟動器",
    'table.heading.device.mdm.mode': 'MDM 模式',
    'table.heading.device.kiosk.mode': '信息亭模式',
    'table.heading.device.android.version': '安卓版',
    'table.heading.device.enrollment.date': '註冊日期',
    'table.heading.device.serial': '序列號',
    'table.heading.device.publicip': 'IP地址',
    'table.heading.device.actions':"功能",
		
    'table.heading.group.name' : "名稱",
    'table.heading.group.actions':"功能",

    'table.heading.role.name' : "名稱",
    'table.heading.role.actions':"功能",

    'table.heading.file.name' : "文檔名",
    'table.heading.file.comment': '描述',
    'table.heading.file.device.path': '裝置路徑',
    'table.heading.file.update.time': '更新時間',
    'table.heading.file.external': '外部',
    'table.heading.file.variable': '變數',
    'table.heading.file.remove': '刪除',
    'table.heading.file.remove.hint': '強制從裝置儲存中刪除檔案',
    'table.heading.file.path' : "路徑",
    'table.heading.file.address' : "網址",
    'table.heading.file.size': '尺寸',
    'table.heading.file.actions':"功能",
		
    'table.heading.users.login' : "登錄",
    'table.heading.users.name' : "名稱",
    'table.heading.users.role' : "角色",
    'table.heading.users.actions':"功能",
		
    'table.heading.common.apps.customer' : "組織",
    'table.heading.common.apps.pkg':"包裹ID",
    'table.heading.common.apps.name' : "應用程式名稱",
    'table.heading.common.apps.version' : "版本",
    'table.heading.common.apps.url':"URL",
    'table.heading.common.apps.label' : "圖示",
    'table.heading.common.apps.actions':"功能",
		
    'notfound.devices':"沒有要顯示的設備。",
    'notfound.files' : '文檔列表為空。',
    'notfound.configurations' : "未找到配置。",
    'notfound.customers':"未找到組織。",
    'notfound.common.apps':"沒有要顯示的應用程式。",
    'notfound.applications':"找不到應用程式",
    'notfound.groups' : '找不到群合。嘗試其他查詢。',
    'notfound.users' : '找不到用戶。嘗試其他查詢。',
    'notfound.apps.for.display':"沒有要顯示的應用程式。",
    'notfound.app.versions.for.display':"沒有要顯示的版本。",
    'notfound.roles':'角色列表為空。',
    'notfound.icons':'圖示清單為空。',

    'format.date.header' : "HH:mm dd / MM / yyyy",
		
    'menu.about' : "關於",
    'menu.profile':"個人資料",
    'menu.panel.master':"主面板",
    'menu.panel.main':"主面板",
    'menu.logout' : "登出",
    'menu.functions' : "其他功能",
    'menu.settings':"設置",
    'menu.show.hints':"顯示提示",
		
    'plugin.name.not.specified' : "<<未指定函數名稱>>",

    'breadcrumb.summary': '摘要',
    'breadcrumb.devices' : "設備",
    'breadcrumb.applications':"應用程式",
    'breadcrumb.configurations':"配置",
    'breadcrumb.files':"文檔",
    'breadcrumb.default.design':"默認設計",
    'breadcrumb.common.settings':"設備表視圖",
    'breadcrumb.language.settings':"語言和其他設置",
    'breadcrumb.license.settings' : "軟件許可證",
    'breadcrumb.users':"用戶",
    'breadcrumb.roles': '角色',
    'breadcrumb.groups':"組合",
    'breadcrumb.hints':"提示",
    'breadcrumb.plugins':"插件",
    'breadcrumb.config.details' : "細節",
    'breadcrumb.application.versions':"版本",
		
    'app.name':"Headwind MDM",
    'app.vendor.name':"h-mdm.com",
    'app.vendor.link':"https://h-mdm.com",
    'app.description':"是開源移動設備管理系統",
    'app.title':"${appName} Web面板",
		
    'box.show.my.apps.only':"僅顯示我的應用程式",
    'configuration.app.version.upgrade.message':"已安裝版本${installedVersion}，可用版本${latestVersion}",
		
    'about.line.1':"${appName}控制面板",
    'about.line.2':"Android企業啟動器",
    'about.line.3':"版本${versionNumber}",
    'about.line.4':"已安裝的插件",
		
    'common.app.clarification' : "該應用程式是公開的，無法進行編輯。要新增此應用的其他版本，請聯繫管理員。",
		
    'qrcode.help.line1' : "以託管（公司）模式設置Android設備（版本7或更高版本）",
    'qrcode.help.line2':"將設備重置為出廠設置",
    'qrcode.help.line3':"在開始屏幕的任何位置點擊7次（您必須輸入隱藏的QR碼掃描模式）",
    'qrcode.help.line4' : "按照設備說明進行操作:接受條款，連接到Wi-Fi，掃描此QR碼",
    'qrcode.help.line5':"QR碼可能包含${appName}的設備ID（因此您無需在移動設備上輸入它）。要將設備ID嵌入QR碼，請在此屏幕上輸入設備ID，然後單擊\"續訂\"。",
		
    'form.configuration.app.version.select.select.title':"選擇要安裝的版本",
    'form.configuration.app.version.select.version.check.off':"禁用版本檢查",
    'form.configuration.app.version.select.upgrade.warning' : "將配置\"${v2}\"的應用程式\"${v1}\"升級到版本\"${v3}\"嗎？",
    'form.configuration.app.version.select.downgrade.warning' : "降級版本在所有設備上刪除所有這些應用程式！是否將應用程式版本\"${v1}\"降級為版本\"${v2}\"？",
		
    'hint.step.1':"點擊此處開始設備註冊",
    'hint.step.2':"點擊此處打開QR碼",
    'hint.step.3':"點擊此處查看如何在設備上打開QR碼掃描器",
    'hint.step.4' : "在\"Devices\"選項卡中找到可用的設備ID。點擊竄改新壇以將其包含在QR碼中。",
		
    'ie.browser.notice.1':"很遺憾，不支持Internet Explorer。",
    'ie.browser.notice.2' : '推薦的瀏覽器，用於使用${appName}-<a href ="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop">Chrome</a>.',
		
    'form.resolved.duplicate.pkg.text1':"軟件包ID\"${pkg}\"已被下列應用程式使用。",
    'form.resolved.duplicate.pkg.text2':"您要新增新應用程式還是現有應用程式的新版本？",
    'form.resolved.duplicate.pkg.text3':"新版本",
    'form.resolved.duplicate.pkg.text4':"程序包${apps}已使用包ID\"${pkg}\"",
    'form.resolved.duplicate.pkg.text5':"您確定要更改包裹ID嗎？",
		
    'tooltip.usage.byconfigurations':"由配置使用",
    'tooltip.usage.byapps':"由應用程式使用",
    'tooltip.usage.byicons':"由圖示使用",
		
    'form.devices.label.params.more':"更多參數",
    'form.devices.label.params.less':"參數較少",
    'form.devices.label.installation.status':"安裝狀態",
    'format.devices.date.createTime':"dd/MM/yyyy HH:mm:ss",
    'format.devices.date.datePicker':"dd-MM-yyyy",
    'form.devices.fast.search': '按號碼快速搜索',

    'form.devices.selection.install.status.default':"安裝狀態...",
    'form.devices.selection.install.status.all' : "所有",
    'form.devices.selection.install.status.success' : "成功",
    'form.devices.selection.install.status.version.mismatch' : "版本不匹配",
    'form.devices.selection.install.status.failure' : "失敗",
    'form.devices.selection.imei.changed':"IMEI最近發生了變化",
		
    'search.placeholder.launcher.version':"啟動器版本",
    'error.date.range.invalid':"無效的日期間隔",

    'form.selection.status.any': '任何值',
    'form.selection.status.all': '全部',
    'form.selection.status.yes': '是的',
    'form.selection.status.no': '不',

    'form.devices.selection.status': '地位 ...',
    'form.devices.selection.online': '在線的',
    'form.devices.selection.offline': '離線',
    'form.devices.selection.number': '輸入號碼',

    'form.devices.selection.online.status.custom': '輸入時間',
    'form.devices.selection.online.status.1': '15分鐘',
    'form.devices.selection.online.status.2': '30分鐘',
    'form.devices.selection.online.status.3': '1小時',
    'form.devices.selection.online.status.4': '3小時',
    'form.devices.selection.online.status.5': '6個小時',
    'form.devices.selection.online.status.6': '1天',
    'form.devices.selection.online.status.7': '2天',
    'form.devices.selection.online.status.8': '3天',
    'form.devices.selection.online.status.9': '1週',
    'form.devices.selection.online.status.10': '1個月',

    'form.devices.selection.online.status.label': '分鐘',
    'form.devices.status.ago': '前',
    'form.devices.status.minutes': 'm',
    'form.devices.status.hours': 'h',
    'form.devices.status.days': 'd',
    'form.devices.status.weeks': 'w',
    'form.devices.status.months': 'mon',
    'form.devices.status.years': 'y',

    'customer.type.demo' : "演示",
    'customer.type.small' : "專業的",
    'customer.type.corporate' : "企業",
    'customer.type.master' : "主",
		
    'customer.type.options.all' : "所有類型",
    'customer.status.options.all':"所有狀態",
		
    'account.expiring':"您的帳戶將在${days}天后過期。請與賣家聯繫以更新您的帳戶。",
    'account.expired.short':"您的帳戶已過期！",
    'account.expired' : "您的帳戶已過期。請與賣家聯繫以更新您的帳戶。",
    'device.limit.achieved' : "由於您已達到極限，因此無法新增設備。請移除一些設備或與賣家聯繫以擴展設備限制。",

    'menu.updates': '檢查更新',
    'updates.title': '更新',
    'updates.disabled.custom': '自定義版本，請手動更新',
    'updates.disabled.not_master': '要求主機提供商更新',
    'updates.disabled.multiple': '多個應用版本，請手動更新',
    'updates.disabled.error': '內部服務器錯誤',
    'updates.disabled.download': '下載更新時出錯',
    'updates.application': '應用程序',
    'updates.current.version': '當前版本',
    'updates.available.version': '可用版本',
    'updates.downloaded': '已下載',
    'updates.auto.update': '自動更新移動應用程序（在生產中謹慎使用！）',
    'updates.enable.stats': '將使用統計信息發送給服務提供商以提高系統性能',
    'updates.get': '獲取更新',
    'updates.checking': '正在檢查更新...',
    'updates.getting': '正在獲取更新...',
    'updates.success': '更新完成',
    'updates.web.hint': '要完成 Web 應用程序更新，請在 SSH 控制台中運行 shell 腳本 /opt/hmdm/update-web-app.sh',

    'permission.edit_device_app_settings': '管理特定於裝置的應用程式設定',
    'permission.plugins_customer_access_management': '管理可用插件',
    'permission.plugin_audit_access': '檢視審核日誌',
    'permission.plugin_contacts_access': '管理聯絡人',
    'permission.plugin_deviceexport_access': '匯出裝置',
    'permission.plugin_deviceimport_access': '導入裝置',
    'permission.plugin_deviceinfo_access': '查看裝置詳細資料',
    'permission.plugin_devicelocations_access': '在地圖上檢視裝置',
    'permission.plugin_devicelocations_settings_access': '配置地圖插件',
    'permission.plugin_devicelog_access': '檢視裝置日誌',
    'permission.plugin_devicereset_access': '重設並重新啟動裝置',
    'permission.plugin_licensing_access': '存取授權（已棄用）',
    'permission.plugin_messaging_send': '發送訊息',
    'permission.plugin_messaging_delete': '刪除已傳送的訊息',
    'permission.plugin_photo_remove_photo': '刪除照片',
    'permission.settings': '管理設定',
    'permission.configurations': '查看配置',
    'permission.edit_devices': '編輯裝置資訊',
    'permission.edit_device_desc': '編輯裝置描述',
    'permission.enroll_devices': '透過二維碼註冊設備',
    'permission.plugin_apuppet_access': '遠端控制',
    'permission.plugin_knox_access': 'Knox 插件',
    'permission.add_config': '新增設定',
    'permission.copy_config': '重複配置',
    'permission.plugin_openvpn_access': 'OpenVPN 外掛程式',
    'permission.plugin_photo_access': '照片插件',
    'permission.push_api': '存取推送API',
    'permission.plugin_urlfilter_access': 'URL過濾',
    'permission.plugin_push_send': '發送推播訊息',
    'permission.plugin_push_delete': '刪除推播訊息',
    'permission.get_updates': '檢查更新',
    'permission.plugin_xtra_access': '請求高級版本',
    'permission.applications': '查看應用程式',
    'permission.edit_applications': '管理應用程式',
    'permission.edit_application_versions': '管理應用程式版本',
    'permission.files': '檢視檔案',
    'permission.edit_files': '管理檔案',

    'yes' : 'yes',
    'no' : 'No'
};		
