if (! document.localization) document.localization = [];

document.localization ['ja_JP'] = {
    'login.username': 'ユーザー名',
    'login.username.placeholder': 'ユーザー名を入力',
    'login.password': 'パスワード:',
    'login.password.placeholder': 'パスワードを入力',
    'login.submit': 'ログイン',
    'login.password.incorrect': 'ユーザー名またはパスワードが無効です',
    'login.password.recovery': 'パスワードを忘れましたか?',
    'recovery.password': 'パスワードの回復',
    'recovery.password.success': 'パスワードの回復手順をメールに送信しました',
    'login.no.account': 'アカウントがありませんか?',
    'login.signup': 'サインアップ',

    'signup.title': '始めましょう',
    'signup.email': 'あなたのメールアドレス',
    'signup.email.placeholder': '有効なメールアドレスを入力してください',
    'signup.email.invalid': '有効なメールアドレスを入力してください',
    'signup.terms.agree': '同意します',
    'signup.terms.terms': '利用規約',
    'signup.submit': 'サインアップ',
    'signup.progress': 'サインアップしています...',
    'signup.email.used': 'このメールアドレスの顧客は既に登録されています',
    'signup.name.used': 'このユーザー名の顧客は既に登録されています',
    'signup.complete': 'ご登録ありがとうございます!',
    'signup.email.check': 'メールを確認し、リンクに従って登録を完了してください!',
    'signup.complete.title': '${appName} でのアカウントの準備がほぼ整いました!',
    'signup.ready.title': '${appName} のアカウントの準備ができました!',
    'signup.customer.id': 'ユーザー名',
    'signup.customer.id.placeholder': '文字と数字のみを使用してください',
    'signup.customer.id.invalid': '6 文字以上の英字と数字のみを使用してください',
    'signup.first.name': '名',
    'signup.first.name.placeholder': 'あなたの名前 (必須)',
    'signup.last.name': '姓',
    'signup.last.name.placeholder': '姓 (必須)',
    'signup.company': '会社名',
    'signup.company.placeholder': '会社の名前 (オプション)',
    'signup.description': 'MDM をどのように使用しますか?',
    'signup.description.placeholder': 'これは私たちのチームがあなたを支援するのに役立ちます',
    'signup.password': 'パスワード',
    'signup.password.repeat': 'パスワードを繰り返す',
    'signup.password.placeholder': '6 文字以上',
    'signup.password.short': '6 文字以上で入力してください',
    'signup.password.not.match': 'パスワードが一致しません',
    'signup.finalized.title': 'アカウントの準備ができました!',
    'signup.finalized.description': 'すぐに、役立つ手順が記載された電子メールを受け取る必要があります。 このメールを確認し、ユーザー名とパスワードを使用して Web パネルにログインしてください。',
    'signup.token.invalid.title': 'トークンが無効であるか、既に使用されています',
    'signup.token.invalid.description': '新しいアカウントを作成するためにサインアップを再試行してください!',

    'header.label.username': 'ユーザー名',

    'summary.devices.status': 'デバイスのステータス',
    'summary.devices.active': 'アクティブ',
    'summary.devices.idle': 'アイドル',
    'summary.devices.offline': 'オフライン',
    'summary.devices.enrollment': '登録概要',
    'summary.devices.enrolled.total': '登録された合計',
    'summary.devices.enrolled.earlier': '以前に登録されました',
    'summary.devices.enrolled.monthly': '過去 30 日間',
    'summary.devices.installation.status': 'アプリケーションのステータス',
    'summary.devices.installation.completed': '完了',
    'summary.devices.version.mismatch': 'バージョンの不一致',
    'summary.devices.installation.failed': 'インストールに失敗しました',
    'summary.devices.enrolled.lastyear': '過去 12 か月',

    'devices.group.options.all': 'すべてのグループ',
    'devices.configuration.options.all': 'すべての構成',
    'devices.permissions.all': 'すべての権限が付与されています',
    'devices.permissions.not.as.device.admin': '- アプリケーションがデバイス管理者としてインストールされていません',
    'devices.permissions.window.overlap.prohibited': '- 他のウィンドウの上に重ねることはできません',
    'devices.permissions.history.access.prohibited': '- 使用履歴へのアクセスが設定されていません',
    'devices.unknown': '不明',
    'devices.model.unknown': '不明',
    'devices.date.unknown': '不明',
    'devices.date.format': 'dd/MM/yy HH:mm',
    'devices.app.installed': '- ${applicationName}: インストール済み。',
    'devices.app.not.installed': '- ${applicationName}: インストールされていません。',
    'devices.app.version.available': ', 利用可能な ${applicationVersion}',
    'devices.app.installed.and.version.available': '- ${applicationName}: インストール済みの ${applicationInstalledVersion}、利用可能な ${applicationVersionAvailable}',
    'devices.app.needs.removal': '${applicationVersion}、削除が必要です',
    'devices.no.data': 'デバイスはデータを送信していません',
    'devices.settings.conformance.broken': '設定との不一致: (${serverData})',
    'devices.file.installed': '- ${file}: インストール済み',
    'devices.file.not.installed': '- ${file}: インストールされていません。',
    'devices.file.lastUpdate.differs': '- ${file}: 変更時間の差 ${diff} 分',

    'button.apply': '適用',
    'button.gps.on': 'GPSを有効にする',
    'button.wifi.on': 'Wi-Fiを有効にする',
    'button.notify.update': '更新時に通知',
    'button.app.settings': 'アプリケーション設定',
    'button.ok': 'OK',
    'button.help': 'ヘルプ',
    'button.new.app': '新しいアプリケーション',
    'button.new.app.version': '新しいバージョン',
    'button.upgrade': 'アップグレード',
    'button.renew.config': 'デバイスの更新',
    'button.common': '共通アプリ',
    'button.close': '閉じる',
    'button.yes': 'はい',
    'button.cancel': 'キャンセル',
    'button.save': '保存',
    'button.save.and.close': '保存して閉じる',
    'button.more': '詳細...',
    'button.cleanup': 'クリア',
    'button.add': '追加',
    'button.add.icon': '新しいアイコン',
    'button.search': '検索',
    'button.export': 'エクスポート',
    'button.change': '編集',
    'button.copy': 'コピー',
    'button.qrcode': 'QRコード',
    'button.application': 'アプリケーション',
    'button.change.password': 'パスワードの変更',
    'button.set.configuration': '設定の設定',
    'button.set.group': 'グループを設定する',
    'button.group.action': 'グループアクション',
    'button.delete': '削除',
    'button.login': 'ログイン',
    'button.renew.code': '更新',
    'button.configurations': '設定',
    'button.set.configurations': '構成を指定',
    'button.edit.versions': 'バージョン',
    'button.edit': '編集',
    'button.change.common.app': '共有アプリの編集',
    'button.delete.common.app': '共有アプリを削除',
    'button.turn.common.app': '共通化',
    'button.hints.enable': 'ツールチップを表示',
    'button.hints.disable': 'ツールチップを非表示',
    'button.show.password': 'パスワードを表示',
    'button.hide.password': 'パスワードを隠す',

    'question.impersonate.user': '"${customerName}" の管理者としてアプリケーションにログインしますか?',
    'question.change.user': 'ユーザー "${userName}" としてアプリケーションにログインしますか?',
    'question.delete.file': 'ファイル"${fileName}" を削除しますか?',
    'question.delete.customer': '"${customerName}" を削除しますか?',
    'question.delete.user': 'ユーザー "${username}" を削除しますか?',
    'question.delete.application': 'アプリケーション "${applicationName}" を削除しますか?',
    'question.delete.application.version': 'バージョン "${applicationVersion}" を削除しますか?',
    'question.delete.configuration': '構成 "${configurationName}" を削除しますか?',
    'question.delete.group': 'グループ "${groupName}" を削除しますか?',
    'question.delete.role': 'ロール "${roleName}" を削除しますか?',
    'question.delete.icon': 'アイコン「${iconName}」を削除しますか?',
    'question.delete.device.bulk': '選択したデバイスを削除しますか?',
    'question.delete.device': '"${deviceNumber}" のデバイスを削除しますか?',
    'question.exit.without.saving': '変更は保存されません。 とにかくこのページを離れますか?',
    'question.turn2common.application': 'アプリケーション "${applicationName}" を共有しますか?',
    'question.app.upgrade': 'アプリケーション "${v1}" を構成 "${v2}" の最新バージョンに更新しますか?',

    'error.application.setting.empty.app': 'アプリケーションを指定',
    'error.application.setting.empty.name': '名前を入力してください',
    'error.application.setting.empty.value': '値を指定してください',

    'error.icon.dimension.invalid': 'アイコンは正方形でなければなりません',
    'error.icon.empty.name': 'アイコンの名前を入力してください',
    'error.icon.empty.file': 'アイコンファイルをアップロード',
    'error.application.version.pkg.mismatch': 'ファイルのパッケージ ID (${actual}) がアプリケーション (${expected}) に対応していません',
    'error.empty.user': 'ユーザーを選択してください',
    'error.empty.user.name': 'ユーザー名を入力してください',
    'error.empty.user.login': 'ログイン情報を入力してください',
    'error.empty.user.role': '役割を選択してください',
    'error.empty.password': '新しいパスワードを入力してください',
    'error.empty.password.confirm': 'パスワードの確認を入力してください',
    'error.user.not.found': 'ユーザーが見つかりません',
    'error.email.not.configured': 'Eメールが設定されていません',
    'error.email.not.found': 'メールアドレスが設定されていません',
    'error.empty.group.name': 'グループ名を入力してください',
    'error.empty.configuration': '構成を指定してください',
    'error.empty.configuration.name': '構成名を入力してください',
    'error.empty.configuration.password': 'パスワードを入力してください',
    'error.empty.configuration.contentApp': 'コンテンツアプリケーションが指定されていません',
    'error.empty.group': 'デバイスを 1 つ以上のグループに追加する',
    'error.invalid.character': 'デバイス番号には記号 / ? & を含めることはできません',
    'error.invalid.configuration.mainApp': 'MDM 設定で、間違ったメイン アプリケーションが使用されています',
    'error.invalid.configuration.contentApp': 'MDM 設定で使用されている無効なコンテンツアプリケーション',
    'error.mismatch.password': 'パスワードとパスワードの確認は一致する必要があります',
    'error.empty.customer.name': '組織名を記入してください',
    'error.empty.customer.prefix': 'デバイス番号のプレフィックスを入力してください',
    'error.empty.customer.device.configuration': 'デバイス構成を選択',
    'error.empty.customer.duplicate.prefix': 'プレフィックスは既に使用されています',
    'error.duplicate.customer.name': '入力された組織は既に存在します。別の名前を試してください。',
    'error.duplicate.group.name': '入力されたグループは既に存在します。別の名前を試してください。',
    'error.duplicate.configuration.name': '入力された構成は既に存在します。別の名前を試してください。',
    'error.duplicate.device.number': 'この番号のデバイスは既に存在します',
    'error.internal.server': '内部サーバーエラー',
    'error.permission.denied': '実行する権限がありません',
    'error.request.failure': 'リクエストの失敗',
    'error.configuration.device.use': 'この構成は削除できません。デバイスで使用されています。「デバイス」からこの構成を使用しているデバイスの設定を変更してください。',
    'error.invalid.system.update.time': 'インストール間隔が無効です',
    'error.size.limit.exceeded': 'ストレージの制限を超えました',

    'error.configuration.file.empty.name': 'ファイル名を入力してください',
    'error.configuration.file.empty.desc': 'ファイルの説明を指定してください',
    'error.configuration.file.empty.path': 'デバイス上のパスを指定してください',
    'error.configuration.file.empty.file': 'ファイルをアップロードしてください',
    'error.configuration.file.empty.url': 'ファイルのURLを指定してください',

    'error.notfound.device': 'デバイスが見つかりません',
    'error.duplicate.device': '同じ番号のデバイスが既に存在します',
    'error.duplicate.login': 'ログイン済みのユーザーです',
    'error.duplicate.email': 'このメールアドレスは既に存在します',
    'error.duplicate.group': 'この名前のグループは既に存在します',
    'error.duplicate.application': 'このパッケージ ID とバージョンのアプリケーションは既に存在します',
    'error.recent.application.version.exists': '最新のアプリケーションバージョンが存在します',
    'error.common.application.access.prohibited': '共通アプリケーションの管理はスーパー管理者のみ許可されています',
    'error.application.config.reference.exists': 'アプリケーションは構成で使用されており、削除できません',
    'error.application.version.deletion.prohibited': 'バージョンが一意であるか、構成で使用されているため、削除できません',
    'error.duplicate.file': '同じ名前のファイルが既に存在します',
    'error.used.file': 'このファイルは使用されています',
    'error.version.exists': 'このアプリの同じバージョンが既に存在します',
    'error.duplicate.configuration': 'この名前の構成は既に存在します',
    'error.duplicate.role.name': '同じ名前のロールがすでに存在します',
    'error.empty.role.name': 'ロール名を指定してください',
    'error.duplicate.icon.name': '同じ名前のアイコンがすでに存在します',
    'error.notfound.customer.admin': '管理者アカウントが見つかりません',
    'error.apk.file.required': '拡張子が .apk または .xapk のファイルを選択してください',
    'error.apk.parse': 'ファイルの解析中にエラーが発生しました',
    'error.package.not.match': 'パッケージ ID が一致しません',
    'error.empty.app.name': 'アプリケーション名を入力してください',
    'error.empty.app.pkg': 'パッケージ ID を入力してください',
    'error.empty.app.url': 'URLを入力してください',
    'error.empty.app.iconText': 'アイコンのテキストを入力してください',
    'error.empty.app.version': 'アプリケーションのバージョンを入力してください',
    'error.notempty.group': 'このグループには１つ以上のデバイスが含まれています。削除することはできません。',
    'error.file.empty': '新しいファイルをアップロード',
    'error.file.deletion': 'サーバー上のファイルの削除中にエラーが発生しました',
    'error.file.save': 'サーバーにファイルを保存中にエラーが発生しました',
    'error.password.wrong': '無効なパスワード',
    'error.password.empty': 'パスワードが指定されていません',
    'error.password.weak': 'パスワードの品質が低い',
    'error.params.missing': 'パラメータがありません:',
    'error.empty.push.options': 'プッシュ通知オプションを選択してください',
    'error.app.name.exists': 'この名前の別のアプリケーションがすでに存在します。 一意の名前を指定してください。',

    'table.filtering.check.all': 'すべて選択',
    'table.filtering.uncheck.all': 'すべてキャンセル',
    'table.filtering.suffix.configuration': '設定',
    'table.filtering.suffix.group': 'グループ',
    'table.filtering.suffix.permission': '権限',
    'table.filtering.no.selected.configuration': '構成が選択されていません',
    'table.filtering.no.selected.group': 'グループが選択されていません',
    'table.filtering.no.selected.permission': '権限が選択されていません',

    'success.admin.created': '管理者アカウントが作成されました:\n ${adminCredentials}',
    'success.uploading.file': 'ファイルをサーバーにアップロードしています ...',
    'success.loading.devices': 'デバイスリストを読み込んでいます ...',
    'success.loading.customer': '顧客の詳細を読み込んでいます ...',
    'success.file.uploaded': 'ファイルが正常にアップロードされました。',
    'success.file.uploaded.need.save': 'ファイルが正常にアップロードされました。相対パスを入力し、[保存] をクリックします。',
    'success.settings.design.saved': 'デザイン設定が正常に保存されました',
    'success.settings.common.saved': 'デバイス テーブルの設定が正常に保存されました',
    'success.settings.saved': '設定が正常に保存されました',
    'success.settings.apiKey.saved': 'API キーが正常に保存されました',
    'success.settings.hints.enabled': 'ヒントを有効にしました',
    'success.settings.hints.disabled': 'ヒントを無効にしました',
    'success.configuration.saved': '構成が正常に保存されました',
    'success.operation.completed': '操作は正常に完了しました',
    'success.plugins.disabled': '設定が正常に保存されました',
    'success.config.update.notification': '構成更新コマンドがデバイスに送信されました',
    'success.config.update.device.app.settings.notification': 'アプリケーション設定を更新するコマンドがデバイスに送信されました。',

    'form.icon.title': 'アイコン',
    'form.icon.name': '名前',
    'form.icon.file': 'ファイル',

    'configuration.add.warning': '本当に空の構成を作成しますか? 必要なすべてのシステムアプリを手動で追加する必要があります。既存の構成をコピーして変更することを推奨します。',
    'configuration.remove.warning': '本当に最後の構成を削除しますか? 必要なシステムアプリの情報が失われます。',
    'form.configuration.title': '設定',
    'form.configuration.title.typical': '標準構成',
    'form.configuration.settings.auto.update': '自動更新',
    'form.configuration.settings.system.update': 'システムアップデート',
    'form.configuration.settings.system.update.default': 'デフォルト',
    'form.configuration.settings.system.update.immediate': '直ちに',
    'form.configuration.settings.system.update.scheduled': 'スケジュール済み',
    'form.configuration.settings.system.update.postponed': '延期',
    'form.configuration.settings.system.update.time': 'インストール時間',
    'form.configuration.settings.system.update.time.from': 'from:',
    'form.configuration.settings.system.update.time.to': 'to:',
    'form.configuration.settings.system.schedule.app.update': 'アプリの更新をスケジュールする',
    'form.configuration.settings.system.app.update.time': 'アプリの更新時間',
    'form.configuration.settings.download.updates': 'コンテンツをダウンロード',
    'form.configuration.settings.download.updates.unlimited': '制限なし',
    'form.configuration.settings.download.updates.limited': 'モバイル ネットワークで 3 回試行',
    'form.configuration.settings.download.updates.wifi': 'WiFi のみ',
    'form.configuration.settings.block.status.bar': 'ステータスバーのロック',
    'form.configuration.settings.block.status.bar.hint': 'この設定は推奨されておらず、Android 6 以下で適切に機能します。 新しいバージョンの Android でステータス バーをロックするには、キオスク モード (MDM 設定) を使用します。',
    'form.configuration.settings.mdm.kiosk.mode': 'キオスクモード',
    'form.configuration.settings.mdm.app.main': 'MDMアプリケーション',
    'form.configuration.settings.mdm.component.event.receiver': '管理レシーバークラス',
    'form.configuration.settings.mdm.component.event.receiver.placeholder': 'com.hmdm.launcher.AdminReceiverである必要があります',
    'form.configuration.settings.mdm.component.wifi.ssid': 'WiFi SSID',
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'WiFi SSID の登録 - 空のままにして手動で入力してください',
    'form.configuration.settings.mdm.component.wifi.password': 'WiFi パスワード',
    'form.configuration.settings.mdm.component.wifi.password.placeholder': '登録 WiFi パス - 空のままにして手動で入力してください',
    'form.configuration.settings.mdm.component.wifi.security': 'WiFi セキュリティ タイプ',
    'form.configuration.settings.mdm.component.wifi.notice': '注意: これらの WiFi 設定は初回登録のみに適用されます!',
    'form.configuration.settings.mdm.component.server.url': '新しいサーバーの URL',
    'form.configuration.settings.mdm.component.server.url.placeholder': '新しいMDM サーバーへの移行に使用',
    'form.configuration.settings.mdm.app.content': 'コンテンツアプリケーション',
    'form.configuration.settings.mdm.kiosk.home': 'ホームボタンを有効にする',
    'form.configuration.settings.mdm.kiosk.recents': '[最近] ボタンを有効にする',
    'form.configuration.settings.mdm.kiosk.notifications': '通知を有効にする',
    'form.configuration.settings.mdm.kiosk.system.info': 'ステータスバー情報を有効にする',
    'form.configuration.settings.mdm.kiosk.keyguard': '画面ロックを有効にする',
    'form.configuration.settings.mdm.kiosk.lock.buttons': '電源ボタンをロック',
    'form.configuration.settings.mdm.mobile.enrollment': 'モバイルデータを使用して登録',
    'form.configuration.settings.mdm.encrypt.device': 'デバイスストレージの暗号化',
    'form.configuration.settings.mdm.lock.safe.settings': 'ロックセーフ設定 (WiFi、GPS など)',
    'form.configuration.settings.mdm.permissive': '許可 (ロック解除) モード',
    'form.configuration.settings.mdm.kiosk.exit': 'キオスク終了ボタン',
    'form.configuration.settings.mdm.kiosk.screen': '画面は常にオン',
    'form.configuration.settings.mdm.allowed.classes': '許可されたアクティビティ',
    'form.configuration.settings.mdm.allowed.classes.placeholder': 'カンマ区切りのクラス、例: com.android.settings.homepage.SettingsHomepageActivity',
    'form.configuration.settings.mdm.restrictions': '制限',
    'form.configuration.settings.mdm.restrictions.placeholder': 'MDM 制限、コンマ区切り、例: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.launcher': 'ランチャーURLを上書き',
    'form.configuration.settings.mdm.launcher.placeholder': '非公開ネットワークへの登録用の代替ランチャーURL',
    'form.configuration.settings.mdm.misc': 'その他の QR コード エントリ',
    'form.configuration.settings.mdm.misc.placeholder': 'カンマ区切りのエントリ。例:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url': 'QRコードURL',
    'form.configuration.settings.mdm.hint': 'メインのアプリケーションとコンポーネントを選択してください',
    'form.configuration.apps.search.label': '検索対象:',
    'form.configuration.apps.sort.label': '並べ替え:',
    'form.configuration.apps.sort.byname': '名前順',
    'form.configuration.apps.sort.bypkg': 'ID別',
    'form.configuration.apps.no.apk': 'なし',
    'form.configuration.apps.show.systeam.apps': 'システムアプリケーションを表示',
    'form.configuration.apps.action.select': '(選択)',
    'form.configuration.apps.action.install': 'インストール',
    'form.configuration.apps.action.prohibit': 'ブロック',
    'form.configuration.apps.action.not.install': 'インストールしない',
    'form.configuration.apps.action.delete': '削除',
    'form.configuration.apps.action.permit': '許可',
    'form.configuration.apps.label.inherit': '継承',
    'form.configuration.apps.label.show': '表示',
    'form.configuration.apps.label.not.show': '隠す',
    'form.configuration.apps.edit.details': '追加パラメータ',
    'form.configuration.apps.keycode': 'キーコード',
    'form.configuration.apps.bottom': '一番下の行に表示',
    'form.configuration.apps.long.tap': 'ロングタップで設定',
    'form.configuration.apps.hint': 'ヒント: 構成からアプリのリンクを解除するには、アクション「ブロック」または「インストールしない」を選択してください。',
    'form.configuration.settings.design.use.default': 'デフォルトのデザインを使用',
    'form.configuration.settings.design.color.background': '背景色',
    'form.configuration.settings.design.color.background.placeholder': '色を選択',
    'form.configuration.settings.design.color.app.names': 'アプリケーション名の色',
    'form.configuration.settings.design.color.app.names.placeholder': '色を選択',
    'form.configuration.settings.design.background.image.url': '背景画像のURL',
    'form.configuration.settings.design.background.image.url.placeholder': '背景画像のURLを入力してください',
    'form.configuration.settings.design.icon': 'アイコンサイズ',
    'form.configuration.settings.design.icon.small': '小',
    'form.configuration.settings.design.icon.medium': '平均 (+ 20%)',
    'form.configuration.settings.design.icon.large': '大 (+ 40%)',
    'form.configuration.settings.design.desktop.header': 'デスクトップ タイトル',
    'form.configuration.settings.design.desktop.header.no': 'いいえ',
    'form.configuration.settings.design.desktop.header.deviceid': 'デバイス ID',
    'form.configuration.settings.design.desktop.header.description': '説明',
    'form.configuration.settings.design.desktop.header.custom': 'カスタムテンプレート',
    'form.configuration.settings.design.desktop.header.hint': 'このパラメーターがデバイスに送信されていることを確認してください (設定 - 一般および言語設定)',
    'form.configuration.settings.design.desktop.header.template': 'テンプレートを入力してください',
    'form.configuration.settings.design.desktop.header.template.placeholder': '変数を使用',
    'form.configuration.settings.design.display.status': '時間とバッテリーの状態を表示する',
    'form.configuration.settings.design.upload': 'アップロード',
    'form.configuration.settings.common.name': '名前',
    'form.configuration.settings.common.name.placeholder': '設定名を入力してください',
    'form.configuration.settings.common.desc': '説明',
    'form.configuration.settings.common.desc.placeholder': '構成の説明を入力してください',
    'form.configuration.settings.common.admin.pwd': 'ロック解除パスワード',
    'form.configuration.settings.common.admin.pwd.placeholder': 'デバイスのロック解除パスワードを入力してください',
    'form.configuration.settings.common.gps': 'GPS',
    'form.configuration.settings.common.gps.any': 'すべて',
    'form.configuration.settings.common.gps.off': '無効',
    'form.configuration.settings.common.gps.on': '有効',
    'form.configuration.settings.common.bluetooth': 'Bluetooth',
    'form.configuration.settings.common.wifi': 'Wi-Fi',
    'form.configuration.settings.common.mobile.data': 'モバイルデータ',
    'form.configuration.settings.common.usb.storage': 'USBストレージをブロック',
    'form.configuration.settings.common.brightness': '明るさを管理',
    'form.configuration.settings.common.brightness.none': 'なし',
    'form.configuration.settings.common.brightness.auto': '自動',
    'form.configuration.settings.common.brightness.manual': '値',
    'form.configuration.settings.common.brightness.value': '画面の明るさ',
    'form.configuration.settings.common.timeout': '画面のタイムアウトを管理する',
    'form.configuration.settings.common.timeout.value': '画面タイムアウト (秒)',
    'form.configuration.settings.common.volume.block': 'ボリュームをロック',
    'form.configuration.settings.common.volume.manage': 'ボリュームの管理',
    'form.configuration.settings.common.volume.value': 'ボリューム',
    'form.configuration.settings.common.timezone.mode': 'タイムゾーンの管理',
    'form.configuration.settings.common.timezone.mode.default': '管理しない',
    'form.configuration.settings.common.timezone.mode.auto': '自動',
    'form.configuration.settings.common.timezone.mode.manual': 'マニュアル',
    'form.configuration.settings.common.timezone': 'タイムゾーン',
    'form.configuration.settings.common.timezone.placeholder': '例: アメリカ/ロサンゼルス',
    'form.configuration.settings.common.timezone.link': 'タイムゾーンのリスト',
    'form.configuration.settings.common.no.network.warning': '警告! すべての接続チャネルをオフにしないでください。オフにすると、デバイスを管理できなくなります!',
    'form.configuration.settings.common.autostart.foreground': 'アプリをフォアグラウンドで自動起動',
    'form.configuration.settings.request.updates': 'ロケーション追跡',
    'form.configuration.settings.request.updates.donottrack': 'アクティブなトラッキングなし (サードパーティのアプリの位置データを使用)',
    'form.configuration.settings.request.updates.gps': 'GPSで位置を追跡',
    'form.configuration.settings.request.updates.wifi': 'Wi-Fi による位置情報の追跡 (Google サービスを有効にする必要があります)',
    'form.configuration.settings.request.updates.prompt.gps': 'GPSで位置を追跡するには、GPSを有効にする必要があります',
    'form.configuration.settings.request.updates.prompt.wifi': 'Wi-Fi で位置を追跡するには、Wi-Fi を有効にする必要があります',
    'form.configuration.settings.revoke.location.permission': '位置情報の許可がありません',
    'form.configuration.settings.revoke.location.permission.hint': '設定されている場合、MDM エージェントに位置情報の許可が付与されず、デバイスの位置を追跡できませんでした',
    'form.configuration.settings.apps.permissions': '他のアプリの権限',
    'form.configuration.settings.apps.permissions.grant': 'すべての権限を自動付与',
    'form.configuration.settings.apps.permissions.ask.location': 'すべて自動付与、ユーザーに位置情報の許可を求める',
    'form.configuration.settings.apps.permissions.deny.location': 'すべて自動付与、位置情報のパーミッションは付与しない',
    'form.configuration.settings.apps.permissions.ask.all': 'すべての権限についてユーザーに尋ねる',
    'form.configuration.settings.push.options': 'プッシュ通知',
    'form.configuration.settings.push.options.mqtt.worker': 'MQTT プロトコル (バッテリー節約)',
    'form.configuration.settings.push.options.mqtt.alarm': 'MQTTプロトコル',
    'form.configuration.settings.push.options.polling': 'HTTP ポーリング',
    'form.configuration.settings.push.options.mqtt.worker.hint' : 'デバイスがアクティブになると即座にプッシュ メッセージを配信します。 ただし、スリープ モードではメッセージが最大数時間遅れる場合があります。 このオプションは、スタンドアロン デバイスでは使用しないでください。 MQTT は TCP ポート 31000 を使用します。ファイアウォールで有効にしてください。',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT は、最小限のリソースしか消費しない軽量プロトコルです。MQTT は TCP ポート 31000 を使用するので、ファイアウォールで有効にしてください。',
    'form.configuration.settings.push.options.polling.hint': '長いポーリングでは HTTP 接続が持続し、サーバー リソースをさらに消費する可能性があります。HTTP(S) 以外の TCP ポートは必要ありません。',
    'form.configuration.settings.push.options.keepalive': 'キープアライブ時間',
    'form.configuration.settings.minute.1': '1 分',
    'form.configuration.settings.minutes.2': '2 分',
    'form.configuration.settings.minutes.3': '3 分',
    'form.configuration.settings.minutes.5': '5 分',
    'form.configuration.settings.minutes.10': '10 分',
    'form.configuration.settings.minutes.15': '15 分',
    'form.configuration.settings.password.mode': 'パスワード要件',
    'form.configuration.settings.password.mode.any': 'なし',
    'form.configuration.settings.password.mode.present': 'パスワードの提示',
    'form.configuration.settings.password.mode.easy': 'かんたん(6文字以上)',
    'form.configuration.settings.password.mode.moderate': 'モデレート (8 個以上の記号、文字、数字)',
    'form.configuration.settings.password.mode.strong': '強 (8+、大文字と小文字、数字、記号)',
    'form.configuration.settings.show.wifi': '接続エラー時のWiFi設定',
    'form.configuration.settings.use.default.launcher': 'バックグラウンド モード',
    'form.configuration.settings.use.default.launcher.hint': 'システム ランチャーを置き換えず、バックグラウンド MDM サービスのみを実行します。キオスク モードでは推奨されません。',
    'form.configuration.settings.disable.screenshots': 'スクリーン キャプチャを無効にする',
    'form.configuration.settings.orientation': '向きをロック',
    'form.configuration.settings.orientation.none': 'ロックしない',
    'form.configuration.settings.orientation.portrait': 'ポートレート',
    'form.configuration.settings.orientation.landscape': '横向き',
    'form.configuration.settings.files.default.path': 'デバイスのデフォルトパス',
    'form.configuration.files.search.label': '検索:',
    'form.configuration.files.action.upload': 'アップロード',
    'form.configuration.files.action.remove': '削除',
    'form.configuration.files.variables': '変数の内容',
    'form.configuration.files.variables.hint': '文字列DEVICE_NUMBER、IMEI、CUSTOM*はそれらの値に置き換えられます',

    'form.configuration.file.name': 'ファイル名',
    'form.configuration.file.select': 'ファイルを選択',
    'form.configuration.file.create': '(新しいファイルを作成)',
    'form.configuration.file.description': 'ファイルの説明',
    'form.configuration.file.description.placeholder': '便利なオプションです',
    'form.configuration.file.path': 'デバイス上のパス',
    'form.configuration.file.path.placeholder': 'ドライブへのパスを除外します。 /my-app/image.jpg',
    'form.configuration.file.url': 'URL',
    'form.configuration.file.url.placeholder': 'ファイルのみが外部リソースでホストされている場合',
    'form.configuration.file.file': 'ファイル',
    'form.configuration.file.action': 'アクション',
    'form.configuration.file.action.prompt.1': 'アップロード',
    'form.configuration.file.action.prompt.2': '削除',
    'form.configuration.file.remove.prompt.1': 'このファイルはデバイスと同期されなくなります',
    'form.configuration.file.remove.prompt.2': 'サーバーからファイルを削除',

    'form.password.title': 'パスワードの変更',
    'form.password.label.user': 'ユーザー',
    'form.password.label.password.new': '新しいパスワード',
    'form.password.label.password.new.placeholder': '新しいパスワードを入力してください',
    'form.password.label.password.confirm': '確認',
    'form.password.label.password.confirm.placeholder': '新しいパスワードをもう一度入力してください',
    'form.password.length': '最小の長さ: ${length}. ',

    'form.application.type': 'タイプ',
    'form.application.type.option.web': 'ウェブページ',
    'form.application.type.option.app': 'アプリケーション',
    'form.application.type.option.intent': 'システムアクション',
    'form.application.intent': 'アクション',
    'form.application.intent.placeholder': 'アクションを選択してください',
    'form.application.url.hint': 'ローカル ファイルとフォルダーへのリンクを作成するには、file:///storage/emulated/0/... を使用します',
    'form.application.pkg': 'パッケージ ID',
    'form.application.from.file': 'ファイルから決定',
    'form.application.pkg.title': 'APK ファイルをアップロードすると、パッケージ ID が自動的に決定されます。 手動で入力したパッケージ ID は、システム アプリにのみ必要です.',
    'form.application.pkg.placeholder': 'たとえば、com.android.camera',
    'form.application.disabled.arch': 'バージョン固有',
    'form.application.disabled.arch.title': 'さまざまな CPU アーキテクチャの APK を追加するには、[追加] をクリックするか、アプリのバージョン リストを開きます',
    'form.application.arch': 'ネイティブ コード',
    'form.application.arch.title': '一部のアプリには、特定の CPU アーキテクチャ向けに最適化されたコードが含まれています。 この場合、2 つの APK をアップロードする必要があります (armeabi-v7a および arm64-v8a アーキテクチャ用)',
    'form.application.arch.universal': 'なし (ユニバーサル APK)',
    'form.application.arch.armeabi': 'armeabi-v7a のネイティブ コード',
    'form.application.arch.arm64': 'arm64-v8a のネイティブ コード',
    'form.application.arch.no.split': 'ユニバーサル APK',
    'form.application.arch.split': '分割 APK',
    'form.application.arch.warning': 'この APK は ${arch} のみに最適化されており、すべてのデバイスで動作するとは限りません。 別の CPU アーキテクチャ用に最適化された別の APK をアップロードすることをお勧めします。 この APK をすべてのデバイスで使用するには、[ユニバーサル APK] を選択します。',
    'form.application.arch.success': 'このアプリには両方の CPU アーキテクチャの APK が含まれています',
    'form.application.version.exists': 'このバージョンの APK は既に存在します',
    'form.application.url.armeabi': 'armeabi-v7aのURL',
    'form.application.url.arm64': 'arm64-v8aのURL',
    'form.application.name': 'アプリケーション名',
    'form.application.name.title': 'リストにアプリ名が表示されます。 一意で有益な名前を使用することをお勧めします.',
    'form.application.name.placeholder': 'たとえば、カメラ (Android)',
    'form.application.version': 'バージョン',
    'form.application.version.placeholder': 'システム アプリの場合は 0',
    'form.application.version.title': 'APK ファイルをアップロードすると、パッケージのバージョンが自動的に決定されます。 システム アプリの場合は 0 に設定します。',
    'form.application.version.code': 'バージョンコード',
    'form.application.version.code.exists': '同じコードのバージョンが既に存在します。 この問題をアプリ開発者に報告してください。',
    'form.application.system': 'システム',
    'form.application.system.title': 'システム アプリケーションはデバイスにプリインストールされており、URL やファイルは必要ありません。 特定のシステム パッケージを有効にする必要がある場合にのみ、このフラグを設定してください。',
    'form.application.run.after.install': 'インストール後に実行',
    'form.application.run.after.install.title': 'バックグラウンド サービスを使用するアプリケーションは、少なくとも 1 回はフォアグラウンドで開始する必要があります。',
    'form.application.run.at.boot': '起動時に実行',
    'form.application.run.at.boot.title': '起動後にアプリをフォアグラウンドで実行する必要がある場合は、このフラグを設定します。 このフラグはバックグラウンド プロセスには影響しません.',
    'form.application.url': 'URL',
    'form.application.url.title': 'アプリが外部リソースでホストされている場合にのみ、URL を入力する必要があります。 以下のフィールドを使用して APK ファイルをアップロードすることをお勧めします。',
    'form.application.url.disabled': 'URLはバージョンごとに設定されています。 URLを変更するには、このウィンドウを閉じて「バージョン」アイコンをクリックしてください。',
    'form.application.file': 'ファイル',
    'form.application.auto.update': '自動更新',
    'form.application.auto.update.title': 'アプリがインストールされているすべての構成を更新するには、このフラグを設定します。 アプリが安定していることを 100% 確信している場合にのみ使用してください。',
    'form.application.showLabel': 'アイコンを表示',
    'form.application.showLabel.title': 'このフラグは、アプリのアイコンをランチャーに表示するかどうかを示します。 このオプションは設定で上書きされる可能性があります.',
    'form.application.use.kiosk': 'キオスクブラウザで開く',
    'form.application.use.kiosk.title': 'アドレスを変更せずにキオスク ブラウザで Web ページを開きたい場合は、このフラグを設定してください',
    'form.application.iconText': 'アイコン テキスト',
    'form.application.iconText.placeholder': '(デフォルト)',
    'form.application.versions.title': 'アプリケーションのバージョン',
    'form.application.icon': 'アイコン',
    'form.application.icon.default': '(デフォルト)',
    'form.application.icon.add': 'アイコンを追加',

    'form.application.setting.app': 'アプリケーション',
    'form.application.setting.app.placeholder': 'アプリケーションを選択',
    'form.application.setting.name': '属性',
    'form.application.setting.value': '値',
    'form.application.setting.comment': 'コメント',
    'form.application.setting.type': 'タイプ',
    'form.application.setting.readonly': 'デバイス上で変更しません',

    'form.application.configurations.app': 'アプリケーション',
    'form.application.configurations.configs': '設定',

    'form.configuration.copy.new.name': '新しい名前',
    'form.configuration.copy.new.name.placeholder': '新しい設定名を入力してください',

    'form.customer.name': '名前',
    'form.customer.name.placeholder': '組織名を入力してください',
    'form.customer.admin.name': '管理者名',
    'form.customer.firstname.placeholder': 'ファーストネーム',
    'form.customer.lastname.placeholder': '苗字',
    'form.customer.language': '言語',
    'form.customer.language.placeholder': '英語の場合は空のままにするか、2 つの小文字を入力します',
    'form.customer.apiKey': 'API キー',
    'form.customer.apiKey.placeholder': 'API キーを入力してください',
    'form.customer.prefix': 'プレフィックス',
    'form.customer.prefix.placeholder': 'デバイス番号のプレフィックスを入力してください',
    'form.customer.device.configuration': 'デバイス構成',
    'form.customer.desc': '説明',
    'form.customer.desc.placeholder': '組織の説明を入力してください',
    'form.customer.copy.configuration': '構成のコピー',
    'form.customer.copy.design': 'コピーデザイン',
    'form.customer.type': '顧客タイプ',
    'form.customer.status': '顧客ステータス',
    'form.customer.expiry.time': '有効期限',
    'form.customer.device.limit': '端末制限',
    'form.customer.size.limit': '保管制限',
    'form.customer.size.limit.placeholder': 'サイズ (MB)',

    'form.device.number': '番号',
    'form.device.number.locked': '前回の番号変更が完了していないため、番号を変更できません。',
    'form.device.migration.warning': 'デバイス番号が変更されます。 デバイスの電源が入っていてオンラインであることを確認してください。',
    'form.device.number.hint': '特殊文字を使用しないでください',
    'form.device.desc': '説明',
    'form.device.groups': 'グループ',
    'form.device.config': '構成',
    'form.device.imei': 'IMEI',
    'form.device.phone.number': '電話番号',

    'form.update.device.config': '構成',
    'form.update.device.action': 'グループアクション',
    'form.device.set.group': 'グループに追加',
    'form.device.clear.group': 'グループから削除',

    'form.file.file': 'ファイル',
    'form.file.name': 'ファイル名',
    'form.file.description': '説明（オプション）',
    'form.file.external': '外部',
    'form.file.external.title': 'ファイルをアップロードする代わりに、外部リソースのURLを指定することもできます。',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': '外部リソース上のファイルURL',
    'form.file.path': 'サーバー上のパス',
    'form.file.device.path': 'デバイス上のパス',
    'form.file.device.path.placeholder': '/storage/emulated/0からの相対パス',
    'form.file.deleted': '削除済み',
    'form.file.copy.link': 'コピーリンク: ${link}',
    'form.file.configurations.file': 'ファイル',
    'form.file.configurations.configs': '構成',
    'form.file.configurations.upload': 'アップロード',
    'form.file.path.placeholder': '"/files/" などの相対パスを入力してください',
    'form.file.available': '利用可能なスペース: ${space} Mb',

    'form.file.apps.name': 'アプリケーション名',
    'form.file.apps.pkg': 'パッケージ ID',
    'form.file.apps.version': 'バージョン',

    'form.group.name': '名前',
    'form.group.name.placeholder': 'グループの名前を入力してください',

    'form.role.name': '名前',
    'form.role.name.placeholder': 'ロールの名前を入力してください',
    'form.role.permissions': '権限',

    'form.user.login': 'ログイン',
    'form.user.login.placeholder': 'ユーザーのログイン情報を入力してください',
    'form.user.name': '名前',
    'form.user.name.placeholder': '姓名',
    'form.user.email': 'Eメール',
    'form.user.email.placeholder': 'メールアドレスを入力してください',
    'form.user.role': '役割',
    'form.user.all.devices.available': 'すべてのデバイスが利用可能です',
    'form.user.available.groups': '利用可能なデバイスグループ',
    'form.user.all.configs.available': 'すべての設定が利用可能です',
    'form.user.available.configs': '利用可能な構成',
    'form.user.password.new': '新しいパスワード',
    'form.user.password': 'パスワード',
    'form.user.password.new.placeholder': '新しいパスワードを入力してください',
    'form.user.password.confirm': '確認',
    'form.user.password.confirm.placeholder': '新しいパスワードをもう一度入力してください',

    'form.settings.hints.title': 'ヒント',

    'form.settings.plugins.title': '使用プラグイン',

    'form.settings.common.title': 'デバイス テーブル ビュー',
    'form.settings.common.visible.columns': '「デバイス」テーブルの表示列',
    'form.settings.common.status': 'ステータス',
    'form.settings.common.role': 'ユーザーの役割',
    'form.settings.common.date': '最終オンライン日付',
    'form.settings.common.device.number': 'デバイス番号',
    'form.settings.common.imei': 'IMEI',
    'form.settings.common.phone.number': '電話番号',
    'form.settings.common.phone.model': '電話モデル',
    'form.settings.common.status.permissions': '権限ステータス',
    'form.settings.common.status.installation': 'インストール状況',
    'form.settings.common.status.files': 'ファイルのステータス',
    'form.settings.common.config': '設定',
    'form.settings.common.desc': '説明',
    'form.settings.common.group': 'グループ',
    'form.settings.common.launcher.version': 'ランチャーのバージョン',
    'form.settings.common.battery.level': 'バッテリー残量',
    'form.settings.common.default.launcher': '背景',
    'form.settings.common.mdm.mode': 'MDM モード',
    'form.settings.common.kiosk.mode': 'キオスクモード',
    'form.settings.common.android.version': 'Androidのバージョン',
    'form.settings.common.enrollment.date': '入学日',
    'form.settings.common.serial': 'シリアル番号',
    'form.settings.common.publicip': 'IPアドレス',

    'form.settings.design.title': 'デフォルトのデザイン',
    'form.settings.design.color.font': '背景色',
    'form.settings.design.color.font.placeholder': '色を選択',
    'form.settings.design.color.app.names': 'アプリケーション名の色',
    'form.settings.design.color.app.names.placeholder': '色を選択',
    'form.settings.design.url.background.image': '背景画像のURL',
    'form.settings.design.url.background.image.placeholder': '背景画像のURLを入力してください',
    'form.settings.design.size.icon': 'アイコンサイズ',
    'form.settings.design.size.icon.small': '小',
    'form.settings.design.size.icon.medium': '平均 (+ 20%)',
    'form.settings.design.size.icon.large': '大 (+ 40%)',
    'form.settings.design.desktop.header': 'デスクトップ タイトル',
    'form.settings.design.desktop.header.no': 'いいえ',
    'form.settings.design.desktop.header.device.id': 'デバイス ID',

    'form.settings.lang.title': '言語設定',
    'form.settings.lang.use.default': 'デフォルトの言語を使用',
    'form.settings.lang.use': '言語を使用',
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.vi': 'Tiếng Việt',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title': 'その他の設定',
    'form.settings.misc.phone.format': '電話番号の形式',
    'form.settings.misc.phone.format.placeholder': '+9 (999) 999-99-99',
    'form.settings.misc.custom.property.name.1': 'カスタム プロパティ #1',
    'form.settings.misc.custom.property.name.2': 'カスタム プロパティ #2',
    'form.settings.misc.custom.property.name.3': 'カスタム プロパティ #3',
    'form.settings.misc.custom.property.multiline': '複数行',
    'form.settings.misc.custom.property.send': 'デバイスに送信',
    'form.settings.misc.custom.property.name.placeholder': 'カスタム プロパティの名前を入力してください',
    'form.settings.misc.create.new.devices': '初回アクセス時にデバイスを追加',
    'form.settings.misc.new.device.config': '新しいデバイス構成',
    'form.settings.misc.new.device.group': '新しいデバイス グループ',
    'form.settings.misc.send.description': 'デバイスに説明を送信',
    'form.settings.misc.password.length': '最小限のパスワード長',
    'form.settings.misc.password.strength': 'パスワードの強度',
    'form.settings.misc.password.none': '指定なし (任意の文字)',
    'form.settings.misc.password.alphanumeric': '小文字と大文字、数字',
    'form.settings.misc.password.specialchar': '小文字と大文字、数字、特殊文字',
    'form.settings.misc.password.reset': 'ユーザーはパスワードをリセットする必要があります',
    'form.settings.misc.idle.logout': 'アイドル時にログアウト',
    'form.settings.misc.idle.logout.never': '決して',
    'form.settings.misc.idle.logout.1': '5 分',
    'form.settings.misc.idle.logout.2': '10 分',
    'form.settings.misc.idle.logout.3': '30 分',
    'form.settings.misc.idle.logout.4': '1 時間',
    'form.settings.security.title': 'セキュリティ設定',

    'idle.logout.message': '非アクティブのため ${sec} 秒後にサインアウトされます',
    'idle.logout.resume': 'ここにいます!',

    'form.settings.groups.title': 'グループ',
    'form.settings.groups.search.placeholder': 'グループ検索',

    'form.settings.users.title': 'ユーザー',
    'form.settings.users.search.placeholder': '検索ユーザー',

    'form.settings.roles.title': 'ユーザーロール',

    'form.settings.icons.title': 'アイコン',
    'form.settings.icons.search.placeholder': 'アイコンを検索',

    'form.qr.device.number': 'デバイス番号',
    'form.qr.auto.create': '存在しない場合はデバイスリストに追加',
    'form.qr.number.use': 'デバイス番号の割り当て',
    'form.qr.number.use.request': 'ユーザー値',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': 'シリアル番号',
    'form.qr.number.hint': 'デバイス番号をクリアして、自動デバイス番号割り当てを有効にします',
    'form.qr.groups': 'グループに追加',
    'form.qr.button.json': 'JSONを取得',
    'form.qr.device.number.placeholder': 'デバイスIDを入力してください...',
    'form.qr.code.image.alt': 'QRコード',

    'form.password.reset.title': '新しいパスワードを設定してください',
    'form.password.reset.invalid': '申し訳ありませんが、このパスワードリセットリンクは無効です',
    'form.password.reset.submit': 'パスワードを設定',

    'form.two.factor.auth.title': '二要素認証',
    'form.two.factor.auth.hint': 'サインアップを完了するには、モバイル デバイスに認証アプリをインストールし、QR コードをスキャンし、確認コードを生成して入力してください。',
    'form.two.factor.auth.code.invalid': '確認コードが無効です!',
    'form.two.factor.auth.code': '検証コード',
    'form.two.factor.auth.code.hint': '認証アプリからの 6 桁のコード',
    'form.two.factor.auth.code.error': 'コードは 6 桁の数字である必要があります',
    'form.two.factor.auth.verify': '検証',
    'form.two.factor.auth.settings.hint': '2 要素認証を設定するには、モバイル デバイスに Authenticator アプリをインストールし、QR コードをスキャンし、確認コードを生成して入力してください。',
    'form.two.factor.auth.set': '2 要素認証がオンになっています',
    'form.two.factor.auth.reset': '2 要素認証はオフになっています',
    'form.two.factor.auth.off.confirm': '二要素認証をオフにしますか? 再度オンにすると、すべての認証子が無効になります。',

    'form.profile.title': 'パスワードの変更',
    'form.profile.password.old': '現在のパスワード',
    'form.profile.password.old.placeholder': '現在のパスワードを入力してください',
    'form.profile.password.new': '新しいパスワード',
    'form.profile.password.new.placeholder': '新しいパスワードを入力してください',
    'form.profile.password.confirm': '確認',
    'form.profile.password.confirm.placeholder': '新しいパスワードをもう一度入力してください',

    'tab.customers': '組織',
    'tab.common.applications': '共有アプリケーション',

    'tab.devices': 'デバイス',
    'tab.applications': 'アプリケーション',
    'tab.configurations': '構成',
    'tab.files': 'ファイル',
    'tab.default.design': 'デフォルトのデザイン',
    'tab.common.settings': 'デバイス テーブル ビュー',
    'tab.users': 'ユーザー',
    'tab.roles': '役割',
    'tab.groups': 'グループ',
    'tab.icons': 'アイコン',
    'tab.language': '一般および言語設定',
    'tab.license': 'ライセンス',
    'tab.hints': 'ヒント',
    'tab.plugins': 'プラグイン',

    'tab.configeditor.common.settings': '共通設定',
    'tab.configeditor.design.settings': 'デザイン設定',
    'tab.configeditor.applications': 'アプリケーション',
    'tab.configeditor.mdm.settings': 'MDM設定',
    'tab.configeditor.app.settings': 'アプリケーション設定',
    'tab.configeditor.files': 'ファイル',

    'search.placeholder.file': '検索ファイル',
    'search.placeholder.configuration': '設定を検索',
    'search.placeholder.customer': '組織を検索',
    'search.placeholder.application': 'アプリケーションを検索',
    'search.placeholder.application.setting': 'アプリケーション設定を検索',
    'search.placeholder.device': 'デバイスを検索',
    'search.placeholder.address': '住所検索',
    'search.placeholder.point': 'サイト検索',
    'search.placeholder.message': 'メッセージ検索',
    'search.placeholder': '検索 ...',
    'search.placeholder.from': 'From ...',
    'search.placeholder.to': 'To ...',
    'search.placeholder.user': 'ユーザー名を入力してください',

    'table.heading.customer.name': '名前',
    'table.heading.customer.desc': '説明',
    'table.heading.customer.registration.time': '登録済み',
    'table.heading.customer.last.login.time': '最終ログイン',
    'table.heading.customer.actions': 'アクション',
    'table.heading.customer.type': 'タイプ',
    'table.heading.customer.expiry.time': '期限切れ',
    'table.heading.customer.device.limit': '制限',
    'table.heading.customer.status': 'ステータス',

    'customer.new': '新規',
    'customer.active': 'アクティブ',
    'customer.need.followup': 'フォローアップが必要です',
    'customer.followup.sent': 'フォローアップを送信しました',
    'customer.internal.test': '内部テスト',
    'customer.developer': '開発者',
    'customer.difficult': '難しい',
    'customer.pause': '一時停止',
    'customer.inactive': 'サインインなし',
    'customer.abandon': '放棄された',
    'customer.onpremise': 'オンプレミストライアル',
    'customer.denial': '拒否',
    'customer.client': 'クライアント',

    'table.heading.configuration.name': '名前',
    'table.heading.configuration.desc': '説明',
    'table.heading.configuration.actions': 'アクション',

    'table.heading.application.setting.app.pkg': 'パッケージID',
    'table.heading.application.setting.app.name': 'アプリケーション名',
    'table.heading.application.setting.name': '属性',
    'table.heading.application.setting.value': '値',
    'table.heading.application.setting.comment': 'コメント',
    'table.heading.application.setting.lastUpdate': '作成日',

    'table.heading.file.url': 'URL',
    'table.heading.file.devicepath': 'デバイス上のパス',
    'table.heading.file.description': 'ファイルの説明',
    'table.heading.file.action': 'アクション',
    'table.heading.file.lastUpdate': '作成日',

    'table.heading.application.pkg': 'パッケージ ID',
    'table.heading.application.name': 'アプリケーション名',
    'table.heading.application.version': 'バージョン',
    'table.heading.application.url': 'URL',
    'table.heading.application.label': 'アイコン',
    'table.heading.application.actions': 'アクション',
    'table.heading.application.order': '注文',

    'table.heading.device.status': 'ステータス',
    'table.heading.device.date': '日付',
    'table.heading.device.device.number': 'デバイス番号',
    'table.heading.device.imei': 'IMEI',
    'table.heading.device.phone.number': '電話番号',
    'table.heading.device.phone.model': '電話モデル',
    'table.heading.device.status.permissions': '許可ステータス',
    'table.heading.device.status.installation': 'インストール状況',
    'table.heading.device.status.files': 'ファイルの状態',
    'table.heading.device.configuration': '設定',
    'table.heading.device.desc': '説明',
    'table.heading.device.group': 'グループ',
    'table.heading.device.launcher.version': 'ランチャーのバージョン',
    'table.heading.device.battery.level': 'バッテリー残量',
    'table.heading.device.default.launcher': '背景',
    'table.heading.device.mdm.mode': 'MDM モード',
    'table.heading.device.kiosk.mode': 'キオスクモード',
    'table.heading.device.android.version': 'Android のバージョン',
    'table.heading.device.enrollment.date': '登録済み',
    'table.heading.device.serial': 'シリアル番号',
    'table.heading.device.publicip': 'IPアドレス',
    'table.heading.device.actions': 'アクション',

    'table.heading.group.name': '名前',
    'table.heading.group.actions': 'アクション',

    'table.heading.role.name': '名前',
    'table.heading.role.actions': 'アクション',

    'table.heading.file.name': 'ファイル名',
    'table.heading.file.description': '説明',
    'table.heading.file.device.path': 'デバイス上のパス',
    'table.heading.file.update.time': '更新時刻',
    'table.heading.file.external': '外部',
    'table.heading.file.variable': '変数',
    'table.heading.file.remove': '削除',
    'table.heading.file.remove.hint': 'デバイスストレージからファイルを強制的に削除します',
    'table.heading.file.path': 'パス',
    'table.heading.file.address': 'アドレス',
    'table.heading.file.size': 'サイズ',
    'table.heading.file.actions': 'アクション',

    'table.heading.users.login': 'ログイン',
    'table.heading.users.name': '名前',
    'table.heading.users.role': '役割',
    'table.heading.users.actions': 'アクション',

    'table.heading.common.apps.customer': '組織',
    'table.heading.common.apps.pkg': 'パッケージ ID',
    'table.heading.common.apps.name': 'アプリケーション名',
    'table.heading.common.apps.version': 'バージョン',
    'table.heading.common.apps.url': 'URL',
    'table.heading.common.apps.label': 'アイコン',
    'table.heading.common.apps.actions': 'アクション',

    'notfound.devices': '表示するデバイスがありません.',
    'notfound.files':' ファイル リストが空です。',
    'notfound.configurations': '設定が見つかりませんでした.',
    'notfound.customers': '組織が見つかりません。',
    'notfound.common.apps': '表示するアプリケーションがありません。',
    'notfound.applications': 'アプリケーションが見つかりません',
    'notfound.groups':' グループが見つかりません。 別のクエリを試してください。',
    'notfound.users':' ユーザーが見つかりません。 別のクエリを試してください。',
    'notfound.apps.for.display': '表示するアプリケーションがありません。',
    'notfound.app.versions.for.display': '表示するバージョンがありません。',
    'notfound.roles':'役割リストが空です。',
    'notfound.icons':'アイコンリストが空です。',

    'format.date.header': 'HH:mm dd/MM/yyyy',

    'menu.about': '概要',
    'menu.profile': 'プロフィール',
    'menu.panel.master': 'マスターパネル',
    'menu.panel.main': 'メインパネル',
    'menu.logout': 'ログアウト',
    'menu.functions': '関数',
    'menu.settings': '設定',
    'menu.show.hints': 'ヒントを表示',

    'plugin.name.not.specified': '<< 関数名が指定されていません >>',

    'breadcrumb.summary': '概要',
    'breadcrumb.devices': 'デバイス',
    'breadcrumb.applications': 'アプリケーション',
    'breadcrumb.configurations': '設定',
    'breadcrumb.files': 'ファイル',
    'breadcrumb.default.design': 'デフォルトでデザイン',
    'breadcrumb.common.settings': 'デバイス テーブル ビュー',
    'breadcrumb.language.settings': '言語とその他の設定',
    'breadcrumb.license.settings': 'ライセンス',
    'breadcrumb.users': 'ユーザー',
    'breadcrumb.roles': '役割',
    'breadcrumb.groups': 'グループ',
    'breadcrumb.hints': 'ヒント',
    'breadcrumb.plugins': 'プラグイン',
    'breadcrumb.config.details': '詳細',
    'breadcrumb.application.versions': 'バージョン',

    'app.name': 'Headwind MDM',
    'app.vendor.name':"h-mdm.com",
    'app.vendor.link':"https://h-mdm.com",
    'app.description': 'is the open source mobile device management system',
    'app.title': '${appName} Web パネル',

    'box.show.my.apps.only': '自分のアプリケーションのみを表示',
    'configuration.app.version.upgrade.message': 'インストール済みバージョン ${installedVersion}、利用可能なバージョン ${latestVersion}',

    'about.line.1': '${appName} コントロールパネル',
    'about.line.2': 'Android 向けエンタープライズランチャー',
    'about.line.3': 'バージョン ${versionNumber}',
    'about.line.4': 'インストール済みプラグイン',

    'common.app.clarification': 'This application is public and not available for editing. To add another version of this app, please contact the administrator.',

    'qrcode.help.line1': '管理 (企業) モードで Android デバイス (バージョン 7 以降) をセットアップするには:',
    'qrcode.help.line2': 'デバイスを工場出荷時の設定にリセット',
    'qrcode.help.line3': '開始画面の任意の場所を 7 回タップします (QR コード スキャンモードで設定します)',
    'qrcode.help.line4': 'デバイスの指示に従ってください: 条件に同意し、Wi-Fi に接続し、この QR コードをスキャンしてください',
    'qrcode.help.line5': 'QR コードには ${appName} のデバイス ID が含まれている場合があります (モバイル デバイスで入力する必要はありません)。 デバイス ID を QR コードに埋め込むには、この画面でデバイス ID を入力し、[更新] をクリックします。',

    'form.configuration.app.version.select.select.title': 'インストールするバージョンを選択してください',
    'form.configuration.app.version.select.version.check.off': 'バージョンチェックを無効にする',
    'form.configuration.app.version.select.upgrade.warning': 'アプリケーション"${v1}"を構成"${v2}"のバージョン"${v3}"にアップグレードしますか?',
    'form.configuration.app.version.select.downgrade.warning': 'バージョンをダウングレードします すべてのデバイスでこれらのアプリケーションをすべて削除してください! アプリケーションのバージョン"${v1}"をバージョン"${v2}"にダウングレードしますか? ',

    'hint.step.1': 'ここをクリックして、デバイスの登録を開始してください',
    'hint.step.2': 'ここをクリックして QR コードを開きます',
    'hint.step.3': 'ここをクリックして、デバイスで QR コード スキャナーを開く方法を確認してください',
    'hint.step.4': '「デバイス」タブで利用可能なデバイス ID を見つけます。 「更新」をクリックして QR コードに含めます。',

    'ie.browser.notice.1': 'Internet Explorer はサポートされていません。',
    'ie.browser.notice.2': '${appName} を使用するための推奨ブラウザ - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop"> クローム</a>.',

    'form.resolved.duplicate.pkg.text1': 'パッケージ ID "${pkg}" は、以下のアプリケーションで既に使用されています。',
    'form.resolved.duplicate.pkg.text2': '新しいアプリケーションを追加しますか、それとも既存のアプリケーションの新しいバージョンを追加しますか?',
    'form.resolved.duplicate.pkg.text3': 'の新しいバージョン',
    'form.resolved.duplicate.pkg.text4': 'パッケージ ID "${pkg}" はアプリケーション ${apps} で既に使用されています',
    'form.resolved.duplicate.pkg.text5': '本当にパッケージ ID を変更しますか?',

    'tooltip.usage.byconfigurations': '構成で使用',
    'tooltip.usage.byapps': 'アプリケーションで使用',
    'tooltip.usage.byicons': 'アイコンで使用',

    'form.devices.label.params.more': 'その他のパラメーター',
    'form.devices.label.params.less': '少ないパラメータ',
    'form.devices.label.installation.status': 'インストールステータス',
    "format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
    "format.devices.date.datePicker": "dd-MM-yyyy",
    'form.devices.fast.search': '番号による高速検索',

    'form.devices.selection.install.status.default': 'インストール状況 ...',
    'form.devices.selection.install.status.all': 'すべて',
    'form.devices.selection.install.status.success': '成功',
    'form.devices.selection.install.status.version.mismatch': 'バージョンの不一致',
    'form.devices.selection.install.status.failure': '失敗',
    'form.devices.selection.imei.changed': 'IMEI が変更されています',

    'search.placeholder.launcher.version': 'ランチャーのバージョン',
    'error.date.range.invalid': '日付間隔が無効です',

    'form.selection.status.any': '任意の値',
    'form.selection.status.all': 'すべて',
    'form.selection.status.yes': 'はい',
    'form.selection.status.no': 'いいえ',

    'form.devices.selection.status': 'ステータス ...',
    'form.devices.selection.online': 'オンライン',
    'form.devices.selection.offline': 'オフライン',
    'form.devices.selection.number': '数字を入力してください',

    'form.devices.selection.online.status.custom': '時間を入力してください',
    'form.devices.selection.online.status.1': '15 分',
    'form.devices.selection.online.status.2': '30 分',
    'form.devices.selection.online.status.3': '1時間',
    'form.devices.selection.online.status.4': '2時間',
    'form.devices.selection.online.status.5': '6時間',
    'form.devices.selection.online.status.6': '1 日',
    'form.devices.selection.online.status.7': '2 日',
    'form.devices.selection.online.status.8': '3 日',
    'form.devices.selection.online.status.9': '1週間',
    'form.devices.selection.online.status.10': '1ヶ月',

    'form.devices.selection.online.status.label': '分',
    'form.devices.status.ago': '前',
    'form.devices.status.minutes': 'm',
    'form.devices.status.hours': 'h',
    'form.devices.status.days': 'd',
    'form.devices.status.weeks': '週',
    'form.devices.status.months': '月',
    'form.devices.status.years': '年',

    'customer.type.demo': 'デモ',
    'customer.type.small': 'プロフェッショナル',
    'customer.type.corporate': 'エンタープライズ',
    'customer.type.master': 'プライマリ',

    'customer.type.options.all': 'すべてのタイプ',
    'customer.status.options.all': 'すべてのステータス',

    'account.expiring': 'あなたのアカウントは ${days} 日で期限切れになります。 アカウントを更新するには、販売者に連絡してください。',
    'account.expired.short': 'あなたのアカウントは期限切れです!',
    'account.expired': 'あなたのアカウントは期限切れです。 アカウントを更新するには、販売者に連絡してください。',
    'device.limit.achieved': '制限に達したため、デバイスを追加できません。 一部のデバイスを削除するか、販売者に連絡してデバイスの制限を延長してください.',

    'menu.updates': 'アップデートを確認',
    'updates.title': 'アップデート',
    'updates.disabled.custom': 'カスタム バージョン、手動で更新してください',
    'updates.disabled.not_master': 'ホスティング プロバイダーに更新を依頼する',
    'updates.disabled.multiple': 'アプリのバージョンが複数あります。手動で更新してください',
    'updates.disabled.error': '内部サーバーエラー',
    'updates.disabled.download': 'アップデートのダウンロード中にエラーが発生しました',
    'updates.application': '応用',
    'updates.current.version': '現行版',
    'updates.available.version': '利用可能なバージョン',
    'updates.downloaded': 'ダウンロード済み',
    'updates.auto.update': 'モバイルアプリを自動的に更新します (本番環境では注意して使用してください!)',
    'updates.enable.stats': 'システム パフォーマンスを向上させるために、サービス プロバイダーに使用統計を送信する',
    'updates.get': 'アップデートを入手する',
    'updates.checking': 'アップデートの確認...',
    'updates.getting': 'アップデートを取得しています...',
    'updates.success': 'アップデート完了',
    'updates.web.hint': 'Web アプリの更新を完了するには、SSH コンソールでシェル スクリプト「/opt/hmdm/update-web-app.sh」を実行します。',

    'permission.edit_device_app_settings': 'デバイス固有のアプリ設定を管理する',
    'permission.plugins_customer_access_management': '利用可能なプラグインを管理する',
    'permission.plugin_audit_access': '監査ログを表示する',
    'permission.plugin_contacts_access': '連絡先を管理する',
    'permission.plugin_deviceexport_access': 'デバイスをエクスポートする',
    'permission.plugin_deviceimport_access': 'デバイスをインポートする',
    'permission.plugin_deviceinfo_access': 'デバイスの詳細情報を表示する',
    'permission.plugin_devicelocations_access': 'マップ上でデバイスを表示する',
    'permission.plugin_devicelocations_settings_access': 'マップ プラグインを構成する',
    'permission.plugin_devicelog_access': 'デバイスを表示するログ',
    'permission.plugin_devicereset_access': 'デバイスのリセットと再起動',
    'permission.plugin_licensing_access': 'ライセンスへのアクセス（非推奨）',
    'permission.plugin_messaging_send': 'メッセージの送信',
    'permission.plugin_messaging_delete': '送信したメッセージの削除',
    'permission.plugin_photo_remove_photo': '写真の削除',
    'permission.settings': '設定の管理',
    'permission.configurations': '構成の表示',
    'permission.edit_devices': 'デバイス情報の編集',
    'permission.edit_device_desc': 'デバイスの説明の編集',
    'permission.enroll_devices': 'QRコードでデバイスを登録する',
    'permission.plugin_apuppet_access': 'リモート コントロール',
    'permission.plugin_knox_access': 'Knoxプラグイン',
    'permission.add_config': '設定の追加',
    'permission.copy_config': '設定の複製',
    'permission.plugin_openvpn_access': 'OpenVPN プラグイン',
    'permission.plugin_photo_access': '写真プラグイン',
    'permission.push_api': 'プッシュ API へのアクセス',
    'permission.plugin_urlfilter_access': 'URL フィルタリング',
    'permission.plugin_push_send': 'プッシュ メッセージの送信',
    'permission.plugin_push_delete': 'プッシュ メッセージの削除',
    'permission.get_updates': '更新の確認',
    'permission.plugin_xtra_access': 'プレミアム バージョンのリクエスト',
    'permission.applications': 'アプリケーションの表示',
    'permission.edit_applications': '管理アプリケーション',
    'permission.edit_application_versions': 'アプリケーション バージョンの管理',
    'permission.files': 'ファイルの表示',
    'permission.edit_files': 'ファイルの管理',

    'yes':'はい',
    'no': 'いいえ'
};
