if (! document.localization) document.localization = [];

document.localization ['fr_FR'] = {
    'login.username': 'Identifiant ou email',
    'login.username.placeholder': 'Entrez votre identifiant ou email',
    'login.password': 'Mot de passe :',
    'login.password.placeholder': 'Entrez le mot de passe',
    'login.submit': 'S\'identifier',
    'login.password.incorrect': 'Identifiant ou mot de passe invalide',
    'login.password.recovery': 'Mot de passe perdu?',
    'recovery.password': 'Récupérer mot de passe',
    'recovery.password.success': 'Les instructions de récupération de mot de passe ont été envoyées à votre adresse e-mail',
    'login.no.account': 'N\'avez pas de compte?',
    'login.signup': 'S\'inscrire',

    'signup.title': 'Commencer',
    'signup.email' : 'Votre adresse e-mail',
    'signup.email.placeholder': 'Entrez une adresse e-mail valide',
    'signup.email.invalid': 'Entrez une adresse e-mail valide',
    'signup.terms.agree': 'Je suis d\'accord avec',
    'signup.terms.terms': 'termes et conditions',
    'signup.submit' : 'S\'inscrire',
    'signup.progress': 'Inscription...',
    'signup.email.used': 'Un client avec cet e-mail est déjà enregistré',
    'signup.name.used': 'Un client avec ce nom d\'utilisateur est déjà enregistré',
    'signup.complete': 'Merci pour votre inscription!',
    'signup.email.check': 'Veuillez vérifier votre e-mail et suivre le lien pour terminer l\'inscription!',
    'signup.complete.title': 'Votre compte sur ${appName} est presque prêt!',
    'signup.ready.title': 'Votre compte sur ${appName} est prêt!',
    'signup.customer.id' : 'Nom d\'utilisateur',
    'signup.customer.id.placeholder' : 'N\'utilisez que des lettres et des chiffres',
    'signup.customer.id.invalid': 'Veuillez utiliser 6 caractères ou plus, lettres et chiffres uniquement',
    'signup.first.name' : 'Prénom',
    'signup.first.name.placeholder': 'Votre prénom (obligatoire)',
    'signup.last.name' : 'Nom de famille',
    'signup.last.name.placeholder': 'Votre nom de famille (obligatoire)',
    'signup.company' : 'Nom de l\'entreprise',
    'signup.company.placeholder': 'Nom de votre entreprise (facultatif)',
    'signup.description': 'Comment allez-vous utiliser MDM?',
    'signup.description.placeholder': 'Cela aidera notre équipe à vous aider',
    'signup.password' : 'Mot de passe',
    'signup.password.repeat': 'Répétez le mot de passe',
    'signup.password.placeholder' : '6+ caractères',
    'signup.password.short': 'Veuillez entrer au moins 6 caractères',
    'signup.password.not.match': 'Les mots de passe ne correspondent pas',
    'signup.finalized.title': 'Votre compte est prêt!',
    'signup.finalized.description': 'Dans peu de temps, vous devez recevoir l\'e-mail contenant les instructions utiles. Veuillez consulter cet e-mail et vous connecter au panneau Web à l\'aide de votre nom d\'utilisateur et de votre mot de passe.',
    'signup.token.invalid.title': 'Le jeton est invalide ou déjà utilisé',
    'signup.token.invalid.description': 'Veuillez réessayer de vous inscrire pour créer un nouveau compte!',

    'header.label.username': 'Identifiant',

    'summary.devices.status' : 'État de l\'appareil',
    'summary.devices.active' : 'Actif',
    'summary.devices.idle': 'Inactif',
    'summary.devices.offline': 'Hors ligne',
    'summary.devices.enrollment': 'Résumé de l\'inscription',
    'summary.devices.enrolled.total': 'Total inscrit',
    'summary.devices.enrolled.earlier': 'Inscrit plus tôt',
    'summary.devices.enrolled.monthly' : '30 derniers jours',
    'summary.devices.installation.status' : 'Statut de l\'application',
    'summary.devices.installation.completed' : 'Terminé',
    'summary.devices.version.mismatch': 'Faux version',
    'summary.devices.installation.failed': 'Échec de l\'installation',
    'summary.devices.enrolled.lastyear': '12 derniers mois',

    'devices.group.options.all': 'Tous les groupes',
    'devices.configuration.options.all': 'Toutes les configurations',
    'devices.permissions.all': 'Toutes les autorisations sont accordées',
    'devices.permissions.not.as.device.admin': '- L\'application n\'est pas installée comme administrateur de l\'appareil',
    'devices.permissions.window.overlap.prohibited': '- La superposition sur d\'autres fenêtres non disponibles.',
    'devices.permissions.history.access.prohibited': '- Accès à l\'historique des usages non configuré.',
    'devices.unknown': 'Inconnue',
    'devices.model.unknown': 'Inconnue',
    'devices.date.unknown': 'Inconnue',
    'devices.date.format': 'dd/MM/yy HH:mm',
    'devices.app.installed': '- ${applicationName}: Installée.',
    'devices.app.not.installed': '- ${applicationName}: pas installé.',
    'devices.app.version.available': ', disponible ${applicationVersion}',
    'devices.app.installed.and.version.available': '- ${applicationName}: installée ${applicationInstalledVersion}, disponible ${applicationVersionAvailable}',
    'devices.app.needs.removal': '${applicationVersion}, suppression est requise',
    'devices.no.data': 'L\'appareil n\'a pas transmis de données',
    'devices.settings.conformance.broken': 'Incohérence avec les paramètres: (${serverData})',
    'devices.file.installed': '- ${file}: installé',
    'devices.file.not.installed': '- ${file}: pas installé.',
    'devices.file.lastUpdate.differs': '- ${file}: différence dans le temps de modification ${diff} min',

	'button.apply': 'Appliquer',
    'button.gps.on': 'Activer GPS',
    'button.wifi.on': 'Activer Wi-Fi',
    'button.notify.update': 'Notifier lors de la mise à jour',
    'button.app.settings': 'Paramètres de l\'application',
    'button.ok': 'D\'accord',
    'button.help': 'Aide',
    'button.new.app': 'Nouvelle application',
    'button.new.app.version': 'Nouvelle version',
    'button.upgrade': 'Mettre à jour',
    'button.renew.config': 'Mise à jour sur les appareils',
    'button.common': 'Application commune',
    'button.close': 'Fermer',
    'button.yes': 'Oui',
    'button.cancel': 'Annuler',
    'button.save': 'Enregistrer',
    'button.save.and.close': 'Enregistrer et fermer',
    'button.more': 'Plus ...',
    'button.cleanup': 'Effacer',
    'button.add': 'Ajouter',
    'button.add.icon': 'Nouvelle icône',
    'button.search': 'Rechercher',
    'button.export': 'Exporter',
    'button.change': 'Modifier',
    'button.copy': 'Copier',
    'button.qrcode': 'Code QR',
    'button.application': 'Application',
    'button.change.password': 'Changer le mot de passe',
    'button.set.configuration': 'Définir la configuration',
    'button.set.group': 'Définir un groupe',
    'button.group.action': 'Action de groupe',
    'button.delete': 'Supprimer',
    'button.login': 'S\'identifier',
    'button.renew.code': 'Renouveler',
    'button.configurations': 'Configurations',
    'button.set.configurations': 'Spécifier les configurations',
    'button.edit.versions': 'Versions',
    'button.edit': 'Modifier',
    'button.change.common.app': 'Modifier l\'application partagée',
    'button.delete.common.app': 'Supprimer l\'application partagée',
    'button.turn.common.app': 'Rendre commun',
    'button.hints.enable': 'Afficher les info-bulles',
    'button.hints.disable': 'Masquer les info-bulles',
    'button.show.password': 'Afficher le mot de passe',
    'button.hide.password': 'Masquer le mot de passe',

	'question.impersonate.user': 'Connectez-vous à l\'application comme administrateur de l\'organisation "${customerName}"?',
    'question.change.user': 'Connectez-vous à l\'application en tant qu\'utilisateur "${userName}"?',
    'question.delete.file': 'Supprimer le fichier "${fileName}"?',
    'question.delete.customer': 'Supprimer l\'organisation "${customerName}"?',
    'question.delete.user': 'Supprimer l\'utilisateur "${username}"?',
    'question.delete.application': 'Supprimer l\'application "${applicationName}"?',
    'question.delete.application.version': 'Supprimer la version "${applicationVersion}"?',
    'question.delete.configuration': 'Supprimer la configuration "${configurationName}"?',
    'question.delete.group': 'Supprimer le groupe "${groupName}"?',
    'question.delete.role': 'Supprimer le rôle "${roleName}"?',
    'question.delete.icon': 'Supprimer l\'icône "${iconName}"?',
    'question.delete.device.bulk': 'Supprimer les appareils sélectionnés?',
    'question.delete.device': 'Supprimer l\'appareil avec le numéro "${deviceNumber}"?',
    'question.exit.without.saving': 'Aucune modification est conservée. Bref, quittez la page.?',
    'question.turn2common.application': 'Partager l\'application "${applicationName}"?',
    'question.app.upgrade': 'Actualiser l\'application "${v1}" vers la dernière version pour la configuration "${v2}"?',
     
    'error.application.setting.empty.app': 'Spécifiez l\'application',
    'error.application.setting.empty.name': 'Entrez un nom',
    'error.application.setting.empty.value': 'Spécifiez une valeur',

    'error.icon.dimension.invalid': 'L\'icône doit être carrée',
    'error.icon.empty.name': 'Entrez le nom de l\'icône',
    'error.icon.empty.file': 'Télécharger le fichier d\'icône',
    'error.application.version.pkg.mismatch': 'Le package ID du fichier (${réel}) ne correspond pas à l\'application (${expected})',
	'error.empty.user': 'Sélectionnez un utilisateur',
    'error.empty.user.name': 'Remplissez l\'identifiant',
    'error.empty.user.login': 'Remplir l\'identifiant de l\'utilisateur',
    'error.empty.user.role': 'Sélectionnez un rôle utilisateur',
    'error.empty.password': 'Entrez un nouveau mot de passe',
    'error.empty.password.confirm': 'Entrez la confirmation du mot de passe',
    'error.user.not.found': 'Utilisateur non trouvé',
    'error.email.not.configured': 'E-mail non configuré',
    'error.email.not.found': 'E-mail de l\'utilisateur non défini',
    'error.empty.group.name': 'Remplissez le nom du groupe',
    'error.empty.configuration': 'Spécifiez la configuration',
    'error.empty.configuration.name': 'Remplissez le nom de la configuration',
    'error.empty.configuration.password': 'Remplissez le mot de passe',
    'error.empty.configuration.contentApp': 'Aucune application de contenu est spécifiée',
    'error.empty.group': 'Ajouter un appareil à un ou plusieurs groupes',
    'error.invalid.character': 'Le numéro de l\'appareil ne peut pas contenir les symboles / ? &',
    'error.invalid.configuration.mainApp': 'Dans les paramètres MDM, la mauvaise application principale est utilisée',
    'error.invalid.configuration.contentApp': 'Invalide contenu utilisé de l\'application dans les paramètres MDM',
    'error.mismatch.password': 'Mot de passe et sa confirmation doivent correspondre',
    'error.empty.customer.name': 'Remplissez le nom de l\'organisation',
    'error.empty.customer.prefix': 'Remplissez le préfixe du numéro de l\'appareil',
    'error.empty.customer.device.configuration': 'Sélectionnez la configuration de l\'appareil',
    'error.empty.customer.duplicate.prefix': 'Préfixe déjà utilisé',
    'error.duplicate.customer.name': 'Nom de l\'organisation saisi existe, essayez un autre nom.',								  
    'error.duplicate.group.name': 'Nom de groupe saisi existe, essayez un autre nom.',
    'error.duplicate.configuration.name': 'Nom de configuration saisi existe, essayez un autre nom.',
    'error.duplicate.device.number': 'Un appareil avec ce numéro existe',
    'error.internal.server': 'Erreur interne du serveur',
    'error.permission.denied': 'Aucun droit à exécuter',
    'error.request.failure': 'Échec de la demande',
    'error.configuration.device.use': 'Suppression impossible de cette configuration, déjà utilisée sur appareils. Allez sur " Appareils ", trouvez les appareils ayant cette configuration et modifiez ses paramètres.',
    'error.invalid.system.update.time': 'Invalide intervalle d\'installation',
    'error.size.limit.exceeded': 'Limite de stockage dépassée',

    'error.configuration.file.empty.name': 'Entrez nom de fichier',
    'error.configuration.file.empty.desc': 'Spécifiez description de fichier',
    'error.configuration.file.empty.path': 'Spécifiez chemin sur l\'appareil',
    'error.configuration.file.empty.file': 'Veuillez télécharger un fichier',
    'error.configuration.file.empty.url': 'Veuillez spécifier l\'URL du fichier',

	'error.notfound.device': 'Appareil non trouvé',
    'error.duplicate.device': 'Un appareil avec le même numéro existe déjà',
    'error.duplicate.login': 'Un tel identifiant est déjà utilisé',
    'error.duplicate.email': 'Un utilisateur avec cette adresse e-mail existe déjà',
    'error.duplicate.group': 'Un groupe ayant le même nom existe',
    'error.duplicate.application': 'Une application avec ce package ID et version existe déjà',
    'error.recent.application.version.exists': 'Une version plus récente de l\'application existe',
    'error.common.application.access.prohibited': 'Seule le super-administrateur est autorisé à gérer les applications communes',
    'error.application.config.reference.exists': 'L\'application est utilisée dans des configurations et impossible à supprimer.',
    'error.application.version.deletion.prohibited': 'Soit la version est unique, ou utilisée dans des configurations, et ne peut être supprimée',
    'error.duplicate.file': 'Un fichier du même nom existe',
    'error.used.file': 'Ce fichier est utilisé',
    'error.version.exists': 'La même version de cette application existe',
    'error.duplicate.configuration': 'Une configuration avec ce nom existe',
    'error.duplicate.role.name': 'Un rôle portant le même nom existe déjà',
    'error.empty.role.name': 'Une icône portant le même nom existe déjà',
    'error.duplicate.icon.name': 'An icon with the same name already exists',
    'error.notfound.customer.admin': 'Compte administrateur introuvable',
    'error.apk.file.required': 'Sélectionnez le fichier avec l\'extension .apk ou .xapk',
    'error.apk.parse': 'Une erreur s\'est produite lors de l\'analyse du fichier',
    'error.package.not.match': 'L\'ID du package ne correspond pas',
    'error.empty.app.name': 'Entrez le nom de l\'application',
    'error.empty.app.pkg': 'Entrez ID du package',
    'error.empty.app.url': 'Entrez URL',
    'error.empty.app.iconText': 'Entrez le texte de l\'icône',
    'error.empty.app.version': 'Entrez la version de l\'application',
    'error.notempty.group': 'Ce groupe comprend un ou plusieurs appareils. Impossible de supprimer.',
    'error.file.empty': 'Télécharger un nouveau fichier',
    'error.file.deletion': 'Erreur lors de la suppression du fichier sur le serveur',
    'error.file.save': 'Erreur lors de l\'enregistrement du fichier sur le serveur',
    'error.password.wrong': 'Mot de passe invalide',
    'error.password.empty': 'Mot de passe non spécifié',
    'error.password.weak': 'Mauvaise qualité du mot de passe',
    'error.params.missing': 'Paramètres manquants:',
    'error.empty.push.options': 'Veuillez sélectionner les options de notifications push',
    'error.app.name.exists': 'Une autre application portant ce nom existe déjà. Veuillez spécifier un nom unique.',

	'table.filtering.check.all': 'Tout sélectionner',
    'table.filtering.uncheck.all': 'Tout annuler',
    'table.filtering.suffix.configuration': 'configurations',
    'table.filtering.suffix.group': 'groupes',
    'table.filtering.suffix.permission': 'autorisations',
    'table.filtering.no.selected.configuration': 'Aucune configuration sélectionnée',
    'table.filtering.no.selected.group': 'Aucun groupe sélectionné',
    'table.filtering.no.selected.permission': 'Aucune autorisation sélectionnée',

	'success.admin.created': 'Compte administrateur créé:\n ${adminCredentials}',
    'success.uploading.file': 'Le fichier est téléchargé sur le serveur ...',
    'success.loading.devices': 'Chargement de la liste des appareils ...',
    'success.loading.customer': 'Chargement des données client ...',
    'success.file.uploaded': 'Fichier téléchargé avec succès.',
    'success.file.uploaded.need.save': 'Fichier téléchargé avec succès. Entrez le chemin relatif et cliquez sur "Enregistrer".',
    'success.settings.design.saved': 'Paramètres de conception enregistrés avec succès',
    'success.settings.common.saved': 'Paramètres généraux enregistrés avec succès',
    'success.settings.saved': 'Paramètres enregistrés avec succès',
    'success.settings.apiKey.saved': 'Clé API enregistrée avec succès',
    'success.settings.hints.enabled': 'Indications activées',
    'success.settings.hints.disabled': 'Indications désactivées',
    'success.configuration.saved': 'Configuration enregistrée avec succès',
    'success.operation.completed': 'Opération terminée avec succès',
    'success.plugins.disabled': 'Paramètres enregistrés avec succès',
    'success.config.update.notification': 'Commande de mise à jour de la configuration a été envoyée aux appareils',
    'success.config.update.device.app.settings.notification': 'Commande de mise à jour des paramètres de l\'application a été envoyée à l\'appareil.',

	'form.icon.title': 'Icône',
    'form.icon.name': 'Nom',
    'form.icon.file': 'Fichier',

    'configuration.add.warning': 'Voulez-vous vraiment créer une configuration vide? Vous devrez ajouter manuellement toutes les applications système requises. Envisagez plutôt de copier et de modifier une configuration existante.',
    'configuration.remove.warning': 'Voulez-vous vraiment supprimer la dernière configuration? Vous perdrez des informations sur les applications système requises.',
	'form.configuration.title': 'Configuration',
    'form.configuration.title.typical': 'Configuration typique',
    'form.configuration.settings.auto.update': 'Mise à jour automatique',
    'form.configuration.settings.system.update': 'Mise à jour du système',
    'form.configuration.settings.system.update.default': 'Par défaut',
    'form.configuration.settings.system.update.immediate': 'Immédiatement',
    'form.configuration.settings.system.update.scheduled': 'Programmé',
    'form.configuration.settings.system.update.postponed': 'Reporté',
    'form.configuration.settings.system.update.time': 'Heure d\'installation',
    'form.configuration.settings.system.update.time.from': 'de:',
    'form.configuration.settings.system.update.time.to': 'à:',
    'form.configuration.settings.system.schedule.app.update': 'Planifier l\'installation de l\'application',
    'form.configuration.settings.system.app.update.time': 'Heure d\'installation',
    'form.configuration.settings.download.updates': 'Télécharger du contenu',
    'form.configuration.settings.download.updates.unlimited': 'Sans limites',
    'form.configuration.settings.download.updates.limited': '3 tentatives sur le réseau mobile',
    'form.configuration.settings.download.updates.wifi': 'Par WiFi uniquement',
    'form.configuration.settings.block.status.bar': 'Verrouillage de la barre d\'état',
    'form.configuration.settings.block.status.bar.hint': 'Ce paramètre est obsolète et fonctionne sur Android 6 et versions antérieures. Pour verrouiller la barre d\'état sur les nouvelles versions d\'Android, utilisez le mode kiosque (paramètres MDM).',
    'form.configuration.settings.mdm.kiosk.mode': 'Mode kiosk',
    'form.configuration.settings.mdm.app.main': 'Application MDM',
    'form.configuration.settings.mdm.component.event.receiver': 'Classe de récepteur administrateur',
    'form.configuration.settings.mdm.component.event.receiver.placeholder': 'Devrait être com.hmdm.launcher.AdminReceiver',
    'form.configuration.settings.mdm.component.wifi.ssid': 'SSID WiFi',
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'Inscription WiFi SSID - laissez vide pour entrer manuellement',
    'form.configuration.settings.mdm.component.wifi.password': 'Mot de passe WiFi',
    'form.configuration.settings.mdm.component.wifi.password.placeholder': 'Inscription passe de WiFi - laissez vide pour entrer manuellement',
    'form.configuration.settings.mdm.component.wifi.security': 'Type de sécurité WiFi',
    'form.configuration.settings.mdm.component.wifi.notice': 'Remarque: ces paramètres WiFi ne sont appliqués qu\'à l\'inscription initiale!',
    'form.configuration.settings.mdm.component.server.url': 'Nouveaux server URL',
    'form.configuration.settings.mdm.component.server.url.placeholder': 'Utilisé pour la migration vers un nouveau serveur MDM',
    'form.configuration.settings.mdm.app.content': 'Application de contenu',
    'form.configuration.settings.mdm.kiosk.home': 'Activer le bouton Accueil',
    'form.configuration.settings.mdm.kiosk.recents': 'Activer le bouton Récents',
    'form.configuration.settings.mdm.kiosk.notifications': 'Activer les notifications',
    'form.configuration.settings.mdm.kiosk.system.info': 'Activer les informations de la barre d\'état',
    'form.configuration.settings.mdm.kiosk.keyguard': 'Activer le verrouillage de l\'écran',
    'form.configuration.settings.mdm.kiosk.lock.buttons': 'Verrouiller le bouton d\'alimentation',
    'form.configuration.settings.mdm.mobile.enrollment': 'S\'inscrire en utilisant les données mobiles',
    'form.configuration.settings.mdm.encrypt.device': 'Cryptage du stockage de l\'appareil',
    'form.configuration.settings.mdm.lock.safe.settings': 'Verrouiller les paramètres de sécurité (WiFi, GPS, etc.)',
    'form.configuration.settings.mdm.permissive': 'Mode permissif (déverrouillé)',
    'form.configuration.settings.mdm.kiosk.exit': 'Bouton de sortie du kiosque',
    'form.configuration.settings.mdm.kiosk.screen': 'Écran toujours allumé',
    'form.configuration.settings.mdm.allowed.classes': 'Activités autorisées',
    'form.configuration.settings.mdm.allowed.classes.placeholder': 'Classes séparées par des virgules, p.e.: com.android.settings.homepage.SettingsHomepageActivity',
    'form.configuration.settings.mdm.restrictions': 'Restrictions',
    'form.configuration.settings.mdm.restrictions.placeholder': 'Restrictions MDM, séparées par des virgules, p.e.: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.launcher': 'emplacer l\'URL du lanceur',
    'form.configuration.settings.mdm.launcher.placeholder': 'Autre URL du lanceur pour l\'inscription aux réseaux fermés',
    'form.configuration.settings.mdm.misc': 'Autres entrées de code QR',
    'form.configuration.settings.mdm.misc.placeholder': 'Entrées séparées par des virgules, p.e.:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url': 'Adresse URL du code QR',
    'form.configuration.settings.mdm.hint': 'Sélectionnez l\'application principale et le composant',
    'form.configuration.apps.search.label': 'Rechercher:',
    'form.configuration.apps.sort.label': 'Trier:',
    'form.configuration.apps.sort.byname': 'Par nom',
    'form.configuration.apps.sort.bypkg': 'Par ID',
    'form.configuration.apps.no.apk': 'rien',
    'form.configuration.apps.show.systeam.apps': 'Afficher les applications système',
    'form.configuration.apps.action.select': '(sélectionner)',
    'form.configuration.apps.action.install': 'Installer',
    'form.configuration.apps.action.prohibit': 'Interdire',
    'form.configuration.apps.action.not.install': 'Ne pas installer',
    'form.configuration.apps.action.delete': 'Supprimer',
    'form.configuration.apps.action.permit': 'Permettre',
    'form.configuration.apps.label.inherit': 'Hérité',
    'form.configuration.apps.label.show': 'Afficher',
    'form.configuration.apps.label.not.show': 'Cacher',
    'form.configuration.apps.edit.details': 'Paramètres supplémentaires',
    'form.configuration.apps.keycode': 'Code clé',
    'form.configuration.apps.bottom': 'Affichage en bas',
    'form.configuration.apps.long.tap': 'Paramètres par appui long',
    'form.configuration.apps.hint': 'Astuce: pour dissocier l\'application de la configuration, sélectionnez l\'action "Bloquer" ou "Ne pas installer".',
    'form.configuration.settings.design.use.default': 'Utiliser la conception par défaut',
    'form.configuration.settings.design.color.background': 'Couleur d\'arrière-plan',
    'form.configuration.settings.design.color.background.placeholder': 'Sélectionnez une couleur',
    'form.configuration.settings.design.color.app.names': 'Couleur des noms d\'application',
    'form.configuration.settings.design.color.app.names.placeholder': 'Sélectionnez une couleur',
    'form.configuration.settings.design.background.image.url': 'Adress URL de l\'image d\'arrière-plan',
    'form.configuration.settings.design.background.image.url.placeholder': 'Entrez url de l\'image d\'arrière-plan',
    'form.configuration.settings.design.icon': 'Taille de l\'icône',
    'form.configuration.settings.design.icon.small': 'Petit',
    'form.configuration.settings.design.icon.medium': 'Moyenne (+20%)',
    'form.configuration.settings.design.icon.large': 'Grand (+40%)',
    'form.configuration.settings.design.desktop.header': 'Titre du bureau',
    'form.configuration.settings.design.desktop.header.no': 'Non',
    'form.configuration.settings.design.desktop.header.deviceid': 'ID de l\'appareil',
    'form.configuration.settings.design.desktop.header.description': 'Description',
    'form.configuration.settings.design.desktop.header.custom': 'Modèle personnalisé',
    'form.configuration.settings.design.desktop.header.hint': 'Assurez-vous que ce paramètre est envoyé aux appareils (Paramètres - Options générales et de langue)',
    'form.configuration.settings.design.desktop.header.template': 'Entrez le modèle',
    'form.configuration.settings.design.desktop.header.template.placeholder': 'Utiliser des variables',
    'form.configuration.settings.design.display.status': 'Afficher l\'heure et l\'état de la batterie',
    'form.configuration.settings.design.upload': 'Télécharger',
    'form.configuration.settings.common.name': 'Nom',
    'form.configuration.settings.common.name.placeholder': 'Entrez le nom de la configuration',
    'form.configuration.settings.common.desc': 'Description',
    'form.configuration.settings.common.desc.placeholder': 'Entrez la description de la configuration',
    'form.configuration.settings.common.admin.pwd': 'Mot de passe de déverrouillage',
    'form.configuration.settings.common.admin.pwd.placeholder': 'Mot de passe de déverrouillage',
    'form.configuration.settings.common.gps': 'GPS',
    'form.configuration.settings.common.gps.any': 'Tout',
    'form.configuration.settings.common.gps.off': 'Désactivé',
    'form.configuration.settings.common.gps.on': 'Activé',
    'form.configuration.settings.common.bluetooth': 'Bluetooth',
    'form.configuration.settings.common.wifi': 'Wi-Fi',
    'form.configuration.settings.common.mobile.data': 'Données mobiles',
    'form.configuration.settings.common.usb.storage': 'Bloquer le stockage USB',
    'form.configuration.settings.common.brightness': 'Gérer la luminosité',
    'form.configuration.settings.common.brightness.none': 'Aucun',
    'form.configuration.settings.common.brightness.auto': 'Auto',
    'form.configuration.settings.common.brightness.manual': 'Valeur',
    'form.configuration.settings.common.brightness.value': 'Luminosité de l\'écran',
    'form.configuration.settings.common.timeout': 'Gérer le mise en veille de l\'écran',
    'form.configuration.settings.common.timeout.value': 'Veille de l\'écran (s)',
    'form.configuration.settings.common.volume.block': 'Verrouiller le volume',
    'form.configuration.settings.common.volume.manage': 'Gérer le volume',
    'form.configuration.settings.common.volume.value': 'Volume',
    'form.configuration.settings.common.timezone.mode': 'Gérer le fuseau horaire',
    'form.configuration.settings.common.timezone.mode.default': 'Ne gère pas',
    'form.configuration.settings.common.timezone.mode.auto': 'Auto',
    'form.configuration.settings.common.timezone.mode.manual': 'Valeur',
    'form.configuration.settings.common.timezone': 'Fuseau horaire',
    'form.configuration.settings.common.timezone.placeholder': 'p.e. America/Los_Angeles',
    'form.configuration.settings.common.timezone.link': 'Liste des fuseaux horaires',
    'form.configuration.settings.common.no.network.warning': 'ATTENTION! Ne désactivez pas tous les canaux de connexion, sinon vous ne pourrez plus gérer les appareils!',
    'form.configuration.settings.common.autostart.foreground': 'Démarrer les apps au premier plan',
    'form.configuration.settings.request.updates' : 'Suivi de localisation',
    'form.configuration.settings.request.updates.donottrack': 'Aucun suivi actif (utiliser les données de localisation de l\'application tierce)',
    'form.configuration.settings.request.updates.gps': 'Suivre l\'emplacement par GPS',
    'form.configuration.settings.request.updates.wifi': 'Suivre la localisation par Wi-Fi (les services Google doivent être activés)',
    'form.configuration.settings.request.updates.prompt.gps': 'Pour suivre la position par GPS, vous devez activer le GPS',
    'form.configuration.settings.request.updates.prompt.wifi': 'Pour suivre la localisation par Wi-Fi, vous devez activer le Wi-Fi',
    'form.configuration.settings.revoke.location.permission' : 'Aucune autorisation de localisation',
    'form.configuration.settings.revoke.location.permission.hint': 'Si défini, l\'autorisation de localisation ne sera pas accordée à l\'agent MDM et il ne pourra pas suivre l\'emplacement de l\'appareil',
    'form.configuration.settings.apps.permissions' : 'Autorisations pour les autres applications',
    'form.configuration.settings.apps.permissions.grant' : 'Accorder automatiquement toutes les autorisations',
    'form.configuration.settings.apps.permissions.ask.location': 'Auto-accorder tout, demander à l\'utilisateur l\'autorisation de localisation',
    'form.configuration.settings.apps.permissions.deny.location': 'Auto-accorder tout, ne pas accorder l\'autorisation de localisation',
    'form.configuration.settings.apps.permissions.ask.all' : 'Demander à l\'utilisateur toutes les autorisations',
    'form.configuration.settings.push.options': 'Notifications push',
    'form.configuration.settings.push.options.mqtt.worker': 'Protocole MQTT (économiser la batterie)',
    'form.configuration.settings.push.options.mqtt.alarm': 'Protocole MQTT',
    'form.configuration.settings.push.options.polling': 'interrogation HTTP',
    'form.configuration.settings.push.options.mqtt.worker.hint' : 'Fournit des messages Push instantanément lorsque l\'appareil est actif. Mais les messages peuvent être retardés jusqu\'à quelques heures en mode veille. N\'utilisez pas cette option sur les appareils autonomes. MQTT utilise le port TCP 31000, activez-le sur votre pare-feu.',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT est un protocole léger qui consomme peu de ressources. MQTT utilise le port TCP 31000, activez-le sur votre pare-feu.',
    'form.configuration.settings.push.options.polling.hint' : 'L\'interrogation longue persiste une connexion HTTP qui peut consommer plus de ressources serveur. Ne nécessite aucun port TCP autre que HTTP(S).',
    'form.configuration.settings.push.options.keepalive' : 'Temps de Keep-Alive',
    'form.configuration.settings.minute.1' : '1 minute',
    'form.configuration.settings.minutes.2' : '2 minutes',
    'form.configuration.settings.minutes.3' : '3 minutes',
    'form.configuration.settings.minutes.5' : '5 minutes',
    'form.configuration.settings.minutes.10' : '10 minutes',
    'form.configuration.settings.minutes.15' : '15 minutes',
    'form.configuration.settings.password.mode' : 'Exigences relatives au mot de passe',
    'form.configuration.settings.password.mode.any' : 'Aucune',
    'form.configuration.settings.password.mode.present' : 'Mot de passe présente',
    'form.configuration.settings.password.mode.easy' : 'Facile (au moins 6 symboles)',
    'form.configuration.settings.password.mode.moderate' : 'Modéré (8+ symboles, lettres et chiffres)',
    'form.configuration.settings.password.mode.strong' : 'Fort (8+, majuscules et minuscules, chiffres, signes)',
    'form.configuration.settings.show.wifi': 'Paramètres WiFi en cas d\'erreur de connexion',
    'form.configuration.settings.use.default.launcher': 'Mode d\'arrière-plan',
    'form.configuration.settings.use.default.launcher.hint': 'Ne remplacez pas un lanceur système, exécutez uniquement les services MDM en arrière-plan. Non recommandé avec le mode kiosque.',
    'form.configuration.settings.disable.screenshots': 'Désactiver la capture d\'écran',
    'form.configuration.settings.orientation': 'Verrouiller l\'orientation',
    'form.configuration.settings.orientation.none': 'Ne pas verrouiller',
    'form.configuration.settings.orientation.portrait': 'Portrait',
    'form.configuration.settings.orientation.landscape': 'Paysage',
    'form.configuration.settings.files.default.path': 'Chemin par défaut sur l\'appareil',
    'form.configuration.files.search.label': 'Rechercher:',
    'form.configuration.files.action.upload': 'Télécharger',
    'form.configuration.files.action.remove': 'Supprimer',
    'form.configuration.files.variables': 'Contenu variable',
    'form.configuration.files.variables.hint': 'Les chaînes DEVICE_NUMBER, IMEI, CUSTOM* seront remplacées par leurs valeurs',

	'form.configuration.file.name': 'Nom du fichier',
    'form.configuration.file.select': 'Sélectionner un fichier',
    'form.configuration.file.create': '(créer un nouveau fichier)',
    'form.configuration.file.description': 'Description',
    'form.configuration.file.description.placeholder': 'En option, pour votre commodité',
    'form.configuration.file.path': 'Chemin sur l\'appareil',
    'form.configuration.file.path.placeholder': 'Pas de chemin vers un lecteur: /my-app/image.jpg',
    'form.configuration.file.url': 'URL',
    'form.configuration.file.url.placeholder': 'Si un fichier est hébergé sur une ressource externe',
    'form.configuration.file.file': 'Fichier',
    'form.configuration.file.action': 'Action',
    'form.configuration.file.action.prompt.1': 'Upload',
    'form.configuration.file.action.prompt.2': 'Supprimer',
    'form.configuration.file.remove.prompt.1': 'Ce fichier ne sera plus synchronisé avec les appareils',
    'form.configuration.file.remove.prompt.2': 'Supprimer le fichier depuis le serveur',

	'form.password.title': 'Changer le mot de passe',
    'form.password.label.user': 'Utilisateur',
    'form.password.label.password.new': 'Nouveau mot de passe',
    'form.password.label.password.new.placeholder': 'Entrez un nouveau mot de passe',
    'form.password.label.password.confirm': 'Vérifier',
    'form.password.label.password.confirm.placeholder': 'Entrez à nouveau le nouveau mot de passe',
    'form.password.length': 'Longueur minimale: ${length}. ',

	'form.application.type': 'Type',
    'form.application.type.option.web': 'Page Web',
    'form.application.type.option.app': 'Application',
    'form.application.type.option.intent': 'Action système',
    'form.application.intent': 'Action',
    'form.application.intent.placeholder': 'Choisir une action',
    'form.application.url.hint': 'Utilisez file:///storage/emulated/0/... pour créer des liens vers des fichiers et dossiers locaux',
    'form.application.pkg': 'ID du package',
    'form.application.from.file': 'déterminé à partir du fichier',
    'form.application.pkg.title': 'L\'ID du package est automatiquement déterminé lorsque vous téléchargez le fichier APK. L\'ID du package saisi manuellement est requis pour les applications système uniquement.',
    'form.application.pkg.placeholder': 'Par exemple, com.android.camera',
    'form.application.disabled.arch': 'Spécifique à la version',
    'form.application.disabled.arch.title': 'Pour ajouter des APK pour différentes architectures de processeur, cliquez sur "Ajouter" ou ouvrez la liste des versions de l\'application',
    'form.application.arch': 'Code natif',
    'form.application.arch.title': 'Certaines applications contiennent du code optimisé pour certaines architectures de processeur. Dans ce cas, vous devez télécharger deux APK (pour les architectures armeabi-v7a et arm64-v8a)',
    'form.application.arch.universal': 'Aucun (APK universel)',
    'form.application.arch.armeabi': 'Code natif pour armeabi-v7a',
    'form.application.arch.arm64': 'Code natif pour arm64-v8a',
    'form.application.arch.no.split': 'APK universel',
    'form.application.arch.split': 'APK divisé',
    'form.application.arch.warning': 'Cet APK est optimisé pour ${arch} uniquement et peut ne pas fonctionner sur tous les appareils. Il est recommandé de télécharger un autre APK optimisé pour une autre architecture CPU. Pour utiliser cet APK sur tous les appareils, sélectionnez "APK universel".',
    'form.application.arch.success': 'Cette application contient des fichiers APK pour les deux architectures de processeur',
    'form.application.version.exists': 'L\'APK pour cette version existe déjà',
    'form.application.url.armeabi': 'URL pour armeabi-v7a',
    'form.application.url.arm64': 'URL pour arm64-v8a',
    'form.application.name': 'Nom de l\'application',
    'form.application.name.title': 'Vous verrez le nom de l\'application dans la liste. Nous vous recommandons d\'utiliser des noms uniques et informatifs.',
    'form.application.name.placeholder': 'Par exemple, Photo (Android)',
    'form.application.version': 'Version',
    'form.application.version.placeholder': '0 pour les applications système',
    'form.application.version.title': 'La version du package est automatiquement déterminée lorsque vous téléchargez le fichier APK. Réglez-le sur 0 pour les applications système.',
    'form.application.version.code': 'Code de version',
    'form.application.version.code.exists': 'Une version avec le même code existe déjà. Veuillez signaler ce problème aux développeurs de l\'application.',
    'form.application.system': 'Système',
    'form.application.system.title': 'Les applications système sont préinstallées sur un appareil et ne nécessitent ni URL ni fichier. Définissez cet indicateur uniquement si vous devez activer un certain package système.',
    'form.application.run.after.install': 'Exécuter après l\'installation',
    'form.application.run.after.install.title': 'Les applications avec des services d\'arrière-plan doivent être lancées au premier plan au moins une fois.',
    'form.application.run.at.boot': 'Exécuter au démarrage',
    'form.application.run.at.boot.title': 'Définissez cet indicateur si vous devez exécuter l\'application au premier plan après le démarrage. Cet indicateur n\'affecte pas les processus d\'arrière-plan.',
    'form.application.url': 'URL',
    'form.application.url.title': 'L\'URL ne doit être saisie que si votre application est hébergée sur une ressource externe. Il est recommandé de télécharger un fichier APK en utilisant un champ ci-dessous.',
    'form.application.url.disabled': 'L\'URL est configurée pour chaque version. Pour modifier l\'URL, fermez cette fenêtre et cliquez sur l\'icône "Versions".',
    'form.application.file': 'Fichier',
    'form.application.auto.update': 'Mise à jour automatique',
    'form.application.auto.update.title': 'Définissez cet indicateur pour mettre à jour toutes les configurations où l\'application est installée. Utilisez uniquement si vous êtes sûr à 100 % que l\'application est stable.',
    'form.application.showLabel': 'Afficher l\'icône',
    'form.application.showLabel.title': 'Cet indicateur indique si l\'icône de l\'application doit être affichée dans le lanceur. Cette option peut être remplacée dans la configuration.',
    'form.application.use.kiosk': 'Ouvrir dans Kiosk-Browser',
    'form.application.use.kiosk.title': 'Définissez cet indicateur si vous souhaitez ouvrir une page Web dans le navigateur de kiosque sans aucune possibilité de modifier l\'adresse',
    'form.application.iconText': 'Texte de l\'icône',
    'form.application.iconText.placeholder': '(par défaut)',
    'form.application.versions.title': 'Versions de l\'application',
    'form.application.icon': 'Icône',
    'form.application.icon.default': '(par défaut)',
    'form.application.icon.add': 'Ajouter une icône',

'form.application.setting.app': 'Application',
     'form.application.setting.app.placeholder': 'Sélectionnez une application',
     'form.application.setting.name': 'Attribut',
     'form.application.setting.value': 'Valeur',
     'form.application.setting.comment': 'Commentaire',
     'form.application.setting.type': 'Type',
     'form.application.setting.readonly': 'Ne change pas sur l\'appareil',
    
     'form.application.configurations.app': 'Application',
     'form.application.configurations.configs': 'Configurations',

     'form.configuration.copy.new.name': 'Nouveau nom',
     'form.configuration.copy.new.name.placeholder': 'Entrez le nouveau nom de configuration',

    'form.customer.name': 'Nom',
    'form.customer.name.placeholder': 'Entrez le nom de l\'organisation',
    'form.customer.admin.name': 'Nom de l\'administrateur',
    'form.customer.firstname.placeholder': 'Prénom',
    'form.customer.lastname.placeholder': 'Nom de famille',
    'form.customer.language': 'Langue',
    'form.customer.language.placeholder': 'Laissez vide pour l\'anglais ou tapez deux lettres minuscules',
    'form.customer.apiKey': 'Clé API',
    'form.customer.apiKey.placeholder': 'Entrez la clé API',
    'form.customer.prefix': 'Préfixe',
    'form.customer.prefix.placeholder': 'Entrez le préfixe du numéro de l\'appareil',
    'form.customer.device.configuration': 'Configuration de l\'appareil',
    'form.customer.desc': 'Description',
    'form.customer.desc.placeholder': 'Entrez une description de l\'organisation',
    'form.customer.copy.configuration': 'Copier les configurations',
    'form.customer.copy.design': 'Copier la conception',
    'form.customer.type': 'Type de client',
    'form.customer.status': 'Statut de client',
    'form.customer.expiry.time': 'Date d\'expiration',
    'form.customer.device.limit': 'Limite d\'appareils',
    'form.customer.size.limit': 'Limite de stockage',
    'form.customer.size.limit.placeholder': 'Taille (Mo)',

    'form.device.number': 'Numéro',
    'form.device.number.locked': 'Impossible de modifier le numéro car le changement de numéro précédent n\'a pas été effectué.',
    'form.device.migration.warning': 'Le numéro de l\'appareil sera modifié. Assurez-vous que l\'appareil est allumé et en ligne.',
    'form.device.number.hint': 'N\'utilisez pas de caractères spéciaux',
    'form.device.desc': 'Description',
    'form.device.groups': 'Groupes',
    'form.device.config': 'Configuration',
    'form.device.imei': 'IMEI',
    'form.device.phone.number': 'Numéro de téléphone',

    'form.update.device.config': 'Configuration',
    'form.update.device.action' : 'Action de groupe',
    'form.device.set.group' : 'Ajouter aux groupes',
    'form.device.clear.group': 'Supprimer des groupes',

    'form.file.file': 'Fichier',
    'form.file.name': 'Nom du fichier',
    'form.file.description': 'Description (facultatif)',
    'form.file.external': 'Externe',
    'form.file.external.title': 'Au lieu de télécharger le fichier, vous pouvez spécifier l\'URL sur une ressource externe',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': 'URL du fichier sur une ressource externe',
    'form.file.path': 'Chemin sur le serveur',
    'form.file.device.path': 'Chemin sur l\'appareil',
    'form.file.device.path.placeholder': 'Chemin relatif à /storage/emulated/0',
    'form.file.deleted': 'SUPPRIMÉ',
    'form.file.copy.link': 'Copier le lien : ${link}',
    'form.file.configurations.file': 'Fichier',
    'form.file.configurations.configs': 'Configurations',
    'form.file.configurations.upload': 'Télécharger',
    'form.file.path.placeholder': 'Entrez un chemin relatif, par exemple "/files/"',
    'form.file.available': 'Espace disponible : ${space} Mo',

    'form.file.apps.name': 'Nom de l\'application',
    'form.file.apps.pkg': 'ID du package',
    'form.file.apps.version': 'Version',

    'form.group.name': 'Nom de groupe',
    'form.group.name.placeholder': 'Enter le nom de groupe',

    'form.role.name': 'Nom',
    'form.role.name.placeholder': 'Entrez le nom du rôle',
    'form.role.permissions': 'Autorisations',

    'form.user.login': 'Connexion',
    'form.user.login.placeholder': 'Entrez la session de l\'utilisateur',
    'form.user.name': 'Nom',
    'form.user.name.placeholder': 'Nom et prénom',
    'form.user.email': 'E-mail',
    'form.user.email.placeholder': 'Entrez l\'e-mail',
    'form.user.role': 'Rôle',
    'form.user.all.devices.available': 'Tous les appareils sont disponibles',
    'form.user.available.groups': 'Groupes de appareils disponibles',
    'form.user.all.configs.available': 'Toutes les configurations sont disponibles',
    'form.user.available.configs': 'Configurations disponibles',
    'form.user.password.new': 'Nouveau mot de passe',
    'form.user.password': 'Mot de passe',
    'form.user.password.new.placeholder': 'Entrez un nouveau mot de passe',
    'form.user.password.confirm': 'Vérifier',
    'form.user.password.confirm.placeholder': 'Entrez à nouveau le nouveau mot de passe',

    'form.settings.hints.title': 'Conseils',

    'form.settings.plugins.title': 'Plugins utilisés',

    'form.settings.common.title': 'Paramètres généraux',
    'form.settings.common.visible.columns': 'Colonnes visibles dans le tableau "Appareils"',
    'form.settings.common.status': 'Statut',
    'form.settings.common.role': 'Rôle des utilisateurs',
    'form.settings.common.date': 'Dernière date de connexion',
    'form.settings.common.device.number': 'Numéro de l\'appareils',
    'form.settings.common.imei': 'IMEI',
    'form.settings.common.phone.number': 'Numéro de téléphone',
    'form.settings.common.phone.model': 'Modèle de téléphone',
    'form.settings.common.status.permissions': 'Statut de l\'autorisation',
    'form.settings.common.status.installation': 'État de l\'installation',
    'form.settings.common.status.files': 'État des fichiers',
    'form.settings.common.config': 'Configuration',
    'form.settings.common.desc': 'Description',
    'form.settings.common.group': 'Groupe',
    'form.settings.common.launcher.version': 'Version du lanceur',
    'form.settings.common.battery.level': 'Niveau de la batterie',
    'form.settings.common.default.launcher': 'Arrière-plan',
    'form.settings.common.mdm.mode': 'Mode MDM',
    'form.settings.common.kiosk.mode': 'Mode kiosque',
    'form.settings.common.android.version': 'Version Androïd',
    'form.settings.common.enrollment.date': 'Date de l\'inscription',
    'form.settings.common.serial': 'Numéro de série',
    'form.settings.common.publicip': 'Adresse IP',

	'form.settings.design.title': 'Conception par défaut',
    'form.settings.design.color.font': 'Couleur d\'arrière-plan',
    'form.settings.design.color.font.placeholder': 'Sélectionnez une couleur',
    'form.settings.design.color.app.names': 'Couleur des noms d\'application',
    'form.settings.design.color.app.names.placeholder': 'Sélectionnez une couleur',
    'form.settings.design.url.background.image': 'URL de l\'image d\'arrière-plan',
    'form.settings.design.url.background.image.placeholder': 'Entrez URL de l\'image d\'arrière-plan',
    'form.settings.design.size.icon': 'Taille de l\'icône',
    'form.settings.design.size.icon.small': 'Petit',
    'form.settings.design.size.icon.medium': 'Moyenne (+ 20%)',
    'form.settings.design.size.icon.large': 'Large (+ 40%)',
    'form.settings.design.desktop.header': 'Titre du bureau',
    'form.settings.design.desktop.header.no': 'Non',
    'form.settings.design.desktop.header.device.id': 'ID de l\'appareil',

    'form.settings.lang.title': 'Paramètres de langue',
    'form.settings.lang.use.default': 'Utiliser la langue par défaut',
    'form.settings.lang.use': 'Utiliser la langue',
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.vi': 'Tiếng Việt',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title': 'Paramètres divers',
    'form.settings.misc.phone.format': 'Format du numéro de téléphone',
    'form.settings.misc.phone.format.placeholder': '+9 (999) 999-99-99',
    'form.settings.misc.custom.property.name.1': 'Propriété personnalisée #1',
    'form.settings.misc.custom.property.name.2': 'Propriété personnalisée #2',
    'form.settings.misc.custom.property.name.3': 'Propriété personnalisée #3',
    'form.settings.misc.custom.property.multiline': 'Multiligne',
    'form.settings.misc.custom.property.send': 'Envoyer à l\'appareil',
    'form.settings.misc.custom.property.name.placeholder': 'Entrez le nom d\'une propriété personnalisée',
    'form.settings.misc.create.new.devices': 'Ajouter un appareil lors du premier accès',
    'form.settings.misc.new.device.config': 'Nouvelle configuration d\'appareil',
    'form.settings.misc.new.device.group': 'Nouveau groupe d\'appareils',
    'form.settings.misc.send.description': 'Envoyer une description aux appareils',
    'form.settings.misc.password.length': 'Longueur minimale du mot de passe',
    'form.settings.misc.password.strength': 'Fiabilité du mot de passe',
    'form.settings.misc.password.none': 'Non spécifié (aucun caractère)',
    'form.settings.misc.password.alphanumeric': 'Lettres minuscules et majuscules, chiffres',
    'form.settings.misc.password.specialchar': 'Lettres minuscules et majuscules, chiffres, caractères spéciaux',
    'form.settings.misc.password.reset': 'L\'utilisateur doit réinitialiser le mot de passe',
    'form.settings.misc.idle.logout': 'Se déconnecter en cas d\'inactivité',
    'form.settings.misc.idle.logout.never': 'Jamais',
    'form.settings.misc.idle.logout.1' : '5 minutes',
    'form.settings.misc.idle.logout.2' : '10 minutes',
    'form.settings.misc.idle.logout.3' : '30 minutes',
    'form.settings.misc.idle.logout.4' : '1 heure',
    'form.settings.security.title' : 'Paramètres de sécurité',

    'idle.logout.message': 'Vous serez déconnecté dans ${sec} secondes en raison d\'inactivité',
    'idle.logout.resume': 'Je suis là!',

    'form.settings.groups.title': 'Groupes',
    'form.settings.groups.search.placeholder': 'Recherche de groupe',

    'form.settings.users.title': 'Utilisateurs',
    'form.settings.users.search.placeholder': 'Rechercher un utilisateur',

    'form.settings.roles.title': 'Rôles des utilisateurs',

    'form.settings.icons.title': 'Icônes',
    'form.settings.icons.search.placeholder': 'Rechercher les icônes',

    'form.qr.device.number': 'ID d\'appareil',
    'form.qr.auto.create': 'Ajouter à la liste des appareils s\'il n\'existe pas',
    'form.qr.number.use': 'Attribution d\'ID d\'appareil',
    'form.qr.number.use.request': 'Valeur utilisateur',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': 'Numéro de série',
    'form.qr.number.hint': 'Effacez le numéro d\'appareil pour activer l\'attribution automatique du numéro d\'appareil',
    'form.qr.groups': 'Ajouter aux groupes',
    'form.qr.button.json': 'Obtenez JSON',
    'form.qr.device.number.placeholder': 'Entrez ID de l\'appareil ...',
    'form.qr.code.image.alt': 'Code QR',

    'form.password.reset.title': 'Veuillez créer un nouveau mot de passe',
    'form.password.reset.invalid': 'Désolé, ce lien de réinitialisation de mot de passe n\'est pas valide',
    'form.password.reset.submit': 'Définir le mot de passe',

    'form.two.factor.auth.title': 'Authentification à deux facteurs',
    'form.two.factor.auth.hint': 'Pour finaliser votre inscription, veuillez installer l\'application Authenticator sur votre appareil mobile, scanner le code QR, générer et saisir le code de vérification.',
    'form.two.factor.auth.code.invalid': 'Le code de vérification n\'est pas valide !',
    'form.two.factor.auth.code' : 'Code de vérification',
    'form.two.factor.auth.code.hint' : 'Code à 6 chiffres de l\'application d\'authentification',
    'form.two.factor.auth.code.error': 'Le code doit être un nombre à 6 chiffres',
    'form.two.factor.auth.verify': 'Vérifier',
    'form.two.factor.auth.settings.hint': 'Pour définir l\'authentification à deux facteurs, veuillez installer l\'application Authenticator sur votre appareil mobile, scannez le code QR, générez et saisissez le code de vérification.',
    'form.two.factor.auth.set': 'L\'authentification à deux facteurs est activée',
    'form.two.factor.auth.reset': 'L\'authentification à deux facteurs est désactivée',
    'form.two.factor.auth.off.confirm': 'Voulez-vous désactiver l’authentification à deux facteurs? Après l\'avoir réactivé, tous les authentifiants deviendront invalides.',

    'form.profile.title': 'Changer le mot de passe',
    'form.profile.password.old': 'Ancien mot de passe',
    'form.profile.password.old.placeholder': 'Entrez l\'ancien mot de passe',
    'form.profile.password.new': 'Nouveau mot de passe',
    'form.profile.password.new.placeholder': 'Entrez un nouveau mot de passe',
    'form.profile.password.confirm': 'Vérifier',
    'form.profile.password.confirm.placeholder': 'Entrez à nouveau le nouveau mot de passe',

    'tab.customers': 'Organisations',
    'tab.common.applications': 'Applications partagées',

    'tab.devices': 'Appareils',
    'tab.applications': 'Applications',
    'tab.configurations': 'Configurations',
    'tab.files': 'Fichiers',
    'tab.default.design': 'Conception par défaut',
    'tab.common.settings': 'Paramètres généraux',
    'tab.users': 'Utilisateurs',
    'tab.roles': 'Rôles',
    'tab.groups': 'Groupes',
    'tab.icons': 'Icônes',
    'tab.language': 'Options générales et de langue',
    'tab.license': 'Licence',
    'tab.hints': 'Indications',
    'tab.plugins': 'Plugins',
    
	'tab.configeditor.common.settings': 'Paramètres généraux',
    'tab.configeditor.design.settings': 'Paramètres de conception',
    'tab.configeditor.applications': 'Applications',
    'tab.configeditor.mdm.settings': 'Paramètres MDM',
    'tab.configeditor.app.settings': 'Paramètres des applications',
    'tab.configeditor.files': 'Fichiers',

    'search.placeholder.file': 'rechercher un fichier',
    'search.placeholder.configuration': 'Rechercher la configuration',
    'search.placeholder.customer': 'Rechercher une organisation',
    'search.placeholder.application': 'Rechercher une application',
    'search.placeholder.application.setting': 'Rechercher un paramètre d\'application',
    'search.placeholder.device': 'Rechercher un appareil',
    'search.placeholder.address': 'Recherche d\'adresse',
    'search.placeholder.point': 'Recherche sur site',
    'search.placeholder.message': 'Recherche de message',
    'search.placeholder': 'Rechercher ...',
    'search.placeholder.from': 'De ...',
    'search.placeholder.to': 'À ...',
    'search.placeholder.user': 'Tapez le nom d\'utilisateur',

    'table.heading.customer.name': 'Nom',
    'table.heading.customer.desc': 'Description',
    'table.heading.customer.registration.time': 'Enregistré',
    'table.heading.customer.last.login.time': 'Dernière connexion',
    'table.heading.customer.actions': 'Actions',
    'table.heading.customer.type': 'Type',
    'table.heading.customer.expiry.time': 'Expire',
    'table.heading.customer.device.limit': 'Limite',
    'table.heading.customer.status': 'Statut',

    'customer.new': 'Nouveau',
    'customer.active': 'Actif',
    'customer.need.followup': 'Besoin d\'un suivi',
    'customer.followup.sent': 'Suivi envoyé',
    'customer.internal.test': 'Test interne',
    'customer.developer': 'Développeur',
    'customer.difficult': 'Difficile',
    'customer.pause': 'Pause',
    'customer.inactive': 'Pas de connexion',
    'customer.abandon': 'Abandonné',
    'customer.onpremise': 'Essai sur place',
    'customer.denial': 'Rejet',
    'customer.client': 'Client',

    'table.heading.configuration.name': 'Nom',
    'table.heading.configuration.desc': 'Description',
    'table.heading.configuration.actions': 'Actions',

    'table.heading.application.setting.app.pkg': 'ID du package',
    'table.heading.application.setting.app.name': 'Nom de l\'application',
    'table.heading.application.setting.name': 'Nom de personnalisation',
    'table.heading.application.setting.value': 'Valeur',
    'table.heading.application.setting.comment': 'Commentaire',
    'table.heading.application.setting.lastUpdate': 'Date de la dernière modification',

	'table.heading.file.url': 'URL',
    'table.heading.file.devicepath': 'Chemin sur l\'appareil',
    'table.heading.file.description': 'Description',
    'table.heading.file.action': 'Action',
    'table.heading.file.lastUpdate': 'Date de la dernière modification',
    
    'table.heading.application.pkg': 'ID du package',
    'table.heading.application.name': 'Nom de l\'application',
    'table.heading.application.version': 'Version',
    'table.heading.application.url': 'URL',
    'table.heading.application.label': 'Icône',
    'table.heading.application.actions': 'Actions',
    'table.heading.application.order': 'Ordre',

    'table.heading.device.status': 'Statut',
    'table.heading.device.date': 'En ligne',
    'table.heading.device.device.number': 'Numéro de l\'appareil',
    'table.heading.device.imei': 'IMEI',
    'table.heading.device.phone.number': 'Numéro de téléphone',
    'table.heading.device.phone.model': 'Modèle de téléphone',
    'table.heading.device.status.permissions': 'Statut de l\'autorisation',
    'table.heading.device.status.installation': 'État de l\'installation',
    'table.heading.device.status.files': 'État des fichiers',
    'table.heading.device.configuration': 'Configuration',
    'table.heading.device.desc': 'Description',
    'table.heading.device.group': 'Groupe',
    'table.heading.device.launcher.version': 'Version du lanceur',
    'table.heading.device.battery.level': 'Niveau de batterie',
    'table.heading.device.default.launcher': 'Arrière-plan',
    'table.heading.device.mdm.mode': 'Mode MDM',
    'table.heading.device.kiosk.mode': 'Mode kiosque',
    'table.heading.device.android.version': 'Version Androïd',
    'table.heading.device.enrollment.date': 'Date de l\'inscription',
    'table.heading.device.serial': 'Numéro de série',
    'table.heading.device.publicip': 'Adresse IP',
    'table.heading.device.actions': 'Actions',

    'table.heading.group.name': 'Nom',
    'table.heading.group.actions': 'Actions',

    'table.heading.role.name': 'Nom',
    'table.heading.role.actions': 'Actions',

    'table.heading.file.name': 'Nom de fichier',
    'table.heading.file.comment': 'Description',
    'table.heading.file.device.path': 'Chemin sur l\'appareil',
    'table.heading.file.update.time': 'Mis à jour à',
    'table.heading.file.external': 'Externe',
    'table.heading.file.variable': 'Variable',
    'table.heading.file.remove': 'Supprimer',
    'table.heading.file.remove.hint': 'Force la suppression du fichier du stockage de l\'appareil',
    'table.heading.file.path': 'Chemin',
    'table.heading.file.address': 'Adresse',
    'table.heading.file.size': 'Taille',
    'table.heading.file.actions': 'Actions',

    'table.heading.users.login': 'Identifiant :',
    'table.heading.users.name': 'Nom',
    'table.heading.users.role': 'Rôle',
    'table.heading.users.actions': 'Actions',

    'table.heading.common.apps.customer': 'Organisation',
    'table.heading.common.apps.pkg': 'ID du package',
    'table.heading.common.apps.name': 'Nom de l\'application',
    'table.heading.common.apps.version': 'Version',
    'table.heading.common.apps.url': 'URL',
    'table.heading.common.apps.label': 'Icône',
    'table.heading.common.apps.actions': 'Actions',
    
	'notfound.devices': 'Il n\'y a aucun appareil à afficher.',
    'notfound.files': 'La liste des fichiers est vide. Utilisez le bouton "Ajouter" pour télécharger un nouveau fichier.',
    'notfound.configurations': 'Aucune configuration n\'a été trouvée.',
    'notfound.customers': 'Organisations non trouvées.',
    'notfound.common.apps': 'Il n\'y a aucune application à afficher.',
    'notfound.applications': 'Applications introuvables',
    'notfound.groups': 'Aucun groupe trouvé. Essayez une autre requête.',
    'notfound.users': 'Utilisateurs non trouvés. Essayez une autre requête.',
    'notfound.apps.for.display': 'Il n\'y a aucune application à afficher.',
    'notfound.app.versions.for.display': 'Il n\'y a aucune version à afficher.',
    'notfound.roles':'La liste des rôles est vide.',
    'notfound.icons':'La liste des icônes est vide.',

    'format.date.header': 'HH:mm dd/MM/yyyy',

	'menu.about': 'À propos de',
    'menu.profile': 'Profil',
    'menu.panel.master': 'Panneau principal',
    'menu.panel.main': 'Panneau principal',
    'menu.logout': 'Déconnexion',
    'menu.functions': 'Fonctions',
    'menu.settings': 'Paramètres',
    'menu.show.hints': 'Afficher les indices',

    'plugin.name.not.specified': '<< Le nom de la fonction n\'est pas spécifié >>',

    'breadcrumb.summary': 'Résumé',
    'breadcrumb.devices': 'Appareils',
    'breadcrumb.applications': 'Applications',
    'breadcrumb.configurations': 'Configurations',
    'breadcrumb.files': 'Fichiers',
    'breadcrumb.default.design': 'Conception par défaut',
    'breadcrumb.common.settings': 'Paramètres généraux',
    'breadcrumb.language.settings': 'Paramètres de langue',
    'breadcrumb.license.settings': 'Licence',
    'breadcrumb.users': 'Utilisateurs',
    'breadcrumb.roles': 'Rôles',
    'breadcrumb.groups': 'Groupes',
    'breadcrumb.hints': 'Indications',
    'breadcrumb.plugins': 'Plugins',
    'breadcrumb.config.details': 'Détails',
    'breadcrumb.application.versions': 'Versions',

    'app.name': 'Headwind MDM',
    'app.vendor.name':"h-mdm.com",
    'app.vendor.link':"https://h-mdm.com",
    'app.description': 'est le système de gestion des appareils mobiles open source',
    'app.title': 'Serveur ${appName}',
     
	'box.show.my.apps.only': 'Afficher uniquement mes applications',
    'configuration.app.version.upgrade.message': 'Version installée ${installedVersion}, version disponible ${latestVersion}',

    'about.line.1': 'Panneau de configuration ${appName}',
    'about.line.2': 'Lanceur d\'entreprise pour Android',
    'about.line.3': 'Version ${versionNumber}',
    'about.line.4': 'Plugins installés',

    'common.app.clarification': 'Cette application est publique et ne peut pas être modifiée. Pour ajouter une autre version de cette application, veuillez contacter l\'administrateur.',

    'qrcode.help.line1': 'Pour configurer l\'appareil Android (version 7 ou plus) en mode géré (entreprise):',
    'qrcode.help.line2': 'Réinitialiser l\'appareil aux paramètres d\'usine',
    'qrcode.help.line3': 'Appuyez 7 fois sur n\'importe quel endroit de l\'écran de démarrage (vous devez entrer dans un mode de numérisation de code QR caché)',
    'qrcode.help.line4': 'Suivez les instructions de l\'appareil: acceptez les conditions, connectez-vous au Wi-Fi, scannez ce QR-code',
    'qrcode.help.line5': 'Le code QR peut contenir ID de l\'appareil pour ${appName} (pas besoin de le saisir sur un appareil mobile). Pour intégrer ID de l\'appareil dans le code QR, saisissez ID de l\'appareil sur cet écran et cliquez sur "Renouveler".',

	'form.configuration.app.version.select.select.title': 'Sélectionnez la version à installer',
    'form.configuration.app.version.select.version.check.off': 'Désactiver la vérification de version',
    'form.configuration.app.version.select.upgrade.warning': 'Mettre à niveau l\'application "${v1}" vers la version "${v3}" pour la configuration "${v2}"?',
    'form.configuration.app.version.select.downgrade.warning': 'Version dégradée EFFACER TOUTES CES APPLICATIONS sur tous les appareils ! Dégrader la version de l\'application "${v1}" à la version "${v2}"?',

    'hint.step.1': 'Cliquez ici pour démarrer l\'inscription de l\'appareil',
    'hint.step.2': 'Cliquez ici pour ouvrir le code QR',
    'hint.step.3': 'Cliquez ici pour voir comment ouvrir le scanner de code QR sur l\'appareil',
    'hint.step.4': 'Trouvez un identifiant d\'appareil disponible dans l\'onglet «Appareils». Cliquez sur «Renouveler» pour l\'inclure dans le code QR.',

    'ie.browser.notice.1': 'Malheureusement, Internet Explorer n\'est pas pris en charge.',
    'ie.browser.notice.2': 'Navigateur recommandé pour l\'utilisation de ${appName} - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop"> Chrome < / a>.',

    'form.resolved.duplicate.pkg.text1': 'ID de package "${pkg}" est déjà utilisé par les applications répertoriées ci-dessous.',
    'form.resolved.duplicate.pkg.text2': 'Voulez-vous ajouter une nouvelle application ou une nouvelle version d\'une application existante?',
    'form.resolved.duplicate.pkg.text3': 'Nouvelle version pour',
    'form.resolved.duplicate.pkg.text4': 'L\'ID de package "${pkg}" est déjà utilisé par les applications ${apps}',
    'form.resolved.duplicate.pkg.text5': 'Voulez-vous vraiment modifier l\'ID du package?',

    'tooltip.usage.byconfigurations': 'Utilisé par les configurations',
    'tooltip.usage.byapps': 'Utilisé par les applications',
    'tooltip.usage.byicons': 'Utilisé par les icônes',

    'form.devices.label.params.more': 'Plus de paramètres',
    'form.devices.label.params.less': 'Moins de paramètres',
    'form.devices.label.installation.status': 'État de l\'installation',
    "format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
    "format.devices.date.datePicker": "dd-MM-yyyy",
    'form.devices.fast.search': 'Recherche rapide par numéro',

    'form.devices.selection.install.status.default': 'État de l\'installation ...',
    'form.devices.selection.install.status.all': 'Toute',
    'form.devices.selection.install.status.success': 'Succès',
    'form.devices.selection.install.status.version.mismatch': 'Incompatibilite de version',
    'form.devices.selection.install.status.failure': 'Échec',
    'form.devices.selection.imei.changed': 'IMEI a récemment changé',

    'search.placeholder.launcher.version': 'Version du lanceur',
    'error.date.range.invalid': 'L\'intervalle de date n\'est pas valide',

    'form.selection.status.any': 'Toute valeur',
    'form.selection.status.all': 'Tout',
    'form.selection.status.yes': 'Oui',
    'form.selection.status.no': 'Non',

    'form.devices.selection.status': 'Statut ...',
    'form.devices.selection.online': 'En ligne',
    'form.devices.selection.offline': 'Hors ligne',
    'form.devices.selection.number': 'Entrez un nombre',

    'form.devices.selection.online.status.custom': 'Entrez l\'heure',
    'form.devices.selection.online.status.1': '15 minutes',
    'form.devices.selection.online.status.2': '30 minutes',
    'form.devices.selection.online.status.3': '1 heure',
    'form.devices.selection.online.status.4': '2 heures',
    'form.devices.selection.online.status.5': '6 heures',
    'form.devices.selection.online.status.6': '1 jour',
    'form.devices.selection.online.status.7': '2 jours',
    'form.devices.selection.online.status.8': '3 jours',
    'form.devices.selection.online.status.9': '1 semaine',
    'form.devices.selection.online.status.10': '1 mois',

    'form.devices.selection.online.status.label': 'minute(s)',
    'form.devices.status.ago': 'depuis',
    'form.devices.status.minutes': 'm',
    'form.devices.status.hours': 'h',
    'form.devices.status.days': 'j',
    'form.devices.status.weeks': 's',
    'form.devices.status.months': 'mois',
    'form.devices.status.years': 'a',

    'customer.type.demo': 'Démo',
    'customer.type.small': 'Petite entreprise',
    'customer.type.corporate': 'Entreprise',
    'customer.type.master': 'Primaire',

    'customer.type.options.all': 'Tous les types',
    'customer.status.options.all': 'Tous les statuts',

    'account.expiring': 'Votre compte expirera dans $ {days} jours. Veuillez contacter le vendeur pour renouveler votre compte.',
    'account.expired': 'Votre compte a expiré. Veuillez contacter le vendeur pour renouveler votre compte.',
    'account.expired.short': 'Votre compte a expiré!',
    'device.limit.achieved': 'Impossible d\'ajouter un appareil car vous avez atteint votre limite. Veuillez supprimer certains appareils ou contacter le vendeur pour étendre la limite de votre appareil.',

    'menu.updates' : 'Vérifier les mises à jour',
    'updates.title' : 'Mises à jour',
    'updates.disabled.custom': 'Version personnalisée, veuillez mettre à jour manuellement',
    'updates.disabled.not_master': 'Demander à l\'hébergeur de mettre à jour',
    'updates.disabled.multiple': 'Plusieurs versions d\'application, veuillez mettre à jour manuellement',
    'updates.disabled.error' : 'Erreur interne du serveur',
    'updates.disabled.download': 'Erreur lors du téléchargement d\'une mise à jour',
        'mises à jour.application' : 'Application',
    'updates.current.version' : 'Version actuelle',
    'updates.available.version' : 'Version disponible',
    'updates.downloaded' : 'Téléchargé',
    'updates.auto.update': 'Mettre à jour automatiquement les applications mobiles (à utiliser avec précaution en production !)',
    'updates.enable.stats' : 'Envoyer des statistiques d\'utilisation au fournisseur de services pour améliorer les performances du système',
'updates.get' : 'Obtenir les mises à jour',
    'updates.checking': 'Vérification des mises à jour...',
    'updates.getting': 'Récupération des mises à jour...',
    'updates.success' : 'Mise à jour terminée',
    'updates.web.hint': 'Pour terminer la mise à jour de l\'application Web, exécutez le script shell /opt/hmdm/update-web-app.sh dans la console SSH',

    'permission.edit_device_app_settings': 'Gérer les paramètres d\'application spécifiques à l\'appareil',
    'permission.plugins_customer_access_management': 'Gérer les plugins disponibles',
    'permission.plugin_audit_access': 'Afficher le journal d\'audit',
    'permission.plugin_contacts_access': 'Gérer les contacts',
    'permission.plugin_deviceexport_access': 'Exporter des appareils',
    'permission.plugin_deviceimport_access': 'Importer des appareils',
    'permission.plugin_deviceinfo_access': 'Afficher les informations détaillées de l\'appareil',
    'permission.plugin_devicelocations_access': 'Afficher les appareils sur la carte',
    'permission.plugin_devicelocations_settings_access': 'Configurer le plugin de carte',
    'permission.plugin_devicelog_access': 'Afficher l\'appareil journaux',
    'permission.plugin_devicereset_access': 'Réinitialiser et redémarrer les appareils',
    'permission.plugin_licensing_access': 'Accès à la licence (obsolète)',
    'permission.plugin_messaging_send': 'Envoyer des messages',
    'permission.plugin_messaging_delete': 'Supprimer les messages envoyés',
    'permission.plugin_photo_remove_photo': 'Supprimer les photos',
    'permission.settings': 'Gérer les paramètres',
    'permission.configurations': 'Afficher les configurations',
    'permission.edit_devices': 'Modifier les informations sur l\'appareil',
    'permission.edit_device_desc': 'Modifier la description de l\'appareil',
    'permission.enroll_devices': 'Enregistrer les appareils par code QR',
    'permission.plugin_apuppet_access': 'Contrôle à distance',
    'permission.plugin_knox_access': 'Plugin Knox',
    'permission.add_config': 'Ajouter des configurations',
    'permission.copy_config': 'Dupliquer les configurations',
    'permission.plugin_openvpn_access': 'Plugin OpenVPN',
    'permission.plugin_photo_access': 'Plugin photo',
    'permission.push_api': 'Accès à l\'API Push',
    'permission.plugin_urlfilter_access': 'Filtrage d\'URL',
    'permission.plugin_push_send': 'Envoyer des messages Push',
    'permission.plugin_push_delete': 'Supprimer les messages Push',
    'permission.get_updates': 'Vérifier les mises à jour',
    'permission.plugin_xtra_access': 'Demander la version Premium',
    'permission.applications': 'Afficher les applications',
    'permission.edit_applications': 'Gérer les applications',
    'permission.edit_application_versions': 'Gérer les versions d\'application',
    'permission.files': 'Afficher les fichiers',
    'permission.edit_files': 'Gérer les fichiers',

    'yes': 'oui',
    'no': 'non'
};
