/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.task;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.UploadedFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCheckTask
implements Runnable {
    private final UnsecureDAO unsecureDAO;
    private final String filesDirectory;
    private static final Logger logger = LoggerFactory.getLogger(FileCheckTask.class);
    private Integer customerId;
    private Path rootDir;

    @Inject
    public FileCheckTask(UnsecureDAO unsecureDAO, @Named(value="files.directory") String filesDirectory) {
        this.unsecureDAO = unsecureDAO;
        this.filesDirectory = filesDirectory;
    }

    @Override
    public void run() {
        try {
            if (this.unsecureDAO.isSingleCustomer()) {
                this.customerId = 1;
                this.rootDir = Paths.get(this.filesDirectory, new String[0]);
                this.checkFiles(this.rootDir);
            } else {
                List customers = this.unsecureDAO.getAllCustomersUnsecure();
                for (Customer customer : customers) {
                    if (customer.isMaster()) continue;
                    this.customerId = customer.getId();
                    this.rootDir = Paths.get(this.filesDirectory, customer.getFilesDir());
                    this.checkFiles(this.rootDir);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkFiles(Path directory) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> stream = Files.list(directory);){
                stream.forEach(path -> {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.checkFiles(path);
                    } else if (Files.isRegularFile(path, new LinkOption[0])) {
                        this.checkFile(path);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkFile(Path file) {
        UploadedFile uploadedFile;
        String rootPath;
        if (file.getFileName().toString().endsWith(".apk") || file.getFileName().toString().endsWith(".xapk")) {
            return;
        }
        String filePath = file.toString();
        if (filePath.startsWith(rootPath = this.rootDir.toString()) && filePath.length() > rootPath.length()) {
            filePath = filePath.substring(rootPath.length() + 1);
        }
        if ((uploadedFile = this.unsecureDAO.getUploadedFileByPath(this.customerId, filePath)) == null) {
            uploadedFile = new UploadedFile();
            uploadedFile.setCustomerId(this.customerId.intValue());
            uploadedFile.setFilePath(filePath);
            this.unsecureDAO.insertUploadedFile(uploadedFile);
        }
        try {
            BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            FileTime modificationTime = attrs.lastModifiedTime();
            long millis = modificationTime.toMillis();
            if (uploadedFile.getUploadTime() != millis) {
                uploadedFile.setUploadTime(Long.valueOf(millis));
                this.unsecureDAO.updateUploadedFile(uploadedFile);
            }
        }
        catch (IOException e) {
            logger.error("Failed to get attributes of " + file.toString() + ": " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }
}

