/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.task;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.service.EmailService;
import com.hmdm.service.MailchimpService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CustomerStatusTask
implements Runnable {
    private final UnsecureDAO unsecureDAO;
    private final EmailService emailService;
    private final MailchimpService mailchimpService;
    private final String adminEmail;
    private final int INTERVAL_PAUSE_1 = 3;
    private final int INTERVAL_PAUSE_2 = 5;
    private final int INTERVAL_ABANDON_1 = 7;
    private final int INTERVAL_ABANDON_2 = 14;
    private final int INTERVAL_DENIAL = 14;

    @Inject
    public CustomerStatusTask(UnsecureDAO unsecureDAO, EmailService emailService, MailchimpService mailchimpService, @Named(value="admin.email") String adminEmail) {
        this.unsecureDAO = unsecureDAO;
        this.emailService = emailService;
        this.mailchimpService = mailchimpService;
        this.adminEmail = adminEmail;
    }

    @Override
    public void run() {
        List customers = this.unsecureDAO.getFollowUpCustomersUnsecure();
        HashMap<String, Customer> updatedCustomersMap = new HashMap<String, Customer>();
        for (Customer customer : customers) {
            long now = System.currentTimeMillis();
            if (customer.getLastLoginTime() == null) {
                long daysAfterRegistration = (now - customer.getRegistrationTime()) / 86400000L;
                if (daysAfterRegistration > 43L) {
                    customer.setCustomerStatus("customer.denial");
                    updatedCustomersMap.put(customer.getName(), customer);
                    continue;
                }
                if (daysAfterRegistration > 29L) {
                    if (customer.getAbandonState() >= 2) continue;
                    customer.setCustomerStatus("customer.abandon");
                    customer.setAbandonState(2);
                    updatedCustomersMap.put(customer.getName(), customer);
                    continue;
                }
                if (daysAfterRegistration > 15L) {
                    if (customer.getAbandonState() >= 1) continue;
                    customer.setCustomerStatus("customer.abandon");
                    customer.setAbandonState(1);
                    updatedCustomersMap.put(customer.getName(), customer);
                    continue;
                }
                if (daysAfterRegistration > 8L) {
                    if (customer.getInactiveState() >= 2) continue;
                    customer.setCustomerStatus("customer.inactive");
                    customer.setInactiveState(2);
                    updatedCustomersMap.put(customer.getName(), customer);
                    continue;
                }
                if (daysAfterRegistration <= 3L || customer.getInactiveState() >= 1) continue;
                customer.setCustomerStatus("customer.inactive");
                customer.setInactiveState(1);
                updatedCustomersMap.put(customer.getName(), customer);
                continue;
            }
            long daysAfterSignIn = (now - customer.getLastLoginTime()) / 86400000L;
            if (customer.getCustomerStatus().equals("customer.new") || customer.getCustomerStatus().equals("customer.inactive")) {
                customer.setCustomerStatus("customer.active");
                updatedCustomersMap.put(customer.getName(), customer);
            }
            if (daysAfterSignIn > 43L) {
                customer.setCustomerStatus("customer.denial");
                updatedCustomersMap.put(customer.getName(), customer);
                continue;
            }
            if (daysAfterSignIn > 29L) {
                if (customer.getAbandonState() >= 2) continue;
                customer.setCustomerStatus("customer.abandon");
                customer.setAbandonState(2);
                updatedCustomersMap.put(customer.getName(), customer);
                continue;
            }
            if (daysAfterSignIn > 15L) {
                if (customer.getAbandonState() >= 1) continue;
                customer.setCustomerStatus("customer.abandon");
                customer.setAbandonState(1);
                updatedCustomersMap.put(customer.getName(), customer);
                continue;
            }
            if (daysAfterSignIn > 8L) {
                if (customer.getPauseState() >= 2) continue;
                customer.setCustomerStatus("customer.pause");
                customer.setPauseState(2);
                updatedCustomersMap.put(customer.getName(), customer);
                continue;
            }
            if (daysAfterSignIn <= 3L || customer.getPauseState() >= 1) continue;
            customer.setCustomerStatus("customer.pause");
            customer.setPauseState(1);
            updatedCustomersMap.put(customer.getName(), customer);
        }
        if (updatedCustomersMap.size() == 0) {
            return;
        }
        LinkedList<Customer> updatedCustomers = new LinkedList<Customer>();
        for (Map.Entry entry : updatedCustomersMap.entrySet()) {
            this.unsecureDAO.updateCustomerUnsecure((Customer)entry.getValue());
            updatedCustomers.add((Customer)entry.getValue());
        }
        String adminSubj = "Headwind MDM customer status changed";
        Object adminBody = "Hi,<br>\nThe following customers changed their status and notified:<br><br>\n\n";
        for (Customer c : updatedCustomers) {
            adminBody = (String)adminBody + c.getName() + "/" + c.getEmail() + ", status " + c.getCustomerStatus() + ", states I" + c.getInactiveState() + "/P" + c.getPauseState() + "/A" + c.getAbandonState() + "<br>\n";
        }
        this.adminEmail.equals("");
        if (this.mailchimpService.initialize()) {
            this.mailchimpService.updateStatus(updatedCustomers);
        }
    }
}

