/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.domain.Video;
import com.hmdm.rest.json.Response;
import com.hmdm.util.FileUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.poi.util.IOUtils;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Singleton
@Path(value="/videos")
public class VideosResource {
    private String videoDirectory;
    private String baseUrl;

    public VideosResource() {
    }

    @Inject
    public VideosResource(@Named(value="video.directory") String videoDirectory, @Named(value="base.url") String baseUrl) {
        this.videoDirectory = videoDirectory;
        this.baseUrl = baseUrl;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response uploadVideo(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws Exception {
        File videoDir = new File(this.videoDirectory);
        if (!videoDir.exists()) {
            videoDir.mkdirs();
        }
        File uploadFile = new File(videoDir.getAbsolutePath(), fileDetail.getFileName());
        FileUtil.writeToFile((InputStream)uploadedInputStream, (String)uploadFile.getAbsolutePath());
        Video video = new Video();
        video.setPath(String.format("%s/rest/public/videos/%s", this.baseUrl, URLEncoder.encode(fileDetail.getFileName(), "UTF8")));
        return Response.OK((Object)video);
    }

    @GET
    @Path(value="/{fileName}")
    @Produces(value={"application/octet-stream"})
    public jakarta.ws.rs.core.Response downloadVideo(@PathParam(value="fileName") String fileName) throws Exception {
        File videoFile;
        File videoDir = new File(this.videoDirectory);
        if (!videoDir.exists()) {
            videoDir.mkdirs();
        }
        if (!(videoFile = new File(videoDir, URLDecoder.decode(fileName, "UTF8"))).exists()) {
            return jakarta.ws.rs.core.Response.status((int)404).build();
        }
        ContentDisposition contentDisposition = ContentDisposition.type((String)"attachment").fileName(videoFile.getName()).creationDate(new Date()).build();
        return jakarta.ws.rs.core.Response.ok(output -> {
            try {
                FileInputStream input = new FileInputStream(videoFile);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                output.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).header("Content-Disposition", (Object)contentDisposition).build();
    }
}

