/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.UserRoleDAO;
import com.hmdm.persistence.domain.UserRole;
import com.hmdm.persistence.domain.UserRolePermission;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"UserRole"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/roles")
public class UserRoleResource {
    private UserRoleDAO userRoleDAO;
    private static final Logger log = LoggerFactory.getLogger(UserRoleResource.class);

    public UserRoleResource() {
    }

    @Inject
    public UserRoleResource(UserRoleDAO userRoleDAO) {
        this.userRoleDAO = userRoleDAO;
    }

    @ApiOperation(value="Get all permissions", notes="Gets the list of all permissions", response=UserRolePermission.class, responseContainer="List")
    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    public Response getPermissions() {
        return Response.OK((Object)this.userRoleDAO.getPermissionsList());
    }

    @ApiOperation(value="Get all roles", notes="Get the list of all user roles", response=UserRole.class, responseContainer="List")
    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    public Response getAllRoles() {
        return Response.OK((Object)this.userRoleDAO.findAll());
    }

    @ApiOperation(value="Create or update user role", notes="Create a new user role (if id is not provided) or update existing one otherwise.")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateRole(UserRole userRole) {
        if (!this.userRoleDAO.hasAccess()) {
            log.error("Unauthorized attempt to update a user role by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        UserRole dbUserRole = this.userRoleDAO.findByName(userRole.getName());
        if (dbUserRole != null && !dbUserRole.getId().equals(userRole.getId())) {
            return Response.DUPLICATE_ENTITY((String)"error.duplicate.role");
        }
        if (userRole.getId() == null) {
            this.userRoleDAO.insert(userRole);
        } else {
            this.userRoleDAO.update(userRole);
        }
        return Response.OK();
    }

    @ApiOperation(value="Delete user role", notes="Delete an existing user role")
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeUserRole(@PathParam(value="id") @ApiParam(value="User role ID") Integer id) {
        if (!this.userRoleDAO.hasAccess()) {
            log.error("Unauthorized attempt to remove a user role by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        this.userRoleDAO.delete(id.intValue());
        return Response.OK();
    }
}

