/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CommonDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.UserDAO;
import com.hmdm.persistence.domain.Settings;
import com.hmdm.persistence.domain.User;
import com.hmdm.persistence.domain.UserRole;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import com.hmdm.util.PasswordUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"User"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/users")
public class UserResource {
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);
    private static final String sessionCredentials = "credentials";
    private UserDAO userDAO;
    private CommonDAO settingsDAO;
    private UnsecureDAO unsecureDAO;

    public UserResource() {
    }

    @Inject
    public UserResource(UserDAO userDAO, CommonDAO settingsDAO, UnsecureDAO unsecureDAO) {
        this.userDAO = userDAO;
        this.settingsDAO = settingsDAO;
        this.unsecureDAO = unsecureDAO;
    }

    @ApiOperation(value="Get user details", notes="Returns the details for the user account referenced by the specified ID.", response=User.class)
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserDetails(@PathParam(value="id") @ApiParam(value="User ID") int id) {
        User userDetails = this.userDAO.getUserDetails(id);
        userDetails.setPassword(null);
        return Response.OK((Object)userDetails);
    }

    @ApiOperation(value="Get current user details", notes="Returns the details for the current user account", response=User.class)
    @GET
    @Path(value="/current")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCurrentUserDetails() {
        return SecurityContext.get().getCurrentUser().map(u -> {
            User userDetails = this.userDAO.getUserDetails(u.getId().intValue());
            userDetails.setPassword(null);
            return Response.OK((Object)userDetails);
        }).orElse(Response.OK(null));
    }

    @ApiOperation(value="List all users", notes="Gets the list of all existing user accounts", response=User.class, responseContainer="List")
    @GET
    @Path(value="/all")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUsers(@QueryParam(value="filter") String filter) {
        return SecurityContext.get().getCurrentUser().map(currentUser -> {
            if (!SecurityContext.get().hasPermission("settings")) {
                logger.error("Unauthorized attempt to access user list by user " + currentUser.getLogin());
                return Response.PERMISSION_DENIED();
            }
            List userDetails = filter == null || filter.isEmpty() ? this.userDAO.findAllUsers() : this.userDAO.findAllUsers("%" + filter + "%");
            userDetails.forEach(u -> {
                u.setPassword(null);
                u.setAuthToken(null);
                u.setEditable(!u.getId().equals(currentUser.getId()));
            });
            return Response.OK((Object)userDetails);
        }).orElse(Response.PERMISSION_DENIED());
    }

    @ApiOperation(value="Update password", notes="Updates the password for current user", response=User.class)
    @PUT
    @Path(value="/current")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePassword(User user) {
        return SecurityContext.get().getCurrentUser().map(u -> {
            if (!u.getId().equals(user.getId())) {
                logger.warn("Failed to update password: u.getId()=" + String.valueOf(u.getId()) + ", user.getId()=" + String.valueOf(user.getId()));
                return Response.PERMISSION_DENIED();
            }
            User dbUser = this.userDAO.findByLoginOrEmail(user.getLogin());
            return this.updatePassword(dbUser, user);
        }).orElse(Response.PERMISSION_DENIED());
    }

    @ApiOperation(value="Create or update user", notes="Creates a new user account (if id is not provided) or update existing one otherwise.")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUser(User user) {
        return SecurityContext.get().getCurrentUser().map(u -> {
            if (!u.getUserRole().isSuperAdmin() && !this.userDAO.isOrgAdmin(u)) {
                logger.warn("Failed to update user {}: must be org admin or superadmin", (Object)user.getLogin());
                return Response.PERMISSION_DENIED();
            }
            try {
                User dbUser;
                String userEmail = user.getEmail();
                if (userEmail != null && !userEmail.equals("") && (dbUser = this.unsecureDAO.findByEmail(userEmail)) != null && !dbUser.getId().equals(user.getId())) {
                    logger.warn("User with email {} already exists, id {}", (Object)userEmail, (Object)dbUser.getId());
                    return Response.ERROR((String)"error.duplicate.email");
                }
                Settings settings = Optional.ofNullable(this.settingsDAO.getSettings()).orElse(new Settings());
                if (user.getId() == null) {
                    User dbUser2 = this.unsecureDAO.findByLogin(user.getLogin());
                    if (dbUser2 != null) {
                        logger.error("Failed to create user {}: duplicate login", (Object)user.getLogin());
                        return Response.ERROR((String)"error.duplicate.login");
                    }
                    if (user.getNewPassword() == null) {
                        logger.warn("Failed to create user {}: empty password", (Object)user.getLogin());
                        return Response.ERROR((String)"error.password.empty");
                    }
                    user.setCustomerId(((User)SecurityContext.get().getCurrentUser().get()).getCustomerId());
                    this.updatePasswordWithReset(user, user.getNewPassword(), settings.isPasswordReset());
                    this.userDAO.insert(user);
                } else {
                    User dbUser3 = this.unsecureDAO.findByLogin(user.getLogin());
                    if (dbUser3 != null && !user.getId().equals(dbUser3.getId())) {
                        logger.error("Failed to create user {}: duplicate login", (Object)user.getLogin());
                        return Response.ERROR((String)"error.duplicate.login");
                    }
                    this.userDAO.updateUserMainDetails(user);
                    if (user.getNewPassword() != null && !user.getNewPassword().isEmpty()) {
                        this.updatePasswordWithReset(user, user.getNewPassword(), settings.isPasswordReset());
                        this.userDAO.updatePassword(user);
                    }
                }
                return Response.OK();
            }
            catch (Exception e) {
                logger.error("Failed to create user {}: ", (Object)user.getLogin(), (Object)e);
                e.printStackTrace();
                return Response.ERROR((String)"error.duplicate.login");
            }
        }).orElse(Response.PERMISSION_DENIED());
    }

    private User updatePasswordWithReset(User user, String password, boolean reset) {
        user.setTwoFactorSecret(null);
        user.setTwoFactorAccepted(false);
        user.setPassword(PasswordUtil.getHashFromMd5((String)password));
        user.setAuthToken(PasswordUtil.generateToken());
        if (reset) {
            user.setPasswordReset(true);
            user.setPasswordResetToken(PasswordUtil.generateToken());
        } else {
            user.setPasswordReset(false);
            user.setPasswordResetToken(null);
        }
        return user;
    }

    @ApiOperation(value="Delete user", notes="Deletes a user account referenced by the specified ID")
    @DELETE
    @Path(value="/other/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteUser(@PathParam(value="id") @ApiParam(value="User ID") int id) {
        return SecurityContext.get().getCurrentUser().map(u -> {
            if (!u.getUserRole().isSuperAdmin() && !this.userDAO.isOrgAdmin(u)) {
                logger.warn("Failed to delete user {}: must be org admin or superadmin", (Object)id);
                return Response.PERMISSION_DENIED();
            }
            try {
                this.userDAO.deleteUser(id);
                return Response.OK();
            }
            catch (Exception e) {
                logger.warn("Failed to delete user", (Throwable)e);
                return Response.ERROR((String)e.getMessage());
            }
        }).orElse(Response.PERMISSION_DENIED());
    }

    @ApiOperation(value="Update user's details", notes="Update user's name and email.")
    @PUT
    @Path(value="/details")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUserDetails(User user) {
        return SecurityContext.get().getCurrentUser().map(u -> {
            User dbUser = this.userDAO.getUserDetails(user.getId().intValue());
            if (dbUser == null) {
                return Response.ERROR((String)"error.user.not.found");
            }
            if (user.getEmail() == null || user.getEmail().trim().equals("")) {
                dbUser.setEmail("");
            } else if (!user.getEmail().equalsIgnoreCase(dbUser.getEmail())) {
                User user2 = this.unsecureDAO.findByEmail(user.getEmail());
                if (user2 != null) {
                    logger.warn("User with email {} already exists, id {}", (Object)user.getEmail(), (Object)user2.getId());
                    return Response.ERROR((String)"error.duplicate.email");
                }
                dbUser.setEmail(user.getEmail());
            }
            dbUser.setName(user.getName());
            try {
                this.userDAO.updateUserMainDetails(dbUser);
                return Response.OK((String)"success.operation.completed", (Object)dbUser);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Response.INTERNAL_ERROR();
            }
        }).orElse(Response.PERMISSION_DENIED());
    }

    @ApiOperation(value="List user roles", notes="Gets the list of all available user roles", response=UserRole.class, responseContainer="List")
    @GET
    @Path(value="/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listUserRoles() {
        try {
            List roles = this.userDAO.findAllUserRoles();
            return Response.OK((Object)roles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.ERROR((String)e.getMessage());
        }
    }

    @ApiOperation(value="", hidden=true)
    @GET
    @Path(value="/superadmin/all/{customerId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCustomerUsersBySuperAdmin(@PathParam(value="customerId") Integer customerId) {
        if (SecurityContext.get().isSuperAdmin()) {
            return Response.OK(this.userDAO.findAllCustomerUsers(customerId.intValue()).stream().peek(user -> user.setPassword(null)).collect(Collectors.toList()));
        }
        return Response.PERMISSION_DENIED();
    }

    @ApiOperation(value="", hidden=true)
    @PUT
    @Path(value="/superadmin/password")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePasswordBySuperAdmin(User user) {
        if (SecurityContext.get().isSuperAdmin()) {
            user.setNewPassword(PasswordUtil.getHashFromMd5((String)user.getNewPassword()));
            this.userDAO.updatePasswordBySuperAdmin(user);
            return Response.OK((String)"success.operation.completed");
        }
        logger.warn("Failed to update password for user {}, must be super admin", (Object)user.getLogin());
        return Response.PERMISSION_DENIED();
    }

    @GET
    @Path(value="/impersonate/{id}")
    @Produces(value={"application/json"})
    public Response login(@PathParam(value="id") Integer id, @Context HttpServletRequest req, @Context HttpServletResponse res) throws IOException {
        return SecurityContext.get().getCurrentUser().map(u -> {
            if (!u.getUserRole().isSuperAdmin() && !this.userDAO.isOrgAdmin(u)) {
                logger.warn("Failed to impersonate as user {}: must be admin", (Object)id);
                return Response.PERMISSION_DENIED();
            }
            User user = this.userDAO.getUserDetails(id.intValue());
            if (user == null) {
                logger.warn("Failed to impersonate as user {}: user not found", (Object)id);
                return Response.INTERNAL_ERROR();
            }
            if (u.getCustomerId() != user.getCustomerId() && !u.getUserRole().isSuperAdmin()) {
                logger.warn("Failed to impersonate as user {}: belongs to another customer {}", (Object)id, (Object)u.getCustomerId());
                return Response.PERMISSION_DENIED();
            }
            HttpSession session = req.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            user.setPassword(null);
            HttpSession userSession = req.getSession(true);
            userSession.setAttribute(sessionCredentials, (Object)user);
            return Response.OK((Object)user);
        }).orElse(Response.PERMISSION_DENIED());
    }

    private Response updatePassword(User dbUser, User user) {
        if (user.getNewPassword() == null || user.getOldPassword() == null || !PasswordUtil.passwordMatch((String)user.getOldPassword(), (String)dbUser.getPassword())) {
            logger.warn("Failed to update password for {}: current password not match", (Object)user.getLogin());
            return Response.ERROR((String)"error.password.wrong");
        }
        if (user.getNewPassword() == null || user.getNewPassword().isEmpty()) {
            logger.warn("Failed to update password for {}: new password is empty", (Object)user.getLogin());
            return Response.ERROR((String)"error.password.empty");
        }
        dbUser.setPassword(PasswordUtil.getHashFromMd5((String)user.getNewPassword()));
        dbUser.setAuthToken(PasswordUtil.generateToken());
        dbUser.setPasswordReset(false);
        dbUser.setPasswordResetToken(null);
        this.userDAO.updatePassword(dbUser);
        logger.info("Password for {} is updated", (Object)user.getLogin());
        return Response.OK((String)"success.operation.completed", (Object)dbUser);
    }
}

