/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CommonDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.UserRoleSettingsDAO;
import com.hmdm.persistence.domain.Settings;
import com.hmdm.persistence.domain.UserRoleSettings;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Settings"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/settings")
public class SettingsResource {
    private static final Logger log = LoggerFactory.getLogger(SettingsResource.class);
    private CommonDAO commonDAO;
    private UserRoleSettingsDAO userRoleSettingsDAO;
    private UnsecureDAO unsecureDAO;

    public SettingsResource() {
    }

    @Inject
    public SettingsResource(CommonDAO commonDAO, UserRoleSettingsDAO userRoleSettingsDAO, UnsecureDAO unsecureDAO) {
        this.commonDAO = commonDAO;
        this.userRoleSettingsDAO = userRoleSettingsDAO;
        this.unsecureDAO = unsecureDAO;
    }

    @ApiOperation(value="Get settings", notes="Gets the current settings", response=Settings.class)
    @GET
    @Produces(value={"application/json"})
    public Response getSettings() {
        try {
            Settings settings = Optional.ofNullable(this.commonDAO.getSettings()).orElse(new Settings());
            settings.setSingleCustomer(this.unsecureDAO.isSingleCustomer());
            if (!settings.isSingleCustomer()) {
                this.commonDAO.loadCustomerSettings(settings);
            }
            return Response.OK((Object)settings);
        }
        catch (Exception e) {
            log.error("Unexpected error when getting the settings for customer", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Get user role settings", notes="Gets the current settings for role of the current user", response=UserRoleSettings.class)
    @GET
    @Path(value="/userRole/{roleId}")
    @Produces(value={"application/json"})
    public Response getUserRoleSettings(@PathParam(value="roleId") int roleId) {
        try {
            UserRoleSettings settings = this.userRoleSettingsDAO.getUserRoleSettings(roleId);
            if (settings == null) {
                UserRoleSettings defaultSettings = new UserRoleSettings();
                defaultSettings.setRoleId(roleId);
                settings = defaultSettings;
            }
            return Response.OK((Object)settings);
        }
        catch (Exception e) {
            log.error("Unexpected error when getting the user role settings for current user", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Save default design", notes="Save the settings for Default Design for mobile application", response=Settings.class)
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/design")
    public Response updateDefaultDesignSettings(Settings settings) {
        if (!SecurityContext.get().hasPermission("settings")) {
            log.error("Unauthorized attempt to update settings by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            this.commonDAO.saveDefaultDesignSettings(settings);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Unexpected error when saving default design settings", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Save user role common settings", notes="Save the settings for user roles", response=Settings.class)
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/userRoles/common")
    public Response updateUserRoleCommonSettings(List<UserRoleSettings> settings) {
        if (!SecurityContext.get().hasPermission("settings")) {
            log.error("Unauthorized attempt to update settings by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            this.userRoleSettingsDAO.saveCommonSettings(settings);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Unexpected error when saving user roles common settings", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Save language settings", notes="Save the language settings for MDM web application", response=Settings.class)
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/lang")
    public Response updateLanguageSettings(Settings settings) {
        if (!SecurityContext.get().hasPermission("settings")) {
            log.error("Unauthorized attempt to update settings by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            this.commonDAO.saveLanguageSettings(settings);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Unexpected error when saving language settings", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Save misc settings", notes="Save the misc settings for MDM web application", response=Settings.class)
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/misc")
    public Response updateMiscSettings(Settings settings) {
        if (!SecurityContext.get().hasPermission("settings")) {
            log.error("Unauthorized attempt to update settings by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            if (!this.unsecureDAO.isSingleCustomer()) {
                settings.setCreateNewDevices(false);
                settings.setNewDeviceGroupId(null);
                settings.setNewDeviceConfigurationId(null);
            }
            this.commonDAO.saveMiscSettings(settings);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Unexpected error when saving misc settings", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

