/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.ApplicationType;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.Device;
import com.hmdm.rest.json.NameResponse;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.UploadAppRequest;
import com.hmdm.util.CryptoUtil;
import com.hmdm.util.FileUtil;
import com.hmdm.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/public")
@Api(tags={"Mobile client API"})
public class PublicResource {
    private static final Logger logger = LoggerFactory.getLogger(PublicResource.class);
    private UnsecureDAO unsecureDAO;
    private CustomerDAO customerDAO;
    private String hashSecret;
    private String filesDirectory;
    private String baseUrl;
    private String appName;
    private String appLogo;
    private String appVendorName;
    private String appVendorLink;
    private String appSignupLink;
    private String appTermsLink;

    public PublicResource() {
    }

    @Inject
    public PublicResource(@Named(value="files.directory") String filesDirectory, @Named(value="base.url") String baseUrl, @Named(value="rebranding.name") String appName, @Named(value="rebranding.logo") String appLogo, @Named(value="rebranding.vendor.name") String appVendorName, @Named(value="rebranding.vendor.link") String appVendorLink, @Named(value="rebranding.signup.link") String appSignupLink, @Named(value="rebranding.terms.link") String appTermsLink, UnsecureDAO unsecureDAO, CustomerDAO customerDAO, @Named(value="hash.secret") String hashSecret) {
        this.filesDirectory = filesDirectory;
        this.baseUrl = baseUrl;
        this.appName = appName;
        this.appLogo = appLogo;
        this.appVendorName = appVendorName;
        this.appVendorLink = appVendorLink;
        this.appSignupLink = appSignupLink;
        this.appTermsLink = appTermsLink;
        this.unsecureDAO = unsecureDAO;
        this.customerDAO = customerDAO;
        this.hashSecret = hashSecret;
    }

    @ApiOperation(value="Upload application", notes="Uploads application to MDM server. This method is only used by the AppList utility, no usage by the web backend")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/applications/upload")
    public Response uploadFiles(@FormDataParam(value="file") InputStream uploadedInputStream, @ApiParam(value="A file to upload") @FormDataParam(value="file") FormDataContentDisposition fileDetail, @ApiParam(value="A JSON-string with application details") @FormDataParam(value="app") String app) throws Exception {
        logger.info("Received Upload App request. App: {}", (Object)app);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            UploadAppRequest request = (UploadAppRequest)objectMapper.readValue(app, UploadAppRequest.class);
            String deviceId = StringUtil.stripOffTrailingCharacter((String)request.getDeviceId(), (String)"\"");
            String hash = StringUtil.stripOffTrailingCharacter((String)request.getHash(), (String)"\"");
            ArrayList<String> errors = new ArrayList<String>();
            if (request.getName() == null || request.getName().isEmpty()) {
                errors.add("name");
            }
            if (request.getName() == null || request.getName().isEmpty()) {
                errors.add("name");
            }
            if (request.getPkg() == null || request.getPkg().isEmpty()) {
                errors.add("pkg");
            }
            if (request.getVersion() == null || request.getVersion().isEmpty()) {
                errors.add("version");
            }
            if (fileDetail != null && !fileDetail.getFileName().isEmpty() && uploadedInputStream != null) {
                if (request.getLocalPath() == null || request.getLocalPath().isEmpty()) {
                    errors.add("localPath");
                }
                if (request.getFileName() == null || request.getFileName().isEmpty()) {
                    errors.add("fileName");
                }
            }
            if (!FileUtil.isSafePath((String)request.getLocalPath()) || !FileUtil.isSafePath((String)request.getFileName())) {
                logger.error("Attempt to upload a file to unsafe path! local path: " + request.getLocalPath() + " File name: " + request.getFileName());
                return Response.PERMISSION_DENIED();
            }
            if (deviceId == null || deviceId.isEmpty()) {
                errors.add("deviceId");
            }
            if (hash == null || hash.isEmpty()) {
                errors.add("hash");
            }
            if (!errors.isEmpty()) {
                logger.error("Required data not specified: {}", errors);
                return Response.ERROR((String)"error.params.missing", errors);
            }
            String expectedHash = CryptoUtil.getMD5String((String)(deviceId + this.hashSecret));
            if (!expectedHash.equalsIgnoreCase(hash)) {
                logger.error("Hash invalid for upload app request from device {}. Expected: {} but got {}", new Object[]{deviceId, expectedHash, hash.toUpperCase()});
                System.out.println("Hash invalid: " + expectedHash + " vs " + hash);
                return Response.ERROR((String)"Invalid hash");
            }
            Device dbDevice = this.unsecureDAO.getDeviceByNumber(deviceId);
            if (dbDevice == null) {
                logger.error("Device not found: {}", (Object)deviceId);
                return Response.DEVICE_NOT_FOUND_ERROR();
            }
            List dbApps = this.unsecureDAO.findByPackageIdAndVersion(Integer.valueOf(dbDevice.getCustomerId()), request.getPkg(), request.getVersion());
            if (!dbApps.isEmpty()) {
                logger.error("Application with same package ID and version already exists: {} v{}", (Object)request.getPkg(), (Object)request.getVersion());
                return Response.DUPLICATE_APPLICATION();
            }
            Customer customer = this.customerDAO.findById(dbDevice.getCustomerId());
            boolean fileUploaded = false;
            if (fileDetail != null && !fileDetail.getFileName().isEmpty() && uploadedInputStream != null) {
                File uploadFile = new File(new File(new File(this.filesDirectory, customer.getFilesDir()), request.getLocalPath()), request.getFileName());
                File parentFile = uploadFile.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (parentFile.exists() && parentFile.isDirectory()) {
                    FileUtil.writeToFile((InputStream)uploadedInputStream, (String)uploadFile.getAbsolutePath());
                    fileUploaded = true;
                } else {
                    logger.error("Can not save the file on server in directory: {}", (Object)parentFile);
                    return Response.INTERNAL_ERROR();
                }
            }
            Application application = new Application();
            application.setName(request.getName());
            application.setPkg(request.getPkg());
            application.setShowIcon(request.isShowIcon());
            application.setUseKiosk(request.isUseKiosk());
            application.setRunAfterInstall(request.isRunAfterInstall());
            application.setRunAtBoot(request.isRunAtBoot());
            application.setSystem(request.isSystem());
            application.setVersion(request.getVersion());
            application.setCustomerId(dbDevice.getCustomerId());
            application.setType(ApplicationType.app);
            if (fileUploaded) {
                String url = String.format("%s/files/%s/%s/%s", this.baseUrl, URLEncoder.encode(customer.getFilesDir(), "UTF8"), URLEncoder.encode(request.getLocalPath(), "UTF8"), URLEncoder.encode(request.getFileName(), "UTF8"));
                application.setUrl(url);
            }
            this.unsecureDAO.insertApplication(application);
            logger.info("Application {} has been uploaded to server from device {} successfully", (Object)application, (Object)deviceId);
            return Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error while uploading application from mobile device", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Get name and vendor", notes="Gets the application name and vendor for rebranding purposes.")
    @GET
    @Path(value="/name")
    @Produces(value={"application/json"})
    public Response getRebranding() {
        NameResponse nameResponse = new NameResponse();
        nameResponse.setAppName(this.appName);
        nameResponse.setVendorName(this.appVendorName);
        nameResponse.setVendorLink(this.appVendorLink);
        nameResponse.setSignupLink(this.appSignupLink);
        nameResponse.setTermsLink(this.appTermsLink);
        return Response.OK((Object)nameResponse);
    }

    @ApiOperation(value="Get logo", notes="Returns the rebranded logo.")
    @GET
    @Path(value="/logo")
    @Produces(value={"application/json"})
    public jakarta.ws.rs.core.Response getRebrandedLogo() {
        try {
            if (!this.appLogo.equals("")) {
                File file = new File(this.appLogo);
                if (file.exists()) {
                    FileInputStream input = new FileInputStream(file);
                    return jakarta.ws.rs.core.Response.ok(output -> IOUtils.copy((InputStream)input, (OutputStream)output)).header("Cache-Control", (Object)"no-cache").header("Content-Type", (Object)"image/png").build();
                }
                System.out.println("Not found: " + file.getAbsolutePath());
                return jakarta.ws.rs.core.Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return jakarta.ws.rs.core.Response.temporaryRedirect((URI)new URI("../images/logo.png")).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return jakarta.ws.rs.core.Response.serverError().build();
        }
    }
}

