/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.IconDAO;
import com.hmdm.persistence.domain.Icon;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Icons"})
@Path(value="/private/icons")
@Singleton
public class IconResource {
    private static final Logger logger = LoggerFactory.getLogger(IconResource.class);
    private IconDAO iconDAO;

    public IconResource() {
    }

    @Inject
    public IconResource(IconDAO iconDAO) {
        this.iconDAO = iconDAO;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createIcon(Icon icon) {
        try {
            Icon newIcon = icon.getId() == null ? this.iconDAO.insertIcon(icon) : this.iconDAO.updateIcon(icon);
            return Response.OK((Object)newIcon);
        }
        catch (Exception e) {
            return Response.INTERNAL_ERROR();
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getIcons() {
        try {
            List allIcons = this.iconDAO.getAllIcons();
            return Response.OK((Object)allIcons);
        }
        catch (Exception e) {
            return Response.INTERNAL_ERROR();
        }
    }

    @GET
    @Path(value="/search/{value}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response searchIcons(@PathParam(value="value") @ApiParam(value="A filter value") String value) {
        try {
            List allIcons = this.iconDAO.getAllIconsByValue(value);
            return Response.OK((Object)allIcons);
        }
        catch (Exception e) {
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Delete an icon", notes="Delete an existing icon")
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeIcon(@PathParam(value="id") @ApiParam(value="Icon ID") Integer id) {
        if (!SecurityContext.get().hasPermission("settings")) {
            logger.error("Unauthorized attempt to update icons by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        this.iconDAO.removeById(id);
        return Response.OK();
    }
}

