/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.notification.PushService;
import com.hmdm.persistence.CommonDAO;
import com.hmdm.persistence.ConfigurationDAO;
import com.hmdm.persistence.ConfigurationFileDAO;
import com.hmdm.persistence.DeviceDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.ApplicationSetting;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.Device;
import com.hmdm.persistence.domain.DeviceSearchRequest;
import com.hmdm.persistence.domain.Settings;
import com.hmdm.rest.json.DeviceGroupBulkRequest;
import com.hmdm.rest.json.PaginatedData;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.view.devicelist.DeviceListView;
import com.hmdm.rest.json.view.devicelist.DeviceView;
import com.hmdm.security.SecurityContext;
import com.hmdm.security.SecurityException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Device"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/devices")
public class DeviceResource {
    private static final Logger log = LoggerFactory.getLogger(DeviceResource.class);
    private DeviceDAO deviceDAO;
    private ConfigurationDAO configurationDAO;
    private PushService pushService;
    private ConfigurationFileDAO configurationFileDAO;
    private CommonDAO commonDAO;
    private UnsecureDAO unsecureDAO;

    public DeviceResource() {
    }

    @Inject
    public DeviceResource(DeviceDAO deviceDAO, ConfigurationDAO configurationDAO, PushService pushService, ConfigurationFileDAO configurationFileDAO, CommonDAO commonDAO, UnsecureDAO unsecureDAO) {
        this.deviceDAO = deviceDAO;
        this.configurationDAO = configurationDAO;
        this.pushService = pushService;
        this.configurationFileDAO = configurationFileDAO;
        this.commonDAO = commonDAO;
        this.unsecureDAO = unsecureDAO;
    }

    @ApiOperation(value="Search devices", notes="Search devices meeting the specified filter value", response=DeviceListView.class)
    @POST
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getAllDevices(DeviceSearchRequest request) {
        PaginatedData devices = this.deviceDAO.getAllDevices(request);
        HashMap<Integer, List> configIdToApplicationsMap = new HashMap<Integer, List>();
        HashMap<Integer, List> configIdToFilesMap = new HashMap<Integer, List>();
        HashMap<Integer, Configuration> configIdToConfigurationsMap = new HashMap<Integer, Configuration>();
        for (Device device : devices.getItems()) {
            Integer deviceConfigurationId = device.getConfigurationId();
            Configuration dbConfig = null;
            if (!configIdToConfigurationsMap.containsKey(deviceConfigurationId) && (dbConfig = this.configurationDAO.getConfigurationById(deviceConfigurationId)) == null) {
                log.error("Device " + device.getNumber() + ": configuration does not exist: " + String.valueOf(deviceConfigurationId));
                device.setConfigurationId(null);
                continue;
            }
            if (!configIdToApplicationsMap.containsKey(deviceConfigurationId)) {
                configIdToApplicationsMap.put(deviceConfigurationId, this.configurationDAO.getConfigurationApplications(deviceConfigurationId));
            }
            if (!configIdToFilesMap.containsKey(deviceConfigurationId)) {
                configIdToFilesMap.put(deviceConfigurationId, this.configurationFileDAO.getConfigurationFiles(deviceConfigurationId));
            }
            if (!configIdToConfigurationsMap.containsKey(deviceConfigurationId)) {
                Configuration configuration = new Configuration();
                configuration.setId(deviceConfigurationId);
                configuration.setName(device.getConfigName());
                if (dbConfig.getMainAppId() != null && dbConfig.getMainAppId() > 0 && dbConfig.getEventReceivingComponent() != null && dbConfig.getEventReceivingComponent().length() > 0) {
                    configuration.setQrCodeKey(dbConfig.getQrCodeKey());
                    configuration.setBaseUrl(this.configurationDAO.getBaseUrl());
                }
                configuration.setApplications((List)configIdToApplicationsMap.get(deviceConfigurationId));
                configuration.setFiles((List)configIdToFilesMap.get(deviceConfigurationId));
                configIdToConfigurationsMap.put(deviceConfigurationId, configuration);
            }
            device.setConfiguration((Configuration)configIdToConfigurationsMap.get(deviceConfigurationId));
        }
        List deviceViews = devices.getItems().stream().filter(d -> d.getConfigurationId() != null).map(DeviceView::new).collect(Collectors.toList());
        PaginatedData devicesPage = new PaginatedData(deviceViews, devices.getTotalItemsCount());
        DeviceListView view = new DeviceListView(configIdToConfigurationsMap.values(), devicesPage);
        return Response.OK((Object)view);
    }

    @ApiOperation(value="Get the device info by number", notes="Get the device info by number", response=DeviceListView.class)
    @GET
    @Path(value="/number/{number}")
    @Produces(value={"application/json"})
    public Response getDevice(@PathParam(value="number") @ApiParam(value="Device number") String number) {
        try {
            Device device = this.deviceDAO.getDeviceByNumber(number);
            DeviceView deviceView = new DeviceView(device);
            return Response.OK((Object)deviceView);
        }
        catch (Exception e) {
            log.error("Cannot find device by number: " + number);
            return Response.DEVICE_NOT_FOUND_ERROR();
        }
    }

    @ApiOperation(value="")
    @POST
    @Path(value="/autocomplete")
    @Produces(value={"application/json"})
    public Response getDevicesForAutocomplete(String filter) {
        try {
            List devices = this.deviceDAO.findDevices(filter, 10);
            return Response.OK((Object)devices);
        }
        catch (Exception e) {
            log.error("Failed to search the devices due to unexpected error. Filter: {}", (Object)filter, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Create or update device", notes="Create a new device (if id is not provided) or update existing one otherwise.")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateDevice(Device device) {
        try {
            Device dbDevice;
            boolean canEditDevices = SecurityContext.get().hasPermission("edit_devices");
            if (!canEditDevices) {
                log.error("Unauthorized attempt to create or edit device", (Throwable)SecurityException.onCustomerDataAccessViolation((int)device.getId(), (String)"device"));
                return Response.PERMISSION_DENIED();
            }
            try {
                dbDevice = this.deviceDAO.getDeviceByNumber(device.getNumber());
            }
            catch (SecurityException e) {
                log.error("A different device with same number exists in other organization: {}", (Object)device.getNumber());
                return Response.DEVICE_EXISTS();
            }
            if (dbDevice != null && !dbDevice.getId().equals(device.getId())) {
                log.error("A different device with same number exists: {}", (Object)dbDevice);
                return Response.DEVICE_EXISTS();
            }
            dbDevice = this.deviceDAO.getDeviceById(device.getId());
            if (device.getId() != null) {
                if (dbDevice != null) {
                    boolean notify = dbDevice.getConfigurationId() != null && !dbDevice.getConfigurationId().equals(device.getConfigurationId()) || dbDevice.getOldNumber() == null && device.getOldNumber() != null;
                    this.deviceDAO.updateDevice(device);
                    if (notify) {
                        this.pushService.notifyDeviceOnSettingUpdate(device.getId());
                    }
                }
            } else if (device.getIds() != null) {
                for (Integer id : device.getIds()) {
                    dbDevice = this.deviceDAO.getDeviceById(id);
                    if (dbDevice == null) continue;
                    this.deviceDAO.updateDeviceConfiguration(id, device.getConfigurationId());
                    this.pushService.notifyDeviceOnSettingUpdate(dbDevice.getId());
                }
            } else {
                Settings settings = new Settings();
                if (!this.unsecureDAO.isSingleCustomer()) {
                    this.commonDAO.loadCustomerSettings(settings);
                }
                if (settings.getDeviceLimit() == 0 || settings.getDeviceCount() < settings.getDeviceLimit()) {
                    device.setLastUpdate(Long.valueOf(0L));
                    this.deviceDAO.insertDevice(device);
                } else {
                    log.warn("New device {} not added by customer {} due to the license limit", (Object)device.getNumber(), SecurityContext.get().getCurrentCustomerId().get());
                    return Response.ERROR();
                }
            }
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Unexpected error when saving/creating device", (Throwable)e);
            return Response.ERROR();
        }
    }

    @ApiOperation(value="Delete device", notes="Delete an existing device")
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeDevice(@PathParam(value="id") @ApiParam(value="Device ID") Integer id) {
        boolean canEditDevices = SecurityContext.get().hasPermission("edit_devices");
        if (!canEditDevices) {
            log.error("Unauthorized attempt to delete device", (Throwable)SecurityException.onCustomerDataAccessViolation((int)id, (String)"device"));
            return Response.PERMISSION_DENIED();
        }
        this.deviceDAO.removeDeviceById(id);
        return Response.OK();
    }

    @ApiOperation(value="Delete bulk devices", notes="Delete multiple devices at once")
    @POST
    @Path(value="/deleteBulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeBulkDevices(Device device) {
        boolean canEditDevices = SecurityContext.get().hasPermission("edit_devices");
        if (!canEditDevices) {
            log.error("Unauthorized attempt to delete devices", (Throwable)SecurityException.onCustomerDataAccessViolation((int)0, (String)"device"));
            return Response.PERMISSION_DENIED();
        }
        if (device.getIds() != null) {
            for (Integer id : device.getIds()) {
                this.deviceDAO.removeDeviceById(id);
            }
        }
        return Response.OK();
    }

    @ApiOperation(value="Set or clear device groups in bulk")
    @POST
    @Path(value="/groupBulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateDeviceGroupBulk(DeviceGroupBulkRequest request) {
        boolean canEditDevices = SecurityContext.get().hasPermission("edit_devices");
        if (!canEditDevices) {
            log.error("Unauthorized attempt to delete devices", (Throwable)SecurityException.onCustomerDataAccessViolation((int)0, (String)"device"));
            return Response.PERMISSION_DENIED();
        }
        if (request.getIds() != null) {
            for (Integer id : request.getIds()) {
                Device device = this.deviceDAO.getDeviceById(id);
                if (device == null) continue;
                List groups = device.getGroups();
                groups.removeAll(request.getGroups());
                if (request.getAction().equals("set")) {
                    groups.addAll(request.getGroups());
                }
                this.deviceDAO.updateDevice(device);
            }
        }
        return Response.OK();
    }

    @ApiOperation(value="Get device application settings", notes="Get application settings set at device level")
    @GET
    @Path(value="/{id}/applicationSettings")
    @Produces(value={"application/json"})
    public Response getDeviceApplicationSettings(@PathParam(value="id") @ApiParam(value="Device ID") Integer id) {
        try {
            List deviceApplicationSettings = this.deviceDAO.getDeviceApplicationSettings(id.intValue());
            return Response.OK((Object)deviceApplicationSettings);
        }
        catch (Exception e) {
            log.error("Failed to retrieve the application settings for device #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Save device application settings", notes="Save application settings set at device level")
    @POST
    @Path(value="/{id}/applicationSettings")
    @Produces(value={"application/json"})
    public Response saveDeviceApplicationSettings(@PathParam(value="id") @ApiParam(value="Device ID") Integer id, List<ApplicationSetting> applicationSettings) {
        try {
            this.deviceDAO.saveDeviceApplicationSettings(id, applicationSettings);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Failed to save the application settings for device #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Notify device on update", notes="Sends a notification to device on application settings update", response=Void.class)
    @POST
    @Path(value="/{id}/applicationSettings/notify")
    @Produces(value={"application/json"})
    public Response notifyDevicesOnUpdate(@PathParam(value="id") Integer id) {
        try {
            this.pushService.notifyDeviceOnApplicationSettingUpdate(id);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Failed to send notification on application settings update to device #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Save device description", notes="Updates existing device description")
    @POST
    @Path(value="/{id}/description")
    @Produces(value={"application/json"})
    public Response saveDeviceDescription(@PathParam(value="id") @ApiParam(value="Device ID") Integer deviceId, String newDeviceDescription) {
        try {
            boolean canEditDeviceDescription = SecurityContext.get().hasPermission("edit_device_desc");
            if (!canEditDeviceDescription) {
                log.error("Unauthorized attempt to edit device description", (Throwable)SecurityException.onCustomerDataAccessViolation((int)deviceId, (String)"device"));
                return Response.PERMISSION_DENIED();
            }
            this.deviceDAO.updateDeviceDescription(deviceId, newDeviceDescription);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Failed to save the description for device #{}", (Object)deviceId, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

