/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.UserDAO;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.CustomerSearchRequest;
import com.hmdm.rest.json.PaginatedData;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import com.hmdm.service.MailchimpService;
import com.hmdm.util.PasswordUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/private/customers")
public class CustomerResource {
    private static final Logger log = LoggerFactory.getLogger(CustomerResource.class);
    private static final String sessionCredentials = "credentials";
    private CustomerDAO customerDAO;
    private UnsecureDAO unsecureDAO;
    private UserDAO userDAO;
    private MailchimpService mailchimpService;

    public CustomerResource() {
    }

    @Inject
    public CustomerResource(CustomerDAO customerDAO, UnsecureDAO unsecureDAO, UserDAO userDAO, MailchimpService mailchimpService) {
        this.customerDAO = customerDAO;
        this.unsecureDAO = unsecureDAO;
        this.userDAO = userDAO;
        this.mailchimpService = mailchimpService;
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @Deprecated
    public Response getAllCustomers() {
        try {
            return Response.OK((Object)this.customerDAO.getAllCustomers());
        }
        catch (Exception e) {
            log.error("Unexpected error when searching for all customer accounts for", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @GET
    @Path(value="/search/{value}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response searchCustomers(@PathParam(value="value") String value) {
        try {
            return Response.OK((Object)this.customerDAO.getAllCustomersByValue(value));
        }
        catch (Exception e) {
            log.error("Unexpected error when searching customer accounts for: {}", (Object)value, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @POST
    @Path(value="/search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response searchCustomers(CustomerSearchRequest request) {
        try {
            PaginatedData customers = this.customerDAO.searchCustomers(request);
            return Response.OK((Object)customers);
        }
        catch (Exception e) {
            log.error("Unexpected error when searching for customer accounts matching: {}", (Object)request, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateCustomer(Customer customer) {
        try {
            Customer dbCustomer = this.customerDAO.getCustomerByName(customer.getName());
            if (dbCustomer != null && !dbCustomer.getId().equals(customer.getId())) {
                log.warn("Customer with name {} already exists, id {}", (Object)customer.getName(), (Object)dbCustomer.getId());
                return Response.DUPLICATE_ENTITY((String)"error.duplicate.customer.name");
            }
            if (customer.getEmail() != null && !customer.getEmail().trim().equals("")) {
                dbCustomer = this.customerDAO.getCustomerByEmail(customer.getEmail());
                if (dbCustomer != null && !dbCustomer.getId().equals(customer.getId())) {
                    log.warn("Customer with email {} already exists, id {}", (Object)customer.getEmail(), (Object)dbCustomer.getId());
                    return Response.DUPLICATE_ENTITY((String)"error.duplicate.email");
                }
                User dbUser = this.unsecureDAO.findByEmail(customer.getEmail());
                if (dbUser != null && (customer.getId() == null || dbUser.getCustomerId() != customer.getId().intValue())) {
                    log.warn("User with email {} already exists, customer {}", (Object)customer.getEmail(), (Object)dbUser.getCustomerId());
                    return Response.DUPLICATE_ENTITY((String)"error.duplicate.email");
                }
            }
            if (customer.getId() == null) {
                String adminCredentials = this.customerDAO.insertCustomer(customer);
                if (customer.getEmail() != null && !customer.getEmail().trim().equals("") && this.mailchimpService.initialize()) {
                    this.mailchimpService.subscribe(customer, "cloud_demo");
                }
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("adminCredentials", adminCredentials);
                return Response.OK(result);
            }
            this.customerDAO.updateCustomer(customer);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Unexpected error when saving customer account {}", (Object)customer, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeCustomer(@PathParam(value="id") Integer id) {
        try {
            this.customerDAO.removeCustomerById(id);
            return Response.OK();
        }
        catch (Exception e) {
            log.error("Unexpected error when deleting customer account #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @GET
    @Path(value="/{id}/edit")
    @Produces(value={"application/json"})
    public Response getCustomerForUpdate(@PathParam(value="id") Integer id) {
        try {
            Customer customer = this.customerDAO.findByIdForUpdate(id.intValue());
            return Response.OK((Object)customer);
        }
        catch (Exception e) {
            log.error("Unexpected error when loading customer details for update: #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @GET
    @Path(value="/prefix/{prefix}/used")
    @Produces(value={"application/json"})
    public Response validatePrefix(@PathParam(value="prefix") String prefix) {
        try {
            boolean prefixUsed = this.customerDAO.isPrefixUsed(prefix);
            return Response.OK((Object)prefixUsed);
        }
        catch (Exception e) {
            log.error("Unexpected error when checking customer prefix {} for usage", (Object)prefix, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @GET
    @Path(value="/impersonate/{id}")
    @Produces(value={"application/json"})
    public Response impersonateCustomer(@PathParam(value="id") Integer id, @Context HttpServletRequest req, @Context HttpServletResponse res) throws IOException {
        try {
            if (SecurityContext.get().isSuperAdmin()) {
                Customer customer = this.customerDAO.findById(id.intValue());
                User orgAdmin = this.userDAO.findOrgAdmin(customer.getId());
                if (orgAdmin != null) {
                    HttpSession session = req.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    if (orgAdmin.getAuthToken() == null || orgAdmin.getAuthToken().length() == 0) {
                        User user = this.unsecureDAO.findByLoginOrEmail(orgAdmin.getLogin());
                        user.setAuthToken(PasswordUtil.generateToken());
                        user.setNewPassword(user.getPassword());
                        this.unsecureDAO.setUserNewPasswordUnsecure(user);
                        orgAdmin.setAuthToken(user.getAuthToken());
                    }
                    orgAdmin.setPassword(null);
                    HttpSession userSession = req.getSession(true);
                    userSession.setAttribute(sessionCredentials, (Object)orgAdmin);
                    return Response.OK((Object)orgAdmin);
                }
                log.warn("Failed to impersonate: org admin not found for customer {}", (Object)customer.getName());
                return Response.ERROR((String)"error.notfound.customer.admin");
            }
            log.warn("Failed to impersonate: the user must be super admin");
            return Response.PERMISSION_DENIED();
        }
        catch (Exception e) {
            log.error("Unexpected error when impersonating administrator for customer account: #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

