/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view.devicelist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hmdm.persistence.domain.Device;
import com.hmdm.rest.json.DeviceInfo;
import com.hmdm.rest.json.LookupItem;
import com.hmdm.rest.json.view.devicelist.DeviceInfoView;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"device", "deviceInfo"}, ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="A device registered to MDM server and running the MDM mobile application")
public class DeviceView {
    private static final Logger logger = LoggerFactory.getLogger(DeviceView.class);
    private final Device device;
    private final DeviceInfoView deviceInfo;

    public DeviceView(Device device) {
        this.device = device;
        DeviceInfo info = null;
        try {
            if (device.getInfo() != null && !device.getInfo().trim().isEmpty()) {
                String deviceInfoString = device.getInfo();
                ObjectMapper jsonMapper = new ObjectMapper();
                info = (DeviceInfo)jsonMapper.readValue(deviceInfoString, DeviceInfo.class);
            }
        }
        catch (IOException e) {
            logger.error("Failed to parse JSON data from info property", (Throwable)e);
        }
        this.deviceInfo = info != null ? new DeviceInfoView(info) : null;
    }

    @ApiModelProperty(value="An ID of device")
    public Integer getId() {
        return this.device.getId();
    }

    @ApiModelProperty(value="An ID of configuration for device")
    public Integer getConfigurationId() {
        return this.device.getConfigurationId();
    }

    @ApiModelProperty(value="An unique textual identifier of device")
    public String getNumber() {
        return this.device.getNumber();
    }

    @ApiModelProperty(value="A description of device")
    public String getDescription() {
        return this.device.getDescription();
    }

    @ApiModelProperty(value="A date of last synchronization of device state (in milliseconds since epoch time)")
    public Long getLastUpdate() {
        return this.device.getLastUpdate();
    }

    @ApiModelProperty(value="An IMEI of device as set by the administrator")
    public String getImei() {
        return this.device.getImei();
    }

    @ApiModelProperty(value="A phone number of device as set by the administrator")
    public String getPhone() {
        return this.device.getPhone();
    }

    @ApiModelProperty(value="A public IP of device")
    public String getPublicIp() {
        return this.device.getPublicIp();
    }

    @ApiModelProperty(value="Custom property #1")
    public String getCustom1() {
        return this.device.getCustom1();
    }

    @ApiModelProperty(value="Custom property #2")
    public String getCustom2() {
        return this.device.getCustom2();
    }

    @ApiModelProperty(value="Custom property #3")
    public String getCustom3() {
        return this.device.getCustom3();
    }

    @ApiModelProperty(value="Old device number, used when the number is changed")
    public String getOldNumber() {
        return this.device.getOldNumber();
    }

    @ApiModelProperty(value="A list of groups assigned to device")
    public List<LookupItem> getGroups() {
        return this.device.getGroups();
    }

    @ApiModelProperty(value="A flag indicating if MDM mode is activated on the device")
    public Boolean getMdmMode() {
        return this.device.getMdmMode();
    }

    @ApiModelProperty(value="A flag indicating if kiosk mode is activated on the device")
    public Boolean getKioskMode() {
        return this.device.getKioskMode();
    }

    @ApiModelProperty(value="Version of Android OS on the device")
    public String getAndroidVersion() {
        return this.device.getAndroidVersion();
    }

    @ApiModelProperty(value="Date and time of the device enrollment")
    public Long getEnrollTime() {
        return this.device.getEnrollTime();
    }

    @ApiModelProperty(value="Device serial number")
    public String getSerial() {
        return this.device.getSerial();
    }

    @ApiModelProperty(value="A version number for Launcher application installed on device")
    public String getLauncherVersion() {
        return this.device.getLauncherVersion();
    }

    @ApiModelProperty(value="A package ID for Launcher application installed on device")
    public String getLauncherPkg() {
        return this.device.getLauncherPkg();
    }

    @ApiModelProperty(value="A color coding the current status of the device", allowableValues="green,red,yellow,brown,grey")
    public String getStatusCode() {
        return this.device.getStatusCode();
    }

    @ApiModelProperty(value="An info on device state submitted by device to MDM server")
    public DeviceInfoView getInfo() {
        return this.deviceInfo;
    }
}

