/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view.devicelist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.rest.json.PaginatedData;
import com.hmdm.rest.json.view.devicelist.ConfigurationView;
import com.hmdm.rest.json.view.devicelist.DeviceView;
import io.swagger.annotations.ApiModel;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="The list of devices with configurations lookup")
public class DeviceListView
implements Serializable {
    private final Map<Integer, ConfigurationView> configurations;
    private final PaginatedData<DeviceView> devices;

    public DeviceListView(@NotNull Collection<Configuration> configurations, @NotNull PaginatedData<DeviceView> devices) {
        this.configurations = configurations.stream().map(ConfigurationView::new).collect(Collectors.toMap(ConfigurationView::getId, c -> c));
        this.devices = devices;
    }

    public Map<Integer, ConfigurationView> getConfigurations() {
        return this.configurations;
    }

    public PaginatedData<DeviceView> getDevices() {
        return this.devices;
    }
}

