/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view.devicelist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.rest.json.DeviceConfigurationFile;
import com.hmdm.rest.json.DeviceInfo;
import com.hmdm.rest.json.view.devicelist.DeviceApplicationView;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonIgnoreProperties(value={"deviceInfo", "deviceApplications"}, ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="The details related to a single device. Such details are sent from the MDM mobile application to MDM server")
public class DeviceInfoView
implements Serializable {
    private final DeviceInfo deviceInfo;
    private final List<DeviceApplicationView> deviceApplications;
    private final List<DeviceConfigurationFile> files;

    DeviceInfoView(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
        this.deviceApplications = Optional.ofNullable(deviceInfo.getApplications()).map(apps -> apps.stream().map(DeviceApplicationView::new).collect(Collectors.toList())).orElse(new ArrayList());
        this.files = Optional.ofNullable(deviceInfo.getFiles()).orElse(new ArrayList());
    }

    @ApiModelProperty(value="A name of the device model")
    public String getModel() {
        return this.deviceInfo.getModel();
    }

    @ApiModelProperty(value="A list of permissions set for device. Contains exactly three elements (each either 0 or 1).")
    public List<Integer> getPermissions() {
        return this.deviceInfo.getPermissions();
    }

    @ApiModelProperty(value="A list of applications installed on device")
    public List<DeviceApplicationView> getApplications() {
        return this.deviceApplications;
    }

    @ApiModelProperty(value="A textual identifier of device within MDM server (e.g. device number)")
    public String getDeviceId() {
        return this.deviceInfo.getDeviceId();
    }

    @ApiModelProperty(value="An IMEI identifier for device")
    public String getImei() {
        return this.deviceInfo.getImei();
    }

    @ApiModelProperty(value="A phone number for device")
    public String getPhone() {
        return this.deviceInfo.getPhone();
    }

    @ApiModelProperty(value="A battery level in percents", allowableValues="range[0, 100]")
    public Integer getBatteryLevel() {
        return this.deviceInfo.getBatteryLevel();
    }

    @ApiModelProperty(value="A flag indicating if MDM mode is activated on the device")
    public Boolean getMdmMode() {
        return this.deviceInfo.getMdmMode();
    }

    @ApiModelProperty(value="A flag indicating if kiosk mode is activated on the device")
    public Boolean getKioskMode() {
        return this.deviceInfo.getKioskMode();
    }

    @ApiModelProperty(value="Version of Android OS on the device")
    public String getAndroidVersion() {
        return this.deviceInfo.getAndroidVersion();
    }

    @ApiModelProperty(value="Serial number of the device")
    public String getSerial() {
        return this.deviceInfo.getSerial();
    }

    @ApiModelProperty(value="A flag showing if Headwind MDM is set as default launcher on a device")
    public Boolean getDefaultLauncher() {
        return this.deviceInfo.getDefaultLauncher();
    }

    @ApiModelProperty(value="A list of configuration files installed on device")
    public List<DeviceConfigurationFile> getFiles() {
        return this.files;
    }
}

