/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view.devicelist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.persistence.domain.Application;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@JsonIgnoreProperties(value={"application"}, ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="A specification of a single application available for usage on mobile device")
public class ApplicationView
implements Serializable {
    private static final long serialVersionUID = 2154319093765210298L;
    private final Application application;

    ApplicationView(Application application) {
        this.application = application;
    }

    @ApiModelProperty(value="A package ID of application")
    public String getPkg() {
        return this.application.getPkg();
    }

    @ApiModelProperty(value="A version of application")
    public String getVersion() {
        return this.application.getVersion();
    }

    @ApiModelProperty(value="An URL for application package")
    public String getUrl() {
        if (this.application.getUrl() != null) {
            return this.application.getUrl();
        }
        if (this.application.getUrlArm64() != null) {
            return this.application.getUrlArm64();
        }
        return this.application.getUrlArmeabi();
    }

    @ApiModelProperty(value="An application ID")
    public Integer getId() {
        return this.application.getId();
    }

    @ApiModelProperty(value="A flag indicating if application is used in device configuration")
    public boolean isSelected() {
        return this.application.isSelected();
    }

    @ApiModelProperty(value="A flag indicating if application version shouldnt be checked")
    public boolean isSkipVersion() {
        return this.application.isSkipVersion();
    }

    @ApiModelProperty(value="The action required to be performed by mobile device", allowableValues="0,1,2")
    public int getAction() {
        return this.application.getAction();
    }

    @ApiModelProperty(value="A name of application")
    public String getName() {
        return this.application.getName();
    }
}

