/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.rest.json.SyncApplicationSettingInt;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(description="A single setting for an application installed and used on mobile device and used in data sycnhronization between mobile device and server application")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncApplicationSetting
implements Serializable,
SyncApplicationSettingInt {
    private static final long serialVersionUID = -3986494672661532347L;
    @ApiModelProperty(value="A package of the application", required=true)
    private String packageId;
    @ApiModelProperty(value="A name of the setting", required=true)
    private String name;
    @ApiModelProperty(value="A type of the application setting. 1 - String, 2 - Integer, 3 - Boolean", required=true, allowableValues="1,2,3")
    private int type;
    @ApiModelProperty(value="A value of the setting")
    private String value;
    @ApiModelProperty(value="A flag indicating if setting can not be modified on device", required=true)
    private Boolean readonly;
    @ApiModelProperty(value="A timestamp of the last update of the setting (in milliseconds since epoch time")
    private long lastUpdate;

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean isReadonly() {
        return this.readonly != null && this.readonly != false ? Boolean.valueOf(true) : null;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String toString() {
        return "SyncApplicationSetting{packageId='" + this.packageId + "', name='" + this.name + "', type=" + this.type + ", value='" + this.value + "', readonly=" + String.valueOf(this.readonly) + ", lastUpdate=" + this.lastUpdate + "}";
    }
}

