/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import com.hmdm.guice.module.ConfigureModule;
import com.hmdm.guice.module.EventListenerModule;
import com.hmdm.guice.module.LiquibaseModule;
import com.hmdm.guice.module.MainRestModule;
import com.hmdm.guice.module.PersistenceModule;
import com.hmdm.guice.module.PrivateRestModule;
import com.hmdm.guice.module.PublicRestModule;
import com.hmdm.guice.module.StartupTaskModule;
import com.hmdm.notification.guice.module.NotificationEngineSelectorModule;
import com.hmdm.notification.guice.module.NotificationLiquibaseModule;
import com.hmdm.notification.guice.module.NotificationMqttConfigModule;
import com.hmdm.notification.guice.module.NotificationMqttTaskModule;
import com.hmdm.notification.guice.module.NotificationPersistenceModule;
import com.hmdm.notification.guice.module.NotificationRestModule;
import com.hmdm.notification.guice.module.NotificationTaskModule;
import com.hmdm.plugin.PluginList;
import com.hmdm.plugin.PluginTaskModule;
import com.hmdm.plugin.guice.module.PluginLiquibaseModule;
import com.hmdm.plugin.guice.module.PluginPersistenceModule;
import com.hmdm.plugin.guice.module.PluginPlatformTaskModule;
import com.hmdm.plugin.guice.module.PluginRestModule;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;

public final class Initializer
extends GuiceServletContextListener {
    private ServletContext context;
    private Injector injector;

    protected Injector getInjector() {
        boolean success = false;
        StringWriter errorOut = new StringWriter();
        PrintWriter errorWriter = new PrintWriter(errorOut);
        try {
            this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)this.getModules());
            success = true;
        }
        catch (Exception e) {
            System.err.println("[HMDM-INITIALIZER]: Unexpected error during injector initialization: " + String.valueOf(e));
            e.printStackTrace();
            e.printStackTrace(errorWriter);
        }
        if (success) {
            System.out.println("[HMDM-INITIALIZER]: Application initialization was successful");
            this.onInitializationCompletion(null);
        } else {
            System.out.println("[HMDM-INITIALIZER]: Application initialization has failed");
            this.onInitializationCompletion(errorOut);
        }
        return this.injector;
    }

    private void onInitializationCompletion(StringWriter errorOut) {
        String signalFilePath = this.context.getInitParameter("initialization.completion.signal.file");
        if (signalFilePath != null && !signalFilePath.trim().isEmpty()) {
            File signalFile = new File(signalFilePath);
            if (!signalFile.exists()) {
                try {
                    FileWriter fw = new FileWriter(signalFile);
                    PrintWriter pw = new PrintWriter(fw);
                    if (errorOut == null) {
                        pw.print("OK");
                    } else {
                        pw.print(errorOut.toString());
                    }
                    pw.close();
                    fw.close();
                    System.out.println("[HMDM-INITIALIZER]: Created a signal file for application initialization completion: " + signalFile.getAbsolutePath());
                }
                catch (IOException e) {
                    System.err.println("[HMDM-INITIALIZER]: Failed to create and write to signal file '" + signalFile.getAbsolutePath() + "' for application initialization completion" + String.valueOf(e));
                }
            } else {
                System.out.println("[HMDM-INITIALIZER]: The signal file for application initialization completion already exists: " + signalFile.getAbsolutePath());
            }
        } else {
            System.out.println("Could not find 'initialization.completion.signal.file' parameter in context. Signaling on application initialization completion will be skipped.");
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.context = servletContextEvent.getServletContext();
        String log4jConfig = this.context.getInitParameter("log4j.config");
        if (log4jConfig != null && !log4jConfig.isEmpty()) {
            System.out.println("[HMDM-LOGGING] : Using log4j configuration from: " + log4jConfig);
            System.setProperty("log4j.configuration", log4jConfig);
            System.setProperty("log4j.ignoreTCL", "true");
        } else {
            System.out.println("[HMDM-LOGGING] Using log4j configuration from build");
        }
        super.contextInitialized(servletContextEvent);
        this.initTasks();
    }

    private List<Module> getModules() {
        LinkedList<Module> modules = new LinkedList<Module>();
        modules.add((Module)new PersistenceModule(this.context));
        modules.add((Module)new LiquibaseModule(this.context));
        modules.add((Module)new ConfigureModule(this.context));
        modules.add((Module)new MainRestModule());
        modules.add((Module)new PublicRestModule());
        modules.add((Module)new PrivateRestModule());
        modules.add((Module)new NotificationPersistenceModule(this.context));
        modules.add((Module)new NotificationLiquibaseModule(this.context));
        modules.add((Module)new NotificationRestModule());
        modules.add((Module)new NotificationEngineSelectorModule());
        modules.add((Module)new NotificationMqttConfigModule(this.context));
        modules.add((Module)new PluginPersistenceModule(this.context));
        modules.add((Module)new PluginLiquibaseModule(this.context));
        modules.add((Module)new PluginRestModule());
        PluginList.init((ServletContext)this.context);
        modules.addAll(PluginList.getPluginModules());
        return modules;
    }

    private void initTasks() {
        NotificationTaskModule notificationTaskModule = (NotificationTaskModule)this.injector.getInstance(NotificationTaskModule.class);
        notificationTaskModule.init();
        NotificationMqttTaskModule notificationMqttTaskModule = (NotificationMqttTaskModule)this.injector.getInstance(NotificationMqttTaskModule.class);
        notificationMqttTaskModule.init();
        PluginPlatformTaskModule pluginPlatformTaskModule = (PluginPlatformTaskModule)this.injector.getInstance(PluginPlatformTaskModule.class);
        pluginPlatformTaskModule.init();
        List pluginTaskModules = PluginList.getPluginTaskModules();
        if (pluginTaskModules != null) {
            pluginTaskModules.forEach(clazz -> {
                try {
                    PluginTaskModule pluginTaskModule = (PluginTaskModule)this.injector.getInstance(clazz);
                    pluginTaskModule.init();
                }
                catch (Exception e) {
                    System.err.println("Failed to instantiate and initialize plugin task module '" + clazz.getName() + "': " + String.valueOf(e));
                }
            });
        }
        EventListenerModule eventListenerModule = (EventListenerModule)this.injector.getInstance(EventListenerModule.class);
        eventListenerModule.init();
        StartupTaskModule startupTaskModule = (StartupTaskModule)this.injector.getInstance(StartupTaskModule.class);
        startupTaskModule.init();
    }
}

