if (! document.localization) document.localization = [];

document.localization ['it_IT'] = {
	'login.username': 'Nome utente o e-mail',
	'login.username.placeholder': 'Inserisci il tuo nome utente o e-mail',
	'login.password': 'Password:',
	'login.password.placeholder': 'Inserisci password',
	'login.submit': 'Accedi',
	'login.password.incorrect': 'Nome utente o password non validi',
	'login.password.recovery': 'Password smarrita?',
	'recovery.password': 'Recupera password',
	'recovery.password.success': 'Le istruzioni per il recupero della password sono state inviate alla tua e-mail',
	'login.no.account': 'Non hai un account?',
	'login.signup': 'Registrati',

	'signup.title': 'Inizia',
	'signup.email': 'Il tuo indirizzo email',
	'signup.email.placeholder': 'Inserisci un indirizzo email valido',
	'signup.email.invalid': 'Inserisci un indirizzo email valido',
	'signup.terms.agree': 'Accetto',
	'signup.terms.terms': 'termini e condizioni',
	'signup.submit': 'Registrati',
	'signup.progress': 'Registrazione in corso...',
	'signup.email.used': 'Un cliente con questa email è già registrato',
	'signup.name.used': 'Un cliente con questo nome utente è già registrato',
	'signup.complete': 'Grazie per esserti registrato!',
	'signup.email.check': 'Controlla la tua email e segui il link per completare la registrazione!',
	'signup.complete.title': 'Il tuo account su ${appName} è quasi pronto!',
	'signup.ready.title': 'Il tuo account su ${appName} è pronto!',
	'signup.customer.id': 'Nome utente',
	'signup.customer.id.placeholder': 'Usa solo lettere e cifre',
	'signup.customer.id.invalid': 'Usa solo 6 o più caratteri, lettere e cifre',
	'signup.first.name': 'Nome',
	'signup.first.name.placeholder': 'Il tuo nome (obbligatorio)',
	'signup.last.name': 'Cognome',
	'signup.last.name.placeholder': 'Il tuo cognome (obbligatorio)',
	'signup.company': 'Nome azienda',
	'signup.company.placeholder': 'Nome della tua attività (facoltativo)',
	'signup.description': 'Come utilizzerai MDM?',
	'signup.description.placeholder': 'Questo aiuterà il nostro team ad assisterti',
	'signup.password': 'Password',
	'signup.password.repeat': 'Ripeti la password',
	'signup.password.placeholder': '6+ caratteri',
	'signup.password.short': 'Inserisci almeno 6 caratteri',
	'signup.password.not.match': 'Le password non corrispondono',
	'signup.finalized.title': 'Il tuo account è pronto!',
	'signup.finalized.description': 'A breve, dovresti ricevere l\'email contenente istruzioni utili. Si prega di rivedere questa e-mail e di accedere al pannello Web utilizzando il nome utente e la password.',
	'signup.token.invalid.title': 'Il token non è valido o è già stato utilizzato',
	'signup.token.invalid.description': 'Riprova a registrarti per creare un nuovo account!',

	'header.label.username': 'Nome utente',

	'summary.devices.status': 'Stato dispositivo',
	'summary.devices.active': 'Attivo',
	'summary.devices.idle': 'Inattivo',
	'summary.devices.offline': 'Offline',
	'summary.devices.enrollment': 'Riepilogo iscrizione',
	'summary.devices.enrolled.total': 'Totale iscritti',
	'summary.devices.enrolled.earlier': 'Registrato prima',
	'summary.devices.enrolled.monthly': 'Ultimi 30 giorni',
	'summary.devices.installation.status': 'Stato applicazione',
	'summary.devices.installation.completed': 'Completato',
	'summary.devices.version.mismatch': 'Versione non corrispondente',
	'summary.devices.installation.failed': 'Installazione non riuscita',
	'summary.devices.enrolled.lastyear': 'Ultimi 12 mesi',

	'devices.group.options.all': 'Tutti i gruppi',
	'devices.configuration.options.all': 'Tutte le configurazioni',
	'devices.permissions.all': 'Tutte le autorizzazioni sono concesso',
	'devices.permissions.not.as.device.admin': '- L\'applicazione non è installata come amministratore del dispositivo',
	'devices.permissions.window.overlap.prohibited': '- La sovrapposizione su altre finestre non è disponibile',
	'devices.permissions.history.access.prohibited': '- L\'accesso alla cronologia di utilizzo non è configurato',
	'devices.unknown': 'Sconosciuto',
	'devices.model.unknown': 'Sconosciuto',
	'devices.date.unknown': 'sconosciuto',
	'devices.date.format': 'dd/MM/yy HH:mm',
	'devices.app.installed': '- ${applicationName}: installato.',
	'devices.app.not.installed': '- ${applicationName}: non installato.',
	'devices.app.version.available': ', disponibile ${applicationVersion}',
	'devices.app.installed.and.version.available': '- ${applicationName}: installato ${applicationInstalledVersion}, disponibile ${applicationVersionAvailable}',
	'devices.app.needs.removal': '${applicationVersion}, è richiesta la rimozione',
	'devices.no.data': 'Il dispositivo non ha trasmesso dati',
	'devices.settings.conformance.broken': 'Mancata corrispondenza con le impostazioni: (${serverData})',
	'devices.file.installed': '- ${file}: installato',
	'devices.file.not.installed': '- ${file}: non installato.',
	'devices.file.lastUpdate.differs': '- ${file}: differenza nell\'orario di modifica ${diff} min',

	'button.apply': 'Applica',
	'button.gps.on': 'Abilita GPS',
	'button.wifi.on': 'Abilita Wi-Fi',
	'button.notify.update': 'Notifica aggiornamento',
	'button.app.settings': 'Impostazioni applicazione',
	'button.ok': 'OK',
	'button.help': 'Aiuto',
	'button.new.app': 'Nuova applicazione',
	'button.new.app.version': 'Nuova versione',
	'button.upgrade': 'Aggiorna',
	'button.renew.config': 'Aggiorna sui dispositivi',
	'button.common': 'Applicazione comune',
	'button.close': 'Chiudi',
	'button.yes': 'Sì',
	'button.cancel': 'Annulla',
	'button.save': 'Salva',
	'button.save.and.close': 'Salva e chiudi',
	'button.more': 'Altro ...',
	'button.cleanup': 'Cancella',
	'button.add': 'Aggiungi',
	 'button.add.icon': 'Nuova icona',
	'button.search': 'Cerca',
	'button.export': 'Esporta',
	'button.change': 'Modifica',
	'button.copy': 'Copia',
	'button.qrcode': 'Codice QR',
	'button.application': 'Applicazione',
	'button.change.password': 'Cambia password',
	'button.set.configuration': 'Imposta configurazione',
	'button.set.group': 'Imposta gruppo',
	'button.group.action': 'Azione di gruppo',
	'button.delete': 'Elimina',
	'button.login': 'Accedi',
	'button.renew.code': 'Rinnova',
	'button.configurations': 'Configurazioni',
	'button.set.configurations': 'Specifica configurazioni',
	'button.edit.versions': 'Versioni',
	'button.edit': 'Modifica',
	'button.change.common.app': 'Modifica applicazione condivisa',
	'button.delete.common.app': 'Elimina applicazione condivisa',
	'button.turn.common.app': 'Rendi comune',
	'button.hints.enable': 'Mostra suggerimenti',
	'button.hints.disable': 'Nascondi suggerimenti',
	'button.show.password': 'Mostra password',
	'button.hide.password': 'Nascondi password',

	'question.impersonate.user': 'Accedi all\'applicazione come amministratore dell\'organizzazione "${customerName}"?',
	'question.change.user': 'Accedi all\'applicazione come utente "${userName}"?',
	'question.delete.file': 'Eliminare il file "${fileName}"?',
	'question.delete.customer': 'Eliminare l\'organizzazione "${customerName}"?',
	'question.delete.user': 'Eliminare l\'utente "${username}"?',
	'question.delete.application': 'Eliminare l\'applicazione "${applicationName}"?',
	'question.delete.application.version': 'Eliminare la versione "${applicationVersion}"?',
	'question.delete.configuration': 'Eliminare la configurazione "${configurationName}"?',
	'question.delete.group': 'Eliminare il gruppo "${groupName}"?',
	'question.delete.role': 'Eliminare il ruolo "${roleName}"?',
    'question.delete.icon': 'Eliminare l\'icona "${iconName}"?',
	'question.delete.device.bulk': 'Eliminare i dispositivi selezionati?',
	'question.delete.device': 'Eliminare il dispositivo con il numero "${deviceNumber}"?',
	'question.exit.without.saving': 'Le modifiche non vengono salvate. Comunque, abbandonare questa pagina?',
	'question.turn2common.application': 'Condividere l\'applicazione "${applicationName}"?',
	'question.app.upgrade': 'Aggiornare l\'applicazione "${v1}" all\'ultima versione per la configurazione "${v2}"?',

	'error.application.setting.empty.app': 'Specifica applicazione',
	'error.application.setting.empty.name': 'Inserisci un nome',
	'error.application.setting.empty.value': 'Specifica un valore',

	'error.icon.dimension.invalid': 'L\'icona deve essere quadrata',
	'error.icon.empty.name': 'Inserisci il nome dell\'icona',
	'error.icon.empty.file': 'Carica file icona',
	'error.application.version.pkg.mismatch': 'L\'ID pacchetto del file (${actual}) non corrisponde all\'applicazione (${expected})',
	'error.empty.user': 'Seleziona un utente',
	'error.empty.user.name': 'Inserisci il nome utente',
	'error.empty.user.login': 'Inserisci il login utente',
	'error.empty.user.role': 'Seleziona un ruolo utente',
	'error.empty.password': 'Inserisci una nuova password',
	'error.empty.password.confirm': 'Inserisci la conferma della password',
	'error.user.not.found': 'Utente non trovato',
	'error.email.not.configured': 'Email non configurata',
	'error.email.not.found': 'Email utente non impostata',
	'error.empty.group.name': 'Inserisci il nome del gruppo',
	'error.empty.configuration': 'Specifica la configurazione',
	'error.empty.configuration.name': 'Inserisci la configurazione name',
	'error.empty.configuration.password': 'Inserisci la password',
	'error.empty.configuration.contentApp': 'Nessuna applicazione di contenuto specificata',
	'error.empty.group': 'Aggiungi un dispositivo a uno o più gruppi',
    'error.invalid.character': 'Il numero del dispositivo non può contenere simboli / ? &',
	'error.invalid.configuration.mainApp': 'Nelle impostazioni MDM, è utilizzata l\'applicazione principale sbagliata',
	'error.invalid.configuration.contentApp': 'Applicazione di contenuto non valida utilizzata nelle impostazioni MDM',
	'error.mismatch.password': 'Password e conferma password devono corrispondere',
	'error.empty.customer.name': 'Inserisci il nome dell\'organizzazione',
	'error.empty.customer.prefix': 'Inserisci il prefisso del numero del dispositivo',
	'error.empty.customer.device.configuration': 'Seleziona configurazione dispositivo',
	'error.empty.customer.duplicate.prefix': 'Prefisso già in uso',
	'error.duplicate.customer.name': 'L\'organizzazione con il nome immesso esiste già. Prova un nome diverso.',
	'error.duplicate.group.name': 'Il gruppo con il nome immesso esiste già. Prova un nome diverso.',
	'error.duplicate.configuration.name': 'La configurazione con il nome immesso esiste già. Prova un nome diverso.',
	'error.duplicate.device.number': 'Un dispositivo con questo numero esiste già',
	'error.internal.server': 'Errore interno del server',
	 'error.permission.denied': 'Nessun diritto di esecuzione',
	'error.request.failure': 'Richiesta fallita',
	'error.configuration.device.use': 'Impossibile eliminare questa configurazione, è utilizzata sui dispositivi. Per prima cosa vai su "Dispositivi", trova i dispositivi che utilizzano questa configurazione e modifica le loro impostazioni.',
	'error.invalid.system.update.time': 'Intervallo di installazione non valido',
	'error.size.limit.exceeded': 'Limite di archiviazione superato',

	'error.configuration.file.empty.name': 'Inserisci un nome file',
	'error.configuration.file.empty.desc': 'Specifica una descrizione file',
	'error.configuration.file.empty.path': 'Specifica il percorso sul dispositivo',
    'error.configuration.file.empty.file': 'Carica un file',
    'error.configuration.file.empty.url': 'Specifica l\'URL del file',

	'error.notfound.device': 'Dispositivo non trovato',
	'error.duplicate.device': 'Esiste già un dispositivo con lo stesso numero', 'error.duplicate.login': 'Questo login è già in uso',
	'error.duplicate.email': 'Un utente con questa email esiste già',
	'error.duplicate.group': 'Un gruppo con lo stesso nome esiste già',
	'error.duplicate.application': 'Un\'applicazione con questo ID pacchetto e questa versione esiste già',
	'error.recent.application.version.exists': 'Esiste una versione più recente dell\'applicazione',
	'error.common.application.access.prohibited': 'La gestione delle applicazioni comuni è consentita solo al Super-Administrator',
	'error.application.config.reference.exists': 'L\'applicazione è utilizzata nelle configurazioni e non può essere eliminata',
	'error.application.version.deletion.prohibited': 'La versione è univoca o utilizzata nelle configurazioni e non può essere cancellato',
	'error.duplicate.file': 'Esiste già un file con lo stesso nome',
	'error.used.file': 'Questo file è in uso',
	'error.version.exists': 'Esiste già la stessa versione di questa app',
	'error.duplicate.configuration': 'Esiste già una configurazione con questo nome',
	'error.duplicate.role.name': 'Esiste già un ruolo con lo stesso nome',
	'error.empty.role.name': 'Specifica il nome del ruolo',
    'error.duplicate.icon.name': 'Esiste già un\'icona con lo stesso nome',
	'error.notfound.customer.admin': 'Account amministratore non trovato',
	'error.apk.file.required': 'Seleziona il file con estensione .apk o .xapk',
	'error.apk.parse': 'Si è verificato un errore durante l\'analisi del file',
	'error.package.not.match': 'L\'ID del pacchetto non corrisponde',
	'error.empty.app.name': 'Inserisci il nome dell\'applicazione',
	'error.empty.app.pkg': 'Inserisci l\'ID del pacchetto',
	'error.empty.app.url': 'Inserisci l\'URL',
	'error.empty.app.iconText': 'Inserisci il testo dell\'icona',
	'error.empty.app.version': 'Inserisci la versione dell\'applicazione',
	'error.notempty.group': 'Questo gruppo include uno o più dispositivi. Non puoi rimuoverlo.',
	'error.file.empty': 'Carica un nuovo file',
	'error.file.deletion': 'Errore durante l\'eliminazione del file sul server',
	'error.file.save': 'Errore durante il salvataggio del file sul server',
	'error.password.wrong': 'Password non valida',
	'error.password.empty': 'Password non specificata',
	'error.password.weak': 'Password di scarsa qualità',
	'error.params.missing': 'Parametri mancanti:',
	'error.empty.push.options': 'Seleziona le opzioni di notifiche push',
	'error.app.name.exists': 'Esiste già un\'altra applicazione con questo nome. Specifica un nome univoco.',

	'table.filtering.check.all': 'Seleziona tutto',
	'table.filtering.uncheck.all': 'Annulla tutto',
	'table.filtering.suffix.configuration': 'configurazioni',
	'table.filtering.suffix.group': 'gruppi',
	'table.filtering.suffix.permission': 'autorizzazioni',
	'table.filtering.no.selected.configuration': 'Nessuna configurazione selezionata',
	'table.filtering.no.selected.group': 'Nessun gruppo selezionato',
	'table.filtering.no.selected.permission': 'Nessuna autorizzazione selezionata',

	'success.admin.created': 'Account amministratore creato:\n ${adminCredentials}',
	'success.uploading.file': 'Il file è in fase di caricamento sul server ...',
	'success.loading.devices': 'Caricamento elenco dispositivi ...',
	'success.loading.customer': 'Caricamento dettagli cliente ...',
	'success.file.uploaded': 'File caricato correttamente.',
	'success.file.uploaded.need.save': 'File caricato correttamente. Inserisci il percorso relativo e fai clic su "Salva".',
	'success.settings.design.saved': 'Impostazioni di progettazione salvate correttamente',
	'success.settings.common.saved': 'Impostazioni tabella dispositivi salvate correttamente',
	'success.settings.saved': 'Impostazioni salvate correttamente',
	'success.settings.apiKey.saved': 'Chiave API salvata correttamente',
	'success.settings.hints.enabled': 'Suggerimenti abilitati',
	'success.settings.hints.disabled': 'Suggerimenti disabilitati',
	'success.configuration.saved': 'Configurazione salvata correttamente',
	'success.operation.completed': 'Operazione completata correttamente',
	'success.plugins.disabled': 'Impostazioni salvate correttamente',
	'success.config.update.notification': 'Il comando di aggiornamento della configurazione è stato inviato a devices',
	'success.config.update.device.app.settings.notification': 'Il comando per aggiornare le impostazioni dell\'applicazione è stato inviato al dispositivo.',

	'form.icon.title': 'Icona',
	'form.icon.name': 'Nome',
	'form.icon.file': 'File',

	'configuration.add.warning': 'Sei sicuro di voler creare una configurazione vuota? Dovrai aggiungere manualmente tutte le app di sistema richieste. Valuta invece di copiare e modificare una configurazione esistente.',
	'configuration.remove.warning': 'Sei sicuro di voler rimuovere l\'ultima configurazione? Perderai informazioni sulle app di sistema richieste.',
	'form.configuration.title': 'Configurazione',
	'form.configuration.title.typical': 'Configurazione tipica',
	'form.configuration.settings.auto.update': 'Aggiornamento automatico',
	'form.configuration.settings.system.update': 'Aggiornamento di sistema',
	'form.configuration.settings.system.update.default': 'Predefinito',
	'form.configuration.settings.system.update.immediate': 'Immediatamente',
	'form.configuration.settings.system.update.scheduled': 'Pianificato',
	'form.configuration.settings.system.update.postponed': 'Rinviato',
	'form.configuration.settings.system.update.time': 'Tempo di installazione',
	'form.configuration.settings.system.update.time.from': 'da:',
	'form.configuration.settings.system.update.time.to': 'a:',
	'form.configuration.settings.system.schedule.app.update': 'Pianifica aggiornamento app',
	'form.configuration.settings.system.app.update.time': 'Ora aggiornamento app',
	'form.configuration.settings.download.updates': 'Scarica contenuto',
	'form.configuration.settings.download.updates.unlimited': 'Senza limiti',
	'form.configuration.settings.download.updates.limited': '3 tentativi nella rete mobile',
	'form.configuration.settings.download.updates.wifi': 'Solo tramite WiFi',
	'form.configuration.settings.block.status.bar': 'Blocco barra di stato',
	'form.configuration.settings.block.status.bar.hint': 'Questa impostazione è deprecata e funziona bene su Android 6 e versioni precedenti. Per bloccare la barra di stato sulle versioni Android più recenti, usa la modalità chiosco (impostazioni MDM).',
	'form.configuration.settings.mdm.kiosk.mode': 'Modalità chiosco',
	'form.configuration.settings.mdm.app.main': 'Applicazione MDM',
	'form.configuration.settings.mdm.component.event.receiver': 'Classe del ricevitore amministratore',
	'form.configuration.settings.mdm.component.event.receiver.placeholder': 'Dovrebbe essere com.hmdm.launcher.AdminReceiver',
	'form.configuration.settings.mdm.component.wifi.ssid': 'SSID WiFi',
	'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'SSID WiFi di registrazione: lascia vuoto per entrare manualmente',
	'form.configuration.settings.mdm.component.wifi.password': 'Password WiFi',
	'form.configuration.settings.mdm.component.wifi.password.placeholder': 'Pass WiFi di registrazione - lascia vuoto per inserirlo manualmente',
	'form.configuration.settings.mdm.component.wifi.security': 'Tipo di sicurezza WiFi',
	'form.configuration.settings.mdm.component.wifi.notice': 'Nota: queste impostazioni WiFi vengono applicate solo alla registrazione iniziale!',
	'form.configuration.settings.mdm.component.server.url': 'Nuovo URL del server',
	'form.configuration.settings.mdm.component.server.url.placeholder': 'Utilizzato per la migrazione a un nuovo server MDM',
	'form.configuration.settings.mdm.app.content': 'Applicazione contenuto',
	'form.configuration.settings.mdm.kiosk.home': 'Abilita pulsante Home',
	'form.configuration.settings.mdm.kiosk.recents': 'Abilita pulsante Recenti',
	'form.configuration.settings.mdm.kiosk.notifications': 'Abilita notifiche',
	'form.configuration.settings.mdm.kiosk.system.info': 'Abilita informazioni barra di stato',
	'form.configuration.settings.mdm.kiosk.keyguard': 'Abilita blocco schermo',
	'form.configuration.settings.mdm.kiosk.lock.buttons': 'Blocca pulsante di accensione',
	'form.configuration.settings.mdm.mobile.enrollment': 'Registrati tramite dati mobili',
	'form.configuration.settings.mdm.encrypt.device': 'Crittografa l\'archiviazione del dispositivo',
	'form.configuration.settings.mdm.lock.safe.settings': 'Blocca le impostazioni di sicurezza (WiFi, GPS, ecc.)',
	'form.configuration.settings.mdm.permissive': 'Modalità permissiva (sbloccata)',
	'form.configuration.settings.mdm.kiosk.exit': 'Pulsante di uscita dal chiosco',
    'form.configuration.settings.mdm.kiosk.screen': 'Schermo sempre acceso',
	'form.configuration.settings.mdm.allowed.classes': 'Attività consentite',
	'form.configuration.settings.mdm.allowed.classes.placeholder': 'Classi separate da virgole, ad esempio: com.android.settings.homepage.SettingsHomepageActivity',
	'form.configuration.settings.mdm.restrictions': 'Restrizioni',
	'form.configuration.settings.mdm.restrictions.placeholder': 'Restrizioni MDM, separate da virgole, ad esempio: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.launcher': 'Sostituisci URL launcher',
    'form.configuration.settings.mdm.launcher.placeholder': 'URL launcher alternativo per l\'iscrizione a reti chiuse',
	'form.configuration.settings.mdm.misc': 'Altre voci del codice QR',
	'form.configuration.settings.mdm.misc.placeholder': 'Voci separate da virgole, ad esempio:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
	'form.configuration.settings.mdm.qrcode.url': 'URL del codice QR',
	'form.configuration.settings.mdm.hint': 'Seleziona l\'applicazione principale e il componente',
	'form.configuration.apps.search.label': 'Cerca:',
	'form.configuration.apps.sort.label': 'Ordina:',
	'form.configuration.apps.sort.byname': 'Per nome',
	'form.configuration.apps.sort.bypkg': 'Per ID',
	'form.configuration.apps.no.apk': 'nessuno',
	'form.configuration.apps.show.systeam.apps': 'Mostra applicazioni di sistema',
	'form.configuration.apps.action.select': '(seleziona)',
	'form.configuration.apps.action.install': 'Installa',
	'form.configuration.apps.action.prohibit': 'Blocca',
	'form.configuration.apps.action.not.install': 'Non installare',
	'form.configuration.apps.action.delete': 'Elimina',
	'form.configuration.apps.action.permit': 'Consenti',
	'form.configuration.apps.label.inherit': 'Ereditato',
	'form.configuration.apps.label.show': 'Mostra',
	'form.configuration.apps.label.not.show': 'Nascondi',
	'form.configuration.apps.edit.details': 'Parametri aggiuntivi',
	'form.configuration.apps.keycode': 'Codice chiave',
	'form.configuration.apps.bottom': 'Visualizza nella riga inferiore',
	'form.configuration.apps.long.tap': 'Un tocco prolungato apre le impostazioni',
	'form.configuration.apps.hint': 'Suggerimento: per scollegare l\'app dalla configurazione, seleziona l\'azione "Blocca" o "Non installare".',
	'form.configuration.settings.design.use.default': 'Usa il design predefinito',
	'form.configuration.settings.design.color.background': 'Colore di sfondo',
	'form.configuration.settings.design.color.background.placeholder': 'Seleziona un colore',
	'form.configuration.settings.design.color.app.names': 'Colore nomi applicazioni',
	'form.configuration.settings.design.color.app.names.placeholder': 'Seleziona un colore',
	'form.configuration.settings.design.background.image.url': 'URL dell\'immagine di sfondo',
	'form.configuration.settings.design.background.image.url.placeholder': 'Inserisci l\'URL dell\'immagine di sfondo',
	'form.configuration.settings.design.icon': 'Dimensione icona',
	'form.configuration.settings.design.icon.small': 'Piccola',
	'form.configuration.settings.design.icon.medium': 'Media (+ 20%)',
	'form.configuration.settings.design.icon.large': 'Grande (+ 40%)',
	'form.configuration.settings.design.desktop.header': 'Titolo desktop',
	'form.configuration.settings.design.desktop.header.no': 'No',
	'form.configuration.settings.design.desktop.header.deviceid': 'ID dispositivo',
	'form.configuration.settings.design.desktop.header.description': 'Descrizione',
	'form.configuration.settings.design.desktop.header.custom': 'Modello personalizzato',
	'form.configuration.settings.design.desktop.header.hint': 'Assicurati che questo parametro venga inviato ai dispositivi (Impostazioni - Impostazioni generali e lingua)',
	'form.configuration.settings.design.desktop.header.template': 'Inserisci il modello',
	'form.configuration.settings.design.desktop.header.template.placeholder': 'Usa variabili',
	'form.configuration.settings.design.display.status': 'Visualizza ora e stato batteria',
	'form.configuration.settings.design.upload': 'Carica',
	'form.configuration.settings.common.name': 'Nome',
	'form.configuration.settings.common.name.placeholder': 'Inserisci il nome della configurazione',
	'form.configuration.settings.common.desc': 'Descrizione',
	'form.configuration.settings.common.desc.placeholder': 'Inserisci la descrizione della configurazione',
	'form.configuration.settings.common.admin.pwd': 'Password di sblocco',
	'form.configuration.settings.common.admin.pwd.placeholder': 'Inserisci la password di sblocco del dispositivo',
	'form.configuration.settings.common.gps': 'GPS',
	'form.configuration.settings.common.gps.any': 'Qualsiasi',
	'form.configuration.settings.common.gps.off': 'Disabilitato',
	'form.configuration.settings.common.gps.on': 'Abilitato',
	'form.configuration.settings.common.bluetooth': 'Bluetooth',
	'form.configuration.settings.common.wifi': 'Wi-Fi',
	'form.configuration.settings.common.mobile.data': 'Dati mobili',
	'form.configuration.settings.common.usb.storage': 'Blocca archiviazione USB',
	'form.configuration.settings.common.brightness': 'Gestisci luminosità',
	'form.configuration.settings.common.brightness.none': 'Nessuno',
	'form.configuration.settings.common.brightness.auto': 'Auto',
	'form.configuration.settings.common.brightness.manual': 'Valore',
	'form.configuration.settings.common.brightness.value': 'Luminosità schermo',
	'form.configuration.settings.common.timeout': 'Gestisci timeout schermo',
	'form.configuration.settings.common.timeout.value': 'Timeout schermo (s)',
	'form.configuration.settings.common.volume.block': 'Blocca volume',
	'form.configuration.settings.common.volume.manage': 'Gestisci volume',
	'form.configuration.settings.common.volume.value': 'Volume',
	'form.configuration.settings.common.timezone.mode': 'Gestisci fuso orario',
	'form.configuration.settings.common.timezone.mode.default': 'Non gestire',
	'form.configuration.settings.common.timezone.mode.auto': 'Automatico',
	'form.configuration.settings.common.timezone.mode.manual': 'Manuale',
	'form.configuration.settings.common.timezone': 'Fuso orario',
	'form.configuration.settings.common.timezone.placeholder': 'ad esempio America/Los_Angeles',
	'form.configuration.settings.common.timezone.link': 'Elenco dei fusi orari',
	'form.configuration.settings.common.no.network.warning': 'ATTENZIONE! Non disattivare tutti i canali di connessione, altrimenti non sarai più in grado di gestire i dispositivi!',
	'form.configuration.settings.common.autostart.foreground': 'Avvia automaticamente le app in primo piano',
	'form.configuration.settings.request.updates': 'Tracciamento della posizione',
	'form.configuration.settings.request.updates.donottrack': 'Nessun tracciamento attivo (utilizza i dati sulla posizione delle app di terze parti)',
	'form.configuration.settings.request.updates.gps': 'Traccia la posizione tramite GPS',
	'form.configuration.settings.request.updates.wifi': 'Traccia la posizione tramite Wi-Fi (i servizi Google devono essere abilitati)',
	'form.configuration.settings.request.updates.prompt.gps': 'Per tracciare la posizione tramite GPS, devi abilitare il GPS',
	'form.configuration.settings.request.updates.prompt.wifi': 'Per tracciare la posizione tramite Wi-Fi, devi abilitare il Wi-Fi',
	'form.configuration.settings.revoke.location.permission': 'Nessun permesso di posizione',
	'form.configuration.settings.revoke.location.permission.hint': 'Se impostato, il permesso di posizione non verrà concesso all\'agente MDM e non potrà tracciare la posizione del dispositivo',
	'form.configuration.settings.apps.permissions': 'Autorizzazioni per altre app',
	'form.configuration.settings.apps.permissions.grant': 'Concedi automaticamente tutte le autorizzazioni',
	'form.configuration.settings.apps.permissions.ask.location': 'Concedi automaticamente tutte, chiedi all\'utente il permesso di posizione',
	'form.configuration.settings.apps.permissions.deny.location': 'Concedi automaticamente tutto, non concedere l\'autorizzazione sulla posizione',
	'form.configuration.settings.apps.permissions.ask.all': 'Chiedi all\'utente tutte le autorizzazioni',
	'form.configuration.settings.push.options' : 'Notifiche push',
	'form.configuration.settings.push.options.mqtt.worker' : 'Protocollo MQTT (risparmio batteria)',
	'form.configuration.settings.push.options.mqtt.alarm' : 'Protocollo MQTT',
	'form.configuration.settings.push.options.polling' : 'Polling HTTP',
	'form.configuration.settings.push.options.mqtt.worker.hint' : 'Invia messaggi push all\'istante quando il dispositivo è attivo. Ma i messaggi potrebbero ritardare fino a qualche ora in modalità di sospensione. Non usare questa opzione su dispositivi autonomi. MQTT usa la porta TCP 31000, abilitala sul tuo firewall.',
	'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT è un protocollo leggero che consuma risorse minime. MQTT usa la porta TCP 31000, abilitala sul tuo firewall.',
	'form.configuration.settings.push.options.polling.hint' : 'Il polling lungo mantiene una connessione HTTP che può consumare più risorse del server. Non richiede porte TCP diverse da HTTP(S).',
	'form.configuration.settings.push.options.keepalive' : 'Tempo di Keep-Alive',
	'form.configuration.settings.minute.1' : '1 minuto',
	'form.configuration.settings.minutes.2' : '2 minuti',
	'form.configuration.settings.minutes.3' : '3 minuti',
	'form.configuration.settings.minutes.5' : '5 minuti',
	'form.configuration.settings.minutes.10' : '10 minuti',
	'form.configuration.settings.minutes.15' : '15 minuti',
	'form.configuration.settings.password.mode' : 'Requisiti password',
	'form.configuration.settings.password.mode.any' : 'Nessuno',
	'form.configuration.settings.password.mode.present' : 'Password presente',
	'form.configuration.settings.password.mode.easy' : 'Facile (almeno 6 simboli)',
	'form.configuration.settings.password.mode.moderate' : 'Moderato (8+ simboli, lettere e cifre)',
	'form.configuration.settings.password.mode.strong' : 'Forte (8+, maiuscole e minuscole, cifre, segni)',
	'form.configuration.settings.show.wifi': 'Errore nelle impostazioni WiFi durante la connessione',
	'form.configuration.settings.use.default.launcher': 'Modalità in background',
	'form.configuration.settings.use.default.launcher.hint': 'Non sostituire un launcher di sistema, esegui solo i servizi MDM in background. Non consigliato con la modalità chiosco.',
	'form.configuration.settings.disable.screenshots': 'Disabilita cattura schermo',
	'form.configuration.settings.orientation': 'Blocca orientamento',
	'form.configuration.settings.orientation.none': 'Non bloccare',
	'form.configuration.settings.orientation.portrait': 'Ritratto',
	'form.configuration.settings.orientation.landscape': 'Orizzontale',
	'form.configuration.settings.files.default.path': 'Percorso predefinito su un dispositivo',
	'form.configuration.files.search.label': 'Cerca:',
	'form.configuration.files.action.upload': 'Carica',
	'form.configuration.files.action.remove': 'Rimuovi',
	'form.configuration.files.variables': 'Contenuto variabile',
	'form.configuration.files.variables.hint': 'Le stringhe DEVICE_NUMBER, IMEI, CUSTOM* saranno sostituite dai rispettivi valori',

	'form.configuration.file.name': 'Nome file',
    'form.configuration.file.select': 'Seleziona un file',
    'form.configuration.file.create': '(crea un nuovo file)',
	'form.configuration.file.description': 'Descrizione',
	'form.configuration.file.description.placeholder': 'Facoltativo, per comodità',
	'form.configuration.file.path': 'Percorso sul dispositivo',
	'form.configuration.file.path.placeholder': 'Escluso il percorso a un\'unità, ad esempio /my-app/image.jpg',
	'form.configuration.file.url': 'URL',
	'form.configuration.file.url.placeholder': 'Se solo un file è ospitato su una risorsa esterna',
	'form.configuration.file.file': 'File',
	'form.configuration.file.action': 'Azione',
	'form.configuration.file.action.prompt.1': 'Carica',
	'form.configuration.file.action.prompt.2': 'Rimuovi',
	'form.configuration.file.remove.prompt.1': 'Questo file non verrà più sincronizzato con i dispositivi',
	'form.configuration.file.remove.prompt.2': 'Rimuovi file dal server',

	'form.password.title': 'Cambia password',
	'form.password.label.user': 'Utente',
	'form.password.label.password.new': 'Nuova password',
	'form.password.label.password.new.placeholder': 'Inserisci una nuova password',
	'form.password.label.password.confirm': 'Verifica',
	'form.password.label.password.confirm.placeholder': 'Inserisci di nuovo la nuova password',
	'form.password.length': 'Lunghezza minima: ${length}. ',

	'form.application.type': 'Tipo',
	'form.application.type.option.web': 'Pagina Web',
	'form.application.type.option.app': 'Applicazione',
	'form.application.type.option.intent': 'Azione di sistema',
	'form.application.intent': 'Azione',
	'form.application.intent.placeholder': 'Scegli un\'azione',
	'form.application.url.hint': 'Usa file:///storage/emulated/0/... per creare collegamenti a file e cartelle locali',
	'form.application.pkg': 'ID pacchetto',
	'form.application.from.file': 'determinato dal file',
	'form.application.pkg.title': 'L\'ID pacchetto viene determinato automaticamente quando carichi il file APK. L\'ID del pacchetto inserito manualmente è obbligatorio solo per le app di sistema.',
	'form.application.pkg.placeholder': 'Ad esempio, com.android.camera',
	'form.application.disabled.arch': 'Specifico della versione',
	'form.application.disabled.arch.title': 'Per aggiungere APK per diverse architetture CPU, fai clic su "Aggiungi" o apri l\'elenco delle versioni dell\'app',
	'form.application.arch': 'Codice nativo',
	'form.application.arch.title': 'Alcune app contengono codice ottimizzato per una determinata architettura CPU. In questo caso, devi caricare due APK (per le architetture armeabi-v7a e arm64-v8a)',
	'form.application.arch.universal': 'Nessuno (APK universale)',
	'form.application.arch.armeabi': 'Codice nativo per armeabi-v7a',
	'form.application.arch.arm64': 'Codice nativo per arm64-v8a',
	'form.application.arch.no.split': 'APK universale',
	'form.application.arch.split': 'APK diviso',
	'form.application.arch.warning': 'Questo APK è ottimizzato solo per ${arch} e potrebbe non funzionare su tutti i dispositivi. Si consiglia di caricare un altro APK ottimizzato per un\'altra architettura CPU. Per usare questo APK su tutti i dispositivi, seleziona "APK universale".',
	'form.application.arch.success': 'Questa app contiene APK per entrambe le architetture CPU',
	'form.application.version.exists': 'L\'APK per questa versione esiste già',
	'form.application.url.armeabi': 'URL per armeabi-v7a',
	'form.application.url.arm64': 'URL per arm64-v8a',
	'form.application.name': 'Nome applicazione',
	'form.application.name.title': 'Vedrai il nome dell\'app nell\'elenco. Ti consigliamo di usare nomi univoci e informativi.',
	'form.application.name.placeholder': 'Ad esempio, Fotocamera (Android)',
	'form.application.version': 'Versione',
	'form.application.version.placeholder': '0 per le app preinstallate',
	'form.application.version.title': 'La versione del pacchetto viene determinata automaticamente quando carichi il file APK. Impostala su 0 per le app di sistema.',
	'form.application.version.code': 'Codice versione',
	'form.application.version.code.exists': 'Esiste già una versione con lo stesso codice. Segnala questo problema agli sviluppatori dell\'app.',
	'form.application.system': 'App preinstallata',
	'form.application.system.title': 'Le applicazioni di sistema sono preinstallate su un dispositivo e non richiedono URL o file. Imposta questo flag solo se devi abilitare un determinato pacchetto di sistema.',
	'form.application.run.after.install': 'Esegui dopo l\'installazione',
	'form.application.run.after.install.title': 'Le applicazioni con servizi in background devono essere avviate in primo piano almeno una volta.',
	'form.application.run.at.boot': 'Esegui all\'avvio',
	'form.application.run.at.boot.title': 'Imposta questo flag se devi eseguire l\'app in primo piano dopo l\'avvio. Questo flag non influisce sui processi in background.',
	'form.application.url': 'URL',
	'form.application.url.title': 'L\'URL deve essere digitato solo se l\'app è ospitata su una risorsa esterna. Si consiglia di caricare un file APK utilizzando un campo sottostante.',
	'form.application.url.disabled': 'L\'URL è impostato per ogni versione. Per modificare l\'URL, chiudi questa finestra e fai clic sull\'icona "Versioni".',
	'form.application.file': 'File',
	'form.application.auto.update': 'Aggiornamento automatico',
	'form.application.auto.update.title': 'Imposta questo flag per aggiornare tutte le configurazioni in cui è installata l\'app. Usalo solo se sei sicuro al 100% che l\'app sia stabile.',
	'form.application.showLabel': 'Mostra icona',
	'form.application.showLabel.title': 'Questo flag indica se l\'icona dell\'app deve essere visualizzata nel launcher. Questa opzione può essere sovrascritta nella configurazione.',
	'form.application.use.kiosk': 'Apri in Kiosk Browser',
	'form.application.use.kiosk.title': 'Imposta questo flag se vuoi aprire una pagina web in Kiosk Browser senza alcuna possibilità di cambiare l\'indirizzo',
	'form.application.iconText': 'Testo icona',
	'form.application.iconText.placeholder': '(default)',
	'form.application.versions.title': 'Versioni dell\'applicazione',
	'form.application.icon': 'Icona',
	'form.application.icon.default': '(default)',
	'form.application.icon.add': 'Aggiungi icona',

	'form.application.setting.app': 'Applicazione',
	'form.application.setting.app.placeholder': 'Seleziona un\'applicazione',
	'form.application.setting.name': 'Attributo',
	'form.application.setting.value': 'Valore',
	'form.application.setting.comment': 'Commento',
	'form.application.setting.type': 'Tipo',
	'form.application.setting.readonly': 'Non cambia sul dispositivo',

	'form.application.configurations.app': 'Applicazione',
	'form.application.configurations.configs': 'Configurazioni',

	'form.configuration.copy.new.name': 'Nuovo nome',
	'form.configuration.copy.new.name.placeholder': 'Inserisci il nuovo nome della configurazione',

	'form.customer.name': 'ID cliente',
	'form.customer.name.placeholder': 'Identificativo organizzazione utilizzato per l\'accesso',
	'form.customer.admin.name': 'Nome amministratore',
	'form.customer.firstname.placeholder': 'Nome',
	'form.customer.lastname.placeholder': 'Cognome',
	'form.customer.language': 'Lingua',
	'form.customer.language.placeholder': 'Vuoto per inglese o due lettere minuscole',
	'form.customer.apiKey': 'Chiave API',
	'form.customer.apiKey.placeholder': 'Inserisci la chiave API',
	'form.customer.prefix': 'Prefisso',
	'form.customer.prefix.placeholder': 'Inserisci il prefisso del numero del dispositivo',
	'form.customer.device.configuration': 'Configurazione del dispositivo',
	'form.customer.desc': 'Descrizione',
	'form.customer.desc.placeholder': 'Inserisci una descrizione dell\'organizzazione',
	'form.customer.copy.configuration': 'Copia configurazioni',
	'form.customer.copy.design': 'Copia design',
	'form.customer.type': 'Tipo di cliente',
	'form.customer.status': 'Stato del cliente',
	'form.customer.expiry.time': 'Data di scadenza',
	'form.customer.device.limit': 'Limite dispositivo',
	'form.customer.size.limit': 'Limite di archiviazione',
	'form.customer.size.limit.placeholder': 'Dimensione (Mb)',

	'form.device.number': 'Numero',
	'form.device.number.locked': 'Impossibile modificare il numero perché la modifica del numero precedente non è stata completata.',
	'form.device.migration.warning': 'Il numero del dispositivo verrà modificato. Assicurati che il dispositivo sia acceso e online.',
	'form.device.number.hint': 'Non usare caratteri speciali',
	'form.device.desc': 'Descrizione',
	'form.device.groups': 'Gruppi',
	'form.device.config': 'Configurazione',
	'form.device.imei': 'IMEI',
	'form.device.phone.number': 'Numero di telefono',

	'form.update.device.config': 'Configurazione',
	'form.update.device.action': 'Azione di gruppo',
	'form.device.set.group': 'Aggiungi ai gruppi',
	'form.device.clear.group': 'Rimuovi dai gruppi',

	'form.file.file': 'File',
    'form.file.name': 'Nome file',
    'form.file.description': 'Descrizione (facoltativa)',
    'form.file.external': 'Esterno',
    'form.file.external.title': 'Invece di caricare il file, puoi specificare l\'URL su una risorsa esterna',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': 'URL del file su una risorsa esterna',
    'form.file.path': 'Percorso sul server',
    'form.file.device.path': 'Percorso sul dispositivo',
    'form.file.device.path.placeholder': 'Percorso relativo a /storage/emulated/0',
    'form.file.deleted': 'ELIMINATO',
    'form.file.copy.link': 'Copia collegamento: ${link}',
    'form.file.configurations.file': 'File',
    'form.file.configurations.configs': 'Configurazioni',
    'form.file.configurations.upload': 'Carica',
	'form.file.path.placeholder': 'Inserisci un percorso relativo, ad esempio "/files/"',
	'form.file.available': 'Spazio disponibile: ${space} Mb',

	'form.file.apps.name': 'Nome applicazione',
	'form.file.apps.pkg': 'ID pacchetto',
	'form.file.apps.version': 'Versione',

	'form.group.name': 'Nome',
	'form.group.name.placeholder': 'Inserisci il nome del gruppo',

	'form.role.name': 'Nome',
	'form.role.name.placeholder': 'Inserisci il nome del ruolo',
	'form.role.permissions': 'Autorizzazioni',

	'form.user.login': 'Login',
	'form.user.login.placeholder': 'Inserisci login utente',
	'form.user.name': 'Nome',
	'form.user.name.placeholder': 'Nome e cognome',
	'form.user.email': 'E-mail',
	'form.user.email.placeholder': 'Inserisci l\'e-mail',
	'form.user.role': 'Ruolo',
	'form.user.all.devices.available': 'Tutti i dispositivi sono disponibili',
	'form.user.available.groups': 'Gruppi di dispositivi disponibili',
	'form.user.all.configs.available': 'Tutte le configurazioni sono disponibili',
	'form.user.available.configs': 'Configurazioni disponibili',
	'form.user.password.new': 'Nuova password',
	'form.user.password': 'Password',
	'form.user.password.new.placeholder': 'Inserisci una nuova password',
	'form.user.password.confirm': 'Verifica',
	'form.user.password.confirm.placeholder': 'Inserisci di nuovo la nuova password',

	'form.settings.hints.title': 'Suggerimenti',

	'form.settings.plugins.title': 'Utilizzato Plugin',

	'form.settings.common.title': 'Visualizzazione tabella dispositivi',
	'form.settings.common.visible.columns': 'Colonne visibili nella tabella "Dispositivi"',
	'form.settings.common.status': 'Stato',
	'form.settings.common.role': 'Ruolo utente',
	'form.settings.common.date': 'Data ultima connessione',
	'form.settings.common.device.number': 'Numero dispositivo',
	'form.settings.common.imei': 'IMEI',
	'form.settings.common.phone.number': 'Numero di telefono',
	'form.settings.common.phone.model': 'Modello telefono',
	'form.settings.common.status.permissions': 'Stato autorizzazione',
	'form.settings.common.status.installation': 'Stato di installazione',
	'form.settings.common.status.files': 'Stato file',
	'form.settings.common.config': 'Configurazione',
	'form.settings.common.desc': 'Descrizione',
	'form.settings.common.group': 'Gruppo',
	'form.settings.common.launcher.version': 'Versione launcher',
	'form.settings.common.battery.level': 'Livello batteria',
	'form.settings.common.default.launcher': 'Background',
	'form.settings.common.mdm.mode': 'Modalità MDM',
	'form.settings.common.kiosk.mode': 'Modalità chiosco',
	'form.settings.common.android.version': 'Versione Android',
	'form.settings.common.enrollment.date': 'Data di iscrizione',
	'form.settings.common.serial': 'Numero di serie',
	'form.settings.common.publicip': 'Indirizzo IP',

	'form.settings.design.title': 'Design predefinito',
	'form.settings.design.color.font': 'Colore di sfondo',
	'form.settings.design.color.font.placeholder': 'Seleziona un colore',
	'form.settings.design.color.app.names': 'Colore nomi applicazione',
	'form.settings.design.color.app.names.placeholder': 'Seleziona un colore',
	'form.settings.design.url.background.image': 'URL dell\'immagine di sfondo',
	'form.settings.design.url.background.image.placeholder': 'Inserisci l\'URL dell\'immagine di sfondo',
	'form.settings.design.size.icon': 'Dimensione icona',
	'form.settings.design.size.icon.small': 'Piccola',
	'form.settings.design.size.icon.medium': 'Media (+ 20%)',
	'form.settings.design.size.icon.large': 'Grande (+ 40%)',
	'form.settings.design.desktop.header': 'Titolo desktop',
	'form.settings.design.desktop.header.no': 'No',
	'form.settings.design.desktop.header.device.id': 'ID dispositivo',

	'form.settings.lang.title': 'Impostazioni lingua',
	'form.settings.lang.use.default': 'Usa predefinito lingua',
	'form.settings.lang.use': 'Usa lingua',
	'form.settings.lang.en': 'English',
	'form.settings.lang.pt': 'Português',
	'form.settings.lang.ru': 'Русский',
	'form.settings.lang.fr': 'Français',
	'form.settings.lang.ar': 'عربي',
	'form.settings.lang.es': 'Español',
	'form.settings.lang.de': 'Deutsch',
	'form.settings.lang.cn': '繁体中文',
	'form.settings.lang.tw': '繁體中文',
	'form.settings.lang.ja': '日本',
	'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.vi': 'Tiếng Việt',
	'form.settings.lang.it': 'Italiano',

	'form.settings.misc.title': 'Impostazioni varie',
	'form.settings.misc.phone.format': 'Formato numero di telefono',
	'form.settings.misc.phone.format.placeholder': '+9 (999) 999-99-99',
	'form.settings.misc.custom.property.name.1': 'Proprietà personalizzata n. 1',
	'form.settings.misc.custom.property.name.2': 'Proprietà personalizzata n. 2',
	'form.settings.misc.custom.property.name.3': 'Proprietà personalizzata n. 3',
	'form.settings.misc.custom.property.multiline': 'Multiline',
	'form.settings.misc.custom.property.send': 'Invia al dispositivo',
	'form.settings.misc.custom.property.name.placeholder': 'Inserisci nome per una proprietà personalizzata',
	'form.settings.misc.create.new.devices': 'Aggiungi dispositivo al primo accesso',
	'form.settings.misc.new.device.config': 'Nuova configurazione dispositivo',
	'form.settings.misc.new.device.group': 'Nuovo gruppo dispositivo',
	'form.settings.misc.send.description': 'Invia descrizione ai dispositivi',
	'form.settings.misc.password.length': 'Lunghezza minima password',
	'form.settings.misc.password.strength': 'Forza password',
	'form.settings.misc.password.none': 'Non specificato (qualsiasi carattere)', 'form.settings.misc.password.alphanumeric': 'Lettere minuscole e maiuscole, cifre',
	'form.settings.misc.password.specialchar': 'Lettere minuscole e maiuscole, cifre, caratteri speciali',
	'form.settings.misc.password.reset': 'L\'utente deve reimpostare la password',
	'form.settings.misc.idle.logout': 'Esci quando sei inattivo',
	'form.settings.misc.idle.logout.never': 'Mai',
	'form.settings.misc.idle.logout.1': '5 minuti',
	'form.settings.misc.idle.logout.2': '10 minuti',
	'form.settings.misc.idle.logout.3': '30 minuti',
	'form.settings.misc.idle.logout.4': '1 ora',
	'form.settings.security.title': 'Impostazioni di sicurezza',

	'idle.logout.message': 'Verrai disconnesso tra ${sec} secondi per inattività',
	'idle.logout.resume': 'Sono qui!',

	'form.settings.groups.title': 'Gruppi',
	'form.settings.groups.search.placeholder': 'Ricerca gruppo',

	'form.settings.users.title': 'Utenti',
	'form.settings.users.search.placeholder': 'Cerca utente',

	'form.settings.roles.title': 'Ruoli utente',

    'form.settings.icons.title': 'Icone',
    'form.settings.icons.search.placeholder': 'Cerca icone',

	'form.qr.device.number': 'Numero dispositivo',
	'form.qr.auto.create': 'Aggiungi all\'elenco dispositivi se non esiste',
	'form.qr.number.use': 'Assegnazione numero dispositivo',
	'form.qr.number.use.request': 'Valore utente',
	'form.qr.number.use.imei': 'IMEI',
	'form.qr.number.use.serial': 'Numero di serie',
	'form.qr.number.hint': 'Cancella il numero dispositivo per abilitare l\'assegnazione automatica del numero dispositivo',
	'form.qr.groups': 'Aggiungi ai gruppi',
	'form.qr.button.json': 'Ottieni JSON',
	'form.qr.device.number.placeholder': 'Inserisci l\'ID dispositivo ...',
	'form.qr.code.image.alt': 'Codice QR',

	'form.password.reset.title': 'Imposta una nuova password',
	'form.password.reset.invalid': 'Spiacenti, questo link per la reimpostazione della password non è valido',
	'form.password.reset.submit': 'Imposta password',

	'form.two.factor.auth.title': 'Autenticazione a due fattori',
	'form.two.factor.auth.hint': 'Per completare la registrazione, installa l\'app Authenticator sul tuo dispositivo mobile, scansiona il codice QR, genera e inserisci il codice di verifica.',
	'form.two.factor.auth.code.invalid': 'Il codice di verifica non è valido!',
	'form.two.factor.auth.code': 'Codice di verifica',
	'form.two.factor.auth.code.hint': 'Codice a 6 cifre dall\'app di autenticazione',
	'form.two.factor.auth.code.error': 'Il codice deve essere un numero a 6 cifre',
	'form.two.factor.auth.verify': 'Verifica',
	'form.two.factor.auth.settings.hint': 'Per impostare l\'autenticazione a due fattori, installa l\'app Authenticator sul tuo dispositivo mobile, scansiona il codice QR, genera e inserisci il codice di verifica.',
	'form.two.factor.auth.set': 'L\'autenticazione a due fattori è attivata',
	'form.two.factor.auth.reset': 'L\'autenticazione a due fattori è disattivata',
	'form.two.factor.auth.off.confirm': 'Vuoi disattivare l\'autenticazione a due fattori? Dopo averlo riattivato, tutti gli autenticatori non saranno più validi.',

	'form.profile.title': 'Cambia password',
	'form.profile.password.old': 'Vecchia password',
	'form.profile.password.old.placeholder': 'Inserisci vecchia password',
	'form.profile.password.new': 'Nuova password',
	'form.profile.password.new.placeholder': 'Inserisci una nuova password',
	'form.profile.password.confirm': 'Verifica',
	'form.profile.password.confirm.placeholder': 'Inserisci di nuovo la nuova password',

	'tab.customers': 'Organizzazioni',
	'tab.common.applications': 'Applicazioni condivise',

	'tab.devices': 'Dispositivi',
	'tab.applications': 'Applicazioni',
	'tab.configurations': 'Configurazioni',
	'tab.files': 'File',
	'tab.default.design': 'Design predefinito',
	'tab.common.settings': 'Visualizzazione tabella dispositivi',
	'tab.users': 'Utenti',
	'tab.roles': 'Ruoli',
	'tab.groups': 'Gruppi',
    'tab.icons': 'Icone',
	'tab.language': 'Impostazioni generali e lingua',
	'tab.license': 'Licenza',
	'tab.hints': 'Suggerimenti',
	'tab.plugins': 'Plugin',

	'tab.configeditor.common.settings': 'Comune settings',
	'tab.configeditor.design.settings': 'Impostazioni di progettazione',
	'tab.configeditor.applications': 'Applicazioni',
	'tab.configeditor.mdm.settings': 'Impostazioni MDM',
	'tab.configeditor.app.settings': 'Impostazioni applicazioni',
	'tab.configeditor.files': 'File',

	'search.placeholder.file': 'cerca file',
	'search.placeholder.configuration': 'Cerca configurazione',
	'search.placeholder.customer': 'Cerca un\'organizzazione',
	'search.placeholder.application': 'Cerca un\'applicazione',
	'search.placeholder.application.setting': 'Cerca un\'impostazione applicazione',
	'search.placeholder.device': 'Cerca un dispositivo',
	'search.placeholder.address': 'Ricerca indirizzo',
	'search.placeholder.point': 'Ricerca sito',
	'search.placeholder.message': 'Ricerca messaggio',
	'search.placeholder': 'Cerca ...',
	'search.placeholder.from': 'Da ...',
	'search.placeholder.to': 'A ...',
	'search.placeholder.user': 'Digita il nome utente',

	'table.heading.customer.name': 'Nome',
	'table.heading.customer.desc': 'Descrizione',
	'table.heading.customer.registration.time': 'Registrato',
	'table.heading.customer.last.login.time': 'Ultimo accesso',
	'table.heading.customer.actions': 'Azioni',
	'table.heading.customer.type': 'Tipo',
	'table.heading.customer.expiry.time': 'Scade',
	'table.heading.customer.device.limit': 'Limite',
	'table.heading.customer.status': 'Stato',

	'customer.new': 'Nuovo',
	'customer.active': 'Attivo',
	'customer.need.followup': 'Need follow-up',
	'customer.followup.sent': 'Follow-up inviato',
	'customer.internal.test': 'Test interno',
	'customer.developer': 'Sviluppatore',
	'customer.difficult': 'Difficile',
	'customer.pause': 'Pausa',
	'customer.inactive': 'Nessun accesso',
	'customer.abandon': 'Abbandona',
	'customer.onpremise': 'Prova on-premise',
	'customer.denial': 'Negazione',
	'customer.client': 'Client',

	'table.heading.configuration.name': 'Nome',
	'table.heading.configuration.desc': 'Descrizione',
	'table.heading.configuration.actions': 'Azioni',

	'table.heading.application.setting.app.pkg': 'ID pacchetto',
	'table.heading.application.setting.app.name': 'Nome applicazione',
	'table.heading.application.setting.name': 'Attributo',
	'table.heading.application.setting.value': 'Valore',
	'table.heading.application.setting.comment': 'Commento',
	'table.heading.application.setting.lastUpdate': 'Data creazione',

	'table.heading.file.url': 'URL',
	'table.heading.file.devicepath': 'Percorso sul dispositivo',
	'table.heading.file.description': 'Descrizione file',
	'table.heading.file.action': 'Azione',
	'table.heading.file.lastUpdate': 'Data di creazione',

	'table.heading.application.pkg': 'ID pacchetto',
	'table.heading.application.name': 'Nome applicazione',
	'table.heading.application.version': 'Versione',
	'table.heading.application.url': 'URL',
	'table.heading.application.label': 'Icona',
	'table.heading.application.actions': 'Azioni',
	'table.heading.application.order': 'Ordine',

	'table.heading.device.status': 'Stato',
	'table.heading.device.date': 'Data',
	'table.heading.device.device.number': 'Numero dispositivo',
	'table.heading.device.imei': 'IMEI',
	'table.heading.device.phone.number': 'Numero di telefono',
	'table.heading.device.phone.model': 'Modello di telefono',
	'table.heading.device.status.permissions': 'Stato autorizzazione',
	'table.heading.device.status.installation': 'Stato installazione',
	'table.heading.device.status.files': 'Stato file',
	'table.heading.device.configuration': 'Configurazione',
	'table.heading.device.desc': 'Descrizione',
	'table.heading.device.group': 'Gruppo',
	'table.heading.device.launcher.version': 'Versione launcher',
	'table.heading.device.battery.level': 'Livello batteria',
	'table.heading.device.default.launcher': 'Background',
	'table.heading.device.mdm.mode': 'Modalità MDM',
	'table.heading.device.kiosk.mode': 'Modalità chiosco',
	'table.heading.device.android.version': 'Versione Android',
	'table.heading.device.enrollment.date': 'Registrato',
	'table.heading.device.serial': 'Numero di serie',
	'table.heading.device.publicip': 'Indirizzo IP',
	'table.heading.device.actions': 'Azioni',

	'table.heading.group.name': 'Nome',
	'table.heading.group.actions': 'Azioni',

	'table.heading.role.name': 'Nome',
	'table.heading.role.actions': 'Azioni',

	'table.heading.file.name': 'Nome del file',
    'table.heading.file.comment': 'Descrizione',
    'table.heading.file.device.path': 'Chemin sur l\'appareil',
    'table.heading.file.update.time': 'Mis à jour à',
    'table.heading.file.external': 'Esterno',
    'table.heading.file.variable': 'Variabile',
    'table.heading.file.remove': 'Rimuovi',
    'table.heading.file.remove.hint': 'Forza la rimozione del file dalla memoria del dispositivo',
    'table.heading.file.path': 'Percorso',
	'table.heading.file.address': 'Indirizzo',
	'table.heading.file.size': 'Dimensione',
	'table.heading.file.actions': 'Azioni',

	'table.heading.users.login': 'Login',
	'table.heading.users.name': 'Nome',
	'table.heading.users.role': 'Ruolo',
	'table.heading.users.actions': 'Azioni',

	'table.heading.common.apps.customer': 'Organizzazione',
	'table.heading.common.apps.pkg': 'ID pacchetto',
	'table.heading.common.apps.name': 'Nome applicazione',
	'table.heading.common.apps.version': 'Versione',
	'table.heading.common.apps.url': 'URL',
	'table.heading.common.apps.label': 'Icona',
	'table.heading.common.apps.actions': 'Azioni',

	'notfound.devices': 'Non ci sono dispositivi da visualizzare.',
	'notfound.files': 'L\'elenco dei file è vuoto.',
	'notfound.configurations': 'Non sono state trovate configurazioni.',
	'notfound.customers': 'Organizzazioni non trovate.',
	'notfound.common.apps': 'Non ci sono applicazioni da visualizzare.',
	'notfound.applications': 'Applicazioni non trovate',
	'notfound.groups': 'Nessun gruppo trovato. Prova una query diversa.',
	'notfound.users': 'Utenti non trovati. Prova una query diversa.',
	'notfound.apps.for.display': 'Non ci sono applicazioni da visualizzare.',
	'notfound.app.versions.for.display': 'Non ci sono versioni da visualizzare.',
	'notfound.roles': 'L\'elenco dei ruoli è vuoto.',
    'notfound.icons':'L\'elenco delle icone è vuoto.',

	'format.date.header': 'HH:mm dd/MM/yyyy',

	'menu.about': 'Informazioni',
	'menu.profile': 'Profilo',
	'menu.panel.master': 'Pannello principale',
	'menu.panel.main': 'Pannello principale',
	'menu.logout': 'Disconnetti',
	'menu.functions': 'Funzioni',
	'menu.settings': 'Impostazioni',
	'menu.show.hints': 'Mostra suggerimenti',

	'plugin.name.not.specified': '<< Il nome della funzione non è specificato >>',

	'breadcrumb.summary': 'Riepilogo',
	'breadcrumb.devices': 'Dispositivi',
	'breadcrumb.applications': 'Applicazioni',
	'breadcrumb.configurations': 'Configurazioni',
	'breadcrumb.files': 'File',
	'breadcrumb.default.design': 'Design predefinito',
	'breadcrumb.common.settings': 'Visualizzazione tabella dispositivi',
	'breadcrumb.language.settings': 'Lingua e altre impostazioni',
	'breadcrumb.license.settings': 'Licenza',
	'breadcrumb.users': 'Utenti',
	'breadcrumb.groups': 'Gruppi',
	'breadcrumb.hints': 'Suggerimenti',
	'breadcrumb.plugins': 'Plugin',
	'breadcrumb.config.details': 'Dettagli',
	'breadcrumb.application.versions': 'Versioni',

	'app.name': 'Device Management',
	'app.vendor.name':"Convergent Tech",
	'app.vendor.link':"",
	'app.description': 'è un sistema di gestione dei dispositivi mobili open source',
	'app.title': 'Pannello Web ${appName}',

	'box.show.my.apps.only': 'Visualizza solo le mie applicazioni',
	'configuration.app.version.upgrade.message': 'Versione installata ${installedVersion}, versione disponibile ${latestVersion}',

	'about.line.1': 'Pannello di controllo ${appName}',
	'about.line.2': 'Enterprise launcher per Android',
	'about.line.3': 'Versione ${versionNumber}',
	'about.line.4': 'Plugin installati',

	'common.app.clarification': 'Questa applicazione è pubblica e non disponibile per la modifica. Per aggiungere un\'altra versione di questa app, contatta l\'amministratore.',

	'qrcode.help.line1': 'Per configurare il dispositivo Android (versione 7 o superiore) in modalità gestita (aziendale):',
	'qrcode.help.line2': 'Ripristina le impostazioni di fabbrica del dispositivo',
	'qrcode.help.line3': 'Tocca 7 volte in qualsiasi punto della schermata iniziale (devi entrare in una modalità di scansione del codice QR nascosto)',
	'qrcode.help.line4': 'Segui le istruzioni del dispositivo: accetta i termini, connettiti al Wi-Fi, scansiona questo codice QR',
	'qrcode.help.line5': 'Il codice QR potrebbe contenere l\'ID dispositivo per ${appName} (quindi non devi inserirlo su un dispositivo mobile). Per incorporare l\'ID dispositivo nel codice QR, inserisci l\'ID dispositivo in questa schermata e fai clic su "Rinnova".',

	'form.configuration.app.version.select.select.title': 'Seleziona la versione da installare',
	'form.configuration.app.version.select.version.check.off': 'Disattiva il controllo della versione',
	'form.configuration.app.version.select.upgrade.warning': 'Aggiornare l\'applicazione "${v1}" alla versione "${v3}" per la configurazione "${v2}"?',
	'form.configuration.app.version.select.downgrade.warning': 'Downgrade della versione ELIMINA TUTTE QUESTE APPLICAZIONI su tutti i dispositivi! Downgrade della versione dell\'applicazione "${v1}" alla versione "${v2}"? ',

	'hint.step.1': 'Clicca qui per avviare la registrazione del dispositivo',
	'hint.step.2': 'Clicca qui per aprire il codice QR',
	'hint.step.3': 'Clicca qui per vedere come aprire lo scanner del codice QR sul dispositivo',
	'hint.step.4': 'Trova un ID dispositivo disponibile nella scheda «Dispositivi». Fai clic su «Rinnova» per includerlo nel codice QR.',

	'ie.browser.notice.1': 'Purtroppo, Internet Explorer non è supportato.',
	'ie.browser.notice.2': 'Browser consigliato per l\'utilizzo di ${appName} - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop">Chrome</a>.',

	'form.resolved.duplicate.pkg.text1': 'L\'ID pacchetto "${pkg}" è già utilizzato dalle applicazioni elencate di seguito.',
	'form.resolved.duplicate.pkg.text2': 'Vuoi aggiungere una nuova applicazione o una nuova versione di un\'applicazione esistente?',
	'form.resolved.duplicate.pkg.text3': 'Nuova versione per',
	'form.resolved.duplicate.pkg.text4': 'L\'ID pacchetto "${pkg}" è già utilizzato dalle applicazioni ${apps}',
	'form.resolved.duplicate.pkg.text5': 'Sei sicuro di voler modificare l\'ID pacchetto?',

	'tooltip.usage.byconfigurations': 'Utilizzato dalle configurazioni',
	'tooltip.usage.byapps': 'Utilizzato dalle applicazioni',
	'tooltip.usage.byicons': 'Utilizzato dalle icone',

	'form.devices.label.params.more': 'Altri parametri',
	'form.devices.label.params.less': 'Meno parametri',
	'form.devices.label.installation.status': 'Stato installazione',
	"format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
	"format.devices.date.datePicker": "dd-MM-yyyy",
	'form.devices.fast.search': 'Ricerca rapida per numero',

	'form.devices.selection.install.status.default': 'Stato installazione ...',
	'form.devices.selection.install.status.all': 'Tutto',
	'form.devices.selection.install.status.success': 'Riuscito',
	'form.devices.selection.install.status.version.mismatch': 'Versione non corrispondente',
	'form.devices.selection.install.status.failure': 'Errore',
	'form.devices.selection.imei.changed': 'IMEI modificato di recente',

	'search.placeholder.launcher.version': 'Versione launcher',
	'error.date.range.invalid': 'Intervallo di date non valido',

	'form.selection.status.any': 'Qualsiasi valore',
	'form.selection.status.all': 'Tutti',
	'form.selection.status.yes': 'Sì',
	'form.selection.status.no': 'No',

	'form.devices.selection.status': 'Stato ...',
	'form.devices.selection.online': 'Online',
	'form.devices.selection.offline': 'Offline',
	'form.devices.selection.number': 'Inserisci un numero',

	'form.devices.selection.online.status.custom': 'Inserisci l\'ora',
	'form.devices.selection.online.status.1': '15 minuti',
	'form.devices.selection.online.status.2': '30 minuti',
	'form.devices.selection.online.status.3': '1 ora',
	'form.devices.selection.online.status.4': '2 ore',
	'form.devices.selection.online.status.5': '6 ore',
	'form.devices.selection.online.status.6': '1 giorno',
	'form.devices.selection.online.status.7': '2 giorni',
	'form.devices.selection.online.status.8': '3 giorni',
	'form.devices.selection.online.status.9': '1 settimana',
	'form.devices.selection.online.status.10': '1 mese',

	'form.devices.selection.online.status.label': 'minuto(i)',
	'form.devices.status.ago': 'ago',
	'form.devices.status.minutes': 'm',
	'form.devices.status.hours': 'h',
	'form.devices.status.days': 'd',
	'form.devices.status.weeks': 'settimane',
	'form.devices.status.months': 'lun',
	'form.devices.status.years': 'anni',

	'customer.type.demo': 'Demo',
	'customer.type.small': 'Professionale',
	'customer.type.corporate': 'Enterprise',
	'customer.type.master': 'Primaria',

	'customer.type.options.all': 'Tutti i tipi',
	'customer.status.options.all': 'Tutti gli stati',

	'account.expiring': 'Il tuo account scadrà tra ${days} giorni. Contatta il venditore per rinnovare il tuo account.',
	'account.expired.short': 'Il tuo account è scaduto!',
	'account.expired': 'Il tuo account è scaduto. Contatta il venditore per rinnovare il tuo account.',
	'device.limit.achieved': 'Impossibile aggiungere un dispositivo perché hai raggiunto il tuo limite. Rimuovi alcuni dispositivi o contatta il venditore per estendere il limite dei tuoi dispositivi.',

	'menu.updates': 'Controlla aggiornamenti',
	'updates.title': 'Aggiornamenti',
	'updates.disabled.custom': 'Versione personalizzata, aggiorna manualmente',
	'updates.disabled.not_master': 'Chiedi al provider di hosting di aggiornare',
	'updates.disabled.multiple': 'Più versioni dell\'app, aggiorna manualmente',
	'updates.disabled.error': 'Errore interno del server',
	'updates.disabled.download': 'Errore durante il download di un aggiornamento',
	'updates.application': 'Applicazione',
	'updates.current.version': 'Versione corrente',
	'updates.available.version': 'Versione disponibile',
	'updates.downloaded': 'Scaricato',
	'updates.auto.update': 'Aggiorna automaticamente le app mobili (usare con cura in produzione!)',
	'updates.enable.stats': 'Invia statistiche di utilizzo al fornitore di servizi per migliorare le prestazioni del sistema',
	'updates.get': 'Ottieni aggiornamenti',
	'updates.checking': 'Controllo aggiornamenti...',
	'updates.getting': 'Ottieni aggiornamenti...',
	'updates.success': 'Aggiornamento completato',
	'updates.web.hint': 'Per completare l\'aggiornamento dell\'app Web, esegui lo script shell "/opt/hmdm/update-web-app.sh" nella console SSH',

	'manual.title': 'Manuale di installazione di Device Management',
	'manual.domain': 'Nome dominio',
	'manual.domain.placeholder': 'Nome dominio della tua istanza Device Management',
	'manual.key': 'Chiave di supporto',
	'manual.key.placeholder': 'XXXX-XXXX-XXXX-XXXX',
	'manual.submit': 'Ottieni manuali',
	'manual.key.invalid': 'La chiave non è valida!',
	'manual.option.select': '(Seleziona il manuale)',
	'manual.option.0': 'Imposta una nuova istanza di Device Management',
	'manual.option.1': 'Aggiorna Device Management Community',
	'manual.option.2': 'Installa i plugin Headwind Remote e URL Filtering',
	'manual.option.3': 'Imposta una nuova istanza di Headwind Remote',
	'manual.license.premium': 'Premium',
	'manual.license.enterprise': 'Enterprise',

	'permission.edit_device_app_settings': 'Gestisci impostazioni app specifiche del dispositivo',
	'permission.plugins_customer_access_management': 'Gestisci i plugin disponibili',
	'permission.plugin_audit_access': 'Visualizza il registro di controllo',
	'permission.plugin_contacts_access': 'Gestisci i contatti',
	'permission.plugin_deviceexport_access': 'Esporta dispositivi',
	'permission.plugin_deviceimport_access': 'Importa dispositivi',
	'permission.plugin_deviceinfo_access': 'Visualizza informazioni dettagliate sul dispositivo',
	'permission.plugin_devicelocations_access': 'Visualizza i dispositivi sulla mappa',
	'permission.plugin_devicelocations_settings_access': 'Configura il plugin della mappa',
	'permission.plugin_devicelog_access': 'Visualizza i registri del dispositivo',
	'permission.plugin_devicereset_access': 'Reimposta e riavvia devices',
	'permission.plugin_licensing_access': 'Accesso alla licenza (obsoleto)',
	'permission.plugin_messaging_send': 'Invia messaggi',
	'permission.plugin_messaging_delete': 'Elimina messaggi inviati',
	'permission.plugin_photo_remove_photo': 'Elimina foto',
	'permission.settings': 'Gestisci impostazioni',
	'permission.configurations': 'Visualizza configurazioni',
	'permission.edit_devices': 'Modifica info dispositivo',
	'permission.edit_device_desc': 'Modifica descrizione dispositivo',
    'permission.enroll_devices': 'Registra i dispositivi tramite codice QR',
	'permission.plugin_apuppet_access': 'Controllo remoto',
	'permission.plugin_knox_access': 'Plugin Knox',
	'permission.add_config': 'Aggiungi configurazioni',
	'permission.copy_config': 'Configurazioni duplicate',
	'permission.plugin_openvpn_access': 'Plugin OpenVPN',
	'permission.plugin_photo_access': 'Plugin foto',
	'permission.push_api': 'Accesso a Push API',
	'permission.plugin_urlfilter_access': 'Filtraggio URL',
	'permission.plugin_push_send': 'Invia messaggi Push',
	'permission.plugin_push_delete': 'Elimina messaggi Push',
	'permission.get_updates': 'Controlla aggiornamenti',
	'permission.plugin_xtra_access': 'Richiedi versione Premium',
	'permission.applications': 'Visualizza applicazioni',
	'permission.edit_applications': 'Gestisci applicazioni',
	'permission.edit_application_versions': 'Gestisci versioni applicazioni',
	'permission.files': 'Visualizza file',
	'permission.edit_files': 'Gestisci file',

	'yes': 'sì',
	'no': 'no'
};
