if (! document.localization) document.localization = [];

document.localization ['es_ES'] = {
    'login.username': 'Usuario o Email',
    'login.username.placeholder': 'Ingrese su usuario o email',
    'login.password': 'Contraseña:',
    'login.password.placeholder': 'Ingrese contraseña',
    'login.submit': 'Ingresar',
    'login.password.incorrect': 'Usuario o contrseña invalidos.',
    'login.password.recovery': '¿Contraseña perdida?',
    'recovery.password': 'Recuperar contraseña',
    'recovery.password.success': 'Se han enviado instrucciones de recuperación de contraseña a su correo electrónico.',
    'login.no.account': '¿No tienes una cuenta?',
    'login.signup': 'Inscribirse',

    'signup.title': 'Empezar',
    'signup.email': 'Tu dirección de correo electrónico',
    'signup.email.placeholder': 'Ingrese una dirección de correo electrónico válida',
    'signup.email.invalid': 'Ingrese una dirección de correo electrónico válida',
    'signup.terms.agree': 'Estoy de acuerdo con',
    'signup.terms.terms': 'términos y condiciones',
    'signup.submit': 'Registrarse',
    'signup.progress': 'Registrándose...',
    'signup.email.used': 'Un cliente con este correo electrónico ya está registrado',
    'signup.name.used': 'Ya está registrado un cliente con este nombre de usuario',
    'signup.complete': '¡Gracias por registrarte!',
    'signup.email.check': '¡Por favor revise su correo electrónico y siga el enlace para completar el registro!',
    'signup.complete.title': '¡Tu cuenta en ${appName} está casi lista!',
    'signup.ready.title': '¡Tu cuenta en ${appName} está lista!',
    'signup.customer.id': 'Nombre de usuario',
    'signup.customer.id.placeholder': 'Usar solo letras y dígitos',
    'signup.customer.id.invalid': 'Utilice 6 o más caracteres, solo letras y dígitos',
    'signup.first.name': 'Nombre',
    'signup.first.name.placeholder': 'Tu primer nombre (requerido)',
    'signup.last.name': 'Apellido',
    'signup.last.name.placeholder': 'Su apellido (requerido)',
    'signup.company': 'Nombre de la empresa',
    'signup.company.placeholder': 'Nombre de su negocio (opcional)',
    'signup.description': '¿Cómo usará MDM?',
    'signup.description.placeholder': 'Esto ayudará a nuestro equipo a asistirlo',
    'signup.password': 'Contraseña',
    'signup.password.repeat': 'Repetir la contraseña',
    'signup.password.placeholder': '6+ caracteres',
    'signup.password.short': 'Ingrese al menos 6 caracteres',
    'signup.password.not.match': 'Las contraseñas no coinciden',
    'signup.finalized.title': '¡Tu cuenta está lista!',
    'signup.finalized.description': 'En poco tiempo, debe recibir el correo electrónico que contiene instrucciones útiles. Revise este correo electrónico e inicie sesión en el panel web con su nombre de usuario y contraseña.',
    'signup.token.invalid.title': 'El token no es válido o ya se usó',
    'signup.token.invalid.description': '¡Vuelva a intentar registrarse para crear una cuenta nueva!',

    'header.label.username': 'Usuario',

    'summary.devices.status': 'Estado del dispositivo',
    'summary.devices.active': 'Activo',
    'summary.devices.idle': 'Inactivo',
    'summary.devices.offline': 'Sin conexión',
    'summary.devices.enrollment': 'Resumen de inscripción',
    'summary.devices.enrolled.total': 'Total inscrito',
    'summary.devices.enrolled.earlier': 'Inscrito anteriormente',
    'summary.devices.enrolled.monthly': 'Últimos 30 días',
    'summary.devices.installation.status': 'Estado de la aplicación',
    'summary.devices.installation.completed': 'Completo',
    'summary.devices.version.mismatch': 'La versión no coincide',
    'summary.devices.installation.failed': 'Error de instalación',
    'summary.devices.enrolled.lastyear': 'Últimos 12 meses',

    'devices.group.options.all': 'Todos los Grupos',
    'devices.configuration.options.all': 'Toda las Configuraciónes',
    'devices.permissions.all': 'Todos los permisos fueron concedidos',
    'devices.permissions.not.as.device.admin': '- La aplicacion no esta instalada como Administrador del Dispositivo',
    'devices.permissions.window.overlap.prohibited': '- Sobreponerse sobre ventanas no esta activo',
    'devices.permissions.history.access.prohibited': '- El acceso al historial de uso no esta configurado',
    'devices.unknown': 'Desconocido',
    'devices.model.unknown': 'Desconocido',
    'devices.date.unknown': 'desconocido',
    'devices.date.format': 'dd/MM/yy HH:mm',
    'devices.app.installed': '- ${applicationName}: Instalada.',
    'devices.app.not.installed': '- ${applicationName}: no instalada.',
    'devices.app.version.available': ', disponible ${applicationVersion}',
    'devices.app.installed.and.version.available': '- ${applicationName}: instalada ${applicationInstalledVersion}, disponible ${applicationVersionAvailable}',
    'devices.app.needs.removal': '${applicationVersion}, requiere eliminar',
    'devices.no.data': 'El dispositivo no ha trasmitido ningun dato',
    'devices.settings.conformance.broken': 'Problema de configuración: (${serverData})',
    'devices.file.installed': '- ${file}: instalado',
    'devices.file.not.installed': '- ${file}: no instalado.',
    'devices.file.lastUpdate.differs': '- ${file}: diferencia en tiempo de modificacion de ${diff} minutos',

    'button.apply': 'Aplicar',
    'button.gps.on': 'Activar GPS',
    'button.wifi.on': 'Activar Wi-Fi',
    'button.notify.update': 'Notificar en Actualizacion',
    'button.app.settings': 'Configuración de la Aplicacion',
    'button.ok': 'OK',
    'button.help': 'Ayuda',
    'button.new.app': 'Nueva aplicacion',
    'button.new.app.version': 'Nueva version',
    'button.upgrade': 'Actualizar',
    'button.renew.config': 'Actualizar en dipositivos',
    'button.common': 'Aplicacion comun',
    'button.close': 'Cerrar',
    'button.yes': 'Si',
    'button.cancel': 'Cancelar',
    'button.save': 'Guardar',
    'button.save.and.close': 'Guardar and Cerrar',
    'button.more': 'Mas ...',
    'button.cleanup': 'Limpiar',
    'button.add': 'Añadir',
    'button.add.icon': 'Nuevo Icono',
    'button.search': 'Buscar',
    'button.export': 'Exportar',
    'button.change': 'Editar',
    'button.copy': 'Copiar',
    'button.qrcode': 'Codigo QR',
    'button.application': 'Aplicacion',
    'button.change.password': 'Cambiar contraseña',
    'button.set.configuration': 'Definir configuración',
    'button.set.group': 'Definir un grupo',
    'button.group.action': 'Acción de grupo',
    'button.delete': 'Eliminar',
    'button.login': 'Ingresar',
    'button.renew.code': 'Actualizar',
    'button.configurations': 'Configuraciónes',
    'button.set.configurations': 'Especificar Configuraciónes',
    'button.edit.versions': 'Versiones',
    'button.edit': 'Editar',
    'button.change.common.app': 'Editar Aplicacion Compartida',
    'button.delete.common.app': 'Eliminar Aplicacion Compartida',
    'button.turn.common.app': 'Convertir en Comun',
    'button.hints.enable': 'Mostrar Pistas',
    'button.hints.disable': 'Ocultar Pistas',
    'button.show.password': 'Mostrar contraseña',
    'button.hide.password': 'Ocultar Contraseña',

    'question.impersonate.user': 'Ingresar como el administrador de la aplicacion "${customerName}"?',
    'question.change.user': '¿Iniciar sesión en la aplicación como usuario "${userName}"?',
    'question.delete.file': 'Eliminar archivo "${fileName}"?',
    'question.delete.customer': 'Eliminar organizacion "${customerName}"?',
    'question.delete.user': 'Eliminar usuario "${username}"?',
    'question.delete.application': 'Eliminar aplicacion"${applicationName}"?',
    'question.delete.application.version': 'Eliminar version "${applicationVersion}"?',
    'question.delete.configuration': 'Elminar configuración "${configurationName}"?',
    'question.delete.group': 'Eliminar grupo "${groupName}"?',
    'question.delete.role': 'Eliminar el rol "${roleName}"?',
    'question.delete.icon': 'Eliminar el icono "${iconName}"?',
    'question.delete.device.bulk': '¿Eliminar los dispositivos seleccionados?',
    'question.delete.device': 'Elminar dispositivo con número "${deviceNumber}"?',
    'question.exit.without.saving': 'Los cambios no fueron guardados. Desea salir de esta pagina de todos modos?',
    'question.turn2common.application': 'Compartir aplicacion "${applicationName}"?',
    'question.app.upgrade': 'Actualizar aplicacion "${v1}" a la ultima version "${v2}"?',

    'error.application.setting.empty.app': 'Especificar aplicacion',
    'error.application.setting.empty.name': 'Ingrese un nombre',
    'error.application.setting.empty.value': 'Ingrese un valor',

    'error.icon.dimension.invalid': 'El Icono debe ser cuadrado',
    'error.icon.empty.name': 'Ingrese el nombre del icono',
    'error.icon.empty.file': 'Subir icono',
    'error.application.version.pkg.mismatch': 'La ID del paquete (${actual}), no corresponde a la aplicacion (${expected})',
    'error.empty.user': 'Seleccione usuario',
    'error.empty.user.name': 'Ingrese el nombre de usuario',
    'error.empty.user.login': 'Ingrese el usuario para ingreso',
    'error.empty.user.role': 'Seleccione el rol',
    'error.empty.password': 'Ingrese nueva contraseña',
    'error.empty.password.confirm': 'Ingrese confirmacion de contraseña',
    'error.user.not.found': 'Usuario no encontrado',
    'error.email.not.configured': 'Correo electrónico no configurado',
    'error.email.not.found': 'Correo electrónico de usuario no configurado',
    'error.empty.group.name': 'Ingrese el nombre del grupo',
    'error.empty.configuration': 'Especifique la configuración',
    'error.empty.configuration.name': 'Ingrese el nombre de la configuración',
    'error.empty.configuration.password': 'Ingrese la contraseña',
    'error.empty.configuration.contentApp': 'No hay contenido para aplicacion especificada',
    'error.empty.group': 'Agregar un dispositivo a uno o más grupos',
    'error.invalid.character': 'El número de dispositivo no puede contener símbolos / ? &',
    'error.invalid.configuration.mainApp': 'En las opciones del MDM, se uso la aplicacion incorrecta',
    'error.invalid.configuration.contentApp': 'Aplicacion de contenido especificada invalida',
    'error.mismatch.password': 'Las contraseñas deben coincidir',
    'error.empty.customer.name': 'Ingrese el nombre de la organizacion',
    'error.empty.customer.prefix': 'Ingrese el encabezado del nombre',
    'error.empty.customer.device.configuration': 'Seleccione una configuración',
    'error.empty.customer.duplicate.prefix': 'Encabezado ya esta en uso',
    'error.duplicate.customer.name': 'La organizacion con el nombre elegido ya existe. Intente un nombre diferente.',
    'error.duplicate.group.name': 'El grupo con el nombre elegido ya existe. Intente un nombre diferente.',
    'error.duplicate.configuration.name': 'La configuración con el nombre elegido ya existe. Intente un nombre diferente.',
    'error.duplicate.device.number': 'Ya existe un dispositivo con este número',
    'error.internal.server': 'Error interno del servidor',
    'error.permission.denied': 'No posee permisos para ejecutar',
    'error.request.failure': 'Fallo el pedido',
    'error.configuration.device.use': 'No puede eliminar esta configuración, esta en uso en dispositivos. Primero dirijase a "Dispositivos" y cambie su configuración',
    'error.invalid.system.update.time': 'Intervalo de instalación invalido',
    'error.size.limit.exceeded': 'Límite de almacenamiento excedido',

    'error.configuration.file.empty.name': 'Ingrese nombre del archivo',
    'error.configuration.file.empty.desc': 'Ingrese descripcion',
    'error.configuration.file.empty.path': 'Ingrese la ruta local del dispositivo',
    'error.configuration.file.empty.file': 'Por favor, cargue un archivo',
    'error.configuration.file.empty.url': 'Por favor, especifique la URL del archivo',

    'error.notfound.device': 'No se encontro dispositivo',
    'error.duplicate.device': 'Ya existe un dispositivo con el mismo número',
    'error.duplicate.login': 'El usuario para ingreso ya existe',
    'error.duplicate.email': 'Ya existe un usuario con este correo electrónico',
    'error.duplicate.group': 'Ya existe un grupo con el mismo nombre',
    'error.duplicate.application': 'Ya existe una aplicacion con la misma ID',
    'error.recent.application.version.exists': 'Ya existe una version superior de la aplicacion',
    'error.common.application.access.prohibited': 'El manejo de aplicaciones comunes solo puede ser realizado por el Super-Administrador',
    'error.application.config.reference.exists': 'La aplicacion esta siendo usada en configuraciónes y no puede eliminarse',
    'error.application.version.deletion.prohibited': 'La version es unica o bien esta siendo usada en confituraciones y no puede eliminarse',
    'error.duplicate.file': 'Ya existe un archivo con el mismo nombre',
    'error.used.file': 'Este archivo esta en uso',
    'error.version.exists': 'Ya existe una version igual de la aplicacion',
    'error.duplicate.configuration': 'Ya existe una configuración con este nombre',
    'error.duplicate.role.name': 'Ya existe un rol con el mismo nombre',
    'error.empty.role.name': 'Especifique el nombre del rol',
    'error.duplicate.icon.name': 'Ya existe un icono con el mismo nombre',
    'error.notfound.customer.admin': 'No se encontro la cuenta de Administrador',
    'error.apk.file.required': 'Seleccione un archivo con extension .apk o .xapk',
    'error.apk.parse': 'Ha ocurrido un error al procesar el archivo',
    'error.package.not.match': 'El ID del paquete no coincide',
    'error.empty.app.name': 'Ingrese el nombre de la aplicacion',
    'error.empty.app.pkg': 'Ingrese la ID del paquete',
    'error.empty.app.url': 'Ingrese la URL',
    'error.empty.app.iconText': 'Ingrese el texto del icono',
    'error.empty.app.version': 'Ingrese la version de la aplicacion',
    'error.notempty.group': 'Este grupo incluye uno o mas dispositivos. No puede ser removido.',
    'error.file.empty': 'Subir un nuevo archivo',
    'error.file.deletion': 'Error eliminando archivo en el servidor',
    'error.file.save': 'Error guardando archivo en el servidor',
    'error.password.wrong': 'Contraseña invalida',
    'error.password.empty': 'Contraseña no especificada',
    'error.password.weak': 'Calidad de contraseña débil',
    'error.params.missing': 'Parametros faltantes:',
    'error.empty.push.options': 'Por favor, seleccione las opciones de notificaciones "Push"',
    'error.app.name.exists': 'Ya existe otra aplicación con este nombre. Especifique un nombre único.',

    'table.filtering.check.all': 'Seleccionar Todo',
    'table.filtering.uncheck.all': 'Cancelar Todo',
    'table.filtering.suffix.configuration': 'configuraciónes',
    'table.filtering.suffix.group': 'grupos',
    'table.filtering.suffix.permission': 'permisos',
    'table.filtering.no.selected.configuration': 'No se seleccionaron configuraciónes',
    'table.filtering.no.selected.group': 'No se seleccionaron grupos',
    'table.filtering.no.selected.permission': 'No se seleccionaron permisos',

    'success.admin.created': 'Cuenta de Administrador creada:\n ${adminCredentials}',
    'success.uploading.file': 'El archivo fue subido al servidor ...',
    'success.loading.devices': 'Cargado lista de dispositivos ...',
    'success.loading.customer': 'Cargando detalles del cliente ...',
    'success.file.uploaded': 'Archivo subido satisfactoriamente.',
    'success.file.uploaded.need.save': 'Archivo subido satisfactoriamente. Ingrese la ruta relativa y presione "Guardar".',
    'success.settings.design.saved': 'Configuración de diseño guardada satisfactoriamente',
    'success.settings.common.saved': 'Configuración de tabla de dispositivos guardada satisfactoriamente',
    'success.settings.saved': 'Configuraciónes guardadas satisfactoriamente',
    'success.settings.apiKey.saved': 'Clave API guardada satisfactoriamente',
    'success.settings.hints.enabled': 'Pistas habilitadas',
    'success.settings.hints.disabled': 'Pistas deshabilitadas',
    'success.configuration.saved': 'Configuración guardada satisfactoriamente',
    'success.operation.completed': 'Operacion completada satisfactoriamente',
    'success.plugins.disabled': 'Configuración guardada satisfactoriamente',
    'success.config.update.notification': 'La actualizacion de configuración fue enviada a los dispositivos.',
    'success.config.update.device.app.settings.notification': 'La actualizacion de configuración fue enviada al dispositivo',

    'form.icon.title': 'Icono',
    'form.icon.name': 'Nombre',
    'form.icon.file': 'Archivo',

    'configuration.add.warning': '¿Está seguro de que desea crear una configuración vacía? Deberá agregar todas las aplicaciones del sistema necesarias manualmente. En su lugar, considere copiar y modificar una configuración existente.',
    'configuration.remove.warning': '¿Está seguro de que desea eliminar la última configuración? Perderá información sobre las aplicaciones del sistema necesarias.',
    'form.configuration.title': 'Configuración',
    'form.configuration.title.typical': 'Configuración tipica',
    'form.configuration.settings.auto.update': 'Auto-Actualizar',
    'form.configuration.settings.system.update': 'Actualizacion del Sistema',
    'form.configuration.settings.system.update.default': 'Por Defecto',
    'form.configuration.settings.system.update.immediate': 'Inmediatamente',
    'form.configuration.settings.system.update.scheduled': 'Programada',
    'form.configuration.settings.system.update.postponed': 'Postpuesta',
    'form.configuration.settings.system.update.time': 'Hora de instalación',
    'form.configuration.settings.system.update.time.from': 'de:',
    'form.configuration.settings.system.update.time.to': 'para:',
    'form.configuration.settings.system.schedule.app.update': 'Programar actualización de la aplicación',
    'form.configuration.settings.system.app.update.time': 'Hora de instalación',
    'form.configuration.settings.download.updates': 'Descargar contenido',
    'form.configuration.settings.download.updates.unlimited': 'Sin límites',
    'form.configuration.settings.download.updates.limited': '3 intentos en la red móvil',
    'form.configuration.settings.download.updates.wifi': 'Solo por WiFi',
    'form.configuration.settings.block.status.bar': 'Bloqueo de Barra de Estado',
    'form.configuration.settings.block.status.bar.hint': 'Esta configuración está obsoleta y funciona en Android 6 y versiones anteriores. Para bloquear la barra de estado en las versiones más recientes de Android, use el modo quiosco (configuración de MDM).',
    'form.configuration.settings.mdm.kiosk.mode': 'Modo "Kiosk"',
    'form.configuration.settings.mdm.app.main': 'Aplicacion MDM',
    'form.configuration.settings.mdm.component.event.receiver': 'Clase de receptor de administrador',
    'form.configuration.settings.mdm.component.event.receiver.placeholder': 'Debería ser com.hmdm.launcher.AdminReceiver',
    'form.configuration.settings.mdm.component.wifi.ssid': 'WiFi SSID',
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'WiFi SSID de provisionamiento - dejar en blanco para ingresar manualmente',
    'form.configuration.settings.mdm.component.wifi.password': 'Contraseña WiFi',
    'form.configuration.settings.mdm.component.wifi.password.placeholder': 'Contraseña WiFi de provisionamiento - dejar en blanco para ingresar manualmente',
    'form.configuration.settings.mdm.component.wifi.security': 'Tipo de seguridad WiFi',
    'form.configuration.settings.mdm.component.wifi.notice': 'Aviso: ¡estas configuraciónes de WiFi se aplican solo a la inscripción inicial!',
    'form.configuration.settings.mdm.component.server.url': 'URL del servidor',
    'form.configuration.settings.mdm.component.server.url.placeholder': 'Usado para la migracion a un nuevo servidor MDM',
    'form.configuration.settings.mdm.app.content': 'Aplicacion de Contenido',
    'form.configuration.settings.mdm.kiosk.home': 'Habilitar Boton Inicio',
    'form.configuration.settings.mdm.kiosk.recents': 'Habilitar Boton Recientes',
    'form.configuration.settings.mdm.kiosk.notifications': 'Habilitar Notificaciones',
    'form.configuration.settings.mdm.kiosk.system.info': 'Habilitar informacion de barra de estado',
    'form.configuration.settings.mdm.kiosk.keyguard': 'Activar bloqueo de pantalla',
    'form.configuration.settings.mdm.kiosk.lock.buttons': 'Bloquear el botón de encendido',
    'form.configuration.settings.mdm.mobile.enrollment': 'Inscríbase usando datos móviles',
    'form.configuration.settings.mdm.encrypt.device': 'Cifrado del dispositivo',
    'form.configuration.settings.mdm.lock.safe.settings': 'Bloquear opciones seguras (WiFi, GPS, etc)',
    'form.configuration.settings.mdm.permissive': 'Modo permisivo (desbloqueado)',
    'form.configuration.settings.mdm.kiosk.exit': 'Botón de salida del quiosco',
    'form.configuration.settings.mdm.kiosk.screen': 'Pantalla encendida',
    'form.configuration.settings.mdm.allowed.classes': 'Actividades permitidas',
    'form.configuration.settings.mdm.allowed.classes.placeholder': 'Clases separadas por comas, e.j.: com.android.settings.homepage.SettingsHomepageActivity',
    'form.configuration.settings.mdm.restrictions': 'Restricciones',
    'form.configuration.settings.mdm.restrictions.placeholder': 'Restricciones de MDM, separadas por comas, e.j.: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.launcher': 'Anular URL del iniciador',
    'form.configuration.settings.mdm.launcher.placeholder': 'URL del iniciador alternativa para la inscripción en redes cerradas',
    'form.configuration.settings.mdm.misc': 'Otras entradas de código QR',
    'form.configuration.settings.mdm.misc.placeholder': 'Entradas separadas por comas, p.e.:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url': 'URL del codigo QR',
    'form.configuration.settings.mdm.hint': 'Seleccione la aplicacion principal y componente',
    'form.configuration.apps.search.label': 'Buscar por:',
    'form.configuration.apps.sort.label': 'Ordenar:',
    'form.configuration.apps.sort.byname': 'Por nombre',
    'form.configuration.apps.sort.bypkg': 'Por ID',
    'form.configuration.apps.no.apk': 'ninguno',
    'form.configuration.apps.show.systeam.apps': 'Mostrar aplicaciones del sistema',
    'form.configuration.apps.action.select': '(seleccione)',
    'form.configuration.apps.action.install': 'Instalar',
    'form.configuration.apps.action.prohibit': 'Bloquear',
    'form.configuration.apps.action.not.install': 'No instalar',
    'form.configuration.apps.action.delete': 'Eliminar',
    'form.configuration.apps.action.permit': 'Permitir',
    'form.configuration.apps.label.inherit': 'Hederada',
    'form.configuration.apps.label.show': 'Mostrar',
    'form.configuration.apps.label.not.show': 'Ocultar',
    'form.configuration.apps.edit.details': 'Parametros adicionales',
    'form.configuration.apps.keycode': 'Codigo Key',
    'form.configuration.apps.bottom': 'Mostrar en la línea inferior',
    'form.configuration.apps.long.tap': 'Ajustes con un toque largo',
    'form.configuration.apps.hint': 'Pista: para desvincular la aplicacion de la configuración, seleccione la accion "Bloquear" o "No instalar".',
    'form.configuration.settings.design.use.default': 'Usar diseño por defecto',
    'form.configuration.settings.design.color.background': 'Color de Fondo',
    'form.configuration.settings.design.color.background.placeholder': 'Seleccione un color',
    'form.configuration.settings.design.color.app.names': 'Color del nombre de aplicaciones',
    'form.configuration.settings.design.color.app.names.placeholder': 'Seleccione un color',
    'form.configuration.settings.design.background.image.url': 'URL para la imagen de fondo',
    'form.configuration.settings.design.background.image.url.placeholder': 'Ingrese una URL para la imagen de fondo',
    'form.configuration.settings.design.icon': 'Tamaño de Icono',
    'form.configuration.settings.design.icon.small': 'Pequeño',
    'form.configuration.settings.design.icon.medium': 'Normal (+ 20%)',
    'form.configuration.settings.design.icon.large': 'Grandes (+ 40%)',
    'form.configuration.settings.design.desktop.header': 'Titulo de escritorio',
    'form.configuration.settings.design.desktop.header.no': 'No',
    'form.configuration.settings.design.desktop.header.deviceid': 'ID del Dispositivo',
    'form.configuration.settings.design.desktop.header.description': 'Descripción',
    'form.configuration.settings.design.desktop.header.custom': 'Plantilla personalizada',
    'form.configuration.settings.design.desktop.header.hint': 'Asegúrese de que este parámetro se envíe a los dispositivos (Configuración - Opciones general y de idioma)',
    'form.configuration.settings.design.desktop.header.template': 'Ingrese la plantilla',
    'form.configuration.settings.design.desktop.header.template.placeholder': 'Usar variables',
    'form.configuration.settings.design.display.status': 'Mostrar la hora y el estado de la batería',
    'form.configuration.settings.design.upload': 'Subir',
    'form.configuration.settings.common.name': 'Nombre',
    'form.configuration.settings.common.name.placeholder': 'Ingrese el nombre de la configuración',
    'form.configuration.settings.common.desc': 'Descripcion',
    'form.configuration.settings.common.desc.placeholder': 'Ingrese la descripcion de la configuración',
    'form.configuration.settings.common.admin.pwd': 'Contraseña de desbloqueo',
    'form.configuration.settings.common.admin.pwd.placeholder': 'Ingrese la contraseña de desbloqueo del dispositivo',
    'form.configuration.settings.common.gps': 'GPS',
    'form.configuration.settings.common.gps.any': 'Cualquiera',
    'form.configuration.settings.common.gps.off': 'Deshabilitado',
    'form.configuration.settings.common.gps.on': 'Habilitado',
    'form.configuration.settings.common.bluetooth': 'Bluetooth',
    'form.configuration.settings.common.wifi': 'Wi-Fi',
    'form.configuration.settings.common.mobile.data': 'Datos Mobiles',
    'form.configuration.settings.common.usb.storage': 'Bloquear almacenamiento USB',
    'form.configuration.settings.common.brightness': 'Administrar brillo',
    'form.configuration.settings.common.brightness.none': 'Ninguno',
    'form.configuration.settings.common.brightness.auto': 'Automatico',
    'form.configuration.settings.common.brightness.manual': 'Valor',
    'form.configuration.settings.common.brightness.value': 'Brillo de pantalla',
    'form.configuration.settings.common.timeout': 'Tiempo de espera en pantalla',
    'form.configuration.settings.common.timeout.value': 'Espera en pantalla (s)',
    'form.configuration.settings.common.volume.block': 'Bloquear volumen',
    'form.configuration.settings.common.volume.manage': 'Administrar volumen',
    'form.configuration.settings.common.volume.value': 'Volumen',
    'form.configuration.settings.common.timezone.mode': 'Administrar Zona',
    'form.configuration.settings.common.timezone.mode.default': 'No administrar',
    'form.configuration.settings.common.timezone.mode.auto': 'Automatico',
    'form.configuration.settings.common.timezone.mode.manual': 'Manual',
    'form.configuration.settings.common.timezone': 'Zona',
    'form.configuration.settings.common.timezone.placeholder': 'e.j. America/Los_Angeles',
    'form.configuration.settings.common.timezone.link': 'Lista de zonas',
    'form.configuration.settings.common.no.network.warning': '¡ADVERTENCIA! ¡No apague todos los canales de conexión, de lo contrario ya no podrá administrar dispositivos!',
    'form.configuration.settings.common.autostart.foreground': 'Iniciar apps en primer plano',
    'form.configuration.settings.request.updates': 'Rastreo de ubicación',
    'form.configuration.settings.request.updates.donottrack': 'Sin seguimiento activo (usar datos de ubicación de aplicaciones de terceros)',
    'form.configuration.settings.request.updates.gps': 'Rastrear ubicación por GPS',
    'form.configuration.settings.request.updates.wifi': 'Rastrear ubicación por Wi-Fi (los servicios de Google deben estar habilitados)',
    'form.configuration.settings.request.updates.prompt.gps': 'Para rastrear la ubicación por GPS, debe habilitar el GPS',
    'form.configuration.settings.request.updates.prompt.wifi': 'Para rastrear la ubicación por Wi-Fi, debe habilitar Wi-Fi',
    'form.configuration.settings.revoke.location.permission': 'Sin permiso de ubicación',
    'form.configuration.settings.revoke.location.permission.hint': 'Si se establece, el permiso de ubicación no se otorgará al agente MDM y no podrá rastrear la ubicación del dispositivo',
    'form.configuration.settings.apps.permissions': 'Permisos para otras aplicaciones',
    'form.configuration.settings.apps.permissions.grant': 'Otorgar automáticamente todos los permisos',
    'form.configuration.settings.apps.permissions.ask.location': 'Otorgar todo automáticamente, solicitar al usuario el permiso de ubicación',
    'form.configuration.settings.apps.permissions.deny.location': 'Otorgar todo automáticamente, no otorgar permiso de ubicación',
    'form.configuration.settings.apps.permissions.ask.all': 'Preguntar al usuario por todos los permisos',
    'form.configuration.settings.push.options' : 'Notificaciones Emergentes',
    'form.configuration.settings.push.options.mqtt.worker' : 'Protocolo MQTT (ahorra bateria)',
    'form.configuration.settings.push.options.mqtt.alarm' : 'Protocolo MQTT',
    'form.configuration.settings.push.options.polling' : 'HTTP polling',
    'form.configuration.settings.push.options.mqtt.worker.hint' : 'Entrega mensajes Push instantáneamente cuando el dispositivo está activo. Pero los mensajes pueden demorarse hasta algunas horas en el modo de suspensión. No utilice esta opción en dispositivos independientes. MQTT usa el puerto TCP 31000, habilítelo en su firewall.',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT es un protocolo liviano que consume recursos mínimos. MQTT usa el puerto TCP 31000, habilítelo en su firewall.',
    'form.configuration.settings.push.options.polling.hint' : 'El sondeo prolongado mantiene una conexión HTTP que puede consumir más recursos del servidor. No requiere ningún puerto TCP que no sea HTTP(S).',
    'form.configuration.settings.push.options.keepalive' : 'Mantener vivo el tiempo',
    'form.configuration.settings.minute.1' : '1 minuto',
    'form.configuration.settings.minutes.2' : '2 minutos',
    'form.configuration.settings.minutes.3' : '3 minutos',
    'form.configuration.settings.minutes.5' : '5 minutos',
    'form.configuration.settings.minutes.10' : '10 minutos',
    'form.configuration.settings.minutes.15' : '15 minutos',
    'form.configuration.settings.password.mode' : 'Requerimientos de contraseña',
    'form.configuration.settings.password.mode.any' : 'Ninguno',
    'form.configuration.settings.password.mode.present' : 'Presente Contraseña',
    'form.configuration.settings.password.mode.easy' : 'Facil (al menos 6 simbolos)',
    'form.configuration.settings.password.mode.moderate' : 'Moderada (8+ simbolos, letras y digitos)',
    'form.configuration.settings.password.mode.strong' : 'Fuerte (8+, mayusculas & minusculas, digitos, simbolos)',
    'form.configuration.settings.show.wifi': 'Configuración de WiFi en error de conexión',
    'form.configuration.settings.use.default.launcher': 'Modo en segundo plano',
    'form.configuration.settings.use.default.launcher.hint': 'No reemplaza un iniciador del sistema, solo ejecuta servicios MDM en segundo plano. No se recomienda con el modo quiosco.',
    'form.configuration.settings.disable.screenshots': 'Deshabilitar la captura de pantalla',
    'form.configuration.settings.orientation': 'Bloquear orientacion',
    'form.configuration.settings.orientation.none': 'No bloquear',
    'form.configuration.settings.orientation.portrait': 'Vertical',
    'form.configuration.settings.orientation.landscape': 'Horizontal',
    'form.configuration.settings.files.default.path': 'Ruta predeterminada en el dispositivo',
    'form.configuration.files.search.label': 'Buscar:',
    'form.configuration.files.action.upload': 'Subir',
    'form.configuration.files.action.remove': 'Remover',
    'form.configuration.files.variables': 'Contenido variable',
    'form.configuration.files.variables.hint': 'Las cadenas DEVICE_NUMBER, IMEI, CUSTOM* se reemplazarán por sus valores',

    'form.configuration.file.name': 'Nombre archivo',
    'form.configuration.file.select': 'Seleccionar un archivo',
    'form.configuration.file.create': '(crear un nuevo archivo)',
    'form.configuration.file.description': 'Descripcion',
    'form.configuration.file.description.placeholder': 'Opcional, para su conveniencia',
    'form.configuration.file.path': 'Ruta al archivo',
    'form.configuration.file.path.placeholder': 'Sin ruta a una unidad, p. Ej. /my-app/image.jpg',
    'form.configuration.file.url': 'URL',
    'form.configuration.file.url.placeholder': 'Si un archivo está alojado en un recurso externo',
    'form.configuration.file.file': 'Archivo',
    'form.configuration.file.action': 'Accion',
    'form.configuration.file.action.prompt.1': 'Subir',
    'form.configuration.file.action.prompt.2': 'Remover',
    'form.configuration.file.remove.prompt.1': 'Este archivo no sera sincronizado con los dipositivos nunca mas',
    'form.configuration.file.remove.prompt.2': 'Eliminar este archivo del servidor',

    'form.password.title': 'Cambiar contraseña',
    'form.password.label.user': 'Usuario',
    'form.password.label.password.new': 'Nueva contraseña',
    'form.password.label.password.new.placeholder': 'Ingresa una nueva contraseña',
    'form.password.label.password.confirm': 'Verificar',
    'form.password.label.password.confirm.placeholder': 'Ingresa la contraseña nuevamente',
    'form.password.length': 'Longitud mínima: ${length}. ',

    'form.application.type': 'Tipo',
    'form.application.type.option.web': 'Pagina Web',
    'form.application.type.option.app': 'Aplicacion',
    'form.application.type.option.intent': 'Acción del sistema',
    'form.application.intent': 'Acción',
    'form.application.intent.placeholder': 'Elige una acción',
    'form.application.url.hint': 'Usa file:///storage/emulated/0/... para crear enlaces a archivos y carpetas locales',
    'form.application.pkg': 'ID Paquete',
    'form.application.from.file': 'determinada por el archivo',
    'form.application.pkg.title': 'El ID del paquete se determina automáticamente cuando carga el archivo APK. El ID de paquete ingresado manualmente solo es necesario para las aplicaciones del sistema.',
    'form.application.pkg.placeholder': 'Por ejemplo, com.android.camera',
    'form.application.disabled.arch': 'Específico de la versión',
    'form.application.disabled.arch.title': 'Para agregar APK para diferentes arquitecturas de CPU, haga clic en "Agregar" o abra la lista de versiones de la aplicación',
    'form.application.arch': 'Código nativo',
    'form.application.arch.title': 'Algunas aplicaciones contienen código optimizado para cierta arquitectura de CPU. En este caso, debe cargar dos APK (para las arquitecturas armeabi-v7a y arm64-v8a)',
    'form.application.arch.universal': 'Ninguno (APK universal)',
    'form.application.arch.armeabi': 'Código nativo para armeabi-v7a',
    'form.application.arch.arm64': 'Código nativo para arm64-v8a',
    'form.application.arch.no.split': 'APK universal',
    'form.application.arch.split': 'APK dividido',
    'form.application.arch.warning': 'Este APK está optimizado solo para ${arch} y es posible que no funcione en todos los dispositivos. Se recomienda cargar otro APK optimizado para otro arco de CPU. Para usar este APK en todos los dispositivos, seleccione "APK universal".',
    'form.application.arch.success': 'Esta aplicación contiene APK para ambas arquitecturas de CPU',
    'form.application.version.exists': 'El APK para esta versión ya existe',
    'form.application.url.armeabi': 'URL de armeabi-v7a',
    'form.application.url.arm64': 'URL de arm64-v8a',
    'form.application.name': 'Nombre Aplicacion',
    'form.application.name.title': 'Verá el nombre de la aplicación en la lista. Recomendamos utilizar nombres únicos e informativos.',
    'form.application.name.placeholder': 'Por ejemplo, Cámara (Android)',
    'form.application.version': 'Version',
    'form.application.version.placeholder': '0 para aplicaciones del sistema',
    'form.application.version.title': 'La versión del paquete se determina automáticamente cuando carga el archivo APK. Póngalo en 0 para las aplicaciones del sistema.',
    'form.application.version.code': 'Código de versión',
    'form.application.version.code.exists': 'Ya existe una versión con el mismo código. Informe este problema a los desarrolladores de la aplicación.',
    'form.application.system': 'Sistema',
    'form.application.system.title': 'Las aplicaciones del sistema están preinstaladas en un dispositivo y no requieren URL ni archivo. Establezca este indicador solo si necesita habilitar un determinado paquete del sistema.',
    'form.application.run.after.install': 'Correr luego de la instalación',
    'form.application.run.after.install.title': 'Las aplicaciones con servicios en segundo plano deben iniciarse en primer plano al menos una vez.',
    'form.application.run.at.boot': 'Correr al inicio',
    'form.application.run.at.boot.title': 'Establezca esta marca si necesita ejecutar la aplicación en primer plano después del arranque. Esta bandera no afecta los procesos en segundo plano.',
    'form.application.url': 'URL',
    'form.application.url.title': 'La URL solo debe escribirse si su aplicación está alojada en un recurso externo. Se recomienda cargar un archivo APK utilizando un campo a continuación.',
    'form.application.url.disabled': 'La URL se configura para cada versión. Para cambiar la URL, cierre esta ventana y haga clic en el icono "Versiones".',
    'form.application.file': 'Archivo',
    'form.application.auto.update': 'Auto-Actualización',
    'form.application.auto.update.title': 'Establezca esta bandera para actualizar todas las configuraciones donde está instalada la aplicación. Úselo solo si está 100% seguro de que la aplicación es estable.',
    'form.application.showLabel': 'Mostrar Icono',
    'form.application.showLabel.title': 'Esta bandera indica si el icono de la aplicación debe mostrarse en el lanzador. Esta opción puede anularse en la configuración.',
    'form.application.use.kiosk': 'Abierto en Kiosk Browser',
    'form.application.use.kiosk.title': 'Establezca esta bandera si desea abrir una página web en Kiosk-Browser sin posibilidad de cambiar la URL',
    'form.application.iconText': 'Texto del Icono',
    'form.application.iconText.placeholder': '(por defecto)',
    'form.application.versions.title': 'Versiones de Aplicacion',
    'form.application.icon': 'Icono',
    'form.application.icon.default': '(por defecto)',
    'form.application.icon.add': 'Añadir Icono',

    'form.application.setting.app': 'Aplicacion',
    'form.application.setting.app.placeholder': 'Seleccione una aplicacion',
    'form.application.setting.name': 'Atributo',
    'form.application.setting.value': 'Valor',
    'form.application.setting.comment': 'Comentario',
    'form.application.setting.type': 'Tipo',
    'form.application.setting.readonly': 'No cambia en el dispositivo',

    'form.application.configurations.app': 'Aplicacion',
    'form.application.configurations.configs': 'Configuración',

    'form.configuration.copy.new.name': 'Nuevo nombre',
    'form.configuration.copy.new.name.placeholder': 'Ingrese el nuevo nombre de configuración',

    'form.customer.name': 'Nombre',
    'form.customer.name.placeholder': 'Ingrese el nombre de la organizacion',
    'form.customer.admin.name': 'Nombre del admin',
    'form.customer.firstname.placeholder': 'Nombre de pila',
    'form.customer.lastname.placeholder': 'Apellido',
    'form.customer.language': 'Idioma',
    'form.customer.language.placeholder': 'Deje en blanco para inglés o escriba dos letras pequeñas',
    'form.customer.apiKey': 'Clave API',
    'form.customer.apiKey.placeholder': 'Ingrese la clave API',
    'form.customer.prefix': 'Prefijo',
    'form.customer.prefix.placeholder': 'Ingrese el prefijo de número de dispositivo',
    'form.customer.device.configuration': 'Configuración del Dispositivo',
    'form.customer.desc': 'Descripcion',
    'form.customer.desc.placeholder': 'Ingrese una descripcion de la organizacion',
    'form.customer.copy.configuration': 'Copiar configuraciónes',
    'form.customer.copy.design': 'Copiar diseño',
    'form.customer.type': 'Tipo de cliente',
    'form.customer.status': 'Estado de cliente',
    'form.customer.expiry.time': 'Fecha de caducidad',
    'form.customer.device.limit': 'Límite de dispositivos',
    'form.customer.size.limit': 'Límite de almacenamiento',
    'form.customer.size.limit.placeholder': 'Tamaño (Mb)',

    'form.device.number': 'Número',
    'form.device.number.locked': 'No se puede cambiar el número porque no se completó el cambio de número anterior.',
    'form.device.migration.warning': 'Se cambiará el número de dispositivo. Asegúrese de que el dispositivo esté encendido y en línea.',
    'form.device.number.hint': 'No utilice caracteres especiales',
    'form.device.desc': 'Descripcion',
    'form.device.groups': 'Grupos',
    'form.device.config': 'Configuración',
    'form.device.imei': 'IMEI',
    'form.device.phone.number': 'Número Telefonico',

    'form.update.device.config': 'Configuración',
    'form.update.device.action': 'Acción de grupo',
    'form.device.set.group': 'Agregar a grupos',
    'form.device.clear.group': 'Eliminar de grupos',

    'form.file.file': 'Archivo',
    'form.file.name': 'Nombre del archivo',
    'form.file.description': 'Descripción (opcional)',
    'form.file.external': 'Externo',
    'form.file.external.title': 'En lugar de cargar el archivo, puede especificar la URL en un recurso externo',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': 'URL del archivo en un recurso externo',
    'form.file.path': 'Ruta en el servidor',
    'form.file.device.path': 'Ruta en el dispositivo',
    'form.file.device.path.placeholder': 'Ruta relativa a /storage/emulated/0',
    'form.file.deleted': 'ELIMINADO',
    'form.file.copy.link': 'Copiar enlace: ${link}',
    'form.file.configurations.file': 'Archivo',
    'form.file.configurations.configs': 'Configuraciones',
    'form.file.configurations.upload': 'Subir',
    'form.file.path.placeholder': 'Ingrese una ruta relativa, por ejemplo "/files/"',
    'form.file.available': 'Espacio disponible: ${space} Mb',

    'form.file.apps.name': 'Nombre de Aplicacion',
    'form.file.apps.pkg': 'ID del Paquete',
    'form.file.apps.version': 'Version',

    'form.group.name': 'Nombre',
    'form.group.name.placeholder': 'Ingrese el nombre del grupo',

    'form.role.name': 'Nombre',
    'form.role.name.placeholder': 'Ingrese el nombre del rol',
    'form.role.permissions': 'Permisos',

    'form.user.login': 'Ingresar',
    'form.user.login.placeholder': 'Ingrese el usuario para ingreso',
    'form.user.name': 'Nombre',
    'form.user.name.placeholder': 'Nombre y apellido',
    'form.user.email': 'Correo electrónico',
    'form.user.email.placeholder': 'Ingrese el correo electrónico',
    'form.user.role': 'Rol',
    'form.user.all.devices.available': 'Todos los dipositivos están diposnibles',
    'form.user.available.groups': 'Grupos de dispositivos disponibles',
    'form.user.all.configs.available': 'Todas las configs están disponibles',
    'form.user.available.configs': 'Configuraciones disponibles',
    'form.user.password.new': 'Nueva Contraseña',
    'form.user.password': 'Contraseña',
    'form.user.password.new.placeholder': 'Ingrese una nueva contraseña',
    'form.user.password.confirm': 'Verificar',
    'form.user.password.confirm.placeholder': 'Ingrese la nueva contraseña otra vez',

    'form.settings.hints.title': 'Pistas',

    'form.settings.plugins.title': 'Plugins Utilizados',

    'form.settings.common.title': 'Vista de Tabla Dispositivos',
    'form.settings.common.visible.columns': 'Columnas visibles en la tabla de "Dispositivos"',
    'form.settings.common.status': 'Estado',
    'form.settings.common.role': 'Rol de usuarios',
    'form.settings.common.date': 'Última fecha en línea',
    'form.settings.common.device.number': 'Número Dispositivo',
    'form.settings.common.imei': 'IMEI',
    'form.settings.common.phone.number': 'Número Telefonico',
    'form.settings.common.phone.model': 'Modelo del Telefono',
    'form.settings.common.status.permissions': 'Estado de Permisos',
    'form.settings.common.status.installation': 'Estado de Instalación',
    'form.settings.common.status.files': 'Estado de Archivos',
    'form.settings.common.config': 'Configuración',
    'form.settings.common.desc': 'Descripcion',
    'form.settings.common.group': 'Grupo',
    'form.settings.common.launcher.version': 'Version del Launcher',
    'form.settings.common.battery.level': 'Nivel de Bateria',
    'form.settings.common.default.launcher': 'Segundo Plano',
    'form.settings.common.mdm.mode': 'Modo MDM',
    'form.settings.common.kiosk.mode': 'Modo quiosco',
    'form.settings.common.android.version': 'Versión de Android',
    'form.settings.common.enrollment.date': 'Fecha de inscripción',
    'form.settings.common.serial': 'Número de serie',
    'form.settings.common.publicip': 'Dirección IP',

    'form.settings.design.title': 'Diseño por Defecto',
    'form.settings.design.color.font': 'Color de Fondo',
    'form.settings.design.color.font.placeholder': 'Seleccione un color',
    'form.settings.design.color.app.names': 'Color de Nombre de Apliacaciones',
    'form.settings.design.color.app.names.placeholder': 'Seleccione un color',
    'form.settings.design.url.background.image': 'URL para la imagen de fondo',
    'form.settings.design.url.background.image.placeholder': 'Ingrese una URL para la imagen de fondo',
    'form.settings.design.size.icon': 'Tamaño de Iconos',
    'form.settings.design.size.icon.small': 'Pequeño',
    'form.settings.design.size.icon.medium': 'Normal (+ 20%)',
    'form.settings.design.size.icon.large': 'Grande (+ 40%)',
    'form.settings.design.desktop.header': 'Titulo del Escritorio',
    'form.settings.design.desktop.header.no': 'No',
    'form.settings.design.desktop.header.device.id': 'ID Dispositivo',

    'form.settings.lang.title': 'Opciones de Lenguaje',
    'form.settings.lang.use.default': 'Usar el lenguaje por defecto',
    'form.settings.lang.use': 'Usar lenguaje',
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.vi': 'Tiếng Việt',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title': 'Opciones Varias',
    'form.settings.misc.phone.format': 'Formato del número telefonico',
    'form.settings.misc.phone.format.placeholder': '+9 (999) 999-99-99',
    'form.settings.misc.custom.property.name.1': 'Propiedad personalizada #1',
    'form.settings.misc.custom.property.name.2': 'Propiedad personalizada #2',
    'form.settings.misc.custom.property.name.3': 'Propiedad personalizada #3',
    'form.settings.misc.custom.property.multiline': 'Multilínea',
    'form.settings.misc.custom.property.send': 'Enviar a dispositivo',
    'form.settings.misc.custom.property.name.placeholder': 'Ingrese un nombre para la propiedad personalizada',
    'form.settings.misc.create.new.devices': 'Añadir dipositivo en el primer acceso',
    'form.settings.misc.new.device.config': 'Nuevo configuración de dispositivo',
    'form.settings.misc.new.device.group': 'Nuevo grupo de dispositivos',
    'form.settings.misc.send.description': 'Enviar descripción a los dispositivos',
    'form.settings.misc.password.length': 'Longitud mínima de la contraseña',
    'form.settings.misc.password.strength': 'Seguridad de la contraseña',
    'form.settings.misc.password.none': 'No especificado (cualquier carácter)',
    'form.settings.misc.password.alphanumeric': 'Letras minúsculas y mayúsculas, dígitos',
    'form.settings.misc.password.specialchar': 'Letras minúsculas y mayúsculas, dígitos, caracteres especiales',
    'form.settings.misc.password.reset': 'El usuario debe restablecer la contraseña',
    'form.settings.misc.idle.logout': 'Cerrar sesión cuando esté inactivo',
    'form.settings.misc.idle.logout.never': 'Nunca',
    'form.settings.misc.idle.logout.1': '5 minutos',
    'form.settings.misc.idle.logout.2': '10 minutos',
    'form.settings.misc.idle.logout.3': '30 minutos',
    'form.settings.misc.idle.logout.4': '1 hora',
    'form.settings.security.title': 'Configuración de seguridad',

    'idle.logout.message': 'Se cerrará tu sesión en ${sec} segundos debido a inactividad',
    'idle.logout.resume': '¡Estoy aquí!',

    'form.settings.groups.title': 'Grupos',
    'form.settings.groups.search.placeholder': 'Buscar grupo',

    'form.settings.users.title': 'Usuarios',
    'form.settings.users.search.placeholder': 'Buscar usuario',

    'form.settings.roles.title': 'Roles de usuario',

    'form.settings.icons.title': 'Íconos',
    'form.settings.icons.search.placeholder': 'Buscar los íconos',

    'form.qr.device.number': 'ID del dispositivo',
    'form.qr.auto.create': 'Agregar a la lista de dispositivos si no existe',
    'form.qr.number.use': 'Asignación de ID de dispositivo',
    'form.qr.number.use.request': 'Valor de usuario',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': 'Número de serie',
    'form.qr.number.hint': 'Borre el número de dispositivo para habilitar la asignación automática de números de dispositivo',
    'form.qr.groups': 'Agregar a grupos',
    'form.qr.button.json': 'Obtener JSON',
    'form.qr.device.number.placeholder': 'Ingrese la ID del dispositivo ...',
    'form.qr.code.image.alt': 'Codigo QR',

    'form.password.reset.title': 'Configure una nueva contraseña',
    'form.password.reset.invalid': 'Lo sentimos, este enlace de restablecimiento de contraseña no es válido',
    'form.password.reset.submit': 'Establecer la contraseña',

    'form.two.factor.auth.title': 'Autenticación de dos factores',
    'form.two.factor.auth.hint': 'Para completar su registro, instale la aplicación Authenticator en su dispositivo móvil, escanee el código QR, genere e ingrese el código de verificación.',
    'form.two.factor.auth.code.invalid': '¡El código de verificación no es válido!',
    'form.two.factor.auth.code': 'Código de verificación',
    'form.two.factor.auth.code.hint': 'Código de 6 dígitos de la aplicación de autenticación',
    'form.two.factor.auth.code.error': 'El código debe ser un número de 6 dígitos',
    'form.two.factor.auth.verify': 'Verificar',
    'form.two.factor.auth.settings.hint': 'Para configurar la autenticación de dos factores, instale la aplicación Authenticator en su dispositivo móvil, escanee el código QR, genere e ingrese el código de verificación.',
    'form.two.factor.auth.set': 'La autenticación de dos factores está activada',
    'form.two.factor.auth.reset': 'La autenticación de dos factores está desactivada',
    'form.two.factor.auth.off.confirm': '¿Quieres desactivar la autenticación de dos factores? Después de volver a activarlo, todos los autenticadores dejarán de ser válidos.',

    'form.profile.title': 'Cambiar contraseña',
    'form.profile.password.old': 'Contraseña Anterior',
    'form.profile.password.old.placeholder': 'Ingrese la contraseña anterior',
    'form.profile.password.new': 'Nueva contraseña',
    'form.profile.password.new.placeholder': 'Ingrese una nueva contraseña',
    'form.profile.password.confirm': 'Verificar',
    'form.profile.password.confirm.placeholder': 'Ingrese nuevamente la nueva contraseña',

    'tab.customers': 'Organizaciones',
    'tab.common.applications': 'Aplicaciones Compartidas',

    'tab.devices': 'Dispositivos',
    'tab.applications': 'Aplicaciones',
    'tab.configurations': 'Configuraciónes',
    'tab.files': 'Archivos',
    'tab.default.design': 'Diseño por Defecto',
    'tab.common.settings': 'Tabla de Dispositivos',
    'tab.users': 'Usuarios',
    'tab.roles': 'Roles',
    'tab.groups': 'Grupos',
    'tab.icons': 'Iconos',
    'tab.language': 'Opciones general y de idioma',
    'tab.license': 'Licencia',
    'tab.hints': 'Pistas',
    'tab.plugins': 'Plugins',

    'tab.configeditor.common.settings': 'Opciones Comunes',
    'tab.configeditor.design.settings': 'Opciones de Diseño',
    'tab.configeditor.applications': 'Aplicaciones',
    'tab.configeditor.mdm.settings': 'Opciones MDM',
    'tab.configeditor.app.settings': 'Opciones de Aplicaciones',
    'tab.configeditor.files': 'Archivos',

    'search.placeholder.file': 'buscar archivo',
    'search.placeholder.configuration': 'Buscar configuración',
    'search.placeholder.customer': 'Buscar una organizacion',
    'search.placeholder.application': 'Buscar una aplicacion',
    'search.placeholder.application.setting': 'Buscar por una opcion de aplicacion',
    'search.placeholder.device': 'Buscar un dispositivo',
    'search.placeholder.address': 'Buscar direccion',
    'search.placeholder.point': 'Buscar sitio',
    'search.placeholder.message': 'Buscar mensaje',
    'search.placeholder': 'Buscar ...',
    'search.placeholder.from': 'De ...',
    'search.placeholder.to': 'Para ...',
    'search.placeholder.user': 'Ingrese el nombre de usuario',

    'table.heading.customer.name': 'Nombre',
    'table.heading.customer.desc': 'Descripcion',
    'table.heading.customer.registration.time': 'Registrado',
    'table.heading.customer.last.login.time': 'Ultimo ingreso',
    'table.heading.customer.actions': 'Acciones',
    'table.heading.customer.type': 'Tipo',
    'table.heading.customer.expiry.time': 'Expira',
    'table.heading.customer.device.limit': 'Límite',
    'table.heading.customer.status': 'Estado',

    'customer.new': 'Nuevo',
    'customer.active': 'Activo',
    'customer.need.followup': 'Necesita seguimiento',
    'customer.followup.sent': 'Seguimiento enviado',
    'customer.internal.test': 'Prueba interna',
    'customer.developer': 'Elaborador',
    'customer.difficult': 'Difícil',
    'customer.pause': 'Pausa',
    'customer.inactive': 'Sin inicio',
    'customer.abandon': 'Abandonado',
    'customer.onpremise': 'Local prueba',
    'customer.denial': 'Negación',
    'customer.client': 'Cliente',

    'table.heading.configuration.name': 'Nombre',
    'table.heading.configuration.desc': 'Descripcion',
    'table.heading.configuration.actions': 'Acciones',

    'table.heading.application.setting.app.pkg': 'ID de Paquete',
    'table.heading.application.setting.app.name': 'Nombre Aplicacion',
    'table.heading.application.setting.name': 'Atributo',
    'table.heading.application.setting.value': 'Valor',
    'table.heading.application.setting.comment': 'Comentario',
    'table.heading.application.setting.lastUpdate': 'Fecha de Creacion',

    'table.heading.file.url': 'URL',
    'table.heading.file.devicepath': 'Ruta en Dispositivo',
    'table.heading.file.description': 'Descripcion del archivo',
    'table.heading.file.action': 'Accion',
    'table.heading.file.lastUpdate': 'Fecha de Creacion',

    'table.heading.application.pkg': 'ID del Paquete',
    'table.heading.application.name': 'Nombre Aplicacion',
    'table.heading.application.version': 'Version',
    'table.heading.application.url': 'URL',
    'table.heading.application.label': 'Icono',
    'table.heading.application.actions': 'Acciones',
    'table.heading.application.order': 'Orden',

    'table.heading.device.status': 'Estado',
    'table.heading.device.date': 'En línea',
    'table.heading.device.device.number': 'Número Dispositivo',
    'table.heading.device.imei': 'IMEI',
    'table.heading.device.phone.number': 'Número Telefonico',
    'table.heading.device.phone.model': 'Modelo Telefono',
    'table.heading.device.status.permissions': 'Estado Permisos',
    'table.heading.device.status.installation': 'Estado Instalación',
    'table.heading.device.status.files': 'Estado Archivos',
    'table.heading.device.configuration': 'Confituracion',
    'table.heading.device.desc': 'Descripcion',
    'table.heading.device.group': 'Grupo',
    'table.heading.device.launcher.version': 'Version del Launcher',
    'table.heading.device.battery.level': 'Nivel de Bateria',
    'table.heading.device.default.launcher': 'Segundo Plano',
    'table.heading.device.mdm.mode': 'Modo MDM',
    'table.heading.device.kiosk.mode': 'Modo quiosco',
    'table.heading.device.android.version': 'Versión de Android',
    'table.heading.device.enrollment.date': 'Fecha de inscripción',
    'table.heading.device.serial': 'Número de serie',
    'table.heading.device.publicip': 'Dirección IP',
    'table.heading.device.actions': 'Acciones',

    'table.heading.group.name': 'Nombre',
    'table.heading.group.actions': 'Acciones',

    'table.heading.role.name': 'Nombre',
    'table.heading.role.actions': 'Acciones',

    'table.heading.file.name': 'Nombre',
    'table.heading.file.comment': 'Descripción',
    'table.heading.file.device.path': 'Ruta en el dispositivo',
    'table.heading.file.update.time': 'Actualizado',
    'table.heading.file.external': 'Externo',
    'table.heading.file.variable': 'Variable',
    'table.heading.file.remove': 'Eliminar',
    'table.heading.file.remove.hint': 'Fuerza la eliminación del archivo del almacenamiento del dispositivo',
    'table.heading.file.path': 'Ruta',
    'table.heading.file.address': 'Direccion',
    'table.heading.file.size': 'Tamaño',
    'table.heading.file.actions': 'Acciones',

    'table.heading.users.login': 'Ingreso',
    'table.heading.users.name': 'Nombre',
    'table.heading.users.role': 'Rol',
    'table.heading.users.actions': 'Acciones',

    'table.heading.common.apps.customer': 'Organizacion',
    'table.heading.common.apps.pkg': 'ID del Paquete',
    'table.heading.common.apps.name': 'Nombre Aplicacion',
    'table.heading.common.apps.version': 'Version',
    'table.heading.common.apps.url': 'URL',
    'table.heading.common.apps.label': 'Icono',
    'table.heading.common.apps.actions': 'Acciones',

    'notfound.devices': 'No hay dispositivos para mostrar.',
    'notfound.files':' La lista de archivos esta vacia',
    'notfound.configurations': 'No se encontraron configuraciónes.',
    'notfound.customers': 'No se encontraron organizaciones.',
    'notfound.common.apps': 'No hay aplicaciones para mostrar.',
    'notfound.applications': 'No se encontraron aplicaciones.',
    'notfound.groups':' No se encontraron grupos. Prueba una consulta diferente',
    'notfound.users':' No se encontraron usuarios. Prueba una consulta diferente',
    'notfound.apps.for.display': 'No hay aplicaciones para mostrar.',
    'notfound.app.versions.for.display': 'No hay versiones para mostrar.',
    'notfound.roles':'La lista de roles está vacía.',
    'notfound.icons':'La lista de iconos está vacía.',

    'format.date.header': 'HH:mm dd/MM/yyyy',

    'menu.about': 'Informacion',
    'menu.profile': 'Perfil',
    'menu.panel.master': 'Panel Maestro',
    'menu.panel.main': 'Panel Principal',
    'menu.logout': 'Salir',
    'menu.functions': 'Funciones',
    'menu.settings': 'Opciones',
    'menu.show.hints': 'Mostrar pistas',

    'plugin.name.not.specified': '<< El nombre de la funcion no esta especificado >>',

    'breadcrumb.summary': 'Resumen',
    'breadcrumb.devices': 'Dispositivos',
    'breadcrumb.applications': 'Aplicaciones',
    'breadcrumb.configurations': 'Configuraciónes',
    'breadcrumb.files': 'Archivos',
    'breadcrumb.default.design': 'Diseño por defecto',
    'breadcrumb.common.settings': 'Tabla de Dispositivos',
    'breadcrumb.language.settings': 'Lenguaje y Otras Opciones',
    'breadcrumb.license.settings': 'Licencia',
    'breadcrumb.users': 'Usuarios',
    'breadcrumb.roles': 'Roles',
    'breadcrumb.groups': 'Grupos',
    'breadcrumb.hints': 'Pistas',
    'breadcrumb.plugins': 'Plugins',
    'breadcrumb.config.details': 'Detalles',
    'breadcrumb.application.versions': 'Versiones',

    'app.name': 'Device Management',
    'app.vendor.name':"Convergent Tech",
    'app.vendor.link':"",
    'app.description': 'es la solucion MDM open-source',
    'app.title': '${appName} Panel Web',

    'box.show.my.apps.only': 'Mostrar mis aplicaciones solamente',
    'configuration.app.version.upgrade.message': 'Version instalada ${installedVersion}, version disponible ${latestVersion}',

    'about.line.1': '${appName} panel de control',
    'about.line.2': 'Launcher Enterprise para Android',
    'about.line.3': 'Version ${versionNumber}',
    'about.line.4': 'Plugins Instalados',

    'common.app.clarification': 'Esta aplicacion es publica y no esta disponible para editar, por favor, contacte al administrador',

    'qrcode.help.line1': 'Para configurar un dispositivo Android (version 7 or mayor) en un modo adminsitrado:',
    'qrcode.help.line2': 'Restaurar el dispositivo a su estado de fabrica',
    'qrcode.help.line3': 'Presiona 7 veces en la pantalla de inicio (debes entrar a el modo de escaneo QR)',
    'qrcode.help.line4': 'Sigue las instrucciones del dispositivo: acepta los terminos, conecta el Wi-Fi, y escanea este codigo QR',
    'qrcode.help.line5': 'Este QR debe contener el ID del dispositivo de ${appName} (no necesitas ingresarlo en el dispositivo). Para agregar la ID del dispositivo al QR, ingresa la ID del dispositvo y presiona "Renovar".',

    'form.configuration.app.version.select.select.title': 'Selecciona la version a instalar',
    'form.configuration.app.version.select.version.check.off': 'Deshabilitar la verificacion de version',
    'form.configuration.app.version.select.upgrade.warning': 'Actualizar aplicacion "${v1}" a la version version "${v3}" para configuración "${v2}"?',
    'form.configuration.app.version.select.downgrade.warning': 'Downgrade version DELETE ALL THESE APPLICATIONS on all devices! Downgrade the application version "${v1}" to version "${v2}"? ',

    'hint.step.1': 'Haz click aqui para comenzar el provisionamiento del dispositivo',
    'hint.step.2': 'Haz click aqui para mostrar el codigo QR',
    'hint.step.3': 'Haz click aqui para ingresar al lector QR del dispositivo',
    'hint.step.4': 'Ingresa una ID disponible en la pestaña «Dispositivos». Haz click en «Recargar» para incluirla en el codigo QR.',

    'ie.browser.notice.1': 'Desafortunadamente, Internet Explorer no es soportado.',
    'ie.browser.notice.2': 'Recomendamos el explorador web - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop">Chrome</a>.',

    'form.resolved.duplicate.pkg.text1': 'ID del paquete "${pkg}" ya esta siendo usada.',
    'form.resolved.duplicate.pkg.text2': 'Deseas añadir una nueva aplicacion o una nueva version de la aplicacion?',
    'form.resolved.duplicate.pkg.text3': 'Nueva version para',
    'form.resolved.duplicate.pkg.text4': 'Las aplicaciones ${apps} ya utilizan el ID de paquete "${pkg}"',
    'form.resolved.duplicate.pkg.text5': '¿Está seguro de que desea cambiar el ID del paquete?',

    'tooltip.usage.byconfigurations': 'Usada por configuraciónes',
    'tooltip.usage.byapps': 'Usada por aplicaciones',
    'tooltip.usage.byicons': 'Usada por inconos',

    'form.devices.label.params.more': 'Mas parametros',
    'form.devices.label.params.less': 'Menos parametros',
    'form.devices.label.installation.status': 'Estado de Instalación',
    "format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
    "format.devices.date.datePicker": "dd-MM-yyyy",
    'form.devices.fast.search': 'Búsqueda rápida por número',

    'form.devices.selection.install.status.default': 'Estado de instalación ...',
    'form.devices.selection.install.status.all': 'Todos',
    'form.devices.selection.install.status.success': 'Satisfactorio',
    'form.devices.selection.install.status.version.mismatch': 'Error de Version',
    'form.devices.selection.install.status.failure': 'Fallo',
    'form.devices.selection.imei.changed': 'IMEI cambio recientemente',

    'search.placeholder.launcher.version': 'Version del Launcher',
    'error.date.range.invalid': 'Rango de fechas invalido',

    'form.selection.status.any': 'Algún valor',
    'form.selection.status.all': 'Todos',
    'form.selection.status.yes': 'Sí',
    'form.selection.status.no': 'No',

    'form.devices.selection.status': 'Estado ...',
    'form.devices.selection.online': 'En línea',
    'form.devices.selection.offline': 'Desconectado',
    'form.devices.selection.number': 'Ingrese un numero',

    'form.devices.selection.online.status.custom': 'Ingrese la hora',
    'form.devices.selection.online.status.1': '15 minutos',
    'form.devices.selection.online.status.2': '30 minutos',
    'form.devices.selection.online.status.3': '1 hora',
    'form.devices.selection.online.status.4': '2 horas',
    'form.devices.selection.online.status.5': '6 horas',
    'form.devices.selection.online.status.6': '1 día',
    'form.devices.selection.online.status.7': '2 días',
    'form.devices.selection.online.status.8': '3 días',
    'form.devices.selection.online.status.9': '1 semana',
    'form.devices.selection.online.status.10': '1 mes',

    'form.devices.selection.online.status.label': 'minuto(s)',
    'form.devices.status.ago': 'atrás',
    'form.devices.status.minutes': 'm',
    'form.devices.status.hours': 'h',
    'form.devices.status.days': 'd',
    'form.devices.status.weeks': 's',
    'form.devices.status.months': 'mes',
    'form.devices.status.years': 'a',

    'customer.type.demo': 'Demo',
    'customer.type.small': 'Profesional',
    'customer.type.corporate': 'Empresa',
    'customer.type.master': 'Primaria',

    'customer.type.options.all': 'Todos los tipos',
    'customer.status.options.all': 'Todos los estados',

    'account.expiring': 'Su cuenta caducará en $ {days} días. Comuníquese con el vendedor para renovar su cuenta.',
    'account.expired': 'Su cuenta ha caducado. Comuníquese con el vendedor para renovar su cuenta.',
    'account.expired.short': 'Su cuenta ha caducado.',
    'device.limit.achieved': 'No se puede agregar un dispositivo porque alcanzó su límite. Quite algunos dispositivos o comuníquese con el vendedor para ampliar el límite de dispositivos.',

    'menu.updates': 'Buscar actualizaciones',
    'updates.title': 'Actualizaciones',
    'updates.disabled.custom': 'Versión personalizada, actualice manualmente',
    'updates.disabled.not_master': 'Pídale al proveedor de alojamiento que actualice',
    'updates.disabled.multiple': 'Múltiples versiones de la aplicación, actualice manualmente',
    'updates.disabled.error': 'Error interno del servidor',
    'updates.disabled.download': 'Error al descargar una actualización',
    'updates.application': 'Aplicación',
    'updates.current.version': 'Versión actual',
    'updates.available.version': 'Versión disponible',
    'updates.downloaded': 'Descargado',
    'updates.auto.update': 'Actualiza automáticamente las aplicaciones móviles (¡utilízalo con cuidado en producción!)',
    'updates.enable.stats': 'Enviar estadísticas de uso al proveedor de servicios para mejorar el rendimiento del sistema',
    'updates.get': 'Obtener actualizaciones',
    'updates.checking': 'Buscando actualizaciones...',
    'updates.getting': 'Obteniendo actualizaciones...',
    'updates.success': 'Actualización completada',
    'updates.web.hint': 'Para completar la actualización de la aplicación web, ejecute el script de shell /opt/hmdm/update-web-app.sh en la consola SSH',

    'permission.edit_device_app_settings': 'Administrar la configuración de la aplicación específica del dispositivo',
    'permission.plugins_customer_access_management': 'Administrar los complementos disponibles',
    'permission.plugin_audit_access': 'Ver el registro de auditoría',
    'permission.plugin_contacts_access': 'Administrar contactos',
    'permission.plugin_deviceexport_access': 'Exportar dispositivos',
    'permission.plugin_deviceimport_access': 'Importar dispositivos',
    'permission.plugin_deviceinfo_access': 'Ver información detallada del dispositivo',
    'permission.plugin_devicelocations_access': 'Ver dispositivos en el mapa',
    'permission.plugin_devicelocations_settings_access': 'Configurar el complemento del mapa',
    'permission.plugin_devicelog_access': 'Ver dispositivo logs',
    'permission.plugin_devicereset_access': 'Restablecer y reiniciar dispositivos',
    'permission.plugin_licensing_access': 'Acceso a la licencia (obsoleto)',
    'permission.plugin_messaging_send': 'Enviar mensajes',
    'permission.plugin_messaging_delete': 'Eliminar mensajes enviados',
    'permission.plugin_photo_remove_photo': 'Eliminar fotos',
    'permission.settings': 'Administrar configuraciones',
    'permission.configurations': 'Ver configuraciones',
    'permission.edit_devices': 'Editar información del dispositivo',
    'permission.edit_device_desc': 'Editar descripción del dispositivo',
    'permission.enroll_devices': 'Inscribir dispositivos mediante código QR',
    'permission.plugin_apuppet_access': 'Control remoto',
    'permission.plugin_knox_access': 'Knox plugin',
    'permission.add_config': 'Agregar configuraciones',
    'permission.copy_config': 'Configuraciones duplicadas',
    'permission.plugin_openvpn_access': 'Plugin de OpenVPN',
    'permission.plugin_photo_access': 'Plugin de fotos',
    'permission.push_api': 'Acceso a Push API',
    'permission.plugin_urlfilter_access': 'Filtrado de URL',
    'permission.plugin_push_send': 'Enviar mensajes Push',
    'permission.plugin_push_delete': 'Eliminar mensajes Push',
    'permission.get_updates': 'Buscar actualizaciones',
    'permission.plugin_xtra_access': 'Solicitar versión Premium',
    'permission.applications': 'Ver aplicaciones',
    'permission.edit_applications': 'Administrar aplicaciones',
    'permission.edit_application_versions': 'Administrar versiones de la aplicación',
    'permission.files': 'Ver archivos',
    'permission.edit_files': 'Administrar archivos',

    'yes': 'si',
    'no': 'no'
};
