/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.task;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.UploadedFile;
import com.hmdm.persistence.mapper.ConfigurationFileMapper;
import com.hmdm.persistence.mapper.UploadedFileMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMigrateTask
implements Runnable {
    private final ConfigurationFileMapper mapper;
    private final UploadedFileMapper uploadedFileMapper;
    private final UnsecureDAO unsecureDAO;
    private final String filesDirectory;
    private static final Logger logger = LoggerFactory.getLogger(FileMigrateTask.class);

    @Inject
    public FileMigrateTask(ConfigurationFileMapper configurationFileMapper, UploadedFileMapper uploadedFileMapper, UnsecureDAO unsecureDAO, @Named(value="files.directory") String filesDirectory) {
        this.mapper = configurationFileMapper;
        this.uploadedFileMapper = uploadedFileMapper;
        this.unsecureDAO = unsecureDAO;
        this.filesDirectory = filesDirectory;
    }

    @Override
    public void run() {
        this.migrateConfigFiles();
        this.deleteOrphanedDuplicates();
    }

    private void migrateConfigFiles() {
        try {
            boolean isSingleCustomer = this.unsecureDAO.isSingleCustomer();
            Path rootDir = Paths.get(this.filesDirectory, new String[0]);
            List oldFiles = this.mapper.getOldStyleConfigurationFiles();
            oldFiles.forEach(cf -> {
                logger.info("Migrating config file: id=" + cf.getId() + ", filePath=" + cf.getFilePath() + ", URL=" + cf.getExternalUrl());
                Configuration configuration = this.unsecureDAO.getConfigurationById(Integer.valueOf(cf.getConfigurationId()));
                if (configuration == null) {
                    logger.info("Configuration = null, deleting");
                    this.mapper.deleteConfigurationFile(cf.getId());
                    return;
                }
                Customer customer = this.unsecureDAO.getCustomerByIdUnsecure(Integer.valueOf(configuration.getCustomerId()));
                if (customer == null) {
                    logger.info("Customer = null, deleting");
                    this.mapper.deleteConfigurationFile(cf.getId());
                    return;
                }
                int duplicateFileId = 0;
                if (cf.getFileId() != null) {
                    UploadedFile file = this.uploadedFileMapper.findById(cf.getFileId());
                    if (file == null) {
                        logger.info("File = null (id=" + cf.getFileId() + "), deleting");
                        this.mapper.deleteConfigurationFile(cf.getId());
                        return;
                    }
                    file.setDescription(cf.getDescription());
                    file.setFilePath(cf.getFilePath());
                    file.setDevicePath(cf.getDevicePath());
                    file.setExternal(false);
                    file.setExternalUrl(null);
                    file.setReplaceVariables(cf.isReplaceVariables());
                    Path customerDir = isSingleCustomer ? rootDir : Paths.get(this.filesDirectory, customer.getFilesDir());
                    Path filePath = Paths.get(customerDir.toString(), cf.getFilePath());
                    if (Files.isRegularFile(filePath, new LinkOption[0])) {
                        try {
                            BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                            FileTime modificationTime = attrs.lastModifiedTime();
                            long millis = modificationTime.toMillis();
                            file.setUploadTime(Long.valueOf(millis));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            logger.info("Exception " + e.getMessage() + ", deleting");
                            this.mapper.deleteConfigurationFile(cf.getId());
                            return;
                        }
                    } else if (!cf.isRemove()) {
                        logger.info("File deleted, deleting");
                        this.mapper.deleteConfigurationFile(cf.getId());
                        return;
                    }
                    UploadedFile sameFile = this.uploadedFileMapper.findSame(customer.getId(), file.getDescription(), file.getFilePath(), file.getDevicePath(), file.isExternal(), file.getExternalUrl(), file.isReplaceVariables());
                    if (sameFile == null) {
                        logger.info("Updating uploaded file with new data");
                        this.uploadedFileMapper.update(file);
                    } else {
                        logger.info("Found duplicate, id=" + sameFile.getId());
                        duplicateFileId = file.getId();
                        cf.setFileId(sameFile.getId());
                    }
                } else {
                    UploadedFile file = new UploadedFile();
                    file.setCustomerId(customer.getId().intValue());
                    file.setDescription(cf.getDescription());
                    file.setUploadTime(Long.valueOf(0L));
                    file.setDevicePath(cf.getDevicePath());
                    file.setExternal(true);
                    file.setExternalUrl(cf.getExternalUrl());
                    file.setReplaceVariables(cf.isReplaceVariables());
                    UploadedFile sameFile = this.uploadedFileMapper.findSame(customer.getId(), file.getDescription(), file.getFilePath(), file.getDevicePath(), file.isExternal(), file.getExternalUrl(), file.isReplaceVariables());
                    if (sameFile == null) {
                        this.uploadedFileMapper.insert(file);
                        logger.info("Uploaded file (external) created, id=" + file.getId());
                        cf.setFileId(file.getId());
                    } else {
                        logger.info("Found duplicate, id=" + sameFile.getId());
                        cf.setFileId(sameFile.getId());
                    }
                }
                cf.setDescription(null);
                cf.setDevicePath(null);
                cf.setExternalUrl(null);
                cf.setFilePath(null);
                cf.setChecksum(null);
                cf.setLastUpdate(Long.valueOf(0L));
                cf.setReplaceVariables(false);
                this.mapper.updateOldStyleConfigurationFile(cf);
                logger.info("Configuration file updated, id=" + cf.getId() + ", fileId=" + cf.getFileId());
                if (duplicateFileId != 0 && this.mapper.countFileUsedAsConfigFile(Integer.valueOf(duplicateFileId)) == 0L) {
                    logger.info("Duplicated file deleted, fileId=" + duplicateFileId);
                    this.uploadedFileMapper.delete(duplicateFileId);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteOrphanedDuplicates() {
        List customers = this.unsecureDAO.getAllCustomersUnsecure();
        for (Customer customer : customers) {
            this.deleteOrphanedDuplicates(customer);
        }
    }

    private void deleteOrphanedDuplicates(Customer customer) {
        List orphans = this.uploadedFileMapper.findOrphaned(customer.getId());
        for (UploadedFile file : orphans) {
            if ((!file.isExternal() || this.uploadedFileMapper.countExternalDuplicates(file.getId(), customer.getId(), file.getExternalUrl()) <= 0L) && (file.isExternal() || this.uploadedFileMapper.countUploadedDuplicates(file.getId(), customer.getId(), file.getFilePath()) <= 0L)) continue;
            logger.info("Orphaned uploaded file has duplicates, deleted, id=" + file.getId());
            this.uploadedFileMapper.delete(file.getId().intValue());
        }
    }
}

