/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.domain.Video;
import com.hmdm.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.poi.util.IOUtils;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Singleton
@Path(value="/videos")
public class VideosResource {
    private String videoDirectory;
    private String baseUrl;

    public VideosResource() {
    }

    @Inject
    public VideosResource(@Named(value="video.directory") String videoDirectory, @Named(value="base.url") String baseUrl) {
        this.videoDirectory = videoDirectory;
        this.baseUrl = baseUrl;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public com.hmdm.rest.json.Response uploadVideo(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws Exception {
        File videoDir = new File(this.videoDirectory);
        if (!videoDir.exists()) {
            videoDir.mkdirs();
        }
        File uploadFile = new File(videoDir.getAbsolutePath(), fileDetail.getFileName());
        FileUtil.writeToFile((InputStream)uploadedInputStream, (String)uploadFile.getAbsolutePath());
        Video video = new Video();
        video.setPath(String.format("%s/rest/public/videos/%s", this.baseUrl, URLEncoder.encode(fileDetail.getFileName(), "UTF8")));
        return com.hmdm.rest.json.Response.OK((Object)video);
    }

    @GET
    @Path(value="/{fileName}")
    @Produces(value={"application/octet-stream"})
    public Response downloadVideo(@PathParam(value="fileName") String fileName) throws Exception {
        File videoFile;
        File videoDir = new File(this.videoDirectory);
        if (!videoDir.exists()) {
            videoDir.mkdirs();
        }
        if (!(videoFile = new File(videoDir, URLDecoder.decode(fileName, "UTF8"))).exists()) {
            return Response.status((int)404).build();
        }
        ContentDisposition contentDisposition = ContentDisposition.type((String)"attachment").fileName(videoFile.getName()).creationDate(new Date()).build();
        return Response.ok(output -> {
            try {
                FileInputStream input = new FileInputStream(videoFile);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                output.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).header("Content-Disposition", (Object)contentDisposition).build();
    }
}

