/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.hmdm.event.DeviceBatteryLevelUpdatedEvent;
import com.hmdm.event.DeviceInfoUpdatedEvent;
import com.hmdm.event.DeviceLocationUpdatedEvent;
import com.hmdm.event.Event;
import com.hmdm.event.EventService;
import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.DeviceDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.ApplicationSetting;
import com.hmdm.persistence.domain.ApplicationSettingType;
import com.hmdm.persistence.domain.ApplicationVersion;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.Device;
import com.hmdm.persistence.domain.Settings;
import com.hmdm.rest.filter.BaseIPFilter;
import com.hmdm.rest.json.DeviceCreateOptions;
import com.hmdm.rest.json.DeviceInfo;
import com.hmdm.rest.json.DeviceLocation;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.SyncApplicationSetting;
import com.hmdm.rest.json.SyncConfigurationFile;
import com.hmdm.rest.json.SyncResponse;
import com.hmdm.rest.json.SyncResponseHook;
import com.hmdm.rest.json.SyncResponseInt;
import com.hmdm.security.SecurityContext;
import com.hmdm.util.CryptoUtil;
import com.hmdm.util.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@Path(value="/public/sync")
@Api(tags={"Device data synchronization"})
public class SyncResource {
    private static final Logger logger = LoggerFactory.getLogger(SyncResource.class);
    private UnsecureDAO unsecureDAO;
    private DeviceDAO deviceDAO;
    private CustomerDAO customerDAO;
    private EventService eventService;
    private Set<SyncResponseHook> syncResponseHooks;
    private String baseUrl;
    private BaseIPFilter remoteAddrResolver;
    private boolean secureEnrollment;
    private String hashSecret;
    private boolean preventDuplicateEnrollment;
    private static final String HEADER_IP_ADDRESS = "X-IP-Address";
    private static final String HEADER_CPU_ARCH = "X-CPU-Arch";
    private static final String HEADER_ENROLLMENT_SIGNATURE = "X-Request-Signature";
    private static final String HEADER_RESPONSE_SIGNATURE = "X-Response-Signature";
    private String mobileAppName;
    private String vendor;
    private static final Function<ApplicationSetting, String> appSettingMapKeyGenerator = s -> s.getApplicationId() + "," + s.getName();

    public SyncResource() {
    }

    @Inject
    public SyncResource(UnsecureDAO unsecureDAO, EventService eventService, Injector injector, CustomerDAO customerDAO, DeviceDAO deviceDAO, @Named(value="base.url") String baseUrl, @Named(value="secure.enrollment") boolean secureEnrollment, @Named(value="hash.secret") String hashSecret, @Named(value="prevent.duplicate.enrollment") boolean preventDuplicateEnrollment, @Named(value="rebranding.mobile.name") String mobileAppName, @Named(value="rebranding.vendor.name") String vendor, @Named(value="proxy.addresses") String proxyIps, @Named(value="proxy.ip.header") String ipHeader) {
        this.unsecureDAO = unsecureDAO;
        this.eventService = eventService;
        this.customerDAO = customerDAO;
        this.deviceDAO = deviceDAO;
        this.baseUrl = baseUrl;
        this.secureEnrollment = secureEnrollment;
        this.hashSecret = hashSecret;
        this.preventDuplicateEnrollment = preventDuplicateEnrollment;
        this.mobileAppName = mobileAppName;
        this.vendor = vendor;
        this.remoteAddrResolver = new BaseIPFilter("", proxyIps, ipHeader);
        HashSet<SyncResponseHook> allYourInterfaces = new HashSet<SyncResponseHook>();
        for (Key key : injector.getAllBindings().keySet()) {
            if (!SyncResponseHook.class.isAssignableFrom(key.getTypeLiteral().getRawType())) continue;
            SyncResponseHook yourInterface = (SyncResponseHook)injector.getInstance(key);
            allYourInterfaces.add(yourInterface);
        }
        this.syncResponseHooks = allYourInterfaces;
    }

    @ApiOperation(value="Get device settings", notes="Gets the device info and settings from the MDM server.", response=SyncResponse.class)
    @POST
    @Path(value="/configuration/{deviceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response enrollDevice(DeviceCreateOptions createOptions, @PathParam(value="deviceId") @ApiParam(value="An identifier of device within MDM server") String number, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        logger.debug("/public/sync/configuration/{}", (Object)number);
        if (this.secureEnrollment && !CryptoUtil.checkRequestSignature((String)request.getHeader("X-Request-Signature"), (String)(this.hashSecret + number))) {
            logger.warn("Failed to setup device {}: signature mismatch", (Object)number);
            return Response.PERMISSION_DENIED();
        }
        try {
            Device dbDevice = this.unsecureDAO.getDeviceByNumber(number);
            boolean migration = false;
            boolean foundByImeiOrSerial = false;
            if (dbDevice == null) {
                dbDevice = this.unsecureDAO.getDeviceByOldNumber(number);
                boolean bl = migration = dbDevice != null;
            }
            if (dbDevice == null) {
                dbDevice = this.unsecureDAO.getDeviceByImeiOrSerial(number);
                boolean bl = foundByImeiOrSerial = dbDevice != null;
                if (foundByImeiOrSerial) {
                    logger.info("IMEI/Serial {}: assigned existing number: {}", (Object)number, (Object)dbDevice.getNumber());
                }
            }
            if (dbDevice == null) {
                logger.info("Creating device {} with options {}", (Object)number, (Object)createOptions.toString());
                dbDevice = this.unsecureDAO.createNewDeviceOnDemand(number, createOptions);
            }
            if (dbDevice != null) {
                if (this.preventDuplicateEnrollment && dbDevice.getLastUpdate() != 0L) {
                    logger.warn("Device {} already enrolled. To enroll, delete device from the list and add back", (Object)dbDevice.getNumber());
                    return Response.DEVICE_EXISTS();
                }
                return this.getDeviceSettingInternal(dbDevice, migration, foundByImeiOrSerial, request, response);
            }
            logger.warn("Requested device {} was not found", (Object)number);
            return Response.DEVICE_NOT_FOUND_ERROR();
        }
        catch (Exception e) {
            logger.error("Unexpected error when getting device settings", (Throwable)e);
            e.printStackTrace();
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Get device settings", notes="Gets the device info and settings from the MDM server.", response=SyncResponse.class)
    @GET
    @Path(value="/configuration/{deviceId}")
    @Produces(value={"application/json"})
    public Response getDeviceSetting(@PathParam(value="deviceId") @ApiParam(value="An identifier of device within MDM server") String number, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        logger.debug("/public/sync/configuration/{}", (Object)number);
        if (this.secureEnrollment && !CryptoUtil.checkRequestSignature((String)request.getHeader("X-Request-Signature"), (String)(this.hashSecret + number))) {
            logger.warn("Failed to setup device {}: signature mismatch", (Object)number);
            return Response.PERMISSION_DENIED();
        }
        try {
            Device dbDevice = this.unsecureDAO.getDeviceByNumber(number);
            boolean migration = false;
            boolean foundByImeiOrSerial = false;
            if (dbDevice == null) {
                dbDevice = this.unsecureDAO.getDeviceByOldNumber(number);
                boolean bl = migration = dbDevice != null;
            }
            if (dbDevice == null) {
                dbDevice = this.unsecureDAO.getDeviceByImeiOrSerial(number);
                boolean bl = foundByImeiOrSerial = dbDevice != null;
                if (foundByImeiOrSerial) {
                    logger.info("IMEI/Serial {}: assigned existing number: {}", (Object)number, (Object)dbDevice.getNumber());
                }
            }
            if (dbDevice == null) {
                if (this.unsecureDAO.isSingleCustomer()) {
                    dbDevice = this.unsecureDAO.createNewDeviceOnDemand(number);
                } else {
                    logger.warn("Not allowed to create devices in the multi-tenant setup");
                }
            }
            if (dbDevice != null) {
                return this.getDeviceSettingInternal(dbDevice, migration, foundByImeiOrSerial, request, response);
            }
            logger.warn("Requested device {} was not found", (Object)number);
            return Response.DEVICE_NOT_FOUND_ERROR();
        }
        catch (Exception e) {
            logger.error("Unexpected error when getting device settings", (Throwable)e);
            e.printStackTrace();
            return Response.INTERNAL_ERROR();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getDeviceSettingInternal(Device dbDevice, boolean migration, boolean foundByImeiOrSerial, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        ApplicationVersion applicationVersion;
        Integer contentAppId;
        if (!migration && dbDevice.getOldNumber() != null) {
            this.unsecureDAO.completeDeviceMigration(dbDevice.getId());
            dbDevice.setOldNumber(null);
        }
        Customer customer = this.customerDAO.findById(dbDevice.getCustomerId());
        String cpuArch = request.getHeader("X-CPU-Arch");
        if (cpuArch == null) {
            cpuArch = "arm64";
        } else {
            int i = cpuArch.indexOf(45);
            if (i != -1) {
                cpuArch = cpuArch.substring(0, i);
            }
        }
        Settings settings = this.unsecureDAO.getSettings(dbDevice.getCustomerId());
        List applications = this.unsecureDAO.getPlainConfigurationApplications(Integer.valueOf(dbDevice.getCustomerId()), dbDevice.getConfigurationId());
        for (Application app : applications) {
            String icon = app.getIcon();
            if (icon != null && !icon.trim().isEmpty()) {
                String iconUrl = FileUtil.createFileUrl((String)this.baseUrl, (String)URLEncoder.encode(customer.getFilesDir(), "UTF8"), (String)URLEncoder.encode(icon, "UTF8"));
                app.setIcon(iconUrl);
            }
            if (!app.isSplit()) continue;
            if (cpuArch.equals("arm64")) {
                app.setUrl(app.getUrlArm64());
                continue;
            }
            if (!cpuArch.equals("armeabi")) continue;
            app.setUrl(app.getUrlArmeabi());
        }
        Configuration configuration = this.unsecureDAO.getConfigurationByIdWithAppSettings(dbDevice.getConfigurationId());
        SyncResponse data = configuration.isUseDefaultDesignSettings() ? new SyncResponse(settings, configuration.getPassword(), applications, dbDevice) : new SyncResponse(configuration, applications, dbDevice);
        data.setGps(configuration.getGps());
        data.setBluetooth(configuration.getBluetooth());
        data.setWifi(configuration.getWifi());
        data.setMobileData(configuration.getMobileData());
        data.setUsbStorage(configuration.getUsbStorage());
        data.setLockStatusBar(configuration.isBlockStatusBar());
        data.setSystemUpdateType(configuration.getSystemUpdateType());
        data.setRequestUpdates(configuration.getRequestUpdates().getTransmittedValue());
        data.setDisableLocation(configuration.getDisableLocation());
        data.setAppPermissions(configuration.getAppPermissions().getTransmittedValue());
        data.setPushOptions(configuration.getPushOptions());
        data.setKeepaliveTime(configuration.getKeepaliveTime());
        data.setAutoBrightness(configuration.getAutoBrightness());
        if (data.getAutoBrightness() != null && !data.getAutoBrightness().booleanValue()) {
            data.setBrightness(configuration.getBrightness());
        }
        data.setManageTimeout(configuration.getManageTimeout() == null || configuration.getManageTimeout() == false ? null : Boolean.valueOf(true));
        if (data.getManageTimeout() != null && data.getManageTimeout().booleanValue()) {
            data.setTimeout(configuration.getTimeout());
        }
        data.setLockVolume(configuration.getLockVolume());
        data.setManageVolume(configuration.getManageVolume() == null || configuration.getManageVolume() == false ? null : Boolean.valueOf(true));
        if (data.getManageVolume() != null && data.getManageVolume().booleanValue()) {
            data.setVolume(configuration.getVolume());
        }
        if (configuration.getSystemUpdateType() == 2) {
            data.setSystemUpdateFrom(configuration.getSystemUpdateFrom());
            data.setSystemUpdateTo(configuration.getSystemUpdateTo());
        }
        if (configuration.isScheduleAppUpdate()) {
            data.setScheduleAppUpdate(Boolean.valueOf(true));
            data.setAppUpdateFrom(configuration.getAppUpdateFrom());
            data.setAppUpdateTo(configuration.getAppUpdateTo());
        }
        data.setDownloadUpdates(configuration.getDownloadUpdates().getTransmittedValue());
        data.setPasswordMode(configuration.getPasswordMode());
        data.setOrientation(configuration.getOrientation());
        data.setDisplayStatus(configuration.isDisplayStatus() ? Boolean.valueOf(true) : null);
        data.setRunDefaultLauncher(configuration.getRunDefaultLauncher());
        data.setDisableScreenshots(configuration.getDisableScreenshots());
        data.setAutostartForeground(configuration.getAutostartForeground());
        data.setTimeZone(configuration.getTimeZone());
        data.setAllowedClasses(configuration.getAllowedClasses());
        data.setNewServerUrl(configuration.getNewServerUrl());
        data.setLockSafeSettings(configuration.getLockSafeSettings());
        data.setPermissive(configuration.getPermissive());
        data.setKioskExit(configuration.getKioskExit());
        data.setShowWifi(configuration.getShowWifi());
        data.setKioskMode(configuration.isKioskMode());
        if (data.isKioskMode() && (contentAppId = configuration.getContentAppId()) != null && (applicationVersion = this.unsecureDAO.findApplicationVersionById(contentAppId)) != null) {
            Application application = this.unsecureDAO.findApplicationById(applicationVersion.getApplicationId());
            data.setMainApp(application.getPkg());
        }
        data.setKioskHome(configuration.getKioskHome() != null && configuration.getKioskHome() != false ? Boolean.valueOf(true) : null);
        data.setKioskRecents(configuration.getKioskRecents() != null && configuration.getKioskRecents() != false ? Boolean.valueOf(true) : null);
        data.setKioskNotifications(configuration.getKioskNotifications() != null && configuration.getKioskNotifications() != false ? Boolean.valueOf(true) : null);
        data.setKioskSystemInfo(configuration.getKioskSystemInfo() != null && configuration.getKioskSystemInfo() != false ? Boolean.valueOf(true) : null);
        data.setKioskKeyguard(configuration.getKioskKeyguard() != null && configuration.getKioskKeyguard() != false ? Boolean.valueOf(true) : null);
        data.setKioskLockButtons(configuration.getKioskLockButtons() != null && configuration.getKioskLockButtons() != false ? Boolean.valueOf(true) : null);
        data.setKioskScreenOn(configuration.getKioskScreenOn() != null && configuration.getKioskScreenOn() != false ? Boolean.valueOf(true) : null);
        data.setRestrictions(configuration.getRestrictions());
        if (settings != null) {
            if (settings.isCustomSend1()) {
                data.setCustom1(dbDevice.getCustom1());
            }
            if (settings.isCustomSend2()) {
                data.setCustom2(dbDevice.getCustom2());
            }
            if (settings.isCustomSend3()) {
                data.setCustom3(dbDevice.getCustom3());
            }
            if (settings.isSendDescription()) {
                data.setDescription(dbDevice.getDescription());
            }
        }
        List deviceAppSettings = this.unsecureDAO.getDeviceAppSettings(dbDevice.getId().intValue());
        List configApplicationSettings = configuration.getApplicationSettings();
        List applicationSettings = SyncResource.combineDeviceLogRules((List)configApplicationSettings, (List)deviceAppSettings);
        Device dbDevice1 = dbDevice;
        data.setApplicationSettings(applicationSettings.stream().map(s -> {
            SyncApplicationSetting syncSetting = new SyncApplicationSetting();
            syncSetting.setPackageId(s.getApplicationPkg());
            syncSetting.setName(s.getName());
            syncSetting.setType(s.getType().getId());
            syncSetting.setReadonly(s.isReadonly());
            syncSetting.setValue(s.getValueForDevice(dbDevice1));
            syncSetting.setLastUpdate(s.getLastUpdate());
            return syncSetting;
        }).collect(Collectors.toList()));
        List configurationFiles = this.unsecureDAO.getConfigurationFiles(dbDevice);
        configurationFiles.forEach(file -> {
            if (file.getExternalUrl() != null) {
                file.setUrl(file.getExternalUrl());
            } else if (file.getFilePath() != null) {
                String url = FileUtil.createFileUrl((String)this.baseUrl, (String)customer.getFilesDir(), (String)file.getFilePath());
                file.setUrl(url);
            }
        });
        configurationFiles.removeIf(file -> {
            if (file.getDevicePath() == null) {
                logger.warn("ConfigurationFile id " + file.getId() + ": devicePath=null, skipping for safety purposes");
                return true;
            }
            if (!file.isRemove() && file.getUrl() == null) {
                logger.warn("ConfigurationFile id " + file.getId() + ": url=null and not marked to remove, skipping for safety purposes");
                return true;
            }
            return false;
        });
        data.setFiles(configurationFiles.stream().map(SyncConfigurationFile::new).collect(Collectors.toList()));
        if (!this.mobileAppName.equals("")) {
            data.setAppName(this.mobileAppName);
        }
        if (!this.vendor.equals("")) {
            data.setVendor(this.vendor);
        }
        if (foundByImeiOrSerial) {
            data.setNewNumber(dbDevice.getNumber());
        }
        SyncResponse syncResponse = data;
        SecurityContext.init((Integer)dbDevice.getCustomerId());
        try {
            if (this.syncResponseHooks != null && !this.syncResponseHooks.isEmpty()) {
                for (SyncResponseHook hook : this.syncResponseHooks) {
                    syncResponse = hook.handle(dbDevice.getId().intValue(), (SyncResponseInt)syncResponse);
                }
            }
        }
        finally {
            SecurityContext.release();
        }
        response.setHeader("X-IP-Address", this.remoteAddrResolver.getRemoteAddr(request));
        response.setHeader("X-Response-Signature", CryptoUtil.getDataSignature((String)this.hashSecret, (Object)syncResponse));
        return Response.OK((Object)syncResponse);
    }

    @ApiOperation(value="Update device info", notes="Updates the device info on the MDM server.", response=Response.class)
    @POST
    @Path(value="/info")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateDeviceInfo(DeviceInfo deviceInfo, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        logger.debug("/public/sync/info --> {}", (Object)deviceInfo);
        try {
            Device dbDevice = this.unsecureDAO.getDeviceByNumber(deviceInfo.getDeviceId());
            boolean migration = false;
            if (dbDevice == null) {
                dbDevice = this.unsecureDAO.getDeviceByOldNumber(deviceInfo.getDeviceId());
                boolean bl = migration = dbDevice != null;
            }
            if (dbDevice == null) {
                if (this.unsecureDAO.isSingleCustomer()) {
                    dbDevice = this.unsecureDAO.createNewDeviceOnDemand(deviceInfo.getDeviceId());
                } else {
                    logger.warn("Not allowed to create devices in the multi-tenant setup");
                }
            }
            if (dbDevice != null) {
                DeviceLocation location;
                if (!migration && dbDevice.getOldNumber() != null) {
                    this.unsecureDAO.completeDeviceMigration(dbDevice.getId());
                    dbDevice.setOldNumber(null);
                }
                ObjectMapper objectMapper = new ObjectMapper();
                DeviceInfo prevInfo = null;
                try {
                    prevInfo = (DeviceInfo)objectMapper.readValue(dbDevice.getInfo(), DeviceInfo.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (prevInfo != null && prevInfo.getImei() != null && deviceInfo.getImei() != null && !prevInfo.getImei().equals(deviceInfo.getImei())) {
                    dbDevice.setImeiUpdateTs(Long.valueOf(System.currentTimeMillis()));
                }
                this.unsecureDAO.updateDeviceInfo(dbDevice.getId(), objectMapper.writeValueAsString((Object)deviceInfo), dbDevice.getImeiUpdateTs(), this.remoteAddrResolver.getRemoteAddr(request));
                boolean needUpdate = false;
                if (deviceInfo.getCustom1() != null) {
                    dbDevice.setCustom1(deviceInfo.getCustom1());
                    needUpdate = true;
                }
                if (deviceInfo.getCustom2() != null) {
                    dbDevice.setCustom2(deviceInfo.getCustom2());
                    needUpdate = true;
                }
                if (deviceInfo.getCustom3() != null) {
                    dbDevice.setCustom3(deviceInfo.getCustom3());
                    needUpdate = true;
                }
                if (needUpdate) {
                    this.unsecureDAO.updateDeviceCustomProperties(dbDevice.getId(), dbDevice);
                }
                if (deviceInfo.getBatteryLevel() != null) {
                    this.eventService.fireEvent((Event)new DeviceBatteryLevelUpdatedEvent(dbDevice.getId().intValue(), deviceInfo.getBatteryLevel().intValue()));
                }
                if ((location = deviceInfo.getLocation()) != null) {
                    LinkedList<DeviceLocation> locations = new LinkedList<DeviceLocation>();
                    locations.add(deviceInfo.getLocation());
                    this.eventService.fireEvent((Event)new DeviceLocationUpdatedEvent(dbDevice.getId().intValue(), locations, false));
                }
                this.eventService.fireEvent((Event)new DeviceInfoUpdatedEvent(dbDevice.getId().intValue()));
                response.setHeader("X-IP-Address", this.remoteAddrResolver.getRemoteAddr(request));
                return Response.OK();
            }
            logger.warn("Requested device {} was not found", (Object)deviceInfo.getDeviceId());
            return Response.DEVICE_NOT_FOUND_ERROR();
        }
        catch (Exception e) {
            logger.error("Unexpected error when processing info submitted by device", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Save application settings", notes="Saves the application settings for the device on the MDM server.", response=Response.class)
    @POST
    @Path(value="/applicationSettings/{deviceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveApplicationSettings(@PathParam(value="deviceId") @ApiParam(value="An identifier of device within MDM server") String deviceNumber, List<SyncApplicationSetting> applicationSettings) {
        logger.debug("/public/sync/applicationSettings/{} --> {}", (Object)deviceNumber, applicationSettings);
        try {
            Device dbDevice = this.unsecureDAO.getDeviceByNumber(deviceNumber);
            if (dbDevice != null) {
                this.unsecureDAO.saveDeviceApplicationSettings(dbDevice, applicationSettings.stream().map(s -> {
                    ApplicationSetting applicationSetting = new ApplicationSetting();
                    applicationSetting.setApplicationPkg(s.getPackageId());
                    applicationSetting.setName(s.getName());
                    applicationSetting.setType(ApplicationSettingType.byId((int)s.getType()).orElse(ApplicationSettingType.STRING));
                    applicationSetting.setReadonly(s.isReadonly().booleanValue());
                    applicationSetting.setValue(s.getValue());
                    applicationSetting.setLastUpdate(s.getLastUpdate());
                    return applicationSetting;
                }).collect(Collectors.toList()));
                return Response.OK();
            }
            logger.warn("Requested device {} was not found", (Object)deviceNumber);
            return Response.DEVICE_NOT_FOUND_ERROR();
        }
        catch (Exception e) {
            logger.error("Unexpected error when saving device application settings for device {}", (Object)deviceNumber, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    private static List<ApplicationSetting> combineDeviceLogRules(List<ApplicationSetting> lessPreferred, List<ApplicationSetting> morePreferred) {
        lessPreferred = lessPreferred.stream().filter(s -> s.getValue() != null && !s.getValue().trim().isEmpty()).collect(Collectors.toList());
        morePreferred = morePreferred.stream().filter(s -> s.getValue() != null && !s.getValue().trim().isEmpty()).collect(Collectors.toList());
        Map moreMapping = morePreferred.stream().collect(Collectors.toMap(appSettingMapKeyGenerator, r -> r));
        ArrayList<ApplicationSetting> result = new ArrayList<ApplicationSetting>();
        lessPreferred.stream().filter(less -> !moreMapping.containsKey(appSettingMapKeyGenerator.apply(less))).forEach(result::add);
        result.addAll(morePreferred);
        return result;
    }
}

