/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CommonDAO;
import com.hmdm.persistence.PendingSignupDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.PendingSignup;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.SignupCompleteRequest;
import com.hmdm.service.EmailService;
import com.hmdm.service.MailchimpService;
import com.hmdm.util.PasswordUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Signup"})
@Singleton
@Path(value="/public/signup")
public class SignupResource {
    private static final Logger logger = LoggerFactory.getLogger(SignupResource.class);
    private String baseUrl;
    private CommonDAO commonDAO;
    private UnsecureDAO unsecureDAO;
    private PendingSignupDAO pendingSignupDAO;
    private EmailService emailService;
    private MailchimpService mailchimpService;
    private String adminEmail;
    private boolean customerSignup;
    private boolean customerSignupCopySettings;
    private Integer[] customerSignupConfigurations;
    private String customerSignupSupportEmail;
    private int customerSignupDeviceLimit;
    private int customerSignupSizeLimit;
    private int customerSignupExpiryDays;
    private int customerSignupDeviceConfig;

    public SignupResource() {
    }

    @Inject
    public SignupResource(CommonDAO commonDAO, UnsecureDAO unsecureDAO, PendingSignupDAO pendingSignupDAO, EmailService emailService, MailchimpService mailchimpService, @Named(value="admin.email") String adminEmail, @Named(value="base.url") String baseUrl, @Named(value="customer.signup") boolean customerSignup, @Named(value="customer.signup.copy.settings") boolean customerSignupCopySettings, @Named(value="customer.signup.configurations") String customerSignupConfigStr, @Named(value="customer.signup.support.email") String customerSignupSupportEmail, @Named(value="customer.signup.device.limit") String customerSignupDeviceLimitStr, @Named(value="customer.signup.size.limit") String customerSignupSizeLimitStr, @Named(value="customer.signup.expiry.days") String customerSignupExpiryDaysStr, @Named(value="customer.signup.device.config") String customerSignupDeviceConfigStr) {
        this.commonDAO = commonDAO;
        this.unsecureDAO = unsecureDAO;
        this.pendingSignupDAO = pendingSignupDAO;
        this.emailService = emailService;
        this.mailchimpService = mailchimpService;
        this.adminEmail = adminEmail;
        this.baseUrl = baseUrl;
        this.customerSignup = customerSignup;
        this.customerSignupCopySettings = customerSignupCopySettings;
        this.customerSignupSupportEmail = customerSignupSupportEmail;
        this.customerSignupDeviceLimit = this.parseInt(customerSignupDeviceLimitStr, 3);
        this.customerSignupSizeLimit = this.parseInt(customerSignupSizeLimitStr, 100);
        this.customerSignupExpiryDays = this.parseInt(customerSignupExpiryDaysStr, 365);
        this.customerSignupDeviceConfig = this.parseInt(customerSignupDeviceConfigStr, 1);
        String[] configIdStrs = customerSignupConfigStr.split(",");
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (String configId : configIdStrs) {
            try {
                Integer n = Integer.parseInt(configId);
                list.add(n);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.customerSignupConfigurations = new Integer[list.size()];
        list.toArray(this.customerSignupConfigurations);
    }

    @ApiOperation(value="Signup feature", notes="Checks if the customer signup is allowed.")
    @GET
    @Deprecated
    @Path(value="/canSignup")
    @Produces(value={"application/json"})
    public Response canSignup() {
        if (this.emailService.isConfigured() && this.customerSignup) {
            return Response.OK();
        }
        return Response.ERROR();
    }

    @ApiOperation(value="Verify email", notes="Check whether the email doesn't exist and start the signup flow")
    @POST
    @Path(value="/verifyEmail")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response verifyEmail(PendingSignup signupData) {
        signupData.setEmail(signupData.getEmail().toLowerCase());
        Customer dbCustomer = this.unsecureDAO.getCustomerByEmailUnsecure(signupData.getEmail());
        if (dbCustomer != null) {
            return Response.DUPLICATE_ENTITY((String)"signup.email.used");
        }
        User dbUser = this.unsecureDAO.findByEmail(signupData.getEmail());
        if (dbUser != null) {
            return Response.DUPLICATE_ENTITY((String)"signup.email.used");
        }
        PendingSignup pendingSignup = this.pendingSignupDAO.getByEmail(signupData.getEmail());
        if (pendingSignup != null && pendingSignup.getSignupTime() != null && pendingSignup.getSignupTime() + 60000L > System.currentTimeMillis()) {
            return Response.DUPLICATE_ENTITY((String)"signup.email.used");
        }
        signupData.setSignupTime(Long.valueOf(System.currentTimeMillis()));
        signupData.setToken(PasswordUtil.generateToken());
        this.pendingSignupDAO.insert(signupData);
        String subj = this.emailService.getVerifyEmailSubj(signupData.getLanguage());
        String body = this.emailService.getVerifyEmailBody(signupData.getLanguage(), signupData.getToken());
        this.emailService.sendEmail(signupData.getEmail(), subj, body);
        return Response.OK();
    }

    @ApiOperation(value="Verify token", notes="Checks if the customer's token is valid.")
    @GET
    @Path(value="/verifyToken/{token}")
    @Produces(value={"application/json"})
    public Response verifyToken(@PathParam(value="token") @ApiParam(value="Customer's token") String token) {
        PendingSignup signup = this.pendingSignupDAO.getByToken(token);
        if (signup == null) {
            return Response.OBJECT_NOT_FOUND_ERROR();
        }
        return Response.OK((Object)signup);
    }

    @ApiOperation(value="Complete the registration", notes="Create a new customer and notify admins and customer itself.")
    @POST
    @Path(value="/complete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response complete(SignupCompleteRequest data) {
        try {
            Object description;
            Customer dbCustomer = this.unsecureDAO.getCustomerByNameUnsecure(data.getName());
            if (dbCustomer != null) {
                return Response.DUPLICATE_ENTITY((String)"error.duplicate.customer.name");
            }
            PendingSignup signup = this.pendingSignupDAO.getByToken(data.getToken());
            if (signup == null) {
                return Response.OBJECT_NOT_FOUND_ERROR();
            }
            Customer customer = new Customer();
            customer.setName(data.getName().trim());
            if (signup.getLanguage().equals("ru")) {
                customer.setLanguage("ru");
            }
            customer.setEmail(signup.getEmail().toLowerCase().trim());
            customer.setFirstName(data.getFirstName().trim());
            customer.setLastName(data.getLastName().trim());
            Object object = description = data.getCompany() != null ? data.getCompany() : "";
            if (data.getDescription() != null && !data.getDescription().trim().equals("")) {
                if (!((String)description).equals("")) {
                    description = (String)description + "\n";
                }
                description = (String)description + data.getDescription().trim();
            }
            customer.setDescription((String)description);
            customer.setCustomerStatus("customer.new");
            customer.setAccountType(0);
            customer.setDeviceLimit(this.customerSignupDeviceLimit);
            customer.setSizeLimit(this.customerSignupSizeLimit);
            customer.setExpiryTime(Long.valueOf(System.currentTimeMillis() + (long)this.customerSignupExpiryDays * 86400000L));
            customer.setConfigurationIds(this.customerSignupConfigurations);
            customer.setDeviceConfigurationId(Integer.valueOf(this.customerSignupDeviceConfig));
            this.unsecureDAO.signupCustomerUnsecure(customer, data.getPasswd(), this.customerSignupCopySettings);
            this.pendingSignupDAO.remove(customer.getEmail());
            this.emailService.sendEmail(customer.getEmail(), this.emailService.getSignupCompleteEmailSubj(customer.getLanguage()), this.emailService.getSignupCompleteEmailBody(customer), this.customerSignupSupportEmail);
            this.emailService.sendEmail(this.adminEmail, this.emailService.getSignupNotifyEmailSubj(), this.emailService.getSignupNotifyEmailBody(customer));
            if (!this.customerSignupSupportEmail.equals("")) {
                this.emailService.sendEmail(this.customerSignupSupportEmail, this.emailService.getSignupNotifyEmailSubj(), this.emailService.getSignupNotifyEmailBody(customer));
            }
            if (this.mailchimpService.initialize()) {
                this.mailchimpService.subscribe(customer, "self_signup");
            }
            return Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error when signing up a customer {}", (Object)data, (Object)e);
            e.printStackTrace();
            return Response.INTERNAL_ERROR();
        }
    }

    private int parseInt(String parameter, int defaultValue) {
        int ret = defaultValue;
        if (parameter != null) {
            try {
                ret = Integer.parseInt(parameter);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }
}

