/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.UserDAO;
import com.hmdm.rest.json.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Hint"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/hints")
public class HintResource {
    private static final Logger logger = LoggerFactory.getLogger(HintResource.class);
    private UserDAO userDAO;

    public HintResource() {
    }

    @Inject
    public HintResource(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @ApiOperation(value="Get shown hints", notes="Gets the list of identifiers for the hints already presented to current user", response=String.class, responseContainer="List")
    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    public Response getShownHints() {
        try {
            List shownHints = this.userDAO.getShownHints();
            return Response.OK((Object)shownHints);
        }
        catch (Exception e) {
            logger.error("Unexpected error while getting the list of hints shown to user", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Enable hints", notes="Enables the hints to be presented to current user", response=Response.class)
    @POST
    @Path(value="/enable")
    @Produces(value={"application/json"})
    public Response enableHints() {
        try {
            this.userDAO.enableHints();
            return Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error while enabling hints for user", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Disable hints", notes="Disables the hints from to be presented to current user", response=Response.class)
    @POST
    @Path(value="/disable")
    @Produces(value={"application/json"})
    public Response disableHints() {
        try {
            this.userDAO.disableHints();
            return Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error while disabling hints for user", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="On hint shown", notes="Marks the hint as shown to current user", response=Response.class)
    @POST
    @Path(value="/history")
    @Produces(value={"application/json"})
    public Response markHintAsShown(String hintKey) {
        try {
            this.userDAO.onHintShown(hintKey);
            return Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error while marking the hint as shown to user", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

