/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hmdm.persistence.ApplicationDAO;
import com.hmdm.rest.filter.PublicIPFilter;
import com.hmdm.util.CryptoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DownloadFilesServlet
extends HttpServlet {
    private final ApplicationDAO applicationDAO;
    private final String filesDirectory;
    private final File baseDirectory;
    private final PublicIPFilter publicIPFilter;
    private boolean secureEnrollment;
    private String hashSecret;
    private static final String HEADER_ENROLLMENT_SIGNATURE = "X-Request-Signature";
    private static final String CONTENT_TYPE_APK = "application/vnd.android.package-archive";
    private static final Logger log = LoggerFactory.getLogger(DownloadFilesServlet.class);

    @Inject
    public DownloadFilesServlet(ApplicationDAO applicationDAO, PublicIPFilter publicIPFilter, @Named(value="files.directory") String filesDirectory, @Named(value="secure.enrollment") boolean secureEnrollment, @Named(value="hash.secret") String hashSecret) {
        this.applicationDAO = applicationDAO;
        this.filesDirectory = filesDirectory;
        this.baseDirectory = new File(filesDirectory);
        this.publicIPFilter = publicIPFilter;
        this.secureEnrollment = secureEnrollment;
        this.hashSecret = hashSecret;
        if (!this.baseDirectory.exists()) {
            this.baseDirectory.mkdirs();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        File file;
        String path = URLDecoder.decode(req.getRequestURI(), "UTF8");
        int index = path.indexOf("/files/", 0) + "/files/".length();
        path = path.substring(index);
        if (!this.publicIPFilter.match((ServletRequest)req)) {
            log.warn("Request blocked by IP: " + req.getRemoteAddr());
            resp.sendError(403);
            return;
        }
        if (this.secureEnrollment && !this.applicationDAO.isMainApp("%" + path)) {
            String signature = req.getHeader(HEADER_ENROLLMENT_SIGNATURE);
            if (signature == null) {
                log.warn("No signature for file request " + req.getRequestURL().toString());
                resp.sendError(403);
                return;
            }
            try {
                String goodSignature = CryptoUtil.getSHA1String((String)(this.hashSecret + path));
                if (!signature.equalsIgnoreCase(goodSignature)) {
                    log.warn("Wrong signature for file request " + path + ": " + signature + " Should be: " + goodSignature);
                    resp.sendError(403);
                    return;
                }
            }
            catch (Exception goodSignature) {
                // empty catch block
            }
        }
        if ((file = new File(String.format("%s/%s", this.filesDirectory, path))).exists()) {
            long modifiedSince = req.getDateHeader("If-Modified-Since");
            if (modifiedSince != -1L && modifiedSince > file.lastModified()) {
                resp.setStatus(304);
                return;
            }
            String range = req.getHeader("Range");
            if (range != null && range.startsWith("bytes=")) {
                this.sendPartialContent(range.substring(6), file, resp);
                return;
            }
            try (FileInputStream input = new FileInputStream(file);
                 ServletOutputStream outputStream = resp.getOutputStream();){
                long length = file.length();
                if (length <= Integer.MAX_VALUE) {
                    resp.setContentLength((int)length);
                } else {
                    resp.addHeader("Content-Length", Long.toString(length));
                }
                if (file.getAbsolutePath().endsWith(".apk")) {
                    resp.setContentType(CONTENT_TYPE_APK);
                }
                IOUtils.copy((InputStream)input, (OutputStream)outputStream);
                outputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Not found: " + file.getAbsolutePath());
            resp.sendError(404);
        }
    }

    private void sendPartialContent(String rangeStr, File file, HttpServletResponse resp) {
        try {
            String[] range = rangeStr.split("-");
            Long start = Long.parseLong(range[0]);
            Long end = null;
            if (range.length > 1) {
                end = Long.parseLong(range[1]);
            }
            FileInputStream input = new FileInputStream(file);
            ServletOutputStream outputStream = resp.getOutputStream();
            long length = file.length();
            if (end == null) {
                end = length;
            }
            resp.setStatus(206);
            resp.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + length);
            long contentLength = end - start;
            if (length <= Integer.MAX_VALUE) {
                resp.setContentLength((int)contentLength);
            } else {
                resp.addHeader("Content-Length", Long.toString(contentLength));
            }
            if (file.getAbsolutePath().endsWith(".apk")) {
                resp.setContentType(CONTENT_TYPE_APK);
            }
            ((InputStream)input).skip(start);
            IOUtils.copy((InputStream)input, (OutputStream)outputStream, (long)contentLength);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

