/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.notification.PushService;
import com.hmdm.persistence.ApplicationDAO;
import com.hmdm.persistence.ConfigurationDAO;
import com.hmdm.persistence.ConfigurationReferenceExistsException;
import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.UserDAO;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.LookupItem;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.UpgradeConfigurationApplicationRequest;
import com.hmdm.security.SecurityContext;
import com.hmdm.util.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Configuration"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/configurations")
public class ConfigurationResource {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationResource.class);
    private ConfigurationDAO configurationDAO;
    private ApplicationDAO applicationDAO;
    private PushService pushService;
    private CustomerDAO customerDAO;
    private UserDAO userDAO;
    private String baseUrl;

    public ConfigurationResource() {
    }

    @Inject
    public ConfigurationResource(ConfigurationDAO configurationDAO, ApplicationDAO applicationDAO, PushService pushService, CustomerDAO customerDAO, UserDAO userDAO, @Named(value="base.url") String baseUrl) {
        this.configurationDAO = configurationDAO;
        this.applicationDAO = applicationDAO;
        this.pushService = pushService;
        this.customerDAO = customerDAO;
        this.userDAO = userDAO;
        this.baseUrl = baseUrl;
    }

    @ApiOperation(value="Get configurations", notes="Gets the list of available configurations", response=Configuration.class, responseContainer="List")
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getAllConfigurations() {
        if (!SecurityContext.get().hasPermission("configurations")) {
            log.error("Unauthorized attempt to access configurations");
            return Response.PERMISSION_DENIED();
        }
        List configurations = this.configurationDAO.getAllConfigurations();
        configurations.forEach(c -> c.setBaseUrl(this.configurationDAO.getBaseUrl()));
        return Response.OK((Object)configurations);
    }

    @ApiOperation(value="Get configuration names", notes="Gets the list of available configuration names", response=LookupItem.class, responseContainer="List")
    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response getAllConfigurationNames() {
        List items = this.configurationDAO.getAllConfigurations().stream().map(configuration -> new LookupItem(configuration.getId().intValue(), configuration.getName())).collect(Collectors.toList());
        return Response.OK(items);
    }

    @ApiOperation(value="Search configurations", notes="Searches configurations meeting the specified filter value", response=Configuration.class, responseContainer="List")
    @GET
    @Path(value="/search/{value}")
    @Produces(value={"application/json"})
    public Response searchConfigurations(@PathParam(value="value") String value) {
        if (!SecurityContext.get().hasPermission("configurations")) {
            log.error("Unauthorized attempt to access configurations");
            return Response.PERMISSION_DENIED();
        }
        List configurations = this.configurationDAO.getAllConfigurationsByValue(value);
        configurations.forEach(c -> c.setBaseUrl(this.configurationDAO.getBaseUrl()));
        return Response.OK((Object)configurations);
    }

    @ApiOperation(value="Get configurations for autocompletions")
    @POST
    @Path(value="/autocomplete")
    @Produces(value={"application/json"})
    public Response getConfigurations(String filter) {
        try {
            List groups = this.configurationDAO.getAllConfigurationsByValue(filter).stream().map(configuration -> new LookupItem(configuration.getId().intValue(), configuration.getName())).collect(Collectors.toList());
            return Response.OK(groups);
        }
        catch (Exception e) {
            log.error("Failed to search the configurations due to unexpected error. Filter: {}", (Object)filter, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Create or update configuration", notes="Creates a new configuration (if id is not provided) or update existing one otherwise.")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateConfiguration(Configuration configuration) {
        if (!SecurityContext.get().hasPermission("configurations")) {
            log.error("Unauthorized attempt to update the configuration " + configuration.getId() + ", user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            Configuration dbConfiguration = this.configurationDAO.getConfigurationByName(configuration.getName());
            Integer id = configuration.getId();
            if (dbConfiguration != null && !dbConfiguration.getId().equals(id)) {
                return Response.DUPLICATE_ENTITY((String)"error.duplicate.configuration");
            }
            if (id == null) {
                if (!SecurityContext.get().hasPermission("add_config")) {
                    log.error("Unauthorized attempt to create the configuration " + configuration.getId());
                    return Response.PERMISSION_DENIED();
                }
                configuration.setDisableLocation(Boolean.valueOf(false));
                this.configurationDAO.insertConfiguration(configuration);
                User user = (User)SecurityContext.get().getCurrentUser().get();
                if (!user.isAllConfigAvailable()) {
                    user.getConfigurations().add(new LookupItem(configuration.getId().intValue(), null));
                    this.userDAO.updateUserMainDetails(user);
                }
            } else {
                log.info("Configuration " + configuration.getName() + " updated by user " + SecurityContext.get().getCurrentUserName());
                this.configurationDAO.updateConfiguration(configuration);
                this.pushService.notifyDevicesOnUpdate(configuration.getId());
            }
            configuration = this.getConfiguration(configuration.getId());
            return Response.OK((Object)configuration);
        }
        catch (Exception e) {
            log.error("Unexpected error when saving the configuration", (Throwable)e);
            e.printStackTrace();
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Upgrade configuration application", notes="Upgrades the application used by configuration to most recent version", response=Configuration.class)
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/application/upgrade")
    public Response upgradeConfiguration(UpgradeConfigurationApplicationRequest request) {
        if (!SecurityContext.get().hasPermission("configurations")) {
            log.error("Unauthorized attempt to upgrade the configuration " + request.getConfigurationId());
            return Response.PERMISSION_DENIED();
        }
        try {
            this.configurationDAO.upgradeConfigurationApplication(request.getConfigurationId(), request.getApplicationId());
            Configuration configuration = this.getConfiguration(request.getConfigurationId());
            return Response.OK((Object)configuration);
        }
        catch (Exception e) {
            log.error("Failed to upgrade application #{} for configuration #{} to latest version due to unexpected error", new Object[]{request.getConfigurationId(), request.getApplicationId(), e});
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Copy configuration", notes="Creates a new copy of configuration referenced by the id and names it with provided name.")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/copy")
    public Response copyConfiguration(Configuration configuration) {
        if (!SecurityContext.get().hasPermission("copy_config")) {
            log.error("Unauthorized attempt to copy the configuration " + configuration.getId());
            return Response.PERMISSION_DENIED();
        }
        Configuration dbConfiguration = this.configurationDAO.getConfigurationByName(configuration.getName());
        if (dbConfiguration != null) {
            return Response.DUPLICATE_ENTITY((String)"error.duplicate.configuration");
        }
        dbConfiguration = this.getConfiguration(configuration.getId());
        List configurationApplications = this.configurationDAO.getPlainConfigurationApplications(configuration.getId());
        Configuration copy = dbConfiguration.newCopy();
        copy.setName(configuration.getName());
        copy.setDescription(configuration.getDescription());
        copy.setApplications(configurationApplications);
        copy.setBaseUrl(this.configurationDAO.getBaseUrl());
        this.configurationDAO.insertConfiguration(copy);
        User user = (User)SecurityContext.get().getCurrentUser().get();
        if (!user.isAllConfigAvailable()) {
            user.getConfigurations().add(new LookupItem(copy.getId().intValue(), null));
            this.userDAO.updateUserMainDetails(user);
        }
        return Response.OK();
    }

    @ApiOperation(value="Delete configuration", notes="Deletes a configuration referenced by the specified ID.")
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeConfiguration(@PathParam(value="id") @ApiParam(value="Configuration ID") Integer id) {
        if (!SecurityContext.get().hasPermission("copy_config")) {
            log.error("Unauthorized attempt to delete the configuration " + id);
            return Response.PERMISSION_DENIED();
        }
        try {
            this.configurationDAO.removeConfigurationById(id);
            return Response.OK();
        }
        catch (ConfigurationReferenceExistsException e) {
            log.error("Failed to delete configuration #{}", (Object)id, (Object)e);
            return Response.CONFIGURATION_DEVICE_REFERENCE_EXISTS();
        }
        catch (Exception e) {
            log.error("Failed to delete configuration #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="", hidden=true)
    @GET
    @Path(value="/applications")
    @Produces(value={"application/json"})
    public Response getAllApplications() {
        return Response.OK((Object)this.applicationDAO.getAllApplications());
    }

    @ApiOperation(value="Get configuration applications", notes="Gets the list of all applications in context of usage by the requested configuration", response=Application.class, responseContainer="List")
    @GET
    @Path(value="/applications/{id}")
    @Produces(value={"application/json"})
    public Response getConfigurationApplications(@PathParam(value="id") @ApiParam(value="Configuration ID") Integer id) {
        if (!SecurityContext.get().hasPermission("configurations")) {
            log.error("Unauthorized attempt to access configuration applications");
            return Response.PERMISSION_DENIED();
        }
        return Response.OK((Object)this.configurationDAO.getConfigurationApplications(id));
    }

    @ApiOperation(value="Get configuration", notes="Gets the details for configuration referenced by the specified ID", response=Configuration.class)
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getConfigurationById(@PathParam(value="id") Integer id) {
        if (!SecurityContext.get().hasPermission("configurations")) {
            log.error("Unauthorized attempt to access the configuration " + id);
            return Response.PERMISSION_DENIED();
        }
        Configuration configurationById = this.getConfiguration(id);
        return Response.OK((Object)configurationById);
    }

    private Configuration getConfiguration(Integer id) {
        Configuration configuration = this.configurationDAO.getConfigurationByIdFull(id);
        if (configuration != null) {
            configuration.setBaseUrl(this.configurationDAO.getBaseUrl());
            List files = configuration.getFiles();
            if (files != null && !files.isEmpty()) {
                Customer customer = this.customerDAO.findById(configuration.getCustomerId());
                files.forEach(file -> {
                    if (file.getExternalUrl() != null) {
                        file.setUrl(file.getExternalUrl());
                    } else if (file.getFilePath() != null) {
                        String url = FileUtil.createFileUrl((String)this.baseUrl, (String)customer.getFilesDir(), (String)file.getFilePath());
                        file.setUrl(url);
                    }
                });
            }
        }
        return configuration;
    }
}

