/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.UploadedFileDAO;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.UploadedFile;
import com.hmdm.rest.json.FileUploadResult;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import com.hmdm.security.SecurityException;
import com.hmdm.util.CryptoUtil;
import com.hmdm.util.FileUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/private/config-files")
public class ConfigurationFileResource {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationFileResource.class);
    private CustomerDAO customerDAO;
    private UnsecureDAO unsecureDAO;
    private String filesDirectory;
    private UploadedFileDAO uploadedFileDAO;
    private String baseUrl;

    public ConfigurationFileResource() {
    }

    @Inject
    public ConfigurationFileResource(CustomerDAO customerDAO, @Named(value="files.directory") String filesDirectory, @Named(value="base.url") String baseUrl, UploadedFileDAO uploadedFileDAO, UnsecureDAO unsecureDAO) {
        this.customerDAO = customerDAO;
        this.filesDirectory = filesDirectory;
        this.uploadedFileDAO = uploadedFileDAO;
        this.unsecureDAO = unsecureDAO;
        this.baseUrl = baseUrl;
    }

    @ApiOperation(value="Upload configuration file", notes="Uploads the configuration file to server. Returns a path to uploaded file", response=FileUploadResult.class)
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response uploadConfigurationFile(@FormDataParam(value="file") InputStream uploadedInputStream, @ApiParam(value="A configuration file to upload") @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        try {
            return SecurityContext.get().getCurrentCustomerId().map(customerId -> {
                try {
                    String fileName;
                    File configFile;
                    Customer customer = this.customerDAO.findById(customerId.intValue());
                    String customerFilesDir = customer.getFilesDir();
                    File customerFilesDirectory = new File(this.filesDirectory, customerFilesDir);
                    if (!customerFilesDirectory.exists()) {
                        customerFilesDirectory.mkdirs();
                    }
                    if ((configFile = new File(customerFilesDirectory, fileName = new String(fileDetail.getFileName().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8))).exists()) {
                        logger.warn("The file already exists and will be overwritten: {}", (Object)configFile.getAbsolutePath());
                    }
                    FileOutputStream fos = new FileOutputStream(configFile);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    IOUtils.copy((InputStream)uploadedInputStream, (OutputStream)bos);
                    uploadedInputStream.close();
                    bos.close();
                    fos.close();
                    if (!this.unsecureDAO.isSingleCustomer() && !customer.isMaster() && customer.getSizeLimit() > 0) {
                        long userDirSize = 0L;
                        long uploadFileSize = configFile.length();
                        userDirSize = FileUtils.sizeOfDirectory((File)customerFilesDirectory);
                        long totalSizeMb = (userDirSize + uploadFileSize) / 0x100000L;
                        if (totalSizeMb > (long)customer.getSizeLimit()) {
                            configFile.delete();
                            return Response.ERROR((String)"error.size.limit.exceeded", (Object)(totalSizeMb + " / " + customer.getSizeLimit()));
                        }
                    }
                    UploadedFile uploadedFile = new UploadedFile();
                    uploadedFile.setCustomerId(customerId.intValue());
                    uploadedFile.setFilePath(configFile.getName());
                    uploadedFile.setUploadTime(Long.valueOf(System.currentTimeMillis()));
                    uploadedFile = this.uploadedFileDAO.insert(uploadedFile);
                    String checksum = CryptoUtil.calculateChecksum((InputStream)Files.newInputStream(configFile.toPath(), new OpenOption[0]));
                    uploadedFile.setChecksum(checksum);
                    String url = FileUtil.createFileUrl((String)this.baseUrl, (String)customer.getFilesDir(), (String)configFile.getName());
                    uploadedFile.setUrl(url);
                    return Response.OK((Object)uploadedFile);
                }
                catch (Exception e) {
                    logger.error("Unexpected error when handling icon file upload", (Throwable)e);
                    return Response.INTERNAL_ERROR();
                }
            }).orElseThrow(SecurityException::onAnonymousAccess);
        }
        catch (Exception e) {
            logger.error("Unexpected error when handling icon file upload", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

