/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.notification.PushService;
import com.hmdm.persistence.ApplicationDAO;
import com.hmdm.persistence.ApplicationReferenceExistsException;
import com.hmdm.persistence.ApplicationVersionPackageMismatchException;
import com.hmdm.persistence.CommonAppAccessException;
import com.hmdm.persistence.ConfigurationDAO;
import com.hmdm.persistence.DuplicateApplicationException;
import com.hmdm.persistence.RecentApplicationVersionExistsException;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.ApplicationVersion;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.ApplicationConfigurationLink;
import com.hmdm.rest.json.ApplicationVersionConfigurationLink;
import com.hmdm.rest.json.LinkConfigurationsToAppRequest;
import com.hmdm.rest.json.LinkConfigurationsToAppVersionRequest;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import com.hmdm.security.SecurityException;
import com.hmdm.util.FileExistsException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Application"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/applications")
public class ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationResource.class);
    private File baseDirectory;
    private ApplicationDAO applicationDAO;
    private ConfigurationDAO configurationDAO;
    private PushService pushService;

    public ApplicationResource() {
    }

    @Inject
    public ApplicationResource(ApplicationDAO applicationDAO, ConfigurationDAO configurationDAO, PushService pushService, @Named(value="files.directory") String filesDirectory) {
        this.applicationDAO = applicationDAO;
        this.configurationDAO = configurationDAO;
        this.pushService = pushService;
        this.baseDirectory = new File(filesDirectory);
        if (!this.baseDirectory.exists()) {
            this.baseDirectory.mkdirs();
        }
    }

    @ApiOperation(value="Get all applications", notes="Gets the list of all available applications", response=Application.class, responseContainer="List")
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getAllApplications() {
        if (!SecurityContext.get().hasPermission("applications")) {
            logger.error("Unauthorized attempt to access application list by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        return Response.OK((Object)this.applicationDAO.getAllApplications());
    }

    @ApiOperation(value="Search applications", notes="Search applications meeting the specified filter value", response=Application.class, responseContainer="List")
    @GET
    @Path(value="/search/{value}")
    @Produces(value={"application/json"})
    public Response searchApplications(@PathParam(value="value") @ApiParam(value="A filter value") String value) {
        if (!SecurityContext.get().hasPermission("applications")) {
            logger.error("Unauthorized attempt to access application list by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        return Response.OK((Object)this.applicationDAO.getAllApplicationsByValue(value));
    }

    @ApiOperation(value="Get app ids and names for autocompletions")
    @POST
    @Path(value="/autocomplete")
    @Produces(value={"application/json"})
    public Response getApplicationsForAutocomplete(String filter) {
        try {
            List applications = this.applicationDAO.getApplicationPkgLookup(filter, 10);
            return Response.OK((Object)applications);
        }
        catch (Exception e) {
            logger.error("Failed to search the applications due to unexpected error. Filter: {}", (Object)filter, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Get application versions", notes="Gets the list of versions for specified application", response=ApplicationVersion.class, responseContainer="List")
    @GET
    @Path(value="/{id}/versions")
    @Produces(value={"application/json"})
    public Response getAllApplicationVersions(@PathParam(value="id") @ApiParam(value="Application ID") Integer id) {
        if (!SecurityContext.get().hasPermission("applications")) {
            logger.error("Unauthorized attempt to access application version list by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            return Response.OK((Object)this.applicationDAO.getApplicationVersions(id));
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the versions for application #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Get application", notes="Gets the details for specified application", response=Application.class)
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getApplication(@PathParam(value="id") @ApiParam(value="Application ID") Integer id) {
        if (!SecurityContext.get().hasPermission("applications")) {
            logger.error("Unauthorized attempt to access application list by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            return Response.OK((Object)this.applicationDAO.findById(id.intValue()));
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the details for application #{}", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Create or update Android application", notes="Create a new Android application (if id is not provided) or update existing one otherwise.")
    @Path(value="/android")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateApplication(Application application) {
        if (!SecurityContext.get().hasPermission("edit_applications")) {
            logger.error("Unauthorized attempt to update application by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            ApplicationVersion version;
            if (application.getId() == null) {
                int appId = this.applicationDAO.insertApplication(application);
                application = this.applicationDAO.findById(appId);
                return Response.OK((Object)application);
            }
            this.applicationDAO.updateApplication(application);
            if (application.getUrl() != null && application.getLatestVersion() != null && !application.isSplit() && (version = this.applicationDAO.findApplicationVersionById(application.getLatestVersion().intValue())) != null) {
                version.setUrl(application.getUrl());
                this.applicationDAO.updateApplicationVersion(version);
                logger.info("Application " + application.getPkg() + " updated to version " + version.getVersion() + ", user " + SecurityContext.get().getCurrentUserName());
            }
            return Response.OK();
        }
        catch (DuplicateApplicationException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.DUPLICATE_APPLICATION();
        }
        catch (RecentApplicationVersionExistsException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.RECENT_APPLICATION_VERSION_EXISTS();
        }
        catch (CommonAppAccessException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.COMMON_APPLICATION_ACCESS_PROHIBITED();
        }
        catch (FileExistsException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.FILE_EXISTS();
        }
        catch (Exception e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Create or update Web-page application", notes="Create a new Web-page application (if id is not provided) or update existing one otherwise.")
    @Path(value="/web")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateWebApplication(Application application) {
        if (!SecurityContext.get().hasPermission("edit_applications")) {
            logger.error("Unauthorized attempt to update application by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            ApplicationVersion version;
            if (application.getId() == null) {
                int appId = this.applicationDAO.insertWebApplication(application);
                application = this.applicationDAO.findById(appId);
                return Response.OK((Object)application);
            }
            this.applicationDAO.updateWebApplication(application);
            if (application.getUrl() != null && application.getLatestVersion() != null && (version = this.applicationDAO.findApplicationVersionById(application.getLatestVersion().intValue())) != null) {
                version.setUrl(application.getUrl());
                this.applicationDAO.updateApplicationVersion(version);
            }
            return Response.OK();
        }
        catch (DuplicateApplicationException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.DUPLICATE_APPLICATION();
        }
        catch (RecentApplicationVersionExistsException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.RECENT_APPLICATION_VERSION_EXISTS();
        }
        catch (CommonAppAccessException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.COMMON_APPLICATION_ACCESS_PROHIBITED();
        }
        catch (FileExistsException e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.FILE_EXISTS();
        }
        catch (Exception e) {
            logger.error("Failed to create or update application", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Create or update application version", notes="Create a new application version (if id is not provided) or update existing one otherwise.")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/versions")
    public Response updateApplicationVersion(ApplicationVersion applicationVersion) {
        if (!SecurityContext.get().hasPermission("edit_application_versions")) {
            logger.error("Unauthorized attempt to update application version by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            if (applicationVersion.getId() == null) {
                this.applicationDAO.insertApplicationVersion(applicationVersion);
                applicationVersion = this.applicationDAO.findApplicationVersionById(applicationVersion.getId().intValue());
                return Response.OK((Object)applicationVersion);
            }
            logger.info("Application " + applicationVersion.getApplicationId() + " version updated: " + applicationVersion.getVersion() + ", user " + SecurityContext.get().getCurrentUserName());
            this.applicationDAO.updateApplicationVersion(applicationVersion);
            return Response.OK();
        }
        catch (DuplicateApplicationException e) {
            logger.error("Failed to create or update application version", (Throwable)e);
            return Response.DUPLICATE_APPLICATION();
        }
        catch (RecentApplicationVersionExistsException e) {
            logger.error("Failed to create or update application version", (Throwable)e);
            return Response.RECENT_APPLICATION_VERSION_EXISTS();
        }
        catch (ApplicationVersionPackageMismatchException e) {
            logger.error("Failed to create or update application version", (Throwable)e);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("expected", e.getExpectedPackageName());
            args.put("actual", e.getActualPackageName());
            return Response.ERROR((String)"error.application.version.pkg.mismatch", args);
        }
        catch (CommonAppAccessException e) {
            logger.error("Failed to create or update application version", (Throwable)e);
            return Response.COMMON_APPLICATION_ACCESS_PROHIBITED();
        }
        catch (FileExistsException e) {
            logger.error("Failed to create or update application version", (Throwable)e);
            return Response.FILE_EXISTS();
        }
        catch (Exception e) {
            logger.error("Failed to create or update application version", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Delete application", notes="Delete an existing application")
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeApplication(@PathParam(value="id") @ApiParam(value="Application ID") Integer id) {
        if (!SecurityContext.get().hasPermission("edit_applications")) {
            logger.error("Unauthorized attempt to remove application by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            this.applicationDAO.removeApplicationById(id, true);
            return Response.OK();
        }
        catch (SecurityException e) {
            logger.error("Prohibited to delete application #{} by current user", (Object)id, (Object)e);
            return Response.PERMISSION_DENIED();
        }
        catch (ApplicationReferenceExistsException e) {
            logger.error("Prohibited to delete application #{} as it is still referenced in configurations", (Object)id, (Object)e);
            return Response.APPLICATION_CONFIG_REFERENCE_EXISTS();
        }
        catch (Exception e) {
            logger.error("Failed to delete application #{} due to unexpected error", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Delete application version", notes="Delete an existing application version")
    @DELETE
    @Path(value="/versions/{id}")
    @Produces(value={"application/json"})
    public Response removeApplicationVersion(@PathParam(value="id") @ApiParam(value="Application Version ID") Integer id) {
        if (!SecurityContext.get().hasPermission("edit_application_versions")) {
            logger.error("Unauthorized attempt to delete application version by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            this.applicationDAO.removeApplicationVersionByIdWithAPKFile(id);
            return Response.OK();
        }
        catch (SecurityException e) {
            logger.error("Prohibited to delete application version #{} by current user", (Object)id, (Object)e);
            return Response.PERMISSION_DENIED();
        }
        catch (ApplicationReferenceExistsException e) {
            logger.error("Prohibited to delete application version #{} as it is still referenced in configurations", (Object)id, (Object)e);
            return Response.APPLICATION_CONFIG_REFERENCE_EXISTS();
        }
        catch (Exception e) {
            logger.error("Failed to delete application version #{} due to unexpected error", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Get application configurations", notes="Gets the list of configurations using requested application", response=ApplicationConfigurationLink.class, responseContainer="List")
    @GET
    @Path(value="/configurations/{id}")
    @Produces(value={"application/json"})
    public Response getApplicationConfigurations(@PathParam(value="id") @ApiParam(value="Application ID") Integer id) {
        if (!SecurityContext.get().hasPermission("applications")) {
            logger.error("Unauthorized attempt to get application configurations by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        return Response.OK((Object)this.applicationDAO.getApplicationConfigurations(id));
    }

    @ApiOperation(value="Get application version configurations", notes="Gets the list of configurations using requested application version", response=ApplicationConfigurationLink.class, responseContainer="List")
    @GET
    @Path(value="/version/{id}/configurations")
    @Produces(value={"application/json"})
    public Response getApplicationVersionConfigurations(@PathParam(value="id") @ApiParam(value="Application Version ID") Integer id) {
        if (!SecurityContext.get().hasPermission("applications")) {
            logger.error("Unauthorized attempt to get application version configurations by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            return Response.OK((Object)this.applicationDAO.getApplicationVersionConfigurations(id));
        }
        catch (Exception e) {
            logger.error("Failed to get list of application version configurations", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Update application configurations", notes="Updates the list of configurations using requested application")
    @POST
    @Path(value="/configurations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateApplicationConfigurations(LinkConfigurationsToAppRequest request) {
        if (!SecurityContext.get().hasPermission("edit_applications")) {
            logger.error("Unauthorized attempt to update application configurations by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            User user = (User)SecurityContext.get().getCurrentUser().get();
            if (!user.isAllConfigAvailable()) {
                request.getConfigurations().removeIf(c -> user.getConfigurations().stream().filter(uc -> uc.getId() == c.getConfigurationId()).findFirst() == null);
            }
            request.getConfigurations().removeIf(c -> {
                Application application = this.applicationDAO.findById(c.getApplicationId());
                Configuration configuration = this.configurationDAO.getConfigurationById(Integer.valueOf(c.getConfigurationId()));
                return application.getCustomerId() != user.getCustomerId() || configuration.getCustomerId() != user.getCustomerId();
            });
            logger.info("Application configurations updated by user " + SecurityContext.get().getCurrentUserName());
            this.applicationDAO.updateApplicationConfigurations(request);
            for (ApplicationConfigurationLink configurationLink : request.getConfigurations()) {
                if (!configurationLink.isNotify()) continue;
                this.pushService.notifyDevicesOnUpdate(Integer.valueOf(configurationLink.getConfigurationId()));
            }
            return Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error when updating application configurations", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Update application version configurations", notes="Updates the list of configurations using requested application version")
    @POST
    @Path(value="/version/configurations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateApplicationVersionConfigurations(LinkConfigurationsToAppVersionRequest request) {
        if (!SecurityContext.get().hasPermission("edit_application_versions")) {
            logger.error("Unauthorized attempt to update application version configurations by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        try {
            User user = (User)SecurityContext.get().getCurrentUser().get();
            if (!user.isAllConfigAvailable()) {
                request.getConfigurations().removeIf(c -> user.getConfigurations().stream().filter(uc -> uc.getId() == c.getConfigurationId()).findFirst() == null);
            }
            logger.info("Application version configurations updated by user " + SecurityContext.get().getCurrentUserName());
            this.applicationDAO.updateApplicationVersionConfigurations(request, user);
            for (ApplicationVersionConfigurationLink configurationLink : request.getConfigurations()) {
                if (!configurationLink.isNotify()) continue;
                this.pushService.notifyDevicesOnUpdate(Integer.valueOf(configurationLink.getConfigurationId()));
            }
            return Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error when updating application configurations", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="", hidden=true)
    @GET
    @Path(value="/admin/search")
    @Produces(value={"application/json"})
    public Response getAllAdminApplications() {
        return Response.OK((Object)this.applicationDAO.getAllAdminApplications());
    }

    @ApiOperation(value="", hidden=true)
    @GET
    @Path(value="/admin/search/{value}")
    @Produces(value={"application/json"})
    public Response searchAdminApplications(@PathParam(value="value") String value) {
        return Response.OK((Object)this.applicationDAO.getAllAdminApplicationsByValue(value));
    }

    @ApiOperation(value="", hidden=true)
    @GET
    @Path(value="/admin/common/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response turnApplicationIntoCommon(@PathParam(value="id") Integer id) {
        try {
            logger.info("Turn application into common: " + id);
            this.applicationDAO.turnApplicationIntoCommon(id);
            return Response.OK();
        }
        catch (DuplicateApplicationException e) {
            logger.error("Failed to turn application with ID: {} into common", (Object)id, (Object)e);
            return Response.DUPLICATE_APPLICATION();
        }
        catch (Exception e) {
            logger.error("Failed to turn application with ID: {} into common", (Object)id, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Validate application package", notes="Validate the application package ID for uniqueness", response=Application.class, responseContainer="List")
    @Path(value="/validatePkg")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response validateApplication(Application application) {
        try {
            List sameNameApps = this.applicationDAO.getApplicationsForName(application);
            for (Application app : sameNameApps) {
                if (app.getPkg().equalsIgnoreCase(application.getPkg())) continue;
                return Response.ERROR((String)"error.app.name.exists");
            }
            List otherApps = this.applicationDAO.getApplicationsForPackageID(application);
            return Response.OK((Object)otherApps);
        }
        catch (Exception e) {
            logger.error("Failed to validate application", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

