/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view.devicelist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.persistence.domain.ApplicationType;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.rest.json.view.devicelist.ApplicationView;
import com.hmdm.rest.json.view.devicelist.ConfigurationFileView;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonIgnoreProperties(value={"configuration"}, ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="An MDM configuration used on mobile device")
public class ConfigurationView
implements Serializable {
    private static final long serialVersionUID = 3343804830704098674L;
    private final Configuration configuration;
    private final List<ApplicationView> applications;
    private final List<ConfigurationFileView> files;

    ConfigurationView(Configuration configuration) {
        this.configuration = configuration;
        this.applications = Optional.ofNullable(configuration.getApplications()).map(apps -> apps.stream().filter(app -> app.getType().equals((Object)ApplicationType.app)).map(ApplicationView::new).collect(Collectors.toList())).orElse(new ArrayList());
        this.files = Optional.ofNullable(configuration.getFiles()).map(apps -> apps.stream().map(ConfigurationFileView::new).collect(Collectors.toList())).orElse(new ArrayList());
    }

    @ApiModelProperty(value="A configuration ID")
    public Integer getId() {
        return this.configuration.getId();
    }

    @ApiModelProperty(value="A unique name of configuration")
    public String getName() {
        return this.configuration.getName();
    }

    @ApiModelProperty(value="QR code to enroll the configuration")
    public String getQrCodeKey() {
        return this.configuration.getQrCodeKey();
    }

    @ApiModelProperty(hidden=true)
    public String getBaseUrl() {
        return this.configuration.getBaseUrl();
    }

    @ApiModelProperty(value="A list of applications set and available for for configuration")
    public List<ApplicationView> getApplications() {
        return this.applications;
    }

    @ApiModelProperty(value="A list of configrration files to be set on device")
    public List<ConfigurationFileView> getFiles() {
        return this.files;
    }
}

