/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.DesktopHeader;
import com.hmdm.persistence.domain.Device;
import com.hmdm.persistence.domain.Settings;
import com.hmdm.rest.json.SyncApplication;
import com.hmdm.rest.json.SyncApplicationInt;
import com.hmdm.rest.json.SyncApplicationSettingInt;
import com.hmdm.rest.json.SyncConfigurationFileInt;
import com.hmdm.rest.json.SyncResponseInt;
import com.hmdm.util.CryptoUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@ApiModel(description="The details and settings for a single device used for configuring MDM mobile application")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncResponse
implements Serializable,
SyncResponseInt {
    private static final long serialVersionUID = 7961923794459303328L;
    @ApiModelProperty(value="A background color to use when running MDM application")
    private String backgroundColor;
    @ApiModelProperty(value="A text color to use when running MDM application")
    private String textColor;
    @ApiModelProperty(value="An URL for background image to use when running MDM application")
    private String backgroundImageUrl;
    @ApiModelProperty(value="A size of the icons to use when running MDM application")
    private String iconSize;
    @ApiModelProperty(value="A type of location tracking")
    private String requestUpdates;
    @ApiModelProperty(value="A flag indicating if location permission shouldn't be granted")
    private Boolean disableLocation;
    @ApiModelProperty(value="Strategy of app permission auto-granting")
    private String appPermissions;
    @ApiModelProperty(value="Push notification options")
    private String pushOptions;
    @ApiModelProperty(value="Keep-Alive time for MQTT connection")
    private Integer keepaliveTime;
    @ApiModelProperty(value="Brightness management option")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean autoBrightness;
    @ApiModelProperty(value="Brightness value (0-255)")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer brightness;
    @ApiModelProperty(value="Timeout management option")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean manageTimeout;
    @ApiModelProperty(value="Timeout value (sec)")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer timeout;
    @ApiModelProperty(value="Volume lock option")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean lockVolume;
    @ApiModelProperty(value="Volume manage option")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean manageVolume;
    @ApiModelProperty(value="Volume (percents)")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer volume;
    @ApiModelProperty(value="Password requirements for the mobile device")
    private String passwordMode;
    @ApiModelProperty(value="Orientation lock: 0 - none, 1 - portrait, 2 - landscape")
    private Integer orientation;
    @ApiModelProperty(value="Set to true if Headind MDM should display device status (time, battery, etc)")
    private Boolean displayStatus;
    @ApiModelProperty(value="Set to true if Headwind MDM need to work together with a third-party launcher")
    private Boolean runDefaultLauncher;
    @ApiModelProperty(value="Flag indicating if screenshots are disabled on the device")
    private Boolean disableScreenshots;
    @ApiModelProperty(value="Flag indicating if autostarted apps should be kept in the foreground")
    private Boolean autostartForeground;
    @ApiModelProperty(value="Time zone settings: null for using default settings, auto for automatic time zone, or Olson time zone string")
    private String timeZone;
    @ApiModelProperty(value="Allowed classes, separated by comma")
    private String allowedClasses;
    @ApiModelProperty(value="New server URL used to migrate to another server")
    private String newServerUrl;
    @ApiModelProperty(value="Flag disabling safe settings")
    private Boolean lockSafeSettings;
    @ApiModelProperty(value="Flag enabling permissive mode")
    private Boolean permissive;
    @ApiModelProperty(value="Flag enabling the kiosk exit button")
    private Boolean kioskExit;
    @ApiModelProperty(value="Show WiFi settings if there's a connection error, also in Kiosk mode")
    private Boolean showWifi;
    @ApiModelProperty(value="A password for administrator of MDM application used on device")
    private String password;
    @ApiModelProperty(value="An IMEI of device")
    private String imei;
    @ApiModelProperty(value="A phone number of device")
    private String phone;
    @ApiModelProperty(value="A displayed title of the MDM application used on device")
    private String title;
    @ApiModelProperty(value="A list of applications to be used on device")
    private List<SyncApplicationInt> applications;
    @ApiModelProperty(value="A flag indicating if GPS is enabled on device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean gps;
    @ApiModelProperty(value="A flag indicating if Bluetooth is enabled on device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean bluetooth;
    @ApiModelProperty(value="A flag indicating if Wi-Fi is enabled on device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean wifi;
    @ApiModelProperty(value="A flag indicating if Mobile Data is enabled on device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean mobileData;
    @ApiModelProperty(value="A flag indicating if USB storage is enabled on device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean usbStorage;
    @ApiModelProperty(value="A flag indicating if MDM is operating in kiosk mode")
    private boolean kioskMode;
    @ApiModelProperty(value="Flag enabling Home button in kiosk mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean kioskHome;
    @ApiModelProperty(value="Flag enabling Recents button in kiosk mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean kioskRecents;
    @ApiModelProperty(value="Flag enabling notifications in kiosk mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean kioskNotifications;
    @ApiModelProperty(value="Flag enabling system info in kiosk mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean kioskSystemInfo;
    @ApiModelProperty(value="Flag enabling lock screen in kiosk mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean kioskKeyguard;
    @ApiModelProperty(value="Flag disabling power button in kiosk mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean kioskLockButtons;
    @ApiModelProperty(value="A flag indicating if status bar is locked")
    private boolean lockStatusBar;
    @ApiModelProperty(value="Flag forcing screen to be on in kiosk mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean kioskScreenOn;
    @ApiModelProperty(value="A package ID for the main application")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String mainApp;
    @ApiModelProperty(value="A system update type. 0-Default, 1-Immediately, 2-Scheduled, 3-Postponed", allowableValues="0,1,2,3")
    private int systemUpdateType;
    @ApiModelProperty(value="A start time for system update period formatted as HH:MM. (If system update time is 2)")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String systemUpdateFrom;
    @ApiModelProperty(value="A finish time for system update period formatted as HH:MM. (If system update time is 2)")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String systemUpdateTo;
    @ApiModelProperty(value="A flag indicating if the application update must be scheduled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean scheduleAppUpdate;
    @ApiModelProperty(value="A start time for app update period formatted as HH:MM.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String appUpdateFrom;
    @ApiModelProperty(value="A finish time for app update period formatted as HH:MM.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String appUpdateTo;
    @ApiModelProperty(value="Limitations of downloading updates")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String downloadUpdates;
    @ApiModelProperty(value="A list of application settings to apply on device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<SyncApplicationSettingInt> applicationSettings;
    @ApiModelProperty(value="A list of files to apply on device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<SyncConfigurationFileInt> files;
    @ApiModelProperty(value="New device number, used for changing the device number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String newNumber;
    @ApiModelProperty(value="List of additional restrictions in MDM mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String restrictions;
    @ApiModelProperty(value="Custom property #1 if it is being sent to device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String custom1;
    @ApiModelProperty(value="Custom property #2 if it is being sent to device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String custom2;
    @ApiModelProperty(value="Custom property #3 if it is being sent to device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String custom3;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String appName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String vendor;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;

    public SyncResponse() {
    }

    public SyncResponse(Settings settings, String password, List<Application> applications, Device device) {
        if (settings != null) {
            this.backgroundColor = settings.getBackgroundColor();
            this.textColor = settings.getTextColor();
            this.backgroundImageUrl = settings.getBackgroundImageUrl();
            this.iconSize = settings.getIconSize().getTransmittedValue();
            String string = this.title = settings.getDesktopHeader() == DesktopHeader.TEMPLATE ? settings.getDesktopHeaderTemplate() : settings.getDesktopHeader().getTransmittedValue();
        }
        if (device != null) {
            this.imei = device.getImei();
            this.phone = device.getPhone();
            if (device.getOldNumber() != null) {
                this.newNumber = device.getNumber();
            }
        }
        this.password = CryptoUtil.getMD5String((String)password);
        this.applications = applications != null ? applications.stream().map(SyncApplication::new).collect(Collectors.toList()) : new LinkedList();
    }

    public SyncResponse(Configuration settings, List<Application> applications, Device device) {
        if (settings != null) {
            this.backgroundColor = settings.getBackgroundColor();
            this.textColor = settings.getTextColor();
            this.backgroundImageUrl = settings.getBackgroundImageUrl();
            this.iconSize = settings.getIconSize().getTransmittedValue();
            String string = this.title = settings.getDesktopHeader() == DesktopHeader.TEMPLATE ? settings.getDesktopHeaderTemplate() : settings.getDesktopHeader().getTransmittedValue();
        }
        if (device != null) {
            this.imei = device.getImei();
            this.phone = device.getPhone();
            if (device.getOldNumber() != null) {
                this.newNumber = device.getNumber();
            }
        }
        this.password = CryptoUtil.getMD5String((String)settings.getPassword());
        this.applications = applications != null ? applications.stream().map(SyncApplication::new).collect(Collectors.toList()) : new LinkedList();
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public String getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    public void setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
    }

    public List<SyncApplicationInt> getApplications() {
        return this.applications;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getImei() {
        return this.imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(String iconSize) {
        this.iconSize = iconSize;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getGps() {
        return this.gps;
    }

    public void setGps(Boolean gps) {
        this.gps = gps;
    }

    public Boolean getBluetooth() {
        return this.bluetooth;
    }

    public void setBluetooth(Boolean bluetooth) {
        this.bluetooth = bluetooth;
    }

    public Boolean getWifi() {
        return this.wifi;
    }

    public void setWifi(Boolean wifi) {
        this.wifi = wifi;
    }

    public Boolean getMobileData() {
        return this.mobileData;
    }

    public void setMobileData(Boolean mobileData) {
        this.mobileData = mobileData;
    }

    public boolean isKioskMode() {
        return this.kioskMode;
    }

    public void setKioskMode(boolean kioskMode) {
        this.kioskMode = kioskMode;
    }

    public Boolean getKioskHome() {
        return this.kioskHome;
    }

    public void setKioskHome(Boolean kioskHome) {
        this.kioskHome = kioskHome;
    }

    public Boolean getKioskRecents() {
        return this.kioskRecents;
    }

    public void setKioskRecents(Boolean kioskRecents) {
        this.kioskRecents = kioskRecents;
    }

    public Boolean getKioskNotifications() {
        return this.kioskNotifications;
    }

    public void setKioskNotifications(Boolean kioskNotifications) {
        this.kioskNotifications = kioskNotifications;
    }

    public Boolean getKioskSystemInfo() {
        return this.kioskSystemInfo;
    }

    public void setKioskSystemInfo(Boolean kioskSystemInfo) {
        this.kioskSystemInfo = kioskSystemInfo;
    }

    public Boolean getKioskKeyguard() {
        return this.kioskKeyguard;
    }

    public void setKioskKeyguard(Boolean kioskKeyguard) {
        this.kioskKeyguard = kioskKeyguard;
    }

    public Boolean getKioskLockButtons() {
        return this.kioskLockButtons;
    }

    public void setKioskLockButtons(Boolean kioskLockButtons) {
        this.kioskLockButtons = kioskLockButtons;
    }

    public Boolean getKioskScreenOn() {
        return this.kioskScreenOn;
    }

    public void setKioskScreenOn(Boolean kioskScreenOn) {
        this.kioskScreenOn = kioskScreenOn;
    }

    public String getMainApp() {
        return this.mainApp;
    }

    public void setMainApp(String mainApp) {
        this.mainApp = mainApp;
    }

    public boolean isLockStatusBar() {
        return this.lockStatusBar;
    }

    public void setLockStatusBar(boolean lockStatusBar) {
        this.lockStatusBar = lockStatusBar;
    }

    public int getSystemUpdateType() {
        return this.systemUpdateType;
    }

    public void setSystemUpdateType(int systemUpdateType) {
        this.systemUpdateType = systemUpdateType;
    }

    public String getSystemUpdateFrom() {
        return this.systemUpdateFrom;
    }

    public void setSystemUpdateFrom(String systemUpdateFrom) {
        this.systemUpdateFrom = systemUpdateFrom;
    }

    public String getSystemUpdateTo() {
        return this.systemUpdateTo;
    }

    public void setSystemUpdateTo(String systemUpdateTo) {
        this.systemUpdateTo = systemUpdateTo;
    }

    public Boolean getScheduleAppUpdate() {
        return this.scheduleAppUpdate;
    }

    public void setScheduleAppUpdate(Boolean scheduleAppUpdate) {
        this.scheduleAppUpdate = scheduleAppUpdate;
    }

    public String getAppUpdateFrom() {
        return this.appUpdateFrom;
    }

    public void setAppUpdateFrom(String appUpdateFrom) {
        this.appUpdateFrom = appUpdateFrom;
    }

    public String getAppUpdateTo() {
        return this.appUpdateTo;
    }

    public void setAppUpdateTo(String appUpdateTo) {
        this.appUpdateTo = appUpdateTo;
    }

    public String getDownloadUpdates() {
        return this.downloadUpdates;
    }

    public void setDownloadUpdates(String downloadUpdates) {
        this.downloadUpdates = downloadUpdates;
    }

    public List<SyncApplicationSettingInt> getApplicationSettings() {
        return this.applicationSettings;
    }

    public void setApplicationSettings(List<SyncApplicationSettingInt> applicationSettings) {
        this.applicationSettings = applicationSettings;
    }

    public Boolean getUsbStorage() {
        return this.usbStorage;
    }

    public void setUsbStorage(Boolean usbStorage) {
        this.usbStorage = usbStorage;
    }

    public String getRequestUpdates() {
        return this.requestUpdates;
    }

    public void setRequestUpdates(String requestUpdates) {
        this.requestUpdates = requestUpdates;
    }

    public Boolean getDisableLocation() {
        return this.disableLocation;
    }

    public void setDisableLocation(Boolean disableLocation) {
        this.disableLocation = disableLocation;
    }

    public String getAppPermissions() {
        return this.appPermissions;
    }

    public void setAppPermissions(String appPermissions) {
        this.appPermissions = appPermissions;
    }

    public String getPushOptions() {
        return this.pushOptions;
    }

    public void setPushOptions(String pushOptions) {
        this.pushOptions = pushOptions;
    }

    public Integer getKeepaliveTime() {
        return this.keepaliveTime;
    }

    public void setKeepaliveTime(Integer keepaliveTime) {
        this.keepaliveTime = keepaliveTime;
    }

    public Boolean getAutoBrightness() {
        return this.autoBrightness;
    }

    public void setAutoBrightness(Boolean autoBrightness) {
        this.autoBrightness = autoBrightness;
    }

    public Integer getBrightness() {
        return this.brightness;
    }

    public void setBrightness(Integer brightness) {
        this.brightness = brightness;
    }

    public Boolean getManageTimeout() {
        return this.manageTimeout;
    }

    public void setManageTimeout(Boolean manageTimeout) {
        this.manageTimeout = manageTimeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Boolean getLockVolume() {
        return this.lockVolume;
    }

    public void setLockVolume(Boolean lockVolume) {
        this.lockVolume = lockVolume;
    }

    public Boolean getManageVolume() {
        return this.manageVolume;
    }

    public void setManageVolume(Boolean manageVolume) {
        this.manageVolume = manageVolume;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public String getPasswordMode() {
        return this.passwordMode;
    }

    public void setPasswordMode(String passwordMode) {
        this.passwordMode = passwordMode;
    }

    public Integer getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Integer orientation) {
        this.orientation = orientation;
    }

    public Boolean getDisplayStatus() {
        return this.displayStatus;
    }

    public void setDisplayStatus(Boolean displayStatus) {
        this.displayStatus = displayStatus;
    }

    public Boolean getRunDefaultLauncher() {
        return this.runDefaultLauncher;
    }

    public void setRunDefaultLauncher(Boolean runDefaultLauncher) {
        this.runDefaultLauncher = runDefaultLauncher;
    }

    public Boolean getDisableScreenshots() {
        return this.disableScreenshots;
    }

    public void setDisableScreenshots(Boolean disableScreenshots) {
        this.disableScreenshots = disableScreenshots;
    }

    public Boolean getAutostartForeground() {
        return this.autostartForeground;
    }

    public void setAutostartForeground(Boolean autostartForeground) {
        this.autostartForeground = autostartForeground;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getAllowedClasses() {
        return this.allowedClasses;
    }

    public void setAllowedClasses(String allowedClasses) {
        this.allowedClasses = allowedClasses;
    }

    public String getNewServerUrl() {
        return this.newServerUrl;
    }

    public void setNewServerUrl(String newServerUrl) {
        this.newServerUrl = newServerUrl;
    }

    public Boolean getLockSafeSettings() {
        return this.lockSafeSettings;
    }

    public void setLockSafeSettings(Boolean lockSafeSettings) {
        this.lockSafeSettings = lockSafeSettings;
    }

    public Boolean getPermissive() {
        return this.permissive;
    }

    public void setPermissive(Boolean permissive) {
        this.permissive = permissive;
    }

    public Boolean getKioskExit() {
        return this.kioskExit;
    }

    public void setKioskExit(Boolean kioskExit) {
        this.kioskExit = kioskExit;
    }

    public Boolean getShowWifi() {
        return this.showWifi;
    }

    public void setShowWifi(Boolean showWifi) {
        this.showWifi = showWifi;
    }

    public List<SyncConfigurationFileInt> getFiles() {
        return this.files;
    }

    public void setFiles(List<SyncConfigurationFileInt> files) {
        this.files = files;
    }

    public String getNewNumber() {
        return this.newNumber;
    }

    public void setNewNumber(String newNumber) {
        this.newNumber = newNumber;
    }

    public String getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(String restrictions) {
        this.restrictions = restrictions;
    }

    public String getCustom1() {
        return this.custom1;
    }

    public void setCustom1(String custom1) {
        this.custom1 = custom1;
    }

    public String getCustom2() {
        return this.custom2;
    }

    public void setCustom2(String custom2) {
        this.custom2 = custom2;
    }

    public String getCustom3() {
        return this.custom3;
    }

    public void setCustom3(String custom3) {
        this.custom3 = custom3;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

