/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.ApplicationType;
import com.hmdm.rest.json.SyncApplicationInt;
import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;

@ApiModel(description="A specification of a single application available for usage on mobile device")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncApplication
implements SyncApplicationInt {
    @JsonIgnore
    private final Application wrapped;

    public SyncApplication(@NotNull Application wrapped) {
        this.wrapped = wrapped;
    }

    public String getIcon() {
        return this.wrapped.getIcon();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String getPkg() {
        return this.wrapped.getPkg();
    }

    public String getVersion() {
        return this.wrapped.getVersion();
    }

    public Integer getCode() {
        return this.wrapped.getVersionCode() != 0 ? Integer.valueOf(this.wrapped.getVersionCode()) : null;
    }

    public String getUrl() {
        return this.wrapped.getUrl();
    }

    public Integer getId() {
        return this.wrapped.getId();
    }

    public Boolean getShowIcon() {
        return this.wrapped.getShowIcon() ? Boolean.valueOf(true) : null;
    }

    public Boolean getUseKiosk() {
        return this.wrapped.getUseKiosk() ? Boolean.valueOf(true) : null;
    }

    @Deprecated
    public Boolean isRemove() {
        return this.wrapped.isRemove() ? Boolean.valueOf(true) : null;
    }

    public Boolean isSystem() {
        return this.wrapped.isSystem() ? Boolean.valueOf(true) : null;
    }

    public Boolean isRunAfterInstall() {
        return this.wrapped.isRunAfterInstall() ? Boolean.valueOf(true) : null;
    }

    public Boolean isRunAtBoot() {
        return this.wrapped.isRunAtBoot() ? Boolean.valueOf(true) : null;
    }

    public Boolean isSkipVersion() {
        return this.wrapped.isSkipVersion() ? Boolean.valueOf(true) : null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getIconText() {
        return this.wrapped.getIconText();
    }

    public ApplicationType getType() {
        return this.wrapped.getType();
    }

    public Integer getScreenOrder() {
        return this.wrapped.getScreenOrder();
    }

    public Integer getKeyCode() {
        return this.wrapped.getKeyCode();
    }

    public Boolean getBottom() {
        return this.wrapped.isBottom() ? Boolean.valueOf(true) : null;
    }

    public Boolean getLongTap() {
        return this.wrapped.isLongTap() ? Boolean.valueOf(true) : null;
    }

    public String getIntent() {
        return this.wrapped.getIntent();
    }
}

