/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.guice.module;

import com.google.inject.Inject;
import com.hmdm.event.EventListener;
import com.hmdm.event.EventService;
import com.hmdm.persistence.ConfigurationUpdatedEventListener;
import com.hmdm.persistence.DeviceInfoUpdatedEventListener;
import com.hmdm.persistence.mapper.DeviceMapper;
import com.hmdm.service.DeviceStatusService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerModule {
    private final EventService eventService;
    private final DeviceMapper deviceMapper;
    private final DeviceStatusService deviceStatusService;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private static final Logger logger = LoggerFactory.getLogger(EventListenerModule.class);

    @Inject
    public EventListenerModule(EventService eventService, DeviceMapper deviceMapper, DeviceStatusService deviceStatusService) {
        this.eventService = eventService;
        this.deviceMapper = deviceMapper;
        this.deviceStatusService = deviceStatusService;
    }

    public void init() {
        this.eventService.addEventListener((EventListener)new DeviceInfoUpdatedEventListener(this.deviceStatusService));
        this.eventService.addEventListener((EventListener)new ConfigurationUpdatedEventListener(this.deviceMapper, this.deviceStatusService));
        this.executorService.submit(() -> {
            List deviceIds = this.deviceMapper.getAllDeviceIds();
            deviceIds.forEach(deviceId -> {
                try {
                    this.deviceStatusService.recalcDeviceStatuses(deviceId.intValue());
                }
                catch (Exception e) {
                    logger.warn("Failed to recalculate statuses for device: {}", deviceId, (Object)e);
                }
            });
        });
        Runtime.getRuntime().addShutdownHook(new Thread(this.executorService::shutdown));
    }
}

