if (! document.localization) document.localization = [];

document.localization ['de_DE'] = {
    'login.username': 'Benutzername oder e-Mail',
    'login.username.placeholder': 'Benutzername oder e-Mail eingeben',
    'login.password': 'Passwort:',
    'login.password.placeholder': 'Passwort eingeben',
    'login.submit': 'Anmelden',
    'login.password.incorrect': 'Falscher Benutzername oder Passwort',
    'login.password.recovery': 'Passwort vergessen?',
    'recovery.password': 'Passwort wiederherstellen',
    'recovery.password.success': 'Anweisungen zur Passwortwiederherstellung wurden an Ihre E-Mail gesendet',
    'login.no.account': 'Noch kein Konto haben?',
    'login.signup': 'Anmelden',

    'signup.title': 'Erste Schritte',
    'signup.email': 'Ihre E-Mail-Adresse',
    'signup.email.placeholder': 'Geben Sie eine gültige E-Mail-Adresse ein',
    'signup.email.invalid': 'Geben Sie eine gültige E-Mail-Adresse ein',
    'signup.terms.agree': 'Ich stimme zu',
    'signup.terms.terms': 'allgemeine Geschäftsbedingungen',
    'signup.submit': 'Anmelden',
    'signup.progress': 'Anmeldung ...',
    'signup.email.used': 'Ein Kunde mit dieser E-Mail ist bereits registriert',
    'signup.name.used': 'Ein Kunde mit diesem Benutzernamen ist bereits registriert',
    'signup.complete': 'Vielen Dank für Ihre Anmeldung!',
    'signup.email.check': 'Bitte überprüfen Sie Ihre E-Mail und folgen Sie dem Link, um die Registrierung abzuschließen!',
    'signup.complete.title': 'Ihr Konto bei ${appName} ist fast fertig!',
    'signup.ready.title': 'Ihr Konto bei ${appName} ist bereit!',
    'signup.customer.id': 'Benutzername',
    'signup.customer.id.placeholder': 'Nur Buchstaben und Ziffern verwenden',
    'signup.customer.id.invalid': 'Bitte verwenden Sie 6 oder mehr Zeichen, nur Buchstaben und Ziffern',
    'signup.first.name': 'Vorname',
    'signup.first.name.placeholder': 'Ihr Vorname (erforderlich)',
    'signup.last.name': 'Nachname',
    'signup.last.name.placeholder': 'Ihr Nachname (erforderlich)',
    'signup.company': 'Firmenname',
    'signup.company.placeholder': 'Name Ihres Unternehmens (optional)',
    'signup.description': 'Wie werden Sie MDM verwenden?',
    'signup.description.placeholder': 'Dies wird unserem Team helfen, Ihnen zu helfen',
    'signup.password': 'Passwort',
    'signup.password.repeat': 'Passwort wiederholen',
    'signup.password.placeholder': '6+ Zeichen',
    'signup.password.short': 'Bitte geben Sie mindestens 6 Zeichen ein',
    'signup.password.not.match': 'Passwörter stimmen nicht überein',
    'signup.finalized.title': 'Ihr Konto ist bereit!',
    'signup.finalized.description': 'In Kürze müssen Sie die E-Mail mit nützlichen Anweisungen erhalten. Bitte lesen Sie diese E-Mail und melden Sie sich mit Ihrem Benutzernamen und Passwort beim Webpanel an.',
    'signup.token.invalid.title': 'Der Token ist ungültig oder bereits verwendet',
    'signup.token.invalid.description': 'Bitte versuchen Sie erneut, sich anzumelden, um ein neues Konto zu erstellen!',

    'header.label.username': 'Benutzername',

    'summary.devices.status': 'Gerätestatus',
    'summary.devices.active': 'Aktiv',
    'summary.devices.idle': 'Leerlauf',
    'summary.devices.offline': 'Offline',
    'summary.devices.enrollment': 'Registrierung',
    'summary.devices.enrolled.total': 'Gesamtzahl',
    'summary.devices.enrolled.earlier': 'Früher registriert',
    'summary.devices.enrolled.monthly': 'Letzte 30 Tage',
    'summary.devices.installation.status': 'Anwendungsstatus',
    'summary.devices.installation.completed': 'Abgeschlossen',
    'summary.devices.version.mismatch': 'Versionskonflikt',
    'summary.devices.installation.failed': 'Fehlgeschlagen',
    'summary.devices.enrolled.lastyear': 'Letzte 12 Monate',

    'devices.group.options.all': 'Alle Gruppen',
    'devices.configuration.options.all': 'Alle Konfigurationen',
    'devices.permissions.all': 'Alle Berechtigungen werden erteilt',
    'devices.permissions.not.as.device.admin': '- Die Anwendung ist nicht als Geräteadministrator installiert',
    'devices.permissions.window.overlap.prohibited': '- Eine Überlagerung über anderen Fenstern ist nicht verfügbar',
    'devices.permissions.history.access.prohibited': '- Der Zugriff auf den Nutzungsverlauf ist nicht konfiguriert',
    'devices.unknown': 'Unbekannt',
    'devices.model.unknown': 'Unbekannt',
    'devices.date.unknown': 'Unbekannt',
    'devices.date.format': 'dd/MM/yy HH:mm',
    'devices.app.installed': '- ${applicationName}: Installiert.',
    'devices.app.not.installed': '- ${applicationName}: Nicht installiert.',
    'devices.app.version.available': ', verfügbar ${applicationVersion}',
    'devices.app.installed.and.version.available': '- ${applicationName}: installiert ${applicationInstalledVersion}, verfügbar ${applicationVersionAvailable}',
    'devices.app.needs.removal': '${applicationVersion}, Entfernung ist erforderlich',
    'devices.no.data': 'Das Gerät hat keine Daten übertragen',
    'devices.settings.conformance.broken': 'Nicht übereinstimmende Einstellungen: (${serverData})',
    'devices.file.installed': '- ${file}: installiert',
    'devices.file.not.installed': '- ${file}: nicht installiert.',
    'devices.file.lastUpdate.differs': '- ${file}: Unterschied in der Änderungszeit ${diff} min',

    'button.apply': 'Anwenden',
    'button.gps.on': 'GPS aktivieren',
    'button.wifi.on': 'WLAN aktivieren',
    'button.notify.update': 'Bei Aktualisierung benachrichtigen',
    'button.app.settings': 'Anwendungseinstellungen',
    'button.ok': 'OK',
    'button.help': 'Hilfe',
    'button.new.app': 'Neue Anwendung',
    'button.new.app.version': 'Neue Version',
    'button.upgrade': 'Aktualisierung',
    'button.renew.config': 'Update auf Geräten',
    'button.common': 'Gemeinsame Anwendung',
    'button.close': 'Schließen',
    'button.yes': 'Ja',
    'button.cancel': 'Abbrechen',
    'button.save': 'Speichern',
    'button.save.and.close': 'Speichern und Schließen',
    'button.more': 'Mehr ...',
    'button.cleanup': 'Löschen',
    'button.add': 'Hinzufügen',
    'button.add.icon': 'Neues Symbol',
    'button.search': 'Suchen',
    'button.export': 'Export',
    'button.change': 'Ändern',
    'button.copy': 'Kopieren',
    'button.qrcode': 'QR code',
    'button.application': 'Anwendung',
    'button.change.password': 'Ändere Passwort',
    'button.set.configuration': 'Konfiguration einstellen',
    'button.set.group': 'Gruppe einstellen',
    'button.group.action': 'Gruppenaktion',
    'button.delete': 'Löschen',
    'button.login': 'Login',
    'button.renew.code': 'Erneuern',
    'button.configurations': 'Konfigurationen',
    'button.set.configurations': 'Konfigurationen angeben',
    'button.edit.versions': 'Versionen',
    'button.edit': 'Bearbeiten',
    'button.change.common.app': 'Gemeinsame Anwendung ändern',
    'button.delete.common.app': 'Gemeinsame Anwendung löschen',
    'button.turn.common.app': 'Auf gemeinsame ändern',
    'button.hints.enable': 'Tooltips anzeigen',
    'button.hints.disable': 'Tooltips verbergen',
    'button.show.password': 'Password anzeigen',
    'button.hide.password': 'Password verbergen',

    'question.impersonate.user': 'Melden Sie sich als Administrator der Organisation "${customerName}" bei der Anwendung an?',
    'question.change.user': 'Melden Sie sich als Benutzer "${userName}" bei der Anwendung an?',
    'question.delete.file': 'Datei "${fileName} löschen"?',
    'question.delete.customer': 'Organisation "${customerName}" löschen?',
    'question.delete.user': 'Benutzer "${username}" löschen?',
    'question.delete.application': 'Anwendung "${applicationName}" löschen?',
    'question.delete.application.version': 'Version "${applicationVersion}" löschen?',
    'question.delete.configuration': 'Konfiguration "${configurationName}" löschen?',
    'question.delete.group': 'Gruppe "${groupName}" löschen?',
    'question.delete.role': 'Rolle "${roleName}" löschen?',
    'question.delete.icon': 'Das Symbol "${iconName}" löschen?',
    'question.delete.device.bulk': 'Ausgewählte Geräte löschen?',
    'question.delete.device': 'Geät mit der Nummer "${deviceNumber}" löschen?',
    'question.exit.without.saving': 'Änderungen werden nicht gespeichert. Wie auch immer, diese Seite verlassen?',
    'question.turn2common.application': 'Teile die Anwendung "${applicationName}"?',
    'question.app.upgrade': 'Anwendung "${v1}" auf die neueste Version für Konfiguration "${v2}" aktualisieren?',

    'error.application.setting.empty.app': 'Anwendung denfinieren',
    'error.application.setting.empty.name': 'Namen einfügen',
    'error.application.setting.empty.value': 'Geben Sie einen Wert an',

    'error.icon.dimension.invalid': 'Das Symbol muss quadratisch sein',
    'error.icon.empty.name': 'Namen des Symbols eingeben',
    'error.icon.empty.file': 'Symbol-Datei hochladen',
    'error.application.version.pkg.mismatch': 'Die Paket-ID der Datei (${actual}) entspricht nicht der Anwendung (${expected}).',
    'error.empty.user': 'Wählen Sie einen Benutzer',
    'error.empty.user.name': 'Geben Sie den Benutzernamen ein',
    'error.empty.user.login': 'Füllen Sie das Benutzer-Login aus',
    'error.empty.user.role': 'Wählen Sie die Benutzerrolle aus',
    'error.empty.password': 'Neues Passwort eingeben',
    'error.empty.password.confirm': 'Neues Passwort bestätigen',
    'error.user.not.found': 'Benutzer wurde nicht gefunden',
    'error.email.not.configured': 'E-Mail nicht konfiguriert',
    'error.email.not.found': 'Benutzer-E-Mail nicht festgelegt',
    'error.empty.group.name': 'Geben Sie den Gruppennamen ein',
    'error.empty.configuration': 'Geben Sie die Konfiguration an',
    'error.empty.configuration.name': 'Füllen Sie den Konfigurationsnamen aus',
    'error.empty.configuration.password': 'Geben Sie das Passwort an',
    'error.empty.configuration.contentApp': 'Keine Inhaltsanwendung angegeben',
    'error.empty.group': 'Fügen Sie ein Gerät einer oder mehreren Gruppen hinzu',
    'error.invalid.character': 'Die Gerätenummer darf keine Symbole / ? & enthalten.',
    'error.invalid.configuration.mainApp': 'In den MDM-Einstellungen wird die falsche Hauptanwendung verwendet',
    'error.invalid.configuration.contentApp': 'Ungültige Inhaltsanwendung, die in den MDM-Einstellungen verwendet wird',
    'error.mismatch.password': 'Passwort und Passwortbestätigung müssen übereinstimmen',
    'error.empty.customer.name': 'Geben Sie den Namen der Organisation ein',
    'error.empty.customer.prefix': 'Geben Sie das Präfix für die Gerätenummer ein',
    'error.empty.customer.device.configuration': 'Gerätekonfiguration auswählen',
    'error.empty.customer.duplicate.prefix': 'Präfix wird bereits verwendet',
    'error.duplicate.customer.name': 'Die Organisation mit dem eingegebenen Namen existiert bereits. Versuchen Sie es mit einem anderen Namen. ',
    'error.duplicate.group.name': 'Die Gruppe mit dem eingegebenen Namen existiert bereits. Versuchen Sie es mit einem anderen Namen. ',
    'error.duplicate.configuration.name': 'Die Konfiguration mit dem eingegebenen Namen ist bereits vorhanden. Versuchen Sie es mit einem anderen Namen. ',
    'error.duplicate.device.number': 'Ein Gerät mit dieser Nummer existiert bereits',
    'error.internal.server': 'Interner Serverfehler',
    'error.permission.denied': 'Keine Ausführungsrechte',
    'error.request.failure': 'Fehler anfordern',
    'error.configuration.device.use': 'Diese Konfiguration kann nicht gelöscht werden, sie wird auf Geräten verwendet. Gehen Sie zuerst zu "Geräte", suchen Sie die Geräte mit dieser Konfiguration und ändern Sie ihre Einstellungen. ',
    'error.invalid.system.update.time': 'Ungültiges Installationsintervall',
    'error.size.limit.exceeded': 'Speicherlimit überschritten',

    'error.configuration.file.empty.name': 'Geben Sie einen Dateinamen ein',
    'error.configuration.file.empty.desc': 'Geben Sie eine Dateibeschreibung an',
    'error.configuration.file.empty.path': 'Geben Sie den Pfad auf dem Gerät an',
    'error.configuration.file.empty.file': 'Bitte laden Sie eine Datei hoch.',
    'error.configuration.file.empty.url': 'Bitte geben Sie die Datei-URL an.',

    'error.notfound.device': 'Gerät nicht gefunden',
    'error.duplicate.device': 'Ein Gerät mit derselben Nummer existiert bereits',
    'error.duplicate.login': 'Ein solches Login wird bereits verwendet',
    'error.duplicate.email': 'Ein Benutzer mit dieser E-Mail existiert bereits',
    'error.duplicate.group': 'Eine gleichnamige Gruppe existiert bereits',
    'error.duplicate.application': 'Eine Anwendung mit dieser Paket-ID und Version existiert bereits',
    'error.recent.application.version.exists': 'Neuere Anwendungsversion existiert',
    'error.common.application.access.prohibited': 'Die Verwaltung der allgemeinen Anwendungen ist nur dem Superadministrator gestattet',
    'error.application.config.reference.exists': 'Die Anwendung wird in Konfigurationen verwendet und kann nicht gelöscht werden',
    'error.application.version.deletion.prohibited': 'Die Version ist entweder eindeutig oder wird in Konfigurationen verwendet und kann nicht gelöscht werden',
    'error.duplicate.file': 'Eine gleichnamige Datei existiert bereits',
    'error.used.file': 'Diese Datei wird verwendet',
    'error.version.exists': 'Die gleiche Version dieser App existiert bereits',
    'error.duplicate.configuration': 'Eine Konfiguration mit diesem Namen existiert bereits',
    'error.duplicate.role.name': 'Eine Rolle mit demselben Namen existiert bereits',
    'error.empty.role.name': 'Bitte geben Sie den Rollennamen an',
    'error.duplicate.icon.name': 'Ein Symbol mit demselben Namen existiert bereits',
    'error.notfound.customer.admin': 'Administratorkonto nicht gefunden',
    'error.apk.file.required': 'Wählen Sie die Datei mit der Erweiterung .apk oder .xapk aus',
    'error.apk.parse': 'Beim Parsen der Datei ist ein Fehler aufgetreten',
    'error.package.not.match': 'Paket-ID stimmt nicht überein',
    'error.empty.app.name': 'Anwendungsnamen eingeben',
    'error.empty.app.pkg': 'Geben Sie die Paket-ID ein',
    'error.empty.app.url': 'Geben Sie die URL ein',
    'error.empty.app.iconText': 'Geben Sie den Symboltext ein',
    'error.empty.app.version': 'Geben Sie die Version der Anwendung ein',
    'error.notempty.group': 'Diese Gruppe umfasst ein oder mehrere Geräte. Sie können es nicht entfernen. ',
    'error.file.empty': 'Neue Datei hochladen',
    'error.file.deletion': 'Fehler beim Löschen der Datei auf dem Server',
    'error.file.save': 'Fehler beim Speichern der Datei auf dem Server',
    'error.password.wrong': 'Ungültiges Passwort',
    'error.password.empty': 'Passwort nicht angegeben',
    'error.password.weak': 'Schwache Passwortqualität',
    'error.params.missing': 'Fehlende Parameter:',
    'error.empty.push.options': 'Bitte wählen Sie die Push-Benachrichtigungsoptionen',
    'error.app.name.exists': 'Eine andere Anwendung mit diesem Namen existiert bereits. Bitte geben Sie einen eindeutigen Namen an.',

    'table.filtering.check.all': 'Alle auswählen',
    'table.filtering.uncheck.all': 'Alle abbrechen',
    'table.filtering.suffix.configuration': 'Konfigurationen',
    'table.filtering.suffix.group': 'groups',
    'table.filtering.suffix.permission': 'Berechtigungen',
    'table.filtering.no.selected.configuration': 'Keine Konfigurationen ausgewählt',
    'table.filtering.no.selected.group': 'Keine ausgewählten Gruppen',
    'table.filtering.no.selected.permission': 'Keine Berechtigungen ausgewählt',

    'success.admin.created': 'Administratorkonto erstellt:\n ${adminCredentials}',
    'success.uploading.file': 'Die Datei wird auf den Server hochgeladen ...',
    'success.loading.devices': 'Geräteliste laden ...',
    'success.loading.customer': 'Laden von Kundendaten ...',
    'success.file.uploaded': 'Datei erfolgreich hochgeladen.',
    'success.file.uploaded.need.save': 'Datei erfolgreich hochgeladen. Geben Sie den relativen Pfad ein und klicken Sie auf "Speichern". ',
    'success.settings.design.saved': 'Designeinstellungen erfolgreich gespeichert',
    'success.settings.common.saved': 'Einstellungen der Gerätetabelle erfolgreich gespeichert',
    'success.settings.saved': 'Einstellungen erfolgreich gespeichert',
    'success.settings.apiKey.saved': 'API-Schlüssel erfolgreich gespeichert',
    'success.settings.hints.enabled': 'Hinweise aktiviert',
    'success.settings.hints.disabled': 'Hinweise deaktiviert',
    'success.configuration.saved': 'Konfiguration erfolgreich gespeichert',
    'success.operation.completed': 'Operation erfolgreich abgeschlossen',
    'success.plugins.disabled': 'Einstellungen erfolgreich gespeichert',
    'success.config.update.notification': 'Konfigurationsaktualisierungsbefehl wurde an Geräte gesendet',
    'success.config.update.device.app.settings.notification': 'Der Befehl zum Aktualisieren der Anwendungseinstellungen wurde an das Gerät gesendet.',

    'form.icon.title': 'Symbol',
    'form.icon.name': 'Name',
    'form.icon.file': 'Datei',

    'configuration.add.warning': 'Möchten Sie wirklich eine leere Konfiguration erstellen? Sie müssen alle erforderlichen System-Apps manuell hinzufügen. Kopieren und ändern Sie stattdessen eine vorhandene Konfiguration.',
    'configuration.remove.warning': 'Möchten Sie die letzte Konfiguration wirklich entfernen? Sie verlieren Informationen darüber, welche System-Apps erforderlich sind.',
    'form.configuration.title': 'Konfiguration',
    'form.configuration.title.typical': 'Typische Konfiguration',
    'form.configuration.settings.auto.update': 'Auto-Update',
    'form.configuration.settings.system.update': 'System Update',
    'form.configuration.settings.system.update.default': 'Standard',
    'form.configuration.settings.system.update.immediate': 'Sofort',
    'form.configuration.settings.system.update.scheduled': 'Geplant',
    'form.configuration.settings.system.update.postponed': 'Aufgeschoben',
    'form.configuration.settings.system.update.time': 'Installationszeit',
    'form.configuration.settings.system.update.time.from': 'von:',
    'form.configuration.settings.system.update.time.to': 'bis:',
    'form.configuration.settings.system.schedule.app.update': 'App-Update planen',
    'form.configuration.settings.system.app.update.time': 'App-Update-Zeit',
    'form.configuration.settings.download.updates': 'Inhalte herunterladen',
    'form.configuration.settings.download.updates.unlimited': 'Ohne Begrenzung',
    'form.configuration.settings.download.updates.limited': '3 Versuche im Mobilfunknetz',
    'form.configuration.settings.download.updates.wifi': 'Nur über WLAN',
    'form.configuration.settings.block.status.bar': 'Statusleisten-Sperre',
    'form.configuration.settings.block.status.bar.hint': 'Diese Einstellung ist veraltet und funktioniert auf Android 6 und niedriger. Um die Statusleiste bei neueren Android-Versionen zu sperren, verwenden Sie den Kiosk-Modus (MDM-Einstellungen).',
    'form.configuration.settings.mdm.kiosk.mode': 'Kiosk-Modus',
    'form.configuration.settings.mdm.app.main': 'MDM-Anwendung',
    'form.configuration.settings.mdm.component.event.receiver': 'Admin-Empfängerklasse',
    'form.configuration.settings.mdm.component.event.receiver.placeholder': 'Sollte com.hmdm.launcher.AdminReceiver sein',
    'form.configuration.settings.mdm.component.wifi.ssid': 'WiFi SSID',
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'WiFi-SSID registrieren - leer lassen, manuell eingeben',
    'form.configuration.settings.mdm.component.wifi.password': 'WiFi password',
    'form.configuration.settings.mdm.component.wifi.password.placeholder': 'WiFi-Pass für Registrierung - leer lassen, manuell eingeben',
    'form.configuration.settings.mdm.component.wifi.security': 'WiFi-Sicherheitstyp',
    'form.configuration.settings.mdm.component.wifi.notice': 'Hinweis: Diese WLAN-Einstellungen gelten nur für die Erstregistrierung!',
    'form.configuration.settings.mdm.component.server.url': 'Neue Server-URL',
    'form.configuration.settings.mdm.component.server.url.placeholder': 'Wird für die Migration auf einen neuen MDM-Server verwendet',
    'form.configuration.settings.mdm.app.content': 'Inhaltsanwendung',
    'form.configuration.settings.mdm.kiosk.home': 'Home-Schaltfläche aktivieren',
    'form.configuration.settings.mdm.kiosk.recents': 'Schaltfläche "Letzte" aktivieren',
    'form.configuration.settings.mdm.kiosk.notifications': 'Benachrichtigungen aktivieren',
    'form.configuration.settings.mdm.kiosk.system.info': 'Statusleisteninformationen aktivieren',
    'form.configuration.settings.mdm.kiosk.keyguard': 'Bildschirmsperre aktivieren',
    'form.configuration.settings.mdm.kiosk.lock.buttons': 'Die Einschalttaste sperren',
    'form.configuration.settings.mdm.mobile.enrollment': 'Mit mobilen Daten anmelden',
    'form.configuration.settings.mdm.encrypt.device': 'Verschlüsselung des Gerätespeichers',
    'form.configuration.settings.mdm.lock.safe.settings': 'Sperre sichere Einstellungen (WiFi, GPS usw.)',
    'form.configuration.settings.mdm.permissive': 'Entsperrter Modus',
    'form.configuration.settings.mdm.kiosk.exit': 'Kiosk-Ausgangsschaltfläche',
    'form.configuration.settings.mdm.kiosk.screen': 'Bildschirm immer an',
    'form.configuration.settings.mdm.allowed.classes': 'Zulässige Aktivitäten',
    'form.configuration.settings.mdm.allowed.classes.placeholder': 'Durch Kommas getrennte Klassen, z. B.: com.android.settings.homepage.SettingsHomepageActivity',
    'form.configuration.settings.mdm.restrictions': 'Einschränkungen',
    'form.configuration.settings.mdm.restrictions.placeholder': 'Durch Kommas getrennte MDM-Einschränkungen, z.B.: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.launcher': 'Starter-URL überschreiben',
    'form.configuration.settings.mdm.launcher.placeholder': 'Alternative Start-URL für die Registrierung in geschlossenen Netzwerken',
    'form.configuration.settings.mdm.misc': 'Andere QR-Code-Einträge',
    'form.configuration.settings.mdm.misc.placeholder': 'Kommagetrennte Einträge, z. B.:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url': 'QR-Code-URL',
    'form.configuration.settings.mdm.hint': 'Hauptanwendung und Komponente auswählen',
    'form.configuration.apps.search.label': 'Suche nach:',
    'form.configuration.apps.sort.label': 'Sort:',
    'form.configuration.apps.sort.byname': 'Nach Namen',
    'form.configuration.apps.sort.bypkg': 'Nach ID',
    'form.configuration.apps.no.apk': 'keine',
    'form.configuration.apps.show.systeam.apps': 'Systemanwendungen anzeigen',
    'form.configuration.apps.action.select': '(auswählen)',
    'form.configuration.apps.action.install': 'Installieren',
    'form.configuration.apps.action.prohibit': 'Blockieren',
    'form.configuration.apps.action.not.install': 'Nicht Installieren',
    'form.configuration.apps.action.delete': 'Löschen',
    'form.configuration.apps.action.permit': 'Erlauben',
    'form.configuration.apps.label.inherit': 'Vererbt',
    'form.configuration.apps.label.show': 'Zeigen',
    'form.configuration.apps.label.not.show': 'Verbergen',
    'form.configuration.apps.edit.details': 'Zusätzliche Parameter',
    'form.configuration.apps.keycode': 'Schlüsselcode',
    'form.configuration.apps.bottom': 'In der unteren Zeile anzeigen',
    'form.configuration.apps.long.tap': 'Einstellungen durch langes Tippen',
    'form.configuration.apps.hint': 'Hinweis: Um die Verknüpfung der App mit der Konfiguration aufzuheben, wählen Sie die Aktion "Blockieren" oder "Nicht installieren".',
    'form.configuration.settings.design.use.default': 'Standarddesign verwenden',
    'form.configuration.settings.design.color.background': 'Hintergrundfarbe',
    'form.configuration.settings.design.color.background.placeholder': 'Farbe auswählen',
    'form.configuration.settings.design.color.app.names': 'Farbe der Anwendungsnamen',
    'form.configuration.settings.design.color.app.names.placeholder': 'Farbe auswählen',
    'form.configuration.settings.design.background.image.url': 'URL des Hintergrundbildes',
    'form.configuration.settings.design.background.image.url.placeholder': 'Geben Sie die URL des Hintergrundbilds ein',
    'form.configuration.settings.design.icon': 'Symbolgröße',
    'form.configuration.settings.design.icon.small': 'Klein',
    'form.configuration.settings.design.icon.medium': 'Durchschnitt (+ 20%)',
    'form.configuration.settings.design.icon.large': 'Groß (+ 40%)',
    'form.configuration.settings.design.desktop.header': 'Desktop-Titel',
    'form.configuration.settings.design.desktop.header.no': 'Nein',
    'form.configuration.settings.design.desktop.header.deviceid': 'Geräte-ID',
    'form.configuration.settings.design.desktop.header.description': 'Beschreibung',
    'form.configuration.settings.design.desktop.header.custom': 'Benutzerdefinierte Vorlage',
    'form.configuration.settings.design.desktop.header.hint': 'Stellen Sie sicher, dass dieser Parameter an Geräte gesendet wird (Einstellungen - Allgemeine- und Spracheinstellungen)',
    'form.configuration.settings.design.desktop.header.template': 'Vorlage',
    'form.configuration.settings.design.desktop.header.template.placeholder': 'Variablen verwenden',
    'form.configuration.settings.design.display.status': 'Uhrzeit und Batteriestatus anzeigen',
    'form.configuration.settings.design.upload': 'Hochladen',
    'form.configuration.settings.common.name': 'Name',
    'form.configuration.settings.common.name.placeholder': 'Geben Sie den Konfigurationsnamen ein',
    'form.configuration.settings.common.desc': 'Beschreibung',
    'form.configuration.settings.common.desc.placeholder': 'Geben Sie die Konfigurationsbeschreibung ein',
    'form.configuration.settings.common.admin.pwd': 'Entsperrkennwort',
    'form.configuration.settings.common.admin.pwd.placeholder': 'Geben Sie das Entsperrkennwort ein',
    'form.configuration.settings.common.gps': 'GPS',
    'form.configuration.settings.common.gps.any': 'Beliebig',
    'form.configuration.settings.common.gps.off': 'Disabled',
    'form.configuration.settings.common.gps.on': 'Aktiviert',
    'form.configuration.settings.common.bluetooth': 'Bluetooth',
    'form.configuration.settings.common.wifi': 'Wi-Fi',
    'form.configuration.settings.common.mobile.data': 'Mobile Daten',
    'form.configuration.settings.common.usb.storage': 'USB-Speicher blockieren',
    'form.configuration.settings.common.brightness': 'Helligkeit verwalten',
    'form.configuration.settings.common.brightness.none': 'Nicht verwalten',
    'form.configuration.settings.common.brightness.auto': 'Auto',
    'form.configuration.settings.common.brightness.manual': 'Manuell',
    'form.configuration.settings.common.brightness.value': 'Bildschirmhelligkeit',
    'form.configuration.settings.common.timeout': 'Bildschirm-Timeout verwalten',
    'form.configuration.settings.common.timeout.value': 'Bildschirm-Timeout (s)',
    'form.configuration.settings.common.volume.block': 'Lautstärke sperren',
    'form.configuration.settings.common.volume.manage': 'Gerätevolumen verwalten',
    'form.configuration.settings.common.volume.value': 'Gerätevolumen',
    'form.configuration.settings.common.timezone.mode': 'Zeitzone verwalten',
    'form.configuration.settings.common.timezone.mode.default': 'Nicht verwalten',
    'form.configuration.settings.common.timezone.mode.auto': 'Auto',
    'form.configuration.settings.common.timezone.mode.manual': 'Manuell',
    'form.configuration.settings.common.timezone': 'Zeitzone',
    'form.configuration.settings.common.timezone.placeholder': 'z.B. Europe / Vienna ',
    'form.configuration.settings.common.timezone.link': 'Liste der Zeitzonen',
    'form.configuration.settings.common.no.network.warning': 'ACHTUNG! Schalten Sie nicht alle Verbindungskanäle aus, sonst können Sie keine Geräte mehr verwalten!',
    'form.configuration.settings.common.autostart.foreground': 'Apps im Vordergrund starten',
    'form.configuration.settings.request.updates': 'Standortverfolgung',
    'form.configuration.settings.request.updates.donottrack': 'Kein aktives Tracking (App-Standortdaten von Drittanbietern verwenden)',
    'form.configuration.settings.request.updates.gps': 'Standort per GPS verfolgen',
    'form.configuration.settings.request.updates.wifi': 'Standort über WLAN verfolgen (Google-Dienste müssen aktiviert sein)',
    'form.configuration.settings.request.updates.prompt.gps': 'Um den Standort per GPS zu verfolgen, müssen Sie GPS aktivieren',
    'form.configuration.settings.request.updates.prompt.wifi': 'Um den Standort über Wi-Fi zu verfolgen, müssen Sie Wi-Fi aktivieren',
    'form.configuration.settings.revoke.location.permission': 'Keine Standortberechtigung',
    'form.configuration.settings.revoke.location.permission.hint': 'Wenn gesetzt, wird die Standortberechtigung dem MDM-Agenten nicht erteilt und er konnte den Gerätestandort nicht verfolgen',
    'form.configuration.settings.apps.permissions': 'Berechtigungen für andere Apps',
    'form.configuration.settings.apps.permissions.grant': 'Alle Berechtigungen automatisch gewähren',
    'form.configuration.settings.apps.permissions.ask.location': 'Alle automatisch gewähren, Benutzer nach der Standortberechtigung fragen',
    'form.configuration.settings.apps.permissions.deny.location': 'Alle automatisch gewähren, Standortberechtigung nicht erteilen',
    'form.configuration.settings.apps.permissions.ask.all': 'Benutzer nach allen Berechtigungen fragen',
    'form.configuration.settings.push.options': 'Push-Benachrichtigungen',
    'form.configuration.settings.push.options.mqtt.worker': 'MQTT-Protokoll (Batterie sparen)',
    'form.configuration.settings.push.options.mqtt.alarm': 'MQTT-Protokoll',
    'form.configuration.settings.push.options.polling': 'HTTP-Polling',
    'form.configuration.settings.push.options.mqtt.worker.hint' : 'Liefert Push-Nachrichten sofort, wenn das Gerät aktiv ist. Im Schlafmodus können sich die Nachrichten jedoch um bis zu einige Stunden verzögern. Verwenden Sie diese Option nicht auf eigenständigen Geräten. MQTT verwendet den TCP-Port 31000 und aktiviert ihn in Ihrer Firewall.',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT ist ein leichtes Protokoll, das nur minimale Ressourcen verbraucht. MQTT verwendet TCP-Port 31000. Aktivieren Sie ihn in Ihrer Firewall.',
    'form.configuration.settings.push.options.polling.hint' : 'Long Polling hält eine HTTP-Verbindung aufrecht, die mehr Serverressourcen verbrauchen kann. Es sind keine anderen TCP-Ports als HTTP(S) erforderlich.',
    'form.configuration.settings.push.options.keepalive' : 'Keep-Alive-Zeit',
    'form.configuration.settings.minute.1' : '1 Minute',
    'form.configuration.settings.minutes.2' : '2 Minuten',
    'form.configuration.settings.minutes.3' : '3 Minuten',
    'form.configuration.settings.minutes.5' : '5 Minuten',
    'form.configuration.settings.minutes.10' : '10 Minuten',
    'form.configuration.settings.minutes.15' : '15 Minuten',
    'form.configuration.settings.password.mode': 'Passwortanforderungen',
    'form.configuration.settings.password.mode.any': 'Beliebig',
    'form.configuration.settings.password.mode.present': 'Passwort präsentiert',
    'form.configuration.settings.password.mode.easy': 'Einfach (mindestens 6 Symbole)',
    'form.configuration.settings.password.mode.moderate': 'Moderat (8+ Symbole, Buchstaben und Ziffern)',
    'form.configuration.settings.password.mode.strong': 'Stark (8+, Groß- und Kleinbuchstaben, Ziffern, Zeichen)',
    'form.configuration.settings.show.wifi': 'WLAN-Einstellungen bei Verbindungsfehler',
    'form.configuration.settings.use.default.launcher': 'Hintergrundmodus',
    'form.configuration.settings.use.default.launcher.hint': 'Ersetzt keinen Systemstarter, sondern führt nur MDM-Dienste im Hintergrund aus. Im Kioskmodus nicht empfohlen.',
    'form.configuration.settings.disable.screenshots': 'Bildschirmaufnahme sperren',
    'form.configuration.settings.orientation': 'Ausrichtung sperren',
    'form.configuration.settings.orientation.none': 'Nicht sperren',
    'form.configuration.settings.orientation.portrait': 'Hochformat',
    'form.configuration.settings.orientation.landscape': 'Querformat',
    'form.configuration.settings.files.default.path': 'Standardpfad auf dem Gerät',
    'form.configuration.files.search.label': 'Suche:',
    'form.configuration.files.action.upload': 'Hochladen',
    'form.configuration.files.action.remove': 'Entfernen',
    'form.configuration.files.variables': 'Variabler Inhalt',
    'form.configuration.files.variables.hint': 'Die Zeichenfolgen DEVICE_NUMBER, IMEI, CUSTOM* werden durch ihre Werte ersetzt',

    'form.configuration.file.name': 'Dateiname',
    'form.configuration.file.select': 'Datei auswählen',
    'form.configuration.file.create': '(Neue Datei erstellen)',
    'form.configuration.file.description': 'Dateibeschreibung',
    'form.configuration.file.description.placeholder': 'Optional',
    'form.configuration.file.path': 'Pfad auf Gerät',
    'form.configuration.file.path.placeholder': 'Kein Pfad zum Laufwerk, z.B. /my-app/image.jpg',
    'form.configuration.file.url': 'URL',
    'form.configuration.file.url.placeholder': 'Für externen Ressourcen gehostete Dateien',
    'form.configuration.file.file': 'Datei',
    'form.configuration.file.action': 'Aktion',
    'form.configuration.file.action.prompt.1': 'Hochladen',
    'form.configuration.file.action.prompt.2': 'Entfernen',
    'form.configuration.file.remove.prompt.1': 'Diese Datei wird nicht mehr mit Geräten synchronisiert',
    'form.configuration.file.remove.prompt.2': 'Datei vom Server entfernen',

    'form.password.title': 'Passwort ändern',
    'form.password.label.user': 'Benutzer',
    'form.password.label.password.new': 'Neues Passwort',
    'form.password.label.password.new.placeholder': 'Geben Sie ein neues Passwort ein',
    'form.password.label.password.confirm': 'Überprüfen',
    'form.password.label.password.confirm.placeholder': 'Geben Sie das neue Passwort erneut ein',
    'form.password.length': 'Minimale Länge: ${length}. ',

    'form.application.type': 'Art',
    'form.application.type.option.web': 'Webseite',
    'form.application.type.option.app': 'Anwendung',
    'form.application.type.option.intent': 'Systemaktion',
    'form.application.intent': 'Aktion',
    'form.application.intent.placeholder': 'Eine Aktion auswählen',
    'form.application.url.hint': 'Verwenden Sie file:///storage/emulated/0/..., um Links zu lokalen Dateien und Ordnern zu erstellen',
    'form.application.pkg': 'Paket-ID',
    'form.application.from.file': 'aus Datei ermittelt',
    'form.application.pkg.title': 'Die Paket-ID wird automatisch ermittelt, wenn Sie die APK-Datei hochladen. Die manuell eingegebene Paket-ID ist nur für System-Apps erforderlich.',
    'form.application.pkg.placeholder': 'Z.B., com.android.camera',
    'form.application.disabled.arch': 'Versionsspezifisch',
    'form.application.disabled.arch.title': 'Um APKs für verschiedene CPU-Architekturen hinzuzufügen, klicken Sie auf "Hinzufügen" oder öffnen Sie die Liste der App-Versionen',
    'form.application.arch': 'Native Code',
    'form.application.arch.title': 'Einige Apps enthalten Code, der für bestimmte CPU-Architekturen optimiert ist. In diesem Fall müssen Sie zwei APKs hochladen (für Architekturen von armeabi-v7a und arm64-v8a).',
    'form.application.arch.universal': 'Keine (universelle APK)',
    'form.application.arch.armeabi': 'Native Code für armeabi-v7a',
    'form.application.arch.arm64': 'Native code für arm64-v8a',
    'form.application.arch.no.split': 'Universelle APK',
    'form.application.arch.split': 'Geteilte APK',
    'form.application.arch.warning': 'Dieses APK ist nur für ${arch} optimiert. Es wird empfohlen, ein anderes APK hochzuladen, das für einen anderen CPU-Bogen optimiert ist. Um dieses APK auf allen Geräten zu verwenden, wählen Sie "Universelle APK".',
    'form.application.arch.success': 'Diese App enthält APKs für beide CPU-Architekturen',
    'form.application.version.exists': 'APK für diese Version existiert bereits',
    'form.application.url.armeabi': 'URL für armeabi-v7a',
    'form.application.url.arm64': 'URL für arm64-v8a',
    'form.application.name': 'Anwendungsname',
    'form.application.name.title': 'Sie sehen den App-Namen in der Liste. Wir empfehlen die Verwendung eindeutiger und informativer Namen.',
    'form.application.name.placeholder': 'Zum Beispiel Kamera (Android)',
    'form.application.version': 'Version',
    'form.application.version.placeholder': '0 für System-Apps',
    'form.application.version.title': 'Die Paketversion wird automatisch ermittelt, wenn Sie die APK-Datei hochladen. Setzen Sie es für System-Apps auf 0.',
    'form.application.version.code': 'Versionscode',
    'form.application.version.code.exists': 'Eine Version mit demselben Code existiert bereits. Bitte melden Sie dieses Problem den App-Entwicklern.',
    'form.application.system': 'System',
    'form.application.system.title': 'System-Apps sind auf einem Gerät vorinstalliert und erfordern keine URL oder Datei. Setzen Sie dieses Flag nur, wenn Sie ein bestimmtes Systempaket aktivieren müssen.',
    'form.application.run.after.install': 'Nach der Installation ausführen',
    'form.application.run.after.install.title': 'Anwendungen mit Hintergrunddiensten müssen mindestens einmal im Vordergrund gestartet werden.',
    'form.application.run.at.boot': 'Beim Booten ausführen',
    'form.application.run.at.boot.title': 'Setzen Sie dieses Flag, wenn Sie die App nach dem Start im Vordergrund ausführen müssen. Dieses Flag wirkt sich nicht auf Hintergrundprozesse aus.',
    'form.application.url': 'URL',
    'form.application.url.title': 'Die URL sollte nur eingegeben werden, wenn Ihre App auf einer externen Ressource gehostet wird. Es wird empfohlen, eine APK-Datei mithilfe eines Felds unten hochzuladen.',
    'form.application.url.disabled': 'Die URL wird für jede Version eingerichtet. Um die URL zu ändern, schließen Sie dieses Fenster und klicken Sie auf das Symbol "Versionen".',
    'form.application.file': 'Datei',
    'form.application.auto.update': 'Auto-Update',
    'form.application.auto.update.title': 'Setzen Sie dieses Flag, um alle Konfigurationen zu aktualisieren, in denen die App installiert ist. Nur verwenden, wenn Sie 100 % sicher sind, dass die App stabil läuft.',
    'form.application.showLabel': 'Symbol anzeigen',
    'form.application.showLabel.title': 'Dieses Flag gibt an, ob das App-Symbol im Launcher angezeigt werden soll. Diese Option kann in der Konfiguration überschrieben werden.',
    'form.application.use.kiosk': 'Im Kiosk Browser öffnen',
    'form.application.use.kiosk.title': 'Setzen Sie dieses Flag, wenn Sie eine Webseite im Kiosk-Browser öffnen möchten, ohne die Adresse ändern zu können',
    'form.application.iconText': 'Symboltext',
    'form.application.iconText.placeholder': '(Standard)',
    'form.application.versions.title': 'Versionen der Anwendung',
    'form.application.icon': 'Icon',
    'form.application.icon.default': '(Standard)',
    'form.application.icon.add': 'Symbol hinzufügen',

    'form.application.setting.app': 'Anwendung',
    'form.application.setting.app.placeholder': 'Wählen Sie eine Anwendung aus',
    'form.application.setting.name': 'Eigenschaft',
    'form.application.setting.value': 'Wert',
    'form.application.setting.comment': 'Kommentar',
    'form.application.setting.type': 'Type',
    'form.application.setting.readonly': 'Ändert sich nicht auf dem Gerät',

    'form.application.configurations.app': 'Anwendung',
    'form.application.configurations.configs': 'Konfigurationen',

    'form.configuration.copy.new.name': 'Neuer Name',
    'form.configuration.copy.new.name.placeholder': 'Geben Sie den neuen Konfigurationsnamen ein',

    'form.customer.name': 'Name',
    'form.customer.name.placeholder': 'Geben Sie den Namen der Organisation ein',
    'form.customer.admin.name': 'Admin-Name',
    'form.customer.firstname.placeholder': 'Vorname',
    'form.customer.lastname.placeholder': 'Familienname',
    'form.customer.language': 'Sprache',
    'form.customer.language.placeholder': 'Für Englisch leer lassen oder zwei kleine Buchstaben eingeben',
    'form.customer.apiKey': 'API-Schlüssel',
    'form.customer.apiKey.placeholder': 'Geben Sie den API-Schlüssel ein',
    'form.customer.prefix': 'Präfix',
    'form.customer.prefix.placeholder': 'Geben Sie das Gerätenummernpräfix ein',
    'form.customer.device.configuration': 'Gerätekonfiguration',
    'form.customer.desc': 'Beschreibung',
    'form.customer.desc.placeholder': 'Geben Sie eine Beschreibung der Organisation ein',
    'form.customer.copy.configuration': 'Konfigurationen kopieren',
    'form.customer.copy.design': 'Design kopieren',
    'form.customer.type': 'Kundentyp',
    'form.customer.status': 'Kundenstatus',
    'form.customer.expiry.time': 'Ablaufdatum',
    'form.customer.device.limit': 'Gerätelimit',
    'form.customer.size.limit': 'Speicherlimit',
    'form.customer.size.limit.placeholder': 'Größe (MB)',

    'form.device.number': 'Nummer',
    'form.device.number.locked': 'Die Nummer kann nicht geändert werden, da die vorherige Nummernänderung nicht abgeschlossen wurde.',
    'form.device.migration.warning': 'Die Gerätenummer wird geändert. Stellen Sie sicher, dass das Gerät eingeschaltet und online ist.',
    'form.device.number.hint': 'Keine Sonderzeichen verwenden',
    'form.device.desc': 'Beschreibung',
    'form.device.groups': 'Gruppen',
    'form.device.config': 'Konfiguration',
    'form.device.imei': 'IMEI',
    'form.device.phone.number': 'Telefonnummer',

    'form.update.device.config': 'Konfiguration',
    'form.update.device.action': 'Gruppenaktion',
    'form.device.set.group': 'Zu Gruppen hinzufügen',
    'form.device.clear.group': 'Aus Gruppen entfernen',

    'form.file.file': 'Datei',
    'form.file.name': 'Dateiname',
    'form.file.description': 'Beschreibung (optional)',
    'form.file.external': 'Extern',
    'form.file.external.title': 'Anstatt die Datei hochzuladen, können Sie die URL auf einer externen Ressource angeben',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': 'Datei-URL einer externen Ressource',
    'form.file.path': 'Pfad auf dem Server',
    'form.file.device.path': 'Pfad auf dem Gerät',
    'form.file.device.path.placeholder': 'Pfad relativ zu /storage/emulated/0',
    'form.file.deleted': 'GELÖSCHT',
    'form.file.copy.link': 'Link kopieren: ${link}',
    'form.file.configurations.file': 'Datei',
    'form.file.configurations.configs': 'Konfigurationen',
    'form.file.configurations.upload': 'Hochladen',
    'form.file.path.placeholder': 'Ein relativ Pfad, z.B. "/files/"',
    'form.file.available': 'Verfügbarer Speicherplatz: ${space} MB',

    'form.file.apps.name': 'Anwendungsname',
    'form.file.apps.pkg': 'Paket-ID',
    'form.file.apps.version': 'Version',

    'form.group.name': 'Name',
    'form.group.name.placeholder': 'Geben Sie den Namen der Gruppe ein',

    'form.role.name': 'Name',
    'form.role.name.placeholder': 'Geben Sie den Namen der Rolle ein',
    'form.role.permissions': 'Berechtigungen',

    'form.user.login': 'Benuter-Login',
    'form.user.login.placeholder': 'Benutzeranmeldung eingeben',
    'form.user.name': 'Name',
    'form.user.name.placeholder': 'Vor-und Nachname',
    'form.user.email': 'E-mail',
    'form.user.email.placeholder': 'E-Mail eingeben',
    'form.user.role': 'Rolle',
    'form.user.all.devices.available': 'Alle Geräte verfügbar',
    'form.user.available.groups': 'Verfügbare Gerätegruppen',
    'form.user.all.configs.available': 'Alle Konfigurationen verfügbar',
    'form.user.available.configs': 'Verfügbare Konfigurationen',
    'form.user.password.new': 'Neues Passwort',
    'form.user.password': 'Passwort',
    'form.user.password.new.placeholder': 'Geben Sie ein neues Passwort ein',
    'form.user.password.confirm': 'Überprüfen',
    'form.user.password.confirm.placeholder': 'Geben Sie das neue Passwort erneut ein',

    'form.settings.hints.title': 'Hinweise',

    'form.settings.plugins.title': 'Benutzte Plugins',

    'form.settings.common.title': 'Gerätetabellenansicht',
    'form.settings.common.visible.columns': 'Sichtbare Spalten in der Tabelle "Geräte"',
    'form.settings.common.status': 'Status',
    'form.settings.common.role': 'Benutzerrolle',
    'form.settings.common.date': 'Letztes Online-Datum',
    'form.settings.common.device.number': 'Gerätenummer',
    'form.settings.common.imei': 'IMEI',
    'form.settings.common.phone.number': 'Telefonnummer',
    'form.settings.common.phone.model': 'Telefonmodell',
    'form.settings.common.status.permissions': 'Berechtigungsstatus',
    'form.settings.common.status.installation': 'Installationsstatus',
    'form.settings.common.status.files': 'Dateistatus',
    'form.settings.common.config': 'Konfiguration',
    'form.settings.common.desc': 'Beschreibung',
    'form.settings.common.group': 'Gruppe',
    'form.settings.common.launcher.version': 'Launcher-Version',
    'form.settings.common.battery.level': 'Batteriestand',
    'form.settings.common.default.launcher': 'Hintergrund',
    'form.settings.common.mdm.mode': 'MDM-Modus',
    'form.settings.common.kiosk.mode': 'Kiosk-Modus',
    'form.settings.common.android.version': 'Android-Version',
    'form.settings.common.enrollment.date': 'Anmeldedatum',
    'form.settings.common.serial': 'Seriennummer',
    'form.settings.common.publicip': 'IP Adresse',

    'form.settings.design.title': 'Standarddesign',
    'form.settings.design.color.font': 'Hintergrundfarbe',
    'form.settings.design.color.font.placeholder': 'Farbe auswählen',
    'form.settings.design.color.app.names': 'Farbe der Anwendungsnamen',
    'form.settings.design.color.app.names.placeholder': 'Farbe auswählen',
    'form.settings.design.url.background.image': 'URL des Hintergrundbildes',
    'form.settings.design.url.background.image.placeholder': 'Geben Sie die URL des Hintergrundbilds ein',
    'form.settings.design.size.icon': 'Symbolgröße',
    'form.settings.design.size.icon.small': 'Klein',
    'form.settings.design.size.icon.medium': 'Durchschnitt (+ 20%)',
    'form.settings.design.size.icon.large': 'Groß (+ 40%)',
    'form.settings.design.desktop.header': 'Desktop-Titel',
    'form.settings.design.desktop.header.no': 'Nein',
    'form.settings.design.desktop.header.device.id': 'Device ID',

    'form.settings.lang.title': 'Spracheinstellungen',
    'form.settings.lang.use.default': 'Standardsprache verwenden',
    'form.settings.lang.use': 'Sprache verwenden',
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.vi': 'Tiếng Việt',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title': 'Verschiedene Einstellungen',
    'form.settings.misc.phone.format': 'Telefonnummernformat',
    'form.settings.misc.phone.format.placeholder': '+99 (999) 999 99 999',
    'form.settings.misc.custom.property.name.1': 'Benutzerdefinierte Eigenschaft #1',
    'form.settings.misc.custom.property.name.2': 'Benutzerdefinierte Eigenschaft #2',
    'form.settings.misc.custom.property.name.3': 'Benutzerdefinierte Eigenschaft #3',
    'form.settings.misc.custom.property.multiline': 'Mehrzeilig',
    'form.settings.misc.custom.property.send': 'An Gerät senden',
    'form.settings.misc.custom.property.name.placeholder': 'Name für eine benutzerdefinierte Eigenschaft eingeben',
    'form.settings.misc.create.new.devices': 'Gerät beim ersten Zugriff hinzufügen',
    'form.settings.misc.new.device.config': 'Neue Gerätekonfiguration',
    'form.settings.misc.new.device.group': 'Neue Gerätegruppe',
    'form.settings.misc.send.description': 'Beschreibung an Geräte senden',
    'form.settings.misc.password.length': 'Minimale Passwortlänge',
    'form.settings.misc.password.strength': 'Passwortstärke',
    'form.settings.misc.password.none': 'Nicht angegeben (beliebige Zeichen)',
    'form.settings.misc.password.alphanumeric': 'Klein- und Großbuchstaben, Ziffern',
    'form.settings.misc.password.specialchar': 'Klein- und Großbuchstaben, Ziffern, Sonderzeichen',
    'form.settings.misc.password.reset': 'Der Benutzer sollte das Passwort zurücksetzen',
    'form.settings.misc.idle.logout': 'Bei Inaktivität abmelden',
    'form.settings.misc.idle.logout.never': 'Nie',
    'form.settings.misc.idle.logout.1': '5 Minuten',
    'form.settings.misc.idle.logout.2': '10 Minuten',
    'form.settings.misc.idle.logout.3': '30 Minuten',
    'form.settings.misc.idle.logout.4': '1 Stunde',
    'form.settings.security.title': 'Sicherheitseinstellungen',

    'idle.logout.message': 'Sie werden aufgrund von Inaktivität in ${sec} Sekunden abgemeldet',
    'idle.logout.resume': 'Ich bin hier!',

    'form.settings.groups.title': 'Gruppen',
    'form.settings.groups.search.placeholder': 'Gruppensuche',

    'form.settings.users.title': 'Benutzer',
    'form.settings.users.search.placeholder': 'Benutzer suchen',

    'form.settings.roles.title': 'Benutzerrollen',

    'form.settings.icons.title': 'Symbole',
    'form.settings.icons.search.placeholder': 'Symbole suchen',

    'form.qr.device.number': 'Geräte-ID',
    'form.qr.auto.create': 'Zur Geräteliste hinzufügen, falls nicht vorhanden',
    'form.qr.number.use': 'Geräte-ID-Zuweisung',
    'form.qr.number.use.request': 'Benutzerwert',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': 'Ordnungsnummer',
    'form.qr.number.hint': 'Löschen Sie die Gerätenummer, um die automatische Gerätenummernzuweisung zu aktivieren',
    'form.qr.groups': 'Zu Gruppen hinzufügen',
    'form.qr.button.json': 'JSON holen',
    'form.qr.device.number.placeholder': 'Geben Sie die Geräte-ID ein ...',
    'form.qr.code.image.alt': 'QR-Code',

    'form.password.reset.title': 'Bitte neues Passwort einrichten',
    'form.password.reset.invalid': 'Entschuldigung, dieser Link zum Zurücksetzen des Passworts ist ungültig',
    'form.password.reset.submit': 'Passwort festlegen',

    'form.two.factor.auth.title': 'Zwei-Faktor-Authentifizierung',
    'form.two.factor.auth.hint': 'Um Ihre Anmeldung abzuschließen, installieren Sie bitte die Authenticator-App auf Ihrem Mobilgerät, scannen Sie den QR-Code, generieren Sie den Bestätigungscode und geben Sie ihn ein.',
    'form.two.factor.auth.code.invalid': 'Der Bestätigungscode ist ungültig!',
    'form.two.factor.auth.code': 'Bestätigungscode',
    'form.two.factor.auth.code.hint': '6-stelliger Code aus der Authentifizierungs-App',
    'form.two.factor.auth.code.error': 'Der Code muss eine 6-stellige Zahl sein',
    'form.two.factor.auth.verify': 'Überprüfen',
    'form.two.factor.auth.settings.hint': 'Um die Zwei-Faktor-Authentifizierung festzulegen, installieren Sie bitte die Authenticator-App auf Ihrem Mobilgerät, scannen Sie den QR-Code, generieren Sie den Bestätigungscode und geben Sie ihn ein.',
    'form.two.factor.auth.set': 'Zwei-Faktor-Authentifizierung ist aktiviert',
    'form.two.factor.auth.reset': 'Zwei-Faktor-Authentifizierung ist deaktiviert',
    'form.two.factor.auth.off.confirm': 'Möchten Sie die Zwei-Faktor-Authentifizierung deaktivieren? Nach dem erneuten Einschalten werden alle Authentifikatoren ungültig.',

    'form.profile.title': 'Passwort ändern',
    'form.profile.password.old': 'Altes Passwort',
    'form.profile.password.old.placeholder': 'Altes Passwort eingeben',
    'form.profile.password.new': 'Neues Passwort',
    'form.profile.password.new.placeholder': 'Geben Sie ein neues Passwort ein',
    'form.profile.password.confirm': 'Überprüfen',
    'form.profile.password.confirm.placeholder': 'Geben Sie das neue Passwort erneut ein',

    'tab.customers': 'Ereignisse',
    'tab.common.applications': 'Gemeinsame Anwendungen',

    'tab.devices': 'Geräte',
    'tab.applications': 'Anwendungen',
    'tab.configurations': 'Konfigurationen',
    'tab.files': 'Dateien',
    'tab.default.design': 'Standarddesign',
    'tab.common.settings': 'Gerätetabellenansicht',
    'tab.users': 'Benutzer',
    'tab.roles': 'Rollen',
    'tab.groups': 'Gruppen',
    'tab.icons': 'Symbole',
    'tab.language': 'Allgemeine- und Spracheinstellungen',
    'tab.license': 'Lizenz',
    'tab.hints': 'Hinweise',
    'tab.plugins': 'Plugins',

    'tab.configeditor.common.settings': 'Allgemeine Einstellungen',
    'tab.configeditor.design.settings': 'Darstellungseinstellungen',
    'tab.configeditor.applications': 'Anwendungen',
    'tab.configeditor.mdm.settings': 'MDM-Einstellungen',
    'tab.configeditor.app.settings': 'Anwendungseinstellungen',
    'tab.configeditor.files': 'Dateien',

    'search.placeholder.file': 'Suchdatei',
    'search.placeholder.configuration': 'Suche nach Konfiguration',
    'search.placeholder.customer': 'Suche nach einer Organisation',
    'search.placeholder.application': 'Suche nach einer Anwendung',
    'search.placeholder.application.setting': 'Suche nach einer Anwendungseinstellung',
    'search.placeholder.device': 'Suche nach einem Gerät',
    'search.placeholder.address': 'Adressensuche',
    'search.placeholder.point': 'Koordinaten-Suche',
    'search.placeholder.message': 'Nachrichtensuche',
    'search.placeholder': 'Suche ...',
    'search.placeholder.from': 'Von ...',
    'search.placeholder.to': 'Bis ...',
    'search.placeholder.user': 'Geben Sie den Benutzernamen ein',

    'table.heading.customer.name': 'Name',
    'table.heading.customer.desc': 'Beschreibung',
    'table.heading.customer.registration.time': 'Registriert',
    'table.heading.customer.last.login.time': 'Letzte Anmeldung',
    'table.heading.customer.actions': 'Aktionen',
    'table.heading.customer.type': 'Type',
    'table.heading.customer.expiry.time': 'Expires',
    'table.heading.customer.device.limit': 'Limit',
    'table.heading.customer.status': 'Status',

    'customer.new': 'Neu',
    'customer.active': 'Aktiv',
    'customer.need.followup': 'Follow-up braucht',
    'customer.followup.sent': 'Follow-up gesendet',
    'customer.internal.test': 'Interner Test',
    'customer.developer': 'Entwickler',
    'customer.difficult': 'Schwierig',
    'customer.pause': 'Pause',
    'customer.inactive': 'Keine Anmeldung',
    'customer.abandon': 'Verlassen',
    'customer.onpremise': 'Test vor Ort',
    'customer.denial': 'Ablehnung',
    'customer.client': 'Klient',

    'table.heading.configuration.name': 'Name',
    'table.heading.configuration.desc': 'Beschreibung',
    'table.heading.configuration.actions': 'Aktionen',

    'table.heading.application.setting.app.pkg': 'Paket-ID',
    'table.heading.application.setting.app.name': 'Anwendungsname',
    'table.heading.application.setting.name': 'Attribute',
    'table.heading.application.setting.value': 'Value',
    'table.heading.application.setting.comment': 'Kommentar',
    'table.heading.application.setting.lastUpdate': 'Erstellungsdatum',

    'table.heading.file.url': 'URL',
    'table.heading.file.devicepath': 'Pfad auf dem Gerät',
    'table.heading.file.description': 'Dateibeschreibung',
    'table.heading.file.action': 'Aktion',
    'table.heading.file.lastUpdate': 'Erstellungsdatum',

    'table.heading.application.pkg': 'Paket-ID',
    'table.heading.application.name': 'Anwendungsname',
    'table.heading.application.version': 'Version',
    'table.heading.application.url': 'URL',
    'table.heading.application.label': 'Symbol',
    'table.heading.application.actions': 'Aktionen',
    'table.heading.application.order': 'Sortierung',

    'table.heading.device.status': 'Status',
    'table.heading.device.date': 'Online',
    'table.heading.device.device.number': 'Gerätenummer',
    'table.heading.device.imei': 'IMEI',
    'table.heading.device.phone.number': 'Telefonnummer',
    'table.heading.device.phone.model': 'Telefonmodell',
    'table.heading.device.status.permissions': 'Berechtigungsstatus',
    'table.heading.device.status.installation': 'Installationsstatus',
    'table.heading.device.status.files': 'Dateistatus',
    'table.heading.device.configuration': 'Konfiguration',
    'table.heading.device.desc': 'Beschreibung',
    'table.heading.device.group': 'Gruppe',
    'table.heading.device.launcher.version': 'Launcher-Version',
    'table.heading.device.battery.level': 'Batteriestand',
    'table.heading.device.default.launcher': 'Hintergrund',
    'table.heading.device.mdm.mode': 'MDM-Modus',
    'table.heading.device.kiosk.mode': 'Kiosk-Modus',
    'table.heading.device.android.version': 'Android-Version',
    'table.heading.device.enrollment.date': 'Anmeldedatum',
    'table.heading.device.serial': 'Seriennummer',
    'table.heading.device.publicip': 'IP Adresse',
    'table.heading.device.actions': 'Aktionen',

    'table.heading.group.name': 'Name',
    'table.heading.group.actions': 'Aktionen',

    'table.heading.role.name': 'Name',
    'table.heading.role.actions': 'Aktionen',

    'table.heading.file.name': 'Dateiname',
    'table.heading.file.comment': 'Beschreibung',
    'table.heading.file.device.path': 'Pfad auf Gerät',
    'table.heading.file.update.time': 'Aktualisiert',
    'table.heading.file.external': 'Extern',
    'table.heading.file.variable': 'Variable',
    'table.heading.file.remove': 'Entfernen',
    'table.heading.file.remove.hint': 'Erzwingt das Entfernen der Datei aus dem Gerätespeicher',
    'table.heading.file.path': 'Pfad',
    'table.heading.file.address': 'Adresse',
    'table.heading.file.size': 'Größe',
    'table.heading.file.actions': 'Aktionen',

    'table.heading.users.login': 'Login',
    'table.heading.users.name': 'Name',
    'table.heading.users.role': 'Rolle',
    'table.heading.users.actions': 'Aktionen',

    'table.heading.common.apps.customer': 'Organisation',
    'table.heading.common.apps.pkg': 'Paket-ID',
    'table.heading.common.apps.name': 'Anwendungsname',
    'table.heading.common.apps.version': 'Version',
    'table.heading.common.apps.url': 'URL',
    'table.heading.common.apps.label': 'Symbol',
    'table.heading.common.apps.actions': 'Aktionen',

    'notfound.devices': 'Es wurden keine Geräte gefunden.',
    'notfound.files': 'Die Dateiliste ist leer.',
    'notfound.configurations': 'Es wurden keine Konfigurationen gefunden.',
    'notfound.customers': 'Organisationen nicht gefunden.',
    'notfound.common.apps': 'Es wurden keine Anwendungen gefunden.',
    'notfound.applications': 'Anwendungen nicht gefunden',
    'notfound.groups': 'Keine Gruppen gefunden. Versuchen Sie es mit einer anderen Abfrage. ',
    'notfound.users': 'Benutzer nicht gefunden. Versuchen Sie es mit einer anderen Abfrage. ',
    'notfound.apps.for.display': 'Es sind keine Anwendungen zum Anzeigen vorhanden.',
    'notfound.app.versions.for.display': 'Es sind keine Versionen zum Anzeigen vorhanden.',
    'notfound.roles':'Die Rollenliste ist leer.',
    'notfound.icons':'Die Symbolliste ist leer.',

    'format.date.header': 'HH:mm dd/MM/yyyy',

    'menu.about': 'Über',
    'menu.profile': 'Profil',
    'menu.panel.master': 'Master Panel',
    'menu.panel.main': 'Hauptpanel',
    'menu.logout': 'Abmelden',
    'menu.functions': 'Funktionen',
    'menu.settings': 'Einstellungen',
    'menu.show.hints': 'Hinweise anzeigen',

    'plugin.name.not.specified': '<< Der Funktionsname ist nicht angegeben >>',

    'breadcrumb.summary': 'Zusammenfassung',
    'breadcrumb.devices': 'Geräte',
    'breadcrumb.applications': 'Anwendungen',
    'breadcrumb.configurations': 'Konfigurationen',
    'breadcrumb.files': 'Dateien',
    'breadcrumb.default.design': 'Design nach Standard',
    'breadcrumb.common.settings ':' Gerätetabellenansicht ',
    'breadcrumb.language.settings': 'Sprache und andere Einstellungen',
    'breadcrumb.license.settings': 'Lizenz',
    'breadcrumb.users': 'Benutzer',
    'breadcrumb.roles': 'Rollen',
    'breadcrumb.groups': 'Gruppen',
    'breadcrumb.hints': 'Hinweise',
    'breadcrumb.plugins ':' Plugins ',
    'breadcrumb.config.details': 'Details',
    'breadcrumb.application.versions': 'Versionen',

    'app.name': 'Headwind MDM',
    'app.vendor.name':"h-mdm.com",
    'app.vendor.link':"https://h-mdm.com",
    'app.description': 'ist das Open-Source-Managementsystem für mobile Geräte',
    'app.title': '${appName}-Webpanel',

    'box.show.my.apps.only': 'Nur meine Anwendungen anzeigen',
    'configuration.app.version.upgrade.message': 'Installierte Version ${installedVersion}, verfügbare Version ${latestVersion}',

    'about.line.1': '${appName}-Bedienfeld',
    'about.line.2': 'Enterprise Launcher für Android',
    'about.line.3': 'Version ${versionNumber}',
    'about.line.4': 'Installierte Plugins',

    'common.app.clarification': 'Diese Anwendung ist öffentlich und kann nicht bearbeitet werden. Um eine weitere Version dieser App hinzuzufügen, wenden Sie sich bitte an den Administrator. ',

    'qrcode.help.line1': 'So richten Sie das Android-Gerät (Version 7 oder höher) in einem verwalteten (Unternehmens-) Modus ein:',
    'qrcode.help.line2': 'Gerät auf Werkseinstellungen zurücksetzen',
    'qrcode.help.line3': 'Tippen Sie siebenmal auf eine beliebige Stelle des Startbildschirms (Sie müssen einen versteckten QR-Code-Scanmodus aufrufen)',
    'qrcode.help.line4': 'Befolgen Sie die Anweisungen des Geräts: Akzeptieren Sie die Bedingungen, stellen Sie eine Verbindung zu Wi-Fi her, scannen Sie diesen QR-Code',
    'qrcode.help.line5': 'Der QR-Code enthält möglicherweise die Geräte-ID für ${appName} (Sie müssen sie also nicht auf einem mobilen Gerät eingeben). Um die Geräte-ID in den QR-Code einzubetten, geben Sie die Geräte-ID auf diesem Bildschirm ein und klicken Sie auf "Erneuern". ',

    'form.configuration.app.version.select.select.title': 'Wählen Sie die zu installierende Version aus',
    'form.configuration.app.version.select.version.check.off': 'Versionsprüfung deaktivieren',
    'form.configuration.app.version.select.upgrade.warning': 'Upgrade der Anwendung "${v1}" auf die Version "${v3}" für die Konfiguration "${v2}"?',
    'form.configuration.app.version.select.downgrade.warning': 'Downgrade-Version LÖSCHEN SIE ALLE DIESEN ANWENDUNGEN auf allen Geräten! Downgrade der Anwendungsversion "${v1}" auf Version "${v2}"? ',

    'tip.step.1': 'Klicken Sie hier, um die Geräteregistrierung zu starten',
    'tip.step.2': 'Klicken Sie hier, um den QR-Code zu öffnen',
    'tip.step.3': 'Klicken Sie hier, um zu sehen, wie der QR-Code-Scanner auf dem Gerät geöffnet wird',
    'tip.step.4': 'Suchen Sie auf der Registerkarte «Geräte» nach einer verfügbaren Geräte-ID. Klicken Sie auf «Erneuern», um es in den QR-Code aufzunehmen. ',

    'ie.browser.notice.1': 'Internet Explorer wird leider nicht unterstützt.',
    'ie.browser.notice.2': 'Empfohlener Browser für die Verwendung von ${appName} - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop"> Chrome</a>.',

    'form.resolved.duplicate.pkg.text1': 'Die Paket-ID "${pkg}" wird bereits von den unten aufgeführten Anwendungen verwendet.',
    'form.resolved.duplicate.pkg.text2': 'Möchten Sie eine neue Anwendung oder eine neue Version einer vorhandenen Anwendung hinzufügen?',
    'form.resolved.duplicate.pkg.text3': 'Neue Version für',
    'form.resolved.duplicate.pkg.text4': 'Die Paket-ID "${pkg}" wird bereits von Anwendungen ${apps} verwendet.',
    'form.resolved.duplicate.pkg.text5': 'Möchten Sie die Paket-ID wirklich ändern?',

    'tooltip.usage.byconfigurations': 'Wird von Konfigurationen verwendet',
    'tooltip.usage.byapps': 'Wird von Anwendungen verwendet',
    'tooltip.usage.byicons': 'Wird von Symbolen verwendet',

    'form.devices.label.params.more': 'Weitere Parameter',
    'form.devices.label.params.less': 'Weniger Parameter',
    'form.devices.label.installation.status': 'Installationsstatus',
    "format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
    "format.devices.date.datePicker": "dd-MM-yyyy",
    'form.devices.fast.search': 'Schnelle Suche nach Nummer',

    'form.devices.selection.install.status.default': 'Installationsstatus ...',
    'form.devices.selection.install.status.all': 'Alle',
    'form.devices.selection.install.status.success': 'Erfolgreich',
    'form.devices.selection.install.status.version.mismatch': 'Versionskonflikt',
    'form.devices.selection.install.status.failure': 'Fehler',
    'form.devices.selection.imei.changed': 'IMEI kürzlich geändert',

    'search.placeholder.launcher.version': 'Launcher Version',
    'error.date.range.invalid': 'Ungültiges Datumsintervall',

    'form.selection.status.any': 'Jeder Wert',
    'form.selection.status.all': 'Alle',
    'form.selection.status.yes': 'Ja',
    'form.selection.status.no': 'Nein',

    'form.devices.selection.status': 'Zustand ...',
    'form.devices.selection.online': 'Online',
    'form.devices.selection.offline': 'Offline',
    'form.devices.selection.number': 'Zahl eingeben',

    'form.devices.selection.online.status.custom': 'Zeit eingeben',
    'form.devices.selection.online.status.1': '15 Minuten',
    'form.devices.selection.online.status.2': '30 Minuten',
    'form.devices.selection.online.status.3': '1 Stunde',
    'form.devices.selection.online.status.4': '2 Stunden',
    'form.devices.selection.online.status.5': '6 Stunden',
    'form.devices.selection.online.status.6': '1 Tag',
    'form.devices.selection.online.status.7': '2 Tage',
    'form.devices.selection.online.status.8': '3 Tage',
    'form.devices.selection.online.status.9': '1 Woche',
    'form.devices.selection.online.status.10': '1 Monat',

    'form.devices.selection.online.status.label': 'Minute(n)',
    'form.devices.status.ago': 'vor',
    'form.devices.status.minutes': 'M',
    'form.devices.status.hours': 'S',
    'form.devices.status.days': 'T',
    'form.devices.status.weeks': 'W',
    'form.devices.status.months': 'Mon',
    'form.devices.status.years': 'J',

    'customer.type.demo': 'Demo',
    'customer.type.small': 'Professional',
    'customer.type.corporate': 'Enterprise',
    'customer.type.master': 'Primary',

    'customer.type.options.all': 'Alle Arten',
    'customer.status.options.all': 'Alle Status',

    'account.expiring': 'Ihr Konto läuft in ${days} Tagen ab. Bitte kontaktieren Sie den Verkäufer, um Ihr Konto zu erneuern. ',
    'account.expired.short': 'Ihr Konto ist abgelaufen!',
    'account.expired': 'Ihr Konto ist abgelaufen. Bitte kontaktieren Sie den Verkäufer, um Ihr Konto zu erneuern. ',
    'device.limit.achieved': 'Ein Gerät kann nicht hinzugefügt werden, da Sie Ihr Limit erreicht haben. Bitte entfernen Sie einige Geräte oder wenden Sie sich an den Verkäufer, um Ihr Gerätelimit zu verlängern. ',

    'menu.updates': 'Nach Updates suchen',
    'updates.title': 'Updates',
    'updates.disabled.custom': 'Benutzerdefinierte Version, bitte manuell aktualisieren',
    'updates.disabled.not_master': 'Den Hosting-Provider um Aktualisierung bitten',
    'updates.disabled.multiple': 'Mehrere App-Versionen, bitte manuell aktualisieren',
    'updates.disabled.error': 'Interner Serverfehler',
    'updates.disabled.download': 'Fehler beim Herunterladen eines Updates',
    'updates.application': 'Anwendung',
    'updates.current.version': 'Aktuelle Version',
    'updates.available.version': 'Verfügbare Version',
    'updates.downloaded': 'Heruntergeladen',
    'updates.auto.update': 'Mobile Apps automatisch aktualisieren (mit Vorsicht in der Produktion verwenden!)',
    'updates.enable.stats': 'Nutzungsstatistiken an den Dienstanbieter senden, um die Systemleistung zu verbessern',
    'updates.get': 'Updates erhalten',
    'updates.checking': 'Suche nach Updates...',
    'updates.getting': 'Updates werden abgerufen...',
    'updates.success': 'Update abgeschlossen',
    'updates.web.hint': 'Um das Web-App-Update abzuschließen, führen Sie das Shell-Skript "/opt/hmdm/update-web-app.sh" in der SSH-Konsole aus',

    'permission.edit_device_app_settings': 'Gerätespezifische App-Einstellungen verwalten',
    'permission.plugins_customer_access_management': 'Verfügbare Plugins verwalten',
    'permission.plugin_audit_access': 'Überwachungsprotokoll anzeigen',
    'permission.plugin_contacts_access': 'Kontakte verwalten',
    'permission.plugin_deviceexport_access': 'Geräte exportieren',
    'permission.plugin_deviceimport_access': 'Geräte importieren',
    'permission.plugin_deviceinfo_access': 'Detaillierte Geräteinformationen anzeigen',
    'permission.plugin_devicelocations_access': 'Geräte auf der Karte anzeigen',
    'permission.plugin_devicelocations_settings_access': 'Karten-Plugin konfigurieren',
    'permission.plugin_devicelog_access': 'Gerät anzeigen Protokolle',
    'permission.plugin_devicereset_access': 'Geräte zurücksetzen und neu starten',
    'permission.plugin_licensing_access': 'Zugriff auf die Lizenz (veraltet)',
    'permission.plugin_messaging_send': 'Nachrichten senden',
    'permission.plugin_messaging_delete': 'Gesendete Nachrichten löschen',
    'permission.plugin_photo_remove_photo': 'Fotos löschen',
    'permission.settings': 'Einstellungen verwalten',
    'permission.configurations': 'Konfigurationen anzeigen',
    'permission.edit_devices': 'Geräteinfo bearbeiten',
    'permission.edit_device_desc': 'Gerätebeschreibung bearbeiten',
    'permission.enroll_devices': 'Geräte per QR-Code registrieren',
    'permission.plugin_apuppet_access': 'Fernsteuerung',
    'permission.plugin_knox_access': 'Knox Plugin',
    'permission.add_config': 'Konfigurationen hinzufügen',
    'permission.copy_config': 'Konfigurationen duplizieren',
    'permission.plugin_openvpn_access': 'OpenVPN-Plugin',
    'permission.plugin_photo_access': 'Foto-Plugin',
    'permission.push_api': 'Zugriff auf Push-API',
    'permission.plugin_urlfilter_access': 'URL-Filterung',
    'permission.plugin_push_send': 'Push-Nachrichten senden',
    'permission.plugin_push_delete': 'Push-Nachrichten löschen',
    'permission.get_updates': 'Nach Updates suchen',
    'permission.plugin_xtra_access': 'Premium-Version anfordern',
    'permission.applications': 'Anwendungen anzeigen',
    'permission.edit_applications': 'Verwalten Anwendungen',
    'permission.edit_application_versions': 'Anwendungsversionen verwalten',
    'permission.files': 'Dateien anzeigen',
    'permission.edit_files': 'Dateien verwalten',

    'yes': 'Ja',
    'no': 'Nein'
};
