/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CommonDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.Settings;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import com.hmdm.service.EmailService;
import com.hmdm.util.PasswordUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Password-Reset"})
@Singleton
@Path(value="/public/passwordReset")
public class PasswordResetResource {
    private static final Logger logger = LoggerFactory.getLogger(PasswordResetResource.class);
    private String baseUrl;
    private CommonDAO commonDAO;
    private UnsecureDAO unsecureDAO;
    private EmailService emailService;

    public PasswordResetResource() {
    }

    @Inject
    public PasswordResetResource(CommonDAO commonDAO, UnsecureDAO unsecureDAO, EmailService emailService, @Named(value="base.url") String baseUrl) {
        this.commonDAO = commonDAO;
        this.unsecureDAO = unsecureDAO;
        this.emailService = emailService;
        this.baseUrl = baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get settings by token", notes="Returns the user settings by password reset token.", response=User.class)
    @GET
    @Path(value="/settings/{token}")
    @Produces(value={"application/json"})
    public Response getSettings(@PathParam(value="token") @ApiParam(value="Password reset token") String token) {
        try {
            User user = this.unsecureDAO.findByPasswordResetToken(token);
            if (user == null) {
                Response response = Response.ERROR((String)"error.user.not.found");
                return response;
            }
            SecurityContext.init((User)user);
            Settings settings = Optional.ofNullable(this.commonDAO.getSettings()).orElse(new Settings());
            settings.setSingleCustomer(this.unsecureDAO.isSingleCustomer());
            if (!settings.isSingleCustomer()) {
                this.commonDAO.loadCustomerSettings(settings);
            }
            Response response = Response.OK((Object)settings);
            return response;
        }
        catch (Exception e) {
            logger.error("Unexpected error when getting the settings for customer", (Throwable)e);
            Response response = Response.INTERNAL_ERROR();
            return response;
        }
        finally {
            SecurityContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Reset password", notes="Resets the user password")
    @POST
    @Path(value="/reset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePassword(User newData) {
        try {
            User user = this.unsecureDAO.findByPasswordResetToken(newData.getPasswordResetToken());
            if (user == null) {
                Response response = Response.ERROR((String)"error.user.not.found");
                return response;
            }
            user.setNewPassword(PasswordUtil.getHashFromMd5((String)newData.getNewPassword()));
            user.setPasswordReset(false);
            user.setPasswordResetToken(null);
            this.unsecureDAO.setUserNewPasswordUnsecure(user);
            Response response = Response.OK((Object)user);
            return response;
        }
        catch (Exception e) {
            logger.error("Unexpected error when resetting the user password", (Throwable)e);
            Response response = Response.INTERNAL_ERROR();
            return response;
        }
        finally {
            SecurityContext.release();
        }
    }

    @ApiOperation(value="Password recovery feature", notes="Checks if the password can be recovered.")
    @GET
    @Deprecated
    @Path(value="/canRecover")
    @Produces(value={"application/json"})
    public Response canRecover() {
        if (this.emailService.isConfigured()) {
            return Response.OK();
        }
        return Response.ERROR();
    }

    @ApiOperation(value="Request password recovery", notes="Checks if the password can be recovered.")
    @GET
    @Path(value="/recover/{username}")
    @Produces(value={"application/json"})
    public Response recover(@PathParam(value="username") @ApiParam(value="Login of the user who wants to recover the password") String username) {
        try {
            Customer customer;
            String language;
            User user = this.unsecureDAO.findByLoginOrEmail(username);
            if (user == null) {
                logger.warn("Can't recover password for user " + username + ": user not found");
                return Response.ERROR((String)"error.user.not.found");
            }
            if (!this.emailService.isConfigured()) {
                logger.warn("Can't recover password for user " + username + ": email sender not configured");
                return Response.ERROR((String)"error.email.not.configured");
            }
            if (user.getEmail() == null || user.getEmail().trim().equals("")) {
                logger.warn("Can't recover password for user " + username + ": no email for user");
                return Response.ERROR((String)"error.email.not.found");
            }
            if (user.getPasswordResetToken() == null || user.getPasswordResetToken().equals("")) {
                user.setPasswordResetToken(PasswordUtil.generateToken());
                user.setNewPassword(user.getPassword());
                this.unsecureDAO.setUserNewPasswordUnsecure(user);
            }
            String string = language = (customer = this.unsecureDAO.getCustomerByIdUnsecure(Integer.valueOf(user.getCustomerId()))) == null ? "" : customer.getLanguage();
            if (this.emailService.sendEmail(user.getEmail(), this.emailService.getRecoveryEmailSubj(language), this.emailService.getRecoveryEmailBody(language, user.getPasswordResetToken()))) {
                return Response.OK();
            }
            return Response.INTERNAL_ERROR();
        }
        catch (Exception e) {
            logger.error("Unexpected error when requesting the password recovery for user " + username, (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

