/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.GroupDAO;
import com.hmdm.persistence.UserDAO;
import com.hmdm.persistence.domain.Group;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.LookupItem;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Device Group"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/groups")
public class GroupResource {
    private GroupDAO groupDAO;
    private UserDAO userDAO;
    private static final Logger log = LoggerFactory.getLogger(GroupResource.class);

    public GroupResource() {
    }

    @Inject
    public GroupResource(GroupDAO groupDAO, UserDAO userDAO) {
        this.groupDAO = groupDAO;
        this.userDAO = userDAO;
    }

    @ApiOperation(value="Get all device groups", notes="Gets the list of all available device groups", response=Group.class, responseContainer="List")
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getAllGroups() {
        return Response.OK((Object)this.groupDAO.getAllGroups());
    }

    @ApiOperation(value="Search device groups", notes="Search device groups meeting the specified filter value", response=Group.class, responseContainer="List")
    @GET
    @Path(value="/search/{value}")
    @Produces(value={"application/json"})
    public Response searchGroups(@PathParam(value="value") @ApiParam(value="A filter value") String value) {
        return Response.OK((Object)this.groupDAO.getAllGroupsByValue(value));
    }

    @ApiOperation(value="Get group ids/names for autocomplete")
    @POST
    @Path(value="/autocomplete")
    @Produces(value={"application/json"})
    public Response getGroupsForAutocomplete(String filter) {
        try {
            List groups = this.groupDAO.getAllGroupsByValue(filter).stream().map(group -> new LookupItem(group.getId().intValue(), group.getName())).collect(Collectors.toList());
            return Response.OK(groups);
        }
        catch (Exception e) {
            log.error("Failed to search the groups due to unexpected error. Filter: {}", (Object)filter, (Object)e);
            return Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Create or update device group", notes="Create a new device group (if id is not provided) or update existing one otherwise.")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateGroup(Group group) {
        if (!SecurityContext.get().hasPermission("settings")) {
            log.error("Unauthorized attempt to update groups by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        Group dbGroup = this.groupDAO.getGroupByName(group.getName());
        if (dbGroup != null && !dbGroup.getId().equals(group.getId())) {
            return Response.DUPLICATE_ENTITY((String)"error.duplicate.group");
        }
        if (group.getId() == null) {
            this.groupDAO.insertGroup(group);
            User user = (User)SecurityContext.get().getCurrentUser().get();
            if (!user.isAllDevicesAvailable()) {
                user.getGroups().add(new LookupItem(group.getId().intValue(), null));
                this.userDAO.updateUserMainDetails(user);
            }
        } else {
            this.groupDAO.updateGroup(group);
        }
        return Response.OK();
    }

    @ApiOperation(value="Delete device group", notes="Delete an existing device group")
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeGroup(@PathParam(value="id") @ApiParam(value="Device group ID") Integer id) {
        if (!SecurityContext.get().hasPermission("settings")) {
            log.error("Unauthorized attempt to update groups by user " + SecurityContext.get().getCurrentUserName());
            return Response.PERMISSION_DENIED();
        }
        Long count = this.groupDAO.countDevicesByGroupId(id);
        if (count > 0L) {
            return Response.ERROR((String)"error.notempty.group");
        }
        this.groupDAO.removeGroupById(id);
        return Response.OK();
    }
}

