/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.notification.PushService;
import com.hmdm.persistence.ApplicationDAO;
import com.hmdm.persistence.ConfigurationDAO;
import com.hmdm.persistence.ConfigurationFileDAO;
import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.IconDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.UploadedFileDAO;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.ApplicationVersion;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.UploadedFile;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.APKFileDetails;
import com.hmdm.rest.json.ApplicationConfigurationLink;
import com.hmdm.rest.json.FileConfigurationLink;
import com.hmdm.rest.json.FileUploadResult;
import com.hmdm.rest.json.LimitResponse;
import com.hmdm.rest.json.LinkConfigurationsToFileRequest;
import com.hmdm.rest.json.view.FileView;
import com.hmdm.security.SecurityContext;
import com.hmdm.util.APKFileAnalyzer;
import com.hmdm.util.FileExistsException;
import com.hmdm.util.FileUtil;
import com.hmdm.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.poi.util.IOUtils;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Files"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/web-ui-files")
public class FilesResource {
    private static final Logger logger = LoggerFactory.getLogger(FilesResource.class);
    private String filesDirectory;
    private String baseUrl;
    private File baseDirectory;
    private CustomerDAO customerDAO;
    private UnsecureDAO unsecureDAO;
    private ApplicationDAO applicationDAO;
    private ConfigurationDAO configurationDAO;
    private UploadedFileDAO uploadedFileDAO;
    private APKFileAnalyzer apkFileAnalyzer;
    private ConfigurationFileDAO configurationFileDAO;
    private IconDAO iconDAO;
    private PushService pushService;

    public FilesResource() {
    }

    @Inject
    public FilesResource(@Named(value="files.directory") String filesDirectory, @Named(value="base.url") String baseUrl, CustomerDAO customerDAO, UnsecureDAO unsecureDAO, ApplicationDAO applicationDAO, ConfigurationDAO configurationDAO, UploadedFileDAO uploadedFileDAO, APKFileAnalyzer apkFileAnalyzer, ConfigurationFileDAO configurationFileDAO, IconDAO iconDAO, PushService pushService) {
        this.filesDirectory = filesDirectory;
        this.baseDirectory = new File(filesDirectory);
        this.customerDAO = customerDAO;
        this.unsecureDAO = unsecureDAO;
        this.applicationDAO = applicationDAO;
        this.configurationDAO = configurationDAO;
        this.uploadedFileDAO = uploadedFileDAO;
        this.configurationFileDAO = configurationFileDAO;
        this.iconDAO = iconDAO;
        this.pushService = pushService;
        if (!this.baseDirectory.exists()) {
            this.baseDirectory.mkdirs();
        }
        this.apkFileAnalyzer = apkFileAnalyzer;
        this.baseUrl = baseUrl;
    }

    @ApiOperation(value="Get all files", notes="Gets the list of all available files", response=FileView.class, responseContainer="List")
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public com.hmdm.rest.json.Response getAllFiles() {
        if (!SecurityContext.get().hasPermission("files")) {
            logger.error("Unauthorized attempt to access file list by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        return com.hmdm.rest.json.Response.OK((Object)this.generateFilesList((String)null));
    }

    @ApiOperation(value="Remove a file", notes="Removes the file from the MDM server")
    @POST
    @Path(value="/remove")
    public com.hmdm.rest.json.Response removeFile(FileView file) {
        if (!SecurityContext.get().hasPermission("edit_files")) {
            logger.error("Unauthorized attempt to remove a file by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        if (!FileUtil.isSafePath((String)file.getFilePath())) {
            logger.error("Attempt to remove a file with unsafe path! path: " + file.getFilePath());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        return SecurityContext.get().getCurrentUser().map(u -> {
            Customer customer = this.customerDAO.findById(u.getCustomerId());
            if (this.configurationFileDAO.isFileUsed(file.getId())) {
                return com.hmdm.rest.json.Response.FILE_USED();
            }
            if (this.iconDAO.isFileUsed(file.getId())) {
                return com.hmdm.rest.json.Response.FILE_USED();
            }
            if (!file.isExternal()) {
                java.nio.file.Path filePath = customer.getFilesDir() == null || customer.getFilesDir().isEmpty() ? Paths.get(this.filesDirectory, file.getFilePath()) : Paths.get(this.filesDirectory, customer.getFilesDir(), file.getFilePath());
                try {
                    this.uploadedFileDAO.remove(file.getId().intValue());
                    if (filePath.toFile().exists() && this.uploadedFileDAO.getByPath(customer.getId(), file.getFilePath()) == null) {
                        Files.delete(filePath);
                    }
                    return com.hmdm.rest.json.Response.OK();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return com.hmdm.rest.json.Response.ERROR((String)"error.file.deletion");
                }
            }
            this.uploadedFileDAO.remove(file.getId().intValue());
            return com.hmdm.rest.json.Response.OK();
        }).orElse(com.hmdm.rest.json.Response.PERMISSION_DENIED());
    }

    @ApiOperation(value="Complete file upload", notes="Commits the file upload to MDM server. Returns the uploaded file data", response=FileView.class)
    @POST
    @Path(value="/update")
    public com.hmdm.rest.json.Response updateFile(UploadedFile uploadedFile) {
        if (!SecurityContext.get().hasPermission("edit_files")) {
            logger.error("Unauthorized attempt to update a file by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        if (uploadedFile.getId() == null) {
            if (!uploadedFile.isExternal()) {
                return this.createFileInternal(uploadedFile);
            }
            return this.createExternalFileInternal(uploadedFile);
        }
        return this.updateFileInternal(uploadedFile);
    }

    private com.hmdm.rest.json.Response createFileInternal(UploadedFile uploadedFile) {
        if (uploadedFile.getFilePath() == null) {
            uploadedFile.setFilePath("");
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (!FileUtil.isSafePath((String)uploadedFile.getFilePath()) || !uploadedFile.getTmpPath().startsWith(tmpdir)) {
            logger.error("Attempt to create a file with unsafe path: " + uploadedFile.getFilePath() + " tmp path: " + uploadedFile.getTmpPath());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        String fname = uploadedFile.getFileName();
        if (fname.equals("")) {
            fname = FileUtil.getNameFromTmpPath((String)uploadedFile.getTmpPath());
            while (fname.startsWith("/")) {
                fname = fname.substring(1);
            }
            uploadedFile.setFilePath(fname);
        }
        String fileName = fname;
        return SecurityContext.get().getCurrentUser().map(u -> {
            Customer customer = this.customerDAO.findById(u.getCustomerId());
            try {
                File movedFile = FileUtil.moveFile((Customer)customer, (String)this.filesDirectory, (String)uploadedFile.getSubdir(), (String)uploadedFile.getTmpPath(), (String)fileName);
                if (movedFile != null) {
                    LinkedList result = new LinkedList();
                    this.handleFile(movedFile, result, null, customer);
                    BasicFileAttributes attrs = Files.readAttributes(movedFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    uploadedFile.setUploadTime(Long.valueOf(attrs.creationTime().toMillis()));
                    uploadedFile.setCustomerId(customer.getId().intValue());
                    this.uploadedFileDAO.insert(uploadedFile);
                    uploadedFile.setUrl(uploadedFile.getUrl(this.baseUrl, customer));
                    return com.hmdm.rest.json.Response.OK((Object)uploadedFile);
                }
                return com.hmdm.rest.json.Response.ERROR((String)"error.file.save");
            }
            catch (FileExistsException e) {
                logger.warn("File {} already exists", (Object)uploadedFile.getFilePath());
                return com.hmdm.rest.json.Response.FILE_EXISTS();
            }
            catch (IOException e) {
                logger.warn("While creating file {}: {}", (Object)uploadedFile.getFilePath(), (Object)e.getMessage());
                e.printStackTrace();
                return com.hmdm.rest.json.Response.INTERNAL_ERROR();
            }
        }).orElse(com.hmdm.rest.json.Response.PERMISSION_DENIED());
    }

    private com.hmdm.rest.json.Response createExternalFileInternal(UploadedFile uploadedFile) {
        if (uploadedFile.getExternalUrl() == null || uploadedFile.getExternalUrl().trim().equals("")) {
            logger.warn("While creating external file: empty URL");
            return com.hmdm.rest.json.Response.ERROR();
        }
        return SecurityContext.get().getCurrentUser().map(u -> {
            if (uploadedFile.getFilePath() == null) {
                uploadedFile.setFilePath("");
            }
            Customer customer = this.customerDAO.findById(u.getCustomerId());
            uploadedFile.setCustomerId(customer.getId().intValue());
            this.uploadedFileDAO.insert(uploadedFile);
            uploadedFile.setUrl(uploadedFile.getUrl(this.baseUrl, customer));
            return com.hmdm.rest.json.Response.OK((Object)uploadedFile);
        }).orElse(com.hmdm.rest.json.Response.PERMISSION_DENIED());
    }

    private com.hmdm.rest.json.Response updateFileInternal(UploadedFile uploadedFile) {
        return SecurityContext.get().getCurrentUser().map(u -> {
            Customer customer = this.customerDAO.findById(u.getCustomerId());
            if (!uploadedFile.isExternal()) {
                UploadedFile dbFile = this.uploadedFileDAO.getById(uploadedFile.getId());
                if (!StringUtil.isEmpty((String)uploadedFile.getTmpPath())) {
                    FileUtil.deleteFile((Customer)customer, (String)this.filesDirectory, (String)dbFile.getFilePath());
                    File movedFile = FileUtil.moveFile((Customer)customer, (String)this.filesDirectory, (String)dbFile.getSubdir(), (String)uploadedFile.getTmpPath(), (String)dbFile.getFileName());
                    if (movedFile == null) {
                        return com.hmdm.rest.json.Response.ERROR((String)"error.file.save");
                    }
                    try {
                        BasicFileAttributes attrs = Files.readAttributes(movedFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                        uploadedFile.setUploadTime(Long.valueOf(attrs.lastModifiedTime().toMillis()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return com.hmdm.rest.json.Response.INTERNAL_ERROR();
                    }
                }
                if (!dbFile.getFilePath().equals(uploadedFile.getFilePath())) {
                    if (!FileUtil.isSafePath((String)uploadedFile.getFilePath())) {
                        logger.error("Attempt to move a file to unsafe path: " + uploadedFile.getFilePath());
                        return com.hmdm.rest.json.Response.PERMISSION_DENIED();
                    }
                    String srcPath = String.format("%s/%s/%s", this.filesDirectory, customer.getFilesDir(), dbFile.getFilePath());
                    File movedFile = FileUtil.moveFile((Customer)customer, (String)this.filesDirectory, (String)"", (String)srcPath, (String)uploadedFile.getFilePath());
                    if (movedFile == null) {
                        logger.error("Failed to move a file to path: " + uploadedFile.getFilePath());
                        return com.hmdm.rest.json.Response.ERROR((String)"error.file.save");
                    }
                }
            }
            this.uploadedFileDAO.update(uploadedFile);
            return com.hmdm.rest.json.Response.OK();
        }).orElse(com.hmdm.rest.json.Response.PERMISSION_DENIED());
    }

    @ApiOperation(value="Search files", notes="Search files meeting the specified filter value", response=FileView.class, responseContainer="List")
    @GET
    @Path(value="/search/{value}")
    @Produces(value={"application/json"})
    public com.hmdm.rest.json.Response getFilesByName(@PathParam(value="value") @ApiParam(value="A filter value") String value) {
        if (!SecurityContext.get().hasPermission("files")) {
            logger.error("Unauthorized attempt to access file list by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        return com.hmdm.rest.json.Response.OK((Object)this.generateFilesList(value));
    }

    @ApiOperation(value="Get applications", notes="Gets the list of applications using the file", response=Application.class, responseContainer="List")
    @GET
    @Path(value="/apps/{url}")
    @Produces(value={"application/json"})
    public com.hmdm.rest.json.Response getApplicationsForFile(@PathParam(value="url") @ApiParam(value="An URL referencing the file") String url) {
        if (!SecurityContext.get().hasPermission("files")) {
            logger.error("Unauthorized attempt to access file list by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        try {
            String decodedUrl = URLDecoder.decode(url, "UTF-8");
            return com.hmdm.rest.json.Response.OK((Object)this.applicationDAO.getAllApplicationsByUrl(decodedUrl));
        }
        catch (Exception e) {
            logger.error("Unexpected error when getting the list of applications by URL", (Throwable)e);
            return com.hmdm.rest.json.Response.INTERNAL_ERROR();
        }
    }

    @GET
    @Path(value="/limit")
    @Produces(value={"application/json"})
    public com.hmdm.rest.json.Response getStorageLimit() {
        Customer currentCustomer;
        LimitResponse lr = new LimitResponse();
        if (!this.unsecureDAO.isSingleCustomer() && !(currentCustomer = this.customerDAO.findById(((Integer)SecurityContext.get().getCurrentCustomerId().get()).intValue())).isMaster() && currentCustomer.getSizeLimit() > 0) {
            File userDir = new File(this.filesDirectory, currentCustomer.getFilesDir());
            long userDirSize = 0L;
            if (userDir.exists()) {
                userDirSize = FileUtils.sizeOfDirectory((File)userDir);
            }
            lr.setSizeUsed((int)(userDirSize / 0x100000L));
            lr.setSizeLimit(currentCustomer.getSizeLimit());
        }
        return com.hmdm.rest.json.Response.OK((Object)lr);
    }

    @ApiOperation(value="Get file configurations", notes="Gets the list of configurations using requested file", response=ApplicationConfigurationLink.class, responseContainer="List")
    @GET
    @Path(value="/configurations/{id}")
    @Produces(value={"application/json"})
    public com.hmdm.rest.json.Response getFileConfigurations(@PathParam(value="id") @ApiParam(value="File ID") Integer id) {
        if (!SecurityContext.get().hasPermission("files")) {
            logger.error("Unauthorized attempt to get file configurations by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        return com.hmdm.rest.json.Response.OK((Object)this.uploadedFileDAO.getFileConfigurations(id));
    }

    @ApiOperation(value="Update file configurations", notes="Updates the list of configurations using requested file")
    @POST
    @Path(value="/configurations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public com.hmdm.rest.json.Response updateFileConfigurations(LinkConfigurationsToFileRequest request) {
        if (!SecurityContext.get().hasPermission("edit_files")) {
            logger.error("Unauthorized attempt to update file configurations by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        try {
            User user = (User)SecurityContext.get().getCurrentUser().get();
            if (!user.isAllConfigAvailable()) {
                request.getConfigurations().removeIf(c -> user.getConfigurations().stream().filter(uc -> uc.getId() == c.getConfigurationId()).findFirst() == null);
            }
            request.getConfigurations().removeIf(c -> {
                UploadedFile file = this.uploadedFileDAO.getById(Integer.valueOf(c.getFileId()));
                Configuration configuration = this.configurationDAO.getConfigurationById(Integer.valueOf(c.getConfigurationId()));
                return file.getCustomerId() != user.getCustomerId() || configuration.getCustomerId() != user.getCustomerId();
            });
            logger.info("File configurations updated by user " + SecurityContext.get().getCurrentUserName());
            this.uploadedFileDAO.updateFileConfigurations(request.getConfigurations());
            for (FileConfigurationLink configurationLink : request.getConfigurations()) {
                if (!configurationLink.isNotify()) continue;
                this.pushService.notifyDevicesOnUpdate(Integer.valueOf(configurationLink.getConfigurationId()));
            }
            return com.hmdm.rest.json.Response.OK();
        }
        catch (Exception e) {
            logger.error("Unexpected error when updating file configurations", (Throwable)e);
            return com.hmdm.rest.json.Response.INTERNAL_ERROR();
        }
    }

    @ApiOperation(value="Upload raw file", notes="Uploads the raw file to server (without attempt to parse APK). Returns a path to uploaded file", response=FileUploadResult.class)
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/raw")
    public com.hmdm.rest.json.Response uploadFilesRaw(@FormDataParam(value="file") InputStream uploadedInputStream, @ApiParam(value="A file to upload") @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws Exception {
        return this.uploadFilesInternal(uploadedInputStream, fileDetail, false);
    }

    @ApiOperation(value="Upload file or application", notes="Uploads the file or application to server. Returns a path to uploaded file", response=FileUploadResult.class)
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public com.hmdm.rest.json.Response uploadFiles(@FormDataParam(value="file") InputStream uploadedInputStream, @ApiParam(value="A file to upload") @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws Exception {
        return this.uploadFilesInternal(uploadedInputStream, fileDetail, true);
    }

    private com.hmdm.rest.json.Response uploadFilesInternal(InputStream uploadedInputStream, FormDataContentDisposition fileDetail, boolean parseFile) throws Exception {
        if (!SecurityContext.get().hasPermission("edit_files")) {
            logger.error("Unauthorized attempt to upload a file by user " + SecurityContext.get().getCurrentUserName());
            return com.hmdm.rest.json.Response.PERMISSION_DENIED();
        }
        try {
            Customer currentCustomer;
            String fileName = new String(fileDetail.getFileName().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            String adjustedFileName = FileUtil.adjustFileName((String)fileName);
            File uploadFile = FileUtil.createTempFile((String)adjustedFileName);
            FileUtil.writeToFile((InputStream)uploadedInputStream, (String)uploadFile.getAbsolutePath());
            FileUploadResult result = new FileUploadResult();
            result.setName(fileName);
            if (!this.unsecureDAO.isSingleCustomer() && !(currentCustomer = this.customerDAO.findById(((Integer)SecurityContext.get().getCurrentCustomerId().get()).intValue())).isMaster() && currentCustomer.getSizeLimit() > 0) {
                long totalSizeMb;
                File userDir = new File(this.filesDirectory, currentCustomer.getFilesDir());
                long userDirSize = 0L;
                long uploadFileSize = uploadFile.length();
                if (userDir.exists()) {
                    userDirSize = FileUtils.sizeOfDirectory((File)userDir);
                }
                if ((totalSizeMb = (userDirSize + uploadFileSize) / 0x100000L) > (long)currentCustomer.getSizeLimit()) {
                    uploadFile.delete();
                    logger.warn("Storage limit exceeded for customer {}: {}/{}", new Object[]{currentCustomer.getName(), totalSizeMb, currentCustomer.getSizeLimit()});
                    return com.hmdm.rest.json.Response.ERROR((String)"error.size.limit.exceeded", (Object)(totalSizeMb + " / " + currentCustomer.getSizeLimit()));
                }
            }
            result.setServerPath(uploadFile.getAbsolutePath());
            if (parseFile && fileName.endsWith("apk")) {
                List dbAppsByPkg;
                ApplicationVersion version;
                APKFileDetails apkFileDetails = this.apkFileAnalyzer.analyzeFile(uploadFile.getAbsolutePath());
                result.setFileDetails(apkFileDetails);
                if (apkFileDetails.getVersionCode() != 0 && (version = this.applicationDAO.findApplicationVersionByCode(apkFileDetails.getPkg(), apkFileDetails.getVersionCode())) != null && !version.getVersion().equals(apkFileDetails.getVersion())) {
                    logger.warn("Version of {} with code {} already exists, name {}", new Object[]{apkFileDetails.getPkg(), apkFileDetails.getVersionCode(), version.getVersion()});
                    return com.hmdm.rest.json.Response.DUPLICATE_ENTITY((String)"form.application.version.code.exists");
                }
                version = this.applicationDAO.findApplicationVersion(apkFileDetails.getPkg(), apkFileDetails.getVersion());
                if (StringUtil.isEmpty((String)apkFileDetails.getArch())) {
                    if (version != null) {
                        result.setExists(Boolean.valueOf(true));
                    }
                } else if (apkFileDetails.getArch().equals("armeabi")) {
                    result.setComplete(Boolean.valueOf(version != null && !StringUtil.isEmpty((String)version.getUrlArm64())));
                    result.setExists(Boolean.valueOf(version != null && (!version.isSplit() || !StringUtil.isEmpty((String)version.getUrlArmeabi()))));
                } else if (apkFileDetails.getArch().equals("arm64")) {
                    result.setComplete(Boolean.valueOf(version != null && !StringUtil.isEmpty((String)version.getUrlArmeabi())));
                    result.setExists(Boolean.valueOf(version != null && (!version.isSplit() || !StringUtil.isEmpty((String)version.getUrlArm64()))));
                }
                if (!(dbAppsByPkg = this.applicationDAO.findByPackageId(apkFileDetails.getPkg())).isEmpty()) {
                    Application dbApp = (Application)dbAppsByPkg.get(0);
                    Application dbAppCopy = new Application();
                    dbAppCopy.setId(dbApp.getId());
                    dbAppCopy.setShowIcon(dbApp.getShowIcon());
                    dbAppCopy.setUseKiosk(dbApp.getUseKiosk());
                    dbAppCopy.setRunAfterInstall(dbApp.isRunAfterInstall());
                    dbAppCopy.setRunAtBoot(dbApp.isRunAtBoot());
                    dbAppCopy.setSystem(dbApp.isSystem());
                    dbAppCopy.setName(dbApp.getName());
                    dbAppCopy.setPkg(dbApp.getPkg());
                    result.setApplication(dbAppCopy);
                }
            }
            return com.hmdm.rest.json.Response.OK((Object)result);
        }
        catch (Exception e) {
            logger.error("Unexpected error when handling file upload", (Throwable)e);
            return com.hmdm.rest.json.Response.ERROR();
        }
    }

    @ApiOperation(value="Download a file", notes="Downloads the content of the file", responseHeaders={@ResponseHeader(name="Content-Disposition")})
    @GET
    @Path(value="/{filePath}")
    @Produces(value={"application/octet-stream"})
    public Response downloadFile(@PathParam(value="filePath") @ApiParam(value="A path to a file") String filePath) throws Exception {
        File file = new File(filePath + "/" + URLDecoder.decode(filePath, "UTF8"));
        if (!file.exists()) {
            return Response.status((int)404).build();
        }
        ContentDisposition contentDisposition = ContentDisposition.type((String)"attachment").fileName(file.getName()).creationDate(new Date()).build();
        return Response.ok(output -> {
            try {
                FileInputStream input = new FileInputStream(file);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                output.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).header("Content-Disposition", (Object)contentDisposition).build();
    }

    private List<FileView> generateFilesList(String value) {
        List files = SecurityContext.get().getCurrentUser().map(u -> {
            Customer customer = this.customerDAO.findById(u.getCustomerId());
            List customerFiles = value != null ? this.uploadedFileDAO.getAllByValue(value) : this.uploadedFileDAO.getAll();
            List result = customerFiles.stream().map(f -> {
                FileView hFile = new FileView(f, this.baseUrl, this.filesDirectory, customer);
                hFile.setUsedByConfigurations(this.configurationFileDAO.getUsingConfigurations(customer.getId(), hFile.getId()));
                hFile.setUsedByIcons(this.iconDAO.getUsingIcons(customer.getId(), hFile.getId()));
                return hFile;
            }).collect(Collectors.toList());
            return result;
        }).orElse(new LinkedList());
        return files;
    }

    private void handleFile(File file, List<FileView> result, String value, Customer customer) {
        String customerFilesBaseDir = customer.getFilesDir();
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                File[] filesArray = files = file.listFiles();
                int length = files.length;
                for (int i = 0; i < length; ++i) {
                    File fl = filesArray[i];
                    this.handleFile(fl, result, value, customer);
                }
            } else if (value == null || file.getName().contains(value)) {
                String url;
                Object path = file.getParentFile().getAbsolutePath().replace(this.filesDirectory.replace("/", File.separator), "");
                if (!((String)path).endsWith(File.separator)) {
                    path = (String)path + File.separator;
                }
                if (customerFilesBaseDir != null && !customerFilesBaseDir.isEmpty()) {
                    path = ((String)path).substring((File.separator + customerFilesBaseDir + File.separator).length());
                    url = String.format("%s/files/%s/%s", this.baseUrl, customerFilesBaseDir, ((String)path).replace(File.separator, "/") + file.getName());
                } else {
                    url = String.format("%s/files%s", this.baseUrl, ((String)path).replace(File.separator, "/") + file.getName());
                }
                FileView fileObj = new FileView((String)path, file.getName(), url, file.length());
                fileObj.setUsedByConfigurations(this.configurationFileDAO.getUsingConfigurations(customer.getId(), fileObj.getId()));
                fileObj.setUsedByIcons(this.iconDAO.getUsingIcons(customer.getId(), fileObj.getId()));
                result.add(fileObj);
            }
        }
    }
}

