/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.persistence.domain.ConfigurationFile;
import com.hmdm.rest.json.SyncConfigurationFileInt;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(description="A single configuration file to be used on mobile device and used in data synchronization between mobile device and server application")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncConfigurationFile
implements Serializable,
SyncConfigurationFileInt {
    @JsonIgnore
    private final ConfigurationFile wrapped;

    public SyncConfigurationFile(ConfigurationFile file) {
        this.wrapped = file;
    }

    @ApiModelProperty(value="A description of the file")
    public String getDescription() {
        return null;
    }

    @ApiModelProperty(value="A checksum for the file content")
    public String getChecksum() {
        return this.wrapped.getChecksum();
    }

    @ApiModelProperty(value="A flag indicating if file is to be removed from the device or not")
    public Boolean getRemove() {
        return this.wrapped.isRemove() ? Boolean.valueOf(true) : null;
    }

    @ApiModelProperty(value="A timestamp of file uploading to server (in milliseconds since epoch time)")
    public Long getLastUpdate() {
        return this.wrapped.getLastUpdate();
    }

    @ApiModelProperty(value="A path to a file on device")
    public String getPath() {
        return this.wrapped.getDevicePath();
    }

    @ApiModelProperty(value="An URL referencing the content of the file")
    public String getUrl() {
        return this.wrapped.getUrl();
    }

    @ApiModelProperty(value="A flag indicating whether the file content must be updated by device-specific values")
    public Boolean getVarContent() {
        return this.wrapped.isReplaceVariables() ? Boolean.valueOf(true) : null;
    }
}

