/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.guice.module;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.hmdm.event.EventService;
import com.hmdm.guice.module.StartupTaskModule;
import com.hmdm.persistence.CommonDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.service.RsaKeyService;
import com.hmdm.task.CustomerStatusTask;
import com.hmdm.task.FileCheckTask;
import com.hmdm.task.FileMigrateTask;
import com.hmdm.util.BackgroundTaskRunnerService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupTaskModule {
    private CommonDAO commonDAO;
    private UnsecureDAO unsecureDAO;
    private BackgroundTaskRunnerService taskRunner;
    private int deviceFastSearchChars;
    private String sqlInitScriptPath;
    private CustomerStatusTask customerStatusTask;
    private FileCheckTask fileCheckTask;
    private FileMigrateTask fileMigrateTask;
    private boolean customerAutoStatus;
    private boolean transmitPassword;
    private RsaKeyService rsaKeyService;
    private static final Logger logger = LoggerFactory.getLogger(EventService.class);

    @Inject
    public StartupTaskModule(CommonDAO commonDAO, UnsecureDAO unsecureDAO, BackgroundTaskRunnerService taskRunner, CustomerStatusTask customerStatusTask, FileCheckTask fileCheckTask, FileMigrateTask fileMigrateTask, RsaKeyService rsaKeyService, @Named(value="device.fast.search.chars") int deviceFastSearchChars, @Named(value="sql.init.script.path") String sqlInitScriptPath, @Named(value="customer.auto.status") boolean customerAutoStatus, @Named(value="transmit.password") boolean transmitPassword) {
        this.commonDAO = commonDAO;
        this.unsecureDAO = unsecureDAO;
        this.taskRunner = taskRunner;
        this.deviceFastSearchChars = deviceFastSearchChars;
        this.sqlInitScriptPath = sqlInitScriptPath;
        this.customerStatusTask = customerStatusTask;
        this.fileCheckTask = fileCheckTask;
        this.fileMigrateTask = fileMigrateTask;
        this.customerAutoStatus = customerAutoStatus;
        this.transmitPassword = transmitPassword;
        this.rsaKeyService = rsaKeyService;
    }

    public void init() {
        this.taskRunner.submitTask((Runnable)new UpdatePasswordTask(this));
        this.taskRunner.submitTask((Runnable)new UpdateDeviceFastSearchTask(this));
        this.taskRunner.submitTask((Runnable)new ResetUserLoginFailTimeTask(this));
        this.taskRunner.submitTask((Runnable)this.fileMigrateTask);
        if (!this.sqlInitScriptPath.equals("")) {
            this.taskRunner.submitTask((Runnable)new ExecuteInitSqlTask(this));
        }
        if (this.customerAutoStatus) {
            this.taskRunner.submitRepeatableTask((Runnable)this.customerStatusTask, 0L, 1L, TimeUnit.HOURS);
        }
        this.taskRunner.submitRepeatableTask((Runnable)this.fileCheckTask, 5L, 60L, TimeUnit.MINUTES);
        if (this.transmitPassword) {
            this.taskRunner.submitTask((Runnable)new GenerateRsaKeysTask(this));
        }
    }
}

