if ( !document.localization ) document.localization = [];

document.localization[ 'ru_RU' ] = {
    'login.username': 'Имя пользователя или email',
    'login.username.placeholder': 'Введите имя пользователя или email',
    'login.password': 'Пароль:',
    'login.password.placeholder': 'Введите пароль',
    'login.submit': 'Войти',
    'login.password.incorrect': 'Неверные имя пользователя или пароль',
    'login.password.recovery': 'Забыли пароль?',
    'recovery.password': 'Восстановить пароль',
    'recovery.password.success': 'Инструкция по восстановлению пароля отправлена на ваш email',
    'login.no.account': 'Нет учетной записи?',
    'login.signup': 'Регистрация',

    'signup.title': 'Начать',
    'signup.email': 'Ваш адрес электронной почты',
    'signup.email.placeholder': 'Введите действительный адрес электронной почты',
    'signup.email.invalid': 'Введите действительный адрес электронной почты',
    'signup.terms.agree': 'Я согласен с',
    'signup.terms.terms': 'условиями использования',
    'signup.submit': 'Зарегистрироваться',
    'signup.progress': 'Регистрация...',
    'signup.email.used': 'Клиент с таким адресом электронной почты уже зарегистрирован',
    'signup.name.used': 'Клиент с таким именем пользователя уже зарегистрирован',
    'signup.complete': 'Спасибо за регистрацию!',
    'signup.email.check': 'Пожалуйста, проверьте свою электронную почту и перейдите по ссылке, чтобы завершить регистрацию!',
    'signup.complete.title': 'Ваша учетная запись в ${appName} почти готова!',
    'signup.ready.title': 'Ваша учетная запись в ${appName} готова!',
    'signup.customer.id': 'Имя пользователя',
    'signup.customer.id.placeholder': 'Использовать только буквы и цифры',
    'signup.customer.id.invalid': 'Используйте 6 или более символов, только буквы и цифры',
    'signup.first.name': 'Имя',
    'signup.first.name.placeholder': 'Ваше имя (обязательно)',
    'signup.last.name': 'Фамилия',
    'signup.last.name.placeholder': 'Ваша фамилия (обязательно)',
    'signup.company': 'Название компании',
    'signup.company.placeholder': 'Название вашей компании (необязательно)',
    'signup.description': 'Как вы будете использовать MDM?',
    'signup.description.placeholder': 'Это поможет нашей команде помочь вам',
    'signup.password': 'Пароль',
    'signup.password.repeat': 'Повторите пароль',
    'signup.password.placeholder': '6+ символов',
    'signup.password.short': 'Пожалуйста, введите не менее 6 символов',
    'signup.password.not.match': 'Пароли не совпадают',
    'signup.finalized.title': 'Ваш аккаунт готов!',
    'signup.finalized.description': 'В ближайшее время вы должны получить электронное письмо с полезными инструкциями. Пожалуйста, просмотрите это письмо и войдите в веб-панель, используя свое имя пользователя и пароль.',
    'signup.token.invalid.title': 'Токен недействителен или уже используется',
    'signup.token.invalid.description': 'Пожалуйста, повторите попытку регистрации, чтобы создать новую учетную запись!',

    'header.label.username': 'Имя пользователя',

    'summary.devices.status': 'Состояние устройства',
    'summary.devices.active': 'Активное',
    'summary.devices.idle': 'Требует внимания',
    'summary.devices.offline': 'Не в сети',
    'summary.devices.enrollment': 'Регистрация устройств',
    'summary.devices.enrolled.total': 'Всего зарегистрировано',
    'summary.devices.enrolled.earlier': 'Зарегистрировано ранее',
    'summary.devices.enrolled.monthly': 'Последние 30 дней',
    'summary.devices.installation.status': 'Состояние приложений',
    'summary.devices.installation.completed': 'Завершено',
    'summary.devices.version.mismatch': 'Ошибка версии',
    'summary.devices.installation.failed': 'Ошибка установки',
    'summary.devices.enrolled.lastyear': 'Последние 12 месяцев',

    'devices.group.options.all': 'Все группы',
    'devices.configuration.options.all': 'Все конфигурации',
    'devices.permissions.all': 'Все разрешения выданы',
    'devices.permissions.not.as.device.admin': '- Приложение не установлено как администратор устройства',
    'devices.permissions.window.overlap.prohibited': '- Наложение поверх других окон недоступно',
    'devices.permissions.history.access.prohibited': '- Доступ к истории использования не настроен',
    'devices.unknown': 'Неизвестен',
    'devices.model.unknown': 'Неизвестна',
    'devices.date.unknown': 'неизвестно',
    'devices.date.format': 'dd/MM/yy HH:mm',
    'devices.app.installed': '- ${applicationName}: установл.',
    'devices.app.not.installed': '- ${applicationName}: не установл.',
    'devices.app.version.available': ', доступна ${applicationVersion}',
    'devices.app.installed.and.version.available': '- ${applicationName}: установл. ${applicationInstalledVersion}, доступна ${applicationVersionAvailable}',
    'devices.app.needs.removal': '${applicationVersion}, требуется удаление',
    'devices.no.data': 'Устройство не передало данных',
    'devices.settings.conformance.broken': 'Несоответствие настройкам: (${serverData})',
    'devices.file.installed': '- ${file}: установл.',
    'devices.file.not.installed': '- ${file}: не установл.',
    'devices.file.lastUpdate.differs': '- ${file}: различие во врмени модификации ${diff} мин',

    'button.apply': 'Применить',
    'button.gps.on': 'Включить GPS',
    'button.wifi.on': 'Включить Wi-Fi',
    'button.notify.update': 'Уведомить об обновлении',
    'button.app.settings': 'Настройки приложений',
    'button.ok': 'OK',
    'button.help': 'Помощь',
    'button.new.app': 'Новое приложение',
    'button.new.app.version': 'Новая версия',
    'button.upgrade': 'Обновить',
    'button.renew.config': 'Обновить на устройствах',
    'button.common': 'Общедоступное приложение',
    'button.close': 'Закрыть',
    'button.yes': 'Да',
    'button.cancel': 'Отмена',
    'button.save': 'Сохранить',
    'button.save.and.close': 'Сохранить и закрыть',
    'button.more': 'Ещё...',
    'button.cleanup': 'Очистить',
    'button.add': 'Добавить',
    'button.add.icon': 'Новая',
    'button.search': 'Поиск',
    'button.export': 'Экспорт',
    'button.change': 'Изменить',
    'button.copy': 'Копировать',
    'button.qrcode': 'QR-код',
    'button.application': 'Приложение',
    'button.change.password': 'Сменить пароль',
    'button.set.configuration': 'Задать конфигурацию',
    'button.set.group': 'Задать группу',
    'button.group.action': 'Действие с группой',
    'button.delete': 'Удалить',
    'button.login': 'Логин',
    'button.renew.code': 'Обновить код',
    'button.configurations': 'Конфигурации',
    'button.set.configurations': 'Указать конфигурации',
    'button.edit.versions': 'Версии',
    'button.edit': 'Редактировать',
    'button.change.common.app': 'Изменить общее приложение',
    'button.delete.common.app': 'Удалить общее приложение',
    'button.turn.common.app': 'Сделать общим',
    'button.hints.enable': 'Показывать подсказки',
    'button.hints.disable': 'Скрыть подсказки',
    'button.show.password': 'Показать пароль',
    'button.hide.password': 'Скрыть пароль',

    'question.impersonate.user': 'Войти в приложение от имени администратора организации "${customerName}"?',
    'question.change.user': 'Войти в приложение от имени пользователя "${userName}"?',
    'question.delete.file': 'Удалить файл "${fileName}"?',
    'question.delete.customer': 'Удалить организацию "${customerName}"?',
    'question.delete.user': 'Удалить пользователя "${username}"?',
    'question.delete.application': 'Удалить приложение "${applicationName}"?',
    'question.delete.application.version': 'Удалить версию "${applicationVersion}"?',
    'question.delete.configuration': 'Удалить конфигурацию "${configurationName}"?',
    'question.delete.group': 'Удалить группу "${groupName}"?',
    'question.delete.role': 'Удалить роль "${roleName}"?',
    'question.delete.icon': 'Удалить иконку "${iconName}"?',
    'question.delete.device.bulk': 'Удалить выбранные устройства?',
    'question.delete.device': 'Удалить устройство с номером "${deviceNumber}"?',
    'question.exit.without.saving': 'Изменения не сохранены. Всё равно покинуть эту страницу?',
    'question.turn2common.application': 'Сделать общим приложение "${applicationName}"?',
    'question.app.upgrade': 'Обновить приложение "${v1}" до последней версии для конфигурации "${v2}"?',

    'error.application.setting.empty.app': 'Укажите приложение',
    'error.application.setting.empty.name': 'Укажите название',
    'error.application.setting.empty.value': 'Укажите значение',

    'error.icon.dimension.invalid': 'Иконка должна быть квадратной',
    'error.icon.empty.name': 'Введите название иконки',
    'error.icon.empty.file': 'Загрузите файл иконки',
    'error.application.version.pkg.mismatch': 'ID пакета файла (${actual}) не соответствует приложению (${expected})',
    'error.empty.user': 'Выберите пользователя',
    'error.empty.user.name': 'Заполните имя пользователя',
    'error.empty.user.login': 'Заполните login пользователя',
    'error.empty.user.role': 'Выберите роль пользователя',
    'error.empty.password': 'Введите новый пароль',
    'error.empty.password.confirm': 'Введите подтверждение пароля',
    'error.user.not.found': 'Пользователь не найден',
    'error.email.not.configured': 'Электронная почта не настроена',
    'error.email.not.found': 'Электронная почта пользователя не указана',
    'error.empty.group.name': 'Заполните название группы',
    'error.empty.configuration': 'Укажите конфигурацию',
    'error.empty.configuration.name': 'Заполните имя конфигурации',
    'error.empty.configuration.password': 'Заполните пароль',
    'error.empty.configuration.contentApp': 'Не указано контентное приложение',
    'error.empty.group': 'Добавьте устройство в одну или несколько групп',
    'error.invalid.character': 'Номер устройства не может содержать символы / ? &',
    'error.invalid.configuration.mainApp': 'В настройках MDM используется неверное главное приложение',
    'error.invalid.configuration.contentApp': 'В настройках MDM используется неверное контентное приложение',
    'error.mismatch.password': 'Пароль и подтверждение пароля должны совпадать',
    'error.empty.customer.name': 'Заполните имя организации',
    'error.empty.customer.prefix': 'Заполните префикс номеров устройств',
    'error.empty.customer.device.configuration': 'Выберите конфигурацию устройств',
    'error.empty.customer.duplicate.prefix': 'Префикс уже используется',
    'error.duplicate.customer.name': 'Организация с введенным именем уже существует. Попробуйте другое имя.',
    'error.duplicate.group.name': 'Группа с введенным именем уже существует. Попробуйте другое имя.',
    'error.duplicate.configuration.name': 'Конфигурация с введенным именем уже существует. Попробуйте другое имя.',
    'error.duplicate.device.number': 'Устройство с таким номером уже существует',
    'error.internal.server': 'Внутренняя ошибка сервера',
    'error.permission.denied': 'Нет прав для выполнения',
    'error.request.failure': 'Ошибка при выполнении запроса',
    'error.configuration.device.use': 'Невозможно удалить эту конфигурацию, она используется на устройствах. Сначала перейдите в "Устройства", найдите устройства, использующие эту конфигурацию, и измените их настройки.',
    'error.invalid.system.update.time': 'Неверный интервал врмение установки',
    'error.size.limit.exceeded': 'Превышен лимит хранилища',

    'error.configuration.file.empty.name': 'Укажите название файла',
    'error.configuration.file.empty.desc': 'Укажите описание файла',
    'error.configuration.file.empty.path': 'Укажите путь на устройстве',
    'error.configuration.file.empty.file': 'Пожалуйста, загрузите файл',
    'error.configuration.file.empty.url': 'Пожалуйста, укажите URL файла',

    'error.notfound.device': 'Устройство не найдено',
    'error.duplicate.device': 'Устройство с таким номером уже существует',
    'error.duplicate.login': 'Такой логин уже используется',
    'error.duplicate.email': 'Пользователь с таким email уже существует',
    'error.duplicate.group': 'Группа с таким именем уже существует',
    'error.duplicate.application': 'Приложение c таким ID пакета и версией уже существует',
    'error.recent.application.version.exists': 'Существует более поздняя версия приложения',
    'error.common.application.access.prohibited': 'Управлять общим приложением может только Супер-Администратор',
    'error.application.config.reference.exists': 'Приложение используется в конфигурациях и не может быть удалено',
    'error.application.version.deletion.prohibited': 'Версия либо явялется единственной, либо используется в конфигурациях и не может быть удалена',
    'error.duplicate.file': 'Файл с таким именем уже существует',
    'error.used.file': 'Этот файл используется',
    'error.version.exists': 'Такая версия этого приложения уже существует',
    'error.duplicate.configuration': 'Конфигурация с таким именем уже существует',
    'error.duplicate.role.name': 'Роль с таким названием уже существует',
    'error.empty.role.name': 'Пожалуйста, укажите название роли',
    'error.duplicate.icon.name': 'Иконка с таким именем уже существует',
    'error.notfound.customer.admin': 'Не найдена учетная запись администратора',
    'error.apk.file.required': 'Выберите файл с расширением .apk или .xapk',
    'error.apk.parse': 'При разборе файла на сервере возникла ошибка',
    'error.package.not.match': 'Идентификатор пакета не совпадает',
    'error.empty.app.name': 'Введите название приложения',
    'error.empty.app.pkg': 'Введите ID пакета',
    'error.empty.app.url': 'Введите URL',
    'error.empty.app.iconText': 'Введите текст ярлыка',
    'error.empty.app.version': 'Введите версию приложения',
    'error.notempty.group': 'В данную группу входят одно или несколько устройств. Вы не можете её удалить.',
    'error.file.empty': 'Загрузите новый файл',
    'error.file.deletion': 'Ошибка при удалении файла на сервере',
    'error.file.save': 'Ошибка при сохранении файла на сервере',
    'error.password.wrong': 'Неверный пароль',
    'error.password.empty': 'Пароль не указан',
    'error.password.weak': 'Слабое качество пароля',
    'error.params.missing': 'Отсутствуют параметры:',
    'error.empty.push.options': 'Пожалуйста, выберите вариант Push-уведомлений',
    'error.app.name.exists': 'Приложение с таким названием уже есть. Укажите уникальное имя.',

    'table.filtering.check.all': 'Выбрать все',
    'table.filtering.uncheck.all': 'Отменить все',
    'table.filtering.suffix.configuration': 'конфигураций',
    'table.filtering.suffix.group': 'групп',
    'table.filtering.suffix.permission': 'разрешений',
    'table.filtering.no.selected.configuration': 'Нет выбранных конфигураций',
    'table.filtering.no.selected.group': 'Нет выбранных групп',
    'table.filtering.no.selected.permission': 'Нет выбранных разрешений',

    'success.admin.created': 'Создана учетная запись администратора:\n${adminCredentials}',
    'success.uploading.file': 'Файл загружается на сервер...',
    'success.loading.devices': 'Загрузка списка устройств...',
    'success.loading.customer': 'Загрузка данных организации ...',
    'success.file.uploaded': 'Файл успешно загружен.',
    'success.file.uploaded.need.save': 'Файл успешно загружен. Введите относительный путь и нажмите кнопку "Сохранить".',
    'success.settings.design.saved': 'Настройки дизайна сохранены успешно',
    'success.settings.common.saved': 'Настройки столбцов сохранены успешно',
    'success.settings.saved': 'Настройки сохранены успешно',
    'success.settings.apiKey.saved': 'Ключ API сохранен успешно',
    'success.settings.hints.enabled': 'Показ подсказок разрешен',
    'success.settings.hints.disabled': 'Показ подсказок запрещен',
    'success.configuration.saved': 'Конфигурация успешно сохранена',
    'success.operation.completed': 'Операция завершена успешно',
    'success.plugins.disabled': 'Настройки сохранены успешно',
    'success.config.update.notification': 'Команда обновления конфигурации отправлена на устройства',
    'success.config.update.device.app.settings.notification': 'Команда обновления настроек приложений отправлена на устройство',

    'form.icon.title': 'Иконка',
    'form.icon.name': 'Название',
    'form.icon.file': 'Файл',

    'configuration.add.warning': 'Вы уверены, что хотите создать пустую конфигурацию? Вам нужно будет добавить все необходимые системные приложения вручную. Рекомендуем скопировать и существующую конфигурацию и модифицировать копию.',
    'configuration.remove.warning': 'Вы уверены, что хотите удалить последнюю конфигурацию? Вы потеряете информацию о том, какие системные приложения требуются.',
    'form.configuration.title': 'Конфигурация',
    'form.configuration.title.typical': 'Типовая конфигурация',
    'form.configuration.settings.auto.update': 'Автообновление',
    'form.configuration.settings.system.update': 'Обновление системы',
    'form.configuration.settings.system.update.default': 'Любой',
    'form.configuration.settings.system.update.immediate': 'Немедленно',
    'form.configuration.settings.system.update.scheduled': 'По распис-ю',
    'form.configuration.settings.system.update.postponed': 'По запросу',
    'form.configuration.settings.system.update.time': 'Время установки',
    'form.configuration.settings.system.update.time.from': 'c:',
    'form.configuration.settings.system.update.time.to': 'по:',
    'form.configuration.settings.system.schedule.app.update': 'Обновление приложений по распис-ю',
    'form.configuration.settings.system.app.update.time': 'Время установки',
    'form.configuration.settings.download.updates': 'Загрузка контента',
    'form.configuration.settings.download.updates.unlimited': 'Без ограничений',
    'form.configuration.settings.download.updates.limited': '3 попытки в мобильной сети',
    'form.configuration.settings.download.updates.wifi': 'Только через WiFi',
    'form.configuration.settings.block.status.bar': 'Блокировка статус-бара',
    'form.configuration.settings.block.status.bar.hint': 'Этот параметр устарел и работает только на Android 6 и ниже. Чтобы заблокировать строку состояния в новых версиях Android, используйте режим киоска (настройки MDM).',
    'form.configuration.settings.mdm.kiosk.mode': 'Режим киоска',
    'form.configuration.settings.mdm.app.main': 'MDM приложение',
    'form.configuration.settings.mdm.component.event.receiver': 'Класс - администратор',
    'form.configuration.settings.mdm.component.event.receiver.placeholder': 'Должен быть com.hmdm.launcher.AdminReceiver',
    'form.configuration.settings.mdm.component.wifi.ssid': 'WiFi SSID',
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'WiFi SSID - оставьте пустым для ручного ввода',
    'form.configuration.settings.mdm.component.wifi.password': 'WiFi пароль',
    'form.configuration.settings.mdm.component.wifi.password.placeholder': 'WiFi пароль - оставьте пустым для ручного ввода',
    'form.configuration.settings.mdm.component.wifi.security': 'Тип защиты WiFi',
    'form.configuration.settings.mdm.component.wifi.notice': 'Внимание: настройки WiFi применяются только для начальной регистрации устройства!',
    'form.configuration.settings.mdm.component.server.url': 'URL нового сервера',
    'form.configuration.settings.mdm.component.server.url.placeholder': 'Заполняется при миграции на новый MDM сервер',
    'form.configuration.settings.mdm.app.content': 'Контентное приложение',
    'form.configuration.settings.mdm.kiosk.home': 'Разрешить кнопку Home',
    'form.configuration.settings.mdm.kiosk.recents': 'Разрешить кнопку Recents',
    'form.configuration.settings.mdm.kiosk.notifications': 'Разрешить уведомления',
    'form.configuration.settings.mdm.kiosk.system.info': 'Разрешить информацию в статус-баре',
    'form.configuration.settings.mdm.kiosk.keyguard': 'Разрешить блокировку экрана',
    'form.configuration.settings.mdm.kiosk.lock.buttons': 'Блокировка кнопки питания',
    'form.configuration.settings.mdm.mobile.enrollment': 'Настраивать через мобильную сеть',
    'form.configuration.settings.mdm.encrypt.device': 'Зашифровать хранилище устройства',
    'form.configuration.settings.mdm.lock.safe.settings': 'Блокировать безопасные настройки',
    'form.configuration.settings.mdm.permissive': 'Отключить блокировки',
    'form.configuration.settings.mdm.kiosk.exit': 'Кнопка выхода из киоска',
    'form.configuration.settings.mdm.allowed.classes': 'Разрешенные активити',
    'form.configuration.settings.mdm.allowed.classes.placeholder': 'Классы через запятую, например: com.android.settings.homepage.SettingsHomepageActivity',
    'form.configuration.settings.mdm.restrictions': 'Ограничения',
    'form.configuration.settings.mdm.restrictions.placeholder': 'MDM ограничения, через запятую, например: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.misc': 'Другие записи QR-кода',
    'form.configuration.settings.mdm.misc.placeholder': 'Записи, разделенные запятыми, например:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url': 'URL QR-кода',
    'form.configuration.settings.mdm.hint': 'Выберите главное приложение и компонент',
    'form.configuration.apps.search.label': 'Поиск:',
    'form.configuration.apps.sort.label': 'Сортировать:',
    'form.configuration.apps.sort.byname': 'По имени',
    'form.configuration.apps.sort.bypkg': 'По ID',
    'form.configuration.apps.no.apk': 'нет',
    'form.configuration.apps.show.systeam.apps': 'Показать системные',
    'form.configuration.apps.action.select': '(выберите)',
    'form.configuration.apps.action.install': 'Установить',
    'form.configuration.apps.action.prohibit': 'Блокировать',
    'form.configuration.apps.action.not.install': 'Не устанавливать',
    'form.configuration.apps.action.delete': 'Удалить',
    'form.configuration.apps.action.permit': 'Разрешить',
    'form.configuration.apps.label.inherit': 'Наследуется',
    'form.configuration.apps.label.show': 'Показывать',
    'form.configuration.apps.label.not.show': 'Не показывать',
    'form.configuration.apps.edit.details': 'Дополнительные параметры',
    'form.configuration.apps.keycode': 'Код кнопки запуска',
    'form.configuration.apps.bottom': 'Отображать в нижней строке',
    'form.configuration.apps.long.tap': 'Настройки по долгому нажатию',
    'form.configuration.apps.hint': 'Совет: чтобы убрать приложения из этого списка, выберите действие "Блокировать" или "Не устанавливать".',
    'form.configuration.settings.design.use.default': 'Использовать дизайн по умолчанию',
    'form.configuration.settings.design.color.background': 'Цвет фона',
    'form.configuration.settings.design.color.background.placeholder': 'Выберите цвет',
    'form.configuration.settings.design.color.app.names': 'Цвет названий приложений',
    'form.configuration.settings.design.color.app.names.placeholder': 'Выберите цвет',
    'form.configuration.settings.design.background.image.url': 'URL фонового изображения',
    'form.configuration.settings.design.background.image.url.placeholder': 'Введите url фонового изображения',
    'form.configuration.settings.design.icon': 'Размер иконок',
    'form.configuration.settings.design.icon.small': 'Маленькие',
    'form.configuration.settings.design.icon.medium': 'Средние (+20%)',
    'form.configuration.settings.design.icon.large': 'Большие (+40%)',
    'form.configuration.settings.design.desktop.header': 'Заголовок рабочего стола',
    'form.configuration.settings.design.desktop.header.no': 'Нет',
    'form.configuration.settings.design.desktop.header.deviceid': 'ID устройства',
    'form.configuration.settings.design.desktop.header.description': 'Описание',
    'form.configuration.settings.design.desktop.header.custom': 'Шаблон',
    'form.configuration.settings.design.desktop.header.hint': 'Проверьте, что параметр отправляется на устройства (Настройки - Общие и языковые настройки)',
    'form.configuration.settings.design.desktop.header.template': 'Введите шаблон',
    'form.configuration.settings.design.desktop.header.template.placeholder': 'Используйте переменные',
    'form.configuration.settings.design.display.status': 'Отображать время и статус батареи',
    'form.configuration.settings.design.upload': 'Загрузить',
    'form.configuration.settings.common.name': 'Название',
    'form.configuration.settings.common.name.placeholder': 'Введите название конфигурации',
    'form.configuration.settings.common.desc': 'Описание',
    'form.configuration.settings.common.desc.placeholder': 'Введите описание конфигурации',
    'form.configuration.settings.common.admin.pwd': 'Пароль разблокировки',
    'form.configuration.settings.common.admin.pwd.placeholder': 'Введите пароль разблокировки',
    'form.configuration.settings.common.gps': 'GPS',
    'form.configuration.settings.common.gps.any': 'Любой',
    'form.configuration.settings.common.gps.off': 'Выключен',
    'form.configuration.settings.common.gps.on': 'Включен',
    'form.configuration.settings.common.bluetooth': 'Bluetooth',
    'form.configuration.settings.common.wifi': 'Wi-Fi',
    'form.configuration.settings.common.mobile.data': 'Мобильные данные',
    'form.configuration.settings.common.usb.storage': 'Блокировка USB диска',
    'form.configuration.settings.common.brightness': 'Управление яркостью',
    'form.configuration.settings.common.brightness.none': 'Нет',
    'form.configuration.settings.common.brightness.auto': 'Авто',
    'form.configuration.settings.common.brightness.manual': 'Значение',
    'form.configuration.settings.common.brightness.value': 'Яркость экрана',
    'form.configuration.settings.common.timeout': 'Управление таймаутом экрана',
    'form.configuration.settings.common.timeout.value': 'Таймаут экрана (с)',
    'form.configuration.settings.common.volume.block': 'Блокировка громкости',
    'form.configuration.settings.common.volume.manage': 'Управлять громкостью',
    'form.configuration.settings.common.volume.value': 'Громкость',
    'form.configuration.settings.common.timezone.mode': 'Управление временной зоной',
    'form.configuration.settings.common.timezone.mode.default': 'Не управлять',
    'form.configuration.settings.common.timezone.mode.auto': 'Автоматически',
    'form.configuration.settings.common.timezone.mode.manual': 'Вручную',
    'form.configuration.settings.common.timezone': 'Временная зона',
    'form.configuration.settings.common.timezone.placeholder': 'Например, Europe/Moscow',
    'form.configuration.settings.common.timezone.link': 'Список временных зон',
    'form.configuration.settings.common.no.network.warning': 'ВНИМАНИЕ! Не отключайте все каналы связи, это может привести к недоступности управления устройствами!',
    'form.configuration.settings.common.autostart.foreground': 'Показывать приложения после автозапуска',
    'form.configuration.settings.request.updates': 'Отслеживание местоположения',
    'form.configuration.settings.request.updates.donottrack': 'Не активно (используются только данные сторонних приложений)',
    'form.configuration.settings.request.updates.gps': 'Отслеживать по GPS',
    'form.configuration.settings.request.updates.wifi': 'Отслеживать по Wi-Fi (должны быть включены сервисы Google)',
    'form.configuration.settings.request.updates.prompt.gps': 'Для отслеживания местоположения по GPS необходимо включить GPS',
    'form.configuration.settings.request.updates.prompt.wifi': 'Для отслеживания местоположения по Wi-Fi необходимо включить Wi-Fi',
    'form.configuration.settings.revoke.location.permission': 'Не разрешать определять местоположение',
    'form.configuration.settings.revoke.location.permission.hint': 'Если установлено, разрешение на определение местоположения не будет предоставлено агенту MDM, и он не сможет отслеживать местоположение устройства',
    'form.configuration.settings.apps.permissions': 'Разрешения для других приложений',
    'form.configuration.settings.apps.permissions.grant': 'Автоматическое предоставление всех разрешений',
    'form.configuration.settings.apps.permissions.ask.location': 'Автоматически предоставлять все, запрашивать у пользователя разрешение на местоположение',
    'form.configuration.settings.apps.permissions.deny.location': 'Автоматически предоставлять все, не предоставлять разрешение на местоположение',
    'form.configuration.settings.apps.permissions.ask.all': 'Запросить у пользователя все разрешения',
    'form.configuration.settings.push.options' : 'Push-уведомления',
    'form.configuration.settings.push.options.mqtt.worker' : 'MQTT протокол (энергосбережение)',
    'form.configuration.settings.push.options.mqtt.alarm' : 'MQTT протокол',
    'form.configuration.settings.push.options.polling' : 'HTTP Long Polling',
    'form.configuration.settings.push.options.mqtt.worker.hint' : 'Доставляет Push-сообщения мгновенно, когда устройство активно. Но в спящем режиме сообщения могут задерживаться на несколько часов. Не используйте эту опцию на автономных устройствах. MQTT использует TCP-порт 31000, включите его на вашем брандмауэре.',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT — это легкий протокол, потребляющий минимум ресурсов. MQTT использует порт TCP 31000, включите его в своем брандмауэре.',
    'form.configuration.settings.push.options.polling.hint' : 'Поддерживает постоянное HTTP-соединение, что может потреблять больше ресурсов сервера. Не требует никаких TCP-портов, кроме HTTP(S).',
    'form.configuration.settings.push.options.keepalive' : 'Время Keep-Alive',
    'form.configuration.settings.minute.1' : '1 минута',
    'form.configuration.settings.minutes.2' : '2 минуты',
    'form.configuration.settings.minutes.3' : '3 минуты',
    'form.configuration.settings.minutes.5' : '5 минут',
    'form.configuration.settings.minutes.10' : '10 минут',
    'form.configuration.settings.minutes.15' : '15 минут',
    'form.configuration.settings.password.mode' : 'Требования к паролю',
    'form.configuration.settings.password.mode.any' : 'Нет',
    'form.configuration.settings.password.mode.present' : 'Пароль должен присутствовать',
    'form.configuration.settings.password.mode.easy' : 'Простой (6 символов или более)',
    'form.configuration.settings.password.mode.moderate' : 'Средний (8+ символов, буквы и цифры)',
    'form.configuration.settings.password.mode.strong' : 'Сложный (8+, разный регистр, цифры, знаки)',
    'form.configuration.settings.show.wifi': 'Настройки Wi-Fi при ошибке подключения',
    'form.configuration.settings.use.default.launcher': 'Фоновый режим',
    'form.configuration.settings.use.default.launcher.hint': 'Не заменять системный лаунчер, а запускать только фоновые службы MDM. Не рекомендуется в режиме киоска.',
    'form.configuration.settings.disable.screenshots': 'Запретить скриншоты',
    'form.configuration.settings.orientation': 'Ориентация',
    'form.configuration.settings.orientation.none': 'Не фиксировать',
    'form.configuration.settings.orientation.portrait': 'Портретная',
    'form.configuration.settings.orientation.landscape': 'Альбомная',
    'form.configuration.settings.files.default.path': 'Путь по умолчанию на устройстве',
    'form.configuration.files.search.label': 'Поиск:',
    'form.configuration.files.action.upload': 'Загрузить',
    'form.configuration.files.action.remove': 'Удалить',
    'form.configuration.files.variables': 'Менять содержимое',
    'form.configuration.files.variables.hint': 'Строки DEVICE_NUMBER, IMEI, CUSTOM* будут заменены их значениями',

    'form.configuration.file.name': 'Имя файла',
    'form.configuration.file.select': 'Выберите файл',
    'form.configuration.file.create': '(создать новый файл)',
    'form.configuration.file.description': 'Описание файла',
    'form.configuration.file.description.placeholder': 'Опционально, для вашего удобства',
    'form.configuration.file.path': 'Путь на устройстве',
    'form.configuration.file.path.placeholder': 'Без пути к носителю, например /my-app/image.jpg',
    'form.configuration.file.url': 'URL',
    'form.configuration.file.url.placeholder': 'Только если файл на внешнем ресурсе',
    'form.configuration.file.file': 'Файл',
    'form.configuration.file.action': 'Действие',
    'form.configuration.file.action.prompt.1': 'Загрузить',
    'form.configuration.file.action.prompt.2': 'Удалить',
    'form.configuration.file.remove.prompt.1': 'Этот файл больше не будет синхронизироваться с устройствами',
    'form.configuration.file.remove.prompt.2': 'Удалить файл с сервера',

    'form.password.title': 'Сменить пароль',
    'form.password.label.user': 'Пользователь',
    'form.password.label.password.new': 'Новый пароль',
    'form.password.label.password.new.placeholder': 'Введите новый пароль',
    'form.password.label.password.confirm': 'Подтверждение',
    'form.password.label.password.confirm.placeholder': 'Введите новый пароль ещё раз',
    'form.password.length': 'Минимальная длина: ${length}. ',

    'form.application.type': 'Тип',
    'form.application.type.option.web': 'Веб-страница',
    'form.application.type.option.app': 'Приложение',
    'form.application.type.option.intent': 'Системное действие',
    'form.application.intent': 'Действие',
    'form.application.intent.placeholder': 'Выберите действие',
    'form.application.url.hint': 'Используйте file:///storage/emulated/0/... для создания ссылок на локальные файлы и папки',
    'form.application.pkg': 'ID пакета',
    'form.application.from.file': 'определяется из файла',
    'form.application.pkg.title': 'ID пакета определяется автоматически при загрузке файла. Указывайте ID пакета вручную только для системных приложений.',
    'form.application.pkg.placeholder': 'Например, com.android.camera',
    'form.application.disabled.arch': 'Зависит от версии',
    'form.application.disabled.arch.title': 'Чтобы добавить APK для разных архитектур CPU, нажмите «Добавить» или откройте список версий приложения.',
    'form.application.arch': 'Нативный код',
    'form.application.arch.title': 'Некоторые приложения содержат код, оптимизированный для определенной архитектуры CPU. В этом случае вам надо загрузить два APK (для архитектур armeabi-v7a и arm64-v8a)',
    'form.application.arch.universal': 'Нет (универсальный APK)',
    'form.application.arch.armeabi': 'Нативный код для armeabi-v7a',
    'form.application.arch.arm64': 'Нативный код для arm64-v8a',
    'form.application.arch.no.split': 'Универсальный APK',
    'form.application.arch.split': 'Раздельные APK',
    'form.application.arch.warning': 'Этот APK оптимизирован только для ${arch} и может работать не на всех устройствах. Рекомендуем загрузить еще один APK для другой архитектуры CPU. Для использования APK на всех устройствах, выберите "Универсальный APK".',
    'form.application.arch.success': 'Это приложение содержит APK-файлы для обеих архитектур CPU.',
    'form.application.version.exists': 'APK для этой версии уже существует',
    'form.application.url.armeabi': 'URL для armeabi-v7a',
    'form.application.url.arm64': 'URL для arm64-v8a',
    'form.application.name': 'Название приложения',
    'form.application.name.title': 'Под этим названием вы будете видеть приложение в списке. Рекомендуем давать приложениям уникальные и информативные названия.',
    'form.application.name.placeholder': 'Например, Камера (Android)',
    'form.application.version': 'Версия',
    'form.application.version.title': 'Версия пакета определяется автоматически при загрузке файла. Для системных приложений ставьте 0.',
    'form.application.version.code': 'Код версии',
    'form.application.version.code.exists': 'Версия с таким кодом уже существует. Пожалуйста, сообщите об этой проблеме разработчикам приложения.',
    'form.application.version.placeholder': '0 для системных приложений',
    'form.application.system': 'Системное',
    'form.application.system.title': 'Системные приложения уже установлены на устройстве и не требуют файла. Ставьте этот флажок, только если требуется разрешить системный пакет.',
    'form.application.run.after.install': 'Запуск после установки',
    'form.application.run.after.install.title': 'Приложения с фоновыми сервисами требуют явного запуска хотя бы один раз.',
    'form.application.run.at.boot': 'Запуск при загрузке',
    'form.application.run.at.boot.title': 'Этот флажок будет открывать окно приложения при каждом запуске. Он не влияет на запуск фоновых сервисов приложений.',
    'form.application.url': 'URL',
    'form.application.url.title': 'URL нужно указывать, только если приложение размещено на внешнем ресурсе. Лучше загрузите APK файл на сервер с помощью поля ниже.',
    'form.application.url.disabled': 'URL редактируется для каждой версии в отдельности. Чтобы изменить URL, закройте это окно и нажмите иконку "Версии".',
    'form.application.file': 'Файл',
    'form.application.auto.update': 'Обновить автоматически',
    'form.application.auto.update.title': 'Установите этот флаг, чтобы обновить все конфигурации, в которых установлено приложение. Используйте, только если вы на 100% уверены, что приложение работает стабильно.',
    'form.application.showLabel': 'Показать ярлык',
    'form.application.showLabel.title': 'Показывать ли иконку приложения в лаунчере. Эту опцию можно затем переопределить в конфигурации.',
    'form.application.use.kiosk': 'Открыть в Киоск-Браузере',
    'form.application.use.kiosk.title': 'Установите этот флаг, если нужно открыть страницу в Киоск-Браузере без возможности изменения адреса',
    'form.application.iconText': 'Текст ярлыка',
    'form.application.iconText.placeholder': '(по умолчанию)',
    'form.application.versions.title': 'Версии приложения',
    'form.application.icon': 'Иконка',
    'form.application.icon.default': '(по умолчанию)',
    'form.application.icon.add': 'Добавить иконку',

    'form.application.setting.app': 'Приложение',
    'form.application.setting.app.placeholder': 'Выберите приложение',
    'form.application.setting.name': 'Атрибут',
    'form.application.setting.value': 'Значение',
    'form.application.setting.comment': 'Комментарий',
    'form.application.setting.type': 'Тип',
    'form.application.setting.readonly': 'Не меняется на устройстве',

    'form.application.configurations.app': 'Приложение',
    'form.application.configurations.configs': 'Конфигурации',

    'form.configuration.copy.new.name': 'Новое название',
    'form.configuration.copy.new.name.placeholder': 'Введите новое название конфигурации',

    'form.customer.name': 'Название',
    'form.customer.name.placeholder': 'Введите название организации',
    'form.customer.admin.name': 'Имя администратора',
    'form.customer.firstname.placeholder': 'Имя',
    'form.customer.lastname.placeholder': 'Фамилия',
    'form.customer.language': 'Язык',
    'form.customer.language.placeholder': 'Оставьте пустым для английского, или две строчные буквы',
    'form.customer.apiKey': 'Ключ API',
    'form.customer.apiKey.placeholder': 'Введите ключ API',
    'form.customer.prefix': 'Префикс',
    'form.customer.prefix.placeholder': 'Введите префикс номеров устройств',
    'form.customer.device.configuration': 'Конфигурация устройств',
    'form.customer.desc': 'Описание',
    'form.customer.desc.placeholder': 'Введите описание организации',
    'form.customer.copy.configuration': 'Копировать конфигурации',
    'form.customer.copy.design': 'Копировать дизайн',
    'form.customer.type': 'Тип клиента',
    'form.customer.status': 'Статус клиента',
    'form.customer.expiry.time': 'Дата окончания',
    'form.customer.device.limit': 'Лимит устройств',
    'form.customer.size.limit': 'Лимит хранилища',
    'form.customer.size.limit.placeholder': 'Размер (Мб)',

    'form.device.number': 'Номер',
    'form.device.number.locked': 'Нельзя изменить номер, если устройство в процессе миграции.',
    'form.device.migration.warning': 'Устройство будет переключено на новый номер. Проверьте, что устройство включено - номер изменится, если устройство в сети.',
    'form.device.number.hint': 'Латинские буквы, цифры, знаки',
    'form.device.desc': 'Описание',
    'form.device.groups': 'Группы',
    'form.device.config': 'Конфигурация',
    'form.device.imei': 'IMEI',
    'form.device.phone.number': 'Номер телефона',

    'form.update.device.config': 'Конфигурация',
    'form.update.device.action': 'Групповое действие',
    'form.device.set.group': 'Добавить в группы',
    'form.device.clear.group': 'Удалить из групп',

    'form.file.file': 'Файл',
    'form.file.name': 'Имя файла',
    'form.file.description': 'Описание (необязательно)',
    'form.file.external': 'Внешний',
    'form.file.external.title': 'Вместо загрузки файла вы можете указать URL на внешнем ресурсе',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': 'URL файла на внешнем ресурсе',
    'form.file.path': 'Путь на сервере',
    'form.file.device.path': 'Путь на устройстве',
    'form.file.device.path.placeholder': 'Путь относительно /storage/emulated/0',
    'form.file.deleted': 'УДАЛЕН',
    'form.file.copy.link': 'Копировать ссылку: ${link}',
    'form.file.configurations.file': 'Файл',
    'form.file.configurations.configs': 'Конфигурации',
    'form.file.configurations.upload': 'Загрузить',
    'form.file.path.placeholder': 'Введите относительный путь, например "/files/"',
    'form.file.available': 'Доступное место: ${space} Мб',

    'form.file.apps.name': 'Название приложения',
    'form.file.apps.pkg': 'ID пакета',
    'form.file.apps.version': 'Версия',

    'form.group.name': 'Название',
    'form.group.name.placeholder': 'Введите название группы',

    'form.role.nome': 'Название',
    'form.role.name.placeholder': 'Введите название роли',
    'form.role.permissions': 'Разрешения',

    'form.user.login': 'Логин',
    'form.user.login.placeholder': 'Идентификатор пользователя',
    'form.user.name': 'Имя',
    'form.user.name.placeholder': 'Имя и фамилия',
    'form.user.email': 'E-mail',
    'form.user.email.placeholder': 'Введите e-mail',
    'form.user.role': 'Роль',
    'form.user.all.devices.available': 'Доступны все устройства',
    'form.user.available.groups': 'Доступные группы устройств',
    'form.user.all.configs.available': 'Доступны все конфигурации',
    'form.user.available.configs': 'Доступные конфигурации',
    'form.user.password.new': 'Новый пароль',
    'form.user.password': 'Пароль',
    'form.user.password.new.placeholder': 'Введите новый пароль',
    'form.user.password.confirm': 'Подтверждение',
    'form.user.password.confirm.placeholder': 'Введите новый пароль ещё раз',

    'form.settings.hints.title': 'Подсказки',

    'form.settings.plugins.title': 'Используемые Плагины',

    'form.settings.common.title': 'Таблица "Устройства"',
    'form.settings.common.visible.columns': 'Видимые столбцы в таблице "Устройства"',
    'form.settings.common.status': 'Статус',
    'form.settings.common.role': 'Роль пользователей',
    'form.settings.common.date': 'Когда было онлайн',
    'form.settings.common.device.number': 'Номер устройства',
    'form.settings.common.imei': 'IMEI',
    'form.settings.common.phone.number': 'Номер телефона',
    'form.settings.common.phone.model': 'Модель телефона',
    'form.settings.common.status.permissions': 'Статус разрешений',
    'form.settings.common.status.installation': 'Статус установки',
    'form.settings.common.status.files': 'Статус файлов',
    'form.settings.common.config': 'Конфигурация',
    'form.settings.common.desc': 'Описание',
    'form.settings.common.group': 'Группа',
    'form.settings.common.launcher.version': 'Версия лаунчера',
    'form.settings.common.battery.level': 'Заряд батареи',
    'form.settings.common.default.launcher': 'Фоновый режим',
    'form.settings.common.mdm.mode': 'Режим MDM',
    'form.settings.common.kiosk.mode': 'Режим киоска',
    'form.settings.common.android.version': 'Версия Android',
    'form.settings.common.enrollment.date': 'Дата настройки',
    'form.settings.common.serial': 'Серийный номер',
    'form.settings.common.publicip': 'IP адрес',

    'form.settings.design.title': 'Дизайн по умолчанию',
    'form.settings.design.color.font': 'Цвет фона',
    'form.settings.design.color.font.placeholder': 'Выберите цвет',
    'form.settings.design.color.app.names': 'Цвет названий приложений',
    'form.settings.design.color.app.names.placeholder': 'Выберите цвет',
    'form.settings.design.url.background.image': 'URL фонового изображения',
    'form.settings.design.url.background.image.placeholder': 'Введите URL фонового изображения',
    'form.settings.design.size.icon': 'Размер иконок',
    'form.settings.design.size.icon.small': 'Маленькие',
    'form.settings.design.size.icon.medium': 'Средние (+20%)',
    'form.settings.design.size.icon.large': 'Большие (+40%)',
    'form.settings.design.desktop.header': 'Заголовок рабочего стола',
    'form.settings.design.desktop.header.no': 'Нет',
    'form.settings.design.desktop.header.device.id': 'ID устройства',

    'form.settings.lang.title': 'Языковые настройки',
    'form.settings.lang.use.default': 'Использовать язык по умолчанию',
    'form.settings.lang.use': 'Использовать язык',
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title': 'Прочие настройки',
    'form.settings.misc.phone.format': 'Формат номера телефона',
    'form.settings.misc.phone.format.placeholder': '+9 (999) 999-99-99',
    'form.settings.misc.custom.property.name.1': 'Пользовательское поле #1',
    'form.settings.misc.custom.property.name.2': 'Пользовательское поле #2',
    'form.settings.misc.custom.property.name.3': 'Пользовательское поле #3',
    'form.settings.misc.custom.property.multiline': 'Многострочное',
    'form.settings.misc.custom.property.send': 'Отпр. на устр-во',
    'form.settings.misc.custom.property.name.placeholder': 'Введите название пользовательского поля',
    'form.settings.misc.create.new.devices': 'Добавлять устр-во при первом обращении',
    'form.settings.misc.new.device.config': 'Конфигурация нового устройства',
    'form.settings.misc.new.device.group': 'Группа нового устройства',
    'form.settings.misc.send.description': 'Отправлять описание на устройства',
    'form.settings.misc.password.length': 'Минимальная длина пароля',
    'form.settings.misc.password.strength': 'Надежность пароля',
    'form.settings.misc.password.none': 'Не указана (любые символы)',
    'form.settings.misc.password.alphanumeric': 'Строчные и прописные буквы, цифры',
    'form.settings.misc.password.specialchar': 'Строчные и прописные буквы, цифры, специальные символы',
    'form.settings.misc.password.reset': 'Пользователь должен сбросить пароль',
    'form.settings.misc.idle.logout': 'Выход из системы при простое',
    'form.settings.misc.idle.logout.never': 'Никогда',
    'form.settings.misc.idle.logout.1': '5 минут',
    'form.settings.misc.idle.logout.2': '10 минут',
    'form.settings.misc.idle.logout.3': '30 минут',
    'form.settings.misc.idle.logout.4': '1 час',
    'form.settings.security.title': 'Настройки безопасности',

    'idle.logout.message': 'Вы выйдете из системы через ${sec} секунд из-за неактивности',
    'idle.logout.resume': 'Я здесь!',

    'form.settings.groups.title': 'Группы',
    'form.settings.groups.search.placeholder': 'Поиск группы',

    'form.settings.users.title': 'Пользователи',
    'form.settings.users.search.placeholder': 'Поиск пользователя',

    'form.settings.roles.title': 'Роли пользователей',

    'form.settings.icons.title': 'Иконки',
    'form.settings.icons.search.placeholder': 'Поиск иконок',

    'form.qr.device.number': 'ID устройства',
    'form.qr.auto.create': 'Добавить в список устройств, если ещё нет',
    'form.qr.number.use': 'Назначение ID устройства',
    'form.qr.number.use.request': 'Ввод пользователя',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': 'Серийный номер',
    'form.qr.number.hint': 'Очистите номер устройства, чтобы включить автоматическое присвоение номера устройства',
    'form.qr.groups': 'Добавить к группам',
    'form.qr.button.json': 'Получить JSON',
    'form.qr.device.number.placeholder': 'Введите ID устройства...',
    'form.qr.code.image.alt': 'QR-код',

    'form.password.reset.title': 'Пожалуйста, установите новый пароль',
    'form.password.reset.invalid': 'К сожалению, эта ссылка для сброса пароля недействительна',
    'form.password.reset.submit': 'Установить пароль',

    'form.two.factor.auth.title': 'Двухфакторная аутентификация',
    'form.two.factor.auth.hint': 'Чтобы завершить регистрацию, установите приложение Authenticator на свое мобильное устройство, отсканируйте QR-код, сгенерируйте и введите проверочный код.',
    'form.two.factor.auth.code.invalid': 'Код проверки недействителен!',
    'form.two.factor.auth.code': 'Код проверки',
    'form.two.factor.auth.code.hint': '6-значный код из приложения для аутентификации',
    'form.two.factor.auth.code.error': 'Код должен представлять собой 6-значное число',
    'form.two.factor.auth.verify': 'Проверить',
    'form.two.factor.auth.settings.hint': 'Чтобы настроить двухфакторную аутентификацию, установите приложение Authenticator на свое мобильное устройство, отсканируйте QR-код, сгенерируйте и введите проверочный код.',
    'form.two.factor.auth.set': 'Двухфакторная аутентификация включена',
    'form.two.factor.auth.reset': 'Двухфакторная аутентификация отключена',
    'form.two.factor.auth.off.confirm': 'Вы хотите отключить двухфакторную аутентификацию? После повторного включения все аутентификаторы станут недействительными.',

    'form.profile.title': 'Смена пароля',
    'form.profile.password.old': 'Старый пароль',
    'form.profile.password.old.placeholder': 'Введите старый пароль',
    'form.profile.password.new': 'Новый пароль',
    'form.profile.password.new.placeholder': 'Введите новый пароль',
    'form.profile.password.confirm': 'Подтверждение',
    'form.profile.password.confirm.placeholder': 'Введите новый пароль ещё раз',

    'tab.customers': 'Организации',
    'tab.common.applications': 'Общие приложения',

    'tab.devices': 'Устройства',
    'tab.applications': 'Приложения',
    'tab.configurations': 'Конфигурации',
    'tab.files': 'Файлы',
    'tab.default.design': 'Дизайн по умолчанию',
    'tab.common.settings': 'Таблица "Устройства"',
    'tab.users': 'Пользователи',
    'tab.roles': 'Роли',
    'tab.groups': 'Группы',
    'tab.icons': 'Иконки',
    'tab.language': 'Общие и языковые настройки',
    'tab.license': 'Лицензия',
    'tab.hints': 'Подсказки',
    'tab.plugins': 'Плагины',

    'tab.configeditor.common.settings': 'Общие настройки',
    'tab.configeditor.design.settings': 'Настройки дизайна',
    'tab.configeditor.applications': 'Приложения',
    'tab.configeditor.mdm.settings': 'Настройки MDM',
    'tab.configeditor.app.settings': 'Настройки приложений',
    'tab.configeditor.files': 'Файлы',

    'search.placeholder.file': 'Поиск файла',
    'search.placeholder.configuration': 'Поиск конфигурации',
    'search.placeholder.customer': 'Поиск организации',
    'search.placeholder.application': 'Поиск приложения',
    'search.placeholder.application.setting': 'Поиск настройки',
    'search.placeholder.device': 'Поиск устройства',
    'search.placeholder.address': 'Поиск адреса',
    'search.placeholder.point': 'Поиск площадки',
    'search.placeholder.message': 'Поиск сообщения',
    'search.placeholder': 'Поиск ...',
    'search.placeholder.from': 'С...',
    'search.placeholder.to': 'По...',
    'search.placeholder.user': 'Имя пользователя',

    'table.heading.customer.name': 'Название',
    'table.heading.customer.desc': 'Описание',
    'table.heading.customer.registration.time': 'Зарегистрирован',
    'table.heading.customer.last.login.time': 'Последний логин',
    'table.heading.customer.actions': 'Действия',
    'table.heading.customer.type': 'Тип',
    'table.heading.customer.expiry.time': 'Окончание',
    'table.heading.customer.device.limit': 'Лимит',
    'table.heading.customer.status': 'Статус',

    'customer.new': 'Новый',
    'customer.active': 'В процессе',
    'customer.need.followup': 'Нужен Follow-up',
    'customer.followup.sent': 'Follow-up выслан',
    'customer.internal.test': 'Тестовый',
    'customer.developer': 'Разработчик',
    'customer.difficult': 'Проблемный',
    'customer.pause': 'Пауза',
    'customer.inactive': 'Не входил',
    'customer.abandon': 'Забросил',
    'customer.onpremise': 'Локальный тест',
    'customer.denial': 'Отказ',
    'customer.client': 'Клиент',

    'table.heading.configuration.name': 'Название',
    'table.heading.configuration.desc': 'Описание',
    'table.heading.configuration.actions': 'Действия',

    'table.heading.application.setting.app.pkg': 'ID пакета',
    'table.heading.application.setting.app.name': 'Название приложения',
    'table.heading.application.setting.name': 'Атрибут',
    'table.heading.application.setting.value': 'Значение',
    'table.heading.application.setting.comment': 'Комментарий',
    'table.heading.application.setting.lastUpdate': 'Создан',

    'table.heading.file.url': 'URL',
    'table.heading.file.devicepath': 'Путь на устройстве',
    'table.heading.file.description': 'Описание файла',
    'table.heading.file.action': 'Действие',
    'table.heading.file.lastUpdate': 'Создан',

    'table.heading.application.pkg': 'ID пакета',
    'table.heading.application.name': 'Название приложения',
    'table.heading.application.version': 'Версия',
    'table.heading.application.url': 'URL',
    'table.heading.application.label': 'Ярлык',
    'table.heading.application.actions': 'Действия',
    'table.heading.application.order': 'Порядок',

    'table.heading.device.status': 'Статус',
    'table.heading.device.date': 'Онлайн',
    'table.heading.device.device.number': 'Номер устройства',
    'table.heading.device.imei': 'IMEI',
    'table.heading.device.phone.number': 'Номер телефона',
    'table.heading.device.phone.model': 'Модель телефона',
    'table.heading.device.status.permissions': 'Статус разрешений',
    'table.heading.device.status.installation': 'Статус установки',
    'table.heading.device.status.files': 'Статус файлов',
    'table.heading.device.configuration': 'Конфигурация',
    'table.heading.device.desc': 'Описание',
    'table.heading.device.group': 'Группа',
    'table.heading.device.launcher.version': 'Версия лаунчера',
    'table.heading.device.battery.level': 'Заряд батареи',
    'table.heading.device.default.launcher': 'Фоновый режим',
    'table.heading.device.mdm.mode': 'Режим MDM',
    'table.heading.device.kiosk.mode': 'Режим киоска',
    'table.heading.device.android.version': 'Версия Android',
    'table.heading.device.enrollment.date': 'Дата настройки',
    'table.heading.device.serial': 'Серийный номер',
    'table.heading.device.publicip': 'IP адрес',
    'table.heading.device.actions': 'Действия',

    'table.heading.group.name': 'Название',
    'table.heading.group.actions': 'Действия',

    'table.heading.role.name': 'Название',
    'table.heading.role.actions': 'Действия',

    'table.heading.file.name': 'Имя файла',
    'table.heading.file.comment': 'Описание',
    'table.heading.file.device.path': 'Путь на устройстве',
    'table.heading.file.update.time': 'Обновлен',
    'table.heading.file.external': 'Внешний',
    'table.heading.file.variable': 'Переменные',
    'table.heading.file.remove': 'Удалить',
    'table.heading.file.remove.hint': 'Принудительно удалить файл из хранилища устройства',
    'table.heading.file.path': 'Путь',
    'table.heading.file.address': 'Адрес',
    'table.heading.file.size': 'Размер',
    'table.heading.file.actions': 'Действия',

    'table.heading.users.login': 'Login',
    'table.heading.users.name': 'Имя',
    'table.heading.users.role': 'Роль',
    'table.heading.users.actions': 'Действия',

    'table.heading.common.apps.customer': 'Организация',
    'table.heading.common.apps.pkg': 'ID пакета',
    'table.heading.common.apps.name': 'Название приложения',
    'table.heading.common.apps.version': 'Версия',
    'table.heading.common.apps.url': 'URL',
    'table.heading.common.apps.label': 'Ярлык',
    'table.heading.common.apps.actions': 'Действия',

    'notfound.devices': 'Нет устройств для отображения.',
    'notfound.files': 'Список файлов пуст.',
    'notfound.configurations': 'Конфигурации не найдены.',
    'notfound.customers': 'Организации не найдены.',
    'notfound.common.apps': 'Нет приложений для отображения.',
    'notfound.applications': 'Приложения не найдены',
    'notfound.groups': 'Группы не найдены. Попробуйте другой запрос.',
    'notfound.users': 'Пользователи не найдены. Попробуйте другой запрос.',
    'notfound.apps.for.display': 'Нет приложений для отображения.',
    'notfound.app.versions.for.display': 'Нет версий для отображения.',
    'notfound.roles':'Нет ролей пользователей для отображения.',
    'notfound.icons':'Список иконок пуст.',

    'format.date.header': 'HH:mm dd/MM/yyyy',

    'menu.about': 'О приложении',
    'menu.profile': 'Профиль',
    'menu.panel.master': 'Мастер-панель',
    'menu.panel.main': 'Основная панель',
    'menu.logout': 'Выйти',
    'menu.functions': 'Функции',
    'menu.settings': 'Настройки',
    'menu.show.hints': 'Показать подсказки',

    'plugin.name.not.specified': '<<Имя функции не указано>>',

    'breadcrumb.summary': 'Сводка',
    'breadcrumb.devices': 'Устройства',
    'breadcrumb.applications': 'Приложения',
    'breadcrumb.configurations': 'Конфигурации',
    'breadcrumb.files': 'Файлы',
    'breadcrumb.default.design': 'Дизайн по умолчанию',
    'breadcrumb.common.settings': 'Таблица "Устройства"',
    'breadcrumb.language.settings': 'Язык и другие настройки',
    'breadcrumb.license.settings': 'Лицензия',
    'breadcrumb.users': 'Пользователи',
    'breadcrumb.roles': 'Роли',
    'breadcrumb.groups': 'Группы',
    'breadcrumb.hints': 'Подсказки',
    'breadcrumb.plugins': 'Плагины',
    'breadcrumb.config.details': 'Детали',
    'breadcrumb.application.versions': 'Версии',

    'app.name': 'Headwind MDM',
    'app.vendor.name':"h-mdm.com",
    'app.vendor.link':"https://h-mdm.com",
    'app.description': '- система управления мобильными устройствами с открытым кодом',
    'app.title': '${appName} - панель управления',

    'box.show.my.apps.only': 'Показать только мои приложения',
    'configuration.app.version.upgrade.message': 'Установлена версия ${installedVersion}, доступна версия ${latestVersion}',

    'about.line.1': 'Панель управления ${appName}',
    'about.line.2': 'Оболочка для корпоративных Android-устройств',
    'about.line.3': 'Версия ${versionNumber}',
    'about.line.4': 'Используемые плагины',

    'common.app.clarification': 'Это приложение является общедоступным, его редактирование запрещено. Для добавления другой версии, пожалуйста, обратитесь к администратору.',

    'qrcode.help.line1': 'Чтобы настроить Android-устройство (версии Android 7 или выше) в управляемом (корпоративном) режиме:',
    'qrcode.help.line2': 'Выполните сброс к заводским настройкам',
    'qrcode.help.line3': 'Нажмите 7 раз подряд на любом месте стартового экрана (должен появиться скрытый режим сканирования QR-кода)',
    'qrcode.help.line4': 'Следуйте инструкциям устройства: примите условия использования, подключитесь к Wi-Fi, отсканируйте QR-код',
    'qrcode.help.line5': 'Код может содержать также ID устройства в системе ${appName} (после настройки его не нужно будет вводить). Для включения ID устройства в QR код, введите его на этом экране и нажмите "Обновить".',

    'form.configuration.app.version.select.select.title': 'Выберите версию для установки',
    'form.configuration.app.version.select.version.check.off': 'Отключить проверку версии',
    'form.configuration.app.version.select.upgrade.warning': 'Обновить приложение "${v1}" до версии "${v3}" для конфигурации "${v2}"?',
    'form.configuration.app.version.select.downgrade.warning': ' Понижение версии УДАЛИТ ВСЕ ДАННЫЕ ПРИЛОЖЕНИЯ на всех устройствах! Понизить версию приложения "${v1}" до версии "${v2}"?',

    'hint.step.1': 'Чтобы начать настройку устройства, нажмите сюда',
    'hint.step.2': 'Чтобы показать QR код, нажмите сюда',
    'hint.step.3': 'Чтобы узнать, как открыть сканер QR кода на устройстве, нажмите здесь',
    'hint.step.4': 'Найдите доступный ID во вкладке "устройства". Нажмите "Обновить", чтобы включить его в QR код.',

    'ie.browser.notice.1': 'К сожалению, браузер Internet Explorer не поддерживается.',
    'ie.browser.notice.2': 'Рекомендуемый браузер для использования ${appName} - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop">Chrome</a>.',

    'form.resolved.duplicate.pkg.text1': 'ID пакета "${pkg}" уже используется приложениями, указанными ниже.',
    'form.resolved.duplicate.pkg.text2': 'Вы хотите добавить новое приложение или новую версию существующего приложения?',
    'form.resolved.duplicate.pkg.text3': 'Новая версия для',
    'form.resolved.duplicate.pkg.text4': 'Package ID "${pkg}" уже используется приложениями ${apps}',
    'form.resolved.duplicate.pkg.text5': 'Вы уверены, что хотите изменить package ID?',

    'tooltip.usage.byconfigurations': 'Используется конфигурациями',
    'tooltip.usage.byapps': 'Используется приложениями',
    'tooltip.usage.byicons': 'Используется иконками',

    'form.devices.label.params.more': 'Дополнительные параметры',
    'form.devices.label.params.less': 'Меньше параметров',
    'form.devices.label.installation.status': 'Статус установки',
    "format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
    "format.devices.date.datePicker": "dd-MM-yyyy",
    'form.devices.fast.search': 'Быстрый поиск по номеру',

    'form.devices.selection.install.status.default': 'Статус установки ...',
    'form.devices.selection.install.status.all': 'Все',
    'form.devices.selection.install.status.success': 'Успешно',
    'form.devices.selection.install.status.version.mismatch': 'Неверные версии',
    'form.devices.selection.install.status.failure': 'Ошибка',
    'form.devices.selection.imei.changed': 'IMEI недавно менялся',

    'search.placeholder.launcher.version': 'Версия лаунчера',
    'error.date.range.invalid': 'Неверный интервал дат',

    'form.selection.status.any': 'Любой',
    'form.selection.status.all': 'Все',
    'form.selection.status.yes': 'Да',
    'form.selection.status.no': 'Нет',

    'form.devices.selection.status': 'Статус ...',
    'form.devices.selection.online': 'Онлайн',
    'form.devices.selection.offline': 'Оффлайн',
    'form.devices.selection.number': 'Введите число',

    'form.devices.selection.online.status.custom': 'Ввести время',
    'form.devices.selection.online.status.1': '15 минут',
    'form.devices.selection.online.status.2': '30 минут',
    'form.devices.selection.online.status.3': '1 час',
    'form.devices.selection.online.status.4': '2 часа',
    'form.devices.selection.online.status.5': '6 часов',
    'form.devices.selection.online.status.6': '1 день',
    'form.devices.selection.online.status.7': '2 дня',
    'form.devices.selection.online.status.8': '3 дня',
    'form.devices.selection.online.status.9': '1 неделя',
    'form.devices.selection.online.status.10': '1 месяц',

    'form.devices.selection.online.status.label': 'минут',
    'form.devices.status.ago': 'назад',
    'form.devices.status.minutes': 'мин',
    'form.devices.status.hours': 'ч',
    'form.devices.status.days': 'д',
    'form.devices.status.weeks': 'н',
    'form.devices.status.months': 'мес',
    'form.devices.status.years': 'г',

    'customer.type.demo': 'Демо',
    'customer.type.small': 'Малый бизнес',
    'customer.type.corporate': 'Корпоративный',
    'customer.type.master': 'Основной',

    'customer.type.options.all': 'Все типы',
    'customer.status.options.all': 'Все статусы',

    'account.expiring': 'Ваша учетная запись истекает в течение ${days} дней. Пожалуйста, свяжитесь с продавцом для продления.',
    'account.expired': 'Ваша учетная запись истекла. Пожалуйста, свяжитесь с продавцом для продления.',
    'account.expired.short': 'Ваша учетная запись истекла!',
    'device.limit.achieved': 'Нельзя добавить устройство - вы достигли лимита. Удалите устройства или свяжитесь с продавцом для увеличения лимита.',

    'menu.updates': 'Проверить наличие обновлений',
    'updates.title': 'Обновления',
    'updates.disabled.custom': 'Пользовательская версия, обновите ее вручную',
    'updates.disabled.not_master': 'Попросите хостинг-провайдера обновить',
    'updates.disabled.multiple': 'Несколько версий приложения, обновите вручную',
    'updates.disabled.error': 'Внутренняя ошибка сервера',
    'updates.disabled.download': 'Ошибка загрузки обновления',
    'updates.application': 'Приложение',
    'updates.current.version': 'Текущая версия',
    'updates.available.version': 'Доступная версия',
    'updates.downloaded': 'Загружено',
    'updates.auto.update': 'Автоматически обновлять мобильные приложения (используйте с осторожностью в рабочей среде!)',
    'updates.enable.stats': 'Отправить статистику использования поставщику услуг для повышения производительности системы',
    'updates.get': 'Обновить',
    'updates.checking': 'Проверка обновлений...',
    'updates.getting': 'Получение обновлений...',
    'updates.success': 'Обновление завершено',
    'updates.web.hint': 'Чтобы завершить обновление веб-приложения, запустите сценарий оболочки /opt/hmdm/update-web-app.sh в консоли SSH',

    'permission.edit_device_app_settings': 'Управление настройками приложения для устройств',
    'permission.plugins_customer_access_management': 'Управление доступными плагинами',
    'permission.plugin_audit_access': 'Просмотр журнала аудита',
    'permission.plugin_contacts_access': 'Управление контактами',
    'permission.plugin_deviceexport_access': 'Экспорт устройств',
    'permission.plugin_deviceimport_access': 'Импорт устройств',
    'permission.plugin_deviceinfo_access': 'Просмотр подробной информации об устройстве',
    'permission.plugin_devicelocations_access': 'Просмотр устройств на карте',
    'permission.plugin_devicelocations_settings_access': 'Настройка плагина карты',
    'permission.plugin_devicelog_access': 'Просмотр журналов устройства',
    'permission.plugin_devicereset_access': 'Сброс и перезагрузка устройств',
    'permission.plugin_licensing_access': 'Доступ к лицензии (устарело)',
    'permission.plugin_messaging_send': 'Отправка сообщений',
    'permission.plugin_messaging_delete': 'Удаление отправленных сообщений',
    'permission.plugin_photo_remove_photo': 'Удаление фотографий',
    'permission.settings': 'Управление настройками',
    'permission.configurations': 'Просмотр конфигураций',
    'permission.edit_devices': 'Изменение информации об устройстве',
    'permission.edit_device_desc': 'Изменение описания устройства',
    'permission.enroll_devices': 'Регистрация устройств по QR-коду',
    'permission.plugin_apuppet_access': 'Удаленное управление',
    'permission.plugin_knox_access': 'Плагин Knox',
    'permission.add_config': 'Добавление конфигураций',
    'permission.copy_config': 'Дублирование конфигураций',
    'permission.plugin_openvpn_access': 'Плагин OpenVPN',
    'permission.plugin_photo_access': 'Плагин фотографий',
    'permission.push_api': 'Доступ к API Push',
    'permission.plugin_urlfilter_access': 'Фильтрация URL',
    'permission.plugin_push_send': 'Отправка Push-сообщений',
    'permission.plugin_push_delete': 'Удаление Push-сообщений',
    'permission.get_updates': 'Проверка обновлений',
    'permission.plugin_xtra_access': 'Запрос на Премиум-версию',
    'permission.applications': 'Просмотр приложений',
    'permission.edit_applications': 'Управление приложениями',
    'permission.edit_application_versions': 'Управление версиями приложений',
    'permission.files': 'Просмотр файлов',
    'permission.edit_files': 'Управление файлами',

    'yes': 'да',
    'no': 'нет'
};
