if (! document.localization) document.localization = [];

document.localization ['pt_PT'] = {
    'login.username': 'Usuário ou Email',
    'login.username.placeholder': 'Insira o seu usuário ou email',
    'login.password': 'Senha:',
    'login.password.placeholder': 'Insira sua senha',
    'login.submit': 'Login',
    'login.password.incorrect': 'Usuário ou senha inválidos',
    'login.password.recovery': 'Senha perdida?',
    'recovery.password': 'Recuperar senha',
    'recovery.password.success': 'As instruções de recuperação de senha foram enviadas para seu e-mail',
    'login.no.account': 'Não tem uma conta?',
    'login.signup': 'Inscrever-se',

    'signup.title': 'Começar',
    'signup.email': 'Seu endereço de e-mail',
    'signup.email.placeholder': 'Digite um endereço de e-mail válido',
    'signup.email.invalid': 'Digite um endereço de e-mail válido',
    'signup.terms.agree': 'Eu concordo com',
    'signup.terms.terms': 'termos e condições',
    'signup.submit': 'Inscreva-se',
    'signup.progress': 'Inscrevendo-se...',
    'signup.email.used': 'Um cliente com este email já está cadastrado',
    'signup.name.used': 'Um cliente com este nome de usuário já está registrado',
    'signup.complete': 'Obrigado por se inscrever!',
    'signup.email.check': 'Por favor, verifique seu e-mail e siga o link para concluir o registro!',
    'signup.complete.title': 'Sua conta em ${appName} está quase pronta!',
    'signup.ready.title': 'Sua conta em ${appName} está pronta!',
    'signup.customer.id': 'Nome de usuário',
    'signup.customer.id.placeholder': 'Usar apenas letras e dígitos',
    'signup.customer.id.invalid': 'Por favor, use 6 ou mais caracteres, apenas letras e dígitos',
    'signup.first.name': 'Nome',
    'signup.first.name.placeholder': 'Seu primeiro nome (obrigatório)',
    'signup.last.name': 'Sobrenome',
    'signup.last.name.placeholder': 'Seu sobrenome (obrigatório)',
    'signup.company': 'Nome da empresa',
    'signup.company.placeholder': 'Nome da sua empresa (opcional)',
    'signup.description': 'Como você usará o MDM?',
    'signup.description.placeholder': 'Isso ajudará nossa equipe a ajudá-lo',
    'signup.password': 'Senha',
    'signup.password.repeat': 'Repita a senha',
    'signup.password.placeholder': '6+ caracteres',
    'signup.password.short': 'Por favor, digite pelo menos 6 caracteres',
    'signup.password.not.match': 'As senhas não correspondem',
    'signup.finalized.title': 'Sua conta está pronta!',
    'signup.finalized.description': 'Em pouco tempo, você deve receber o e-mail contendo instruções úteis. Revise este e-mail e faça login no painel da web usando seu nome de usuário e senha.',
    'signup.token.invalid.title': 'O token é inválido ou já foi usado',
    'signup.token.invalid.description': 'Por favor, tente se inscrever novamente para criar uma nova conta!',

    'header.label.username': 'Usuário',

    'summary.devices.status': 'Status do dispositivo',
    'summary.devices.active': 'Ativo',
    'summary.devices.idle': 'Inativo',
    'summary.devices.offline': 'Off-line',
    'summary.devices.enrollment': 'Resumo da inscrição',
    'summary.devices.enrolled.total': 'Total inscrito',
    'summary.devices.enrolled.earlier': 'Inscrito anteriormente',
    'summary.devices.enrolled.monthly': 'Últimos 30 dias',
    'summary.devices.installation.status': 'Status do aplicativo',
    'summary.devices.installation.completed': 'Completo',
    'summary.devices.version.mismatch': 'Erro de versão',
    'summary.devices.installation.failed': 'Falha na instalação',
    'summary.devices.enrolled.lastyear': 'Últimos 12 meses',

    'devices.group.options.all': 'Todos os Grupos',
    'devices.configuration.options.all': 'Todas as Configurações',
    'devices.permissions.all': 'Todas as permissões concedidas',
    'devices.permissions.not.as.device.admin': '- A Aplicação não está instalada como administrador do dispositivo',
    'devices.permissions.window.overlap.prohibited': '- A sobreposição sobre outras janelas não está disponível',
    'devices.permissions.history.access.prohibited': '- Acesso ao histórico de uso não configurado',
    'devices.unknown': 'Desconhecido',
    'devices.model.unknown': 'Desconhecido',
    'devices.date.unknown': 'desconhecido',
    'devices.date.format': 'dd/MM/yy HH:mm',
    'devices.app.installed': '- ${applicationName}: Instalado.',
    'devices.app.not.installed': '- ${applicationName}: não instalado.',
    'devices.app.version.available': ', disponível ${applicationVersion}',
    'devices.app.installed.and.version.available': '- ${applicationName}: instalado ${applicationInstalledVersion}, disponível ${applicationVersionAvailable}',
    'devices.app.needs.removal': '${applicationVersion}, remoção é necessária',
    'devices.no.data': 'O dispositivo não transmitiu dados',
    'devices.settings.conformance.broken': 'Incompatibilidade com as configurações: (${serverData})',
    'devices.file.installed': '- ${file}: instalado',
    'devices.file.not.installed': '- ${file}: não instalado.',
    'devices.file.lastUpdate.differs': '- ${file}: diferença de ${diff} min da última atualização',

    'button.apply': 'Aplicar',
    'button.gps.on': 'Ativar GPS',
    'button.wifi.on': 'Ativar Wi-Fi',
    'button.notify.update': 'Notificar na Atualização',
    'button.app.settings': 'Configurações do Aplicativo',
    'button.ok': 'OK',
    'button.help': 'Ajuda',
    'button.new.app': 'Novo Aplicativo',
    'button.new.app.version': 'Nova Versão',
    'button.upgrade': 'Atualizar',
    'button.renew.config': 'Atualizar Dispositivos',
    'button.common': 'Aplicação comum',
    'button.close': 'Fechar',
    'button.yes': 'Sim',
    'button.cancel': 'Cancelar',
    'button.save': 'Salvar',
    'button.save.and.close': 'Salvar e Fechar',
    'button.more': 'Mais ...',
    'button.cleanup': 'Limpar',
    'button.add': 'Adicionar',
    'button.add.icon': 'Novo ícone',
    'button.search': 'Buscar',
    'button.export': 'Exportar',
    'button.change': 'Editar',
    'button.copy': 'Copiar',
    'button.qrcode': 'QR code',
    'button.application': 'Aplicativo',
    'button.change.password': 'Alterar Senha',
    'button.set.configuration': 'Aplicar configuração',
    'button.set.group': 'Definir um grupo',
    'button.delete': 'Remover',
    'button.login': 'Login',
    'button.renew.code': 'Renovar',
    'button.configurations': 'Configurações',
    'button.set.configurations': 'Especificar Confgurações',
    'button.edit.versions': 'Versões',
    'button.edit': 'Editar',
    'button.change.common.app': 'Editar Aplicativos Compartilhados',
    'button.delete.common.app': 'Remover Aplicativos Compartilhados',
    'button.turn.common.app': 'Tornar Comum',
    'button.hints.enable': 'Mostrar Dicas',
    'button.hints.disable': 'Ocultar Dicas',
    'button.show.password': 'Mostrar senha',
    'button.hide.password': 'Ocultar senha',

    'question.impersonate.user': 'Entrar no aplicativo como administrador da organização "${customerName}"?',
    'question.change.user': 'Entrar no aplicativo como usuário "${userName}"?',
    'question.delete.file': 'Excluir arquivo "${fileName}"?',
    'question.delete.customer': 'Excluir organização "${customerName}"?',
    'question.delete.user': 'Excluir usuário "${username}"?',
    'question.delete.application': 'Excluir aplicação "${applicationName}"?',
    'question.delete.application.version': 'Excluir versão "${applicationVersion}"?',
    'question.delete.configuration': 'Excluir configuração "${configurationName}"?',
    'question.delete.group': 'Excluir grupo "${groupName}"?',
    'question.delete.role': 'Excluir função "${roleName}"?',
    'question.delete.icon': 'Apagar o ícone "${iconName}"?',
    'question.delete.device.bulk': 'Excluir dispositivos selecionados?',
    'question.delete.device': 'Excluir dispositivo com o número "${deviceNumber}"?',
    'question.exit.without.saving': 'Alterações não foram salvas. De qualquer forma deseja sair dessa página?',
    'question.turn2common.application': 'Compartilhar a aplicação "${applicationName}"?',
    'question.app.upgrade': 'Atualizar aplicação "${v1}" para a versão mais recente da configuração "${v2}"?',

    'error.application.setting.empty.app': 'Insira o aplicativo',
    'error.application.setting.empty.name': 'Insira o nome',
    'error.application.setting.empty.value': 'Insira o Valor',

    'error.icon.dimension.invalid': 'O ícone precisa ser quadrado',
    'error.icon.empty.name': 'Insira o nome do ícone',
    'error.icon.empty.file': 'Upload do ícone',
    'error.application.version.pkg.mismatch': 'O pacote de ID do arquivo (${actual}) não corresponde a aplicação (${expected})',
    'error.empty.user': 'Selecione um usuário',
    'error.empty.user.name': 'Insira o nome do usuário',
    'error.empty.user.login': 'Insira o login do usuário',
    'error.empty.user.role': 'Selecione o perfil do usuário',
    'error.empty.password': 'Insira a nova senha',
    'error.empty.password.confirm': 'Insira a confirmação de senha',
    'error.user.not.found': 'Usuário não encontrado',
    'error.email.not.configured': 'Email não configurado',
    'error.email.not.found': 'E-mail do usuário não definido',
    'error.empty.group.name': 'Insira o nome do grupo',
    'error.empty.configuration': 'Selecione a configuração',
    'error.empty.configuration.name': 'Insira o nome da configuração',
    'error.empty.configuration.password': 'Insira a senha',
    'error.empty.configuration.contentApp': 'Nenhum conteúdo de aplicação especificado',
    'error.empty.group': 'Add a device to one or more groups',
    'error.invalid.character': 'O número do dispositivo não pode conter símbolos / ? &',
    'error.invalid.configuration.mainApp': 'Nas configurações do MDM, o aplicativo principal errado é usado',
    'error.invalid.configuration.contentApp': 'Aplicação de conteúdo inválido nas configurações do MDM',
    'error.mismatch.password': 'Senha e confirmação de senha devem corresponder',
    'error.empty.customer.name': 'Preencha o nome da organização',
    'error.empty.customer.prefix': 'Preencha o número do prefixo do dispositivo',
    'error.empty.customer.device.configuration': 'Selecione a configuração do dispositivo',
    'error.empty.customer.duplicate.prefix': 'Este prefixo já está em uso',
    'error.duplicate.customer.name': 'A organização com o nome digitado já existe. Tente um nome diferente.',
    'error.duplicate.group.name': 'O grupo que você digitou já existe. Tente um nome diferente',
    'error.duplicate.configuration.name': 'O nome de configuração que você digitou já existe. Tente um nome diferente.',
    'error.duplicate.device.number': 'Um dispositivo com esse número já existe',
    'error.internal.server': 'Erro interno do servidor',
    'error.permission.denied': 'Sem direitos de execução',
    'error.request.failure': 'Falha de solicitou',
    'error.configuration.device.use': 'Não é possível excluir essa configuração, ela está sendo usada em algum(ns) dispositivo(s). Primeiro vá para "Dispositivos", encontre o dispositivo usando esta configuração e altere sua configuração.',
    'error.invalid.system.update.time': 'Intervalo de instalação inválido',
    'error.size.limit.exceeded': 'Limite de armazenamento excedido',

    'error.configuration.file.empty.name': 'Insira um nome de arquivo',
    'error.configuration.file.empty.desc': 'Especifique uma descrição de arquivo',
    'error.configuration.file.empty.path': 'Especifique o caminho no dispositivo',
    'error.configuration.file.empty.file': 'Favor enviar um ficheiro',
    'error.configuration.file.empty.url': 'Favor especificar o URL do ficheiro',

    'error.notfound.device': 'Dispositivo não encontrado',
    'error.duplicate.device': 'Um dispositivo com o mesmo número já existe',
    'error.duplicate.login': 'Esse login já está em uso',
    'error.duplicate.email': 'Já existe um usuário com este e-mail',
    'error.duplicate.group': 'Um grupo com esse mesmo nome já existe',
    'error.duplicate.application': 'Já existe uma aplicação com esse ID de pacote e versão',
    'error.recent.application.version.exists': 'Existe uma versão mais recente da aplicação',
    'error.common.application.access.prohibited': 'O gerenciamento das aplicações comuns é permitido apenas pelo Super-Administrador',
    'error.application.config.reference.exists': 'A aplicação está sendo usada nas configurações e não pode ser excluída',
    'error.application.version.deletion.prohibited': 'A versão é única ou usada em configurações e não pode ser excluída',
    'error.duplicate.file': 'Um arquivo com o mesmo nome já existe',
    'error.used.file': 'Este arquivo está usado',
    'error.version.exists': 'A mesma versão deste app já existe',
    'error.duplicate.configuration': 'Uma configuração com este nome já existe',
    'error.duplicate.role.name': 'Já existe uma função com o mesmo nome',
    'error.empty.role.name': 'Especifique o nome da função',
    'error.duplicate.icon.name': 'Já existe um ícone com o mesmo nome',
    'error.notfound.customer.admin': 'Conta de administrador não encontrada',
    'error.apk.file.required': 'Selecione o arquivo com a extensão .apk ou .xapk',
    'error.apk.parse': 'Um erro ocorreu ao analisar o arquivo',
    'error.package.not.match': 'O ID do pacote não corresponde',
    'error.empty.app.name': 'Insira o nome da aplicação',
    'error.empty.app.pkg': 'Insira o ID do pacote',
    'error.empty.app.url': 'Insira a URL',
    'error.empty.app.iconText': 'Insira o texto do ícone',
    'error.empty.app.version': 'Insira a versão da aplicação',
    'error.notempty.group': 'Esse grupo inclui um ou mais dispositivos. Você não pode removê-lo.',
    'error.file.empty': 'Upload de um novo arquivo',
    'error.file.deletion': 'Erro ao excluir um arquivo do servidor',
    'error.file.save': 'Erro ao salvar o arquivo no servidor',
    'error.password.wrong': 'Senha inválida',
    'error.password.empty': 'Senha não especificado',
    'error.password.weak': 'Qualidade de senha fraca',
    'error.params.missing': 'Parâmetros ausentes:',
    'error.empty.push.options': 'Por favor, selecione as notificações de Push',
    'error.app.name.exists': 'Já existe outro aplicativo com este nome. Especifique um nome exclusivo.',

    'table.filtering.check.all': 'Selecionar Tudo',
    'table.filtering.uncheck.all': 'Cancelar Tudo',
    'table.filtering.suffix.configuration': 'configurações',
    'table.filtering.suffix.group': 'grupos',
    'table.filtering.suffix.permission': 'permissões',
    'table.filtering.no.selected.configuration': 'Nenhuma configuração selecionada',
    'table.filtering.no.selected.group': 'Nenhum grupo selecionado',
    'table.filtering.no.selected.permission': 'Nenhuma permissão selecionada',

    'success.admin.created': 'Conta de administrador criada:\n ${adminCredentials}',
    'success.uploading.file': 'O arquivo está sendo enviado para o servidor ...',
    'success.loading.devices': 'Carregando a lista de dispositivos ...',
    'success.loading.customer': 'Carregando os detalhes do cliente ...',
    'success.file.uploaded': 'Arquivo carregado com sucesso.',
    'success.file.uploaded.need.save': 'Arquivo enviado com sucesso. Insira o caminho relativo e clique em "Salvar".',
    'success.settings.design.saved': 'Configurações de design salvas com sucesso',
    'success.settings.common.saved': 'Configurações de tabela de dispositivos salvas com sucesso',
    'success.settings.saved': 'Configurações salvas com sucesso',
    'success.settings.apiKey.saved': 'API key salva com sucesso',
    'success.settings.hints.enabled': 'Dicas habilitadas',
    'success.settings.hints.disabled': 'Dicas desabilitadas',
    'success.configuration.saved': 'Configuração salva com sucesso',
    'success.operation.completed': 'Operação completada com sucesso',
    'success.plugins.disabled': 'Configurações salvas com sucesso',
    'success.config.update.notification': 'O comando de atualização da configuração foi enviado aos dispositivos',
    'success.config.update.device.app.settings.notification': 'O comando para atualizar as configurações do aplicativo foi enviado ao dispositivo.',

    'form.icon.title': 'Ícone',
    'form.icon.name': 'Nome',
    'form.icon.file': 'Arquivo',

    'configuration.add.warning': 'Você tem certeza que quer criar uma configuração vazia? Você precisará adicionar todos os aplicativos de sistema necessários manualmente. Considere copiar e modificar uma configuração existente ao invés disso.',
    'configuration.remove.warning': 'Você tem certeza que quer remover a última configuração? Você perderá informações de quais aplicativos do sistema são necessários.',
    'form.configuration.title': 'Configuração',
    'form.configuration.title.typical': 'Configuração padrão',
    'form.configuration.settings.auto.update': 'Atualização automática',
    'form.configuration.settings.system.update': 'Atualização do sistema',
    'form.configuration.settings.system.update.default': 'Padrão',
    'form.configuration.settings.system.update.immediate': 'Imediatamente',
    'form.configuration.settings.system.update.scheduled': 'Agendado',
    'form.configuration.settings.system.update.postponed': 'Adiado',
    'form.configuration.settings.system.update.time': 'Hora de instalação',
    'form.configuration.settings.system.update.time.from': 'de:',
    'form.configuration.settings.system.update.time.to': 'a:',
    'form.configuration.settings.system.schedule.app.update': 'Agende a instalação do aplicativo',
    'form.configuration.settings.system.app.update.time': 'Hora de instalação',
    'form.configuration.settings.download.updates': 'Descarregar conteúdo',
    'form.configuration.settings.download.updates.unlimited': 'Sem limites',
    'form.configuration.settings.download.updates.limited': '3 tentativas na rede móvel',
    'form.configuration.settings.download.updates.wifi': 'Apenas por WiFi',
    'form.configuration.settings.block.status.bar': 'Bloqueio da barra de status',
    'form.configuration.settings.block.status.bar.hint': 'Esta configuração está obsoleta e funciona no Android 6 e versões anteriores. Para bloquear a barra de status em versões mais recentes do Android, use o modo quiosque (configurações de MDM).',
    'form.configuration.settings.mdm.kiosk.mode': 'Modo Kiosk',
    'form.configuration.settings.mdm.app.main': 'Aplicação MDM',
    'form.configuration.settings.mdm.component.event.receiver': 'Classe de receptor administrador',
    'form.configuration.settings.mdm.component.event.receiver.placeholder': 'Deve ser com.hmdm.launcher.AdminReceiver',
    'form.configuration.settings.mdm.component.wifi.ssid': 'WiFi SSID',
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'Insrição de WiFi SSID - deixe vazio para inserir manualmente',
    'form.configuration.settings.mdm.component.wifi.password': 'Senha do WiFi',
    'form.configuration.settings.mdm.component.wifi.password.placeholder': 'Inscrição de WiFi pass - deixe vazio para inserir manualmente',
    'form.configuration.settings.mdm.component.wifi.security': 'Tipo de segurança do WiFi',
    'form.configuration.settings.mdm.component.wifi.notice': 'Aviso: algumas configurações de WiFi são aplicadas apenas à inscrição inicial!',
    'form.configuration.settings.mdm.component.server.url': 'Novo URL do servidor',
    'form.configuration.settings.mdm.component.server.url.placeholder': 'Usado para migração para um novo servidor de MDM',
    'form.configuration.settings.mdm.app.content': 'Aplicação de Conteúdo',
    'form.configuration.settings.mdm.kiosk.home': 'Habilitar botão Home',
    'form.configuration.settings.mdm.kiosk.recents': 'Habilitar botão Recentes',
    'form.configuration.settings.mdm.kiosk.notifications': 'Habilitar notificações',
    'form.configuration.settings.mdm.kiosk.system.info': 'Habilitar informações da barra de status',
    'form.configuration.settings.mdm.kiosk.keyguard': 'Habilitar bloqueio de tela',
    'form.configuration.settings.mdm.kiosk.lock.buttons': 'Trave o botão liga/desliga',
    'form.configuration.settings.mdm.mobile.enrollment': 'Registre-se usando dados móveis',
    'form.configuration.settings.mdm.encrypt.device': 'Encriptação de dispositivo',
    'form.configuration.settings.mdm.lock.safe.settings': 'Configurações de bloqueio de segurançå (WiFi, GPS, etc)',
    'form.configuration.settings.mdm.permissive': 'Modo permissivo (desbloqueado)',
    'form.configuration.settings.mdm.kiosk.exit': 'Botão de saída do quiosque',
    'form.configuration.settings.mdm.allowed.classes': 'Atividades permitidas',
    'form.configuration.settings.mdm.allowed.classes.placeholder': 'Classes separadas por vírgulas, por exemplo: com.android.settings.homepage.SettingsHomepageActivity',
    'form.configuration.settings.mdm.restrictions': 'Restrições',
    'form.configuration.settings.mdm.restrictions.placeholder': 'Restrições do MDM separadas por vírgula, por exemplo: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.misc': 'Outras entradas de código QR',
    'form.configuration.settings.mdm.misc.placeholder': 'Entradas separadas por vírgula, p.e.:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url': 'URL do QR code',
    'form.configuration.settings.mdm.hint': 'Selecione a aplicação principal e componente',
    'form.configuration.apps.search.label': 'Buscar por:',
    'form.configuration.apps.sort.label': 'Ordenar:',
    'form.configuration.apps.sort.byname': 'Por nome',
    'form.configuration.apps.sort.bypkg': 'Por ID',
    'form.configuration.apps.no.apk': 'Nenhum',
    'form.configuration.apps.show.systeam.apps': 'Mostrar Aplicações do Sistema',
    'form.configuration.apps.action.select': '(selecione)',
    'form.configuration.apps.action.install': 'Instalar',
    'form.configuration.apps.action.prohibit': 'Bloquear',
    'form.configuration.apps.action.not.install': 'Não instalar',
    'form.configuration.apps.action.delete': 'Excluir',
    'form.configuration.apps.action.permit': 'Permitir',
    'form.configuration.apps.label.inherit': 'Herdado',
    'form.configuration.apps.label.show': 'Mostrar',
    'form.configuration.apps.label.not.show': 'Ocultar',
    'form.configuration.apps.edit.details': 'Parâmetros adicionais',
    'form.configuration.apps.keycode': 'Código chave',
    'form.configuration.apps.bottom': 'Exibir na linha abaixo',
    'form.configuration.apps.long.tap': 'Configurações por toque longo',
    'form.configuration.apps.hint': 'Dica: para desvincular o aplicativo da configuração, selecione a ação "Bloquear" ou "Não instalar".',
    'form.configuration.settings.design.use.default': 'Use o design padrão',
    'form.configuration.settings.design.color.background': 'Cor de fundo',
    'form.configuration.settings.design.color.background.placeholder': 'Selecione uma cor',
    'form.configuration.settings.design.color.app.names': 'Cor dos nomes dos aplicativos',
    'form.configuration.settings.design.color.app.names.placeholder': 'Selecione uma cor',
    'form.configuration.settings.design.background.image.url': 'URL da imagem de fundo',
    'form.configuration.settings.design.background.image.url.placeholder': 'Insira a URL da imagem de fundo',
    'form.configuration.settings.design.icon': 'Tamanho do ícone',
    'form.configuration.settings.design.icon.small': 'Pequeno',
    'form.configuration.settings.design.icon.medium': 'Médio (+ 20%)',
    'form.configuration.settings.design.icon.large': 'Grande (+ 40%)',
    'form.configuration.settings.design.desktop.header': 'Título da área de Trabalho',
    'form.configuration.settings.design.desktop.header.no': 'Não',
    'form.configuration.settings.design.desktop.header.deviceid': 'ID do dispositivo',
    'form.configuration.settings.design.desktop.header.description': 'Descrição',
    'form.configuration.settings.design.desktop.header.custom': 'Modelo personalizado',
    'form.configuration.settings.design.desktop.header.hint': 'Certifique-se de que este parâmetro seja enviado aos dispositivos (Ajustes - Ajustes gerais e de idioma)',
    'form.configuration.settings.design.desktop.header.template': 'Insira o modelo',
    'form.configuration.settings.design.desktop.header.template.placeholder': 'Use variáveis',
    'form.configuration.settings.design.display.status': 'Exibir hora e estado da bateria',
    'form.configuration.settings.design.upload': 'Upload',
    'form.configuration.settings.common.name': 'Nome',
    'form.configuration.settings.common.name.placeholder': 'Insira o nome da configuração',
    'form.configuration.settings.common.desc': 'Descrição',
    'form.configuration.settings.common.desc.placeholder': 'Insira a descrição da configuração',
    'form.configuration.settings.common.admin.pwd': 'Senha de desbloqueio',
    'form.configuration.settings.common.admin.pwd.placeholder': 'Insira a senha de desbloqueio do dispositivo',
    'form.configuration.settings.common.gps': 'GPS',
    'form.configuration.settings.common.gps.any': 'Qualquer',
    'form.configuration.settings.common.gps.off': 'Desabilitado',
    'form.configuration.settings.common.gps.on': 'Habilitado',
    'form.configuration.settings.common.bluetooth': 'Bluetooth',
    'form.configuration.settings.common.wifi': 'Wi-Fi',
    'form.configuration.settings.common.mobile.data': 'Dados móveis',
    'form.configuration.settings.common.usb.storage': 'Bloquear armazenamento USB',
    'form.configuration.settings.common.brightness': 'Gerenciar brilho',
    'form.configuration.settings.common.brightness.none': 'Nenhum',
    'form.configuration.settings.common.brightness.auto': 'Automático',
    'form.configuration.settings.common.brightness.manual': 'Valor',
    'form.configuration.settings.common.brightness.value': 'Brilho da tela',
    'form.configuration.settings.common.timeout': 'Gerenciar tempo limite de tela',
    'form.configuration.settings.common.timeout.value': 'Tempo limite de tela',
    'form.configuration.settings.common.volume.block': 'Bloquear volume',
    'form.configuration.settings.common.volume.manage': 'Gerenciar volume',
    'form.configuration.settings.common.volume.value': 'Volume',
    'form.configuration.settings.common.timezone.mode': 'Gerenciar fuso horário',
    'form.configuration.settings.common.timezone.mode.default': 'Não gerenciar',
    'form.configuration.settings.common.timezone.mode.auto': 'Automático',
    'form.configuration.settings.common.timezone.mode.manual': 'Manual',
    'form.configuration.settings.common.timezone': 'Fuso horário',
    'form.configuration.settings.common.timezone.placeholder': 'por exemplo: America/Los_Angeles',
    'form.configuration.settings.common.timezone.link': 'Lista de fuso horários',
    'form.configuration.settings.common.no.network.warning': 'AVISO! Não desligue todos os canais de conexão, caso contrário você não será mais capaz de gerenciar mais os dispositivos!',
    'form.configuration.settings.common.autostart.foreground': 'Iniciar aplicativos em primeiro plano',
    'form.configuration.settings.request.updates': 'Rastreamento de localização',
    'form.configuration.settings.request.updates.donottrack': 'Sem rastreamento ativo (use dados de localização de aplicativos de terceiros)',
    'form.configuration.settings.request.updates.gps': 'Rastrear localização por GPS',
    'form.configuration.settings.request.updates.wifi': 'Rastrear localização por Wi-Fi (os serviços do Google devem estar ativados)',
    'form.configuration.settings.request.updates.prompt.gps': 'Para rastrear a localização por GPS, você precisa habilitar o GPS',
    'form.configuration.settings.request.updates.prompt.wifi': 'Para rastrear a localização por Wi-Fi, você precisa habilitar o Wi-Fi',
    'form.configuration.settings.revoke.location.permission': 'Sem permissão de localização',
    'form.configuration.settings.revoke.location.permission.hint': 'Se definido, a permissão de localização não será concedida ao agente MDM e não poderá rastrear a localização do dispositivo',
    'form.configuration.settings.apps.permissions': 'Permissões para outros aplicativos',
    'form.configuration.settings.apps.permissions.grant': 'Conceder automaticamente todas as permissões',
    'form.configuration.settings.apps.permissions.ask.location': 'Conceder automaticamente todos, pedir permissão de localização ao usuário',
    'form.configuration.settings.apps.permissions.deny.location': 'Conceder automaticamente todos, não conceder a permissão de localização',
    'form.configuration.settings.apps.permissions.ask.all': 'Pedir ao usuário todas as permissões',
    'form.configuration.settings.push.options' : 'Notificações via Push',
    'form.configuration.settings.push.options.mqtt.worker' : 'Protocolo MQTT (economizar bateria)',
    'form.configuration.settings.push.options.mqtt.alarm' : 'Protocolo MQTT',
    'form.configuration.settings.push.options.polling' : 'Sondagem HTTP',
    'form.configuration.settings.push.options.mqtt.worker.hint' : 'Envie mensagens instantaneamente quando o dispositivo estiver ativo. Mas as mensagens podem atrasar até algumas horas no modo de hibernação. Não use esta opção em dispositivos independentes. O MQTT usa a porta TCP 31000, habilite-o em seu firewall.',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'O MQTT é um protocolo leve que consome recursos mínimos. O MQTT utiliza a porta TCP 31000, ative-a na sua firewall.',
    'form.configuration.settings.push.options.polling.hint' : 'A sondagem longa persiste numa ligação HTTP que pode consumir mais recursos do servidor. Não requer qualquer porta TCP para além da HTTP(S).',
    'form.configuration.settings.push.options.keepalive' : 'Tempo Keep-Alive',
    'form.configuration.settings.minute.1' : '1 minuto',
    'form.configuration.settings.minutes.2' : '2 minutos',
    'form.configuration.settings.minutes.3' : '3 minutos',
    'form.configuration.settings.minutes.5' : '5 minutos',
    'form.configuration.settings.minutes.10' : '10 minutos',
    'form.configuration.settings.minutes.15' : '15 minutos',
    'form.configuration.settings.password.mode' : 'Requisitos de senha',
    'form.configuration.settings.password.mode.any' : 'Nenhum',
    'form.configuration.settings.password.mode.present' : 'Apresentar senha',
    'form.configuration.settings.password.mode.easy' : 'Fácil (ao menos 6 símbolos)',
    'form.configuration.settings.password.mode.moderate' : 'Moderado (mais de 8 letras e números)',
    'form.configuration.settings.password.mode.strong' : 'Forte (mais de 8, maiúsculas e minúsculas, números, símbolos)',
    'form.configuration.settings.show.wifi': 'Configurações de WiFi em erro de conexão',
    'form.configuration.settings.use.default.launcher': 'Modo de segundo plano',
    'form.configuration.settings.use.default.launcher.hint': 'Não substitua um iniciador de sistema, execute apenas serviços MDM em segundo plano. Não recomendado com o modo quiosque.',
    'form.configuration.settings.disable.screenshots': 'Desabilitar captura de tela',
    'form.configuration.settings.orientation': 'Bloquear orientação',
    'form.configuration.settings.orientation.none': 'Não bloquear',
    'form.configuration.settings.orientation.portrait': 'Retrato',
    'form.configuration.settings.orientation.landscape': 'Paisagem',
    'form.configuration.settings.files.default.path': 'Caminho padrão em um dispositivo',
    'form.configuration.files.search.label': 'Buscar:',
    'form.configuration.files.action.upload': 'Upload',
    'form.configuration.files.action.remove': 'Remover',
    'form.configuration.files.variables': 'Conteúdo variável',
    'form.configuration.files.variables.hint': 'Strings DEVICE_NUMBER, IMEI, CUSTOM* serão substituídos pelos seus valores',

    'form.configuration.file.name': 'Nome do arquivo',
    'form.configuration.file.select': 'Selecionar um ficheiro',
    'form.configuration.file.create': '(criar um novo ficheiro)',
    'form.configuration.file.description': 'Descrição do arquivo',
    'form.configuration.file.description.placeholder': 'Opcional, para sua conveniência',
    'form.configuration.file.path': 'Caminho no dispositivo',
    'form.configuration.file.path.placeholder': 'Excluindo caminho para um drive, por exemplo: /my-app/image.jpg',
    'form.configuration.file.url': 'URL',
    'form.configuration.file.url.placeholder': 'Se apenas um arquivos estiver hospedado no recurso externo',
    'form.configuration.file.file': 'Arquivo',
    'form.configuration.file.action': 'Ação',
    'form.configuration.file.action.prompt.1': 'Upload',
    'form.configuration.file.action.prompt.2': 'Remover',
    'form.configuration.file.remove.prompt.1': 'Este arquivo não será mais sincronizado com os dispositivos',
    'form.configuration.file.remove.prompt.2': 'Remover arquivos do servidor',

    'form.password.title': 'Alterar Senha',
    'form.password.label.user': 'Usuário',
    'form.password.label.password.new': 'Nova senha',
    'form.password.label.password.new.placeholder': 'Entre com uma nova senha',
    'form.password.label.password.confirm': 'Confirmar',
    'form.password.label.password.confirm.placeholder': 'Entre com a senha novamente',
    'form.password.length': 'Comprimento mínimo: ${length}. ',

    'form.application.type': 'Tipo',
    'form.application.type.option.web': 'Web-page',
    'form.application.type.option.app': 'Aplicativo',
    'form.application.type.option.intent': 'Ação do sistema',
    'form.application.intent': 'Ação',
    'form.application.intent.placeholder': 'Escolha uma ação',
    'form.application.url.hint': 'Use file:///storage/emulated/0/... para criar links para arquivos e pastas locais',
    'form.application.pkg': 'ID do pacote',
    'form.application.from.file': 'determinado a partir do arquivo',
    'form.application.pkg.title': 'ID do pacote é automaticamente determinado quando você faz upload do arquivo APK. A ID do pacote inserida manulamente é necessária apenas para aplicativos do sistema.',
    'form.application.pkg.placeholder': 'Por exemplo: com.android.camera',
    'form.application.disabled.arch': 'Versão específica',
    'form.application.disabled.arch.title': 'Para adicionar APKs para diferente arquiteturas de CPU, clique em "Adicionar" ou abra a lista de versões do aplicativo',
    'form.application.arch': 'Código nativo',
    'form.application.arch.title': 'Alguns aplicativos contém código otimizados para determinadas arquiteturas de CPU. Neste caso, você precisa fazer upload de duas APKs (para arquitetura armeabi-v7a e arm64-v8a)',
    'form.application.arch.universal': 'Nenhum (APK universal)',
    'form.application.arch.armeabi': 'Código nativo para armeabi-v7a',
    'form.application.arch.arm64': 'Código nativo para arm64-v8a',
    'form.application.arch.no.split': 'Universal APK',
    'form.application.arch.split': 'APK de divisão',
    'form.application.arch.warning': 'Este APK é otimizado apenas para ${arch} e pode não funcionar em todos os dispositivos. Recomenda-se carregar outro APK otimizado para outro arco de CPU. Para usar este APK em todos os dispositivos, selecione "APK universal".',
    'form.application.arch.success': 'Este aplicativo contém APKs para ambas arquiteturas de CPU',
    'form.application.version.exists': 'O APK para esta versão já existe',
    'form.application.url.armeabi': 'URL para armeabi-v7a',
    'form.application.url.arm64': 'URL para arm64-v8a',
    'form.application.name': 'Nome da Aplicação',
    'form.application.name.title': 'Você verá o nome do aplicativo na lista. Nós recomendamos usar nomes únicos e informativos.',
    'form.application.name.placeholder': 'Por exemplo: Câmera (Android)',
    'form.application.version': 'Versão',
    'form.application.version.placeholder': '0 para aplicativos do sistema',
    'form.application.version.title': 'Package version is automatically determined when you upload the APK file. Set it to 0 for system apps.',
    'form.application.version.code': 'Código da versão',
    'form.application.version.code.exists': 'Já existe uma versão com o mesmo código. Por favor, informe este problema para os desenvolvedores do aplicativo.',
    'form.application.system': 'System',
    'form.application.system.title': 'Os aplicativos do sistema são pré-instaladas em um disposito e não requerem URL ou arquivo. Marque essa opção apenas se precisar habilitar um determinado pacote de sistema.',
    'form.application.run.after.install': 'Rodar após instalação',
    'form.application.run.after.install.title': 'Aplicações com serviços de segundo plano precisam ser iniciados em primeiro plano ao menos uma vez.',
    'form.application.run.at.boot': 'Executar na inicialização',
    'form.application.run.at.boot.title': 'Defina este sinalizador se precisar executar o aplicativo em primeiro plano após a inicialização. Este sinalizador não está afetando os processos em segundo plano.',
    'form.application.url': 'URL',
    'form.application.url.title': 'A URL deve ser digitado apenas se o seu aplicativo está hospedado em um recurso externo. Recomenda-se fazer upload de um arquivo APK usando um campo abaixo.',
    'form.application.url.disabled': 'URL é configurada para cada versão. Para alterar a URL, feche esta janela e clique no ícone "Versões".',
    'form.application.file': 'Arquivo',
    'form.application.auto.update': 'Auto-Atualização',
    'form.application.auto.update.title': 'Defina este sinalizador para atualizar todas as configurações em que o aplicativo está instalado. Use apenas se tiver 100% de certeza de que o aplicativo é estável.',
    'form.application.showLabel': 'Mostrar Ícone',
    'form.application.showLabel.title': 'Este sinalizador indica se o ícone do aplicativo deve ser exibido no inicializador. Esta opção pode ser substituída na configuração.',
    'form.application.use.kiosk': 'Abrir no Kiosk Browser',
    'form.application.use.kiosk.title': 'Defina este sinalizador se desejar abrir uma página da web no Kiosk Browser sem qualquer possibilidade de alterar o endereço',
    'form.application.iconText': 'Texto do ícone',
    'form.application.iconText.placeholder': '(padrão)',
    'form.application.versions.title': 'Versões da aplicação',
    'form.application.icon': 'Ícone',
    'form.application.icon.default': '(padrão)',
    'form.application.icon.add': 'Adicionar ícone',

    'form.application.setting.app': 'Aplicativo',
    'form.application.setting.app.placeholder': 'Selecione uma aplicação',
    'form.application.setting.name': 'Atributo',
    'form.application.setting.value': 'Valor',
    'form.application.setting.comment': 'Comente',
    'form.application.setting.type': 'Tipo',
    'form.application.setting.readonly': 'Não muda no dispositivo',
    
    'form.application.configurations.app': 'Aplicativo',
    'form.application.configurations.configs': 'Configurações',

    'form.configuration.copy.new.name': 'Novo nome',
    'form.configuration.copy.new.name.placeholder': 'Insira o novo nome da configuração',

    'form.customer.name': 'Nome',
    'form.customer.name.placeholder': 'Insira o nome da organização',
    'form.customer.admin.name': 'Nome do admin',
    'form.customer.firstname.placeholder': 'Primeiro nome',
    'form.customer.lastname.placeholder': 'Sobrenome',
    'form.customer.language': 'Linguagem',
    'form.customer.language.placeholder': 'Deixe em branco para inglês ou digite duas letras minúsculas',
    'form.customer.apiKey': 'Chave de API',
    'form.customer.apiKey.placeholder': 'Insria a chave de API',
    'form.customer.prefix': 'Prefixo',
    'form.customer.prefix.placeholder': 'Insira o prefixo do número do dispositivo',
    'form.customer.device.configuration': 'Configuração do dispositvo',
    'form.customer.desc': 'Descrição',
    'form.customer.desc.placeholder': 'Insira uma descrição da organização',
    'form.customer.copy.configuration': 'Copiar configurações',
    'form.customer.copy.design': 'Copiar design',
    'form.customer.type': 'Tipo de cliente',
    'form.customer.status': 'Status do cliente',
    'form.customer.expiry.time': 'Data de validade',
    'form.customer.device.limit': 'Limite de dispositivos',
    'form.customer.size.limit': 'Limite de armazenamento',
    'form.customer.size.limit.placeholder': 'Tamanho (Mb)',

    'form.device.number': 'Número',
    'form.device.number.locked': 'Não é possível alterar o número, porque a alteração do número anterior não foi concluída.',
    'form.device.migration.warning': 'O número do dispositivo será alterado. Tenha certeza que o dispositivo está ligado e online.',
    'form.device.number.hint': 'Não use caracteres especiais',
    'form.device.desc': 'Descrição',
    'form.device.groups': 'Grupos',
    'form.device.config': 'Configuração',
    'form.device.imei': 'IMEI',
    'form.device.phone.number': 'Número do telefone',

    'form.update.device.config': 'Configuração',
    'form.update.device.action': 'Ação de grupo',
    'form.device.set.group': 'Adicionar a grupos',
    'form.device.clear.group': 'Remover dos grupos',

    'form.file.file': 'Arquivo',
    'form.file.name': 'Nome do ficheiro',
    'form.file.description': 'Descrição (opcional)',
    'form.file.external': 'Externo',
    'form.file.external.title': 'Em vez de carregar o ficheiro, pode especificar o URL num recurso externo',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': 'URL do ficheiro num recurso externo',
    'form.file.path': 'Caminho no servidor',
    'form.file.device.path': 'Caminho no dispositivo',
    'form.file.device.path.placeholder': 'Caminho relativo a /storage/emulated/0',
    'form.file.deleted': 'EXCLUÍDO',
    'form.file.copy.link': 'Copiar link: ${link}',
    'form.file.configurations.file': 'Ficheiro',
    'form.file.configurations.configs': 'Definições',
    'form.file.configurations.upload': 'Carregar',
    'form.file.path.placeholder': 'Insira um caminho relativo, por exemplo "/files/"',
    'form.file.available': 'Espaço disponível: ${space} Mb',

    'form.file.apps.name': 'Nome da Aplicação',
    'form.file.apps.pkg': 'ID do pacote',
    'form.file.apps.version': 'Versão',

    'form.group.name': 'Nome',
    'form.group.name.placeholder': 'Insira o nome do grupo',

    'form.role.nome': 'Nome',
    'form.role.name.placeholder': 'Introduza o nome da função',
    'form.role.permissions': 'Permissões',

    'form.user.login': 'Login',
    'form.user.login.placeholder': 'Insira o login do usuário',
    'form.user.name': 'Nome',
    'form.user.name.placeholder': 'Primeiro e último nome',
    'form.user.email': 'E-mail',
    'form.user.email.placeholder': 'Insira o e-mail',
    'form.user.role': 'Função',
    'form.user.all.devices.available': 'Todos dispositivos estão disponíveis',
    'form.user.available.groups': 'Grupos de dispositivos disponíveis',
    'form.user.all.configs.available': 'Todas configurações estão disponíveis',
    'form.user.available.configs': 'Configurações disponíveis',
    'form.user.password.new': 'Nova senha',
    'form.user.password': 'Senha',
    'form.user.password.new.placeholder': 'Entre com uma nova senha',
    'form.user.password.confirm': 'Confirmar',
    'form.user.password.confirm.placeholder': 'Entre com a senha novamente',

    'form.settings.hints.title': 'Dicas',

    'form.settings.plugins.title': 'Plugins usados',

    'form.settings.common.title': 'Visualização da tabela de dispositivos',
    'form.settings.common.visible.columns': 'Colunas visíveis na tabela de "Dispositivos"',
    'form.settings.common.status': 'Status',
    'form.settings.common.role': 'Função do usuário',
    'form.settings.common.date': 'Última data on-line',
    'form.settings.common.device.number': 'Número do dispositivo',
    'form.settings.common.imei': 'IMEI',
    'form.settings.common.phone.number': 'Número do telefone',
    'form.settings.common.phone.model': 'Modelo do telefone',
    'form.settings.common.status.permissions': 'Status de permissão',
    'form.settings.common.status.installation': 'Status de instalação',
    'form.settings.common.status.files': 'Status dos arquivos',
    'form.settings.common.config': 'Configuração',
    'form.settings.common.desc': 'Descrição',
    'form.settings.common.group': 'Grupo',
    'form.settings.common.launcher.version': 'Versão do lançador',
    'form.settings.common.battery.level': 'Nível da bateria',
    'form.settings.common.default.launcher': 'Segundo plano',
    'form.settings.common.mdm.mode': 'Modo MDM',
    'form.settings.common.kiosk.mode': 'Modo quiosque',
    'form.settings.common.android.version': 'Versão do Android',
    'form.settings.common.enrollment.date': 'Data de inscrição',
    'form.settings.common.serial': 'Número de série',
    'form.settings.common.publicip': 'Endereço de IP',

    'form.settings.design.title': 'Design padrão',
    'form.settings.design.color.font': 'Cor de fundo',
    'form.settings.design.color.font.placeholder': 'Selecione uma cor',
    'form.settings.design.color.app.names': 'Cor dos nomes dos aplicativos',
    'form.settings.design.color.app.names.placeholder': 'Selecione uma cor',
    'form.settings.design.url.background.image': 'URL da imagem de fundo',
    'form.settings.design.url.background.image.placeholder': 'Insira a URL da imagem de fundo',
    'form.settings.design.size.icon': 'Tamanho do ícone',
    'form.settings.design.size.icon.small': 'Pequeno',
    'form.settings.design.size.icon.medium': 'Médio (+ 20%)',
    'form.settings.design.size.icon.large': 'Grande (+ 40%)',
    'form.settings.design.desktop.header': 'Título da área de Trabalho',
    'form.settings.design.desktop.header.no': 'Não',
    'form.settings.design.desktop.header.device.id': 'ID do dispositivo',

    'form.settings.lang.title': 'Ajustes de idioma',
    'form.settings.lang.use.default': 'Utilizar idioma padrão',
    'form.settings.lang.use': 'Selecione um idioma',
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title': 'Ajustes diversas',
    'form.settings.misc.phone.format': 'Formato de número de telefone',
    'form.settings.misc.phone.format.placeholder': '+9 (999) 999-99-99',
    'form.settings.misc.custom.property.name.1': 'Propriedade personalizada #1',
    'form.settings.misc.custom.property.name.2': 'Propriedade personalizada #2',
    'form.settings.misc.custom.property.name.3': 'Propriedade personalizada #3',
    'form.settings.misc.custom.property.multiline': 'Multilinha',
    'form.settings.misc.custom.property.send': 'Enviar para o dispositivo',
    'form.settings.misc.custom.property.name.placeholder': 'Insira o nome de uma propriedade personalizada',
    'form.settings.misc.create.new.devices': 'Adicionar dispositivo no primeiro acesso',
    'form.settings.misc.new.device.config': 'Nova configuração de dispositivos',
    'form.settings.misc.new.device.group': 'Novo grupo de dispositivos',
    'form.settings.misc.send.description': 'Enviar descrição para dispositivos',
    'form.settings.misc.password.length': 'Comprimento mínimo da senha',
    'form.settings.misc.password.strength': 'Força da senha',
    'form.settings.misc.password.none': 'Não especificado (qualquer caractere)',
    'form.settings.misc.password.alphanumeric': 'Letras maiúsculas e minúsculas, dígitos',
    'form.settings.misc.password.specialchar': 'Letras maiúsculas e minúsculas, dígitos, caracteres especiais',
    'form.settings.misc.password.reset': 'O usuário deve redefinir a senha',
    'form.settings.misc.idle.logout': 'Sair quando ocioso',
    'form.settings.misc.idle.logout.never': 'Nunca',
    'form.settings.misc.idle.logout.1': '5 minutos',
    'form.settings.misc.idle.logout.2': '10 minutos',
    'form.settings.misc.idle.logout.3': '30 minutos',
    'form.settings.misc.idle.logout.4': '1 hora',
    'form.settings.security.title': 'Ajustes de segurança',

    'idle.logout.message': 'Você será desconectado em ${sec} segundos devido à inatividade',
    'idle.logout.resume': 'Estou aqui!',

    'form.settings.groups.title': 'Grupos',
    'form.settings.groups.search.placeholder': 'Pesquisar Grupo',

    'form.settings.users.title': 'Usuários',
    'form.settings.users.search.placeholder': 'Pesquisar usuário',

    'form.settings.roles.title': 'Funções de utilizador',

    'form.settings.icons.title': 'Ícones',
    'form.settings.icons.search.placeholder': 'Pesquisar ícones',

    'form.qr.device.number': 'Número do dispositivo',
    'form.qr.auto.create': 'Adicionar a lista de dispositivos se não existir',
    'form.qr.number.use': 'Atribuição de número de dispositivo',
    'form.qr.number.use.request': 'Valor do usuário',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': 'Número de série',
    'form.qr.number.hint': 'Limpe o número do dispositivo para habilitar a atribuição automática do número do dispositivo',
    'form.qr.groups': 'Adicionar aos grupos',
    'form.qr.button.json': 'Get JSON',
    'form.qr.device.number.placeholder': 'Insira o ID do dispositivo ...',
    'form.qr.code.image.alt': 'QR code',

    'form.password.reset.title': 'Por favor, configure uma nova senha',
    'form.password.reset.invalid': 'Desculpe, este link de redefinição de senha é inválido',
    'form.password.reset.submit': 'Defina a senha',

    'form.two.factor.auth.title': 'Autenticação de dois fatores',
    'form.two.factor.auth.hint': 'Para concluir sua inscrição, instale o aplicativo Authenticator em seu dispositivo móvel, escaneie o código QR, gere e insira o código de verificação.',
    'form.two.factor.auth.code.invalid': 'O código de verificação é inválido!',
    'form.two.factor.auth.code': 'Código de verificação',
    'form.two.factor.auth.code.hint': 'código de 6 dígitos do aplicativo autenticador',
    'form.two.factor.auth.code.error': 'O código deve ser um número de 6 dígitos',
    'form.two.factor.auth.verify': 'Verificar',
    'form.two.factor.auth.settings.hint': 'Para definir a autenticação de dois fatores, instale o aplicativo Authenticator em seu dispositivo móvel, escaneie o código QR, gere e insira o código de verificação.',
    'form.two.factor.auth.set': 'A autenticação de dois fatores está ativada',
    'form.two.factor.auth.reset': 'A autenticação de dois fatores está desativada',
    'form.two.factor.auth.off.confirm': 'Deseja desativar a autenticação de dois fatores? Depois de ligá-lo novamente, todos os autenticadores se tornarão inválidos.',

    'form.profile.title': 'Alterar Senha',
    'form.profile.password.old': 'Senha antiga',
    'form.profile.password.old.placeholder': 'Insira a senha antiga',
    'form.profile.password.new': 'Nova senha',
    'form.profile.password.new.placeholder': 'Entre com uma nova senha',
    'form.profile.password.confirm': 'Confirmar',
    'form.profile.password.confirm.placeholder': 'Entre com a senha novamente',

    'tab.customers': 'Organizações',
    'tab.common.applications': 'Aplicações compartilhadas',

    'tab.devices': 'Dispositivos',
    'tab.applications': 'Aplicativos',
    'tab.configurations': 'Configurações',
    'tab.files': 'Arquivos',
    'tab.default.design': 'Design padrão',
    'tab.common.settings': 'Visualização da tabela de dispositivos',
    'tab.users': 'Usuários',
    'tab.roles': 'Funções',
    'tab.groups': 'Grupos',
    'tab.icons': 'Ícones',
    'tab.language': 'Opções gerais e de idioma',
    'tab.license': 'Licença',
    'tab.hints': 'Dicas',
    'tab.plugins': 'Plugins',
    
    'tab.configeditor.common.settings': 'Configurações padrão',
    'tab.configeditor.design.settings': 'Configurações de Design',
    'tab.configeditor.applications': 'Aplicativos',
    'tab.configeditor.mdm.settings': 'Configurações de MDM',
    'tab.configeditor.app.settings': 'Configurações de aplicações',
    'tab.configeditor.files': 'Arquivos',

    'search.placeholder.file': 'Pesquise por arquivo',
    'search.placeholder.configuration': 'Pesquise por configuração',
    'search.placeholder.customer': 'Pesquise por uma organização',
    'search.placeholder.application': 'Pesquise por uma aplicação',
    'search.placeholder.application.setting': 'Pesquise uma configuração de aplicativo',
    'search.placeholder.device': 'Pesquisa por um dispositivo',
    'search.placeholder.address': 'Pesquisa de endereço',
    'search.placeholder.point': 'Pesquisa de site',
    'search.placeholder.message': 'Pesquisa de mensagem',
    'search.placeholder': 'Buscar ...',
    'search.placeholder.from': 'De ...',
    'search.placeholder.to': 'Para ...',
    'search.placeholder.user': 'Insira o nome do usuário',

    'table.heading.customer.name': 'Nome',
    'table.heading.customer.desc': 'Descrição',
    'table.heading.customer.registration.time': 'Registrado',
    'table.heading.customer.last.login.time': 'Último login',
    'table.heading.customer.actions': 'Ações',
    'table.heading.customer.type': 'Tipo',
    'table.heading.customer.expiry.time': 'Expiração',
    'table.heading.customer.device.limit': 'Limite',
    'table.heading.customer.status': 'Status',

    'customer.new': 'Novo',
    'customer.active': 'Ativo',
    'customer.need.followup': 'Necessita acompanhamento',
    'customer.followup.sent': 'Acompanhamento enviado',
    'customer.internal.test': 'Teste interno',
    'customer.developer': 'Desenvolvedor',
    'customer.difficult': 'Dificuldade',
    'customer.pause': 'Pausa',
    'customer.inactive': 'Sem login',
    'customer.abandon': 'Abandonado',
    'customer.onpremise': 'Teste no local',
    'customer.denial': 'Negação',
    'customer.client': 'Cliente',

    'table.heading.configuration.name': 'Nome',
    'table.heading.configuration.desc': 'Descrição',
    'table.heading.configuration.actions': 'Ações',

    'table.heading.application.setting.app.pkg': 'ID do pacote',
    'table.heading.application.setting.app.name': 'Nome da Aplicação',
    'table.heading.application.setting.name': 'Atributo',
    'table.heading.application.setting.value': 'Valor',
    'table.heading.application.setting.comment': 'Comentário',
    'table.heading.application.setting.lastUpdate': 'Data de criação',

    'table.heading.file.url': 'URL',
    'table.heading.file.devicepath': 'Caminho no dispositivo',
    'table.heading.file.description': 'Descrição do arquivo',
    'table.heading.file.action': 'Ação',
    'table.heading.file.lastUpdate': 'Data de criação',
    
    'table.heading.application.pkg': 'ID do pacote',
    'table.heading.application.name': 'Nome da Aplicação',
    'table.heading.application.version': 'Versão',
    'table.heading.application.url': 'URL',
    'table.heading.application.label': 'Ícone',
    'table.heading.application.actions': 'Ações',
    'table.heading.application.order': 'Order',

    'table.heading.device.status': 'Status',
    'table.heading.device.date': 'Conectados',
    'table.heading.device.device.number': 'Número do dispositivo',
    'table.heading.device.imei': 'IMEI',
    'table.heading.device.phone.number': 'Número do telefone',
    'table.heading.device.phone.model': 'Modelo do telefone',
    'table.heading.device.status.permissions': 'Status de permissão',
    'table.heading.device.status.installation': 'Status de instalação',
    'table.heading.device.status.files': 'Status dos arquivos',
    'table.heading.device.configuration': 'Configuração',
    'table.heading.device.desc': 'Descrição',
    'table.heading.device.group': 'Grupo',
    'table.heading.device.launcher.version': 'Versão do lançador',
    'table.heading.device.battery.level': 'Nível de bateria',
    'table.heading.device.default.launcher': 'Segundo plano',
    'table.heading.device.mdm.mode': 'Modo MDM',
    'table.heading.device.kiosk.mode': 'Modo quiosque',
    'table.heading.device.android.version': 'Versão do Android',
    'table.heading.device.enrollment.date': 'Data de inscrição',
    'table.heading.device.serial': 'Número de série',
    'table.heading.device.publicip': 'Endereço de IP',
    'table.heading.device.actions': 'Ações',

    'table.heading.group.name': 'Nome',
    'table.heading.group.actions': 'Ações',

    'table.heading.role.name': 'Nome',
    'table.heading.role.actions': 'Ações',

    'table.heading.file.name': 'Nome do arquivo',
    'table.heading.file.comment': 'Descrição',
    'table.heading.file.device.path': 'Caminho no dispositivo',
    'table.heading.file.update.time': 'Atualizado em',
    'table.heading.file.external': 'Externo',
    'table.heading.file.variable': 'Variável',
    'table.heading.file.remove': 'Remover',
    'table.heading.file.remove.hint': 'Obrigar a remoção do ficheiro do armazenamento do dispositivo',
    'table.heading.file.path': 'Caminho',
    'table.heading.file.address': 'Endereço',
    'table.heading.file.size': 'Tamanho',
    'table.heading.file.actions': 'Ações',

    'table.heading.users.login': 'Login',
    'table.heading.users.name': 'Nome',
    'table.heading.users.role': 'Funções',
    'table.heading.users.actions': 'Ações',

    'table.heading.common.apps.customer': 'Organização',
    'table.heading.common.apps.pkg': 'ID do Pacote',
    'table.heading.common.apps.name': 'Nome da Aplicação',
    'table.heading.common.apps.version': 'Verão',
    'table.heading.common.apps.url': 'URL',
    'table.heading.common.apps.label': 'Ícone',
    'table.heading.common.apps.actions': 'Ações',

    'notfound.devices': 'Não há dispositivos para mostrar.',
    'notfound.files':' A lista de arquivos está vazia.',
    'notfound.configurations': 'Nenhuma configuração foi encontrada.',
    'notfound.customers': 'Organizações não encontradas.',
    'notfound.common.apps': 'Não há aplicações para mostrar.',
    'notfound.applications': 'Aplicações não encontradas',
    'notfound.groups':' Grupos não encontrados. Tente uma consulta diferente.',
    'notfound.users':' Usuários não encontrados. Tente uma consulta diferente.',
    'notfound.apps.for.display': 'Não há aplicações para mostrar.',
    'notfound.app.versions.for.display': 'Não há versões para mostrar.',
    'notfound.roles':'A lista de funções está vazia.',
    'notfound.icons':'A lista de ícones está vazia.',

    'format.date.header': 'HH:mm dd/MM/yyyy',

    'menu.about': 'Sobre',
    'menu.profile': 'Perfil',
    'menu.panel.master': 'Painel Master',
    'menu.panel.main': 'Painel principal',
    'menu.logout': 'Deslogar',
    'menu.functions': 'Funções',
    'menu.settings': 'Ajustes',
    'menu.show.hints': 'Mostrar dicas',

    'plugin.name.not.specified': '<< O nome da função não foi especificado >>',

    'breadcrumb.summary': 'Resumo',
    'breadcrumb.devices': 'Dispositivos',
    'breadcrumb.applications': 'Aplicativos',
    'breadcrumb.configurations': 'Configurações',
    'breadcrumb.files': 'Arquivos',
    'breadcrumb.default.design': 'Design por padrão',
    'breadcrumb.common.settings': 'Visualização da tabela de dispositivos',
    'breadcrumb.language.settings': 'Ajustes gerais e de idioma',
    'breadcrumb.license.settings': 'Licença',
    'breadcrumb.users': 'Usuários',
    'breadcrumb.roles': 'Funções',
    'breadcrumb.groups': 'Grupos',
    'breadcrumb.hints': 'Dicas',
    'breadcrumb.plugins': 'Plugins',
    'breadcrumb.config.details': 'Detalhes',
    'breadcrumb.application.versions': 'Versões',

    'app.name': 'Headwind MDM',
    'app.vendor.name':"h-mdm.com",
    'app.vendor.link':"https://h-mdm.com",
    'app.description': 'é o sistema de gerenciamento de dispositivos móveis de código aberto',
    'app.title': 'Painel Web ${appName}',

    'box.show.my.apps.only': 'Mostrar apenas minhas aplicações',
    'configuration.app.version.upgrade.message': 'Versão instalada ${installedVersion}, versão disponível ${latestVersion}',

    'about.line.1': 'Painel de controle ${appName}',
    'about.line.2': 'Iniciador empresarial para Android',
    'about.line.3': 'Versão ${versionNumber}',
    'about.line.4': 'Plugins Instalador',

    'common.app.clarification': 'Essa aplicação é pública e não está disponível para edição. Para adicionar outra versão deste app, por favor, entre em contato com o administrador.',

    'qrcode.help.line1': 'Para configurar o dispositivo Android (verão 7 ou posterior) em um modo gerenciado (corporativo):',
    'qrcode.help.line2': 'Redefina o dispositivo para as configurações de fábrica',
    'qrcode.help.line3': 'Toque 7 vezes em qualquer lugar da tela inicial (você deve entrar em modo oculto de leitura de QR code)',
    'qrcode.help.line4': 'Siga as instruções do dispositivo: aceite os termos, conecte-se ao Wi-Fi, escaneie este QR code',
    'qrcode.help.line5': 'O QR code talvez contenha o ID do dispositivo para ${appName} (então você não precisa inserí-lo em um dispositivo mobile). Para incorporar o ID do dispositivo ao QR code, insira o ID do dispositivo nesta tela e clique "Renovar".',

    'form.configuration.app.version.select.select.title': 'Selecione a versão para instalar',
    'form.configuration.app.version.select.version.check.off': 'Desabilitar verificação de versão',
    'form.configuration.app.version.select.upgrade.warning': 'Atualizar aplicativo "${v1}" para versão "${v3}" para configuração "${v2}"?',
    'form.configuration.app.version.select.downgrade.warning': 'Downgrade de versão DELETA TODAS AS APLICAÇÕES em todos os dispositivos! Fazer downgrade da aplicação da versão "${v1}" para a versão "${v2}"? ',

    'hint.step.1': 'Clique aqui para iniciar o a inscrição do dispositivo',
    'hint.step.2': 'Clique aqui para abrir o QR code',
    'hint.step.3': 'Clique aqui para ver como abrir o  QR code scanner no dispositivo',
    'hint.step.4': 'Encontre um ID de dispositivo disponível na aba Dispositivos». Clique em «Renovar» para incluir  no QR code.',

    'ie.browser.notice.1': 'Infelizmente, o Internet Explorer não é compatível.',
    'ie.browser.notice.2': 'Browser recomendado para o ${appName} - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop">Chrome</a>.',

    'form.resolved.duplicate.pkg.text1': 'O ID "${pkg}" do pacote já é usado pelos aplicativos listados abaixo.',
    'form.resolved.duplicate.pkg.text2': 'Você deseja adicionar uma nova aplicação ou uma nova versão de uma aplicação existente?',
    'form.resolved.duplicate.pkg.text3': 'Nova versão para',
    'form.resolved.duplicate.pkg.text4': 'O ID "${pkg}" do pacote já é usado pelos aplicativos ${apps}',
    'form.resolved.duplicate.pkg.text5': 'Você tem certeza que deseja alterar o ID do pacote?',

    'tooltip.usage.byconfigurations': 'Usado por configurações',
    'tooltip.usage.byapps': 'Usado por aplicações',
    'tooltip.usage.byicons': 'Usado por ícones',

    'form.devices.label.params.more': 'Mais parâmetros',
    'form.devices.label.params.less': 'Menos parâmetros',
    'form.devices.label.installation.status': 'Status de instalação',
    "format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
    "format.devices.date.datePicker": "dd-MM-yyyy",
    'form.devices.fast.search': 'Pesquisa rápida por número',

    'form.devices.selection.install.status.default': 'Status da instalação ...',
    'form.devices.selection.install.status.all': 'Tudo',
    'form.devices.selection.install.status.success': 'Sucesso',
    'form.devices.selection.install.status.version.mismatch': 'Incompatibilidade de versão',
    'form.devices.selection.install.status.failure': 'Falha',
    'form.devices.selection.imei.changed': 'IMEI alterado recentemente',

    'search.placeholder.launcher.version': 'Versão do lançador',
    'error.date.range.invalid': 'Intervalo de data inválido',

    'form.selection.status.any': 'Qualquer valor',
    'form.selection.status.all': 'Tudo',
    'form.selection.status.yes': 'Sim',
    'form.selection.status.no': 'Não',

    'form.devices.selection.status': 'Status ...',
    'form.devices.selection.online': 'Conectados',
    'form.devices.selection.offline': 'Desconectados',
    'form.devices.selection.number': 'Insira numeros',

    'form.devices.selection.online.status.custom': 'Digite a hora',
    'form.devices.selection.online.status.1': '15 minutos',
    'form.devices.selection.online.status.2': '30 minutos',
    'form.devices.selection.online.status.3': '1 hora',
    'form.devices.selection.online.status.4': '2 horas',
    'form.devices.selection.online.status.5': '6 horas',
    'form.devices.selection.online.status.6': '1 dia',
    'form.devices.selection.online.status.7': '2 dias',
    'form.devices.selection.online.status.8': '3 dias',
    'form.devices.selection.online.status.9': '1 semana',
    'form.devices.selection.online.status.10': '1 mês',

    'form.devices.selection.online.status.label': 'minuto(s)',
    'form.devices.status.ago': 'atrás',
    'form.devices.status.minutes': 'm',
    'form.devices.status.hours': 'h',
    'form.devices.status.days': 'd',
    'form.devices.status.weeks': 's',
    'form.devices.status.months': 'mês',
    'form.devices.status.years': 'a',

    'customer.type.demo': 'Demonstração',
    'customer.type.small': 'Profissional',
    'customer.type.corporate': 'Empresarial',
    'customer.type.master': 'Primário',

    'customer.type.options.all': 'Todos os tipos',
    'customer.status.options.all': 'Todos os status',

    'account.expiring': 'Sua conta irá expirar em ${days} dias. Por favor, contate o vendedor para renovar sua conta.',
    'account.expired.short': 'Sua conta expirou!',
    'account.expired': 'Sua conta expirou. Por favor, contate o vendedor para renovar sua conta.',
    'device.limit.achieved': 'Não é possível adicionar um dispositivo, por quel você atingiu seu limite. Por favor, remova algum dispositivo ou contate o vendedor para extender seu limite de dispositivos.',

    'menu.updates': 'Verificar se há atualizações',
    'updates.title': 'Atualizações',
    'updates.disabled.custom': 'Versão personalizada, atualize manualmente',
    'updates.disabled.not_master': 'Peça ao provedor de hospedagem para atualizar',
    'updates.disabled.multiple': 'Várias versões de aplicativos, atualize manualmente',
    'updates.disabled.error': 'Erro interno do servidor',
    'updates.disabled.download': 'Erro ao baixar uma atualização',
    'updates.application': 'Aplicativo',
    'updates.current.version': 'Versão atual',
    'updates.available.version': 'Versão disponível',
    'updates.downloaded': 'Baixado',
    'updates.auto.update': 'Atualizar aplicativos móveis automaticamente (use com cuidado na produção!)',
    'updates.enable.stats': 'Enviar estatísticas de uso para o provedor de serviços para melhorar o desempenho do sistema',
    'updates.get': 'Obter atualizações',
    'updates.checking': 'Verificando atualizações...',
    'updates.getting': 'Recebendo atualizações...',
    'updates.success': 'Atualização concluída',
    'updates.web.hint': 'Para concluir a atualização do aplicativo da web, execute o shell script /opt/hmdm/update-web-app.sh no console SSH',

    'permission.edit_device_app_settings': 'Gerir definições de aplicações específicas do dispositivo',
    'permission.plugins_customer_access_management': 'Gerir os plugins disponíveis',
    'permission.plugin_audit_access': 'Ver o registo de auditoria',
    'permission.plugin_contacts_access': 'Gerir contactos',
    'permission.plugin_deviceexport_access': 'Exportar dispositivos',
    'permission.plugin_deviceimport_access': 'Importar dispositivos',
    'permission.plugin_deviceinfo_access': 'Ver informações detalhadas do dispositivo',
    'permission.plugin_devicelocations_access': 'Ver dispositivos no mapa',
    'permission.plugin_devicelocations_settings_access': 'Configurar o plugin do mapa',
    'permission.plugin_devicelog_access': 'Ver registos do dispositivo',
    'permission.plugin_devicereset_access': 'Redefinir e reiniciar dispositivos',
    'permission.plugin_licensing_access': 'Acesso à licença (obsoleto)',
    'permission.plugin_messaging_send': 'Enviar mensagens',
    'permission.plugin_messaging_delete': 'Apagar mensagens enviadas',
    'permission.plugin_photo_remove_photo': 'Apagar fotos',
    'permission.settings': 'Gerir definições',
    'permission.configurations': 'Ver definições',
    'permission.edit_devices': 'Editar informação do dispositivo',
    'permission.edit_device_desc': 'Editar descrição do dispositivo',
    'permission.enroll_devices': 'Registe os dispositivos por código QR',
    'permission.plugin_apuppet_access': 'Controlo remoto',
    'permission.plugin_knox_access': 'Plugin Knox',
    'permission.add_config': 'Adicionar definições',
    'permission.copy_config': 'Configurações duplicadas',
    'permission.plugin_openvpn_access': 'Plugin OpenVPN',
    'permission.plugin_photo_access': 'Plugin de fotografia',
    'permission.push_api': 'Acesso à API Push',
    'permission.plugin_urlfilter_access': 'Filtragem de URL',
    'permission.plugin_push_send': 'Enviar mensagens push',
    'permission.plugin_push_delete': 'Apagar mensagens push',
    'permission.get_updates': 'Verificar atualizações',
    'permission.plugin_xtra_access': 'Pedido de versão Premium',
    'permission.applications': 'Ver aplicações',
    'permission.edit_applications': 'Gerir aplicações',
    'permission.edit_application_versions': 'Gerir versões da aplicação',
    'permission.files': 'Ver ficheiros',
    'permission.edit_files': 'Gerir ficheiros',

    'yes': 'sim',
    'no': 'não'
};
