if (! document.localization) document.localization = [];

document.localization ['en_US'] = {
    'login.username': 'Username or email',
    'login.username.placeholder': 'Enter your username or email',
    'login.password': 'Password:',
    'login.password.placeholder': 'Enter password',
    'login.submit': 'Login',
    'login.password.incorrect': 'Invalid username or password',
    'login.password.recovery': 'Lost password?',
    'recovery.password': 'Recover password',
    'recovery.password.success': 'Password recovery instructions have been sent to your email',
    'login.no.account': 'Don\'t have an account?',
    'login.signup': 'Sign up',

    'signup.title': 'Get started',
    'signup.email': 'Your email address',
    'signup.email.placeholder': 'Enter a valid email address',
    'signup.email.invalid': 'Enter a valid email address',
    'signup.terms.agree': 'I agree with',
    'signup.terms.terms': 'terms and conditions',
    'signup.submit': 'Sign up',
    'signup.progress': 'Signing up...',
    'signup.email.used': 'A customer with this email is already registered',
    'signup.name.used': 'A customer with this username is already registered',
    'signup.complete': 'Thank you for signing up!',
    'signup.email.check': 'Please check your email and follow the link to complete the registration!',
    'signup.complete.title': 'Your account at ${appName} is almost ready!',
    'signup.ready.title': 'Your account at ${appName} is ready!',
    'signup.customer.id': 'Username',
    'signup.customer.id.placeholder': 'Use letters and digits only',
    'signup.customer.id.invalid': 'Please use 6 or more characters, letters and digits only',
    'signup.first.name': 'First name',
    'signup.first.name.placeholder': 'Your first name (required)',
    'signup.last.name': 'Last name',
    'signup.last.name.placeholder': 'Your last name (required)',
    'signup.company': 'Company name',
    'signup.company.placeholder': 'Name of your business (optional)',
    'signup.description': 'How will you use MDM?',
    'signup.description.placeholder': 'This will help our team to assist you',
    'signup.password': 'Password',
    'signup.password.repeat': 'Repeat the password',
    'signup.password.placeholder': '6+ characters',
    'signup.password.short': 'Please enter at least 6 characters',
    'signup.password.not.match': 'Passwords do not match',
    'signup.finalized.title': 'Your account is ready!',
    'signup.finalized.description': 'In a short time, you must get the email containing useful instructions. Please review this email and login to the web panel using your username and password.',
    'signup.token.invalid.title': 'The token is invalid or already used',
    'signup.token.invalid.description': 'Please retry signing up to create a new account!',

    'header.label.username': 'Username',

    'summary.devices.status': 'Device status',
    'summary.devices.active': 'Active',
    'summary.devices.idle': 'Idle',
    'summary.devices.offline': 'Offline',
    'summary.devices.enrollment': 'Enrollment summary',
    'summary.devices.enrolled.total': 'Enrolled total',
    'summary.devices.enrolled.earlier': 'Enrolled earlier',
    'summary.devices.enrolled.monthly': 'Last 30 days',
    'summary.devices.installation.status': 'Application status',
    'summary.devices.installation.completed': 'Complete',
    'summary.devices.version.mismatch': 'Version mismatch',
    'summary.devices.installation.failed': 'Install failed',
    'summary.devices.enrolled.lastyear': 'Last 12 months',

    'devices.group.options.all': 'All groups',
    'devices.configuration.options.all': 'All configurations',
    'devices.permissions.all': 'All permissions are granted',
    'devices.permissions.not.as.device.admin': '- The application is not installed as a device administrator',
    'devices.permissions.window.overlap.prohibited': '- Overlay on top of other windows is not available',
    'devices.permissions.history.access.prohibited': '- Access to usage history is not configured',
    'devices.unknown': 'Unknown',
    'devices.model.unknown': 'Unknown',
    'devices.date.unknown': 'unknown',
    'devices.date.format': 'dd/MM/yy HH:mm',
    'devices.app.installed': '- ${applicationName}: Installed.',
    'devices.app.not.installed': '- ${applicationName}: not installed.',
    'devices.app.version.available': ', available ${applicationVersion}',
    'devices.app.installed.and.version.available': '- ${applicationName}: installed ${applicationInstalledVersion}, available ${applicationVersionAvailable}',
    'devices.app.needs.removal': '${applicationVersion}, removal is required',
    'devices.no.data': 'The device has not transmitted data',
    'devices.settings.conformance.broken': 'Mismatch with settings: (${serverData})',
    'devices.file.installed': '- ${file}: installed',
    'devices.file.not.installed': '- ${file}: not installed.',
    'devices.file.lastUpdate.differs': '- ${file}: difference in modification time ${diff} min',

    'button.apply': 'Apply',
    'button.gps.on': 'Enable GPS',
    'button.wifi.on': 'Enable Wi-Fi',
    'button.notify.update': 'Notify on update',
    'button.app.settings': 'Application settings',
    'button.ok': 'OK',
    'button.help': 'Help',
    'button.new.app': 'New application',
    'button.new.app.version': 'New version',
    'button.upgrade': 'Upgrade',
    'button.renew.config': 'Update on devices',
    'button.common': 'Common application',
    'button.close': 'Close',
    'button.yes': 'Yes',
    'button.cancel': 'Cancel',
    'button.save': 'Save',
    'button.save.and.close': 'Save and close',
    'button.more': 'More ...',
    'button.cleanup': 'Clear',
    'button.add': 'Add',
    'button.add.icon': 'New Icon',
    'button.search': 'Search',
    'button.export': 'Export',
    'button.change': 'Edit',
    'button.copy': 'Copy',
    'button.qrcode': 'QR code',
    'button.application': 'Application',
    'button.change.password': 'Change password',
    'button.set.configuration': 'Set configuration',
    'button.set.group': 'Set group',
    'button.group.action': 'Group action',
    'button.delete': 'Delete',
    'button.login': 'Login',
    'button.renew.code': 'Renew',
    'button.configurations': 'Configurations',
    'button.set.configurations': 'Specify Configurations',
    'button.edit.versions': 'Versions',
    'button.edit': 'Edit',
    'button.change.common.app': 'Edit Shared Application',
    'button.delete.common.app': 'Delete Shared Application',
    'button.turn.common.app': 'Make Common',
    'button.hints.enable': 'Show tooltips',
    'button.hints.disable': 'Hide tooltips',
    'button.show.password': 'Show password',
    'button.hide.password': 'Hide password',

    'question.impersonate.user': 'Log in to the application as the administrator of the organization "${customerName}"?',
    'question.change.user': 'Log in to the application as the user "${userName}"?',
    'question.delete.file': 'Delete file "${fileName}"?',
    'question.delete.customer': 'Delete organization "${customerName}"?',
    'question.delete.user': 'Delete user "${username}"?',
    'question.delete.application': 'Delete application "${applicationName}"?',
    'question.delete.application.version': 'Delete version "${applicationVersion}"?',
    'question.delete.configuration': 'Delete configuration "${configurationName}"?',
    'question.delete.group': 'Delete group "${groupName}"?',
    'question.delete.role': 'Delete the role "${roleName}"?',
    'question.delete.icon': 'Delete the icon "${iconName}"?',
    'question.delete.device.bulk': 'Delete selected devices?',
    'question.delete.device': 'Delete the device with the number "${deviceNumber}"?',
    'question.exit.without.saving': 'Changes are not saved. Anyway leave this page?',
    'question.turn2common.application': 'Share the application "${applicationName}"?',
    'question.app.upgrade': 'Update application "${v1}" to latest version for configuration "${v2}"?',

    'error.application.setting.empty.app': 'Specify application',
    'error.application.setting.empty.name': 'Enter a name',
    'error.application.setting.empty.value': 'Specify a value',

    'error.icon.dimension.invalid': 'Icon must be square',
    'error.icon.empty.name': 'Enter the name of the icon',
    'error.icon.empty.file': 'Upload icon file',
    'error.application.version.pkg.mismatch': 'Package ID of the file (${actual}) does not correspond to the application (${expected})',
    'error.empty.user': 'Select a user',
    'error.empty.user.name': 'Fill in the username',
    'error.empty.user.login': 'Fill in the user login',
    'error.empty.user.role': 'Select a user role',
    'error.empty.password': 'Enter new password',
    'error.empty.password.confirm': 'Enter password confirmation',
    'error.user.not.found': 'User not found',
    'error.email.not.configured': 'Email not configured',
    'error.email.not.found': 'User email not set',
    'error.empty.group.name': 'Fill in the group name',
    'error.empty.configuration': 'Specify the configuration',
    'error.empty.configuration.name': 'Fill in the configuration name',
    'error.empty.configuration.password': 'Fill in the password',
    'error.empty.configuration.contentApp': 'No content application specified',
    'error.empty.group': 'Add a device to one or more groups',
    'error.invalid.character': 'The device number cannot contain symbols / ? &',
    'error.invalid.configuration.mainApp': 'In the MDM settings, the wrong main application is used',
    'error.invalid.configuration.contentApp': 'Invalid content application used in MDM settings',
    'error.mismatch.password': 'Password and password confirmation must match',
    'error.empty.customer.name': 'Fill in the name of the organization',
    'error.empty.customer.prefix': 'Fill in the device number prefix',
    'error.empty.customer.device.configuration': 'Select device configuration',
    'error.empty.customer.duplicate.prefix': 'Prefix already in use',
    'error.duplicate.customer.name': 'The organization with the entered name already exists. Try a different name.',
    'error.duplicate.group.name': 'The group with the entered name already exists. Try a different name.',
    'error.duplicate.configuration.name': 'The configuration with the entered name already exists. Try a different name.',
    'error.duplicate.device.number': 'A device with this number already exists',
    'error.internal.server': 'Internal server error',
    'error.permission.denied': 'No rights to execute',
    'error.request.failure': 'Request failure',
    'error.configuration.device.use': 'Cannot delete this configuration, it is used on devices. First go to "Devices", find the devices using this configuration and change their settings.',
    'error.invalid.system.update.time': 'Invalid installation interval',
    'error.size.limit.exceeded': 'Storage limit exceeded',

    'error.configuration.file.empty.name': 'Enter a file name',
    'error.configuration.file.empty.desc': 'Specify a file description',
    'error.configuration.file.empty.path': 'Specify the path on the device',
    'error.configuration.file.empty.file': 'Please upload a file',
    'error.configuration.file.empty.url': 'Please specify the file URL',

    'error.notfound.device': 'Device not found',
    'error.duplicate.device': 'A device with the same number already exists',
    'error.duplicate.login': 'Such a login is already in use',
    'error.duplicate.email': 'A user with this email already exists',
    'error.duplicate.group': 'A group with the same name already exists',
    'error.duplicate.application': 'An application with this package ID and version already exists',
    'error.recent.application.version.exists': 'More recent application version exists',
    'error.common.application.access.prohibited': 'Managing of the common applications is allowed by Super-Administrator only',
    'error.application.config.reference.exists': 'The application is used in configurations and cannot be deleted',
    'error.application.version.deletion.prohibited': 'The version is either unique or used in configurations and cannot be deleted',
    'error.duplicate.file': 'A file with the same name already exists',
    'error.used.file': 'This file is used',
    'error.version.exists': 'The same version of this app already exists',
    'error.duplicate.configuration': 'A configuration with this name already exists',
    'error.duplicate.role.name': 'A role with the same name already exists',
    'error.empty.role.name': 'Please specify the role name',
    'error.duplicate.icon.name': 'An icon with the same name already exists',
    'error.notfound.customer.admin': 'Administrator account not found',
    'error.apk.file.required': 'Select the file with the .apk or .xapk extension',
    'error.apk.parse': 'An error occurred while parsing the file',
    'error.package.not.match': 'Package ID does not match',
    'error.empty.app.name': 'Enter application name',
    'error.empty.app.pkg': 'Enter the package ID',
    'error.empty.app.url': 'Enter the URL',
    'error.empty.app.iconText': 'Enter the icon text',
    'error.empty.app.version': 'Enter the version of the application',
    'error.notempty.group': 'This group includes one or more devices. You cannot remove it.',
    'error.file.empty': 'Upload a new file',
    'error.file.deletion': 'Error deleting file on server',
    'error.file.save': 'Error while saving file on server',
    'error.password.wrong': 'Invalid password',
    'error.password.empty': 'Password not specified',
    'error.password.weak': 'Weak password quality',
    'error.params.missing': 'Missing parameters:',
    'error.empty.push.options': 'Please select the Push notifications options',
    'error.app.name.exists': 'Another application with this name already exists. Please specify a unique name.',

    'table.filtering.check.all': 'Select All',
    'table.filtering.uncheck.all': 'Cancel All',
    'table.filtering.suffix.configuration': 'configurations',
    'table.filtering.suffix.group': 'groups',
    'table.filtering.suffix.permission': 'permissions',
    'table.filtering.no.selected.configuration': 'No configurations selected',
    'table.filtering.no.selected.group': 'No groups selected',
    'table.filtering.no.selected.permission': 'No permissions selected',

    'success.admin.created': 'Administrator account created:\n ${adminCredentials}',
    'success.uploading.file': 'The file is being uploaded to the server ...',
    'success.loading.devices': 'Loading device list ...',
    'success.loading.customer': 'Loading customer details ...',
    'success.file.uploaded': 'File uploaded successfully.',
    'success.file.uploaded.need.save': 'File uploaded successfully. Enter the relative path and click "Save".',
    'success.settings.design.saved': 'Design settings saved successfully',
    'success.settings.common.saved': 'Device table settings saved successfully',
    'success.settings.saved': 'Settings saved successfully',
    'success.settings.apiKey.saved': 'API key saved successfully',
    'success.settings.hints.enabled': 'Hints enabled',
    'success.settings.hints.disabled': 'Hints disabled',
    'success.configuration.saved': 'Configuration saved successfully',
    'success.operation.completed': 'Operation completed successfully',
    'success.plugins.disabled': 'Settings saved successfully',
    'success.config.update.notification': 'Configuration update command has been sent to devices',
    'success.config.update.device.app.settings.notification': 'The command to update application settings has been sent to the device.',

    'form.icon.title': 'Icon',
    'form.icon.name': 'Name',
    'form.icon.file': 'File',

    'configuration.add.warning': 'Are you sure you want to create an empty configuration? You will need to add all required system apps manually. Consider copying and modifying an existing configuration instead.',
    'configuration.remove.warning': 'Are you sure you want to remove the last configuration? You will lose information which system apps are required.',
    'form.configuration.title': 'Configuration',
    'form.configuration.title.typical': 'Typical configuration',
    'form.configuration.settings.auto.update': 'Auto-Update',
    'form.configuration.settings.system.update': 'System Update',
    'form.configuration.settings.system.update.default': 'Default',
    'form.configuration.settings.system.update.immediate': 'Immediately',
    'form.configuration.settings.system.update.scheduled': 'Scheduled',
    'form.configuration.settings.system.update.postponed': 'Postponed',
    'form.configuration.settings.system.update.time': 'Installation time',
    'form.configuration.settings.system.update.time.from': 'from:',
    'form.configuration.settings.system.update.time.to': 'to:',
    'form.configuration.settings.system.schedule.app.update': 'Schedule app update',
    'form.configuration.settings.system.app.update.time': 'App update time',
    'form.configuration.settings.download.updates': 'Download content',
    'form.configuration.settings.download.updates.unlimited': 'Without limits',
    'form.configuration.settings.download.updates.limited': '3 attempts in the mobile network',
    'form.configuration.settings.download.updates.wifi': 'By WiFi only',
    'form.configuration.settings.block.status.bar': 'Status bar lock',
    'form.configuration.settings.block.status.bar.hint': 'This setting is deprecated and works well on Android 6 and below. To lock the status bar on newer Android versions, use the kiosk mode (MDM settings).',
    'form.configuration.settings.mdm.kiosk.mode': 'Kiosk mode',
    'form.configuration.settings.mdm.app.main': 'MDM application',
    'form.configuration.settings.mdm.component.event.receiver': 'Admin receiver class',
    'form.configuration.settings.mdm.component.event.receiver.placeholder': 'Should be com.hmdm.launcher.AdminReceiver',
    'form.configuration.settings.mdm.component.wifi.ssid': 'WiFi SSID',
    'form.configuration.settings.mdm.component.wifi.ssid.placeholder': 'Enrollment WiFi SSID - leave empty to enter manually',
    'form.configuration.settings.mdm.component.wifi.password': 'WiFi password',
    'form.configuration.settings.mdm.component.wifi.password.placeholder': 'Enrollment WiFi pass - leave empty to enter manually',
    'form.configuration.settings.mdm.component.wifi.security': 'WiFi security type',
    'form.configuration.settings.mdm.component.wifi.notice': 'Notice: these WiFi settings are applied to the initial enrollment only!',
    'form.configuration.settings.mdm.component.server.url': 'New server URL',
    'form.configuration.settings.mdm.component.server.url.placeholder': 'Used for migration to a new MDM server',
    'form.configuration.settings.mdm.app.content': 'Content application',
    'form.configuration.settings.mdm.kiosk.home': 'Enable Home button',
    'form.configuration.settings.mdm.kiosk.recents': 'Enable Recents button',
    'form.configuration.settings.mdm.kiosk.notifications': 'Enable notifications',
    'form.configuration.settings.mdm.kiosk.system.info': 'Enable status bar info',
    'form.configuration.settings.mdm.kiosk.keyguard': 'Enable screen lock',
    'form.configuration.settings.mdm.kiosk.lock.buttons': 'Lock the Power button',
    'form.configuration.settings.mdm.mobile.enrollment': 'Enroll using mobile data',
    'form.configuration.settings.mdm.encrypt.device': 'Encrypt the device storage',
    'form.configuration.settings.mdm.lock.safe.settings': 'Lock safe settings (WiFi, GPS, etc)',
    'form.configuration.settings.mdm.permissive': 'Permissive (unlocked) mode',
    'form.configuration.settings.mdm.kiosk.exit': 'Kiosk exit button',
    'form.configuration.settings.mdm.allowed.classes': 'Allowed activities',
    'form.configuration.settings.mdm.allowed.classes.placeholder': 'Comma-separated classes, e.g.: com.android.settings.homepage.SettingsHomepageActivity',
    'form.configuration.settings.mdm.restrictions': 'Restrictions',
    'form.configuration.settings.mdm.restrictions.placeholder': 'MDM restrictions, comma-separated, e.g.: no_sms,no_outgoing_calls,no_usb_file_transfer',
    'form.configuration.settings.mdm.misc': 'Other QR code entries',
    'form.configuration.settings.mdm.misc.placeholder': 'comma-separated entries, e.g.:\n"android.app.extra.PROVISIONING_LOCALE": "de_DE"',
    'form.configuration.settings.mdm.qrcode.url': 'QR code URL',
    'form.configuration.settings.mdm.hint': 'Select the main application and component',
    'form.configuration.apps.search.label': 'Search for:',
    'form.configuration.apps.sort.label': 'Sort:',
    'form.configuration.apps.sort.byname': 'By name',
    'form.configuration.apps.sort.bypkg': 'By ID',
    'form.configuration.apps.no.apk': 'none',
    'form.configuration.apps.show.systeam.apps': 'Show System Applications',
    'form.configuration.apps.action.select': '(select)',
    'form.configuration.apps.action.install': 'Install',
    'form.configuration.apps.action.prohibit': 'Block',
    'form.configuration.apps.action.not.install': 'Do not install',
    'form.configuration.apps.action.delete': 'Delete',
    'form.configuration.apps.action.permit': 'Allow',
    'form.configuration.apps.label.inherit': 'Inherited',
    'form.configuration.apps.label.show': 'Show',
    'form.configuration.apps.label.not.show': 'Hide',
    'form.configuration.apps.edit.details': 'Additional parameters',
    'form.configuration.apps.keycode': 'Key code',
    'form.configuration.apps.bottom': 'Display at the bottom line',
    'form.configuration.apps.long.tap': 'Long tap opens settings',
    'form.configuration.apps.hint': 'Hint: to unlink the app from the configuration, select the action "Block" or "Do not install".',
    'form.configuration.settings.design.use.default': 'Use default design',
    'form.configuration.settings.design.color.background': 'Background Color',
    'form.configuration.settings.design.color.background.placeholder': 'Select a color',
    'form.configuration.settings.design.color.app.names': 'Application Names Color',
    'form.configuration.settings.design.color.app.names.placeholder': 'Select a color',
    'form.configuration.settings.design.background.image.url': 'URL of the background image',
    'form.configuration.settings.design.background.image.url.placeholder': 'Enter the url of the background image',
    'form.configuration.settings.design.icon': 'Icon size',
    'form.configuration.settings.design.icon.small': 'Small',
    'form.configuration.settings.design.icon.medium': 'Average (+ 20%)',
    'form.configuration.settings.design.icon.large': 'Large (+ 40%)',
    'form.configuration.settings.design.desktop.header': 'Desktop title',
    'form.configuration.settings.design.desktop.header.no': 'No',
    'form.configuration.settings.design.desktop.header.deviceid': 'Device ID',
    'form.configuration.settings.design.desktop.header.description': 'Description',
    'form.configuration.settings.design.desktop.header.custom': 'Custom template',
    'form.configuration.settings.design.desktop.header.hint': 'Make sure this parameter is sent to devices (Settings - General and language settings)',
    'form.configuration.settings.design.desktop.header.template': 'Enter the template',
    'form.configuration.settings.design.desktop.header.template.placeholder': 'Use variables',
    'form.configuration.settings.design.display.status': 'Display time and battery state',
    'form.configuration.settings.design.upload': 'Upload',
    'form.configuration.settings.common.name': 'Name',
    'form.configuration.settings.common.name.placeholder': 'Enter the configuration name',
    'form.configuration.settings.common.desc': 'Description',
    'form.configuration.settings.common.desc.placeholder': 'Enter the configuration description',
    'form.configuration.settings.common.admin.pwd': 'Unlock password',
    'form.configuration.settings.common.admin.pwd.placeholder': 'Enter the device unlock password',
    'form.configuration.settings.common.gps': 'GPS',
    'form.configuration.settings.common.gps.any': 'Any',
    'form.configuration.settings.common.gps.off': 'Disabled',
    'form.configuration.settings.common.gps.on': 'Enabled',
    'form.configuration.settings.common.bluetooth': 'Bluetooth',
    'form.configuration.settings.common.wifi': 'Wi-Fi',
    'form.configuration.settings.common.mobile.data': 'Mobile data',
    'form.configuration.settings.common.usb.storage': 'Block USB storage',
    'form.configuration.settings.common.brightness': 'Manage brightness',
    'form.configuration.settings.common.brightness.none': 'None',
    'form.configuration.settings.common.brightness.auto': 'Auto',
    'form.configuration.settings.common.brightness.manual': 'Value',
    'form.configuration.settings.common.brightness.value': 'Screen brightness',
    'form.configuration.settings.common.timeout': 'Manage screen timeout',
    'form.configuration.settings.common.timeout.value': 'Screen timeout (s)',
    'form.configuration.settings.common.volume.block': 'Lock volume',
    'form.configuration.settings.common.volume.manage': 'Manage volume',
    'form.configuration.settings.common.volume.value': 'Volume',
    'form.configuration.settings.common.timezone.mode': 'Manage time zone',
    'form.configuration.settings.common.timezone.mode.default': 'Do not manage',
    'form.configuration.settings.common.timezone.mode.auto': 'Auto',
    'form.configuration.settings.common.timezone.mode.manual': 'Manual',
    'form.configuration.settings.common.timezone': 'Time zone',
    'form.configuration.settings.common.timezone.placeholder': 'e.g. America/Los_Angeles',
    'form.configuration.settings.common.timezone.link': 'List of time zones',
    'form.configuration.settings.common.no.network.warning': 'WARNING! Do not switch off all connection channels, otherwise you won\'t be able to manage devices any more!',
    'form.configuration.settings.common.autostart.foreground': 'Autostart apps in foreground',
    'form.configuration.settings.request.updates': 'Location Tracking',
    'form.configuration.settings.request.updates.donottrack': 'No active tracking (use third-party app location data)',
    'form.configuration.settings.request.updates.gps': 'Track location by GPS',
    'form.configuration.settings.request.updates.wifi': 'Track location by Wi-Fi (Google services must be enabled)',
    'form.configuration.settings.request.updates.prompt.gps': 'To track location by GPS, you need to enable GPS',
    'form.configuration.settings.request.updates.prompt.wifi': 'To track location by Wi-Fi, you need to enable Wi-Fi',
    'form.configuration.settings.revoke.location.permission': 'No location permission',
    'form.configuration.settings.revoke.location.permission.hint': 'If set, the location permission will not be granted to the MDM agent and it could not track the device location',
    'form.configuration.settings.apps.permissions': 'Permissions for other apps',
    'form.configuration.settings.apps.permissions.grant': 'Auto-grant all permissions',
    'form.configuration.settings.apps.permissions.ask.location': 'Auto-grant all, ask user for the location permission',
    'form.configuration.settings.apps.permissions.deny.location': 'Auto-grant all, do not grant the location permission',
    'form.configuration.settings.apps.permissions.ask.all': 'Ask user for all permissions',
    'form.configuration.settings.push.options' : 'Push notifications',
    'form.configuration.settings.push.options.mqtt.worker' : 'MQTT protocol (save battery)',
    'form.configuration.settings.push.options.mqtt.alarm' : 'MQTT protocol',
    'form.configuration.settings.push.options.polling' : 'HTTP polling',
    'form.configuration.settings.push.options.mqtt.worker.hint' : 'Delivers Push messages instantly when the device is active. But messages may delay by up to few hours in sleeping mode. Do not use this option on standalone devices. MQTT uses TCP port 31000, enable it on your firewall.',
    'form.configuration.settings.push.options.mqtt.alarm.hint' : 'MQTT is a lightweight protocol consuming minimal resources. MQTT uses TCP port 31000, enable it on your firewall.',
    'form.configuration.settings.push.options.polling.hint' : 'Long polling persists an HTTP connection which can consume more server resources. Doesn\'t require any TCP ports other than HTTP(S).',
    'form.configuration.settings.push.options.keepalive' : 'Keep-Alive time',
    'form.configuration.settings.minute.1' : '1 minute',
    'form.configuration.settings.minutes.2' : '2 minutes',
    'form.configuration.settings.minutes.3' : '3 minutes',
    'form.configuration.settings.minutes.5' : '5 minutes',
    'form.configuration.settings.minutes.10' : '10 minutes',
    'form.configuration.settings.minutes.15' : '15 minutes',
    'form.configuration.settings.password.mode' : 'Password requirements',
    'form.configuration.settings.password.mode.any' : 'None',
    'form.configuration.settings.password.mode.present' : 'Password presents',
    'form.configuration.settings.password.mode.easy' : 'Easy (at least 6 symbols)',
    'form.configuration.settings.password.mode.moderate' : 'Moderate (8+ symbols, letters and digits)',
    'form.configuration.settings.password.mode.strong' : 'Strong (8+, upper & lowercase, digits, signs)',
    'form.configuration.settings.show.wifi': 'WiFi settings on connection error',
    'form.configuration.settings.use.default.launcher': 'Background mode',
    'form.configuration.settings.use.default.launcher.hint': 'Do not replace a system launcher, only run background MDM services. Not recommended with the kiosk mode.',
    'form.configuration.settings.disable.screenshots': 'Disable screen capture',
    'form.configuration.settings.orientation': 'Lock orientation',
    'form.configuration.settings.orientation.none': 'Do not lock',
    'form.configuration.settings.orientation.portrait': 'Portrait',
    'form.configuration.settings.orientation.landscape': 'Landscape',
    'form.configuration.settings.files.default.path': 'Default path on a device',
    'form.configuration.files.search.label': 'Search:',
    'form.configuration.files.action.upload': 'Upload',
    'form.configuration.files.action.remove': 'Remove',
    'form.configuration.files.variables': 'Variable content',
    'form.configuration.files.variables.hint': 'Strings DEVICE_NUMBER, IMEI, CUSTOM* will be replaced by their values',

    'form.configuration.file.name': 'File name',
    'form.configuration.file.select': 'Select a file',
    'form.configuration.file.create': '(create a new file)',
    'form.configuration.file.description': 'File description',
    'form.configuration.file.description.placeholder': 'Optional, for your convenience',
    'form.configuration.file.path': 'Path on device',
    'form.configuration.file.path.placeholder': 'Excluding path to a drive, e.g. /my-app/image.jpg',
    'form.configuration.file.url': 'URL',
    'form.configuration.file.url.placeholder': 'If only a file is hosted on an external resource',
    'form.configuration.file.file': 'File',
    'form.configuration.file.action': 'Action',
    'form.configuration.file.action.prompt.1': 'Upload',
    'form.configuration.file.action.prompt.2': 'Remove',
    'form.configuration.file.remove.prompt.1': 'This file will not be synchronized with devices any more',
    'form.configuration.file.remove.prompt.2': 'Remove file from the server',

    'form.password.title': 'Change Password',
    'form.password.label.user': 'User',
    'form.password.label.password.new': 'New password',
    'form.password.label.password.new.placeholder': 'Enter a new password',
    'form.password.label.password.confirm': 'Verify',
    'form.password.label.password.confirm.placeholder': 'Enter the new password again',
    'form.password.length': 'Minimal length: ${length}. ',

    'form.application.type': 'Type',
    'form.application.type.option.web': 'Web-page',
    'form.application.type.option.app': 'Application',
    'form.application.type.option.intent': 'System action',
    'form.application.intent': 'Action',
    'form.application.intent.placeholder': 'Choose an action',
    'form.application.url.hint': 'Use file:///storage/emulated/0/... to create links to local files and folders',
    'form.application.pkg': 'Package ID',
    'form.application.from.file': 'determined from file',
    'form.application.pkg.title': 'Package ID is automatically determined when you upload the APK file. Manually entered package ID is required for system apps only.',
    'form.application.pkg.placeholder': 'For example, com.android.camera',
    'form.application.disabled.arch': 'Version-specific',
    'form.application.disabled.arch.title': 'To add APKs for different CPU architectures, click "Add", or open the app versions list',
    'form.application.arch': 'Native code',
    'form.application.arch.title': 'Some apps contain code optimized for certain CPU architecture. In this case, you need to upload two APKs (for armeabi-v7a and arm64-v8a architectures)',
    'form.application.arch.universal': 'None (universal APK)',
    'form.application.arch.armeabi': 'Native code for armeabi-v7a',
    'form.application.arch.arm64': 'Native code for arm64-v8a',
    'form.application.arch.no.split': 'Universal APK',
    'form.application.arch.split': 'Split APK',
    'form.application.arch.warning': 'This APK is optimized for ${arch} only and may not work on all devices. It\'s recommended to upload another APK optimized for another CPU arch. To use this APK on all devices, select "Universal APK".',
    'form.application.arch.success': 'This app contains APKs for both CPU architectures',
    'form.application.version.exists': 'APK for this version already exists',
    'form.application.url.armeabi': 'URL for armeabi-v7a',
    'form.application.url.arm64': 'URL for arm64-v8a',
    'form.application.name': 'Application Name',
    'form.application.name.title': 'You will see the app name in the list. We recommend to use unique and informative names.',
    'form.application.name.placeholder': 'For example, Camera (Android)',
    'form.application.version': 'Version',
    'form.application.version.placeholder': '0 for preinstalled apps',
    'form.application.version.title': 'Package version is automatically determined when you upload the APK file. Set it to 0 for system apps.',
    'form.application.version.code': 'Version Code',
    'form.application.version.code.exists': 'A version with the same code already exists. Please report this issue to the app developers.',
    'form.application.system': 'Preinstalled app',
    'form.application.system.title': 'System applications are preinstalled on a device and do not require URL or file. Set this flag only if you need to enable a certain system package.',
    'form.application.run.after.install': 'Run after installation',
    'form.application.run.after.install.title': 'Applications with background services need to be started in the foreground at least once.',
    'form.application.run.at.boot': 'Run at boot',
    'form.application.run.at.boot.title': 'Set this flag if you need to run the app in the foreground after boot. This flag is not affecting background processes.',
    'form.application.url': 'URL',
    'form.application.url.title': 'The URL should be typed in only if your app is hosted on an external resource. It is recommended to upload an APK file by using a field below.',
    'form.application.url.disabled': 'URL is set up for each version. To change the URL, close this window and click the "Versions" icon.',
    'form.application.file': 'File',
    'form.application.auto.update': 'Auto Update',
    'form.application.auto.update.title': 'Set this flag to update all configurations where the app is installed. Use only if you are 100% sure the app is stable.',
    'form.application.showLabel': 'Show Icon',
    'form.application.showLabel.title': 'This flag denotes whether the app icon should be displayed in the launcher. This option may be overridden in the configuration.',
    'form.application.use.kiosk': 'Open in Kiosk Browser',
    'form.application.use.kiosk.title': 'Set this flag if you\'d like to open a web page in Kiosk Browser without any possibility to change the address',
    'form.application.iconText': 'Icon Text',
    'form.application.iconText.placeholder': '(default)',
    'form.application.versions.title': 'Versions of application',
    'form.application.icon': 'Icon',
    'form.application.icon.default': '(default)',
    'form.application.icon.add': 'Add icon',

    'form.application.setting.app': 'Application',
    'form.application.setting.app.placeholder': 'Select an application',
    'form.application.setting.name': 'Attribute',
    'form.application.setting.value': 'Value',
    'form.application.setting.comment': 'Comment',
    'form.application.setting.type': 'Type',
    'form.application.setting.readonly': 'Does not change on the device',
    
    'form.application.configurations.app': 'Application',
    'form.application.configurations.configs': 'Configurations',

    'form.configuration.copy.new.name': 'New name',
    'form.configuration.copy.new.name.placeholder': 'Enter the new configuration name',

    'form.customer.name': 'Customer ID',
    'form.customer.name.placeholder': 'Organization identifier used for signing in',
    'form.customer.admin.name': 'Admin name',
    'form.customer.firstname.placeholder': 'First name',
    'form.customer.lastname.placeholder': 'Last name',
    'form.customer.language': 'Language',
    'form.customer.language.placeholder': 'Empty for English or two small letters',
    'form.customer.apiKey': 'API key',
    'form.customer.apiKey.placeholder': 'Enter the API key',
    'form.customer.prefix': 'Prefix',
    'form.customer.prefix.placeholder': 'Enter the device number prefix',
    'form.customer.device.configuration': 'Device configuration',
    'form.customer.desc': 'Description',
    'form.customer.desc.placeholder': 'Enter a description of the organization',
    'form.customer.copy.configuration': 'Copy configurations',
    'form.customer.copy.design': 'Copy design',
    'form.customer.type': 'Customer type',
    'form.customer.status': 'Customer status',
    'form.customer.expiry.time': 'Expiry date',
    'form.customer.device.limit': 'Device limit',
    'form.customer.size.limit': 'Storage limit',
    'form.customer.size.limit.placeholder': 'Size (Mb)',

    'form.device.number': 'Number',
    'form.device.number.locked': 'Cannot change the number because the previous number change was not completed.',
    'form.device.migration.warning': 'The device number will be changed. Make sure the device is switched on and online.',
    'form.device.number.hint': 'Don\'t use special characters',
    'form.device.desc': 'Description',
    'form.device.groups': 'Groups',
    'form.device.config': 'Configuration',
    'form.device.imei': 'IMEI',
    'form.device.phone.number': 'Phone Number',

    'form.update.device.config': 'Configuration',
    'form.update.device.action': 'Group action',
    'form.device.set.group': 'Add to groups',
    'form.device.clear.group': 'Remove from groups',

    'form.file.file': 'File',
    'form.file.name': 'File name',
    'form.file.description': 'Description (optional)',
    'form.file.external': 'External',
    'form.file.external.title': 'Instead of uploading the file, you can specify the URL on an external resource',
    'form.file.external.url': 'URL',
    'form.file.external.url.placeholder': 'File URL on an external resource',
    'form.file.path': 'Path on server',
    'form.file.device.path': 'Path on device',
    'form.file.device.path.placeholder': 'Path relative to /storage/emulated/0',
    'form.file.deleted': 'DELETED',
    'form.file.copy.link': 'Copy link: ${link}',
    'form.file.configurations.file': 'File',
    'form.file.configurations.configs': 'Configurations',
    'form.file.configurations.upload': 'Upload',
    'form.file.path.placeholder': 'Enter a relative path, for example "/files/"',
    'form.file.available': 'Available space: ${space} Mb',

    'form.file.apps.name': 'Application Name',
    'form.file.apps.pkg': 'Package ID',
    'form.file.apps.version': 'Version',

    'form.group.name': 'Name',
    'form.group.name.placeholder': 'Enter the name of the group',

    'form.role.name': 'Name',
    'form.role.name.placeholder': 'Enter the name of the role',
    'form.role.permissions': 'Permissions',

    'form.user.login': 'Login',
    'form.user.login.placeholder': 'Enter user login',
    'form.user.name': 'Name',
    'form.user.name.placeholder': 'First and last name',
    'form.user.email': 'E-mail',
    'form.user.email.placeholder': 'Enter the email',
    'form.user.role': 'Role',
    'form.user.all.devices.available': 'All devices are available',
    'form.user.available.groups': 'Available device groups',
    'form.user.all.configs.available': 'All configs are available',
    'form.user.available.configs': 'Available configurations',
    'form.user.password.new': 'New Password',
    'form.user.password': 'Password',
    'form.user.password.new.placeholder': 'Enter a new password',
    'form.user.password.confirm': 'Verify',
    'form.user.password.confirm.placeholder': 'Enter the new password again',

    'form.settings.hints.title': 'Hints',

    'form.settings.plugins.title': 'Used Plugins',

    'form.settings.common.title': 'Device Table View',
    'form.settings.common.visible.columns': 'Visible columns in the "Devices" table',
    'form.settings.common.status': 'Status',
    'form.settings.common.role': 'Users role',
    'form.settings.common.date': 'Last online date',
    'form.settings.common.device.number': 'Device number',
    'form.settings.common.imei': 'IMEI',
    'form.settings.common.phone.number': 'Phone Number',
    'form.settings.common.phone.model': 'Phone Model',
    'form.settings.common.status.permissions': 'Permission Status',
    'form.settings.common.status.installation': 'Installation Status',
    'form.settings.common.status.files': 'Files Status',
    'form.settings.common.config': 'Configuration',
    'form.settings.common.desc': 'Description',
    'form.settings.common.group': 'Group',
    'form.settings.common.launcher.version': 'Launcher version',
    'form.settings.common.battery.level': 'Battery level',
    'form.settings.common.default.launcher': 'Background mode',
    'form.settings.common.mdm.mode': 'MDM mode',
    'form.settings.common.kiosk.mode': 'Kiosk mode',
    'form.settings.common.android.version': 'Android version',
    'form.settings.common.enrollment.date': 'Enrollment date',
    'form.settings.common.serial': 'Serial number',
    'form.settings.common.publicip': 'IP address',

    'form.settings.design.title': 'Default Design',
    'form.settings.design.color.font': 'Background Color',
    'form.settings.design.color.font.placeholder': 'Select a color',
    'form.settings.design.color.app.names': 'Application Names Color',
    'form.settings.design.color.app.names.placeholder': 'Select a color',
    'form.settings.design.url.background.image': 'URL of the background image',
    'form.settings.design.url.background.image.placeholder': 'Enter the background image URL',
    'form.settings.design.size.icon': 'Icon size',
    'form.settings.design.size.icon.small': 'Small',
    'form.settings.design.size.icon.medium': 'Average (+ 20%)',
    'form.settings.design.size.icon.large': 'Large (+ 40%)',
    'form.settings.design.desktop.header': 'Desktop title',
    'form.settings.design.desktop.header.no': 'No',
    'form.settings.design.desktop.header.device.id': 'Device ID',

    'form.settings.lang.title': 'Language settings',
    'form.settings.lang.use.default': 'Use default language',
    'form.settings.lang.use': 'Use language',
    'form.settings.lang.en': 'English',
    'form.settings.lang.pt': 'Português',
    'form.settings.lang.ru': 'Русский',
    'form.settings.lang.fr': 'Français',
    'form.settings.lang.ar': 'عربي',
    'form.settings.lang.es': 'Español',
    'form.settings.lang.de': 'Deutsch',
    'form.settings.lang.cn': '繁体中文',
    'form.settings.lang.tw': '繁體中文',
    'form.settings.lang.ja': '日本',
    'form.settings.lang.tr': 'Türkçe',
    'form.settings.lang.it': 'Italiano',

    'form.settings.misc.title': 'Miscellaneous settings',
    'form.settings.misc.phone.format': 'Phone number format',
    'form.settings.misc.phone.format.placeholder': '+9 (999) 999-99-99',
    'form.settings.misc.custom.property.name.1': 'Custom property #1',
    'form.settings.misc.custom.property.name.2': 'Custom property #2',
    'form.settings.misc.custom.property.name.3': 'Custom property #3',
    'form.settings.misc.custom.property.multiline': 'Multiline',
    'form.settings.misc.custom.property.send': 'Send to device',
    'form.settings.misc.custom.property.name.placeholder': 'Enter name for a custom property',
    'form.settings.misc.create.new.devices': 'Add device on first access',
    'form.settings.misc.new.device.config': 'New device configuration',
    'form.settings.misc.new.device.group': 'New device group',
    'form.settings.misc.send.description': 'Send description to devices',
    'form.settings.misc.password.length': 'Minimal password length',
    'form.settings.misc.password.strength': 'Password strength',
    'form.settings.misc.password.none': 'Not specified (any characters)',
    'form.settings.misc.password.alphanumeric': 'Lower and uppercase letters, digits',
    'form.settings.misc.password.specialchar': 'Lower and uppercase letters, digits, special chars',
    'form.settings.misc.password.reset': 'User should reset the password',
    'form.settings.misc.idle.logout': 'Log out when idle',
    'form.settings.misc.idle.logout.never': 'Never',
    'form.settings.misc.idle.logout.1': '5 minutes',
    'form.settings.misc.idle.logout.2': '10 minutes',
    'form.settings.misc.idle.logout.3': '30 minutes',
    'form.settings.misc.idle.logout.4': '1 hour',
    'form.settings.security.title': 'Security settings',

    'idle.logout.message': 'You will be signed out in ${sec} seconds because of inactivity',
    'idle.logout.resume': 'I am here!',

    'form.settings.groups.title': 'Groups',
    'form.settings.groups.search.placeholder': 'Group search',

    'form.settings.users.title': 'Users',
    'form.settings.users.search.placeholder': 'Search user',

    'form.settings.roles.title': 'User roles',

    'form.settings.icons.title': 'Icons',
    'form.settings.icons.search.placeholder': 'Search icons',

    'form.qr.device.number': 'Device number',
    'form.qr.auto.create': 'Add to device list if not exists',
    'form.qr.number.use': 'Device number assignment',
    'form.qr.number.use.request': 'User value',
    'form.qr.number.use.imei': 'IMEI',
    'form.qr.number.use.serial': 'Serial number',
    'form.qr.number.hint': 'Clear the device number to enable automatic device number assignment',
    'form.qr.groups': 'Add to groups',
    'form.qr.button.json': 'Get JSON',
    'form.qr.device.number.placeholder': 'Enter the device ID ...',
    'form.qr.code.image.alt': 'QR code',

    'form.password.reset.title': 'Please set up a new password',
    'form.password.reset.invalid': 'Sorry, this password reset link is invalid',
    'form.password.reset.submit': 'Set password',

    'form.two.factor.auth.title': 'Two-factor authentication',
    'form.two.factor.auth.hint': 'To complete your sign-up, please install the Authenticator app on your mobile device, scan the QR code, generate and enter the verification code.',
    'form.two.factor.auth.code.invalid': 'The verification code is invalid!',
    'form.two.factor.auth.code': 'Verification code',
    'form.two.factor.auth.code.hint': '6-digit code from the authenticator app',
    'form.two.factor.auth.code.error': 'The code must be a 6-digit number',
    'form.two.factor.auth.verify': 'Verify',
    'form.two.factor.auth.settings.hint': 'To set the two-factor authentication, please install the Authenticator app on your mobile device, scan the QR code, generate and enter the verification code.',
    'form.two.factor.auth.set': 'Two-factor authentication is turned on',
    'form.two.factor.auth.reset': 'Two-factor authentication is turned off',
    'form.two.factor.auth.off.confirm': 'Do you want to turn off two-factor authentication? After turning it back on, all authenticators will become invalid.',

    'form.profile.title': 'Change password',
    'form.profile.password.old': 'Old Password',
    'form.profile.password.old.placeholder': 'Enter old password',
    'form.profile.password.new': 'New Password',
    'form.profile.password.new.placeholder': 'Enter a new password',
    'form.profile.password.confirm': 'Verify',
    'form.profile.password.confirm.placeholder': 'Enter the new password again',

    'tab.customers': 'Organizations',
    'tab.common.applications': 'Shared Applications',

    'tab.devices': 'Devices',
    'tab.applications': 'Applications',
    'tab.configurations': 'Configurations',
    'tab.files': 'Files',
    'tab.default.design': 'Default Design',
    'tab.common.settings': 'Device Table View',
    'tab.users': 'Users',
    'tab.roles': 'Roles',
    'tab.groups': 'Groups',
    'tab.icons': 'Icons',
    'tab.language': 'General and language settings',
    'tab.license': 'License',
    'tab.hints': 'Hints',
    'tab.plugins': 'Plugins',
    
    'tab.configeditor.common.settings': 'Common settings',
    'tab.configeditor.design.settings': 'Design Settings',
    'tab.configeditor.applications': 'Applications',
    'tab.configeditor.mdm.settings': 'MDM Settings',
    'tab.configeditor.app.settings': 'Applications Settings',
    'tab.configeditor.files': 'Files',

    'search.placeholder.file': 'search file',
    'search.placeholder.configuration': 'Search for configuration',
    'search.placeholder.customer': 'Search for an organization',
    'search.placeholder.application': 'Search for an application',
    'search.placeholder.application.setting': 'Search for an application setting',
    'search.placeholder.device': 'Search for a device',
    'search.placeholder.address': 'Address search',
    'search.placeholder.point': 'Site search',
    'search.placeholder.message': 'Message search',
    'search.placeholder': 'Search ...',
    'search.placeholder.from': 'From ...',
    'search.placeholder.to': 'To ...',
    'search.placeholder.user': 'Type the user name',

    'table.heading.customer.name': 'Name',
    'table.heading.customer.desc': 'Description',
    'table.heading.customer.registration.time': 'Registered',
    'table.heading.customer.last.login.time': 'Last login',
    'table.heading.customer.actions': 'Actions',
    'table.heading.customer.type': 'Type',
    'table.heading.customer.expiry.time': 'Expires',
    'table.heading.customer.device.limit': 'Limit',
    'table.heading.customer.status': 'Status',

    'customer.new': 'New',
    'customer.active': 'Active',
    'customer.need.followup': 'Need follow-up',
    'customer.followup.sent': 'Follow-up sent',
    'customer.internal.test': 'Internal test',
    'customer.developer': 'Developer',
    'customer.difficult': 'Difficult',
    'customer.pause': 'Pause',
    'customer.inactive': 'No sign-in',
    'customer.abandon': 'Abandon',
    'customer.onpremise': 'On-premise trial',
    'customer.denial': 'Denial',
    'customer.client': 'Client',

    'table.heading.configuration.name': 'Name',
    'table.heading.configuration.desc': 'Description',
    'table.heading.configuration.actions': 'Actions',

    'table.heading.application.setting.app.pkg': 'Package ID',
    'table.heading.application.setting.app.name': 'Application Name',
    'table.heading.application.setting.name': 'Attribute',
    'table.heading.application.setting.value': 'Value',
    'table.heading.application.setting.comment': 'Comment',
    'table.heading.application.setting.lastUpdate': 'Creation Date',

    'table.heading.file.url': 'URL',
    'table.heading.file.devicepath': 'Path on device',
    'table.heading.file.description': 'File description',
    'table.heading.file.action': 'Action',
    'table.heading.file.lastUpdate': 'Creation date',
    
    'table.heading.application.pkg': 'Package ID',
    'table.heading.application.name': 'Application Name',
    'table.heading.application.version': 'Version',
    'table.heading.application.url': 'URL',
    'table.heading.application.label': 'Icon',
    'table.heading.application.actions': 'Actions',
    'table.heading.application.order': 'Order',

    'table.heading.device.status': 'Status',
    'table.heading.device.date': 'Date',
    'table.heading.device.device.number': 'Device Number',
    'table.heading.device.imei': 'IMEI',
    'table.heading.device.phone.number': 'Phone Number',
    'table.heading.device.phone.model': 'Phone Model',
    'table.heading.device.status.permissions': 'Permission Status',
    'table.heading.device.status.installation': 'Installation Status',
    'table.heading.device.status.files': 'Files status',
    'table.heading.device.configuration': 'Configuration',
    'table.heading.device.desc': 'Description',
    'table.heading.device.group': 'Group',
    'table.heading.device.launcher.version': 'Launcher version',
    'table.heading.device.battery.level': 'Battery level',
    'table.heading.device.default.launcher': 'Background mode',
    'table.heading.device.mdm.mode': 'MDM mode',
    'table.heading.device.kiosk.mode': 'Kiosk mode',
    'table.heading.device.android.version': 'Android version',
    'table.heading.device.enrollment.date': 'Enrolled',
    'table.heading.device.serial': 'Serial number',
    'table.heading.device.publicip': 'IP address',
    'table.heading.device.actions': 'Actions',

    'table.heading.group.name': 'Name',
    'table.heading.group.actions': 'Actions',

    'table.heading.role.name': 'Name',
    'table.heading.role.actions': 'Actions',

    'table.heading.file.name': 'File name',
    'table.heading.file.comment': 'Description',
    'table.heading.file.device.path': 'Path on device',
    'table.heading.file.update.time': 'Updated at',
    'table.heading.file.external': 'External',
    'table.heading.file.variable': 'Variable',
    'table.heading.file.remove': 'Remove',
    'table.heading.file.remove.hint': 'Forces the file removal from the device storage',
    'table.heading.file.path': 'Path',
    'table.heading.file.address': 'Address',
    'table.heading.file.size': 'Size',
    'table.heading.file.actions': 'Actions',

    'table.heading.users.login': 'Login',
    'table.heading.users.name': 'Name',
    'table.heading.users.role': 'Role',
    'table.heading.users.actions': 'Actions',

    'table.heading.common.apps.customer': 'Organization',
    'table.heading.common.apps.pkg': 'Package ID',
    'table.heading.common.apps.name': 'Application Name',
    'table.heading.common.apps.version': 'Version',
    'table.heading.common.apps.url': 'URL',
    'table.heading.common.apps.label': 'Icon',
    'table.heading.common.apps.actions': 'Actions',

    'notfound.devices': 'There are no devices to display.',
    'notfound.files':' The file list is empty.',
    'notfound.configurations': 'No configurations were found.',
    'notfound.customers': 'Organizations not found.',
    'notfound.common.apps': 'There are no applications to display.',
    'notfound.applications': 'Applications not found',
    'notfound.groups':' No groups found. Try a different query.',
    'notfound.users':' Users not found. Try a different query.',
    'notfound.apps.for.display': 'There are no applications to display.',
    'notfound.app.versions.for.display': 'There are no versions to display.',
    'notfound.roles':'The role list is empty.',
    'notfound.icons':'The icon list is empty.',

    'format.date.header': 'HH:mm dd/MM/yyyy',

    'menu.about': 'About',
    'menu.profile': 'Profile',
    'menu.panel.master': 'Master Panel',
    'menu.panel.main': 'Main panel',
    'menu.logout': 'Log out',
    'menu.functions': 'Functions',
    'menu.settings': 'Settings',
    'menu.show.hints': 'Show hints',

    'plugin.name.not.specified': '<< The function name is not specified >>',

    'breadcrumb.summary': 'Summary',
    'breadcrumb.devices': 'Devices',
    'breadcrumb.applications': 'Applications',
    'breadcrumb.configurations': 'Configurations',
    'breadcrumb.files': 'Files',
    'breadcrumb.default.design': 'Design by default',
    'breadcrumb.common.settings': 'Device Table View',
    'breadcrumb.language.settings': 'Language and Other Settings',
    'breadcrumb.license.settings': 'License',
    'breadcrumb.users': 'Users',
    'breadcrumb.groups': 'Groups',
    'breadcrumb.hints': 'Hints',
    'breadcrumb.plugins': 'Plugins',
    'breadcrumb.config.details': 'Details',
    'breadcrumb.application.versions': 'Versions',

    'app.name': 'Headwind MDM',
    'app.vendor.name':"h-mdm.com",
    'app.vendor.link':"https://h-mdm.com",
    'app.description': 'is an open source mobile device management system',
    'app.title': '${appName} Web Panel',

    'box.show.my.apps.only': 'Display my applications only',
    'configuration.app.version.upgrade.message': 'Installed version ${installedVersion}, available version ${latestVersion}',

    'about.line.1': '${appName} control panel',
    'about.line.2': 'Open source MDM for Android',
    'about.line.3': 'Version ${versionNumber}',
    'about.line.4': 'Installed plugins',

    'common.app.clarification': 'This application is public and not available for editing. To add another version of this app, please contact the administrator.',

    'qrcode.help.line1': 'To setup the Android device (version 7 or higher) in a managed (corporate) mode:',
    'qrcode.help.line2': 'Reset the device to factory settings',
    'qrcode.help.line3': 'Tap 7 times on any place of the start screen (you must enter a hidden QR code scanning mode)',
    'qrcode.help.line4': 'Follow the device instructions: accept the terms, connect to Wi-Fi, scan this QR-code',
    'qrcode.help.line5': 'The QR code may contain the device ID for ${appName} (so you don\'t need to enter it on a mobile device). To embed the device ID into the QR code, enter the device ID on this screen and click "Renew".',

    'form.configuration.app.version.select.select.title': 'Select the version to install',
    'form.configuration.app.version.select.version.check.off': 'Disable version checking',
    'form.configuration.app.version.select.upgrade.warning': 'Upgrade application "${v1}" to version "${v3}" for configuration "${v2}"?',
    'form.configuration.app.version.select.downgrade.warning': 'Downgrade version DELETE ALL THESE APPLICATIONS on all devices! Downgrade the application version "${v1}" to version "${v2}"? ',

    'hint.step.1': 'Click here to start the device enrollment',
    'hint.step.2': 'Click here to open the QR code',
    'hint.step.3': 'Click here to see how to open the QR code scanner on the device',
    'hint.step.4': 'Find an available device ID in the «Devices» tab. Click «Renew» to include it in the QR code.',

    'ie.browser.notice.1': 'Unfortunately, Internet Explorer is not supported.',
    'ie.browser.notice.2': 'Recommended browser for using ${appName} - <a href="https://support.google.com/chrome/answer/95346?co=GENIE.Platform%3DDesktop">Chrome</a>.',

    'form.resolved.duplicate.pkg.text1': 'Package ID "${pkg}" is already used by the applications listed below.',
    'form.resolved.duplicate.pkg.text2': 'Do you want to add a new application or a new version of an existing application?',
    'form.resolved.duplicate.pkg.text3': 'New version for',
    'form.resolved.duplicate.pkg.text4': 'Package ID "${pkg}" is already used by applications ${apps}',
    'form.resolved.duplicate.pkg.text5': 'Are you sure you want to change the package ID?',

    'tooltip.usage.byconfigurations': 'Used by configurations',
    'tooltip.usage.byapps': 'Used by applications',
    'tooltip.usage.byicons': 'Used by icons',

    'form.devices.label.params.more': 'More parameters',
    'form.devices.label.params.less': 'Less parameters',
    'form.devices.label.installation.status': 'Installation status',
    "format.devices.date.createTime": "dd/MM/yyyy HH:mm:ss",
    "format.devices.date.datePicker": "dd-MM-yyyy",
    'form.devices.fast.search': 'Fast search by number',

    'form.devices.selection.install.status.default': 'Installation status ...',
    'form.devices.selection.install.status.all': 'All',
    'form.devices.selection.install.status.success': 'Success',
    'form.devices.selection.install.status.version.mismatch': 'Version Mismatch',
    'form.devices.selection.install.status.failure': 'Failure',
    'form.devices.selection.imei.changed': 'IMEI recently changed',

    'search.placeholder.launcher.version': 'Launcher Version',
    'error.date.range.invalid': 'Invalid date interval',

    'form.selection.status.any': 'Any value',
    'form.selection.status.all': 'All',
    'form.selection.status.yes': 'Yes',
    'form.selection.status.no': 'No',

    'form.devices.selection.status': 'Status ...',
    'form.devices.selection.online': 'Online',
    'form.devices.selection.offline': 'Offline',
    'form.devices.selection.number': 'Enter a number',

    'form.devices.selection.online.status.custom': 'Enter time',
    'form.devices.selection.online.status.1': '15 minutes',
    'form.devices.selection.online.status.2': '30 minutes',
    'form.devices.selection.online.status.3': '1 hour',
    'form.devices.selection.online.status.4': '2 hours',
    'form.devices.selection.online.status.5': '6 hours',
    'form.devices.selection.online.status.6': '1 day',
    'form.devices.selection.online.status.7': '2 days',
    'form.devices.selection.online.status.8': '3 days',
    'form.devices.selection.online.status.9': '1 week',
    'form.devices.selection.online.status.10': '1 month',

    'form.devices.selection.online.status.label': 'minute(s)',
    'form.devices.status.ago': 'ago',
    'form.devices.status.minutes': 'm',
    'form.devices.status.hours': 'h',
    'form.devices.status.days': 'd',
    'form.devices.status.weeks': 'week(s)',
    'form.devices.status.months': 'mon',
    'form.devices.status.years': 'year(s)',

    'customer.type.demo': 'Demo',
    'customer.type.small': 'Professional',
    'customer.type.corporate': 'Enterprise',
    'customer.type.master': 'Primary',

    'customer.type.options.all': 'All types',
    'customer.status.options.all': 'All statuses',

    'account.expiring': 'Your account will be expired in ${days} days. Please contact the seller to renew your account.',
    'account.expired.short': 'Your account has expired!',
    'account.expired': 'Your account has expired. Please contact the seller to renew your account.',
    'device.limit.achieved': 'Cannot add a device because you have reached your limit. Please remove some devices or contact the seller to extend your device limit.',

    'menu.updates': 'Check for updates',
    'updates.title': 'Updates',
    'updates.disabled.custom': 'Custom version, please update manually',
    'updates.disabled.not_master': 'Ask the hosting provider to update',
    'updates.disabled.multiple': 'Multiple app versions, please update manually',
    'updates.disabled.error': 'Internal server error',
    'updates.disabled.download': 'Error downloading an update',
    'updates.application': 'Application',
    'updates.current.version': 'Current version',
    'updates.available.version': 'Available version',
    'updates.downloaded': 'Downloaded',
    'updates.auto.update': 'Automatically update mobile apps (use with care in production!)',
    'updates.enable.stats': 'Send usage statistics to the service provider to improve system performance',
    'updates.get': 'Get updates',
    'updates.checking': 'Checking for updates...',
    'updates.getting': 'Getting updates...',
    'updates.success': 'Update completed',
    'updates.web.hint': 'To complete the web app update, run the shell script "/opt/hmdm/update-web-app.sh" in the SSH console',

    'permission.edit_device_app_settings': 'Manage device-specific app settngs',
    'permission.plugins_customer_access_management': 'Manage available plugins',
    'permission.plugin_audit_access': 'View the audit log',
    'permission.plugin_contacts_access': 'Manage contacts',
    'permission.plugin_deviceexport_access': 'Export devices',
    'permission.plugin_deviceimport_access': 'Import devices',
    'permission.plugin_deviceinfo_access': 'View device detailed information',
    'permission.plugin_devicelocations_access': 'View devices on map',
    'permission.plugin_devicelocations_settings_access': 'Configure the map plugin',
    'permission.plugin_devicelog_access': 'View device logs',
    'permission.plugin_devicereset_access': 'Reset and reboot devices',
    'permission.plugin_licensing_access': 'Access to the license (deprecated)',
    'permission.plugin_messaging_send': 'Send messages',
    'permission.plugin_messaging_delete': 'Delete sent messages',
    'permission.plugin_photo_remove_photo': 'Delete photos',
    'permission.settings': 'Manage settings',
    'permission.configurations': 'View configurations',
    'permission.edit_devices': 'Edit device info',
    'permission.edit_device_desc': 'Edit device description',
    'permission.enroll_devices': 'Enroll devices by QR code',
    'permission.plugin_apuppet_access': 'Remote control',
    'permission.plugin_knox_access': 'Knox plugin',
    'permission.add_config': 'Add configurations',
    'permission.copy_config': 'Duplicate configurations',
    'permission.plugin_openvpn_access': 'OpenVPN plugin',
    'permission.plugin_photo_access': 'Photo plugin',
    'permission.push_api': 'Access to Push API',
    'permission.plugin_urlfilter_access': 'URL filtering',
    'permission.plugin_push_send': 'Send Push messages',
    'permission.plugin_push_delete': 'Delete Push messages',
    'permission.get_updates': 'Check for updates',
    'permission.plugin_xtra_access': 'Request for Premium version',
    'permission.applications': 'View applications',
    'permission.edit_applications': 'Manage applications',
    'permission.edit_application_versions': 'Manage application versions',
    'permission.files': 'View files',
    'permission.edit_files': 'Manage files',

    'yes': 'yes',
    'no': 'no'
};
