/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.google.common.io.Files;
import com.hmdm.persistence.ApplicationDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.ApplicationVersion;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.APKFileDetails;
import com.hmdm.rest.json.ApplicationVersionConfigurationLink;
import com.hmdm.rest.json.CheckUpdatesResponse;
import com.hmdm.rest.json.LinkConfigurationsToAppVersionRequest;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.UpdateEntry;
import com.hmdm.rest.json.UpdateRequest;
import com.hmdm.security.SecurityContext;
import com.hmdm.util.APKFileAnalyzer;
import com.hmdm.util.ApplicationUtil;
import com.hmdm.util.FileUtil;
import com.hmdm.util.StatsSender;
import com.hmdm.util.UpdateSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/private/update")
public class UpdateResource {
    private String baseUrl;
    private String filesDirectory;
    private String protocol;
    private String customerDomain;
    private ApplicationDAO applicationDAO;
    private UnsecureDAO unsecureDAO;
    private StatsSender statsSender;
    private APKFileAnalyzer apkFileAnalyzer;
    private boolean sendStatsDefault;
    private static final Logger logger = LoggerFactory.getLogger(UpdateResource.class);
    private static final String WEB_MANIFEST_FILE_NAME = "hmdm_web_update_manifest.txt";

    public UpdateResource() {
    }

    @Inject
    public UpdateResource(@Named(value="files.directory") String filesDirectory, @Named(value="base.url") String baseUrl, @Named(value="updates.send.stats.default") String sendStatsDefaultStr, ApplicationDAO applicationDAO, UnsecureDAO unsecureDAO, StatsSender statsSender, APKFileAnalyzer apkFileAnalyzer) {
        this.filesDirectory = filesDirectory;
        this.baseUrl = baseUrl;
        this.sendStatsDefault = sendStatsDefaultStr != null && !sendStatsDefaultStr.trim().isEmpty() && !sendStatsDefaultStr.startsWith("${") ? Boolean.parseBoolean(sendStatsDefaultStr) : true;
        this.applicationDAO = applicationDAO;
        this.unsecureDAO = unsecureDAO;
        this.statsSender = statsSender;
        this.apkFileAnalyzer = apkFileAnalyzer;
        try {
            URL url = new URL(baseUrl);
            this.protocol = url.getProtocol();
            this.customerDomain = url.getHost();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/check")
    public Response checkUpdates() {
        String manifestStr = null;
        try {
            if (!this.unsecureDAO.isSingleCustomer() && !SecurityContext.get().isSuperAdmin()) {
                throw new SecurityException("Only superadmin can check for updates");
            }
            URL url = new URL(UpdateSettings.MANIFEST_URL.replace("CUSTOMER_DOMAIN", this.customerDomain));
            logger.info("Checking for update: " + url.toString());
            manifestStr = FileUtil.downloadTextFile((URL)url);
            JSONArray array = new JSONArray(manifestStr);
            LinkedList<UpdateEntry> allUpdates = new LinkedList<UpdateEntry>();
            int i = 0;
            while (i < array.length()) {
                UpdateEntry updateEntry = new UpdateEntry(array.getJSONObject(i));
                if (updateEntry.getPkg().equals("web")) {
                    this.processWebAppEntry(updateEntry);
                    allUpdates.add(updateEntry);
                } else if (updateEntry.getPkg().equals("com.hmdm.launcher")) {
                    this.processLauncherAppEntry(updateEntry);
                    allUpdates.add(updateEntry);
                } else if (this.processMobileAppEntry(updateEntry)) {
                    logger.info("Secondary APK: " + updateEntry.getUrl());
                    allUpdates.add(updateEntry);
                }
                ++i;
            }
            CheckUpdatesResponse checkResponse = new CheckUpdatesResponse();
            checkResponse.setUpdates(allUpdates);
            checkResponse.setSendStatsDefault(this.sendStatsDefault);
            return Response.OK((Object)checkResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.ERROR();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response downloadUpdates(UpdateRequest request) {
        String webVersion = "";
        for (UpdateEntry app : request.getUpdates()) {
            if (app.getPkg().equals("web")) {
                webVersion = app.getCurrentVersion();
            }
            if (!app.isOutdated() || app.isUpdateDisabled()) continue;
            if (!app.isDownloaded()) {
                if (app.getPkg().equals("web")) {
                    if (!this.downloadWebApp(app)) {
                        app.setUpdateDisabled(true);
                        app.setUpdateDisableReason("download");
                        continue;
                    }
                } else if (!this.downloadAPKVersion(app)) {
                    app.setUpdateDisabled(true);
                    app.setUpdateDisableReason("download");
                    continue;
                }
                app.setDownloaded(true);
            }
            if (!request.isUpdate() || app.getPkg().equals("web")) continue;
            this.updateAppInConfig(app);
            app.setCurrentVersion(app.getVersion());
        }
        if (request.isSendStats()) {
            this.statsSender.sendStats(UpdateSettings.STAT_URL, this.protocol, this.customerDomain, webVersion);
        }
        return Response.OK((Object)request.getUpdates());
    }

    private boolean downloadWebApp(UpdateEntry app) {
        InputStream inputStream = null;
        HttpURLConnection conn = null;
        try {
            try {
                URL url = new URL(app.getUrl());
                conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(30000);
                conn.setConnectTimeout(30000);
                conn.setUseCaches(false);
                conn.setAllowUserInteraction(false);
                conn.setRequestMethod("GET");
                if (UpdateSettings.WEB_UPDATE_USERNAME != null && UpdateSettings.WEB_UPDATE_PASSWORD != null) {
                    String userCredentials = String.valueOf(UpdateSettings.WEB_UPDATE_USERNAME) + ":" + UpdateSettings.WEB_UPDATE_PASSWORD;
                    String basicAuth = "Basic " + new String(Base64.getEncoder().encodeToString(userCredentials.getBytes()));
                    conn.setRequestProperty("Authorization", basicAuth);
                }
                File file = new File(this.filesDirectory, this.getFileNameFromUrl(app.getUrl()));
                inputStream = conn.getInputStream();
                FileUtil.writeToFile((InputStream)conn.getInputStream(), (String)file.getAbsolutePath());
                this.createWebManifest(app);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private boolean downloadAPKVersion(UpdateEntry app) {
        List appList;
        String name;
        block5: {
            block4: {
                try {
                    name = this.getFileNameFromUrl(app.getUrl());
                    if (name.endsWith(".apk") || name.endsWith(".xapk")) break block4;
                    logger.warn("Can't update app - wrong URL; " + app.getUrl());
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            appList = this.applicationDAO.findByPackageId(app.getPkg());
            if (appList.size() == 1) break block5;
            logger.warn("Failed to update app " + app.getPkg() + ": app not exists or multiple app entries");
            return false;
        }
        File tempFile = FileUtil.createTempFile((String)FileUtil.adjustFileName((String)name));
        FileUtil.writeToFile((InputStream)new URL(app.getUrl()).openStream(), (String)tempFile.getAbsolutePath());
        APKFileDetails fileDetails = this.apkFileAnalyzer.analyzeFile(tempFile.getAbsolutePath());
        ApplicationVersion version = new ApplicationVersion();
        version.setFilePath(tempFile.getAbsolutePath());
        version.setApplicationId(((Application)appList.get(0)).getId());
        version.setVersion(fileDetails.getVersion());
        version.setVersionCode(fileDetails.getVersionCode());
        this.applicationDAO.insertApplicationVersion(version);
        return true;
    }

    private void createWebManifest(UpdateEntry app) throws IOException {
        File appFile = new File(this.filesDirectory, this.getFileNameFromUrl(app.getUrl()));
        File manifestFile = new File(this.filesDirectory, WEB_MANIFEST_FILE_NAME);
        if (manifestFile.exists()) {
            manifestFile.delete();
        }
        Files.write((byte[])appFile.getAbsolutePath().getBytes(StandardCharsets.UTF_8), (File)manifestFile);
    }

    private void updateAppInConfig(UpdateEntry app) {
        ApplicationVersion currentVersion = this.applicationDAO.findApplicationVersion(app.getPkg(), app.getCurrentVersion());
        ApplicationVersion newVersion = this.applicationDAO.findApplicationVersion(app.getPkg(), app.getVersion());
        LinkConfigurationsToAppVersionRequest request = new LinkConfigurationsToAppVersionRequest();
        request.setApplicationVersionId(newVersion.getId().intValue());
        List linkList = this.applicationDAO.getApplicationVersionConfigurations(currentVersion.getId());
        for (ApplicationVersionConfigurationLink link : linkList) {
            link.setApplicationVersionId(newVersion.getId().intValue());
        }
        request.setConfigurations(linkList);
        logger.info("Application versions updated by the superadmin through 'Check for updates'");
        this.applicationDAO.updateApplicationVersionConfigurations(request, (User)SecurityContext.get().getCurrentUser().get());
    }

    private void processWebAppEntry(UpdateEntry entry) {
        if (!UpdateSettings.WEB_UPDATE_ENABLED) {
            entry.setUpdateDisabled(true);
            entry.setUpdateDisableReason("custom");
            return;
        }
        entry.setUrl(entry.getUrl().replace("WEB_SUFFIX", UpdateSettings.WEB_SUFFIX));
        logger.info("Web app: " + entry.getUrl());
        File file = new File(this.filesDirectory, this.getFileNameFromUrl(entry.getUrl()));
        entry.setDownloaded(file.exists());
        entry.setName("Web panel");
    }

    private void processLauncherAppEntry(UpdateEntry entry) {
        List appList = this.applicationDAO.findByPackageId(entry.getPkg());
        if (appList.size() != 1) {
            entry.setUpdateDisabled(true);
            if (appList.size() == 0) {
                entry.setUpdateDisableReason("not_master");
            } else {
                entry.setName(((Application)appList.get(0)).getName());
                entry.setUpdateDisableReason("multiple");
            }
            return;
        }
        entry.setName(((Application)appList.get(0)).getName());
        List versions = this.applicationDAO.getApplicationVersions(((Application)appList.get(0)).getId());
        if (versions.size() == 0) {
            entry.setUpdateDisabled(true);
            entry.setUpdateDisableReason("error");
            return;
        }
        ApplicationVersion currentVersion = this.findLatestInstalledVersion(versions);
        if (currentVersion == null) {
            entry.setUpdateDisabled(true);
            entry.setUpdateDisableReason("error");
            return;
        }
        entry.setCurrentVersion(currentVersion.getVersion());
        if (currentVersion.getUrl() == null) {
            entry.setUpdateDisabled(true);
            entry.setUpdateDisableReason("custom");
            return;
        }
        String name = this.getFileNameFromUrl(currentVersion.getUrl());
        if (!name.endsWith(".apk") && !name.endsWith(".xapk")) {
            entry.setUpdateDisabled(true);
            entry.setUpdateDisableReason("custom");
            return;
        }
        String[] parts = (name = name.substring(0, name.length() - 4)).split("-");
        if (parts.length != 3) {
            entry.setUpdateDisabled(true);
            entry.setUpdateDisableReason("custom");
            return;
        }
        if (!(parts[2].equals("os") || parts[2].equals("master") || parts[2].equals("system"))) {
            entry.setUpdateDisabled(true);
            entry.setUpdateDisableReason("custom");
            return;
        }
        entry.setUrl(entry.getUrl().replace("LAUNCHER_SUFFIX", parts[2]));
        logger.info("Launcher APK: " + entry.getUrl());
        File file = new File(this.filesDirectory, this.getFileNameFromUrl(entry.getUrl()));
        entry.setDownloaded(file.exists());
    }

    private boolean processMobileAppEntry(UpdateEntry entry) {
        List appList = this.applicationDAO.findByPackageId(entry.getPkg());
        if (appList.size() != 1) {
            return false;
        }
        List versions = this.applicationDAO.getApplicationVersions(((Application)appList.get(0)).getId());
        if (versions.size() == 0) {
            return false;
        }
        ApplicationVersion installedVersion = this.findLatestInstalledVersion(versions);
        if (installedVersion == null) {
            return false;
        }
        entry.setCurrentVersion(installedVersion.getVersion());
        File file = new File(this.filesDirectory, this.getFileNameFromUrl(entry.getUrl()));
        entry.setDownloaded(file.exists());
        entry.setName(((Application)appList.get(0)).getName());
        return true;
    }

    private ApplicationVersion findLatestVersion(List<ApplicationVersion> versions) {
        return Collections.max(versions, (o1, o2) -> ApplicationUtil.compareVersions((String)o1.getVersion(), (String)o2.getVersion()));
    }

    private ApplicationVersion findLatestInstalledVersion(List<ApplicationVersion> versions) {
        ApplicationVersion result = null;
        for (ApplicationVersion v : versions) {
            if (!v.isDeletionProhibited() || result != null && ApplicationUtil.compareVersions((String)v.getVersion(), (String)result.getVersion()) <= 0) continue;
            result = v;
        }
        return result;
    }

    private String getFileNameFromUrl(String url) {
        int pos = url.lastIndexOf(47);
        return url.substring(pos + 1);
    }
}

