/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.DeviceDAO;
import com.hmdm.persistence.domain.DeviceSummaryRequest;
import com.hmdm.persistence.domain.SummaryConfigItem;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.SummaryResponse;
import com.hmdm.service.DeviceApplicationsStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Summary"}, authorizations={@Authorization(value="Bearer Token")})
@Singleton
@Path(value="/private/summary")
public class SummaryResource {
    private static final Logger log = LoggerFactory.getLogger(SummaryResource.class);
    private DeviceDAO deviceDAO;

    public SummaryResource() {
    }

    @Inject
    public SummaryResource(DeviceDAO deviceDAO) {
        this.deviceDAO = deviceDAO;
    }

    @ApiOperation(value="Get device statistics", notes="Get statistics of device enrollment", response=SummaryResponse.class)
    @GET
    @Path(value="/devices")
    @Produces(value={"application/json"})
    public Response getDeviceStats() {
        SummaryResponse summaryResponse = new SummaryResponse();
        summaryResponse.setInstallSummary(this.deviceDAO.getInstallSummary());
        if (summaryResponse.getInstallSummary() == null) {
            log.error("Failed to get installation statistics!");
            return Response.INTERNAL_ERROR();
        }
        summaryResponse.setStatusSummary(this.deviceDAO.getStatusSummary());
        if (summaryResponse.getStatusSummary() == null) {
            log.error("Failed to get device status statistics!");
            return Response.INTERNAL_ERROR();
        }
        summaryResponse.setDevicesTotal(this.deviceDAO.getTotalDevicesCount());
        summaryResponse.setDevicesEnrolled(this.deviceDAO.countEnrolled(0L).longValue());
        summaryResponse.setDevicesEnrolledLastMonth(this.deviceDAO.countEnrolled(System.currentTimeMillis() - 2592000000L).longValue());
        DeviceSummaryRequest condition = new DeviceSummaryRequest();
        condition.setMinOnlineTime(Long.valueOf(0L));
        List topConfigs = this.deviceDAO.getSummaryByConfig(condition, null);
        summaryResponse.setTopConfigs(new LinkedList());
        for (SummaryConfigItem summaryConfigItem : topConfigs) {
            summaryResponse.getTopConfigs().add(summaryConfigItem.getName());
        }
        long now = System.currentTimeMillis();
        condition.setMaxOnlineTime(Long.valueOf(now - 3600000L));
        List offline = this.deviceDAO.getSummaryByConfig(condition, topConfigs);
        summaryResponse.setStatusOfflineByConfig(new LinkedList());
        for (SummaryConfigItem item : offline) {
            summaryResponse.getStatusOfflineByConfig().add(item.getCounter());
        }
        condition.setMinOnlineTime(Long.valueOf(now - 14400000L));
        condition.setMaxOnlineTime(Long.valueOf(now - 3600000L));
        List idle = this.deviceDAO.getSummaryByConfig(condition, topConfigs);
        summaryResponse.setStatusIdleByConfig(new LinkedList());
        for (SummaryConfigItem item : idle) {
            summaryResponse.getStatusIdleByConfig().add(item.getCounter());
        }
        condition.setMinOnlineTime(Long.valueOf(now - 3600000L));
        condition.setMaxOnlineTime(null);
        List online = this.deviceDAO.getSummaryByConfig(condition, topConfigs);
        summaryResponse.setStatusOnlineByConfig(new LinkedList());
        for (SummaryConfigItem item : online) {
            summaryResponse.getStatusOnlineByConfig().add(item.getCounter());
        }
        condition.setMinOnlineTime(Long.valueOf(0L));
        condition.setMaxOnlineTime(null);
        condition.setAppStatus(DeviceApplicationsStatus.FAILURE);
        List failed = this.deviceDAO.getSummaryByConfig(condition, topConfigs);
        summaryResponse.setAppFailureByConfig(new LinkedList());
        for (SummaryConfigItem item : failed) {
            summaryResponse.getAppFailureByConfig().add(item.getCounter());
        }
        condition.setAppStatus(DeviceApplicationsStatus.VERSION_MISMATCH);
        List mismatch = this.deviceDAO.getSummaryByConfig(condition, topConfigs);
        summaryResponse.setAppMismatchByConfig(new LinkedList());
        for (SummaryConfigItem item : mismatch) {
            summaryResponse.getAppMismatchByConfig().add(item.getCounter());
        }
        condition.setAppStatus(DeviceApplicationsStatus.SUCCESS);
        List success = this.deviceDAO.getSummaryByConfig(condition, topConfigs);
        summaryResponse.setAppSuccessByConfig(new LinkedList());
        for (SummaryConfigItem item : success) {
            summaryResponse.getAppSuccessByConfig().add(item.getCounter());
        }
        summaryResponse.setDevicesEnrolledMonthly(this.deviceDAO.getDevicesEnrolledMonthly());
        return Response.OK((Object)summaryResponse);
    }
}

