/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Application;
import com.hmdm.persistence.domain.ApplicationVersion;
import com.hmdm.persistence.domain.Configuration;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.util.CryptoUtil;
import com.hmdm.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.javase.QRCode;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"QR-code"})
@Singleton
@Path(value="/public/qr")
public class QRCodeResource {
    private static final Logger logger = LoggerFactory.getLogger(QRCodeResource.class);
    private UnsecureDAO unsecureDAO;
    private CustomerDAO customerDAO;
    private String filesDirectory;
    private String baseUrlForQrCode;

    public QRCodeResource() {
    }

    @Inject
    public QRCodeResource(UnsecureDAO unsecureDAO, CustomerDAO customerDAO, @Named(value="files.directory") String filesDirectory, @Named(value="base.url") String baseUrl) throws MalformedURLException {
        this.unsecureDAO = unsecureDAO;
        this.customerDAO = customerDAO;
        this.filesDirectory = filesDirectory;
        URL url = new URL(baseUrl);
        int port = url.getPort();
        this.baseUrlForQrCode = String.valueOf(url.getProtocol()) + "://" + url.getHost() + (port != -1 ? ":" + port : "");
    }

    @ApiOperation(value="Get a JSON", notes="Gets the JSON for the specified configuration.", responseHeaders={@ResponseHeader(name="Content-Type")})
    @ApiResponses(value={@ApiResponse(code=500, message="Internal server error")})
    @GET
    @Path(value="/json/{id}")
    @Produces(value={"application/json"})
    public Response generateJSON(@PathParam(value="id") @ApiParam(value="Configuration ID") String id, @QueryParam(value="deviceId") @ApiParam(value="A device ID") String deviceID, @QueryParam(value="create") @ApiParam(value="Create on demand") String createOnDemand, @QueryParam(value="useId") @ApiParam(value="Which parameter to use as a device ID") String useId, @QueryParam(value="group") @ApiParam(value="Groups to assign when creating a device") List<String> groups, @Context HttpServletRequest req) {
        logger.info("Generating JSON for configuration key: {}", (Object)id);
        try {
            Configuration configuration = this.unsecureDAO.getConfigurationByQRCodeKey(id);
            if (configuration != null) {
                String res = this.generateExtrasBundle(deviceID, createOnDemand, configuration, groups, useId, req.getContextPath());
                return Response.ok((Object)res).build();
            }
            logger.error("Configuration not found for key: {}", (Object)id);
            return Response.serverError().build();
        }
        catch (Exception e) {
            logger.error("Unexpected error while generating the QR-code image", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @ApiOperation(value="Get QR-code", notes="Gets the QR code image for the specified configuration.", responseHeaders={@ResponseHeader(name="Content-Type")})
    @ApiResponses(value={@ApiResponse(code=500, message="Internal server error")})
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/octet-stream"})
    public Response generateQRCode(@PathParam(value="id") @ApiParam(value="Configuration ID") String id, @QueryParam(value="size") @ApiParam(value="A size of the QR-code image") Integer size, @QueryParam(value="deviceId") @ApiParam(value="A device ID") String deviceID, @QueryParam(value="create") @ApiParam(value="Create on demand") String createOnDemand, @QueryParam(value="useId") @ApiParam(value="Which parameter to use as a device ID") String useId, @QueryParam(value="group") @ApiParam(value="Groups to assign when creating a device") List<String> groups, @Context HttpServletRequest req) {
        logger.info("Generating QR-code image for configuration key: {}", (Object)id);
        try {
            Configuration configuration = this.unsecureDAO.getConfigurationByQRCodeKey(id);
            if (configuration != null) {
                Integer mainAppId = configuration.getMainAppId();
                if (mainAppId != null) {
                    ApplicationVersion appVersion = this.unsecureDAO.findApplicationVersionById(mainAppId);
                    if (appVersion != null && appVersion.getUrl() != null && !appVersion.getUrl().trim().isEmpty()) {
                        String sha256;
                        String apkUrl = appVersion.getUrl().replace(" ", "%20");
                        if (appVersion.getApkHash() == null) {
                            sha256 = this.calculateApkHash(apkUrl);
                            this.unsecureDAO.saveApkFileHash(appVersion.getId(), sha256);
                        } else {
                            sha256 = appVersion.getApkHash();
                        }
                        Application appMain = this.unsecureDAO.findApplicationById(appVersion.getApplicationId());
                        String wifiSsidEntry = "";
                        if (configuration.getWifiSSID() != null && !configuration.getWifiSSID().trim().isEmpty()) {
                            String wifiSecurityType = configuration.getWifiSecurityType();
                            if (wifiSecurityType == null || wifiSecurityType.isEmpty()) {
                                wifiSecurityType = "WPA";
                            }
                            wifiSsidEntry = "\"android.app.extra.PROVISIONING_WIFI_SSID\":" + JSONObject.quote((String)configuration.getWifiSSID().trim()) + ",\n" + "\"android.app.extra.PROVISIONING_WIFI_SECURITY_TYPE\":\"" + wifiSecurityType + "\",\n";
                        }
                        String wifiPasswordEntry = "";
                        if (configuration.getWifiPassword() != null && !configuration.getWifiPassword().trim().isEmpty()) {
                            wifiPasswordEntry = "\"android.app.extra.PROVISIONING_WIFI_PASSWORD\":" + JSONObject.quote((String)configuration.getWifiPassword().trim()) + ",\n";
                        }
                        String mobileEnrollmentEntry = "";
                        if (configuration.isMobileEnrollment()) {
                            mobileEnrollmentEntry = "\"android.app.extra.PROVISIONING_USE_MOBILE_DATA\":true,\n";
                        }
                        String miscQrParametersEntry = "";
                        if (configuration.getQrParameters() != null && !(miscQrParametersEntry = configuration.getQrParameters().trim()).equals("")) {
                            if (!miscQrParametersEntry.endsWith(",")) {
                                miscQrParametersEntry = String.valueOf(miscQrParametersEntry) + ",";
                            }
                            miscQrParametersEntry = String.valueOf(miscQrParametersEntry) + "\n";
                        }
                        StringBuffer sb = new StringBuffer("{\n\"android.app.extra.PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME\":\"" + appMain.getPkg() + "/" + configuration.getEventReceivingComponent() + "\",\n" + "\"android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION\":" + JSONObject.quote((String)apkUrl) + ",\n" + "\"android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM\":\"" + sha256 + "\",\n" + wifiSsidEntry + wifiPasswordEntry + mobileEnrollmentEntry + "\"android.app.extra.PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED\":true,\n");
                        if (!configuration.isEncryptDevice()) {
                            sb.append("\"android.app.extra.PROVISIONING_SKIP_ENCRYPTION\":true,\n");
                        }
                        sb.append(String.valueOf(miscQrParametersEntry) + "\"android.app.extra.PROVISIONING_ADMIN_EXTRAS_BUNDLE\": " + this.generateExtrasBundle(deviceID, createOnDemand, configuration, groups, useId, req.getContextPath()) + "}\n");
                        String s = sb.toString();
                        logger.info("The base for QR code generation:\n{}", (Object)s);
                        return Response.ok(output -> {
                            int imageSize = 250;
                            if (size != null) {
                                imageSize = size;
                            }
                            try {
                                QRCode.from((String)s).to(ImageType.PNG).withSize(imageSize, imageSize).writeTo(output);
                                output.flush();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }).header("Cache-Control", (Object)"no-cache").header("Content-Type", (Object)"image/png").build();
                    }
                    logger.info("Main app for configuration for QR-code key {} does not have URL set", (Object)id);
                } else {
                    logger.info("Configuration for QR-code key {} does not have a main app set", (Object)id);
                }
            } else {
                logger.info("Configuration not found for QR-code key: {}", (Object)id);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            logger.error("Unexpected error while generating the QR-code image", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private String calculateApkHash(String apkUrl) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest;
        block22: {
            Object urlPath;
            logger.info("Digesting the application file: {}", (Object)apkUrl);
            digest = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[8192];
            URL url = new URL(apkUrl);
            if (apkUrl.startsWith(String.valueOf(this.baseUrlForQrCode) + "/files/")) {
                urlPath = url.getPath();
                int index22 = ((String)urlPath).indexOf("/files/", 0) + "/files/".length();
                String path = ((String)urlPath).substring(index22);
                File file = new File(String.format("%s/%s", this.filesDirectory, path));
                if (file.exists()) {
                    Throwable throwable = null;
                    Object var11_16 = null;
                    try (FileInputStream input = new FileInputStream(file);){
                        int count;
                        while ((count = ((InputStream)input).read(buffer)) > 0) {
                            digest.update(buffer, 0, count);
                        }
                        break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                throw new FileNotFoundException();
            }
            urlPath = null;
            Object index22 = null;
            try (BufferedInputStream bis = new BufferedInputStream(url.openStream());){
                int count;
                while ((count = bis.read(buffer)) > 0) {
                    digest.update(buffer, 0, count);
                }
            }
            catch (Throwable index22) {
                if (urlPath == null) {
                    urlPath = index22;
                } else if (urlPath != index22) {
                    ((Throwable)urlPath).addSuppressed(index22);
                }
                throw urlPath;
            }
        }
        byte[] hash = digest.digest();
        String sha256 = CryptoUtil.getBase64String((byte[])hash);
        logger.info("Finished digesting the application file: {}. Hash: {}", (Object)apkUrl, (Object)sha256);
        return sha256;
    }

    private String generateExtrasBundle(String deviceID, String createOnDemand, Configuration configuration, List<String> groups, String useId, String contextPath) {
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        String deviceIdEntry = "";
        if (deviceID != null && !deviceID.trim().isEmpty()) {
            deviceID = deviceID.trim();
            deviceIdEntry = "\"com.hmdm.DEVICE_ID\":\"" + deviceID + "\",";
        }
        String configurationEntry = "";
        String customerEntry = "";
        if (createOnDemand != null && createOnDemand.equals("1")) {
            configurationEntry = "\"com.hmdm.CONFIG\":\"" + Integer.toString(configuration.getId()) + "\",\n";
            if (!this.unsecureDAO.isSingleCustomer()) {
                Customer customer = this.customerDAO.findById(configuration.getCustomerId());
                customerEntry = "\"com.hmdm.CUSTOMER\":\"" + StringUtil.jsonEscape((String)customer.getName()) + "\",\n";
            }
        }
        String groupEntry = "";
        if (groups != null && groups.size() > 0) {
            groupEntry = "\"com.hmdm.GROUP\":\"";
            boolean needComma = false;
            for (String group : groups) {
                if (needComma) {
                    groupEntry = String.valueOf(groupEntry) + ",";
                } else {
                    needComma = true;
                }
                groupEntry = String.valueOf(groupEntry) + group;
            }
            groupEntry = String.valueOf(groupEntry) + "\",\n";
        }
        String useIdEntry = "";
        if (useId != null) {
            useIdEntry = "\"com.hmdm.DEVICE_ID_USE\":\"" + StringUtil.jsonEscape((String)useId) + "\",\n";
        }
        String bundle = "{" + deviceIdEntry + configurationEntry + customerEntry + useIdEntry + groupEntry + "\"com.hmdm.BASE_URL\":\"" + this.baseUrlForQrCode + "\",\n" + "\"com.hmdm.SERVER_PROJECT\":\"" + contextPath + "\"" + "}\n";
        return bundle;
    }
}

