/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.notification.PushService;
import com.hmdm.notification.persistence.domain.PushMessage;
import com.hmdm.persistence.DeviceDAO;
import com.hmdm.persistence.GroupDAO;
import com.hmdm.persistence.domain.Device;
import com.hmdm.persistence.domain.DeviceSearchRequest;
import com.hmdm.persistence.domain.Group;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.PushRequest;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import com.hmdm.security.SecurityException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Push API"})
@Path(value="/private/push")
@Singleton
public class PushApiResource {
    private static final Logger logger = LoggerFactory.getLogger(PushApiResource.class);
    private PushService pushService;
    private DeviceDAO deviceDAO;
    private GroupDAO groupDAO;

    public PushApiResource() {
    }

    @Inject
    public PushApiResource(PushService pushService, DeviceDAO deviceDAO, GroupDAO groupDAO) {
        this.pushService = pushService;
        this.deviceDAO = deviceDAO;
        this.groupDAO = groupDAO;
    }

    private DeviceSearchRequest initDsr() {
        DeviceSearchRequest dsr = new DeviceSearchRequest();
        dsr.setPageSize(1000000);
        dsr.setCustomerId(((Integer)SecurityContext.get().getCurrentCustomerId().get()).intValue());
        dsr.setUserId(((User)SecurityContext.get().getCurrentUser().get()).getId().intValue());
        return dsr;
    }

    private void createPushMessages(DeviceSearchRequest dsr, String messageType, String payload, List<PushMessage> messages) {
        List devices = this.deviceDAO.getAllDevices(dsr).getItems();
        for (Device device : devices) {
            PushMessage pushMessage = new PushMessage(messageType, payload, device.getId().intValue());
            messages.add(pushMessage);
        }
    }

    @ApiOperation(value="Send a Push message", notes="Sends a Push message to specified devices.", authorizations={@Authorization(value="Bearer Token")})
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response sendPush(PushRequest pushRequest) {
        boolean canSendMessages = SecurityContext.get().hasPermission("push_api");
        if (!canSendMessages) {
            logger.error("Unauthorized attempt to send a message", (Throwable)SecurityException.onCustomerDataAccessViolation((int)0, (String)"message"));
            return Response.PERMISSION_DENIED();
        }
        LinkedList<PushMessage> messages = new LinkedList<PushMessage>();
        if (pushRequest.getBroadcast() != null && pushRequest.getBroadcast().booleanValue()) {
            DeviceSearchRequest dsr = this.initDsr();
            this.createPushMessages(dsr, pushRequest.getMessageType(), pushRequest.getPayload(), messages);
        } else {
            if (pushRequest.getGroups() != null) {
                for (String groupName : pushRequest.getGroups()) {
                    Group group = this.groupDAO.getGroupByName(groupName);
                    if (group != null) {
                        DeviceSearchRequest dsr = this.initDsr();
                        dsr.setGroupId(group.getId());
                        this.createPushMessages(dsr, pushRequest.getMessageType(), pushRequest.getPayload(), messages);
                        continue;
                    }
                    logger.warn("Failed to send Push message to group '" + groupName + "': group not found");
                }
            }
            if (pushRequest.getDeviceNumbers() != null) {
                for (String deviceNumber : pushRequest.getDeviceNumbers()) {
                    Device device = this.deviceDAO.getDeviceByNumber(deviceNumber);
                    if (device != null) {
                        PushMessage pushMessage = new PushMessage(pushRequest.getMessageType(), pushRequest.getPayload(), device.getId().intValue());
                        messages.add(pushMessage);
                        continue;
                    }
                    logger.warn("Failed to send Push message to device '" + deviceNumber + "': device not found");
                }
            }
        }
        String logString = "Push message type '" + pushRequest.getMessageType() + "', payload '" + pushRequest.getPayload() + "' is sent to device ids: ";
        String logDevices = "";
        if (messages.size() > 0) {
            for (PushMessage pushMessage : messages) {
                if (logDevices.length() > 0) {
                    logDevices = String.valueOf(logDevices) + ",";
                }
                logDevices = String.valueOf(logDevices) + pushMessage.getDeviceId();
                this.pushService.send(pushMessage);
            }
            logger.debug(String.valueOf(logString) + logDevices);
        } else {
            logger.warn("Empty set of target devices, Push message is not sent");
        }
        return Response.OK();
    }
}

