/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.UploadedFileDAO;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.UploadedFile;
import com.hmdm.rest.json.FileUploadResult;
import com.hmdm.rest.json.Response;
import com.hmdm.security.SecurityContext;
import com.hmdm.security.SecurityException;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/private/icon-files")
public class IconFileResource {
    private static final Logger logger = LoggerFactory.getLogger(IconFileResource.class);
    private static final String DELIMITER = "1111111";
    private UploadedFileDAO uploadedFileDAO;
    private CustomerDAO customerDAO;
    private String filesDirectory;

    @Inject
    public IconFileResource(UploadedFileDAO uploadedFileDAO, CustomerDAO customerDAO, @Named(value="files.directory") String filesDirectory) {
        this.uploadedFileDAO = uploadedFileDAO;
        this.customerDAO = customerDAO;
        this.filesDirectory = filesDirectory;
    }

    @ApiOperation(value="Upload icon", notes="Uploads the icon to server. Returns a path to uploaded icon file", response=FileUploadResult.class)
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response uploadIconFile(@FormDataParam(value="file") InputStream uploadedInputStream, @ApiParam(value="An icon file to upload") @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws Exception {
        try {
            BufferedImage img = ImageIO.read(uploadedInputStream);
            if (img.getWidth() != img.getHeight()) {
                logger.error("Rejecting the icon file {} upload due to unequal icon width and height", (Object)fileDetail.getFileName());
                return Response.ERROR((String)"error.icon.dimension.invalid");
            }
            return SecurityContext.get().getCurrentCustomerId().map(customerId -> {
                try {
                    Customer customer = this.customerDAO.findById(customerId.intValue());
                    String customerFilesDir = customer.getFilesDir();
                    File customerFilesDirectory = new File(this.filesDirectory, customerFilesDir);
                    if (!customerFilesDirectory.exists()) {
                        customerFilesDirectory.mkdirs();
                    }
                    File iconFile = new File(customerFilesDirectory, String.valueOf(UUID.randomUUID().toString()) + ".png");
                    BufferedImage scaledImage = Scalr.resize((BufferedImage)img, (int)144, (BufferedImageOp[])new BufferedImageOp[0]);
                    ImageIO.write((RenderedImage)scaledImage, "png", iconFile);
                    UploadedFile uploadedFile = new UploadedFile();
                    uploadedFile.setCustomerId(customerId.intValue());
                    uploadedFile.setFilePath(iconFile.getName());
                    uploadedFile.setUploadTime(Long.valueOf(System.currentTimeMillis()));
                    uploadedFile = this.uploadedFileDAO.insert(uploadedFile);
                    return Response.OK((Object)uploadedFile);
                }
                catch (Exception e) {
                    logger.error("Unexpected error when handling icon file upload", (Throwable)e);
                    return Response.INTERNAL_ERROR();
                }
            }).orElseThrow(SecurityException::onAnonymousAccess);
        }
        catch (Exception e) {
            logger.error("Unexpected error when handling icon file upload", (Throwable)e);
            return Response.INTERNAL_ERROR();
        }
    }
}

