/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.resource;

import com.hmdm.auth.HmdmAuthInterface;
import com.hmdm.persistence.CustomerDAO;
import com.hmdm.persistence.UnsecureDAO;
import com.hmdm.persistence.domain.Settings;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.AuthOptionsResponse;
import com.hmdm.rest.json.Response;
import com.hmdm.rest.json.UserCredentials;
import com.hmdm.rest.json.view.user.UserView;
import com.hmdm.service.EmailService;
import com.hmdm.service.RsaKeyService;
import com.hmdm.util.BackgroundTaskRunnerService;
import com.hmdm.util.PasswordUtil;
import java.security.PublicKey;
import java.util.Base64;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Singleton
@Path(value="/public/auth")
public class AuthResource {
    private UnsecureDAO userDAO;
    private CustomerDAO customerDAO;
    private UnsecureDAO settingsDAO;
    private BackgroundTaskRunnerService taskRunner;
    private boolean customerSignup;
    private EmailService emailService;
    private RsaKeyService rsaKeyService;
    private boolean transmitPassword;
    private HmdmAuthInterface authEngine;

    public AuthResource() {
    }

    @Inject
    public AuthResource(UnsecureDAO userDAO, CustomerDAO customerDAO, UnsecureDAO settingsDAO, BackgroundTaskRunnerService taskRunner, EmailService emailService, RsaKeyService rsaKeyService, @Named(value="customer.signup") boolean customerSignup, @Named(value="transmit.password") boolean transmitPassword, @Named(value="auth.class") HmdmAuthInterface authEngine) {
        this.userDAO = userDAO;
        this.customerDAO = customerDAO;
        this.settingsDAO = settingsDAO;
        this.taskRunner = taskRunner;
        this.emailService = emailService;
        this.rsaKeyService = rsaKeyService;
        this.customerSignup = customerSignup;
        this.transmitPassword = transmitPassword;
        this.authEngine = authEngine;
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response login(UserCredentials credentials, @Context HttpServletRequest req) throws InterruptedException {
        if (credentials.getLogin() == null || credentials.getPassword() == null) {
            return Response.ERROR();
        }
        User user = this.authEngine.findUser(credentials.getLogin());
        if (user == null) {
            Thread.sleep(1000L);
            return Response.ERROR();
        }
        if (user.getLastLoginFail() > System.currentTimeMillis() - 1000L) {
            return Response.ERROR();
        }
        String password = null;
        if (this.transmitPassword) {
            byte[] passEnc = Base64.getDecoder().decode(credentials.getPassword());
            password = this.rsaKeyService.decrypt(passEnc);
        } else {
            password = credentials.getPassword();
        }
        if (!this.authEngine.authenticate(user, password)) {
            Thread.sleep(1000L);
            return Response.ERROR();
        }
        try {
            this.taskRunner.submitTask(() -> this.customerDAO.recordLastLoginTime(user.getCustomerId(), System.currentTimeMillis()));
            HttpSession userSession = req.getSession();
            userSession.setAttribute("credentials", (Object)user);
            Settings settings = this.settingsDAO.getSettings(user.getCustomerId());
            if (settings != null) {
                if (settings.isTwoFactor()) {
                    userSession.setAttribute("twofactor", (Object)"true");
                    user.setTwoFactor(true);
                }
                user.setIdleLogout(settings.getIdleLogout());
            }
            if (user.getAuthToken() == null || user.getAuthToken().length() == 0) {
                user.setAuthToken(PasswordUtil.generateToken());
                user.setNewPassword(user.getPassword());
                this.userDAO.setUserNewPasswordUnsecure(user);
            }
            user.setPassword(null);
            user.setSingleCustomer(this.userDAO.isSingleCustomer());
            return Response.OK((Object)new UserView(user));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.INTERNAL_ERROR();
        }
    }

    @POST
    @Path(value="/logout")
    public void logout(@Context HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    @GET
    @Path(value="/options")
    public Response options() {
        AuthOptionsResponse response = new AuthOptionsResponse();
        response.setSignup(this.emailService.isConfigured() && this.customerSignup);
        response.setRecover(this.emailService.isConfigured());
        if (this.transmitPassword) {
            PublicKey publicKey = this.rsaKeyService.getPublicKey();
            byte[] keyBytes = publicKey.getEncoded();
            String encoded = Base64.getEncoder().encodeToString(keyBytes);
            response.setPublicKey(encoded);
        }
        return Response.OK((Object)response);
    }
}

