/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.hmdm.persistence.domain.User;
import com.hmdm.rest.json.LookupItem;
import com.hmdm.rest.json.view.user.UserRoleView;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserView {
    private final User user;

    public UserView(User user) {
        this.user = user;
    }

    public Integer getId() {
        return this.user.getId();
    }

    public String getLogin() {
        return this.user.getLogin();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public String getName() {
        return this.user.getName();
    }

    public int getCustomerId() {
        return this.user.getCustomerId();
    }

    public boolean isMasterCustomer() {
        return this.user.isMasterCustomer();
    }

    public boolean isEditable() {
        return this.user.isEditable();
    }

    public boolean isSingleCustomer() {
        return this.user.isSingleCustomer();
    }

    public UserRoleView getUserRole() {
        return new UserRoleView(this.user.getUserRole());
    }

    public boolean isSuperAdmin() {
        return this.user.getUserRole().isSuperAdmin();
    }

    public boolean isAllDevicesAvailable() {
        return this.user.isAllDevicesAvailable();
    }

    public boolean isAllConfigAvailable() {
        return this.user.isAllConfigAvailable();
    }

    public boolean isPasswordReset() {
        return this.user.isPasswordReset();
    }

    public String getAuthToken() {
        return this.user.getAuthToken();
    }

    public String getPasswordResetToken() {
        return this.user.getPasswordResetToken();
    }

    public List<LookupItem> getGroups() {
        return this.user.getGroups();
    }

    public List<LookupItem> getConfigurations() {
        return this.user.getConfigurations();
    }

    public Boolean getTwoFactor() {
        return this.user.isTwoFactor() ? Boolean.valueOf(true) : null;
    }

    public Boolean getTwoFactorAccepted() {
        return this.user.isTwoFactorAccepted() ? Boolean.valueOf(true) : null;
    }

    public Integer getIdleLogout() {
        return this.user.getIdleLogout();
    }
}

